import numpy as np
import pickle

# for alignment
LMARK_REF_ARC = np.array([[38.2946, 51.6963],
                            [73.5318, 51.5014],
                            [56.0252, 71.7366],
                            [41.5493, 92.3655],
                            [70.7299, 92.2041]], dtype=np.float32)


# for landmark - 3ddfa-v2
STD_SIZE = 120
PARAM_MEAN = np.array([ 3.4926363e-04,  2.5279013e-07, -6.8751979e-07,  6.0167957e+01,
       -6.2955132e-07,  5.7572004e-04, -5.0853912e-05,  7.4278198e+01,
        5.4009172e-07,  6.5741384e-05,  3.4420125e-04, -6.6671577e+01,
       -3.4660369e+05, -6.7468234e+04,  4.6822266e+04, -1.5262047e+04,
        4.3505889e+03, -5.4261453e+04, -1.8328033e+04, -1.5843289e+03,
       -8.4566344e+04,  3.8359607e+03, -2.0811361e+04,  3.8094930e+04,
       -1.9967855e+04, -9.2413701e+03, -1.9600715e+04,  1.3168090e+04,
       -5.2591440e+03,  1.8486478e+03, -1.3030662e+04, -2.4355562e+03,
       -2.2542065e+03, -1.4396562e+04, -6.1763291e+03, -2.5621920e+04,
        2.2639447e+02, -6.3261235e+03, -1.0867251e+04,  8.6846509e+02,
       -5.8311479e+03,  2.7051238e+03, -3.6294177e+03,  2.0439901e+03,
       -2.4466162e+03,  3.6586970e+03, -7.6459897e+03, -6.6744526e+03,
        1.1638839e+02,  7.1855972e+03, -1.4294868e+03,  2.6173665e+03,
       -1.2070955e+00,  6.6907924e-01, -1.7760828e-01,  5.6725528e-02,
        3.9678156e-02, -1.3586316e-01, -9.2239931e-02, -1.7260718e-01,
       -1.5804484e-02, -1.4168486e-01], dtype=np.float32)
PARAM_STD = np.array([1.76321526e-04, 6.73794348e-05, 4.47084894e-04, 2.65502319e+01,
       1.23137695e-04, 4.49302170e-05, 7.92367064e-05, 6.98256302e+00,
       4.35044407e-04, 1.23148900e-04, 1.74000015e-04, 2.08030396e+01,
       5.75421125e+05, 2.77649062e+05, 2.58336844e+05, 2.55163125e+05,
       1.50994375e+05, 1.60086109e+05, 1.11277305e+05, 9.73117812e+04,
       1.17198453e+05, 8.93173672e+04, 8.84935547e+04, 7.22299297e+04,
       7.10802109e+04, 5.00139531e+04, 5.59685820e+04, 4.75255039e+04,
       4.95150664e+04, 3.81614805e+04, 4.48720586e+04, 4.62732383e+04,
       3.81167695e+04, 2.81911621e+04, 3.21914375e+04, 3.60061719e+04,
       3.25598926e+04, 2.55511172e+04, 2.42675098e+04, 2.75213984e+04,
       2.31665312e+04, 2.11015762e+04, 1.94123242e+04, 1.94522031e+04,
       1.74549844e+04, 2.25376230e+04, 1.61742812e+04, 1.46716406e+04,
       1.51156885e+04, 1.38700732e+04, 1.37463125e+04, 1.26631338e+04,
       1.58708346e+00, 1.50770092e+00, 5.88135779e-01, 5.88974476e-01,
       2.13278517e-01, 2.63020128e-01, 2.79642940e-01, 3.80302161e-01,
       1.61628410e-01, 2.55969286e-01], dtype=np.float32)
U_BASE = np.array([[-7.35872031e+04],[ 1.85342188e+04],[ 1.77612930e+04],[-7.16355000e+04],
       [-1.23926746e+03],[ 2.01767266e+04],[-6.77558594e+04],[-1.92474238e+04],[ 2.19499492e+04],
       [-6.39095586e+04],[-3.54996289e+04],[ 2.57648320e+04],[-5.84511367e+04],[-5.29795078e+04],
       [ 3.49593359e+04],[-4.86543008e+04],[-6.69758594e+04],[ 5.11847891e+04],[-3.69926758e+04],
       [-7.53740703e+04],[ 7.09580781e+04],[-2.21011914e+04],[-8.23799766e+04],[ 8.91776953e+04],
       [-9.97121124e+01],[-8.63638516e+04],[ 9.62798047e+04],[ 2.19076094e+04],[-8.21290938e+04],
       [ 8.91085859e+04],[ 3.67042969e+04],[-7.54103984e+04],[ 7.09130469e+04],[ 4.82796328e+04],
       [-6.72134297e+04],[ 5.12472109e+04],[ 5.79850000e+04],[-5.34047500e+04],[ 3.50251992e+04],
       [ 6.34462656e+04],[-3.60084414e+04],[ 2.58648359e+04],[ 6.71454609e+04],[-1.96241914e+04],
       [ 2.19214336e+04],[ 7.06891250e+04],[-1.50561914e+03],[ 2.00480488e+04],[ 7.25602891e+04],
       [ 1.84778066e+04],[ 1.79131172e+04],[-5.75137656e+04],[ 4.03013242e+04],[ 8.04721797e+04],
       [-4.92315977e+04],[ 4.66854883e+04],[ 9.24435156e+04],[-3.86623867e+04],[ 4.87914961e+04],
       [ 1.00783859e+05],[-2.85141895e+04],[ 4.78889336e+04],[ 1.05897250e+05],[-1.93453105e+04],
       [ 4.53389336e+04],[ 1.08324586e+05],[ 1.82724023e+04],[ 4.55740859e+04],[ 1.08260852e+05],
       [ 2.74885449e+04],[ 4.81799922e+04],[ 1.05741305e+05],[ 3.76963008e+04],[ 4.91407070e+04],
       [ 1.00549234e+05],[ 4.84490430e+04],[ 4.70097188e+04],[ 9.22795703e+04],[ 5.67314609e+04],
       [ 4.04576250e+04],[ 8.03234141e+04],[-2.60905487e+02],[ 2.63334824e+04],[ 1.11411219e+05],
       [-2.16724335e+02],[ 1.42852705e+04],[ 1.20398492e+05],[-1.10514717e+02],[ 2.28539404e+03],
       [ 1.29726859e+05],[-1.14867363e+02],[-7.99934570e+03],[ 1.31937234e+05],[-1.22622168e+04],
       [-1.69639180e+04],[ 1.09804531e+05],[-7.18394824e+03],[-1.80073809e+04],[ 1.14322297e+05],
       [-2.83630371e+02],[-1.93568770e+04],[ 1.16415719e+05],[ 6.55826123e+03],[-1.79867188e+04],
       [ 1.14289453e+05],[ 1.15820264e+04],[-1.69011914e+04],[ 1.09755766e+05],[-4.35319336e+04],
       [ 2.59349277e+04],[ 8.72518984e+04],[-3.71553867e+04],[ 2.97788887e+04],[ 9.54120547e+04],
       [-2.80870156e+04],[ 2.99009375e+04],[ 9.55950859e+04],[-1.96450605e+04],[ 2.56049590e+04],
       [ 9.31052969e+04],[-2.72607402e+04],[ 2.34987188e+04],[ 9.52987734e+04],[-3.67323672e+04],
       [ 2.30255000e+04],[ 9.30262656e+04],[ 1.83597578e+04],[ 2.56084277e+04],[ 9.27840156e+04],
       [ 2.68588359e+04],[ 3.00101426e+04],[ 9.51868984e+04],[ 3.61512500e+04],[ 2.97651953e+04],
       [ 9.51682344e+04],[ 4.27301250e+04],[ 2.58199121e+04],[ 8.71874844e+04],[ 3.57689453e+04],
       [ 2.31636055e+04],[ 9.29501406e+04],[ 2.61778516e+04],[ 2.34850078e+04],[ 9.51048281e+04],
       [-2.57776289e+04],[-4.12316797e+04],[ 9.92061016e+04],[-1.67560391e+04],[-3.52842891e+04],
       [ 1.10437352e+05],[-5.99480566e+03],[-3.13890684e+04],[ 1.16480539e+05],[-2.64001709e+02],
       [-3.25097559e+04],[ 1.17079453e+05],[ 5.44354541e+03],[-3.13913379e+04],[ 1.16457258e+05],
       [ 1.61491680e+04],[-3.52906836e+04],[ 1.10337359e+05],[ 2.45962793e+04],[-4.12682188e+04],
       [ 9.89942969e+04],[ 1.56132715e+04],[-4.54192422e+04],[ 1.08561773e+05],[ 7.92000928e+03],
       [-4.83141914e+04],[ 1.12856117e+05],[-2.39078278e+02],[-4.88168750e+04],[ 1.13861016e+05],
       [-8.33755957e+03],[-4.82793867e+04],[ 1.13022656e+05],[-1.59420254e+04],[-4.54455469e+04],
       [ 1.08729125e+05],[-2.32469180e+04],[-4.07162812e+04],[ 9.99537266e+04],[-7.67756445e+03],
       [-3.81009766e+04],[ 1.11375852e+05],[-3.79065887e+02],[-3.79130938e+04],[ 1.13163102e+05],
       [ 6.97602539e+03],[-3.81594766e+04],[ 1.11353492e+05],[ 2.29342090e+04],[-4.07978281e+04],
       [ 9.95834531e+04],[ 6.79684863e+03],[-4.05065586e+04],[ 1.11575406e+05],[-4.01142456e+02],
       [-4.08664961e+04],[ 1.12449688e+05],[-7.49982080e+03],[-4.04330664e+04],[ 1.11496352e+05]], dtype=np.float32)
W_SHP_BASE = np.array([[-3.33269918e-03,  1.40211312e-03,  1.95389544e-03,
        -3.18499375e-03, -2.30916217e-03, -4.14184527e-03,
         1.83985772e-04, -4.03534668e-03, -3.27362446e-04,
         2.00419294e-04, -5.33206679e-04,  1.19961053e-03,
        -1.99569180e-03,  3.17660510e-03, -2.61044758e-03,
         5.82478882e-04,  1.86261861e-03, -5.59663400e-03,
         5.41837420e-04, -2.32335343e-03, -2.93749408e-03,
         2.43980042e-03, -3.57449241e-03, -2.97879963e-03,
        -2.66842707e-03,  1.60957687e-03,  3.94054502e-03,
        -2.34814780e-03, -6.36935118e-04,  1.01780891e-03,
        -4.52035572e-03,  6.24745060e-03, -2.56797811e-03,
        -4.35033487e-03, -5.71848033e-03, -1.48044841e-03,
         3.50676819e-05,  2.06305017e-03,  3.52095021e-03,
        -1.04396348e-03],
       [ 2.23639328e-03,  4.39048791e-03, -3.87614523e-03,
        -1.67312205e-03,  1.50226726e-04, -3.27746524e-03,
         7.92055216e-04,  3.76849575e-03,  9.24300984e-04,
        -3.33790039e-03,  1.18842325e-03, -2.56068213e-03,
        -3.77695472e-03,  1.82776013e-03,  1.56639633e-03,
         3.70329595e-03, -1.87927415e-03,  1.66567776e-03,
         5.65631664e-04, -4.22459561e-03, -5.38565160e-04,
         2.73141335e-03, -2.29081954e-03, -9.37429650e-05,
        -1.55658531e-03, -2.90353084e-03,  2.29999726e-03,
         7.95640575e-04, -5.06580807e-04,  4.94779553e-04,
         3.94778268e-04,  6.09845338e-05,  1.46366039e-03,
        -2.16176291e-03,  6.40411105e-04, -3.03642882e-04,
        -1.32747588e-03,  1.60813262e-03, -4.22099466e-03,
        -1.89091091e-03],
       [-3.13180336e-03, -1.16489327e-03, -2.69159069e-03,
         1.59037078e-03,  4.85136267e-03, -2.45818938e-03,
         2.31431681e-03,  4.73826192e-04,  1.39129861e-05,
        -1.62041024e-03, -3.96864314e-04,  3.46794049e-03,
         3.16092931e-03, -5.59579967e-05,  1.66876230e-03,
         1.62646209e-03, -3.42462468e-03, -1.02507009e-03,
         2.44754064e-03, -2.87635555e-03,  1.22977467e-03,
         2.74075055e-03, -4.06093383e-03, -3.01601249e-04,
         3.40036629e-03, -3.21483775e-03, -3.21724336e-03,
         1.78182416e-03, -8.65679758e-04, -1.51266600e-03,
         5.86463779e-04, -6.08456368e-03,  1.13620015e-03,
         4.42833500e-03,  1.86749944e-03, -2.39752908e-03,
        -1.84748118e-04, -2.06412398e-03,  2.68553128e-03,
        -1.44233007e-03],
       [-3.70271574e-03,  1.39300316e-03,  1.89654122e-03,
        -2.87881866e-03, -1.74059265e-03, -2.90546869e-03,
        -9.24324908e-04, -2.26511806e-03,  8.63133610e-05,
         7.58481096e-04,  7.07330939e-04,  1.29155093e-03,
        -4.55672824e-04,  9.25273227e-04, -1.82427361e-03,
         1.66588475e-03,  3.19001003e-04, -5.08870138e-03,
         1.34759571e-03, -2.06852541e-03, -4.76633711e-03,
         2.82934704e-03,  1.23421254e-03, -2.16538412e-03,
         1.13482238e-03,  2.01879838e-03,  2.87401234e-03,
        -2.31046323e-03, -5.16604050e-04,  8.57418170e-04,
        -3.86176980e-03, -3.16638820e-04,  2.68635317e-03,
        -2.15457450e-03, -8.36861972e-03, -5.32560691e-04,
        -3.01886420e-03,  1.97758013e-03,  3.23204859e-03,
         8.90648284e-04],
       [ 1.18383113e-03,  4.54095658e-03, -4.09086654e-03,
        -1.65424997e-03, -4.04816150e-04, -1.61645224e-03,
         4.74517816e-04,  4.04443534e-04, -2.02548667e-03,
         3.98699885e-05,  1.55081856e-03, -3.35855852e-03,
        -1.13691215e-03,  1.78571942e-03,  1.80779069e-04,
         3.35861021e-03, -1.51129230e-03, -3.40394123e-04,
        -1.74569339e-03, -1.59022177e-03,  1.36186741e-03,
         1.87851244e-03, -2.38506866e-04,  7.65848381e-04,
        -6.21307699e-04,  8.18405359e-04,  1.08417671e-03,
        -1.18901185e-03,  1.06538006e-03, -5.03051233e-05,
        -2.58170039e-04, -1.30684418e-03,  8.79697036e-04,
        -2.57061038e-04, -1.10917061e-03,  9.47741675e-04,
        -3.44662723e-04, -4.94226173e-04,  4.38889518e-04,
        -4.30099608e-04],
       [-3.17691476e-03, -1.47761113e-03, -2.37597758e-03,
         9.59825760e-04,  5.29111549e-03, -5.92836805e-05,
         1.48283073e-03, -3.06900241e-04, -1.92244817e-03,
        -3.21620784e-04, -1.80684845e-03,  2.45970720e-03,
         7.40080548e-04,  9.14127857e-04,  2.88063381e-03,
         5.74573351e-04, -8.64153903e-04, -9.45038220e-04,
         1.47072633e-03, -1.70902023e-03,  2.07878044e-03,
         1.00441894e-03, -3.06183985e-03,  1.37898640e-03,
         1.82259921e-03, -2.06839386e-03,  1.00028364e-03,
        -9.54796618e-04, -1.04325521e-03,  2.57694424e-04,
        -6.60473888e-04, -3.77644505e-03, -9.90575296e-04,
         2.94117886e-03, -1.37275015e-03, -3.31120822e-03,
        -9.84739861e-04, -8.66478309e-04,  3.52100935e-03,
         3.44722612e-05],
       [-3.96320084e-03,  9.65320680e-04,  3.03830067e-03,
        -3.09114391e-03, -1.36087916e-03, -1.83935883e-03,
        -3.18669458e-03,  8.59423832e-04, -1.04003368e-04,
        -9.40216589e-04,  1.42342714e-03,  1.70805340e-03,
         6.37541467e-04, -1.48783147e-03,  4.16420662e-04,
         1.06691608e-04, -8.82735825e-04, -3.66575923e-03,
         2.42683291e-03,  3.15566213e-05, -4.24952386e-03,
         1.39018323e-03,  5.07105934e-03, -2.43970403e-03,
         2.46357895e-03,  1.85747026e-03,  5.26075158e-03,
        -5.65545051e-04, -1.24094053e-03,  5.41383575e-04,
        -3.30661656e-03,  2.39557499e-04,  4.01854003e-03,
        -3.95803188e-04, -2.58505554e-03,  4.76035697e-04,
        -5.48944669e-03,  1.80614635e-03,  1.54886383e-03,
        -3.74216237e-03],
       [ 2.12042389e-04,  4.96106688e-03, -4.99822665e-03,
        -1.20861980e-03, -8.90117488e-04,  5.02897601e-04,
        -2.54129351e-04, -3.25930538e-03, -5.03910426e-03,
         4.49658604e-03,  2.10898067e-03, -5.00566931e-03,
         1.41613837e-03,  2.20411224e-03,  1.78533301e-04,
         3.64789902e-03, -2.01279158e-03, -1.83463213e-03,
        -3.09224939e-03,  1.62791321e-03,  1.59538980e-03,
         4.52764379e-03, -1.26566202e-03,  2.40576640e-03,
        -5.88726602e-04, -1.78581438e-04, -2.17218744e-03,
        -2.84330850e-03,  3.07866419e-03,  1.96411740e-03,
        -9.81004210e-04, -3.26899253e-03,  4.58787021e-04,
        -5.84023132e-04, -3.61295207e-03,  1.87507540e-03,
         2.30823457e-03, -2.31071096e-03,  8.94693309e-04,
        -6.67513756e-04],
       [-3.23036779e-03, -2.00150022e-03, -2.78607383e-03,
         1.15100795e-03,  5.19340159e-03,  2.01816135e-03,
         8.47997202e-04, -1.19090034e-03, -2.33518658e-03,
         9.70115943e-04, -3.09009757e-03,  2.48051505e-03,
        -2.67633121e-03,  2.52642436e-03,  5.00295637e-03,
         2.02349899e-03,  1.42086204e-03, -6.14469231e-04,
         1.89805008e-03, -4.74130269e-04,  1.55956356e-03,
        -2.19491791e-04, -2.27176421e-03,  2.27548904e-03,
        -1.64576876e-03, -1.85551541e-03,  2.12783553e-03,
        -5.14281401e-03,  6.01237931e-04,  9.58590652e-04,
        -4.23037040e-04, -3.64260608e-03, -1.64086081e-03,
         7.85603606e-06, -3.65716708e-03, -1.69953518e-03,
        -6.27150643e-04,  6.71320478e-04,  1.54276518e-03,
         1.97465508e-03],
       [-4.16555488e-03,  1.03591708e-03,  3.64478072e-03,
        -3.38595663e-03, -7.64763565e-04, -5.05169795e-04,
        -4.80789505e-03,  1.82885642e-03,  7.67954261e-05,
        -2.61075282e-03,  1.82131946e-04,  1.37009413e-03,
         1.27626804e-03, -2.62506143e-03,  2.19142204e-03,
        -1.11890468e-03, -2.40792683e-03, -2.41120066e-03,
         1.15085184e-03,  2.18817941e-03, -3.88662796e-03,
         1.16222387e-03,  5.83823770e-03, -1.93183150e-04,
         1.35459797e-03,  2.85504526e-03,  4.72069019e-03,
         2.33825203e-03, -8.59072607e-04,  4.33963171e-04,
         7.88599951e-04,  2.48866575e-03,  3.58440983e-03,
         9.29302711e-04,  8.45742587e-04,  1.69711490e-03,
        -3.82338278e-03,  1.74032943e-03,  3.04368068e-03,
        -2.44994741e-03],
       [-1.03946333e-03,  4.68774652e-03, -4.25705872e-03,
        -1.34948030e-04, -1.28871994e-03,  1.93016650e-03,
        -8.54611164e-04, -2.74030864e-03, -4.91972035e-03,
         4.63374378e-03,  1.96506665e-03, -4.98893531e-03,
         1.66207924e-03,  1.96080212e-03, -6.20749634e-05,
         1.27520191e-03, -2.26118905e-03, -2.44168099e-03,
        -1.13744894e-03,  3.28034558e-03,  3.88819753e-04,
         5.81349665e-03, -3.53278156e-04,  2.45782780e-03,
         1.98194088e-04, -1.00282684e-03, -1.55450194e-03,
        -6.27854199e-04,  2.39887508e-03,  1.89255015e-03,
        -6.92050322e-04, -1.05816929e-03,  3.01054824e-04,
         4.99362883e-04, -2.61666649e-03,  1.90594478e-03,
         1.97909377e-03, -1.21576886e-03, -3.97510885e-04,
        -1.12206581e-04],
       [-2.89952219e-03, -2.38097529e-03, -3.71623388e-03,
         3.24416818e-04,  3.51970526e-03,  2.67018587e-03,
         1.02220611e-06, -4.81005234e-04, -1.51519896e-03,
         2.94063566e-03, -2.29879515e-03,  2.15150928e-03,
        -4.00730642e-03,  2.32739281e-03,  3.92101938e-03,
         2.91660731e-03,  1.11792295e-03, -1.21408328e-03,
         2.95222690e-03, -3.77530552e-04,  2.91425560e-04,
        -8.82522378e-04,  1.11882947e-03,  1.21756853e-03,
        -2.29304167e-03, -2.26046215e-03,  8.27118114e-04,
        -5.22557041e-03, -3.45363194e-04,  6.27797272e-04,
        -4.63582226e-04, -2.72113550e-03, -1.49452349e-03,
        -9.23696498e-05, -1.20543956e-03,  9.53753537e-04,
        -1.19997596e-03,  1.08896999e-03, -1.30913197e-03,
        -1.29638461e-03],
       [-3.90879158e-03,  5.49873395e-04,  3.47811356e-03,
        -3.71030532e-03,  1.80408606e-04,  9.39388468e-04,
        -5.38663287e-03,  1.61767460e-03,  1.68012886e-03,
        -2.59307842e-03, -5.86580951e-04,  9.05160850e-04,
         2.50338082e-04, -1.53530820e-03,  3.11790593e-03,
        -1.10333471e-03, -4.75821272e-03, -7.08614942e-04,
        -7.09722575e-04,  3.09860008e-03, -3.06616165e-03,
         2.51765666e-03,  4.04084846e-03,  2.57051806e-03,
        -6.73268165e-04,  7.95383181e-04,  3.55781103e-03,
         3.84060154e-03, -3.37017048e-03, -1.54344784e-03,
         4.87004919e-03,  5.20814117e-03,  1.42839528e-03,
         9.20181454e-04,  1.08328334e-03, -1.16411313e-04,
        -9.99226701e-04,  9.14266566e-05,  9.53353476e-04,
         1.23001193e-03],
       [-2.52903998e-03,  3.33012943e-03, -2.66739749e-03,
         1.52463862e-03, -1.72467914e-03,  2.34242319e-03,
        -1.25490699e-03, -7.60711191e-06, -2.47925846e-03,
         2.85875285e-03,  1.21260155e-03, -4.13270947e-03,
         3.21509840e-04,  2.29701586e-03, -8.72514385e-04,
        -1.35020784e-03, -2.29163072e-03, -2.57131271e-03,
         2.70718010e-04,  3.26010049e-03, -5.02322218e-04,
         5.89982560e-03,  2.25398107e-03,  2.28616339e-03,
         6.74138195e-04, -1.18402566e-03, -4.61353105e-04,
         1.90589868e-03, -2.66596064e-04, -3.13388387e-04,
         1.11794821e-03,  3.01407278e-03,  5.02837705e-04,
         2.10052100e-03, -1.46247749e-03, -1.93225769e-05,
         1.14025234e-03,  6.05088833e-04, -1.96862442e-04,
         8.25996278e-04],
       [-2.16328539e-03, -2.69401725e-03, -4.21061087e-03,
        -7.32078042e-04,  1.01638911e-03,  1.53549726e-03,
        -1.87873942e-04,  9.90346307e-04,  4.53197135e-04,
         4.04764805e-03, -1.44909834e-03,  1.19288324e-03,
        -2.81721121e-03,  2.47309194e-03,  1.08468730e-03,
         1.97732984e-03,  3.19526385e-04, -2.02889042e-03,
         2.75182514e-03, -4.84204385e-04, -1.52508507e-03,
        -1.51859818e-03,  3.61702545e-03,  6.65221072e-04,
        -1.98987406e-03, -4.81867755e-04, -8.43771384e-04,
        -3.11962795e-03, -4.65467485e-04, -5.25210227e-04,
         1.22370454e-03,  6.25241664e-04, -7.83306954e-04,
         1.15269562e-03, -1.02604355e-03,  3.50345857e-03,
        -1.64715562e-03,  1.54063897e-03, -1.86553551e-03,
        -1.53352506e-03],
       [-2.83357920e-03,  4.66956146e-04,  2.46130815e-03,
        -4.01420845e-03,  8.47437303e-04,  2.59593106e-03,
        -4.67704143e-03,  4.36380069e-04,  2.34660413e-03,
        -2.13510939e-03, -9.49692971e-04,  9.35710268e-04,
         4.58410213e-04, -7.24954065e-04,  1.66148145e-03,
        -4.75789537e-04, -5.03407884e-03,  1.36838132e-03,
        -9.16425895e-04,  1.63141568e-03, -7.33021297e-04,
         2.37042690e-03, -2.00582181e-05,  2.77825934e-03,
        -1.28031685e-03, -3.15651909e-04,  2.73376447e-03,
         1.22281024e-03, -6.06757216e-03, -2.20199046e-03,
         4.22126893e-03,  3.99848307e-03, -1.88225880e-03,
        -9.07718961e-04,  7.30327214e-04, -2.05978123e-03,
         1.48176553e-03,  2.73844809e-03, -9.98253818e-04,
         2.08088360e-03],
       [-3.74910096e-03,  1.83829910e-03, -1.16072281e-03,
         3.29183182e-03, -2.16549588e-03,  2.46676011e-03,
        -1.32496678e-03,  1.86773087e-03, -5.65520953e-04,
        -1.07579952e-04,  1.09862929e-04, -2.99432781e-03,
        -3.84074083e-04,  2.52629351e-03, -1.36582414e-03,
        -1.89305679e-03, -9.53945215e-04, -2.01835856e-03,
         4.11656860e-04,  2.35251524e-03,  2.94211874e-04,
         4.19733813e-03,  2.10940978e-03,  9.17417987e-04,
         7.08100270e-04, -1.22834963e-03, -4.22586047e-04,
         1.05955382e-03, -2.60263984e-03, -1.57639687e-03,
         2.67323543e-04,  3.40264663e-03, -2.29240046e-04,
         1.74372585e-03, -2.41354355e-04, -2.04139855e-03,
         1.02798257e-03,  2.88048806e-03,  7.70490078e-05,
        -5.21749142e-04],
       [-1.10469735e-03, -2.58212863e-03, -3.93038895e-03,
        -1.33434741e-03, -1.32286234e-03,  4.58658295e-04,
        -2.21261987e-04,  1.67324359e-03,  1.32289773e-03,
         3.04551423e-03, -4.30201508e-05, -1.84618431e-04,
         4.04055114e-04,  2.67408555e-03,  1.46541093e-03,
         1.20399310e-03,  7.95178858e-05, -3.03455442e-03,
         8.33271013e-04, -1.17826348e-04, -2.12322245e-03,
        -2.32127798e-03,  3.00062727e-03,  6.80932077e-04,
        -1.51696021e-03, -4.98352689e-04, -1.74237392e-03,
        -2.43523065e-03, -1.26803224e-03, -2.24318891e-03,
         1.08834379e-03,  1.41440541e-03, -1.60600164e-03,
         1.26007048e-03,  9.11330048e-04,  2.55686627e-03,
        -1.59628678e-03, -3.23684799e-04, -1.70889753e-03,
        -7.06051942e-04],
       [-1.72696484e-03,  5.91420569e-04,  6.54353702e-04,
        -3.36431130e-03,  4.67365026e-04,  2.80428561e-03,
        -2.73482851e-03, -6.47607783e-04,  3.12324194e-03,
        -8.10507801e-04,  3.74754512e-04,  1.04107836e-03,
         2.34084844e-04, -1.05699676e-03, -1.93726667e-03,
         1.17936404e-03, -2.96935416e-03,  2.43553706e-03,
        -6.39241887e-04, -2.93071382e-04,  3.74594354e-04,
         4.45354125e-03, -1.22982101e-03,  1.11187168e-03,
         9.30832975e-05,  6.02522050e-04,  1.29892875e-03,
        -3.41209187e-03, -7.85007980e-03, -5.24284784e-04,
         2.70899269e-04,  1.83839968e-03, -4.62903315e-03,
        -2.27746414e-03, -1.60917302e-03,  1.27420342e-03,
         5.50984032e-03,  4.77787433e-03,  1.20836613e-03,
         9.41231381e-04],
       [-4.31846781e-03,  4.30250017e-04, -6.97878888e-04,
         4.45438083e-03, -3.28981387e-03,  1.70771952e-03,
        -4.46457125e-04,  2.70052929e-03,  2.12211418e-03,
        -1.77134806e-03,  2.59217020e-04, -1.89986371e-03,
        -8.98617902e-04,  2.87221256e-03, -1.81345677e-03,
        -1.15422718e-03,  2.54858471e-03, -5.34442370e-04,
        -1.97198056e-03,  1.35312881e-03,  4.89801867e-04,
         6.56135427e-03,  9.57822427e-04,  1.25597056e-03,
        -2.29530822e-04, -6.10871473e-04, -1.46587892e-03,
        -2.97117722e-03, -3.28592188e-03, -1.74659409e-03,
        -3.55800730e-03,  2.06933334e-03,  1.48134175e-04,
         7.51401123e-04, -1.49908126e-03, -1.04217231e-03,
         4.65048797e-04,  2.18826113e-03,  4.24436713e-03,
         2.62956251e-04],
       [ 3.94698109e-05, -2.11170688e-03, -2.81208497e-03,
        -8.03424220e-04, -3.32156615e-03, -2.46918411e-04,
         1.95420769e-04,  1.52142812e-03, -4.37279989e-04,
        -1.14586022e-04,  1.34654203e-03,  6.34912722e-05,
         2.87365867e-03,  3.71997524e-03,  3.82958842e-03,
        -1.59476395e-03,  4.23366931e-04, -3.89395258e-03,
        -2.37008673e-03, -7.51291145e-06, -2.44158320e-03,
        -4.47019935e-03,  1.05292839e-03,  2.64020963e-03,
        -8.07245902e-04, -1.98371126e-03,  4.61120420e-04,
        -1.97361805e-03, -9.52851493e-04, -3.80792306e-03,
         1.49413233e-03, -1.62157870e-03, -2.09776498e-03,
        -2.75526050e-04,  1.85367966e-03,  5.15161373e-04,
        -1.40261021e-03,  9.04237913e-06, -1.67628028e-03,
        -8.28890479e-04],
       [-1.21000304e-03,  2.40899069e-04,  6.93586844e-05,
        -1.22584251e-03,  1.30471570e-04,  4.36554183e-05,
        -1.22034259e-03, -4.60528390e-04,  2.63003958e-03,
         4.20286786e-04,  3.86678206e-04, -1.18884273e-04,
        -3.77394113e-04,  6.87163047e-05, -2.68422929e-03,
         2.76650535e-03, -1.21023413e-03,  4.02862811e-03,
        -1.57114846e-04,  5.61342749e-04,  3.58806516e-04,
         3.97669524e-03, -1.67259155e-03,  1.59838528e-03,
        -2.00103200e-03,  1.17547216e-03, -3.03027191e-04,
        -2.55958550e-03, -5.85871236e-03,  2.05972930e-03,
        -4.30988875e-05,  2.24382291e-03, -2.14397418e-03,
        -1.38239047e-04,  2.28412822e-03,  3.70354578e-03,
         7.12003233e-03,  1.98937650e-03,  1.53332995e-03,
        -9.02571832e-04],
       [-4.82623791e-03, -1.00463908e-03, -4.33550973e-04,
         5.57874236e-03, -4.60436102e-03, -1.43459497e-03,
         9.40223050e-04,  3.33245099e-03,  5.31379972e-03,
        -1.46509463e-03, -5.31475991e-04, -1.48431351e-03,
        -1.94488047e-03,  3.93343298e-03, -1.22772017e-03,
         1.06130412e-03,  5.69012854e-03,  3.91754368e-03,
        -4.66375891e-03,  2.57741357e-03,  7.03183105e-05,
         8.66170134e-03, -2.34817900e-03,  5.16652688e-03,
        -6.74243364e-03,  1.16810075e-03, -2.89113168e-03,
        -4.83269896e-03,  4.99513699e-04, -5.65585622e-04,
        -2.96501699e-03,  3.30426171e-03,  5.15062409e-03,
         7.73425447e-04,  3.07835243e-03,  1.45768083e-03,
        -1.95560697e-03, -2.39179097e-03,  9.61593539e-03,
         7.59113638e-04],
       [ 1.01993920e-03, -1.83932064e-03, -1.87268690e-03,
         7.45620870e-04, -5.62453270e-03, -1.54651306e-03,
         1.29238819e-03,  1.26692932e-03, -3.82126146e-03,
        -3.68525996e-03,  1.95484189e-03,  1.85811694e-03,
         2.53094966e-03,  6.14753226e-03,  6.05283491e-03,
        -5.80922980e-03,  7.85557670e-04, -5.04446262e-03,
        -4.84697148e-03, -1.09961862e-03, -3.57468450e-03,
        -7.14562600e-03, -5.86194801e-04,  4.45627375e-03,
         1.37847918e-03, -3.04480805e-03,  4.15680325e-03,
        -1.25537661e-03,  3.99363413e-03, -3.31622153e-03,
         5.00060199e-03, -6.60976442e-03, -1.85258931e-03,
        -3.02411546e-03, -3.20281164e-04, -7.64197379e-04,
         1.58898451e-03,  2.28883512e-03, -1.04285695e-03,
        -6.34333992e-04],
       [ 7.29430903e-05, -1.68146275e-04, -5.91958815e-06,
        -3.64528241e-05, -1.36578337e-05, -1.82631979e-04,
        -6.38574827e-04, -6.23234315e-04,  4.40705102e-04,
        -1.10729458e-03,  2.60796194e-04, -7.20739830e-04,
        -1.04779210e-04,  2.22825189e-03, -4.31624823e-04,
         3.22758849e-03, -1.00629660e-03,  2.86590308e-03,
         5.06394608e-05, -1.22186670e-03,  3.19445186e-04,
         2.34339139e-04, -2.03835079e-03,  1.21338048e-03,
        -1.27755722e-03,  1.26368031e-04,  1.42077915e-03,
        -5.53355087e-04, -3.95595562e-03,  2.63353018e-03,
        -4.78957198e-04,  1.44399726e-03,  3.64727835e-04,
         2.31043389e-03,  2.09365226e-03,  2.58237566e-03,
         5.21622552e-03, -1.75351929e-03,  1.52186331e-04,
         5.58739819e-04],
       [-4.68560727e-03, -1.43796869e-03, -6.43893727e-04,
         5.66796213e-03, -5.39254583e-03, -1.91377464e-03,
         1.36943406e-03,  3.50782485e-03,  6.42394135e-03,
        -1.36971381e-03, -1.26856519e-03, -1.18356117e-03,
        -1.40925252e-03,  4.25826758e-03, -1.64982514e-04,
         2.79260054e-03,  6.27554907e-03,  7.12955045e-03,
        -5.91536937e-03,  1.34273712e-03,  7.60600902e-04,
         9.07421857e-03, -4.98582702e-03,  5.98211307e-03,
        -1.08184777e-02,  1.60553516e-03, -3.60009680e-03,
        -6.62248069e-03,  2.31788633e-03,  1.74023939e-04,
        -3.55693558e-03,  4.64980351e-03,  7.21188029e-03,
        -3.21522617e-04,  5.12935361e-03,  2.22488632e-03,
        -3.64783523e-03, -5.22877648e-03,  1.00535303e-02,
         2.77156546e-03],
       [ 1.18304649e-03, -1.99696701e-03, -1.35479530e-03,
         2.35011638e-03, -6.93521788e-03, -3.24859982e-03,
         1.71082444e-03,  1.26106630e-03, -4.93637193e-03,
        -5.51089551e-03,  1.96743477e-03,  2.66731717e-03,
         1.60504505e-03,  7.64271431e-03,  7.49730226e-03,
        -8.19465891e-03,  2.17543612e-03, -5.06240223e-03,
        -6.31301431e-03, -1.11865113e-03, -4.70343046e-03,
        -7.07991328e-03, -2.52087670e-03,  5.56417042e-03,
         3.08157317e-03, -2.95228604e-03,  5.39855147e-03,
         1.83338943e-05,  8.18480644e-03, -1.76550180e-03,
         7.90865906e-03, -8.03796947e-03, -1.27266429e-03,
        -4.69611352e-03, -9.10422823e-04, -2.78756896e-04,
         4.08747373e-03,  1.27431576e-03, -5.83380403e-04,
        -2.19475385e-03],
       [ 1.37045141e-03, -5.51566482e-04,  1.02387326e-04,
         1.18459028e-03, -3.54527991e-04, -5.84713591e-04,
        -2.31291619e-04, -9.17906931e-04, -1.83537847e-03,
        -2.34563067e-03,  1.81451862e-04, -8.55057151e-04,
         1.75568421e-04,  4.39243810e-03,  2.22088723e-03,
         2.84426752e-03, -5.12567407e-04,  1.37245131e-03,
         6.34273398e-04, -2.28285394e-03,  4.54570662e-04,
        -3.28655099e-03, -1.69894064e-03,  3.77343851e-04,
         4.08109918e-04, -5.31680242e-04,  3.65849026e-03,
         9.95536684e-04, -9.23730724e-04,  2.95377546e-03,
         3.28300695e-04, -5.39581015e-05,  2.55794427e-03,
         3.95382242e-03,  1.28945976e-03,  1.79049571e-03,
         1.93647656e-03, -4.84004570e-03, -7.23811216e-04,
         2.07971758e-03],
       [-4.81600827e-03, -9.94114787e-04, -5.41814370e-04,
         5.94703946e-03, -4.63837851e-03, -1.99258793e-03,
         1.28069703e-04,  3.15018022e-03,  5.56075620e-03,
        -1.70593534e-03, -1.97204109e-03, -9.24847962e-04,
        -9.67691827e-04,  2.85477983e-03, -7.14942988e-04,
         1.76900299e-03,  5.04782936e-03,  5.70397964e-03,
        -4.44761850e-03, -4.15976334e-04, -1.49545714e-03,
         7.88728520e-03, -3.62712238e-03,  5.02788834e-03,
        -8.52597877e-03,  1.19223236e-03, -2.96669803e-03,
        -5.45884203e-03,  1.80742482e-03, -1.61786738e-04,
        -2.98444019e-03,  3.65133025e-03,  2.46433332e-03,
        -1.25221140e-03,  2.15639523e-03,  9.43967549e-04,
        -1.83672644e-03, -2.82397680e-03,  6.37788931e-03,
         2.17582041e-04],
       [ 1.16738107e-03, -1.69085630e-03, -1.76478538e-03,
         7.82217889e-04, -5.92442695e-03, -1.74769899e-03,
         1.32886285e-03,  1.17168587e-03, -2.94703571e-03,
        -4.34183050e-03,  1.92517065e-03,  1.86053850e-03,
         2.56730663e-03,  5.61293680e-03,  6.98313629e-03,
        -6.69015851e-03,  1.67109328e-03, -3.28186434e-03,
        -6.12213556e-03, -1.07495126e-03, -2.97362148e-03,
        -4.16950136e-03, -4.70226025e-03,  2.22642021e-03,
         2.55296053e-03, -2.35059834e-03,  4.33927309e-03,
        -9.86511935e-04,  4.63144528e-03, -9.76436306e-04,
         5.91184478e-03, -5.77252079e-03, -5.40917914e-04,
        -2.57587479e-03, -9.99328564e-04,  4.66408324e-04,
         2.84151547e-03,  1.72112850e-04, -6.91850164e-06,
        -1.88069977e-03],
       [ 1.81144045e-03, -1.02081045e-03, -5.68430478e-05,
         3.16312374e-03, -7.74885528e-04, -3.68672330e-03,
        -6.35969103e-04, -1.98681909e-03, -2.75061699e-03,
        -9.42283601e-04, -1.64717913e-03, -1.79388866e-04,
        -3.54113814e-04,  4.60909726e-03,  2.36844900e-03,
         2.85258051e-03, -4.66356258e-04,  1.62778667e-03,
         1.61721662e-03, -2.28216581e-04,  3.03332839e-04,
        -3.76961683e-03,  1.82114018e-03,  2.21357308e-03,
        -1.63785779e-04, -4.32630040e-04,  2.60747108e-03,
         2.22880091e-03,  3.41801741e-03,  3.47991497e-03,
         2.88103707e-03,  4.24976111e-04,  4.10100864e-03,
         4.24529519e-03,  4.16646432e-03,  1.22897676e-03,
        -6.90580579e-04, -6.55745063e-03,  5.34113264e-04,
        -8.32330319e-04],
       [-4.35538730e-03,  3.87480162e-04, -7.57068279e-04,
         5.07231755e-03, -3.26683489e-03,  7.45018711e-04,
        -1.81827461e-03,  2.36470276e-03,  3.08794831e-03,
        -2.29387614e-03, -1.67186058e-03, -2.80675886e-04,
         8.13242863e-04,  9.77293472e-04, -1.56067358e-03,
        -3.79441393e-04,  2.31434288e-03,  2.99079367e-03,
        -1.75515201e-03, -2.86839879e-03, -2.48981500e-03,
         4.58996557e-03, -1.70401984e-03,  4.07942192e-04,
        -2.37549678e-03, -7.61721225e-04, -1.95602118e-03,
        -4.19334322e-03, -2.24543922e-03, -2.35174946e-03,
        -3.60566564e-03,  1.73358130e-03, -2.81637767e-03,
        -2.76767835e-03, -2.76047527e-03, -7.62160344e-04,
        -2.38813864e-05, -3.65931337e-04,  5.35380910e-04,
        -5.44520386e-04],
       [ 2.40902256e-04, -1.83403667e-03, -2.67636660e-03,
        -9.41650884e-04, -3.83117725e-03, -7.97632674e-04,
        -3.46758345e-04,  1.18062377e-03,  8.00726411e-04,
        -6.62435545e-04,  9.87110077e-04,  2.41384056e-04,
         2.89385975e-03,  2.25221738e-03,  5.01660118e-03,
        -3.82943568e-03,  6.26058260e-04, -9.79522942e-04,
        -4.92278580e-03,  8.12373837e-05, -2.25945306e-03,
        -4.12196794e-04, -4.00885800e-03, -8.49863631e-04,
         2.18631071e-03, -1.13891263e-03,  1.38640695e-03,
        -9.69675311e-04,  1.11720001e-03, -7.33262859e-05,
         3.26775969e-03, -7.83804222e-04,  1.49796042e-05,
         1.12142647e-03,  1.72462477e-03,  1.26639940e-03,
         9.66284424e-04, -6.77235366e-04,  4.39983502e-04,
        -3.06887412e-03],
       [ 2.88049597e-03, -9.74708935e-04, -1.48479559e-03,
         3.65399360e-03, -1.19033933e-03, -4.47754655e-03,
        -8.72666074e-04, -4.61411988e-03, -1.26371835e-03,
         3.26783600e-04, -2.12709536e-03,  1.33788527e-03,
        -4.12216148e-04,  3.17963446e-03, -5.83032554e-04,
         2.60201190e-03,  1.10626046e-03,  1.09883852e-03,
         1.85187091e-03,  1.18454255e-03,  2.29243189e-03,
        -1.81624619e-03,  4.02638363e-03,  9.16816178e-04,
         1.77699316e-03, -6.32906158e-05,  2.79646600e-04,
        -1.30237651e-03,  2.21250835e-03,  2.52433354e-03,
         1.58222567e-03, -1.09629962e-03,  2.83991243e-03,
        -1.10956479e-03,  1.78002368e-03,  2.10787565e-03,
        -1.58910826e-03, -2.86025833e-03,  3.61652067e-03,
        -3.35979857e-03],
       [-3.92444758e-03,  1.87401008e-03, -1.08718849e-03,
         3.97095224e-03, -2.16303510e-03,  1.34798721e-03,
        -3.19865742e-03,  1.13717897e-03,  7.31611275e-04,
        -5.11566759e-04, -1.85185112e-03,  4.22790647e-04,
         1.66278926e-03, -4.69628169e-04, -9.53215116e-04,
        -1.67819776e-03, -5.80213557e-04,  3.07731982e-03,
         4.33081208e-04, -3.87685304e-03, -3.46007105e-03,
         1.63603894e-04, -1.07622775e-03, -6.24480890e-04,
        -1.11102685e-03, -1.50097266e-03, -1.02779793e-03,
        -1.19625774e-05, -2.94498960e-03, -2.70661432e-03,
        -1.25334749e-03,  1.89377542e-03, -3.48613039e-03,
        -7.96645123e-04, -1.69689767e-03, -1.93175802e-03,
        -3.18854814e-04,  5.46151387e-05, -2.57579074e-03,
        -7.10971479e-04],
       [-8.58054264e-04, -2.30725552e-03, -3.82105098e-03,
        -1.83460442e-03, -2.12351838e-03, -9.48151224e-04,
        -1.89061195e-03,  2.70899734e-04,  2.89426208e-03,
         2.08202307e-03,  1.88644743e-04, -1.11933565e-03,
         1.46885010e-04, -1.12520393e-04,  2.09934334e-03,
        -2.16948101e-03, -3.52241943e-04,  1.05144933e-03,
        -3.02843028e-03,  3.52321309e-04, -2.13877321e-03,
         9.97597817e-04, -1.62435300e-03, -3.27370386e-03,
         3.23392591e-03, -1.53004774e-04, -1.23671524e-03,
        -5.55541308e-04,  1.29291567e-03, -8.12966435e-04,
         2.18747742e-03,  1.79382518e-03,  1.07061281e-03,
         1.39044679e-03,  1.11067633e-03,  1.17043208e-03,
         1.30570924e-03, -2.80669425e-04,  1.37939595e-03,
        -3.27941100e-03],
       [ 3.91308311e-03, -8.13188904e-04, -2.43548444e-03,
         3.27693159e-03, -8.34720617e-04, -3.54653667e-03,
        -4.23131190e-04, -6.42845547e-03,  1.98308393e-04,
         5.57984924e-04, -2.13726377e-03,  1.24592078e-03,
        -2.76888139e-04,  2.50956160e-03, -1.89826766e-03,
         1.36499398e-03,  2.94238143e-03,  7.12495588e-04,
         1.23736833e-03,  1.36999553e-03,  5.01741702e-03,
        -3.69127200e-04,  7.47032696e-04, -1.29441067e-03,
         2.44794739e-03,  3.97598342e-04,  7.34005007e-04,
        -2.64920457e-03, -2.02052947e-03,  7.59654387e-04,
         1.23962434e-03, -3.19094467e-03,  1.78547367e-03,
        -5.41222002e-03,  6.23904867e-04,  6.42324041e-04,
        -2.24333466e-03,  4.79740323e-04,  1.86692295e-03,
        -4.06844402e-03],
       [-2.83654639e-03,  3.30332387e-03, -2.30047014e-03,
         2.37639085e-03, -1.59779622e-03,  9.62760649e-04,
        -3.78623442e-03, -1.10113493e-03, -4.87425685e-04,
         2.49187602e-03, -1.31860247e-03,  1.87862106e-03,
         2.56677601e-03, -1.60139007e-03,  2.78093969e-04,
        -1.60674832e-03, -1.21722417e-03,  3.67925083e-03,
         4.96719265e-04, -2.90461699e-03, -4.96972958e-03,
        -4.42730030e-04, -1.53413013e-04,  9.06658592e-04,
        -2.67447461e-03, -2.54759844e-03, -2.01995322e-03,
         2.37056357e-03, -2.50088028e-03, -1.70469296e-03,
        -1.55340822e-04,  2.58578476e-03, -4.31261054e-04,
         7.49945932e-04, -1.68523984e-03, -5.92634256e-04,
        -1.91921531e-03, -1.23073149e-03, -2.67441355e-05,
         1.18344999e-03],
       [-1.90718565e-03, -2.41818698e-03, -4.19003842e-03,
        -1.68610562e-03,  2.35071217e-04, -7.65369681e-04,
        -2.68019759e-03, -1.25070522e-03,  2.21613212e-03,
         2.24494468e-03,  3.36751982e-04, -1.96297513e-03,
        -3.80865810e-03, -1.40393572e-03,  1.16566999e-03,
        -2.03083619e-03,  1.02436934e-04,  2.95180129e-03,
        -2.05459609e-03,  3.79736419e-04, -2.49983883e-03,
         4.53034590e-04, -1.49565443e-04, -3.78227443e-03,
         3.29045136e-03, -3.70052527e-04, -5.86623501e-04,
         3.94659233e-04,  1.24437315e-03, -1.71244971e-03,
         5.68940828e-04,  6.50073460e-04,  3.02719092e-03,
         5.33412094e-04, -3.56183213e-04,  4.49081534e-04,
         1.08755543e-03,  1.51707570e-03,  1.09680952e-03,
        -2.66589900e-03],
       [ 4.19143867e-03, -1.07755396e-03, -2.76069460e-03,
         2.72590783e-03, -2.45672069e-04, -2.55594729e-03,
        -3.47440655e-04, -6.43569464e-03,  2.09334888e-03,
         5.41985384e-04, -1.94142689e-03, -1.60667041e-04,
        -9.76658892e-04,  3.11140134e-03, -7.23213539e-04,
         4.59722942e-04,  2.23837397e-03,  4.25024657e-04,
        -1.80097413e-04,  2.41307169e-03,  5.99384494e-03,
         1.91491249e-03, -1.86876953e-03, -5.63405571e-04,
        -7.74723085e-05, -1.25231850e-03,  1.88915787e-04,
        -7.00443561e-05, -4.08339640e-03, -1.78324396e-03,
         3.73153877e-03, -1.42647722e-03,  1.16334949e-03,
        -5.25138248e-03,  4.19337972e-04, -2.99845054e-03,
        -1.58150250e-03, -1.29878506e-04,  1.41974469e-03,
        -5.76085258e-05],
       [-1.42275961e-03,  4.61411383e-03, -3.57750012e-03,
         9.15417157e-04, -1.14425889e-03,  4.98665031e-04,
        -3.00715165e-03, -3.78990034e-03, -2.60857982e-03,
         4.99888789e-03, -1.09558227e-03,  3.26727051e-03,
         3.87964211e-03, -2.91497330e-03,  1.53088418e-03,
         7.18278345e-04,  1.15142821e-03,  3.56881041e-03,
        -8.92713899e-04, -1.76064856e-03, -4.02042270e-03,
        -1.23262824e-03, -1.08076341e-03, -3.40640399e-04,
        -3.95473000e-03, -2.13207817e-03, -2.25474662e-03,
         1.80055888e-03, -3.15294112e-03, -3.77374701e-04,
         1.02786371e-03,  5.56219835e-04,  3.15614510e-03,
        -1.54506543e-03, -1.19739829e-03,  2.44897348e-03,
        -1.75232661e-03, -6.13408629e-04,  4.15619975e-03,
         3.42126383e-04],
       [-2.66058021e-03, -2.05572764e-03, -3.75959999e-03,
        -7.96740002e-04,  2.77311052e-03, -2.26866148e-04,
        -2.03131209e-03, -2.66675139e-03, -3.19142360e-04,
         8.11988895e-04,  1.04060094e-03, -2.82700220e-03,
        -5.96501259e-03, -2.08524475e-03,  3.40273930e-03,
        -8.70220363e-04,  2.15671584e-03,  3.71903041e-03,
        -2.14494788e-03,  7.23589270e-04, -1.89638720e-03,
        -3.12916905e-04, -1.59194740e-03, -4.39547002e-03,
         1.46662863e-03, -1.66653330e-03,  2.14571110e-03,
         3.42979212e-04, -6.65732950e-04, -1.64349843e-03,
        -1.14538940e-03, -1.28325319e-03,  3.31746228e-03,
        -6.73622126e-05,  4.97688074e-04, -4.25987935e-04,
         1.58978032e-03,  2.37194519e-03,  1.55897089e-03,
        -4.74950008e-04],
       [ 3.92911909e-03, -8.86311871e-04, -2.32073735e-03,
         2.87866243e-03,  1.69450403e-04, -9.68292239e-04,
        -1.09842943e-03, -5.08006662e-03,  2.38732016e-03,
        -5.88963216e-04, -2.57258909e-03, -7.51005195e-04,
        -1.75388996e-04,  2.40690098e-03,  1.05940842e-03,
         3.60658829e-04,  2.36966647e-03, -1.39397755e-03,
        -1.16015866e-03,  3.16991657e-03,  5.55261411e-03,
         1.63407228e-03, -1.93711952e-03,  6.37399207e-04,
        -2.67645437e-03, -6.98506017e-04, -7.49351573e-04,
         1.96420331e-03, -1.84836250e-03, -3.27899610e-03,
         6.91591669e-03,  1.36421819e-03, -4.02637146e-04,
        -4.01620939e-03,  3.04544228e-03, -1.75857835e-03,
        -9.94003145e-04,  1.39713252e-03,  3.38990148e-03,
         1.50900614e-03],
       [-1.72533837e-04,  4.85456549e-03, -4.23932727e-03,
        -2.63481343e-04, -9.24481370e-04, -6.61804050e-04,
        -1.43457460e-03, -3.99637269e-03, -2.88306200e-03,
         5.53630013e-03, -9.89386230e-04,  3.72245116e-03,
         3.04994336e-03, -3.27804941e-03,  1.48417521e-03,
         1.66872272e-03,  2.73161381e-03,  1.96882803e-03,
        -2.98368395e-03, -8.91392352e-04, -5.92041237e-04,
        -8.18308385e-04, -7.04982376e-04, -6.92263478e-04,
        -3.67624615e-03, -1.96903525e-03, -1.63843657e-03,
        -4.96645342e-04, -2.13611661e-03, -9.77077987e-04,
         1.86872249e-03,  3.54379183e-04,  4.90115304e-03,
        -2.84046540e-03, -1.94016390e-03,  2.00312794e-03,
        -3.32522206e-04, -2.60786619e-04,  6.47959951e-03,
        -7.47017562e-04],
       [-3.02321953e-03, -1.50473148e-03, -2.73700245e-03,
         4.46070422e-04,  4.60796384e-03, -9.63517668e-05,
        -5.39381173e-04, -2.80248118e-03, -1.93240610e-03,
        -1.12302694e-03,  7.99160567e-04, -2.97432183e-03,
        -5.32452483e-03, -1.43667078e-03,  4.22899472e-03,
        -9.54003015e-04,  3.71493516e-03,  1.07157079e-03,
        -2.59672734e-03,  5.52389189e-04,  2.93602716e-05,
        -1.79188047e-03, -3.40598868e-03, -2.31614709e-03,
        -2.31532031e-05, -2.45394185e-03,  3.66437575e-03,
        -8.46147886e-04, -1.00715237e-03,  4.47065977e-04,
        -6.80101861e-04, -5.21423179e-04,  9.43676743e-04,
        -4.68995277e-04, -2.29987828e-03, -1.05030090e-03,
         2.12536962e-03,  3.57136456e-03,  2.16836808e-03,
         3.95118492e-03],
       [ 3.54612386e-03, -1.06389425e-03, -1.29154674e-03,
         2.94374558e-03,  3.81784164e-04,  6.71993766e-04,
        -2.71634944e-03, -1.88005774e-03,  1.79448875e-03,
        -2.37535709e-03, -2.07669567e-03, -1.28142280e-03,
         1.15357514e-03, -4.35189490e-04,  2.44553154e-03,
         4.09482629e-04,  3.17388726e-03, -2.34212028e-03,
         2.95398961e-04,  2.40594964e-03,  4.78037307e-03,
         7.45261903e-04, -1.19483877e-04,  1.35021517e-04,
        -2.69761658e-03, -4.96423454e-04, -1.07914493e-04,
         3.31634074e-03,  1.80043385e-03, -5.28337806e-03,
         5.77748381e-03,  3.00428504e-03, -3.21306376e-04,
        -2.03564903e-03,  6.83134608e-03,  2.39719157e-04,
        -1.74570235e-03,  1.44087372e-03,  1.21910212e-04,
        -7.04826729e-04],
       [ 8.35126557e-04,  4.71081724e-03, -3.81372659e-03,
        -8.59820109e-04, -6.76704047e-04, -1.81795738e-03,
         1.74742272e-05, -1.13714406e-04, -3.60075821e-04,
         1.03125873e-03, -1.87869824e-03,  3.46881943e-03,
        -1.76218076e-04, -3.96341085e-03,  2.96656857e-04,
        -4.26135899e-04,  1.93476607e-03, -1.63729396e-03,
        -2.48927204e-03, -3.04218498e-04,  1.40839978e-03,
         5.76256367e-04,  1.92185026e-03,  5.67259449e-05,
        -1.21814234e-03, -2.47476366e-03, -5.62506844e-04,
        -6.02858025e-04, -6.12856180e-04, -3.88211483e-04,
        -1.39058175e-04,  1.64476293e-03,  3.16181080e-03,
        -1.81455316e-03, -1.03438902e-03,  8.40973225e-05,
         9.43293620e-04, -8.95300589e-04,  2.45816796e-03,
        -1.22754299e-03],
       [-3.10491025e-03, -1.00716227e-03, -2.33484036e-03,
         5.10336773e-04,  4.80059767e-03, -1.69905694e-03,
         1.58721377e-04, -1.39247347e-03, -1.41564652e-03,
        -2.11868505e-03,  1.05391536e-03, -3.11322673e-03,
        -1.76280597e-03, -3.11203324e-03,  1.87703629e-03,
        -8.60958069e-04,  2.84097297e-03, -2.27587577e-03,
        -1.29218353e-03,  4.07533109e-04, -3.35975456e-05,
        -2.22545816e-03, -2.38770829e-03,  1.78016853e-04,
         6.76361728e-04, -3.01786372e-03,  8.33834172e-04,
        -9.60044326e-06, -2.53323978e-03,  2.18959781e-03,
         1.04540342e-03,  1.45144120e-04, -1.42004597e-03,
         2.21915008e-03, -3.17999488e-03,  5.86500741e-04,
         5.16026805e-04,  1.54645357e-03,  2.60718097e-03,
         1.05057564e-03],
       [ 3.18336976e-03, -9.86972591e-04, -1.30500691e-03,
         3.25408042e-03,  1.21544045e-03,  1.84154883e-03,
        -4.01569065e-03,  1.18034950e-04,  1.78951910e-03,
        -2.01254408e-03,  6.79856312e-05, -1.72601279e-03,
         3.22541920e-03, -3.79238953e-03,  2.97470088e-03,
         3.29636317e-03,  2.85559893e-03, -2.53352453e-03,
         1.17232057e-03, -2.52945902e-04,  1.13531027e-03,
         8.95218807e-04,  2.88759940e-03, -4.22311859e-04,
        -8.49805190e-04,  8.24010058e-04, -1.79419224e-03,
         2.18573911e-03,  3.82968597e-03, -6.61813142e-03,
         4.71078278e-03,  4.36334434e-04,  3.85793857e-03,
         1.25070754e-03,  6.07640157e-03,  2.50882143e-03,
         1.32955692e-03,  8.81674467e-04, -3.08032404e-03,
         3.07325134e-03],
       [ 1.90107571e-03,  4.53836145e-03, -3.99724068e-03,
        -1.10427267e-03,  1.84403780e-05, -2.94047128e-03,
         7.69302598e-04,  3.43412324e-03,  2.82691000e-03,
        -2.04126467e-03, -2.31264066e-03,  2.39656586e-03,
        -3.72470892e-03, -4.04381845e-03,  9.45937005e-04,
        -2.22597690e-03,  3.65464875e-05, -3.18753975e-03,
        -8.11343256e-04, -1.07361840e-04,  1.06285734e-03,
         3.23580764e-03,  2.06072628e-03,  3.08651943e-04,
         2.41394097e-04, -6.52150670e-03, -1.56327011e-03,
        -8.79864034e-04,  4.07827116e-04,  2.09568301e-03,
        -1.08050392e-03,  1.93783827e-03,  3.09521658e-03,
        -2.44083139e-03,  9.22788749e-04, -8.56638246e-04,
         2.36931723e-03,  1.55371567e-03, -2.05654278e-03,
        -1.99058419e-03],
       [-3.18244705e-03, -6.79762801e-04, -2.77865026e-03,
         1.07030279e-03,  4.33963072e-03, -3.85024655e-03,
         5.25813317e-04, -3.70236230e-04,  9.96330054e-04,
        -2.89971731e-03,  2.87282467e-03, -3.60495062e-03,
         8.24456860e-04, -4.14237007e-03, -5.44520481e-05,
        -2.48161203e-04,  4.09845816e-04, -2.87062814e-03,
         1.06694247e-03,  2.49756587e-04, -1.34878140e-03,
        -1.54036505e-03, -4.05278290e-04,  1.34351256e-03,
         8.27915501e-05, -5.53464191e-03, -4.34560049e-03,
        -3.65890912e-04, -1.73500634e-03,  3.42253805e-03,
         3.59565299e-03, -9.21530998e-04, -5.79417159e-04,
         4.25545964e-03, -2.49587651e-03,  3.03111318e-03,
         8.31670128e-04,  1.05498545e-03,  3.21087707e-03,
        -1.64601090e-03],
       [-2.43852381e-03,  5.60752291e-04,  1.28496526e-04,
        -2.09574518e-03, -7.22806435e-04, -1.81391463e-03,
         3.91954416e-03, -2.13574432e-03, -1.71478721e-03,
        -2.42966041e-03, -5.24726603e-03, -3.76305456e-04,
         1.07603311e-03,  7.10473454e-04,  1.17021776e-03,
        -9.35348915e-04,  2.02138792e-03,  2.10014102e-03,
         3.18095379e-04,  4.05154686e-04, -2.44750339e-03,
         8.43534013e-04,  1.92528835e-03, -2.17781495e-03,
         4.97328350e-04,  1.60327076e-03, -2.89585744e-03,
        -2.85264978e-04,  1.53212372e-04, -2.48682545e-03,
         1.49124966e-03, -2.67222337e-03, -2.92231911e-03,
         3.19950539e-03,  2.31195532e-04, -3.16828518e-05,
         5.38818073e-04,  6.27666595e-04, -2.01802142e-03,
         3.52555164e-03],
       [ 2.14111572e-03,  9.47653665e-04,  5.17476350e-04,
        -2.88666086e-03,  3.07411887e-03, -1.48870738e-03,
        -2.66918866e-03,  6.09121926e-04, -1.64709822e-03,
        -6.79627847e-05, -4.27281993e-05, -1.37574668e-03,
         8.39058426e-04,  3.43681755e-03, -1.16299524e-03,
        -2.06861368e-04,  1.55409973e-03,  1.91761751e-03,
        -1.79076567e-03, -3.64447641e-03, -6.46420056e-04,
         1.43766764e-03,  1.52329647e-03, -1.89405284e-04,
        -1.11050974e-03,  2.32580886e-03,  9.05790890e-04,
        -1.92644121e-03, -4.69643110e-03,  5.01899223e-04,
         9.82534955e-04,  9.64514154e-04,  1.68244762e-03,
         8.82033259e-04, -1.70221276e-04,  3.69604910e-04,
         1.54511072e-03, -2.27267155e-03,  5.93816396e-04,
         6.39647129e-04],
       [-3.61111510e-04, -7.31771346e-04, -2.86234805e-04,
         4.40812408e-04,  1.04878261e-03, -5.17032284e-04,
         1.79813523e-03, -1.83309952e-04,  1.20732852e-03,
        -4.80096438e-04, -2.32990063e-03, -3.77716671e-04,
         5.22408029e-03, -4.84745746e-04,  3.25329811e-03,
        -1.14979129e-03, -9.17562051e-04,  2.34235704e-04,
         3.73845804e-04,  1.26416504e-04,  2.13408330e-03,
         3.82699096e-03, -2.05421937e-03, -3.39867244e-03,
        -1.13913093e-05, -2.79983156e-04,  4.34944173e-03,
         2.11896884e-04,  3.03692953e-03,  1.78300217e-03,
         1.64653652e-03,  3.16216471e-03, -1.95747288e-03,
         1.73493312e-03, -2.51975143e-03,  1.00385991e-03,
         2.13643900e-04, -1.36496045e-03,  1.94758561e-03,
         5.87032409e-05],
       [-2.12299265e-03,  4.10505745e-04, -1.07119842e-04,
        -1.39310013e-03,  9.63365528e-06, -2.18489859e-03,
         3.50812590e-03, -1.61219749e-03, -1.50553335e-03,
        -2.21948605e-03, -5.15700737e-03, -1.74635570e-04,
         1.95508101e-03, -8.38729029e-05,  9.66111955e-04,
        -1.16703399e-04,  2.28117220e-03,  3.61353671e-03,
         3.31726420e-04, -5.27636672e-04, -1.83131651e-03,
         1.26180088e-03,  2.28257291e-03, -2.28612288e-03,
         1.30875502e-03,  1.54203479e-03, -3.35786911e-03,
         1.70435131e-04, -1.73345045e-03, -3.64697329e-03,
         2.74222461e-03, -5.39644714e-03, -2.29294715e-03,
         4.52856161e-03, -2.86478928e-04, -4.04971506e-04,
         3.03767854e-04,  1.41416374e-03, -2.23550294e-03,
         4.88492055e-03],
       [ 2.16025999e-03,  4.10865410e-04,  1.74718595e-03,
        -2.49401620e-03,  5.12065506e-03, -1.24112342e-03,
        -5.05203893e-03,  1.69750105e-03, -2.85527366e-03,
         8.45913135e-04, -6.98547869e-04, -2.64813803e-04,
         3.01620970e-03,  4.42940835e-03, -7.94977415e-03,
         1.63522060e-03,  1.42873824e-03,  3.65634519e-03,
        -1.94364123e-03,  5.36897860e-04, -3.17446981e-03,
        -1.95702305e-03,  7.21242570e-04, -5.16019110e-03,
         7.43334554e-03, -3.66370333e-03,  4.99292416e-03,
        -3.93501436e-03, -7.41431490e-03, -3.82759934e-03,
        -1.11527916e-03,  4.33300994e-03, -7.60770563e-05,
        -3.55137349e-03,  2.03737151e-03,  7.39103183e-03,
         2.10207189e-03, -7.30293710e-03, -1.69844727e-03,
         3.51793435e-03],
       [ 2.64873059e-04, -3.01162334e-04, -3.72398441e-04,
         2.09239690e-04, -9.57590761e-04,  7.41183874e-04,
         1.35954574e-03, -8.27992044e-04,  1.56911358e-03,
        -1.10371642e-04,  6.08901551e-04,  1.31760468e-03,
         7.21568707e-04,  7.76496832e-04,  5.69090014e-03,
        -2.59364722e-03, -1.15784036e-03, -8.78818799e-04,
        -4.35704686e-04, -7.04733364e-04,  2.20845430e-03,
         3.12072341e-03, -2.22294871e-03, -2.07156572e-03,
        -1.46159192e-03,  1.06912653e-03,  1.10312784e-03,
         1.23001542e-03,  2.92477617e-03,  2.70410255e-03,
         2.42643850e-03,  1.35371997e-03, -6.95042952e-04,
        -1.28973497e-03, -3.71695217e-03,  1.26927288e-03,
         5.71285258e-04, -1.93238526e-03,  1.70647691e-03,
        -1.63244817e-03],
       [-1.69967767e-03,  4.50339983e-04, -1.42471108e-04,
        -6.89805136e-04,  1.83417942e-04, -1.70889089e-03,
         2.96749990e-03, -1.13729981e-03, -8.93714954e-04,
        -1.91792904e-03, -4.20214981e-03,  1.43588128e-04,
         1.99445826e-03, -5.06133598e-04,  3.47277848e-04,
         4.37136216e-04,  2.56443000e-03,  3.79233458e-03,
         2.70737277e-04, -1.02615124e-03, -1.46466517e-03,
         1.54288230e-03,  1.53015309e-03, -1.30369642e-03,
         1.77147752e-03,  9.03539767e-04, -2.88914540e-03,
         7.00613426e-04, -2.43624905e-03, -2.70786928e-03,
         2.19090260e-03, -5.43568237e-03, -2.26281304e-03,
         1.79208722e-03, -3.73226532e-04, -3.76783573e-04,
        -1.36451345e-04,  2.15491303e-03, -2.98617501e-03,
         2.09847023e-03],
       [ 1.96208083e-03,  6.73552349e-05,  2.14919215e-03,
        -1.85737002e-03,  5.22572501e-03, -1.19281793e-03,
        -5.31215454e-03,  1.37439661e-03, -2.61696940e-03,
         9.74141993e-04,  3.26509238e-04, -9.58511373e-05,
         3.61999916e-03,  4.34353715e-03, -8.11611302e-03,
         2.70695076e-03,  1.59632054e-03,  3.42128007e-03,
        -2.11228486e-04,  1.54271908e-03, -3.59214866e-03,
        -2.44114548e-03, -1.99674722e-03, -3.04876128e-03,
         6.82146661e-03, -5.91346202e-03,  5.39776310e-03,
        -2.58722273e-03, -3.61571065e-03, -4.81802563e-04,
        -8.26340867e-04,  2.02830136e-03,  1.12884981e-03,
        -5.45174023e-03,  1.72825379e-03,  3.69453919e-03,
         3.76326474e-03, -4.05052770e-03,  2.36503780e-04,
         1.03300915e-03],
       [ 8.97210848e-04,  1.10080248e-06, -3.36029334e-04,
        -3.08373623e-04, -1.68165949e-03,  1.91260292e-03,
         3.08690214e-04, -6.61600439e-04,  1.01105520e-03,
         2.20085349e-04,  2.62818742e-03,  2.56615528e-03,
        -1.63957267e-03,  2.00981484e-03,  4.47860314e-03,
        -2.61659757e-03, -1.37609651e-03, -2.87519419e-04,
        -7.85001146e-04, -9.47246968e-04,  1.42687804e-03,
         1.02819642e-03, -1.11252011e-03, -3.44504183e-03,
         1.53010129e-03,  9.34324809e-04,  4.48973355e-04,
        -3.79527453e-04,  3.81825463e-04,  1.49939104e-03,
         1.98718277e-03,  1.16506638e-03, -1.43968430e-03,
        -3.84231121e-03, -3.81742674e-03,  3.91113199e-03,
         2.07389193e-03, -4.59163077e-03,  2.10341357e-04,
         1.66096128e-04],
       [-1.25328486e-03,  3.46937624e-04, -2.16074535e-04,
        -3.64944106e-04,  2.42881360e-04, -9.13870579e-04,
         2.52169673e-03, -6.13853452e-04, -7.08769250e-04,
        -1.57385331e-03, -3.38798179e-03,  2.76908686e-04,
         1.63214118e-03, -6.62924605e-04,  6.21038140e-04,
         3.25492932e-04,  2.13632151e-03,  3.43016209e-03,
         9.63896047e-04, -1.23766740e-03, -1.27721124e-03,
         1.00653851e-03,  1.47619471e-03, -1.51047437e-03,
         1.77684252e-03,  9.32846102e-04, -3.05293873e-03,
         1.16058136e-03, -2.01753620e-03, -1.64490007e-03,
         2.00042268e-03, -4.65004053e-03, -2.25731614e-03,
         5.92178723e-04, -9.19361773e-04,  2.60162778e-05,
        -3.01788590e-04,  1.26937043e-03, -2.72719213e-03,
         1.04038743e-03],
       [ 1.90249004e-03, -2.12787316e-04,  2.23428919e-03,
        -1.67212775e-03,  5.34515269e-03, -5.58579806e-04,
        -5.49556455e-03,  1.26989733e-03, -2.04827893e-03,
         4.63341654e-04,  5.28167184e-05,  5.30002464e-04,
         3.58566991e-03,  5.67365950e-03, -6.91837771e-03,
         3.90836177e-03,  1.76026963e-03,  4.62124450e-03,
         2.67249928e-03,  3.79366591e-03, -4.64519905e-03,
        -3.75160458e-03, -1.68063561e-03, -3.24703986e-03,
         4.93770000e-03, -7.30976323e-03,  2.26308941e-03,
         1.91502724e-04, -1.87899487e-03, -3.31468873e-05,
         2.27687228e-03,  5.98255661e-04,  8.64269823e-05,
        -6.19067997e-03, -1.91699946e-03,  1.74411468e-03,
         6.31998386e-03, -1.55107211e-03,  2.81043584e-03,
         5.38521417e-05],
       [ 1.37673540e-03,  1.33041802e-04, -2.24103103e-04,
        -3.66874912e-04, -1.97228091e-03,  2.45745108e-03,
        -4.94911510e-04, -4.63506265e-04,  4.11826128e-04,
         1.20991033e-04,  3.71840131e-03,  3.09602893e-03,
        -2.56227842e-03,  3.02548404e-03,  3.76921962e-03,
        -2.29941099e-03, -1.28756906e-03,  3.69672889e-05,
        -7.83392461e-04, -7.03268568e-04,  1.06462056e-03,
        -7.88669218e-04, -1.11922959e-03, -4.36515966e-03,
         3.49580613e-03, -8.31245678e-04,  9.60998179e-04,
        -1.11094606e-03, -3.96862524e-05, -5.64243936e-04,
         9.89308348e-04,  1.66352442e-03, -5.99601539e-04,
        -4.37293481e-03, -1.57553249e-03,  4.65538912e-03,
         3.09880520e-03, -4.56141355e-03,  4.46165446e-04,
         1.39150606e-03],
       [-8.24255461e-04,  3.95634910e-04, -2.51362653e-04,
        -2.20711343e-04,  1.81714480e-04, -5.80084103e-04,
         2.08284124e-03, -2.78192922e-04, -4.77181951e-04,
        -1.05530664e-03, -2.70054187e-03,  5.34798775e-04,
         1.42414880e-03, -7.56060705e-04,  3.11022479e-04,
         4.33794252e-04,  1.47067092e-03,  2.89305672e-03,
         1.25445274e-03, -1.53959205e-03, -9.74208815e-04,
         1.08951773e-03,  1.33445743e-03, -1.38828205e-03,
         1.49342162e-03,  1.04547257e-03, -2.88889953e-03,
         1.15385849e-03, -1.65509363e-03, -3.91341135e-04,
         1.39091443e-03, -2.54565617e-03, -2.53098249e-03,
        -5.07074408e-04, -1.66867627e-03,  6.79366116e-04,
        -1.33460062e-03,  1.28113708e-04, -2.83462717e-03,
        -5.59689826e-04],
       [ 1.99805875e-03, -3.83306091e-04,  2.13589706e-03,
        -1.75086665e-03,  5.31515619e-03, -6.99498705e-05,
        -5.14565781e-03,  1.10609445e-03, -1.51863787e-03,
         5.93069184e-04,  8.29370620e-05,  7.27389357e-04,
         3.80827533e-03,  5.80139272e-03, -6.44564629e-03,
         4.09156736e-03,  7.86652730e-04,  4.23880806e-03,
         3.81624792e-03,  4.28940170e-03, -3.79211083e-03,
        -3.47387209e-03, -5.16241707e-04, -3.01254960e-03,
         2.88501824e-03, -8.08099937e-03, -1.13972963e-03,
         2.95062643e-03,  3.96239600e-04,  4.64170880e-04,
         1.52958801e-03,  1.39361713e-03, -1.67561288e-03,
        -5.62015548e-03, -3.37646995e-03,  2.41387854e-04,
         5.23909042e-03, -1.08939108e-04,  4.69133398e-03,
         1.13814262e-04],
       [ 1.80482294e-03,  1.09559514e-04, -2.30170379e-04,
        -5.18465182e-04, -1.98399392e-03,  3.10650794e-03,
        -1.09291356e-03, -3.35477205e-04,  4.69567633e-04,
        -2.27420722e-04,  4.39997716e-03,  3.36540304e-03,
        -2.92637851e-03,  3.70792439e-03,  3.17505351e-03,
        -1.48624496e-03, -1.14517671e-03,  8.00424197e-04,
        -2.53611885e-04, -8.52835481e-04,  1.19633437e-03,
        -2.58152536e-03, -1.80226960e-03, -4.48198151e-03,
         5.04596485e-03, -1.72473164e-03,  1.06026826e-03,
        -1.57248590e-03, -2.91412725e-04, -8.70136078e-04,
         3.04945454e-04,  1.71235704e-03,  1.20859407e-03,
        -5.03407000e-03, -1.30006857e-03,  3.85359558e-03,
         3.92035348e-03, -4.92726685e-03, -1.49148545e-04,
         2.48989579e-03],
       [ 7.07754982e-04, -3.35715267e-05,  4.68467588e-05,
         3.92373215e-04,  8.43503221e-05, -1.25334336e-04,
        -1.27196836e-03,  1.38863642e-03,  5.06403776e-05,
         1.86667719e-03,  7.35073641e-04,  1.17186585e-03,
        -5.09185193e-04, -1.13201153e-03, -2.91587839e-05,
        -5.00954455e-04, -2.52009515e-04, -4.95298373e-05,
        -6.98753458e-04, -6.61016384e-04, -1.33621274e-04,
         5.86837647e-04, -3.09368107e-03, -7.94894819e-04,
        -2.04328634e-03,  9.18800506e-05,  4.52148583e-04,
        -2.19778484e-03,  3.68562341e-03,  3.80915968e-04,
        -4.05827159e-04,  3.14667099e-03, -1.14361661e-04,
        -1.18810660e-03,  1.68580518e-05,  1.23616471e-03,
        -2.32733856e-03, -2.51490681e-04, -1.62822334e-03,
        -1.60561665e-03],
       [ 2.00243946e-03, -2.50489131e-04,  2.05982919e-03,
        -1.86940609e-03,  5.57084661e-03,  6.84233673e-04,
        -3.95531207e-03,  1.86874927e-03, -1.23340427e-03,
         2.57265661e-03, -3.23134824e-04,  2.12755054e-03,
         3.06041818e-03,  5.64680295e-03, -5.68302302e-03,
         2.66642752e-03,  3.74199124e-03,  1.39902893e-03,
         2.17563775e-03,  6.28324226e-03, -3.99674941e-03,
        -2.00630957e-03, -4.52466949e-04, -3.90758878e-03,
         5.41411759e-03, -4.91702696e-03,  6.98932738e-04,
         2.95002223e-03,  4.86271083e-03, -1.72532536e-03,
         1.21644244e-03, -2.85302568e-03, -3.81893781e-03,
        -4.89927130e-03,  5.40775771e-04, -1.34850023e-04,
         2.51636584e-03,  6.79723278e-04,  1.91520131e-03,
         3.53585999e-03],
       [ 1.86509243e-03,  1.56830793e-04, -2.56864994e-04,
        -7.56606925e-04, -1.75336795e-03,  3.49661685e-03,
        -1.12914899e-03, -3.11455049e-04,  3.44545057e-04,
        -1.45066340e-04,  4.87272162e-03,  3.05502187e-03,
        -3.70548689e-03,  4.13078908e-03,  1.98007724e-03,
        -1.48849934e-03, -1.74335175e-04, -5.86669135e-04,
         4.33387264e-04, -7.88177596e-04,  1.03490648e-03,
        -4.83063143e-03, -2.38000241e-04, -3.56376846e-03,
         4.27214196e-03, -1.31795136e-03,  7.02215999e-04,
        -2.20992626e-03,  9.77607910e-04, -2.07240134e-03,
        -1.31475565e-03,  3.46303830e-04,  7.22615514e-04,
        -3.49770882e-03, -1.69826162e-04,  2.77393684e-03,
         3.42984078e-03, -6.55764854e-03, -1.13916121e-05,
         2.29880726e-03],
       [ 1.18151028e-03, -1.48906314e-04,  3.10540963e-06,
         6.12857635e-04,  1.52943292e-04,  3.05356865e-04,
        -2.06058496e-03,  1.71973510e-03,  4.38864226e-04,
         2.32408778e-03,  1.65072980e-03,  1.70089165e-03,
        -9.12428601e-04, -1.04190595e-03, -1.82770600e-05,
        -2.47113145e-04, -9.20157006e-04, -5.19460184e-04,
        -7.49372877e-04, -6.89592678e-04, -5.57019048e-05,
         1.10308477e-03, -3.06574511e-03, -1.10489212e-03,
        -1.65797619e-03, -1.96538909e-04,  1.22033712e-03,
        -1.52677950e-03,  4.88294940e-03,  1.51965208e-03,
        -4.99238013e-05,  4.96819569e-03, -4.27000487e-04,
        -1.92555273e-03,  6.65761414e-04,  1.26478635e-03,
        -2.25808006e-03, -1.26606872e-04, -2.34067021e-03,
        -1.39772356e-03],
       [ 1.78070820e-03, -2.40536989e-04,  2.50622071e-03,
        -1.46654749e-03,  5.75728063e-03,  1.66654849e-04,
        -4.17129183e-03,  1.95992761e-03, -2.26831040e-03,
         3.46518471e-03, -6.45188848e-04,  1.86592294e-03,
         2.64961063e-03,  4.56080120e-03, -5.91488834e-03,
         2.07823282e-03,  5.37073426e-03, -7.79487076e-04,
        -8.70248041e-05,  6.08201372e-03, -3.59195960e-03,
        -1.94782007e-03, -1.99491996e-03, -4.91312100e-03,
         6.84358645e-03, -4.24925238e-03,  2.19006022e-03,
         8.25213967e-04,  4.19741636e-03, -2.92247790e-03,
         7.09933694e-04, -3.53335752e-03, -2.16169306e-03,
        -4.86861961e-03, -2.45379546e-04,  4.63125943e-05,
         2.87400768e-03,  6.80477096e-05,  5.17923909e-04,
         2.64499523e-03],
       [ 1.44303788e-03,  5.22252776e-05, -1.53311063e-04,
        -6.47579611e-04, -1.75759406e-03,  2.49758898e-03,
        -7.01066863e-04, -5.59930690e-04,  3.22609412e-04,
        -2.20150177e-05,  4.38291579e-03,  2.06952728e-03,
        -3.24950553e-03,  3.93337710e-03,  2.22720276e-03,
        -1.53953151e-03, -1.15169038e-03, -1.27742160e-03,
         6.15591242e-04, -1.04514416e-03,  4.77244874e-04,
        -4.10064356e-03,  9.03722481e-04, -2.82363431e-03,
         2.11410201e-03, -8.38294683e-04, -2.02484924e-04,
        -2.22799135e-03,  1.46002695e-03, -3.57136573e-03,
        -1.34152756e-03,  8.83224362e-04, -1.35106980e-04,
        -3.79323866e-03, -6.67698507e-04,  2.72475160e-03,
         2.60135089e-03, -6.15292275e-03,  6.22771622e-04,
         1.56792218e-03],
       [ 1.68713136e-03, -1.88642909e-04,  3.55683696e-05,
         9.12959978e-04,  1.75057736e-04,  9.39413148e-04,
        -2.62113335e-03,  1.97955710e-03,  8.14515981e-04,
         2.47051590e-03,  2.60629039e-03,  1.40655192e-03,
        -1.10222376e-03, -1.36259838e-03,  3.82052094e-04,
        -1.68587125e-04, -9.04430635e-04, -1.42173551e-03,
        -4.09431377e-04, -1.43947860e-03, -3.78970901e-04,
         3.51085095e-04, -3.28547740e-03, -3.85145453e-04,
        -8.31157551e-04, -4.28830244e-04,  1.84168364e-03,
        -1.63084769e-03,  5.72003983e-03,  2.20004865e-03,
        -3.91529378e-04,  6.49290998e-03, -7.33725843e-04,
        -2.44388776e-03,  3.00358748e-04,  1.18417910e-03,
        -1.13375194e-03, -8.67731520e-04, -1.42779073e-03,
        -1.86041137e-03],
       [ 1.67675223e-03,  2.54329243e-05,  2.37426930e-03,
        -1.33584056e-03,  5.61836688e-03, -3.95112438e-05,
        -3.97094153e-03,  2.24444433e-03, -2.42462428e-03,
         3.68326926e-03, -1.04751275e-03,  2.12282035e-03,
         2.57783639e-03,  2.91554467e-03, -7.09597580e-03,
         8.23191425e-04,  4.74186800e-03, -1.66146189e-03,
        -2.47231429e-03,  5.22753410e-03, -2.46421690e-03,
        -2.31265323e-04, -2.63094716e-03, -6.17363164e-03,
         9.23109520e-03, -3.38922488e-03,  4.86962590e-03,
        -1.55615399e-03,  3.95822618e-03, -4.59115114e-03,
        -3.65492981e-03, -1.58698484e-03, -2.93702073e-03,
        -6.12753443e-03,  1.61852935e-04,  3.38113611e-03,
         1.45047670e-04, -1.43864832e-03, -3.08139715e-03,
         3.93324532e-03],
       [ 9.91415465e-04, -2.34373529e-05, -1.77756709e-04,
        -5.28073579e-04, -1.65015308e-03,  1.58753176e-03,
        -4.14834503e-05, -7.94731663e-04,  6.32880488e-04,
         1.37941999e-04,  3.65435611e-03,  9.82356025e-04,
        -2.35561980e-03,  3.40950442e-03,  2.73710908e-03,
        -1.64229935e-03, -2.00897991e-03, -1.45591120e-03,
         7.42487493e-04, -1.46574643e-03,  6.25631656e-04,
        -3.70764337e-03,  9.88860265e-04, -1.48888410e-03,
        -5.00024355e-04, -5.75883780e-04, -1.19176705e-03,
        -1.77976652e-03,  1.87053182e-03, -2.65053241e-03,
        -6.79685094e-04,  1.45548466e-03, -6.69507062e-05,
        -2.85280193e-03, -1.02895871e-03,  1.99242146e-03,
         1.78046466e-03, -4.34090430e-03,  1.27642287e-03,
         2.02012438e-04],
       [ 2.11048196e-03, -2.30536112e-04,  4.95155364e-05,
         1.46853679e-03,  2.87225615e-04,  1.43066817e-03,
        -3.40465130e-03,  1.99915678e-03,  1.12529041e-03,
         2.68172333e-03,  3.82542494e-03,  1.01717340e-03,
        -1.40638393e-03, -1.46707753e-03, -3.48623405e-04,
         3.63039493e-04, -7.33172114e-04, -2.32892018e-03,
        -7.18206109e-04, -1.48612377e-03,  7.02391935e-06,
         4.01474361e-04, -4.22113854e-03,  1.94758599e-04,
        -1.15985633e-03, -1.50731986e-03,  2.47307681e-03,
        -1.28781318e-03,  5.88639500e-03,  1.88257289e-03,
        -4.77645604e-04,  6.88206963e-03, -1.65103978e-04,
        -4.36647143e-03,  5.21384391e-05,  4.40397678e-04,
        -2.20330385e-03,  7.87696990e-05, -4.42438177e-04,
        -2.81945453e-03],
       [ 1.77667465e-03,  4.10243811e-04,  2.10570847e-03,
        -1.94230839e-03,  5.25847403e-03, -5.65232884e-04,
        -3.53090838e-03,  2.19106884e-03, -2.47830641e-03,
         3.65018775e-03, -1.38708251e-03,  2.61344877e-03,
         2.33857404e-03,  2.63392297e-03, -6.16036588e-03,
        -3.76097101e-04,  4.38969256e-03, -2.01360928e-03,
        -4.82535968e-03,  4.40931553e-03, -1.11197692e-03,
         5.44767128e-04, -1.65648293e-04, -7.96016864e-03,
         1.10526690e-02, -2.84776557e-03,  2.34983838e-03,
        -3.82270524e-03,  7.05884944e-04, -6.93365512e-03,
        -6.02174783e-03,  4.71428939e-04, -1.31453259e-03,
        -4.27208049e-03, -8.94970028e-04,  6.60575740e-03,
        -1.77156902e-03, -3.44837131e-03, -7.68563570e-03,
         4.56636073e-03],
       [ 3.83053499e-04, -3.33548116e-04, -2.47251592e-04,
        -2.56612606e-04, -1.05576473e-03,  5.12285507e-04,
         1.18333357e-03, -5.76072664e-04,  7.67555728e-04,
         1.94394466e-04,  1.91636430e-03, -1.50124845e-03,
        -2.09689315e-04,  2.72748247e-03,  3.54574900e-03,
        -1.81974273e-03, -2.82090320e-03, -1.56629737e-03,
         7.39697483e-04, -1.79877062e-03,  8.55661230e-04,
        -3.50033538e-03,  6.05715497e-04,  5.56787942e-04,
        -3.94757930e-03, -1.68545893e-03, -5.57093590e-04,
        -2.66441057e-04,  2.36854772e-03, -2.70761363e-03,
        -8.58280400e-04,  1.66260905e-03,  1.02392177e-03,
        -1.02338230e-03, -1.66437088e-03,  3.63906962e-04,
        -7.26542901e-04,  1.56711889e-04,  4.45000408e-03,
        -1.55518122e-03],
       [ 2.40506232e-03, -4.07203624e-04,  3.23083586e-05,
         1.96237187e-03,  8.44716560e-04,  1.02551561e-03,
        -3.97375645e-03,  1.74072350e-03,  1.69284304e-03,
         2.46519665e-03,  4.18826612e-03,  1.06263091e-03,
        -7.42365839e-04, -1.83198112e-03, -6.01219304e-04,
         1.03903667e-03, -5.05834993e-04, -2.38919980e-03,
        -1.02041091e-03, -1.22438150e-03,  8.76724429e-04,
         8.06773605e-04, -2.95357709e-03,  7.83578958e-04,
        -8.88877548e-04, -2.08510156e-03,  1.74828526e-03,
        -1.48590840e-03,  4.11057845e-03,  4.11945832e-04,
         3.70689842e-04,  4.65134904e-03, -3.26239351e-05,
        -3.66616133e-03, -5.51845646e-04,  5.60928856e-05,
        -2.38332478e-03,  1.17111404e-03, -3.24787601e-04,
        -2.63956003e-03],
       [ 1.84151996e-03,  9.76162381e-04,  5.70833101e-04,
        -2.25015264e-03,  2.92246300e-03, -6.81245350e-04,
        -1.60195376e-03,  9.32955823e-04, -1.32305035e-03,
         1.59639411e-03, -2.01901793e-03,  6.58217294e-04,
         3.59327445e-04,  7.15380243e-04,  5.92661381e-04,
        -2.90265866e-03,  2.99327588e-03, -2.01260205e-03,
        -4.36001504e-03, -2.70159158e-04,  2.44471524e-03,
         2.79326551e-03,  3.20940930e-03, -1.29095779e-03,
         2.51534954e-03,  2.30758241e-03, -8.43212183e-04,
        -2.15396378e-03,  1.25695264e-03, -2.46867258e-03,
        -1.73405721e-03, -3.39959341e-04,  1.62223866e-03,
         2.41153804e-03, -6.98418415e-04,  3.35477554e-04,
        -2.99601769e-03,  2.62834108e-03, -1.83597312e-03,
         1.02505030e-03],
       [-4.11734771e-04, -7.96797045e-04, -1.59516858e-04,
        -1.16909752e-04,  9.59242985e-04, -1.00247725e-03,
         1.92951015e-03,  8.08914410e-05,  5.04624739e-04,
         3.64740350e-04, -7.63327698e-04, -3.50182364e-03,
         4.19255439e-03,  1.88711693e-03,  1.31969654e-03,
        -6.45392051e-04, -2.41441838e-03, -9.89626045e-04,
         1.04739855e-03, -2.31287151e-04,  1.83572457e-03,
        -4.94398689e-03,  1.64477574e-03,  5.49609540e-04,
        -1.83547521e-03, -3.02783563e-03,  7.65931851e-04,
        -4.79139300e-04,  1.76336197e-03, -4.03182255e-03,
        -3.48910433e-03,  3.95277515e-03,  2.09993962e-03,
         1.06111591e-04, -7.04766717e-04,  1.99148082e-04,
        -1.70323462e-03,  2.21566018e-03,  1.67537935e-03,
        -6.13603392e-04],
       [-1.77398746e-04,  2.04252647e-04, -1.08604043e-04,
        -2.14739470e-04,  3.09287570e-04, -1.49247498e-04,
         3.65003303e-04,  3.48070927e-04, -5.55546421e-06,
        -1.30695043e-04, -2.38506618e-04, -5.69905504e-04,
         4.54446505e-04, -6.90948509e-05,  1.35075697e-05,
        -2.03009462e-03, -2.41907983e-04,  8.43392801e-04,
        -2.31189444e-03, -6.08278962e-04,  1.71365828e-05,
        -1.73490762e-03,  9.36938959e-05, -1.04149955e-03,
         8.34500242e-04, -2.07248260e-04, -3.69987357e-03,
         1.82290139e-04,  1.50817586e-03, -1.07280066e-04,
        -1.69064966e-03, -2.40461930e-04,  2.71028234e-03,
        -9.43303981e-04, -3.87334410e-04,  1.51874311e-03,
        -1.10765337e-04,  2.78209802e-03,  3.51874303e-04,
        -1.71666557e-03],
       [ 2.02125427e-03, -6.15772733e-04,  1.08346937e-03,
        -2.00938713e-03,  1.47983874e-03,  2.11261190e-03,
        -7.13662128e-04, -4.51796048e-04,  1.15136689e-04,
        -5.32601262e-04,  1.53273251e-03, -3.04912654e-04,
         2.24048342e-03, -4.00364399e-04,  4.24583768e-03,
        -1.47155253e-03, -3.44092492e-03,  9.48415778e-04,
         8.00664723e-03,  5.00210188e-03,  9.04222019e-04,
         3.50907183e-04, -5.32832183e-03,  1.28477241e-03,
        -6.77070348e-04, -4.55602352e-03, -2.89314450e-03,
         1.48841145e-03,  2.85218097e-03, -4.64077946e-03,
        -2.28154892e-03,  3.69279203e-03,  2.09220196e-03,
         2.65703024e-03, -2.17276346e-03,  1.89760712e-03,
        -1.10696501e-03, -4.39267699e-03,  1.49526261e-03,
        -1.44094659e-03],
       [ 1.20363338e-03, -1.74526824e-04,  6.44582178e-05,
        -8.57639359e-04, -3.35858134e-03,  4.54339478e-03,
        -2.99010752e-03, -7.19059899e-04, -2.37972080e-03,
        -3.53735709e-03,  3.84320063e-03,  3.86879290e-03,
        -3.62170301e-03,  1.58305652e-03,  4.10199910e-03,
         2.08915281e-03,  6.25738176e-03,  5.87847142e-04,
         3.10941716e-03,  2.76738108e-04, -5.27710945e-04,
         1.24914222e-03, -1.53621368e-03,  5.30975685e-03,
         5.43867471e-03, -1.21860229e-03, -3.27161700e-03,
         5.36487950e-03, -7.65079807e-04, -3.28306895e-04,
        -2.61383271e-03,  2.19879416e-03,  3.07157007e-03,
         6.62095193e-03, -3.02431872e-03,  4.86527686e-04,
        -5.85939270e-03,  1.62177731e-03, -4.79890819e-04,
        -3.35747004e-03],
       [-2.33058978e-04,  2.30252146e-04,  9.48203306e-05,
        -1.59020041e-04,  3.67975648e-04, -1.50927394e-06,
         2.03410818e-05,  2.86373339e-04,  2.67295167e-04,
        -2.15095235e-04,  5.68933436e-04, -9.24666179e-04,
         8.18418994e-05,  6.82760845e-04, -5.96528756e-04,
        -2.91762268e-03,  3.08353570e-04, -6.56053235e-05,
        -2.86795897e-03,  3.10139061e-04, -6.20051360e-05,
        -3.95890279e-03,  7.66779645e-04, -6.40365295e-04,
         2.22515757e-03, -1.04805862e-04, -4.51049767e-03,
         2.26976792e-03,  1.27705501e-03,  5.35017578e-04,
        -3.42861912e-03, -1.24137336e-03,  5.94238797e-03,
         1.64282788e-03, -1.24499679e-03,  3.90038267e-03,
         2.65431544e-03,  5.78947365e-03,  3.86302196e-03,
        -4.26422106e-03],
       [ 1.56836316e-03, -7.62297597e-04,  8.37068539e-04,
        -1.67035672e-03,  6.24365290e-04,  1.81085232e-03,
         4.98806417e-04, -1.34677545e-03,  2.82983150e-04,
        -1.01253111e-03,  1.99605455e-03,  6.31050614e-04,
         1.46561000e-03, -2.66247871e-03,  4.33287211e-03,
        -1.20838510e-03, -4.60079359e-03,  2.26808572e-03,
         7.35565880e-03,  6.37989677e-03,  1.74970657e-03,
         4.32568195e-04, -6.95742620e-03, -6.54714313e-06,
        -1.57719117e-03, -3.70336906e-03, -2.81848013e-03,
         5.61206311e-04,  1.97155474e-04, -3.83489649e-03,
        -2.04099226e-03,  1.79606467e-03,  2.67894263e-03,
        -3.86510801e-04, -5.79618989e-03,  1.70392718e-03,
        -2.87113432e-03, -2.16877833e-03, -3.22074350e-03,
         3.50438582e-04],
       [ 1.69352361e-03, -1.90224760e-04,  3.65966524e-04,
        -1.14394049e-03, -2.85849953e-03,  4.66186181e-03,
        -3.88513575e-03, -7.20217649e-04, -4.75292047e-03,
        -5.85012138e-03,  3.78346280e-03,  3.97343747e-03,
        -1.15203718e-03,  6.06996357e-04,  4.93567344e-03,
         4.03352501e-03,  9.07537155e-03,  2.01086537e-03,
         5.30919898e-03,  1.13079026e-04,  3.45455192e-04,
         9.17705998e-04, -7.37739436e-04,  7.42981769e-03,
         5.86860860e-03, -5.82845788e-03, -5.11603011e-03,
         8.80454015e-03,  2.86164484e-03, -4.02155740e-04,
        -2.66000861e-03,  5.83999138e-03,  1.01974554e-04,
         1.06970379e-02, -1.45465916e-03,  2.54836446e-03,
        -7.29265483e-03,  4.81866160e-03,  1.96245918e-03,
        -3.27386870e-03],
       [-2.19918147e-04,  1.54169393e-04,  1.33325724e-04,
        -1.61261240e-04,  2.74039718e-04,  7.08547668e-06,
        -1.62937329e-04,  3.71927657e-04,  4.80282062e-04,
        -3.00432584e-04,  1.36249361e-03, -1.32123625e-03,
        -7.19885356e-05,  1.02430850e-03, -9.07895039e-04,
        -3.35780950e-03,  2.48410215e-04, -6.72656577e-04,
        -3.18606035e-03,  1.59344985e-03, -1.16491174e-04,
        -4.88600740e-03,  6.99944852e-04, -2.20825692e-04,
         2.85830558e-03, -4.05143626e-04, -4.83284565e-03,
         3.29024135e-03,  3.20200867e-04,  5.78452426e-04,
        -3.79275088e-03, -7.18371477e-04,  7.99360499e-03,
         3.17344908e-03, -2.58663291e-04,  5.42027131e-03,
         3.66944983e-03,  7.06571713e-03,  5.46673872e-03,
        -5.59910014e-03],
       [ 7.57730915e-04, -8.57943262e-04,  4.61079355e-04,
        -8.94797733e-04, -1.66846599e-04,  7.99654663e-05,
         1.83617603e-03, -1.61789008e-03,  4.77286143e-04,
         1.89516519e-04,  1.67675619e-03,  1.31739443e-03,
         3.34064855e-04, -4.68047243e-03,  2.24339636e-03,
        -5.79632062e-04, -6.47305045e-03,  3.39607475e-03,
         6.08423911e-03,  8.94644391e-03,  1.79221109e-03,
         1.99900288e-03, -7.34732440e-03, -2.36669695e-03,
        -3.97993578e-03, -1.18990347e-03, -1.67730660e-03,
        -9.73472837e-04, -1.14036561e-03, -1.27532100e-03,
         5.48699114e-04,  1.51661865e-04,  4.61606821e-03,
        -7.58997723e-03, -7.33657833e-03,  5.43743430e-04,
        -1.46352942e-03,  9.62304694e-05, -6.92130858e-03,
         4.45427140e-03],
       [ 2.11254810e-03,  1.10764980e-04,  4.48278850e-04,
        -1.59075973e-03, -2.84577254e-03,  4.76330519e-03,
        -3.70120793e-03, -9.31412855e-04, -6.37761923e-03,
        -6.34470396e-03,  2.88328109e-03,  4.04362986e-03,
        -5.71713725e-04, -9.15132114e-04,  5.87563450e-03,
         3.79197462e-03,  8.04364774e-03,  2.40772963e-03,
         7.55840028e-03,  1.88658858e-04,  3.84922442e-03,
         2.28014658e-03, -2.28622439e-03,  6.40875008e-03,
         4.45334520e-03, -7.43825082e-03, -5.00718877e-03,
         8.65072571e-03,  4.09214944e-03, -1.10236392e-03,
        -1.75331126e-03,  7.26638222e-03, -2.31727539e-03,
         1.12333344e-02,  1.13142643e-03,  4.58046841e-03,
        -5.94482012e-03,  4.67944704e-03,  1.93446351e-03,
        -1.81945355e-03],
       [-2.36456195e-04,  1.37673647e-04,  1.10173474e-04,
        -1.58284776e-04,  2.56312691e-04, -3.28619535e-05,
        -1.55518137e-04,  2.64232309e-04,  4.90768056e-04,
        -2.42913258e-04,  1.27729075e-03, -1.42067822e-03,
        -2.40194466e-04,  8.84055858e-04, -1.01329619e-03,
        -3.02636414e-03,  2.03244344e-04, -8.15903477e-04,
        -3.12157790e-03,  1.53582508e-03, -3.72105598e-04,
        -4.73375898e-03,  5.39338449e-04, -4.48861538e-04,
         2.30350136e-03, -4.12002031e-04, -4.42936365e-03,
         3.13707744e-03,  1.84341989e-04,  8.46727286e-04,
        -3.51093337e-03, -3.18516599e-04,  7.95727875e-03,
         3.35250562e-03,  2.00428913e-04,  5.11575211e-03,
         3.65711865e-03,  6.19557267e-03,  5.35552111e-03,
        -5.32814674e-03],
       [ 1.69571897e-04, -8.76633509e-04,  3.61794053e-04,
        -5.50812634e-04, -4.19790449e-04, -5.93755103e-04,
         2.55696476e-03, -1.94143248e-03,  8.28589546e-04,
         6.25579676e-04,  1.94528082e-03,  1.61505328e-03,
        -5.10090555e-04, -4.90753027e-03,  5.65958500e-04,
        -3.29076516e-04, -6.82119839e-03,  3.98144731e-03,
         5.07622771e-03,  9.74573195e-03,  1.83225784e-03,
         1.26915914e-03, -6.49228599e-03, -2.81956443e-03,
        -4.52179834e-03,  1.05030625e-03, -2.04257574e-03,
        -1.49474177e-03, -1.20814505e-03, -2.99126259e-04,
         4.98017820e-04, -5.33728162e-04,  4.96678613e-03,
        -1.02884136e-02, -8.12945236e-03, -4.92481922e-04,
         2.35389598e-04,  9.74765455e-04, -7.22831255e-03,
         6.26821304e-03],
       [ 2.34401203e-03,  9.71000700e-05,  5.76725579e-04,
        -2.17582146e-03, -2.57804664e-03,  5.03603369e-03,
        -3.61129642e-03, -1.22847909e-03, -6.60830690e-03,
        -6.98836287e-03,  2.78529292e-03,  4.29337379e-03,
         1.77625607e-05, -6.57048193e-04,  5.82959037e-03,
         3.02439113e-03,  7.72300409e-03,  2.54583498e-03,
         8.38852860e-03,  5.99409614e-05,  4.78040287e-03,
         1.06450915e-03, -3.64785665e-03,  6.07473357e-03,
         4.63146158e-03, -8.07622727e-03, -4.04396746e-03,
         7.64156133e-03,  3.70507850e-03, -1.87178340e-03,
        -1.45334424e-03,  5.18315053e-03, -3.24514951e-03,
         1.17791984e-02,  2.97309525e-05,  4.46355436e-03,
        -5.83853666e-03,  2.84412783e-03,  1.86579151e-03,
        -2.29959539e-03],
       [-9.17812635e-04,  1.09247238e-04,  2.22459013e-04,
        -9.53492010e-04,  4.48776584e-04,  3.70659691e-04,
         5.42579335e-04, -2.36859516e-04,  1.54892448e-03,
         4.25059203e-04,  1.71018287e-03, -5.39987290e-04,
         3.72016249e-04,  1.97725091e-03,  7.33791967e-04,
        -2.46219710e-03,  2.30762083e-03,  3.79279081e-04,
        -4.06257081e-04,  2.45455559e-03,  2.24974312e-04,
        -4.67945682e-03, -2.71463156e-04,  1.07029022e-03,
         1.80855277e-03,  3.12996074e-03, -2.46655708e-03,
         3.21982242e-03,  1.39675383e-03,  7.49024970e-04,
        -1.94808724e-03, -9.07193695e-04,  5.86358225e-03,
         3.61451856e-03, -7.26585218e-04,  6.17868674e-04,
         3.84903350e-03,  9.74073715e-04,  3.70179885e-03,
        -1.76891126e-03],
       [-2.66957359e-04, -4.85720113e-04,  7.00597011e-05,
         5.55220759e-04, -1.46419287e-03,  1.99115329e-05,
         2.20013619e-03, -1.61208538e-03,  2.14143656e-03,
        -7.94581138e-04,  2.07091519e-03,  4.75984823e-04,
        -7.80745526e-04, -2.57386011e-03,  1.61730184e-03,
        -1.60163647e-04, -3.81229259e-03,  7.53184315e-04,
         1.89636170e-03,  6.01398945e-03,  1.65843259e-04,
        -1.24073017e-03, -3.07277474e-03, -1.87206329e-04,
        -2.67149555e-03,  1.43753027e-03, -1.00539182e-03,
         1.23220135e-03, -2.03637709e-03,  1.41311472e-03,
        -1.24619575e-03, -3.00496956e-03,  3.94557323e-03,
        -1.23409473e-03, -7.80108734e-04,  1.85445452e-03,
        -1.77475589e-03,  1.40699930e-03, -3.27440607e-03,
         6.26856135e-03],
       [ 9.15322453e-04,  6.70939626e-04,  5.32945123e-05,
        -1.23644271e-03, -1.65411085e-03,  3.17622372e-03,
        -1.93170691e-03, -8.99288978e-04, -4.12403420e-03,
        -4.37450968e-03,  2.45221984e-03,  1.33932277e-03,
        -8.81876331e-04, -1.29321543e-03, -1.08767708e-03,
         3.90925910e-03,  3.94629454e-03,  2.78300396e-03,
         3.72339855e-03, -4.00352845e-04,  3.03946622e-03,
         1.24498142e-03,  1.30599255e-05,  1.21800543e-03,
         9.35329241e-04, -2.40149116e-03, -3.74688231e-03,
         3.22296936e-03, -4.58942173e-04,  6.95887778e-04,
        -4.00166307e-03,  2.50091450e-03, -1.36508001e-03,
         2.02119327e-03, -4.45941085e-04,  3.92257673e-04,
        -1.61825016e-03,  3.45573924e-03,  2.03010859e-03,
         2.48874305e-03],
       [-6.28455949e-04,  5.32185804e-05,  2.83192261e-04,
        -6.71944639e-04,  2.33496336e-04,  1.17822026e-04,
         4.13302012e-04, -1.07058804e-04,  1.06149877e-03,
         6.66826789e-04,  1.62779156e-03, -1.25644961e-03,
         1.57236238e-04,  1.06476864e-03, -4.53464381e-05,
        -2.31582811e-03,  4.45109326e-04, -6.35038668e-05,
        -1.17592618e-03,  2.48353439e-03,  7.71416060e-04,
        -4.87422943e-03, -8.40705907e-05,  2.89429852e-04,
         1.58878032e-03,  2.01637554e-03, -2.69800448e-03,
         2.76277983e-03, -2.27933415e-05,  6.10969670e-04,
        -2.74795201e-03, -8.19590874e-04,  5.98303741e-03,
         2.00051069e-03,  7.92224309e-04,  1.60883111e-03,
         4.07463219e-03,  2.19136965e-03,  3.89999943e-03,
        -4.13572975e-03],
       [-3.13537807e-04, -4.96280903e-04,  1.39438373e-04,
         3.74397467e-04, -1.09373266e-03, -2.76888342e-04,
         2.64395913e-03, -1.78713840e-03,  2.19823164e-03,
        -3.38982391e-05,  2.27926066e-03,  9.56485048e-04,
        -6.06785237e-04, -3.02634970e-03,  1.43017119e-03,
        -7.74914457e-04, -5.76969190e-03,  1.65425707e-03,
         2.89929309e-03,  7.28911068e-03,  6.25906454e-04,
        -1.84567383e-04, -3.92495841e-03, -1.41818530e-03,
        -3.61812487e-03,  1.58040924e-03, -5.46089024e-04,
        -2.59068736e-04, -2.47232593e-03,  2.19348958e-03,
        -1.25762657e-03, -3.38484789e-03,  4.98430105e-03,
        -4.08450654e-03, -2.90377392e-03,  2.07156944e-03,
        -8.22315284e-04,  2.19576014e-03, -5.08645969e-03,
         5.31074498e-03],
       [ 1.25854358e-03,  6.97482086e-04,  2.44450475e-05,
        -1.77790469e-03, -1.97457545e-03,  3.52928950e-03,
        -1.97376357e-03, -1.19156134e-03, -4.85499110e-03,
        -5.51526295e-03,  3.08067072e-03,  2.29635532e-03,
        -8.67974944e-04, -1.10719772e-03,  2.82131019e-04,
         2.82225246e-03,  4.82254941e-03,  3.01220850e-03,
         4.48400481e-03, -3.54634831e-04,  4.04812535e-03,
         2.53973878e-03,  1.94446748e-05,  1.99025893e-03,
         7.21234654e-04, -3.19308345e-03, -3.29765677e-03,
         3.64672416e-03, -6.76703930e-05,  1.98901442e-04,
        -1.29130716e-03,  3.16584227e-03, -5.74373524e-04,
         4.17890074e-03, -2.70004477e-03,  1.01922161e-03,
        -2.39284616e-03,  3.12372088e-03,  1.42853940e-03,
         3.62531538e-03],
       [-1.29107153e-04,  5.48320213e-06,  1.75988069e-04,
        -1.56375027e-04, -7.27923471e-05,  4.71012172e-04,
         1.42322024e-04,  1.73780558e-04,  6.14011660e-04,
         3.62862811e-05,  1.40103966e-03, -1.53176510e-03,
        -3.18388702e-05,  8.58646294e-04, -6.64053077e-04,
        -1.89531420e-03, -2.50196841e-04, -7.98310502e-04,
        -2.03947630e-03,  1.28869363e-03,  7.41674623e-04,
        -4.57560457e-03, -2.24910109e-04, -7.38923962e-04,
         1.44027709e-03, -1.42150326e-04, -3.20075895e-03,
         1.67695445e-03, -1.25462504e-03,  5.28774515e-04,
        -4.54779994e-03, -3.87394975e-04,  5.29174227e-03,
         1.57382584e-03,  4.21485951e-04,  3.11267679e-03,
         3.02548590e-03,  3.99811147e-03,  3.76852416e-03,
        -4.59030550e-03],
       [-3.95140902e-04, -6.53933152e-04,  1.65693942e-04,
         3.99090175e-04, -8.72720964e-04, -5.74751059e-04,
         2.95742881e-03, -1.64334150e-03,  2.30529183e-03,
         3.72664654e-04,  2.32922053e-03,  7.99675414e-04,
        -5.04476775e-04, -3.14275781e-03,  9.25082131e-04,
        -1.68261200e-03, -7.38925254e-03,  2.28186813e-03,
         3.37210600e-03,  8.08002520e-03,  3.60703008e-04,
         6.84953062e-04, -4.50306479e-03, -2.13594083e-03,
        -4.49701771e-03,  2.62825377e-03, -3.70456430e-04,
        -1.40120136e-03, -2.85111461e-03,  2.29489431e-03,
        -3.94952775e-04, -3.80966254e-03,  4.77848202e-03,
        -6.59156172e-03, -4.57753148e-03,  1.64890755e-03,
         9.66802181e-04,  1.65961031e-03, -6.25151908e-03,
         4.22695233e-03],
       [ 1.48935209e-03,  6.81596983e-04, -1.91549349e-04,
        -1.99816283e-03, -2.27368972e-03,  3.51896463e-03,
        -1.97701482e-03, -1.47542625e-03, -5.21324854e-03,
        -5.97425830e-03,  3.57135152e-03,  2.95768445e-03,
        -4.77731723e-04, -1.28182233e-03,  4.80151968e-04,
         2.71801068e-03,  4.75087017e-03,  3.18206265e-03,
         4.55564912e-03, -5.75229278e-05,  5.80450054e-03,
         3.17396363e-03,  5.09797479e-04,  1.94249628e-03,
         1.33721263e-03, -4.31916537e-03, -2.47484166e-03,
         3.34258005e-03, -3.76610114e-04, -5.67430980e-04,
         5.63122041e-04,  2.66122632e-03, -2.55084160e-04,
         4.42553125e-03, -3.49361170e-03, -2.99441337e-04,
        -2.48679891e-03,  4.20282595e-03,  1.41742305e-04,
         3.04242619e-03],
       [ 3.74691910e-04, -4.38731440e-05, -6.88922519e-05,
         1.59136602e-04, -4.29712411e-04,  1.68431507e-04,
        -2.46357260e-04,  1.86621401e-04, -1.44393722e-04,
        -7.03643891e-04,  1.10842660e-03, -1.69106107e-03,
        -4.23305610e-04,  4.66990343e-04, -1.08244061e-03,
        -1.28285540e-03, -8.18582193e-04, -1.37468334e-03,
        -2.83264904e-03,  1.25548295e-05,  7.22435419e-04,
        -3.85303749e-03,  7.82084302e-04, -1.51587336e-03,
         1.48593029e-03, -2.18442245e-03, -2.33366573e-03,
         4.14766575e-04, -2.11675232e-03,  1.05647137e-03,
        -4.90122475e-03,  4.86433913e-04,  4.35989862e-03,
         7.59011426e-04, -6.88893313e-04,  3.82286496e-03,
         8.44083203e-04,  4.51935595e-03,  3.97802377e-03,
        -3.87461670e-03],
       [-3.53672571e-04, -5.18565066e-04,  7.39583775e-05,
         3.39409395e-04, -1.17818243e-03, -4.82238829e-04,
         2.57859565e-03, -1.63709989e-03,  1.98353687e-03,
         1.21429519e-04,  2.32503982e-03,  4.36304836e-04,
        -5.93223784e-04, -2.87905009e-03,  9.22070059e-04,
        -1.01804012e-03, -6.25118939e-03,  1.68219663e-03,
         2.82573118e-03,  7.33041437e-03, -4.68809623e-04,
         7.31804816e-04, -4.32741083e-03, -1.81622186e-03,
        -3.56832636e-03,  2.52642366e-03, -9.41104547e-04,
        -1.22966699e-03, -1.99220143e-03,  2.01161415e-03,
         3.32796335e-04, -3.02135502e-03,  4.07433230e-03,
        -4.45795897e-03, -4.02667932e-03,  1.42723101e-03,
        -2.34434032e-04,  2.21527927e-03, -6.90112077e-03,
         4.81536286e-03],
       [ 1.40626275e-03,  7.15406262e-04, -1.00922407e-04,
        -1.66446145e-03, -2.12426251e-03,  3.44717596e-03,
        -1.97863602e-03, -1.21244532e-03, -5.02828881e-03,
        -5.13257785e-03,  2.81756651e-03,  3.15404078e-03,
        -6.53323659e-04, -1.18005660e-03,  5.50808560e-04,
         3.42548708e-03,  4.31107823e-03,  2.62999325e-03,
         4.28311853e-03, -3.10755597e-04,  5.43693081e-03,
         3.69331101e-03,  1.21989353e-04,  1.60603516e-03,
         1.58784317e-03, -3.74756637e-03, -1.92849094e-03,
         2.65680696e-03, -2.65778566e-04, -2.65448645e-04,
        -1.60372781e-03,  2.26045609e-03, -7.10730907e-04,
         3.02024372e-03, -3.11996299e-03,  6.56275777e-04,
        -2.21087108e-03,  1.92402257e-03,  3.17743048e-03,
         4.28694719e-03],
       [ 7.27269915e-04, -5.00186616e-05, -2.87290779e-04,
         6.37338380e-04, -7.57900008e-04, -2.25424854e-04,
        -2.60031084e-04,  4.93732223e-04, -7.09323562e-04,
        -7.28168932e-04,  4.21179837e-04, -1.62877177e-03,
        -1.24297963e-04, -5.50063443e-04, -1.10887981e-03,
        -1.02619012e-03, -2.65737809e-03, -1.44129258e-03,
        -3.00090853e-03, -4.36725823e-04,  9.12073825e-04,
        -2.60852207e-03,  9.50366491e-04, -2.63758842e-03,
         1.00439822e-03, -3.48065910e-03, -1.49109541e-03,
        -3.72917748e-05, -4.04025894e-03,  6.53325871e-04,
        -4.72537475e-03,  1.95908928e-04,  2.15066201e-03,
        -1.89081428e-03,  5.18745044e-04,  2.89338944e-03,
        -6.21633022e-04,  4.12053661e-03,  2.49967864e-03,
        -3.87145393e-03],
       [-3.56837903e-04, -5.15590014e-04,  7.42743578e-05,
         5.93683915e-04, -1.58872560e-03, -2.38718654e-04,
         2.09076190e-03, -1.53078162e-03,  1.68101129e-03,
        -6.08008821e-04,  2.14541052e-03,  1.66248228e-05,
        -7.55978690e-04, -2.70853331e-03,  1.33612810e-03,
        -7.95954184e-05, -4.30024182e-03,  4.06029547e-04,
         2.19483348e-03,  5.54924877e-03, -1.08973251e-03,
         4.65206685e-04, -4.17401036e-03, -1.40441884e-03,
        -1.88711903e-03,  2.05452950e-03, -1.80034852e-03,
        -4.75167180e-04, -8.30279663e-04,  5.53435180e-04,
         3.71820497e-04, -1.92992704e-03,  3.40296677e-03,
        -7.09289161e-04, -2.25408142e-03,  2.84308917e-03,
        -5.08022204e-04,  2.13590893e-03, -6.00912329e-03,
         6.07753219e-03],
       [ 1.06050214e-03,  7.08164356e-04, -4.41912289e-06,
        -9.96894320e-04, -2.05336092e-03,  3.03278910e-03,
        -1.65210001e-03, -7.24757614e-04, -4.30391077e-03,
        -4.32857452e-03,  1.70969544e-03,  2.63295555e-03,
        -4.96943307e-04, -1.39138778e-03,  2.05207607e-06,
         4.05362481e-03,  3.77085758e-03,  2.56774458e-03,
         3.16256890e-03, -3.67330475e-04,  4.34789201e-03,
         2.99701677e-03, -4.73562141e-05,  1.09728531e-03,
         1.11916661e-03, -2.28620111e-03, -1.98019180e-03,
         2.64248624e-03, -7.78202317e-04,  9.47750756e-04,
        -3.12435371e-03,  2.21203174e-03, -1.97493006e-03,
         1.08904240e-03, -1.98079646e-03, -3.98048112e-04,
        -1.96976727e-03,  7.97678193e-04,  3.34063335e-03,
         4.56836773e-03],
       [-1.64763012e-03,  6.11270545e-04, -3.20745137e-04,
        -3.49101552e-04, -5.88360599e-05, -6.90418005e-04,
         3.64234531e-03, -1.25988678e-03,  6.78565470e-04,
        -1.62210083e-03, -3.40397912e-03, -1.31847407e-03,
         2.21828278e-03, -4.16252224e-05,  2.40555150e-03,
        -2.56897742e-03,  1.92497764e-03,  1.90359075e-03,
         2.10110773e-03, -2.20787781e-03, -3.11616925e-04,
         2.19996087e-04,  2.95077031e-03, -4.41427430e-04,
         3.59240989e-03,  5.05732896e-04, -1.70027395e-03,
         2.03263201e-03,  2.41856347e-03, -2.05342122e-03,
        -8.26603267e-04,  8.97476857e-04, -8.61686713e-04,
        -8.31260998e-03, -2.20087497e-03,  2.91208015e-03,
         2.00861366e-03,  4.63122778e-05, -1.18516025e-03,
        -1.56641169e-03],
       [ 1.61129388e-03,  3.15330544e-04,  7.64212513e-04,
        -2.43988377e-03,  2.16066861e-03, -1.91430314e-04,
        -1.05091126e-03,  6.19566126e-04, -5.00697119e-04,
        -8.51637335e-04, -1.08406506e-03, -1.04413379e-03,
         1.53828340e-04,  5.86904411e-04,  2.24728184e-03,
        -2.66288803e-03, -1.66363665e-03,  6.30137103e-04,
         9.26060253e-04, -4.43768408e-03,  1.60366483e-03,
        -4.45659156e-04,  1.02203747e-03,  2.04589916e-03,
        -4.53543430e-03,  4.58550546e-03, -1.10883242e-03,
        -5.65391849e-04, -2.80345674e-03, -1.38560776e-04,
         1.85439014e-03,  1.47181418e-05, -8.58562707e-04,
         3.76944081e-03, -3.00281029e-03, -2.42667738e-03,
         1.74475741e-03, -1.25253538e-03,  2.55545927e-03,
        -2.04751245e-03],
       [-2.12827988e-04, -8.17323395e-04,  3.17614002e-04,
        -3.62343329e-04,  7.42912758e-04, -1.54945359e-03,
         2.84265785e-04, -9.46797663e-05, -2.04706608e-04,
        -9.21178842e-04, -2.47082789e-03, -1.30867597e-03,
         4.63018520e-03, -1.27646013e-03, -1.11331348e-03,
         5.42659429e-04,  2.93543508e-05,  2.10194197e-03,
         2.56388539e-05,  2.56860908e-03, -1.70236826e-03,
         3.72821302e-03, -2.44180090e-03, -9.27721150e-04,
         2.98123574e-04, -5.73269266e-04,  3.05318553e-03,
        -2.80363089e-03, -6.52094895e-04,  1.41109619e-03,
         3.26746027e-03, -5.84271736e-04,  2.01081461e-03,
         5.91080077e-03, -1.19904161e-03, -7.62232288e-04,
        -1.94943976e-03,  2.28167092e-03,  1.37910887e-04,
         1.89359277e-03],
       [-1.45538361e-03,  7.77225709e-04, -3.30014096e-04,
        -3.07440641e-04, -6.53673560e-05, -3.28816182e-04,
         3.62893753e-03, -1.51874486e-03,  4.54973575e-04,
        -1.81308866e-03, -3.24723893e-03, -4.06301959e-04,
         1.24533672e-03, -4.99474467e-04,  2.98975618e-03,
        -2.51044962e-03,  2.84541096e-03,  2.16834270e-03,
         1.90296420e-03, -3.41838994e-03, -3.98276112e-04,
         9.69673798e-04,  3.21447453e-03, -4.63704899e-04,
         2.88087479e-03,  2.34019081e-03, -2.35636416e-03,
         3.60538135e-03,  1.25132082e-03, -1.70207408e-03,
         3.72764014e-04, -1.51735032e-03, -2.53313989e-03,
        -7.12982146e-03, -4.82747424e-03,  2.59546423e-03,
         9.86240804e-04,  8.24201052e-05, -3.03056370e-03,
        -2.68015382e-03],
       [ 1.41642429e-03,  1.66646307e-04,  1.10223319e-03,
        -2.66754976e-03,  2.40080641e-03, -1.90134087e-04,
        -1.79022178e-03,  1.27454230e-03, -1.25574984e-03,
        -3.48779169e-04, -1.49301800e-03,  5.69053664e-05,
        -7.27634411e-04,  3.34049982e-04,  2.69993348e-03,
        -1.94585510e-03, -1.19162782e-03,  1.56117149e-03,
         2.74367107e-04, -3.57306842e-03,  1.52301160e-03,
        -1.72490266e-03, -2.23622628e-04,  2.21613841e-03,
        -4.17698175e-03,  4.34072083e-03, -2.99184467e-03,
         8.37414642e-04, -9.49419744e-04,  3.33573640e-04,
         2.88991467e-03, -7.93246436e-04, -2.69028847e-03,
         7.39488052e-03, -7.85787776e-03, -5.05378097e-03,
         4.95949434e-03, -2.71513406e-03,  4.78829956e-03,
        -6.29690988e-03],
       [ 2.35294880e-04, -5.66431845e-04,  4.40001691e-04,
        -4.73754044e-04,  1.88947699e-04, -1.16786349e-03,
        -3.76337790e-04, -4.18392825e-04,  1.20528428e-04,
        -1.71703025e-04,  7.28349987e-05,  5.41674613e-04,
         2.51821103e-03, -4.64064855e-04, -2.29965453e-03,
         1.78531947e-04,  6.70765585e-04,  2.70371651e-03,
        -1.75732491e-03,  3.46170599e-03, -3.00461124e-03,
         3.35819786e-03, -2.32659816e-03, -1.21773628e-03,
         8.20568472e-04, -9.90405330e-04,  9.92478803e-04,
        -5.10246493e-03, -3.20271729e-03,  7.28840823e-04,
         4.59183846e-03, -2.98880762e-03,  3.71168484e-03,
         5.52384369e-03, -1.06051844e-03, -4.39037307e-04,
        -3.94594530e-03,  3.68660945e-03, -4.97734593e-03,
         6.83678954e-04],
       [-1.20637880e-03,  1.04862044e-03, -3.29209113e-04,
        -4.13245376e-04, -1.98302092e-04,  1.28107567e-04,
         2.89657293e-03, -1.39433483e-03,  2.89984717e-04,
        -1.68287184e-03, -1.78746704e-03,  9.98575008e-04,
         4.38743882e-04,  1.61234158e-04,  3.04147718e-03,
        -2.04949500e-03,  4.13708109e-03,  2.37759156e-03,
         1.25477067e-03, -3.08552827e-03,  4.85659461e-04,
         1.34822261e-03,  2.78555648e-03, -4.59440053e-04,
         3.93831171e-03,  3.13858571e-03, -1.95957418e-03,
         4.45293821e-03, -7.64132594e-04, -4.98881040e-04,
         4.56278562e-04, -3.23152775e-03, -3.23831569e-03,
        -7.85047188e-03, -6.79546408e-03,  4.30918531e-03,
        -1.29463349e-03, -3.50019516e-04, -4.97163925e-03,
        -4.07770323e-03],
       [ 1.49760093e-03, -3.02497374e-05,  9.55548079e-04,
        -2.76833307e-03,  2.29950994e-03,  6.09758950e-04,
        -1.26288657e-03,  1.01969065e-03, -6.43240113e-04,
        -1.38699630e-04, -1.12090237e-03, -1.37469426e-04,
        -1.05116447e-03, -1.08875774e-05,  3.76525428e-03,
        -2.39584665e-03, -2.95931473e-03,  4.80713061e-04,
         1.75761397e-03, -2.85597844e-03,  7.50894367e-04,
        -1.79167336e-03, -2.87540926e-04,  2.43735337e-03,
        -4.41867206e-03,  3.84114287e-03, -4.67772968e-03,
         6.45800319e-04,  4.33182577e-04, -2.37491578e-04,
         2.56188982e-03,  1.31086039e-03, -3.11465189e-03,
         8.02998152e-03, -7.70060951e-03, -5.76948142e-03,
         5.54460846e-03, -1.60116074e-03,  4.82085301e-03,
        -6.41105464e-03],
       [ 2.52997590e-04, -4.58335358e-04,  3.36713216e-04,
        -3.90333735e-04,  2.66567640e-05, -1.09823304e-03,
        -8.36458639e-04, -5.45751478e-04, -3.49487418e-05,
        -1.87120850e-06,  9.57740820e-04,  1.31798233e-03,
         1.22287776e-03, -5.83333371e-04, -2.84849270e-03,
         2.67182098e-04,  1.45475706e-03,  2.67994660e-03,
        -1.97825581e-03,  3.12476163e-03, -4.90794051e-03,
         3.05082882e-03, -1.34219904e-03, -1.14161766e-03,
        -5.50729863e-04, -8.91427044e-04, -4.29221080e-04,
        -4.89708083e-03, -4.26230673e-03,  8.84348003e-04,
         4.60988143e-03, -4.20504482e-03,  4.39711148e-03,
         4.80152667e-03, -1.74817629e-03, -2.25646957e-03,
        -4.63691866e-03,  4.37567057e-03, -4.42318246e-03,
        -4.72111395e-04],
       [-9.24138760e-04,  1.09225477e-03, -2.62072019e-04,
        -4.28297906e-04, -6.57422410e-04,  4.21384728e-04,
         2.11071782e-03, -1.36812066e-03,  4.77611087e-04,
        -1.30444497e-03, -2.67836323e-04,  1.65917946e-03,
        -2.85299873e-04,  4.96602326e-04,  3.68536450e-03,
        -1.72686740e-03,  4.25199978e-03,  1.82088919e-03,
         4.86524426e-04, -3.32765887e-03,  5.61127148e-04,
         9.95046808e-04,  2.24136957e-03,  2.50554149e-04,
         3.71867279e-03,  2.81558302e-03, -1.35985459e-03,
         4.65951674e-03, -2.01051147e-03, -2.59815715e-04,
         2.25227530e-04, -2.95790820e-03, -3.61853605e-03,
        -7.69296894e-03, -8.72879941e-03,  5.11977402e-03,
        -2.28673010e-03, -1.15632068e-03, -5.88208530e-03,
        -5.87962475e-03],
       [ 1.62649387e-03, -1.91836531e-04,  7.94228748e-04,
        -2.17380770e-03,  2.38736952e-03,  9.38161917e-04,
        -8.78372055e-04,  3.64003616e-04,  1.10623885e-04,
        -3.52908974e-04,  1.37474301e-04, -1.17836869e-03,
         6.73150120e-04,  1.59025716e-03,  2.49814661e-03,
        -1.38224813e-03, -2.97973328e-03,  2.17956782e-04,
         4.66456544e-03,  2.26640477e-04, -3.32582887e-04,
        -1.22336240e-03, -2.72782694e-04,  2.09472561e-03,
        -2.52553262e-03, -8.28882447e-04, -3.75831104e-03,
        -7.34130372e-05,  5.29709330e-04, -2.41293921e-03,
         8.45421397e-04,  3.96967493e-03, -9.68069246e-04,
         4.18462045e-03, -3.96537920e-03, -2.70744902e-03,
         3.84442252e-03, -1.59345241e-03,  4.82071191e-03,
        -3.27811786e-03],
       [ 4.92798172e-05, -3.78546683e-04,  3.59407917e-04,
        -2.58510670e-04,  7.55907095e-05, -7.35301117e-04,
        -1.37422385e-03, -4.62722004e-04, -5.54209342e-04,
         1.68299477e-04,  1.80803263e-03,  1.73856155e-03,
         1.76842383e-04, -4.59563053e-05, -3.80300824e-03,
         5.89666131e-04,  3.15998541e-03,  2.04500440e-03,
        -1.35802431e-03,  3.23846494e-03, -5.62723028e-03,
         2.13812664e-03, -1.06770916e-04, -8.52389901e-04,
        -8.41269444e-04, -8.02509952e-04, -1.96097209e-03,
        -3.93797411e-03, -4.43700422e-03,  2.33498914e-03,
         3.27641796e-03, -6.05834369e-03,  2.76347599e-03,
         1.27563125e-03, -2.46708444e-03, -4.42035403e-03,
        -3.48607707e-03,  5.40164486e-03, -4.14448325e-03,
        -2.82824016e-03],
       [-1.17313280e-03,  9.99713899e-04, -2.37306842e-04,
        -4.37923300e-04, -2.86356197e-04,  1.86001853e-04,
         2.83320295e-03, -1.23397436e-03,  7.59362476e-04,
        -1.48657372e-03, -1.17900223e-03,  6.57336554e-04,
         7.53815228e-04,  1.96958848e-04,  3.50088067e-03,
        -2.51722871e-03,  3.64522962e-03,  1.62918167e-03,
         1.36068696e-03, -2.95995665e-03,  4.95052780e-04,
         9.12047806e-04,  2.33687414e-03,  4.64664132e-04,
         4.13355231e-03,  2.65386025e-03, -1.45164027e-03,
         4.44044871e-03, -5.47979784e-04, -5.28069388e-04,
        -4.15534218e-04, -1.90542394e-03, -2.73932377e-03,
        -7.83132948e-03, -7.37410877e-03,  4.62036999e-03,
        -1.89470011e-04, -6.67585002e-04, -4.12745308e-03,
        -5.42910816e-03],
       [ 1.56054716e-03, -3.17838450e-04,  7.53575645e-04,
        -2.14326358e-03,  2.22051609e-03,  8.58192681e-04,
        -8.49727890e-04,  6.37732446e-04, -2.41323301e-04,
        -3.97883210e-04, -8.80444306e-04, -1.22974056e-03,
        -2.18645204e-04,  2.04045413e-04,  2.68603046e-03,
        -1.78961980e-03, -3.09452601e-03,  2.48659519e-04,
         4.50197095e-03, -1.38585339e-03, -9.50405083e-04,
        -1.03181088e-03, -7.79162219e-04,  2.78760726e-03,
        -3.37467226e-03,  8.11163278e-04, -2.99492828e-03,
         1.25194411e-03,  3.01938999e-04, -2.83363624e-04,
         2.55633122e-03,  3.50475800e-03, -9.09485098e-04,
         5.03823115e-03, -4.51914407e-03, -3.54151358e-03,
         3.25093325e-03, -4.23555844e-04,  6.17254619e-03,
        -3.41869937e-03],
       [ 1.48425301e-04, -7.01422512e-04,  4.44795296e-04,
        -5.09459293e-04, -8.69460637e-05, -8.63852503e-04,
        -7.30659231e-04, -4.17942123e-04, -6.31587347e-04,
         4.87244433e-05,  5.28429635e-04,  1.18938042e-03,
         5.99307066e-04, -7.32446555e-04, -2.94943945e-03,
         7.47721177e-04,  2.00274796e-03,  2.30268342e-03,
        -1.36370107e-03,  2.77501787e-03, -4.97552007e-03,
         2.65807775e-03, -2.98442785e-04, -1.33559888e-03,
        -7.17613264e-04,  2.36007891e-05, -1.02558522e-03,
        -4.38593049e-03, -2.20856466e-03,  1.94766582e-03,
         5.06783882e-03, -4.20431420e-03,  3.33073246e-03,
         5.59835229e-03, -3.69261205e-03, -4.46581934e-03,
        -3.10198893e-03,  3.58603150e-03, -3.04750376e-03,
        -8.69149866e-04],
       [-1.45390257e-03,  8.08533398e-04, -2.24084288e-04,
        -2.54338695e-04,  5.15521679e-05, -2.20510832e-04,
         3.31603433e-03, -1.18249014e-03,  9.35553689e-04,
        -1.51508092e-03, -2.38246890e-03, -7.38820701e-04,
         1.93113380e-03,  1.67227423e-04,  2.67173583e-03,
        -2.43981113e-03,  2.85523385e-03,  1.89863134e-03,
         2.49654008e-03, -1.75806438e-03,  2.75067490e-04,
         6.53484662e-04,  2.38936627e-03, -9.02458560e-05,
         3.90555616e-03,  9.30311857e-04, -1.29256304e-03,
         3.73791903e-03,  1.16784929e-03, -1.58442557e-03,
        -4.79129929e-04,  7.27082806e-05, -1.17543840e-03,
        -8.88083875e-03, -4.01171809e-03,  4.35507391e-03,
         7.83469644e-04, -7.17008370e-04, -2.61793286e-03,
        -4.03539930e-03],
       [ 1.48019008e-03, -7.34345158e-05,  8.40047956e-04,
        -2.02513509e-03,  2.36835331e-03,  3.20384483e-04,
        -8.46893759e-04,  6.28151582e-04, -5.30872028e-04,
        -4.58308350e-04, -1.58148434e-03, -1.32278225e-03,
        -7.87519675e-04,  2.08260899e-04,  2.36164057e-03,
        -1.89191813e-03, -3.02952784e-03,  7.11737666e-04,
         3.13175563e-03, -3.14746960e-03, -6.01873908e-04,
        -9.98198637e-04, -2.07966339e-04,  2.90006376e-03,
        -3.95617355e-03,  2.45613419e-03, -2.70628463e-03,
         7.13978778e-04, -1.45222200e-03, -1.16816227e-05,
         2.70893821e-03,  1.97009300e-03, -9.31774790e-04,
         3.68202827e-03, -3.53076844e-03, -3.78646725e-03,
         1.77035946e-03,  1.21739157e-03,  5.86923491e-03,
        -3.17554269e-03],
       [ 8.48282161e-06, -8.20230169e-04,  5.00295602e-04,
        -5.34309424e-04,  2.39792833e-04, -1.22913590e-03,
        -8.03856456e-05, -2.35585656e-04, -5.12102444e-04,
        -3.18560837e-04, -9.98913310e-04,  5.72771896e-05,
         2.06740620e-03, -1.13670155e-03, -2.27522105e-03,
         7.86473218e-04,  1.23152602e-03,  2.45573791e-03,
        -9.24326538e-04,  2.64156959e-03, -3.59801902e-03,
         3.16758221e-03, -7.69374659e-04, -1.36574148e-03,
        -1.48402381e-04,  3.38209327e-04,  6.90546294e-04,
        -3.94332875e-03, -7.84287695e-04,  1.60355982e-03,
         5.41315693e-03, -2.42951559e-03,  3.47153749e-03,
         6.87575759e-03, -3.45051568e-03, -3.41229700e-03,
        -2.51585571e-03,  2.61748838e-03, -1.71512365e-03,
         4.66802885e-04],
       [ 8.18824046e-04, -5.80096559e-04,  2.30367459e-05,
         5.84690657e-04,  8.70624266e-04, -3.01692256e-04,
        -1.70130981e-03,  1.71603088e-03, -2.27002965e-05,
         2.73464667e-03, -1.08087486e-04,  4.46665828e-04,
         6.44791144e-05, -1.55646261e-03, -2.14866875e-03,
         7.06317151e-05, -3.20789171e-03, -9.70350869e-04,
        -1.64858683e-03,  2.54376582e-03,  1.41113851e-04,
        -1.75059773e-03, -3.35255126e-03, -2.26909225e-03,
        -9.77825257e-04, -2.97123590e-03, -1.02180720e-03,
        -3.06002866e-03,  4.41898452e-03, -2.32895347e-03,
        -3.67309689e-03,  2.55689933e-03,  2.47880677e-03,
         5.93907014e-03,  8.73622485e-03, -3.91754135e-03,
        -7.44717137e-04,  2.41391547e-03,  3.91955982e-04,
         5.43887960e-03],
       [ 1.56759575e-03, -8.39680724e-05,  6.33882941e-04,
        -2.13709683e-03,  2.51046196e-03,  1.30900752e-03,
        -2.29730213e-04,  7.28571089e-04, -1.05164392e-04,
         5.20472415e-04,  7.70758270e-05, -3.90399218e-04,
         3.74923839e-04,  3.99946555e-04,  2.97795120e-03,
        -2.96403468e-03, -9.26857523e-04, -3.93516857e-05,
         3.90599575e-03,  1.21682184e-04, -4.85090917e-04,
         8.22001777e-04,  2.01856907e-04,  8.96835467e-04,
        -7.89042853e-04, -2.78798019e-04, -3.58830160e-03,
         1.26110949e-03,  3.09991883e-03, -1.71973940e-03,
         2.95487262e-04,  2.95324181e-03, -2.60958425e-03,
         4.19444498e-03, -3.38889798e-03, -2.16662255e-03,
         6.69217989e-05, -7.88346981e-04, -1.34126015e-03,
        -4.35860781e-03],
       [ 4.00057215e-05, -3.54806310e-04,  7.15083443e-04,
        -1.12653142e-05,  6.36554205e-06, -4.62753233e-05,
        -8.32741265e-04, -4.61711810e-04, -7.05053739e-04,
         3.26807640e-04,  2.26527150e-03,  1.59580819e-03,
        -1.57437299e-03, -1.01135658e-04, -4.42958623e-03,
         1.48845452e-03,  2.89110071e-03,  9.38615645e-04,
        -9.27496701e-04,  2.49470142e-03, -4.14262153e-03,
        -7.21850956e-04, -3.79080215e-04, -2.94918718e-04,
        -9.49342037e-04, -2.10513151e-03, -2.82900129e-03,
        -5.76474518e-03, -3.90464603e-03,  1.37025112e-04,
         3.07616265e-03, -5.96544333e-03,  8.89267772e-04,
         2.34378502e-03, -3.32998275e-03, -6.78251265e-03,
        -4.50083840e-04,  4.52839816e-03, -4.01009573e-03,
        -2.57993420e-03],
       [ 1.06875098e-03, -6.76022493e-04,  8.64998801e-05,
         6.87150983e-04,  6.47696841e-04, -1.35354658e-05,
        -2.58405297e-03,  1.75234803e-03,  1.60059819e-04,
         3.06160748e-03,  1.08648243e-03,  1.35635375e-03,
        -8.09012272e-04, -1.58118608e-03, -1.86082034e-03,
         8.69650568e-04, -2.77993106e-03, -1.25653751e-03,
        -1.98768941e-03,  2.34360201e-03, -6.87769905e-04,
        -8.78949184e-04, -4.09053825e-03, -1.69335364e-03,
        -1.65176764e-03, -1.99571997e-03, -5.72081481e-04,
        -3.50983371e-03,  4.66187298e-03, -1.33222563e-03,
        -2.39556516e-03,  2.91679939e-03,  1.34079740e-03,
         6.37727976e-03,  6.07620506e-03, -3.45467567e-03,
        -2.19259737e-03,  5.82445471e-04,  1.14143069e-03,
         3.87640554e-03],
       [ 1.40310952e-03,  9.17101079e-06,  7.22599740e-04,
        -2.60426290e-03,  2.65141297e-03,  9.05437511e-04,
        -4.54432884e-04,  1.08805287e-03, -9.90586588e-04,
         5.17277687e-04, -1.25948212e-03,  3.18501436e-04,
        -1.69350347e-03, -1.33228523e-03,  4.35204804e-03,
        -4.13949043e-03, -6.41284103e-04, -3.25550878e-04,
         6.81851641e-04, -2.05644872e-03,  1.31404528e-03,
         1.18668482e-03, -6.36449666e-04,  1.22248509e-03,
        -2.20585824e-03,  4.40013362e-03, -4.67106048e-03,
         1.03515259e-03,  3.32046347e-03, -5.09897305e-04,
         7.72697967e-04,  4.16758587e-04, -3.44224158e-03,
         8.86678416e-03, -7.27237202e-03, -5.37260296e-03,
         1.91887759e-03,  4.70621308e-05,  5.35031257e-04,
        -6.94812508e-03],
       [ 2.39466215e-04, -4.94696607e-04,  7.19753793e-04,
        -2.14565633e-04, -5.07378682e-05, -5.03540563e-04,
        -1.95263070e-04, -8.72798031e-04, -7.79670590e-05,
         3.15480516e-04,  1.56988134e-03,  1.08427741e-03,
        -2.55597726e-04, -8.74683028e-05, -3.64376185e-03,
         1.16150663e-03,  1.46917521e-03,  1.03985332e-03,
        -1.17537053e-03,  2.75589572e-03, -4.60282853e-03,
        -3.34512006e-04, -8.16740503e-04,  2.23741532e-04,
        -1.38611323e-03, -2.02453253e-03, -1.66428578e-03,
        -7.18434807e-03, -4.32206737e-03, -1.22475671e-03,
         3.68359126e-03, -3.68186063e-03,  2.30219541e-03,
         5.87282889e-03, -2.94901920e-03, -5.57299703e-03,
        -3.14279948e-03,  3.24907480e-03, -4.77051269e-03,
        -4.96623106e-04],
       [ 1.38564350e-03, -5.73474506e-04,  2.21157738e-04,
         6.39767095e-04,  5.14097861e-04,  5.55608480e-04,
        -3.49866506e-03,  1.62373122e-03,  1.13155962e-04,
         2.85218796e-03,  2.42324872e-03,  2.69982894e-03,
        -1.55764911e-03, -8.30227684e-04, -2.16090982e-03,
         1.57964032e-03, -1.69458089e-03, -1.36167416e-03,
        -2.99211103e-03,  2.76911934e-03, -6.21775689e-04,
         2.95008329e-04, -4.91107116e-03, -1.88995805e-03,
        -1.24775805e-03, -1.17883016e-03,  3.02554603e-04,
        -3.78651777e-03,  2.59284489e-03, -1.14668423e-04,
        -1.54963764e-03,  1.34583213e-03,  7.43574288e-04,
         6.58300985e-03,  3.26986401e-03, -2.61836499e-03,
        -4.06350754e-03, -9.14167831e-05,  6.70098234e-04,
         2.97411415e-03],
       [ 1.28341594e-03,  2.62976682e-04,  8.77296901e-04,
        -2.32113642e-03,  2.70194374e-03,  2.89004034e-04,
        -5.67932846e-04,  1.36857363e-03, -1.10975804e-03,
         9.66987805e-04, -2.03037378e-03,  8.85738700e-04,
        -2.10638950e-03, -1.31274899e-03,  3.88030708e-03,
        -4.02750168e-03,  8.23356269e-04, -5.30093617e-04,
        -1.25177379e-03, -1.98421627e-03,  2.55981111e-03,
         1.01846829e-03, -2.96806858e-04,  1.37211091e-03,
        -1.78654364e-03,  5.46988891e-03, -4.12636809e-03,
         1.26646215e-03,  3.74515424e-03, -1.52619614e-03,
         5.26859076e-04, -1.71210628e-03, -2.59658601e-03,
         8.02599918e-03, -7.82564655e-03, -5.96684823e-03,
         1.46868208e-03,  8.38233333e-04,  1.53878646e-03,
        -6.54956698e-03],
       [ 5.90056530e-04,  1.74764835e-03,  1.00775345e-04,
        -4.81849798e-04, -5.35117324e-05,  1.99419004e-03,
         5.24011964e-04, -1.68530189e-03,  2.64434726e-03,
         3.67141532e-04,  3.38815618e-04,  2.01845565e-03,
         3.20148596e-04,  4.56123002e-04,  1.22209126e-03,
        -2.10298051e-04,  4.78227186e-04,  1.90828578e-04,
         3.99533310e-04, -1.19762716e-03,  3.15479096e-03,
         2.84178695e-03,  1.95041648e-04, -3.83122265e-03,
         2.30014510e-03,  6.01246196e-04,  7.46624079e-04,
        -1.55409984e-03, -1.33478048e-03,  3.10182548e-03,
         1.02474727e-03,  3.89129808e-03,  1.08519907e-03,
         4.48715473e-05, -1.74132397e-03,  2.02907555e-04,
         1.05435681e-03, -7.61927688e-04,  1.22956117e-03,
        -6.27344591e-04],
       [ 1.53237220e-03, -5.16144850e-04,  2.65433860e-04,
         7.76294677e-04,  2.62405607e-04,  4.41508862e-04,
        -3.85085912e-03,  1.25434762e-03, -1.04819977e-04,
         2.68980186e-03,  2.99810711e-03,  2.72762054e-03,
        -3.00012808e-03, -1.47010887e-03, -1.49888813e-03,
         1.44892465e-03, -1.65707711e-03, -2.27280008e-03,
        -3.63293872e-03,  1.63327518e-03,  2.34883511e-04,
        -3.35886325e-05, -4.49065026e-03, -1.01167569e-03,
        -2.13659299e-03,  3.22003471e-04, -5.52974350e-04,
        -4.39417083e-03,  2.15450069e-03, -1.24803337e-03,
        -1.52590720e-03,  5.57662104e-04,  2.97193154e-04,
         7.94698577e-03,  3.72123788e-04, -4.33637993e-03,
        -5.73888095e-03,  8.76042526e-04, -2.78853913e-05,
         1.39356696e-03],
       [ 1.46445492e-03,  3.89288994e-04,  5.52627549e-04,
        -1.99286453e-03,  2.16908869e-03,  3.51455383e-04,
         5.09671081e-05,  6.08202361e-04, -6.12774282e-04,
         3.18245962e-04, -1.84562558e-03, -1.77820228e-04,
        -5.80653141e-04, -1.55682373e-03,  3.31751630e-03,
        -4.85857902e-03, -1.12020658e-04, -1.48395891e-03,
        -7.65323231e-04, -2.88895238e-03,  2.60648737e-03,
         2.02348619e-03,  1.10161118e-03,  7.65695353e-04,
        -1.59245881e-03,  4.60547255e-03, -2.78769294e-03,
         2.73448328e-04,  1.18048850e-03, -1.42886094e-03,
        -2.53845210e-05, -4.05215309e-04, -9.76632233e-04,
         3.47398757e-03, -3.15004890e-03, -2.97717215e-03,
        -2.09885067e-03,  3.14710545e-03, -3.21259082e-04,
        -3.04440316e-03],
       [-2.44302646e-04, -9.14815406e-04,  4.01167548e-04,
        -3.91350099e-04,  6.89974928e-04, -1.32313219e-03,
         1.00441382e-03,  4.25493694e-04, -6.24700973e-04,
         3.52416973e-04, -1.71904173e-03, -2.13387888e-03,
         3.84426536e-03,  6.95417402e-04, -2.01386749e-03,
         1.26655900e-03,  2.55345512e-04,  4.60671523e-04,
         1.07423647e-03,  2.45610485e-03, -9.03043896e-04,
        -1.80264656e-03,  1.11199613e-03,  1.64339668e-03,
        -7.17359653e-04, -1.80723611e-03,  8.10661411e-04,
        -3.25261732e-03, -8.24345741e-04, -2.30186945e-03,
        -5.28972480e-04,  2.42277310e-04,  2.18786625e-03,
         4.90115397e-03, -4.67668433e-04, -2.37599015e-03,
        -3.52495816e-03,  2.46891705e-03, -1.20604201e-03,
         1.44188642e-03],
       [ 1.31287053e-03, -5.88536146e-04,  1.27928623e-04,
         5.36074105e-04,  1.47752085e-04,  3.07096401e-04,
        -3.48291034e-03,  1.39946025e-03, -4.31049120e-04,
         2.58063548e-03,  1.95489149e-03,  2.37789913e-03,
        -2.68799067e-03, -1.65731937e-03, -1.31658919e-03,
         9.52197879e-04, -2.40571098e-03, -1.85061677e-03,
        -3.71714006e-03,  1.76180701e-03, -4.14117385e-04,
        -1.81296171e-04, -3.30889900e-03, -1.54854148e-03,
        -2.11562519e-03, -3.06453194e-06, -1.10430224e-03,
        -4.06258274e-03,  3.24820611e-03, -1.35209889e-03,
        -1.72141998e-03,  5.72786259e-04,  5.76600374e-04,
         8.79414752e-03,  2.78537208e-03, -4.87274630e-03,
        -4.06131707e-03,  1.45360525e-03,  5.06210607e-04,
         3.35574849e-03],
       [ 1.37588033e-03,  4.22475387e-05,  6.60975405e-04,
        -1.67723908e-03,  2.42651184e-03,  8.15630250e-04,
        -4.72394931e-05,  8.74496181e-04, -6.17998361e-04,
         5.31070633e-04, -2.12745438e-03, -3.84036102e-04,
        -1.49662339e-03, -1.41306070e-03,  3.31038469e-03,
        -3.99063993e-03, -1.01707538e-03, -6.02646964e-04,
         1.76999008e-03, -1.87923003e-03,  4.14880633e-04,
         1.95971713e-03, -1.80942166e-04,  1.29444536e-03,
        -9.64818755e-04,  2.89219548e-03, -3.21993348e-03,
         1.27851497e-03,  2.16494291e-03, -1.74877903e-04,
         1.27924664e-03,  8.45438393e-04, -2.00222875e-03,
         3.89620126e-03, -3.62698524e-03, -4.88389656e-03,
        -1.83196296e-03,  3.64833931e-03,  2.70602340e-03,
        -4.22012014e-03],
       [ 6.49647382e-06, -9.34121606e-04,  6.91595837e-04,
        -6.30507304e-04,  7.17872754e-05, -1.08788337e-03,
         3.75133299e-04,  3.02941316e-05, -9.64481034e-04,
         4.90764331e-04, -1.98170936e-04, -4.10929119e-04,
         1.17468310e-03, -2.95507725e-05, -2.62349565e-03,
         1.77357357e-03,  1.48936734e-03,  1.03594933e-03,
         3.35068617e-04,  2.52764020e-03, -3.33294412e-03,
        -5.07308927e-04,  1.75386725e-03,  6.67709741e-04,
        -1.22539850e-03, -1.43669208e-03, -3.18177015e-04,
        -5.65597974e-03, -9.39235251e-05, -1.56509446e-03,
         3.38848354e-03, -1.83190464e-03,  2.48359330e-03,
         6.52729813e-03, -3.15638445e-03, -5.19613922e-03,
        -2.06049532e-03,  1.77866616e-03, -2.91820685e-03,
         1.30643824e-03],
       [ 1.03684736e-03, -5.87127986e-04,  8.10536803e-05,
         6.60955673e-04,  6.27046626e-04,  1.04639010e-04,
        -2.50528427e-03,  1.54442363e-03, -2.49519246e-04,
         2.73387646e-03,  5.57494059e-04,  1.20520021e-03,
        -1.08265167e-03, -1.56733778e-03, -2.20242050e-03,
         7.05343846e-04, -3.27122002e-03, -1.48298347e-03,
        -2.66229664e-03,  2.54112389e-03, -3.35157034e-04,
        -1.01991743e-03, -3.39899282e-03, -2.36372883e-03,
        -1.67174474e-03, -1.88244646e-03, -1.08245970e-03,
        -3.64372414e-03,  4.13577631e-03, -1.81039714e-03,
        -2.66520912e-03,  1.73001760e-03,  1.84008991e-03,
         7.48276152e-03,  6.82459818e-03, -4.43402352e-03,
        -2.51743384e-03,  2.01509171e-03,  1.25644077e-03,
         4.91841976e-03],
       [ 1.44795736e-03, -1.68164930e-04,  6.33553951e-04,
        -1.89196283e-03,  2.43224949e-03,  1.32856623e-03,
        -3.17656435e-04,  1.00095675e-03, -4.65928228e-04,
         6.10213378e-04, -1.10589247e-03, -3.16970894e-04,
        -9.53952549e-04, -1.03791477e-03,  3.19321500e-03,
        -3.16639175e-03, -1.01382483e-03, -4.77303081e-04,
         3.19001870e-03, -9.57400305e-04, -4.28234984e-04,
         1.36115577e-03, -9.15527577e-04,  1.72992435e-03,
        -9.21594619e-04,  1.75044115e-03, -3.89983458e-03,
         1.55392871e-03,  3.65798897e-03, -7.14713882e-04,
         1.23846589e-03,  2.79946416e-03, -2.32101418e-03,
         5.45260636e-03, -5.06175868e-03, -4.31439700e-03,
        -9.05414927e-04,  1.79324159e-03,  3.10045015e-03,
        -5.09457756e-03],
       [ 1.26932631e-04, -7.72228173e-04,  7.61545729e-04,
        -4.51826985e-04, -1.41578392e-04, -4.96914727e-04,
        -2.89255113e-04, -2.61109875e-04, -1.02151313e-03,
         4.90648497e-04,  1.21849915e-03,  8.95988196e-04,
        -7.42943317e-04, -2.79458705e-04, -3.38070444e-03,
         1.72338926e-03,  2.05587130e-03,  1.03643944e-03,
        -2.65977258e-04,  2.70894752e-03, -4.48904280e-03,
        -3.23310174e-04,  1.15702848e-03,  1.90320396e-04,
        -1.48612878e-03, -1.44517061e-03, -1.96259702e-03,
        -6.31573889e-03, -1.07411738e-03, -6.99259923e-04,
         4.35903342e-03, -3.82005493e-03,  1.90108747e-03,
         6.39251620e-03, -4.14684834e-03, -6.38623582e-03,
        -1.25832611e-03,  2.51940475e-03, -3.40590952e-03,
        -5.44451410e-04],
       [-1.39349385e-03,  1.34104292e-03,  1.26846135e-03,
        -1.61807938e-03,  1.68800238e-03,  7.82729243e-04,
         1.18169794e-03, -5.89047268e-04,  6.84568938e-03,
         3.54283163e-03,  1.70224137e-03, -2.33104802e-03,
        -3.07283015e-04,  1.89066166e-03, -1.17436156e-03,
         1.93371414e-03,  3.05612385e-03, -4.90166130e-04,
         1.06845796e-03,  1.05261104e-03, -8.28769698e-04,
        -3.56872845e-03, -8.77569895e-04,  6.01069815e-03,
         1.25445903e-03,  5.96274331e-04, -1.95220252e-03,
         1.22348336e-03, -4.69799852e-03,  2.74238177e-03,
         4.44545207e-04, -2.67474307e-03, -2.23336188e-04,
         3.02274362e-03,  3.49899824e-03, -3.71898734e-03,
        -1.89266552e-03,  6.40482031e-05, -3.36330151e-04,
        -1.66964286e-03],
       [-1.97645929e-03, -1.31041091e-03, -4.13796864e-04,
         2.53497134e-03, -3.62220081e-03, -7.83777621e-04,
         2.58973986e-03, -4.92989493e-04,  2.22233962e-03,
        -6.91723719e-04,  9.53010807e-04,  1.00286154e-03,
        -1.25683215e-03, -1.37775694e-03,  1.31121348e-03,
         2.00858340e-03,  8.28340068e-04, -2.35075457e-03,
         3.54539225e-05,  3.23066465e-03, -1.44837296e-03,
        -2.82297470e-03,  2.08095904e-03,  1.90168980e-03,
         2.94710649e-03, -4.46049205e-04,  2.82382499e-03,
         2.43031350e-03, -1.96834700e-03,  4.42048395e-03,
        -3.63798550e-04,  4.71410720e-04,  2.20514229e-03,
         3.95729253e-03,  1.08963344e-03, -1.01937284e-03,
        -2.06721085e-03,  1.91164215e-03, -1.98315154e-03,
         1.98730733e-03],
       [ 5.23755501e-04,  1.90174405e-03, -3.13762030e-05,
        -1.07939809e-03,  3.27289628e-04,  3.12453811e-03,
         5.20004425e-04, -2.81494134e-03,  1.14068657e-03,
        -2.73435726e-04,  3.75706144e-03, -7.12801237e-04,
         6.52309740e-04, -6.07025731e-06, -3.46768112e-03,
         1.04910135e-03, -9.10598494e-04,  7.60060735e-04,
         2.72252085e-03, -4.15064814e-03,  6.25133933e-03,
        -1.49838685e-03,  1.81092159e-03, -4.27538902e-03,
        -1.63778884e-03, -4.37928451e-04, -6.56254881e-04,
        -3.41431634e-03, -2.51760241e-04, -3.42651503e-03,
        -3.22376122e-03, -6.87196618e-04, -2.23506941e-03,
         1.40925637e-04,  2.13986356e-03, -1.98560348e-03,
        -1.39161595e-03, -1.67397829e-03,  3.09808878e-03,
         3.31212432e-05],
       [-8.63102148e-04,  6.03501801e-04,  5.72675548e-04,
        -1.05178647e-03,  9.94347152e-04,  3.18739883e-04,
         1.00144127e-03, -9.58779943e-04,  4.51569259e-03,
         2.64670909e-03,  2.18699966e-03, -2.18755519e-03,
         3.54804855e-04,  1.92257226e-03,  9.64730396e-04,
         7.51343789e-04,  2.74423952e-03, -7.40826770e-04,
        -1.19103879e-06,  9.51057125e-04,  1.63856617e-04,
        -2.94982479e-03, -1.26177445e-03,  4.54380689e-03,
         1.94993045e-03,  2.78044213e-03, -3.33147729e-03,
         2.24671955e-03, -6.44828542e-05,  1.53640099e-03,
        -1.44049968e-03,  9.29178030e-04,  3.12176277e-03,
         5.11923630e-04,  6.59566431e-04, -4.34413692e-03,
         2.81656068e-03, -1.38530927e-03,  2.05379911e-03,
        -5.31261379e-04],
       [-1.53349992e-03, -7.19381613e-04, -2.20343718e-04,
         2.40646978e-03, -2.29582912e-03, -3.51957919e-04,
         2.57477351e-03, -1.45421899e-03,  3.67716956e-03,
        -7.64404656e-04,  1.71625870e-03,  1.30145310e-03,
        -5.65605354e-04,  1.12750808e-04,  7.98399502e-04,
        -5.35139930e-04, -5.26080432e-04,  9.41247097e-04,
         9.40609199e-04,  4.60520387e-03, -8.15872918e-04,
        -4.82294895e-03, -5.33828279e-04, -6.97314565e-04,
         8.91219534e-04, -1.35474082e-03,  3.56390164e-03,
        -8.05821735e-04, -1.36458199e-03,  4.83241398e-03,
        -1.06117188e-03, -1.80859119e-03,  3.81293916e-03,
         3.39132850e-03,  7.77229492e-04,  6.77522877e-03,
        -2.84114201e-03,  7.40080746e-03, -1.04261655e-03,
         1.63983903e-03],
       [ 1.08571164e-03,  1.54769747e-03,  4.31733613e-04,
        -1.68406684e-03, -6.70240028e-04,  3.74388415e-03,
        -9.82236379e-05, -9.87153384e-04, -2.51382892e-03,
        -3.21501866e-03,  2.51095975e-03,  5.50313387e-04,
        -4.26775601e-04, -1.51313562e-03, -4.53249132e-03,
         9.35488788e-04,  1.83790005e-04,  2.97477283e-03,
         3.80726741e-03, -2.99972529e-03,  6.12591114e-03,
        -5.78766048e-04,  1.12497970e-03, -4.17283783e-03,
        -3.82260722e-03, -1.12386444e-03, -3.08304036e-04,
        -1.76266069e-03, -1.38955412e-03,  7.90393606e-05,
        -3.17361858e-03, -7.28719286e-04, -1.06857216e-03,
         2.11700611e-03,  1.66330289e-03,  5.78024483e-04,
        -2.77528656e-03, -1.75795067e-04,  2.81691260e-04,
        -1.49624574e-03],
       [-4.68247483e-04,  1.48377832e-04,  3.22486041e-04,
        -4.32703440e-04,  1.70983345e-04,  2.42491864e-04,
         3.38662881e-04, -1.63758188e-04,  1.48367928e-03,
         8.60535773e-04,  1.94895209e-03, -1.86411163e-03,
         9.21386309e-05,  1.37301465e-03, -6.21634754e-05,
        -5.36669453e-04,  1.10976736e-03, -2.03639167e-04,
        -9.55805299e-04,  7.11445173e-04,  2.95287056e-04,
        -4.73492639e-03, -3.63338913e-04,  1.60284759e-03,
         1.11225829e-03,  5.93746721e-04, -2.23487243e-03,
         2.16539344e-03, -1.16719317e-03,  1.51032885e-03,
        -2.86887446e-03, -7.15749338e-05,  4.22940822e-03,
         2.91157421e-03,  1.38001563e-03, -5.28972538e-04,
         2.22721207e-03,  1.76169432e-03,  3.44490702e-03,
        -2.99509871e-03],
       [-1.31535192e-03, -3.09231225e-04, -1.19668126e-04,
         2.70335958e-03, -1.39688805e-03, -1.53234357e-03,
         2.81773508e-03, -1.45841378e-03,  3.47304181e-03,
         2.20764981e-04,  2.22607865e-03,  2.35095806e-03,
        -5.24620409e-04, -5.42698137e-04, -1.26195047e-03,
        -1.37636438e-03, -2.45564757e-03,  2.18923832e-03,
         1.18114543e-03,  5.15283644e-03, -2.34300899e-03,
        -3.05288611e-03, -8.43662652e-04, -3.59775312e-03,
        -1.32932549e-03, -3.28743452e-04,  4.09057084e-03,
        -4.89136484e-03, -5.69525640e-04,  4.58647311e-03,
        -6.81975362e-05, -3.29664606e-03,  4.70293639e-03,
         4.05258592e-03, -3.50834127e-03,  1.42882820e-02,
        -1.79628015e-03,  9.78888851e-03, -2.97745294e-03,
         2.42469786e-03],
       [ 1.47524104e-03,  1.16691540e-03,  1.25937047e-04,
        -1.88391109e-03, -1.24634209e-03,  3.53408209e-03,
        -5.85760514e-04, -5.73365425e-04, -4.40046564e-03,
        -4.48135426e-03,  1.90310378e-03,  1.62733428e-03,
        -3.52671370e-04, -1.62117020e-03, -3.51890782e-03,
         2.08237558e-04,  2.60691759e-05,  3.52019770e-03,
         3.58330389e-03, -2.46332935e-03,  6.22738199e-03,
         2.38443585e-03,  1.48383505e-03, -4.14062990e-03,
        -4.13445476e-03, -2.38151639e-03, -6.95832714e-04,
        -1.83913240e-03, -1.37224165e-03, -2.86062685e-04,
        -1.88624999e-03, -3.26139620e-04, -2.58102547e-04,
         3.11506377e-03, -1.10254041e-03,  3.58563405e-03,
        -1.25452352e-03,  1.97840901e-03, -2.13667707e-04,
         7.99773261e-04],
       [-9.64482970e-05, -5.08769772e-05,  3.66124732e-05,
        -1.61053380e-04, -7.46744190e-05,  7.00383316e-05,
         1.46945051e-04,  1.43686571e-04,  3.39577411e-04,
         9.31214163e-05,  1.42674497e-03, -1.79943838e-03,
        -7.94560401e-06,  1.22122886e-03, -4.44742880e-04,
        -9.76107607e-04, -5.16882457e-04, -1.13641843e-04,
        -1.21565931e-03,  5.35960076e-04,  5.32874605e-04,
        -4.06728126e-03, -8.34841412e-05, -2.44236289e-04,
         1.61745731e-04, -5.51210600e-04, -2.04824260e-03,
         9.86708095e-04, -2.51654000e-03,  9.08304879e-04,
        -3.54096037e-03, -2.26106698e-04,  4.54864278e-03,
         1.96302962e-03,  1.43725413e-03,  1.00445712e-03,
         2.44297064e-03,  2.33993120e-03,  2.53089122e-03,
        -2.49138637e-03],
       [-1.44383323e-03, -3.31458141e-04, -1.28677333e-04,
         2.75148870e-03, -1.49026851e-03, -1.78619509e-03,
         2.82952003e-03, -1.55277329e-03,  3.46401497e-03,
         5.25032287e-04,  2.16628588e-03,  2.54805177e-03,
        -1.04572659e-03, -5.98228013e-04, -1.93135662e-03,
        -1.25730201e-03, -2.11260212e-03,  2.16137944e-03,
         1.03365548e-03,  5.23089245e-03, -2.86026509e-03,
        -2.29323469e-03, -1.43673795e-03, -3.00682755e-03,
        -6.99194497e-04,  3.97801603e-04,  4.38911607e-03,
        -4.30514570e-03, -1.34938548e-03,  4.26364597e-03,
         6.66600012e-04, -3.64217628e-03,  5.15452027e-03,
         3.82969202e-03, -4.24105674e-03,  1.33255832e-02,
        -1.22355577e-03,  9.59578622e-03, -4.06464515e-03,
         2.02031923e-03],
       [ 1.56463974e-03,  1.26549101e-03,  1.41348122e-04,
        -1.81875296e-03, -1.31642236e-03,  3.47199943e-03,
        -5.48046955e-04, -8.54773854e-04, -4.51751053e-03,
        -4.64480370e-03,  1.52977242e-03,  2.02691811e-03,
        -2.28725694e-04, -2.11706129e-03, -4.04320797e-03,
         1.82447868e-04, -2.86347728e-04,  4.07026522e-03,
         3.31298797e-03, -2.19318504e-03,  6.69393549e-03,
         2.72113457e-03,  1.60622492e-03, -5.08258166e-03,
        -4.49359650e-03, -2.41912226e-03, -1.97874455e-04,
        -2.42920057e-03, -1.78704748e-03, -4.56690585e-04,
        -9.95723647e-04, -3.88940563e-04,  4.42900182e-06,
         3.49340052e-03, -1.53284869e-03,  4.64464305e-03,
        -1.06279179e-03,  1.83438906e-03, -3.94055038e-04,
         1.20617554e-03],
       [ 2.87474628e-04, -2.17038993e-04, -2.24889474e-04,
         1.23364240e-04, -4.51389060e-04,  5.96457940e-05,
         6.73041141e-05,  6.02764601e-04, -1.02997094e-03,
        -8.41170084e-04,  9.90200206e-04, -1.66857592e-03,
        -3.80558253e-04,  7.95516593e-04, -1.27749878e-03,
        -1.68147474e-03, -1.66545378e-03, -2.62548390e-04,
        -1.43265747e-03,  1.29214650e-05,  5.74673293e-04,
        -3.16508720e-03,  1.57093600e-05, -2.09889351e-03,
        -7.83354044e-04, -1.01325545e-03, -1.22963951e-03,
         3.92129936e-04, -3.40242474e-03,  3.12513293e-04,
        -3.63691198e-03, -8.56757280e-04,  4.11434984e-03,
         1.57174887e-03,  9.41191276e-04,  2.51087523e-03,
         3.10910656e-03,  1.90664618e-03,  2.59848591e-03,
        -2.03201734e-03],
       [-1.30217685e-03, -2.48599245e-04, -1.71322798e-04,
         2.69616721e-03, -1.52840221e-03, -1.57905906e-03,
         2.68791593e-03, -1.56140188e-03,  3.45412851e-03,
         1.78671064e-04,  2.38474784e-03,  2.17141351e-03,
        -9.03354026e-04, -3.18600796e-04, -1.49417040e-03,
        -1.35453767e-03, -2.30265479e-03,  2.55648629e-03,
         1.12198468e-03,  4.49289847e-03, -2.49958062e-03,
        -2.65410030e-03, -6.44734129e-04, -3.32167302e-03,
        -1.23863085e-03, -3.35549616e-04,  3.51449428e-03,
        -4.74163424e-03, -1.14207785e-03,  4.49153595e-03,
         2.64968112e-04, -3.93387629e-03,  4.79237270e-03,
         3.97572853e-03, -3.20438994e-03,  1.46555286e-02,
        -1.49919256e-03,  8.04505777e-03, -4.54746280e-03,
         2.17065634e-03],
       [ 1.56797946e-03,  1.21549738e-03,  5.51190569e-05,
        -1.82799425e-03, -1.46804203e-03,  3.42316926e-03,
        -6.21603511e-04, -6.59911253e-04, -4.45966143e-03,
        -4.59536957e-03,  1.51357276e-03,  2.40303134e-03,
        -4.26130922e-04, -1.89089659e-03, -3.01543251e-03,
         3.80613579e-04,  1.82648626e-04,  3.74810747e-03,
         3.21530690e-03, -2.20059510e-03,  7.35807419e-03,
         3.71880969e-03,  1.34389999e-03, -4.87197982e-03,
        -3.97623563e-03, -2.33990559e-03, -5.51355246e-04,
        -2.38368358e-03, -1.71828503e-03, -8.34541803e-04,
        -1.17488846e-03,  1.91109983e-04, -8.88266877e-05,
         2.81019066e-03, -1.86054339e-03,  3.88760492e-03,
        -1.39491039e-03,  1.89554435e-03,  4.02719335e-04,
         1.71554147e-03],
       [ 7.86364661e-04, -8.07752018e-04, -6.14928606e-04,
         9.64215666e-04, -1.16353272e-03, -6.82645303e-04,
        -5.20504604e-04,  9.97980591e-04, -4.04669112e-03,
        -2.87253386e-03,  5.64349291e-04, -9.73972958e-04,
        -7.92088977e-04,  5.25516771e-05, -2.24975799e-03,
        -1.54269591e-03, -3.24539025e-03,  2.35487350e-05,
        -1.06804667e-03,  2.08082987e-04,  1.12190958e-06,
        -1.60019158e-03,  1.15185592e-03, -3.75498808e-03,
        -1.71752681e-03, -2.90890993e-03,  6.19309954e-04,
        -2.96691724e-04, -3.89134698e-03, -6.53215393e-05,
        -3.52116767e-03, -1.97846605e-03,  2.92679691e-03,
         2.57367990e-03, -2.90983706e-04,  5.45300823e-03,
         2.45591882e-03,  3.32312728e-03,  1.13668875e-03,
        -1.22830819e-03],
       [-1.63933495e-03, -6.89708511e-04, -4.14836948e-04,
         2.55086995e-03, -2.00627139e-03, -9.04202869e-04,
         2.50758603e-03, -1.20956241e-03,  3.69665842e-03,
        -4.24681028e-04,  2.35887687e-03,  1.00092404e-03,
        -7.24295387e-04,  5.97746577e-04, -1.00666119e-04,
        -9.11845418e-05, -5.66131086e-04,  1.56971847e-03,
         1.87355198e-03,  3.30869295e-03, -3.25313769e-03,
        -2.20341166e-03, -2.45741778e-03, -2.07732036e-03,
         1.04084681e-03,  8.56221013e-04,  2.23468570e-03,
        -1.83734111e-03,  2.96189886e-04,  4.45642835e-03,
         2.37940974e-03, -1.02091301e-03,  9.41348379e-04,
         3.98011552e-03, -1.78472628e-03,  5.71569195e-03,
        -2.81419535e-03,  5.95681975e-03, -3.24834045e-03,
         2.20352318e-03],
       [ 1.28221628e-03,  1.76132517e-03,  4.23091202e-04,
        -1.44903990e-03, -1.29619788e-03,  3.72271519e-03,
         2.79073342e-04, -5.54232683e-04, -2.51541706e-03,
        -3.50451446e-03,  1.31063547e-03,  2.88709067e-03,
        -1.68243088e-04, -2.06506788e-03, -2.95584812e-03,
         3.22961714e-04,  8.09641439e-04,  3.45862168e-03,
         2.61805742e-03, -1.66374876e-03,  8.01940449e-03,
         3.52570112e-03,  1.35630631e-04, -6.04599295e-03,
        -2.06943485e-03, -1.19860761e-03,  8.73565092e-04,
        -2.52915872e-03, -1.84052356e-03,  7.76376342e-04,
        -3.33489297e-04,  3.64604610e-04, -6.38899335e-04,
         3.47704790e-03, -6.05689536e-04,  3.04168556e-03,
        -2.29000230e-03,  6.85370644e-04,  1.02840096e-03,
        -1.16565835e-03],
       [ 1.46899803e-03, -1.42758200e-03, -1.09001552e-03,
         1.20164151e-03, -1.65998121e-03, -6.48802612e-04,
        -4.24425292e-04,  5.49333228e-04, -6.68388465e-03,
        -4.06171102e-03,  7.40563846e-04, -1.38450367e-03,
        -4.52215667e-04, -2.08144280e-04,  1.50344844e-04,
        -7.49832452e-06, -4.11193073e-03, -3.21873958e-04,
         1.19797543e-04, -1.08315726e-03,  1.39076635e-03,
         3.53698648e-04,  1.51108007e-03, -3.22471326e-03,
        -1.91060524e-03, -3.32377246e-03,  3.49093066e-03,
        -4.05181345e-04, -1.70387281e-03, -2.46943836e-03,
        -3.85949179e-03,  2.21157959e-03,  3.89597355e-03,
        -2.07344932e-03, -1.24021829e-03,  5.64736268e-03,
         5.65401046e-03, -5.32833801e-04,  1.48001162e-03,
         3.58612253e-03],
       [-1.99365220e-03, -1.36255659e-03, -6.23440254e-04,
         2.61786883e-03, -3.26061132e-03, -1.46668125e-03,
         2.27568368e-03,  7.91382336e-05,  1.46267971e-03,
        -1.22957991e-03,  1.41904992e-03,  1.60210984e-04,
        -9.42638260e-04, -1.79845549e-04,  8.36332620e-04,
         2.63318978e-03,  9.06677684e-04, -9.04746958e-06,
         9.58294084e-04,  1.49024941e-04, -4.50617447e-03,
        -1.52886531e-03, -7.78930204e-04,  2.48727138e-05,
         1.98236527e-03,  1.32645573e-03,  1.68113504e-04,
         5.59146691e-04,  1.56734337e-03,  3.37382220e-03,
         2.29014619e-03,  1.15001039e-03, -2.10378203e-03,
         2.60725245e-03, -1.45209441e-03, -2.62472569e-03,
        -1.45575230e-03, -1.32543931e-03, -2.36033206e-03,
         2.62548658e-03],
       [ 7.17892020e-04,  2.07583583e-03,  2.84830923e-04,
        -8.52500147e-04, -3.67605855e-04,  3.26425163e-03,
         5.15188323e-04, -2.14935327e-03,  1.06986891e-03,
        -7.59757240e-04,  1.85738178e-03,  1.85504206e-03,
         1.29753662e-05, -1.68724835e-03, -2.16876366e-03,
        -1.07377383e-03, -5.93910983e-04,  1.33425335e-03,
         4.92399908e-04, -7.05321261e-04,  7.13502197e-03,
         4.57544113e-03, -6.38509111e-04, -6.14350243e-03,
         1.56655937e-04, -1.11422432e-03,  5.71107026e-04,
        -3.23855551e-03, -1.29743654e-03,  1.02534902e-03,
        -1.29375752e-04,  8.22348054e-04, -1.35363359e-03,
         1.65468047e-03,  4.79981216e-04,  4.09493502e-03,
        -1.97787466e-03,  8.71905300e-04,  4.28381795e-03,
        -2.11314112e-03],
       [ 9.20085644e-04, -5.14991756e-04, -4.73751046e-04,
         4.95147717e-04, -7.19982956e-04,  2.82073859e-04,
        -7.92947467e-05,  6.22895896e-04, -2.69440957e-03,
        -2.19945703e-03,  1.46160438e-03, -1.75250520e-03,
        -3.48823552e-04,  9.72862414e-04, -9.42954386e-04,
         1.80329662e-03, -1.93461741e-03,  4.38346324e-04,
        -4.66683647e-04, -6.52400893e-04,  1.04544999e-03,
        -6.54587289e-04, -3.20176390e-04, -2.88021658e-03,
        -1.34614331e-03, -1.26232358e-03,  2.21885764e-03,
        -7.30657252e-04, -4.25611669e-03,  1.03694713e-03,
        -3.45804449e-03,  2.28020595e-03,  4.69681900e-03,
         1.88786990e-03,  1.04853581e-03,  4.90462547e-03,
         6.38923980e-03,  4.92014689e-04,  1.54852238e-03,
         5.56695508e-04],
       [-1.86783576e-03, -1.82164961e-03, -9.15233162e-04,
         3.15147359e-03, -3.54621233e-03, -2.73318123e-03,
         2.87552318e-03,  1.94007298e-04,  2.68480973e-03,
        -1.41980674e-03,  1.59027253e-03,  2.84108479e-04,
        -8.85161047e-04,  2.80080130e-03,  3.07115354e-03,
        -1.40861445e-03,  2.09576869e-03,  1.82920811e-03,
         2.77957926e-03,  1.36721658e-03, -5.29258372e-03,
        -1.13964801e-04, -2.57465942e-03,  3.66165303e-03,
        -1.68794324e-03,  2.62167025e-03,  4.85595490e-04,
        -1.10646407e-03,  5.34421206e-03,  3.23743257e-03,
         2.19517946e-03, -1.85841357e-03,  1.28353065e-06,
        -9.95347509e-04, -3.88651824e-04, -1.56106078e-03,
        -1.42083981e-03, -2.14513531e-03,  2.50621873e-04,
         6.27751928e-03],
       [ 1.15330203e-03,  1.11612596e-03, -1.92965963e-04,
        -1.26856333e-03, -1.49196608e-03,  2.22717412e-03,
         2.70651974e-04, -5.10450976e-04, -3.59647791e-03,
        -3.81797994e-03,  2.20589992e-03,  3.20480298e-03,
         1.45888492e-03, -1.74467568e-03, -1.45052664e-03,
        -2.10224930e-03, -2.84594111e-03,  1.30442623e-03,
         3.61159531e-04,  3.45922366e-04,  5.60577866e-03,
         2.58849212e-03,  2.85120890e-03, -6.71699643e-03,
        -5.07754600e-03, -1.10165332e-03,  4.18391405e-03,
        -3.38259595e-03, -6.81493781e-04,  1.48649549e-03,
         8.37947766e-04, -2.33826553e-03, -2.48352019e-03,
         3.26740206e-03, -4.45808866e-04,  3.03015020e-03,
         8.36697116e-04,  9.33631614e-04,  3.51776928e-03,
        -3.27518419e-03],
       [ 5.11519320e-04, -2.56838975e-04, -2.53074220e-04,
         6.88041910e-05, -2.82073655e-04,  2.66228686e-04,
         2.92918703e-04,  4.74244705e-04, -1.18595944e-03,
        -1.04466232e-03,  1.64193579e-03, -1.98244979e-03,
        -2.43914270e-04,  1.30227767e-03, -8.18967063e-04,
         1.32266444e-03, -9.96970455e-04,  6.27906236e-04,
         1.66089048e-05, -8.00977112e-04,  8.98117025e-04,
        -1.60092732e-03, -4.40813805e-04, -1.31348462e-03,
        -1.31945580e-03, -8.10190046e-04,  1.11731724e-03,
        -2.53989099e-04, -4.73528774e-03,  8.41784757e-04,
        -2.97530484e-03,  1.46084768e-03,  4.42243274e-03,
         2.06077751e-03,  1.85038871e-03,  3.90475383e-03,
         5.83838485e-03, -1.55207803e-04,  1.72287272e-03,
        -3.71538481e-04],
       [-1.90142856e-03, -1.96491391e-03, -1.01518864e-03,
         3.25789698e-03, -3.99036240e-03, -3.14210868e-03,
         3.21489223e-03,  5.20030851e-04,  3.17145279e-03,
        -1.58232509e-03,  1.60582608e-03,  6.56308606e-04,
        -7.03302096e-04,  3.85159324e-03,  4.28030221e-03,
        -2.91799032e-03,  1.96358468e-03,  1.81006652e-03,
         2.94422568e-03,  2.94137350e-03, -5.80571219e-03,
         4.56045062e-04, -3.95066803e-03,  5.39717451e-03,
        -1.24048954e-03,  2.89886305e-03,  2.37302083e-05,
        -1.21005857e-03,  7.13534700e-03,  2.44733063e-03,
         9.25923174e-04, -3.93905258e-03,  2.33563027e-04,
        -1.17190822e-03,  5.45207527e-04, -1.78742351e-03,
        -1.37827010e-03, -2.38915649e-03,  1.32796355e-03,
         6.95754774e-03],
       [ 1.31646683e-03,  4.94713022e-04, -3.12437012e-04,
        -1.29963993e-03, -1.67456316e-03,  1.77095050e-03,
         5.37092972e-04,  7.65373916e-05, -5.86216757e-03,
        -4.71706362e-03,  1.95334945e-03,  3.30443354e-03,
         2.16146954e-03, -1.89295318e-03, -1.33053632e-03,
        -2.98297498e-03, -3.91758792e-03,  9.38527461e-04,
         6.91230292e-04,  4.24345606e-04,  6.26916578e-03,
         1.12722069e-03,  4.23573237e-03, -7.34995399e-03,
        -6.00599684e-03, -1.51133852e-03,  4.64057596e-03,
        -3.15478630e-03, -5.56962215e-04,  4.14441602e-05,
         3.48467329e-05, -3.30735114e-03, -2.11682124e-03,
         3.36243073e-03, -6.39357604e-04,  2.60098442e-03,
         1.35562732e-03,  1.66596740e-03,  2.73942645e-03,
        -1.52119505e-03],
       [ 4.94472879e-05, -1.09654437e-04, -2.00724571e-06,
        -1.34449074e-04, -1.17362477e-04,  1.60259689e-04,
         4.93018131e-04,  3.33973003e-04, -3.72988652e-05,
        -2.73642188e-04,  1.62712263e-03, -2.03642063e-03,
        -2.51520134e-04,  1.29106874e-03, -4.90236853e-04,
         9.77631076e-04, -5.24349394e-04,  3.92442627e-04,
        -3.42460116e-05, -4.43516357e-04,  3.53081035e-04,
        -2.30932841e-03, -2.49644596e-04,  6.49672176e-04,
        -6.59322133e-04, -1.00239727e-03,  7.26291728e-06,
         3.46800662e-04, -4.20291815e-03,  9.48614441e-04,
        -2.32319185e-03,  1.52999037e-05,  3.26942280e-03,
         1.63827487e-03,  2.58573587e-03,  1.89552957e-03,
         4.11756709e-03, -7.41392432e-04,  1.14228891e-03,
        -8.73988494e-04],
       [-1.83397485e-03, -1.89488346e-03, -1.07275543e-03,
         3.18426499e-03, -4.05472331e-03, -3.07816849e-03,
         3.36557417e-03,  7.60805269e-04,  3.65751586e-03,
        -1.93583779e-03,  1.51689211e-03,  1.02740258e-03,
        -5.62563539e-04,  4.02472727e-03,  4.87744063e-03,
        -3.60897393e-03,  1.43975206e-03,  1.17088330e-03,
         2.52549956e-03,  4.00140323e-03, -5.69039630e-03,
         4.15361836e-04, -4.51216428e-03,  5.98795945e-03,
        -6.39601436e-04,  3.22314072e-03,  2.00353697e-05,
        -1.55033427e-03,  7.04425015e-03,  2.03199708e-03,
        -3.61122540e-04, -4.56233136e-03,  1.43688207e-03,
        -6.38253696e-04,  1.08854810e-03, -8.75267899e-04,
        -1.18869473e-03, -1.68265111e-03,  1.83239137e-03,
         7.66021293e-03],
       [ 1.33063283e-03,  3.19078477e-04, -2.92244018e-04,
        -1.40809664e-03, -1.61765493e-03,  1.86222966e-03,
         6.17014011e-04,  2.68381147e-04, -6.29001763e-03,
        -5.01973834e-03,  1.97702390e-03,  2.96007376e-03,
         2.45476933e-03, -1.94713706e-03, -1.65611890e-03,
        -3.10215843e-03, -4.28272411e-03,  2.41582093e-04,
         6.11672003e-04,  1.09717745e-04,  6.34323945e-03,
        -7.70677114e-04,  4.54729190e-03, -8.02336354e-03,
        -5.63435024e-03, -1.87860767e-03,  4.56884643e-03,
        -2.53694179e-03, -1.34588941e-03, -4.31979388e-05,
        -7.02430028e-04, -3.09617817e-03, -1.46113744e-03,
         4.32958454e-03,  1.16781455e-04,  2.13118875e-03,
         1.08807930e-03,  2.10680417e-03,  2.34567118e-03,
        -1.20449020e-03],
       [-4.27728461e-04,  4.46299528e-05,  2.61248788e-04,
        -4.49744053e-04,  3.45455701e-05, -1.40376855e-04,
         5.87192189e-04,  1.25117789e-04,  1.21187477e-03,
         6.18733000e-04,  1.80827023e-03, -2.22426187e-03,
        -2.76504870e-04,  1.48282514e-03, -2.60243232e-05,
         6.96570845e-04,  1.21645993e-04,  2.43640056e-06,
         4.37102499e-05, -4.11951942e-06, -2.93115445e-04,
        -2.83055217e-03, -4.60915879e-04,  2.71425536e-03,
        -3.34929500e-05, -9.74179013e-04, -1.30507455e-03,
         1.25765288e-03, -3.34863504e-03,  4.91346116e-04,
        -1.48717628e-03, -1.00631162e-03,  2.09181453e-03,
         1.54255051e-03,  2.15664599e-03, -6.11374155e-04,
         2.26027286e-03, -1.00596051e-03,  6.31906732e-04,
        -6.30202645e-04],
       [-1.89188996e-03, -1.88221235e-03, -9.22468724e-04,
         3.06570763e-03, -3.89046175e-03, -2.95536965e-03,
         3.32037755e-03,  8.17818276e-04,  3.56942229e-03,
        -1.56173261e-03,  1.35812606e-03,  1.06184080e-03,
        -6.72254013e-04,  3.12217325e-03,  4.78407042e-03,
        -3.26236337e-03,  1.51278439e-03,  8.70036369e-04,
         2.54564942e-03,  4.60872240e-03, -5.00722835e-03,
         3.10199939e-05, -3.06184869e-03,  6.02440909e-03,
        -2.04303855e-04,  2.56573036e-03,  4.16618335e-04,
        -7.12160370e-04,  6.49558892e-03,  1.08546147e-03,
        -8.48254655e-04, -3.85614065e-03,  2.54107662e-03,
        -8.89186049e-04,  5.61252644e-04, -1.15703337e-03,
        -1.58873585e-03, -1.11992995e-03,  2.48472951e-03,
         7.16315163e-03],
       [ 1.25657709e-03,  4.65431687e-04, -3.41109233e-04,
        -1.33567676e-03, -1.50618027e-03,  1.89693668e-03,
         6.91683788e-04,  1.21586856e-06, -5.84497117e-03,
        -4.64795390e-03,  2.14160234e-03,  2.55177054e-03,
         2.25002412e-03, -1.92252838e-03, -1.44392205e-03,
        -2.64114072e-03, -4.10108594e-03,  2.07820121e-04,
         1.32392265e-03, -6.40049286e-04,  5.80335828e-03,
        -8.21205846e-04,  4.74362681e-03, -7.48637225e-03,
        -5.71994251e-03, -2.03828933e-03,  3.95349320e-03,
        -2.92423670e-03, -4.13400528e-04, -6.84540311e-04,
        -5.45690593e-04, -3.08870571e-03, -6.11772062e-04,
         3.92109947e-03,  4.79146518e-04,  6.96417235e-04,
         9.60156322e-04,  2.40360620e-03,  2.53257807e-03,
        -1.26814493e-03],
       [-8.06786586e-04,  2.60279368e-04,  4.80841147e-04,
        -9.22348816e-04,  6.30657363e-04, -1.50509339e-04,
         8.71462224e-04,  8.88319555e-05,  2.46876664e-03,
         1.55142730e-03,  1.65050733e-03, -1.78456516e-03,
         7.82887400e-06,  1.48660503e-03,  5.40852372e-04,
         1.64789642e-04,  1.01048232e-03, -1.59874588e-04,
         5.81756583e-04,  1.05428614e-03, -7.41401978e-04,
        -2.75407336e-03, -2.84292735e-04,  4.15519811e-03,
         7.79119029e-04, -1.23633406e-04, -2.22315895e-03,
         2.31154612e-03, -2.79838219e-03, -8.83400440e-04,
        -6.20706647e-04, -2.43705162e-03,  1.07658352e-03,
         1.62536255e-03,  1.29587681e-03, -1.58808869e-03,
         1.17161486e-03,  2.52940281e-05,  4.93997999e-04,
        -6.35580218e-04],
       [-1.90183532e-03, -1.69253489e-03, -7.63055345e-04,
         3.03001632e-03, -3.44511261e-03, -2.44886708e-03,
         2.87823286e-03,  3.65656102e-04,  2.99960747e-03,
        -1.27033493e-03,  1.11814996e-03,  9.75541421e-04,
        -8.36654624e-04,  1.76674069e-03,  4.05956898e-03,
        -1.80148392e-03,  1.41514628e-03,  5.11299353e-04,
         2.04732083e-03,  4.02694521e-03, -3.86338355e-03,
        -3.89765220e-04, -1.14082033e-03,  4.37898096e-03,
         4.60863346e-04,  2.29316275e-03,  9.94338305e-04,
         1.19538316e-04,  4.09574667e-03,  6.67030981e-04,
        -9.67610162e-04, -1.39508105e-03,  4.15048422e-03,
        -4.33563429e-04, -8.78463179e-05,  2.28677571e-04,
        -1.84653874e-03,  1.33613567e-03,  2.27684667e-03,
         6.68130210e-03],
       [ 1.00592885e-03,  1.04020711e-03, -2.97846738e-04,
        -1.30763056e-03, -1.09295093e-03,  2.37932126e-03,
         4.98047564e-04, -8.91885255e-04, -3.86448833e-03,
        -3.49534117e-03,  2.78038834e-03,  1.62784685e-03,
         1.55411067e-03, -1.75686879e-03, -2.01649801e-03,
        -1.39719818e-03, -3.24605266e-03,  2.62242247e-04,
         2.11196276e-03, -2.10743537e-03,  4.37629409e-03,
        -1.08083722e-03,  4.33005579e-03, -6.43174862e-03,
        -5.66918403e-03, -1.78823387e-03,  2.89028534e-03,
        -3.65324854e-03, -7.41322641e-04, -5.48846147e-04,
        -1.40210288e-03, -2.76705949e-03, -1.31422910e-03,
         3.69269820e-03,  8.44924012e-04, -7.97717075e-04,
         7.21251185e-04,  2.28297641e-03,  2.69718561e-03,
        -1.92718557e-03],
       [-1.23747264e-03,  1.17630931e-03,  1.12220005e-03,
        -1.47560390e-03,  1.38599449e-03,  6.17469428e-04,
         1.03151053e-03, -7.34656875e-04,  5.91257820e-03,
         3.29023530e-03,  1.82981486e-03, -1.99200213e-03,
        -2.89157790e-04,  1.45293900e-03, -9.45390435e-04,
         1.50529691e-03,  2.62206770e-03, -4.28377622e-04,
         8.14213825e-04,  8.44202761e-04, -5.67993033e-04,
        -3.44347255e-03, -4.44749108e-04,  5.29618608e-03,
         1.22815743e-03,  4.43376106e-04, -2.33330578e-03,
         1.64293288e-03, -4.74305404e-03,  2.70220404e-03,
         1.32492249e-04, -3.27968248e-03,  3.19681334e-04,
         2.88133207e-03,  2.58333841e-03, -3.35416407e-03,
        -1.34382374e-03,  5.76042628e-04, -2.56594998e-04,
        -2.20872997e-03],
       [-1.91739411e-03, -1.27293833e-03, -4.83706826e-04,
         2.68403091e-03, -3.23879695e-03, -1.17109471e-03,
         2.27906019e-03, -3.51976894e-04,  2.55091512e-03,
        -1.01633335e-03,  8.42778827e-04,  1.24707143e-03,
        -1.23419031e-03, -3.82567145e-04,  1.99995027e-03,
         1.35621545e-03,  5.64084796e-04, -1.63108122e-03,
         5.86227921e-04,  3.98709439e-03, -2.34683743e-03,
        -1.86169229e-03,  1.61685119e-03,  1.71730446e-03,
         2.20436975e-03,  3.57335986e-04,  2.49818666e-03,
         1.08289008e-03, -1.43173547e-03,  3.51182767e-03,
        -4.96657740e-04,  1.07391202e-03,  2.82843830e-03,
         4.31358209e-03, -8.71917349e-04,  8.97229242e-04,
        -2.02342682e-03,  3.71104875e-03, -8.46124894e-04,
         3.17356223e-03],
       [ 4.75235720e-04,  1.87672256e-03,  1.07158179e-04,
        -1.10305485e-03,  1.68120372e-04,  3.11202835e-03,
         4.49737301e-04, -2.07947637e-03,  6.89591863e-04,
        -8.14702129e-04,  3.55476397e-03, -4.57697053e-04,
         4.00584482e-04, -4.27932158e-04, -3.89489252e-03,
         9.61517741e-04, -8.04883079e-04,  1.11595262e-03,
         3.06577026e-03, -3.60667170e-03,  5.61708491e-03,
        -1.18157349e-03,  1.93720427e-03, -3.91302258e-03,
        -2.86942534e-03, -6.14464050e-04, -9.57663287e-05,
        -4.13951790e-03, -3.32535157e-04, -1.99264777e-03,
        -2.62472080e-03, -1.85667898e-03, -2.81723752e-03,
         1.07754301e-03,  3.50090791e-03, -3.66553525e-03,
        -2.60223076e-03, -1.59418886e-03,  3.68025876e-03,
        -3.82545171e-04],
       [-4.28541680e-04,  3.26491543e-04,  4.28843196e-04,
        -7.09498243e-04,  3.25160479e-04,  2.75034778e-04,
         4.46674647e-04, -4.81119263e-04,  2.28633638e-03,
         1.51177647e-03,  1.86156062e-03, -2.43536197e-03,
         8.72137971e-05,  1.17598067e-03,  1.62932192e-04,
        -1.53458604e-04,  6.62616454e-04, -4.75742214e-04,
        -4.03512706e-04, -2.54454299e-05,  5.94302313e-04,
        -3.93823022e-03, -5.98250073e-04,  2.37939181e-03,
         6.13015087e-04, -1.66523925e-04, -2.23314390e-03,
         1.38264883e-03, -2.93373363e-03,  1.59027975e-03,
        -2.35024956e-03, -1.47924665e-03,  3.46830417e-03,
         1.47864514e-03,  1.93924713e-03, -2.28670076e-03,
         1.76176301e-03,  3.59345868e-04,  1.18861883e-03,
        -1.76008802e-03],
       [-1.68602308e-03, -1.04285427e-03, -5.38601598e-04,
         2.76786275e-03, -2.41112220e-03, -1.59261608e-03,
         2.44804006e-03, -9.15318844e-04,  3.55869485e-03,
        -6.34432130e-04,  2.15888955e-03,  1.73252332e-03,
        -1.04974466e-03,  1.50331378e-03,  1.32816134e-03,
        -1.36597198e-03,  3.11588345e-04,  1.84043415e-03,
         1.26359682e-03,  4.25797049e-03, -3.28521407e-03,
        -8.27588257e-04, -1.70080177e-03,  2.92962126e-04,
        -3.15353478e-04,  2.17125937e-03,  2.72127683e-03,
        -2.11533066e-03,  2.25304486e-03,  4.20094654e-03,
        -1.26228773e-03, -8.61271692e-04,  4.93727252e-03,
         2.32552947e-03, -2.71085091e-03,  5.45809045e-03,
        -2.53485749e-04,  6.22845814e-03, -3.50147020e-04,
         6.80716289e-03],
       [ 1.13042456e-03,  8.11616716e-04,  1.20192851e-06,
        -1.03222358e-03, -1.68272760e-03,  2.59669893e-03,
        -3.41864186e-04, -8.61593871e-05, -4.48484207e-03,
        -4.47059935e-03,  1.79378630e-03,  2.09226692e-03,
         5.33067621e-04, -1.78629917e-03, -3.36824218e-03,
         8.03251518e-04, -6.39653532e-04,  3.10215750e-03,
         3.68446368e-03, -1.15923746e-03,  4.91939485e-03,
         9.59386060e-04,  2.84142443e-03, -5.34362299e-03,
        -5.09389397e-03, -6.77282980e-04,  1.77221023e-03,
        -3.41217523e-03, -1.11234013e-03, -2.22975868e-04,
        -1.61177095e-03, -1.78010017e-03,  7.01887242e-04,
         5.10789268e-03,  4.23511228e-04,  9.98601783e-04,
        -2.45834165e-03,  1.67721137e-03,  2.38542887e-03,
        -1.69286539e-03],
       [-2.88775186e-06, -1.16207455e-04,  4.36637965e-05,
        -1.74779561e-04, -1.51726883e-04,  1.92896332e-04,
         1.25093895e-04,  8.44296083e-05,  7.22499826e-05,
        -4.17362498e-05,  1.47471030e-03, -1.93265860e-03,
        -2.96727540e-05,  1.09761348e-03, -3.15793935e-04,
        -4.29358421e-04, -8.74953112e-04, -7.52611741e-05,
        -8.88009963e-04, -1.25703127e-05,  6.61077618e-04,
        -3.72829172e-03, -3.50730435e-04, -1.54960158e-04,
        -4.76128344e-06, -8.38525826e-04, -1.32153078e-03,
         9.37076809e-04, -3.22989444e-03,  7.65492499e-04,
        -2.95983022e-03, -3.83315113e-04,  3.90632404e-03,
         2.00106669e-03,  2.19403207e-03,  7.42909440e-04,
         3.24013783e-03,  7.45102298e-04,  1.32744783e-03,
        -1.27332809e-03],
       [-1.71155401e-03, -9.32030380e-04, -4.50074091e-04,
         2.80561019e-03, -2.36136583e-03, -1.98592851e-03,
         2.84135924e-03, -1.12765981e-03,  3.56400595e-03,
        -5.26928983e-04,  2.19822791e-03,  1.85530155e-03,
        -1.14406273e-03,  1.49409915e-03,  9.60705569e-04,
        -1.99972419e-03, -1.50181237e-04,  2.13739579e-03,
         1.05258881e-03,  4.42024274e-03, -3.54900816e-03,
        -1.86883713e-04, -2.07671570e-03, -6.21197862e-04,
        -1.13226241e-03,  2.36685015e-03,  2.70298449e-03,
        -3.35299154e-03,  2.20464426e-03,  5.53067215e-03,
         6.05546702e-05, -1.83717068e-03,  4.05961135e-03,
         1.16681785e-03, -2.25607073e-03,  7.80536095e-03,
         5.91005664e-05,  6.04019500e-03, -1.27355079e-03,
         5.38745197e-03],
       [ 1.33387360e-03,  7.41747441e-04, -1.02296844e-05,
        -1.01151236e-03, -1.96583732e-03,  2.42258888e-03,
        -1.68983112e-04, -9.40938753e-06, -5.37319807e-03,
        -4.83034551e-03,  1.45631761e-03,  2.47273804e-03,
         5.06218115e-04, -1.81594060e-03, -3.60771338e-03,
         4.76768691e-05, -1.01283593e-04,  3.71959922e-03,
         3.49070411e-03, -6.20457518e-04,  5.50741144e-03,
         2.49582785e-03,  2.32688873e-03, -5.84495394e-03,
        -5.03452355e-03, -1.44104788e-03,  1.45701098e-03,
        -4.76268493e-03, -6.98542397e-04,  1.06855715e-03,
        -3.02875997e-04, -2.52058590e-03,  4.36818227e-04,
         4.99191554e-03, -1.22365728e-03,  3.23486328e-03,
        -1.81710697e-03,  1.00978801e-03,  1.51098275e-03,
        -6.79857854e-04],
       [ 4.45804326e-04, -4.83460288e-04, -4.14562353e-04,
         3.37226782e-04, -6.73794129e-04, -6.91776950e-05,
        -4.59705079e-05,  4.22792567e-04, -2.03340035e-03,
        -1.53156393e-03,  8.29269877e-04, -1.65974523e-03,
        -3.17921891e-04,  9.39840800e-04, -5.10331418e-04,
        -7.33303023e-04, -2.13348563e-03,  1.13778027e-04,
        -7.27969629e-04, -2.58957123e-04,  5.98365499e-04,
        -2.71693780e-03,  6.06982212e-04, -1.99997192e-03,
        -7.24827813e-04, -1.82010676e-03,  5.17372158e-04,
         2.35518266e-04, -3.46325943e-03,  1.75038978e-04,
        -3.61247058e-03,  7.22895842e-04,  3.76377744e-03,
         1.92575308e-03,  1.95027119e-03,  4.18587541e-03,
         3.85941821e-03,  1.35123834e-03,  9.07254231e-04,
        -6.70303532e-04],
       [-1.68040011e-03, -1.00760569e-03, -5.39431232e-04,
         2.73948209e-03, -2.40134634e-03, -1.80722901e-03,
         2.50537251e-03, -8.48588184e-04,  3.52940080e-03,
        -5.00729715e-04,  2.45326781e-03,  1.40468474e-03,
        -1.01377664e-03,  1.91914861e-03,  8.25155992e-04,
        -9.64930514e-04,  2.32172664e-04,  2.35779793e-03,
         1.88876328e-03,  3.62916244e-03, -4.37612273e-03,
        -1.56650160e-04, -2.85020890e-03,  3.53373005e-04,
        -1.02073560e-03,  2.91895377e-03,  1.99654163e-03,
        -2.10562185e-03,  2.79153045e-03,  4.74158255e-03,
        -2.94033845e-04, -1.67679985e-03,  3.12628807e-03,
         1.73241436e-03, -2.99762771e-03,  5.32741053e-03,
         2.72030684e-05,  5.24113700e-03, -1.02025375e-03,
         5.87841729e-03],
       [ 1.22046820e-03,  8.39236018e-04, -3.79937446e-05,
        -7.74168235e-04, -1.94922683e-03,  2.48427270e-03,
        -2.59729248e-04,  1.95424727e-04, -4.53045452e-03,
        -4.98573249e-03,  1.18418259e-03,  2.75665871e-03,
         6.11741270e-04, -2.08536047e-03, -3.11680115e-03,
         4.75139852e-04, -5.79811021e-05,  3.24025680e-03,
         2.55962904e-03, -5.23624127e-04,  6.13546697e-03,
         3.55307269e-03,  1.75811839e-03, -6.43109158e-03,
        -4.48733894e-03, -5.47883566e-04,  2.27835774e-03,
        -3.81483068e-03, -1.22739631e-03,  6.97293086e-04,
         5.07779710e-04, -9.88003798e-04, -6.90895715e-04,
         4.41099051e-03, -2.49914185e-04,  2.00228929e-03,
        -1.87795982e-03,  1.61575607e-03,  3.30266193e-03,
        -1.75280008e-03],
       [ 1.38590136e-03, -1.28341082e-03, -9.89174703e-04,
         1.08105992e-03, -1.51940878e-03, -4.88373684e-04,
        -4.15424613e-04,  5.88010007e-04, -5.97379217e-03,
        -3.85537371e-03,  7.65876262e-04, -1.50901265e-03,
        -5.24946605e-04, -5.31664336e-05,  1.38330593e-04,
        -9.43726700e-05, -3.72245326e-03, -3.10317497e-04,
         3.27476300e-04, -9.15174081e-04,  1.47062703e-03,
         1.94116379e-04,  7.55386602e-04, -3.05222999e-03,
        -1.76552741e-03, -3.16044781e-03,  3.23584001e-03,
        -7.28310901e-04, -1.87255535e-03, -2.13441858e-03,
        -4.26788721e-03,  2.41106562e-03,  4.05683927e-03,
        -1.44849939e-03, -5.83621673e-04,  5.20822359e-03,
         5.19159529e-03, -9.02915024e-04,  1.89214759e-03,
         3.29334568e-03],
       [-1.94615300e-03, -1.31996674e-03, -6.90294255e-04,
         2.69459747e-03, -3.07738734e-03, -1.55246595e-03,
         2.06284598e-03, -3.62842911e-05,  1.82989333e-03,
        -1.16024981e-03,  1.52057456e-03,  3.03063192e-04,
        -9.95526207e-04,  2.07264035e-04,  1.05742784e-03,
         2.02755048e-03,  8.03078467e-04,  1.29654174e-04,
         1.34101859e-03,  6.64306455e-04, -4.84385528e-03,
        -1.36192190e-03, -1.11956871e-03,  2.14449508e-04,
         1.46569661e-03,  1.78998837e-03,  5.92670631e-06,
         2.14871980e-04,  1.50998670e-03,  3.08987894e-03,
         1.73949229e-03,  1.30607060e-03, -1.79807446e-03,
         2.69085565e-03, -2.46286672e-03, -1.13520410e-03,
        -1.27948541e-03, -1.98629728e-04, -1.95043301e-03,
         3.35148489e-03],
       [ 6.61647937e-04,  2.01132172e-03,  3.09770607e-04,
        -8.58720334e-04, -4.76686633e-04,  3.32911592e-03,
         4.51851927e-04, -1.43319240e-03,  7.50975159e-04,
        -1.31944602e-03,  1.93926203e-03,  2.15872447e-03,
        -1.02738850e-04, -1.69662852e-03, -2.54897750e-03,
        -9.47216235e-04, -3.80967598e-04,  1.75312848e-03,
         8.27094540e-04, -4.90765728e-04,  7.00172456e-03,
         4.62635281e-03, -1.07075437e-03, -5.66336280e-03,
        -8.87707225e-04, -3.97469412e-04,  4.87615471e-04,
        -3.37782805e-03, -1.17991655e-03,  1.83967699e-03,
         1.22258905e-04, -6.26018737e-05, -1.53089827e-03,
         2.56115571e-03,  1.12149003e-03,  2.52913241e-03,
        -2.04813154e-03, -4.48074570e-05,  4.80320491e-03,
        -2.90271314e-03],
       [ 4.60876443e-04, -3.00040992e-04, -2.35393818e-04,
         2.47785298e-04, -5.86454989e-04,  3.33883887e-04,
         3.43161332e-06,  2.52562138e-04, -1.54386635e-03,
        -1.14353083e-03,  1.35222753e-03, -2.10838392e-03,
        -1.90616687e-04,  8.48722120e-04, -8.41316360e-04,
         6.46680826e-04, -1.46583118e-03, -2.59912835e-04,
        -4.74794128e-04, -8.02536437e-04,  7.28428829e-04,
        -2.10953853e-03,  1.25739840e-04, -1.69929524e-03,
        -6.33964199e-04, -1.50401844e-03,  8.40932131e-04,
        -5.15997875e-04, -4.51628864e-03,  6.01052830e-04,
        -3.36918165e-03,  1.71694404e-03,  4.65241773e-03,
         1.32074684e-03,  2.75698770e-03,  3.94132687e-03,
         5.55008370e-03,  1.07989146e-03,  1.11995637e-03,
        -1.46130493e-04],
       [-1.68438104e-03, -1.17781002e-03, -6.82624930e-04,
         2.81727500e-03, -2.67528673e-03, -1.95722934e-03,
         2.59274384e-03, -7.28395011e-04,  3.56465788e-03,
        -6.55862968e-04,  2.39809835e-03,  1.30915910e-03,
        -1.09750510e-03,  2.23225052e-03,  1.35672069e-03,
        -1.03177689e-03,  6.95927534e-04,  2.15358986e-03,
         2.14544847e-03,  3.59695335e-03, -4.99385875e-03,
         1.99987393e-04, -2.68517644e-03,  9.88557935e-04,
        -6.65151747e-04,  3.11414665e-03,  1.59289967e-03,
        -1.59218337e-03,  3.57475039e-03,  4.53085126e-03,
        -5.15253050e-04, -1.04046811e-03,  2.57639471e-03,
         1.28407474e-03, -2.65925378e-03,  4.23517264e-03,
         1.10686306e-04,  4.31847945e-03, -8.15145846e-04,
         6.71138288e-03],
       [ 1.15386641e-03,  7.30497180e-04, -1.21502046e-04,
        -8.27415090e-04, -2.15337146e-03,  2.67675542e-03,
        -8.80703956e-05, -1.73765031e-04, -5.57355862e-03,
        -4.26211208e-03,  1.67573709e-03,  2.73242686e-03,
         1.85471121e-03, -3.13106109e-03, -2.97768670e-03,
         5.46218980e-05, -1.41545222e-03,  2.02511717e-03,
         1.54452492e-03, -1.98908325e-04,  6.50794525e-03,
         3.67356185e-03,  3.80910537e-03, -7.81542528e-03,
        -5.95151680e-03, -4.74780711e-04,  3.93444952e-03,
        -4.26356541e-03, -2.02409294e-03,  1.53583626e-03,
         2.95701670e-04, -1.72147155e-03,  1.03893464e-04,
         2.50710617e-03,  1.00010762e-03,  3.64729459e-03,
        -4.09127097e-04,  1.95534411e-03,  3.26273195e-03,
        -2.53194640e-03],
       [ 2.00057948e-05, -8.27416225e-05,  2.82373148e-05,
        -1.80737290e-04, -1.77790280e-04,  1.55048110e-04,
         2.70683813e-04,  1.94983120e-04, -4.52938293e-05,
        -5.67118987e-05,  1.53423566e-03, -2.14171293e-03,
        -2.49548262e-04,  1.03633653e-03, -3.11141572e-04,
         9.85490115e-05, -6.19814557e-04, -9.19231315e-05,
        -2.55976658e-04, -4.50440595e-04,  4.05162689e-04,
        -2.92377174e-03,  1.19874639e-04,  2.73984624e-04,
         3.84538980e-05, -1.09012076e-03, -8.17284978e-04,
         3.95050272e-04, -3.68821272e-03,  7.56667403e-04,
        -2.48762011e-03, -1.05472609e-04,  3.96659551e-03,
         1.95729011e-03,  2.35630455e-03,  1.25073665e-03,
         3.69786029e-03,  4.74853558e-04,  6.73161005e-04,
        -1.45979854e-03],
       [-1.68967305e-03, -1.12752942e-03, -6.65469677e-04,
         2.83571123e-03, -2.69033876e-03, -2.06163339e-03,
         2.96858791e-03, -7.47338170e-04,  3.77814379e-03,
        -7.32984219e-04,  2.03446392e-03,  1.77079183e-03,
        -1.22599246e-03,  2.10279576e-03,  1.69997534e-03,
        -2.17595696e-03,  3.86224769e-04,  1.88106566e-03,
         1.79733720e-03,  4.10637259e-03, -4.31638537e-03,
         4.07779735e-04, -2.71752733e-03,  7.25887250e-04,
        -5.91473596e-04,  3.00770253e-03,  1.89657777e-03,
        -2.40052631e-03,  3.26934457e-03,  4.56763431e-03,
        -1.12411939e-03, -1.38607540e-03,  3.57767823e-03,
         1.58987800e-03, -1.86874636e-03,  5.72668202e-03,
         5.36570093e-04,  4.48354986e-03, -3.84710322e-04,
         5.89642255e-03],
       [ 1.15177233e-03,  5.63351030e-04, -1.38530333e-04,
        -8.82650260e-04, -2.05802126e-03,  2.46777618e-03,
        -1.63691089e-04, -2.32376551e-04, -6.18601264e-03,
        -4.48249234e-03,  1.64788484e-03,  2.60070339e-03,
         2.11850437e-03, -3.25468625e-03, -3.28283198e-03,
         2.37516506e-05, -1.49922841e-03,  2.03669094e-03,
         1.51019997e-03, -3.86968110e-04,  6.07572030e-03,
         2.56745680e-03,  4.27604886e-03, -7.16736680e-03,
        -6.30574999e-03, -7.92185485e-04,  3.52259493e-03,
        -3.88628175e-03, -2.36627436e-03,  1.20446016e-03,
        -4.27276565e-04, -2.07563187e-03,  9.27871733e-04,
         2.59050308e-03,  1.35644758e-03,  3.25788278e-03,
        -7.55664892e-04,  2.38712085e-03,  2.31098384e-03,
        -1.29557017e-03],
       [-3.70930560e-04,  7.97926841e-05,  3.08422663e-04,
        -6.12864504e-04,  2.74221151e-04, -3.79646845e-05,
         6.47579436e-04,  1.14107839e-04,  1.38455816e-03,
         9.01915366e-04,  1.79145194e-03, -2.15661968e-03,
        -3.25683359e-05,  1.33362086e-03,  3.79713631e-04,
        -3.56921519e-04,  9.82430647e-05, -3.47094261e-04,
        -1.73114851e-04,  1.86241028e-04,  1.72430126e-04,
        -3.21564008e-03, -3.02408330e-06,  2.32825661e-03,
         1.35831899e-04, -6.89860724e-04, -2.05920544e-03,
         1.57206191e-03, -2.98883743e-03, -3.84414190e-04,
        -2.25907611e-03, -1.92358019e-03,  3.08745354e-03,
         2.14058021e-03,  1.73867843e-03, -1.50157954e-03,
         2.13929545e-03,  3.43421620e-04,  1.24988088e-03,
        -1.88733137e-03],
       [-1.70033507e-03, -1.21158594e-03, -6.55464421e-04,
         2.77086347e-03, -2.65124463e-03, -1.80944439e-03,
         2.65402813e-03, -6.06971851e-04,  3.46343592e-03,
        -8.23205861e-04,  1.95243419e-03,  1.63791736e-03,
        -1.15081517e-03,  1.85623905e-03,  2.14524870e-03,
        -1.64516375e-03,  6.29216607e-04,  1.78426993e-03,
         1.88726920e-03,  4.37157974e-03, -3.93608073e-03,
        -3.90199828e-04, -1.68497022e-03,  1.33485021e-03,
        -4.17318806e-05,  2.50574620e-03,  2.15193583e-03,
        -1.40055886e-03,  3.00668599e-03,  3.62674799e-03,
        -1.22774090e-03, -5.08299971e-04,  4.61023580e-03,
         2.13206094e-03, -2.62664794e-03,  4.50489391e-03,
        -2.52978352e-04,  5.45038749e-03, -1.01588499e-04,
         6.95593376e-03],
       [ 1.12336827e-03,  7.34289235e-04, -1.15081435e-04,
        -9.43548745e-04, -1.84525084e-03,  2.66665849e-03,
        -4.35679904e-05, -5.13754843e-04, -5.53678069e-03,
        -4.07779217e-03,  2.07390799e-03,  2.10606144e-03,
         1.73578819e-03, -2.88978405e-03, -3.10568977e-03,
         4.28697822e-04, -1.94594718e-03,  1.92196912e-03,
         2.20803032e-03, -9.52380185e-04,  5.47493016e-03,
         1.53952069e-03,  4.59550926e-03, -7.17013143e-03,
        -6.31674239e-03, -9.49478126e-04,  3.26810777e-03,
        -3.74553236e-03, -2.28197710e-03,  1.31948467e-03,
        -4.69750870e-04, -2.21674354e-03,  1.16987573e-03,
         3.05756181e-03,  1.62444473e-03,  2.76775984e-03,
        -7.22994097e-04,  3.14990128e-03,  2.29086983e-03,
        -1.70244731e-03]], dtype=np.float32)

W_EXP_BASE = np.array([[-1.24710105e-01, -1.63036391e-01,  1.89744961e-02,
         3.96659411e-02,  1.88236713e-01, -2.77462929e-01,
        -1.77723780e-01,  6.98517337e-02,  2.73060333e-02,
         6.54469132e-01],
       [-2.03788832e-01, -3.10518444e-02, -8.50033537e-02,
         5.87826312e-01, -3.04189265e-01,  1.06703520e-01,
         8.36575568e-01, -1.38700744e-02,  2.72612214e-01,
         2.18566179e-01],
       [ 1.16241183e-02, -1.50398567e-01,  1.40436459e-02,
         6.53158203e-02, -3.20982426e-01,  2.13928178e-01,
        -1.70225367e-01,  1.69247389e-01,  2.36333892e-01,
        -8.44197810e-01],
       [-1.88944608e-01, -1.46701157e-01,  7.34289140e-02,
        -3.99272799e-01,  4.34589356e-01, -4.65057939e-01,
        -1.18914771e+00,  5.36295660e-02, -2.24880427e-01,
         1.06146836e+00],
       [-2.49720365e-01,  1.26670152e-01, -1.57754555e-01,
         1.34994733e+00, -2.94332385e-01,  2.29792833e-01,
         2.73492193e+00,  2.02467069e-01,  4.69634026e-01,
         1.31596363e+00],
       [ 6.59076124e-02, -2.39789635e-01,  6.87333867e-02,
        -2.40685374e-01, -2.75510103e-01,  6.77879333e-01,
        -9.05707836e-01,  6.30663931e-01,  1.20378844e-01,
        -1.67373419e+00],
       [ 4.60183799e-01,  1.41394854e+00, -3.88610411e+00,
         2.21802940e+01, -2.68676624e+01, -2.85618820e+01,
         3.80492020e+01, -4.21569014e+00,  2.54822922e+01,
        -6.03672862e-01],
       [-2.48883978e-01,  1.67418838e+00, -2.36795998e+00,
         1.34554949e+01, -1.36806231e+01, -1.51712761e+01,
         2.53400536e+01, -2.66614628e+00,  1.37500992e+01,
         4.55291843e+00],
       [ 5.41071534e-01,  1.99480307e+00, -3.35085678e+00,
         1.70336037e+01, -2.28795891e+01, -2.25603294e+01,
         3.07188988e+01, -1.10501838e+00,  2.16837597e+01,
        -1.09944713e+00],
       [-2.12989769e+01, -1.99303646e+01,  1.35716019e+02,
         9.89113922e+01, -3.31184540e+02, -1.53779297e+01,
        -4.27964134e+01,  2.15643494e+02, -5.79685730e+02,
         6.60623627e+01],
       [ 1.10695953e+02,  2.67319736e+01, -2.71013260e+01,
         7.09346161e+01, -4.54211311e+01, -2.17132401e+02,
         5.37949791e+01,  5.00962677e+01,  1.57669067e+02,
         4.96941833e+01],
       [ 1.96041260e+02, -1.99795640e+00,  5.02860756e+01,
        -1.16375076e+02, -2.37120285e+02, -2.96720581e+02,
         3.28620453e+02, -5.82611389e+02, -2.00433731e+02,
         2.68118469e+02],
       [-4.43216743e+01,  1.12737751e+01,  3.05303497e+02,
         3.35301117e+02, -7.94910889e+02,  3.21169510e+01,
        -3.30010681e+02,  8.36033569e+02, -1.13337109e+03,
        -1.46014801e+02],
       [ 4.52376007e+02,  6.75669250e+01, -1.59502808e+02,
         2.19377945e+02,  1.19519562e+02, -6.61398926e+02,
        -7.16254902e+00,  5.23168152e+02,  4.12269165e+02,
         1.90766769e+02],
       [ 5.97461121e+02, -1.10405830e+02,  2.61008026e+02,
        -2.48134155e+02, -3.71575378e+02, -9.11476990e+02,
         8.32826355e+02, -1.67228162e+03, -1.64658966e+02,
         5.93386169e+02],
       [ 1.38327150e+01,  3.73121452e+01,  5.61313782e+02,
         3.50736176e+02, -1.49400610e+03,  2.02451981e+02,
        -3.23044006e+02,  7.44584656e+02, -2.04968213e+03,
        -1.26985382e+02],
       [ 8.04668518e+02,  1.63942947e+02, -1.98386154e+02,
         1.38725845e+02,  1.20343056e+02, -9.81489258e+02,
         1.56754028e+02,  4.79238922e+02,  4.62063812e+02,
         6.41646240e+02],
       [ 1.05801392e+03, -8.36971893e+01,  3.82724945e+02,
        -4.86005676e+02, -8.79515686e+02, -1.83436267e+03,
         1.45463330e+03, -3.00172314e+03, -2.32430939e+02,
         1.04782153e+03],
       [ 1.97186527e+01,  9.92089233e+01,  9.46221313e+02,
         3.70720886e+02, -2.71245630e+03,  3.22996063e+02,
        -3.36475677e+02,  8.29421021e+02, -3.33370435e+03,
        -1.55000671e+02],
       [ 1.33929456e+03,  3.36844177e+02, -2.82379852e+02,
         1.77532150e+02,  9.38367233e+01, -1.66560718e+03,
         3.00058197e+02,  4.60348663e+02,  7.79668945e+02,
         1.10133423e+03],
       [ 1.62637219e+03, -1.39748581e+02,  4.89206604e+02,
        -7.09261902e+02, -1.32881519e+03, -2.33545093e+03,
         1.88371582e+03, -3.97090283e+03, -3.09565460e+02,
         1.22124121e+03],
       [-2.14475002e+01,  1.67921585e+02,  1.11405176e+03,
         2.94033691e+02, -3.19797559e+03,  3.53922150e+02,
        -2.11286301e+02,  7.09089966e+02, -3.76603516e+03,
        -8.92658691e+01],
       [ 2.18778662e+03,  7.06520020e+02, -2.60787750e+02,
        -3.92045990e+02, -1.07046211e+02, -6.43521179e+02,
         1.20255211e+02,  7.54008911e+02,  7.19436768e+02,
         1.56259656e+03],
       [ 2.24225269e+03,  3.79697815e+02,  1.72847870e+02,
        -1.74133325e+03, -8.86006531e+02, -1.18822632e+03,
         1.91606274e+03, -3.79319116e+03, -4.11078156e+02,
         2.81371118e+03],
       [-8.85042648e+01,  1.59645645e+02,  1.29849146e+03,
         2.16078812e+02, -3.54286133e+03,  2.83455444e+02,
        -1.93518295e+01,  8.24238129e+01, -4.09559058e+03,
         1.77689621e+02],
       [ 2.56830103e+03,  1.11257043e+03, -1.80127579e+02,
        -8.90019470e+02, -1.39099594e+02,  2.75772125e+02,
        -2.52315974e+00,  1.09816016e+03,  1.48154144e+02,
         1.76455908e+03],
       [ 2.45877344e+03,  6.53324646e+02, -1.47819000e+02,
        -2.17431055e+03, -6.80854263e+01, -8.86137573e+02,
         2.08446436e+03, -4.00807202e+03,  1.05787611e+00,
         3.62290552e+03],
       [-1.22579117e+02,  1.12563400e+02,  1.17914062e+03,
         7.91868591e+01, -3.21200513e+03,  1.97925446e+02,
         1.45954437e+02, -4.44555084e+02, -3.73772119e+03,
         5.04483154e+02],
       [ 2.19290552e+03,  7.41049744e+02,  7.61111984e+01,
        -3.72856018e+02, -1.30702591e+02, -6.77941040e+02,
         1.08856216e+02,  7.87876160e+02, -6.03979797e+02,
         1.59284802e+03],
       [ 2.33132910e+03,  3.65868652e+02, -3.67455505e+02,
        -1.93194885e+03,  7.65849854e+02, -1.25458923e+03,
         1.95125232e+03, -3.73628003e+03,  2.51454697e+02,
         3.04809253e+03],
       [-1.00389183e+02,  2.01796082e+02,  9.48052734e+02,
        -1.43229980e+02, -2.79060815e+03,  2.86270050e+02,
         2.82959686e+02, -4.72905487e+02, -3.40276758e+03,
         7.60017517e+02],
       [ 1.38664697e+03,  4.24205139e+02,  1.90243042e+02,
         2.39574570e+02, -2.81880249e+02, -1.64957458e+03,
         2.65363159e+02,  6.18522217e+02, -7.25413208e+02,
         1.18061755e+03],
       [ 1.73980225e+03, -2.21251495e+02, -4.39935150e+02,
        -9.87097595e+02,  1.18758972e+03, -2.32457642e+03,
         1.92578259e+03, -3.91307104e+03, -3.09824005e+02,
         1.51277209e+03],
       [-1.60578251e+00,  2.09101334e+02,  6.05026978e+02,
        -2.99856659e+02, -1.67495520e+03,  2.52610840e+02,
         2.83429199e+02, -5.00088287e+02, -2.27714868e+03,
         5.70348511e+02],
       [ 8.28005310e+02,  2.30900330e+02,  1.87560928e+02,
         3.30930054e+02, -2.52259445e+02, -1.19794397e+03,
         1.07375603e+02,  7.00011963e+02, -4.61096619e+02,
         6.46159485e+02],
       [ 1.18624976e+03, -2.24262848e+02, -3.40490784e+02,
        -6.80680420e+02,  8.57735535e+02, -1.97464099e+03,
         1.60770825e+03, -3.30147363e+03, -2.84988220e+02,
         1.11763684e+03],
       [ 4.50902939e+01,  1.37320740e+02,  3.38389343e+02,
        -2.37419189e+02, -9.67285095e+02,  2.27429413e+02,
         2.34742935e+02, -5.37477539e+02, -1.37611096e+03,
         3.63672516e+02],
       [ 4.80764587e+02,  1.47910248e+02,  8.49801102e+01,
         2.85180756e+02, -1.78840363e+02, -5.67993164e+02,
        -8.80850601e+01,  8.19235657e+02, -3.52525116e+02,
         2.56445648e+02],
       [ 6.94833008e+02, -7.30547638e+01, -1.95790237e+02,
        -5.48807617e+02,  3.76990631e+02, -7.32058655e+02,
         9.44188171e+02, -1.94744153e+03,  8.63402939e+01,
         7.04296082e+02],
       [-1.20356426e+01,  8.97547913e+01,  1.97813293e+02,
        -6.06966019e+00, -6.34370789e+02,  2.01677200e+02,
        -9.30781479e+01,  1.07833115e+02, -1.02276337e+03,
         1.19672480e+01],
       [ 1.48874954e+02,  4.92671013e+01, -2.07986145e+01,
         7.76236572e+01,  8.97853241e+01, -2.36960098e+02,
         4.50033073e+01,  1.50647400e+02, -7.51792526e+01,
         1.37832947e+02],
       [ 2.83321045e+02,  3.67500877e+01, -6.06229172e+01,
        -3.85628815e+02,  3.11920410e+02, -2.73777649e+02,
         5.28805725e+02, -1.11542615e+03,  2.99020142e+02,
         4.18647736e+02],
       [-3.15421796e+00,  1.08847246e-01,  4.26511717e+00,
        -4.16914368e+00, -3.81094513e+01,  2.51697426e+01,
        -2.06067982e+01,  1.17144365e+01, -2.76328678e+01,
         8.75935197e-01],
       [-1.41050720e+00,  3.51082635e+00, -4.26791811e+00,
         8.77542496e+00,  4.38294363e+00, -6.69427299e+00,
         1.09602337e+01,  1.13769226e+01, -8.29053783e+00,
         9.62897778e+00],
       [-1.39260416e+01,  1.09523211e+01, -3.15048432e+00,
        -3.77373924e+01,  1.71627483e+01,  4.69716187e+01,
         1.33058577e+01, -3.04866581e+01,  5.02450562e+01,
         9.71312618e+00],
       [ 1.48677334e-01,  8.65535066e-02,  7.75395185e-02,
        -5.75763583e-01, -1.26036957e-01, -4.55798721e-03,
        -1.99895835e+00, -8.50997508e-01, -2.82491624e-01,
        -1.59205937e+00],
       [-5.53990006e-01,  1.17773700e+00, -1.17747426e-01,
         1.26155353e+00,  9.66015607e-02, -8.40546548e-01,
         5.12582970e+00,  9.75698233e-01,  7.11596668e-01,
         5.83551598e+00],
       [-2.41878644e-01,  5.59584320e-01, -2.51328528e-01,
        -1.85657251e+00, -7.47179270e-01, -1.29837543e-01,
        -3.16753340e+00,  8.90669942e-01,  7.68973708e-01,
         9.23351407e-01],
       [ 1.04951516e-01,  1.92418650e-01,  2.42643598e-02,
        -2.84088284e-01, -1.17443360e-01,  1.47808837e-02,
        -5.27681053e-01, -2.07949787e-01, -1.04768403e-01,
        -6.08471572e-01],
       [-1.99606255e-01,  1.92488894e-01,  7.08928704e-02,
         3.95935953e-01,  2.58232415e-01, -9.85361412e-02,
         9.17150497e-01,  1.43915400e-01, -3.86236049e-02,
         8.27526271e-01],
       [-6.84505254e-02,  1.51298866e-02, -1.31426966e-02,
        -1.44550309e-01,  2.35274121e-01, -4.58248779e-02,
        -3.27211618e-01,  9.62160677e-02, -2.70238072e-01,
        -3.75376716e-02],
       [-4.80708718e-01,  5.02132130e+00, -2.64129829e+00,
        -1.20542336e+01, -3.75406361e+00,  9.86196442e+01,
         1.98715958e+02,  1.28615509e+02,  2.61686478e+01,
         4.39052505e+01],
       [-7.07435906e-01,  2.74118304e+00, -1.62232959e+00,
        -1.56525192e+02, -1.53962851e+01, -5.95133591e+01,
        -7.79282776e+02,  2.63485932e+00,  5.69400902e+01,
         6.49454590e+02],
       [ 2.61147165e+00, -5.53740442e-01, -2.34427595e+00,
         3.17043781e+01, -4.20478344e+00,  1.59516495e+02,
         4.66424286e+02,  1.75749023e+02,  2.08162212e+01,
        -1.32350952e+02],
       [-9.97947082e-02,  5.57581949e+00, -2.63300562e+00,
        -8.36685562e+00,  3.82106876e+00,  1.80097961e+02,
         3.85115967e+02,  2.10441254e+02,  2.84832859e+01,
         6.97624445e+00],
       [-2.16520607e-01,  2.35410595e+00, -2.86422324e+00,
        -2.19954407e+02, -3.14202862e+01, -1.26540413e+02,
        -1.18171118e+03, -3.51917419e+01,  8.47766647e+01,
         9.33957764e+02],
       [ 2.69133067e+00, -3.31700253e+00,  2.41661668e-01,
         8.06412582e+01,  1.40080509e+01,  1.88047714e+02,
         7.05765747e+02,  1.67776825e+02, -1.27894478e+01,
        -3.62695496e+02],
       [ 1.42365240e-03,  7.14155579e+00, -3.08911586e+00,
         3.75365982e+01,  1.06149549e+01,  2.50992493e+02,
         6.59464478e+02,  2.66821442e+02,  2.55883179e+01,
        -7.30376053e+01],
       [-6.52788937e-01, -2.00929165e+00, -1.36881506e+00,
        -2.90253052e+02, -4.26793404e+01, -3.05500214e+02,
        -1.71196411e+03, -1.96825485e+02,  7.30220947e+01,
         9.71963989e+02],
       [ 3.98090935e+00, -5.20665216e+00,  6.00164950e-01,
         1.23076111e+02,  1.84674778e+01,  2.20566101e+02,
         8.35682190e+02,  1.78637436e+02, -1.67044449e+01,
        -3.84479401e+02],
       [ 1.05802983e-01,  8.83325005e+00, -3.62700534e+00,
         8.23933029e+01,  1.72871895e+01,  3.34068848e+02,
         9.47123047e+02,  3.36749481e+02,  2.71061630e+01,
        -1.18598732e+02],
       [-1.46035635e+00, -8.18721294e+00,  8.83393705e-01,
        -4.62113434e+02, -7.02133942e+01, -7.69738220e+02,
        -3.25860132e+03, -6.30039612e+02,  5.34288101e+01,
         1.25649146e+03],
       [ 5.25240898e+00, -6.74715376e+00,  6.32884800e-01,
         1.46458633e+02,  2.11003189e+01,  2.74791077e+02,
         9.64191772e+02,  2.23541428e+02, -1.05637722e+01,
        -3.51441193e+02],
       [ 2.20116347e-01,  1.02974730e+01, -4.08726835e+00,
         1.18199028e+02,  2.26304150e+01,  4.02454041e+02,
         1.17352710e+03,  3.94456604e+02,  2.94842339e+01,
        -1.45342178e+02],
       [-2.79304051e+00, -1.66603642e+01,  4.25878143e+00,
        -6.67925476e+02, -1.02998299e+02, -1.32696570e+03,
        -5.03872412e+03, -1.14733325e+03,  2.50694008e+01,
         1.54008386e+03],
       [ 6.24121523e+00, -9.36625957e+00,  1.00421560e+00,
         1.25661942e+02,  1.82156506e+01,  2.62984314e+02,
         8.64693298e+02,  2.18877686e+02, -6.14817667e+00,
        -3.02456360e+02],
       [-1.89292014e+00, -6.59384871e+00,  3.15837479e+00,
        -1.29291870e+02, -1.96341267e+01, -4.42931854e+02,
        -1.28410559e+03, -4.30113922e+02, -3.67411728e+01,
         1.94168808e+02],
       [-2.29909229e+00, -1.78583221e+01,  4.32169533e+00,
        -6.81925110e+02, -1.01298759e+02, -1.32818970e+03,
        -5.10138232e+03, -1.15247949e+03,  2.24125538e+01,
         1.55627148e+03],
       [ 6.10458231e+00, -9.75561619e+00,  1.30957019e+00,
         1.21876045e+02,  1.67723904e+01,  2.57392029e+02,
         8.69298035e+02,  2.17222824e+02, -5.52122211e+00,
        -3.22825378e+02],
       [-1.54532695e+00, -6.22020912e+00,  2.99217939e+00,
        -8.75988998e+01, -1.41080761e+01, -3.73402374e+02,
        -1.02869861e+03, -3.76147644e+02, -3.73038940e+01,
         1.34426620e+02],
       [-9.43077624e-01, -1.01967411e+01,  1.39364445e+00,
        -4.64567566e+02, -6.63818359e+01, -7.81504150e+02,
        -3.30318823e+03, -6.55994446e+02,  4.36573143e+01,
         1.21933264e+03],
       [ 5.12369156e+00, -6.73387861e+00,  7.95354962e-01,
         1.44918640e+02,  1.93988457e+01,  2.75080719e+02,
         9.80009399e+02,  2.28745102e+02, -7.95534229e+00,
        -3.60333038e+02],
       [-1.04037929e+00, -4.95284748e+00,  2.40128946e+00,
        -4.53636475e+01, -8.22392368e+00, -2.82985077e+02,
        -7.53139282e+02, -2.99442139e+02, -3.23034439e+01,
         1.07254791e+02],
       [-5.72486743e-02, -4.42012262e+00, -7.55295098e-01,
        -2.95768372e+02, -3.87689781e+01, -3.50230164e+02,
        -1.86546936e+03, -2.63217133e+02,  5.90782928e+01,
         9.43527832e+02],
       [ 3.79736614e+00, -5.12064219e+00,  7.99211800e-01,
         1.23039642e+02,  1.60668011e+01,  2.29786499e+02,
         8.89692322e+02,  1.96855118e+02, -1.20151796e+01,
        -3.99961578e+02],
       [-5.88217378e-01, -3.51115561e+00,  1.85814452e+00,
        -1.79704714e+00, -2.40419841e+00, -1.92686005e+02,
        -4.56995972e+02, -2.20675049e+02, -2.89308891e+01,
         4.70108528e+01],
       [ 5.36820948e-01, -1.91090666e-02, -2.60918713e+00,
        -2.32353073e+02, -2.88756905e+01, -1.59512970e+02,
        -1.33750000e+03, -8.64728088e+01,  7.61922836e+01,
         9.24505249e+02],
       [ 2.44808817e+00, -3.81653047e+00,  8.87665272e-01,
         9.73677673e+01,  1.30456476e+01,  1.92832626e+02,
         8.17066040e+02,  1.75234467e+02, -1.45321770e+01,
        -4.31145203e+02],
       [-2.87526011e-01, -3.09741378e+00,  1.07060158e+00,
         1.18387241e+01, -2.93752575e+00, -1.12406342e+02,
        -2.31007889e+02, -1.40235641e+02, -1.93925076e+01,
        -1.45013800e+01],
       [ 4.22064900e-01, -7.31049418e-01, -2.70937324e+00,
        -1.53613968e+02, -2.51930199e+01, -7.90204544e+01,
        -8.61895752e+02, -3.87684135e+01,  6.06409302e+01,
         6.21074951e+02],
       [ 2.16439939e+00, -7.99061835e-01,  6.53618336e-01,
         3.24117546e+01,  1.36158209e+01,  1.53145752e+02,
         4.91678833e+02,  1.71014999e+02,  1.07763398e+00,
        -1.69758713e+02],
       [-2.08914328e+00,  4.82619715e+00,  1.95554830e-02,
        -7.79958391e+00,  6.43814087e+00, -1.86211567e+01,
        -2.59595242e+01, -8.17651653e+00, -6.48966432e-01,
         1.85724411e+01],
       [ 2.01864791e+00, -1.52829113e+01,  1.41828322e+00,
        -1.58279083e+02, -2.61838017e+01, -2.99289886e+02,
        -9.59587708e+02, -2.07305756e+02, -7.25525665e+00,
         1.34429962e+02],
       [ 1.40020151e+01, -1.79767628e+01,  3.29960704e+00,
         2.04709946e+02,  2.33637829e+01,  3.09488312e+02,
         7.80804932e+02,  2.23574326e+02,  9.44627762e+00,
        -1.27503807e+02],
       [-3.58556747e+00,  9.36247444e+00,  1.05480242e+01,
        -7.87076187e+00,  4.18832493e+00, -1.43789368e+01,
        -1.23312988e+01, -2.80053949e+00, -3.09008560e+01,
         3.19017830e+01],
       [-1.52680600e+00, -1.26312256e+00, -6.05937576e+00,
         1.00007034e+02,  8.77820396e+00,  1.53045258e+02,
         4.54547821e+02,  2.10250412e+02,  2.41477470e+01,
         3.19493042e+02],
       [ 2.28950558e+01, -5.45743895e+00,  6.48774290e+00,
         2.44555550e+01, -6.76823139e+00, -5.81076927e+01,
        -1.75757538e+02, -1.70238247e+01,  1.50570774e+01,
        -1.44934204e+02],
       [-3.47313809e+00,  4.28103523e+01,  2.26257645e+02,
        -1.01855164e+01, -9.81369858e+01, -1.93712807e+01,
        -1.40248032e+01, -5.90286026e+01,  5.63802002e+02,
        -1.58520250e+01],
       [-2.71728115e+01,  1.28606384e+02, -3.43692017e+01,
         1.03027290e+02,  2.17640362e+01,  8.51997375e+02,
         6.53629944e+02,  1.77864670e+02,  6.89068756e+01,
         6.45698792e+02],
       [ 2.50638580e+01,  3.19305553e+01,  3.78909802e+00,
        -8.91990662e+01, -1.57426348e+01, -3.87756920e+01,
        -1.64341736e+02,  5.19254990e+01,  6.17482986e+01,
        -6.24157028e+01],
       [-2.61319780e+00,  7.78020096e+01,  4.60554596e+02,
        -9.96743774e+00, -1.88737503e+02, -3.33985901e+01,
         5.07630587e-01, -1.07907784e+02,  1.20761560e+03,
        -6.92470093e+01],
       [-1.85457745e+01,  2.01026627e+02, -4.69938278e+01,
         3.27254425e+02,  5.06453896e+01,  1.49543787e+03,
         5.32777954e+02,  9.66727829e+01,  1.07342148e+02,
         8.45797791e+02],
       [ 8.71429825e+00,  8.03015213e+01, -1.15268297e+01,
        -1.35698074e+02,  7.38701057e+00,  1.08112817e+03,
        -2.10288071e+02, -8.71553497e+01,  1.39836487e+02,
         3.83524292e+02],
       [ 6.24428406e+01, -6.11119385e+01,  9.74832458e+02,
         1.53176666e+02,  5.73064537e+01, -5.19016846e+02,
        -1.22534882e+02,  3.31573547e+02,  1.91803101e+03,
         1.01975006e+02],
       [ 2.03495544e+02,  2.87286499e+02, -4.16708252e+02,
         1.94279285e+03,  1.50981354e+02,  1.42139453e+03,
         1.10178821e+03, -2.00064514e+02, -6.20087280e+02,
         1.37979993e+03],
       [ 1.76469284e+02, -5.30358887e+02,  6.64762817e+02,
         3.12480278e+01,  1.46444031e+02, -1.57537415e+02,
        -2.95852936e+02,  4.99721436e+02,  8.92488342e+02,
        -9.68226257e+02],
       [ 4.61655045e+01,  5.61255188e+01,  9.41872314e+02,
         1.25168816e+02, -2.57809174e+02, -2.86975220e+02,
         3.40344191e+00,  1.81238083e+02,  2.17673877e+03,
        -3.28658867e+01],
       [ 1.15463943e+02,  2.23758972e+02, -2.88103271e+02,
         1.61936182e+03,  1.93656113e+02,  1.47805945e+03,
         4.22994995e+02, -3.82169861e+02, -4.57078125e+02,
         1.32530457e+03],
       [ 1.72683228e+02, -5.23180969e+02,  4.53419983e+02,
        -6.28728828e+01,  1.91425354e+02,  5.10156586e+02,
        -1.75907471e+02,  3.59321991e+02,  5.01699799e+02,
        -6.65589539e+02],
       [ 1.12928696e-01,  1.45565140e+02,  9.38119507e+02,
         4.56975079e+00, -5.31969482e+02, -5.95167160e+01,
         2.03575935e+01, -1.88183395e+02,  2.33110596e+03,
        -2.22628296e+02],
       [ 5.17582359e+01,  1.97718079e+02, -4.59001999e+01,
         1.44034399e+03,  1.27405785e+02,  1.43736804e+03,
        -2.13369293e+02, -5.43578857e+02,  4.97523384e+01,
         1.08089941e+03],
       [ 1.91365891e+02, -5.85737610e+02,  8.84216537e+01,
         6.31201982e+00, -1.53026426e+00,  9.45155884e+02,
        -1.54139114e+02,  2.74356079e+02,  4.16145210e+01,
        -7.15152039e+02],
       [-4.21044807e+01,  2.41645004e+02,  9.34526978e+02,
        -1.20063599e+02, -2.21718826e+02,  1.81778564e+02,
         4.93215828e+01, -5.11864258e+02,  2.11323389e+03,
        -3.25707916e+02],
       [ 1.20524391e+02,  3.03639282e+02,  1.78399780e+02,
         1.69182446e+03,  7.63072815e+01,  1.49138879e+03,
         4.38661438e+02, -4.30449677e+02,  6.51788574e+02,
         1.28148340e+03],
       [ 1.78114273e+02, -6.47255249e+02, -2.69156799e+02,
        -9.97041779e+01, -2.15938889e+02,  5.78341675e+02,
        -1.99939362e+02,  3.81125031e+02, -4.54098602e+02,
        -6.24480347e+02],
       [-5.71362267e+01,  3.71981476e+02,  9.08502258e+02,
        -1.53186905e+02,  1.20849251e+02,  4.56117737e+02,
         1.66100494e+02, -5.98065613e+02,  1.78815405e+03,
        -3.62385620e+02],
       [ 2.10000534e+02,  3.90685333e+02,  2.65273865e+02,
         1.99316650e+03,  1.63630768e+02,  1.47953882e+03,
         1.07996777e+03, -2.63046692e+02,  7.73713135e+02,
         1.30441162e+03],
       [ 1.90884232e+02, -7.40822998e+02, -4.74638580e+02,
         3.30559158e+01, -1.86256882e+02, -7.29470062e+01,
        -3.56191956e+02,  5.78105835e+02, -9.52549866e+02,
        -9.00638794e+02],
       [-3.06698799e+00,  6.29694700e+00, -1.58149886e+00,
        -2.42682667e+01, -7.64473248e+00, -5.21038475e+01,
        -8.31796494e+01, -2.12661896e+01,  7.23026562e+00,
         3.55069885e+01],
       [ 6.24855161e-01,  1.74000096e+00, -5.08167553e+00,
         3.01962204e+01, -3.17905579e+01, -6.26531448e+01,
        -1.55872253e+02, -4.49577217e+01,  3.60940857e+01,
         1.60144135e+02],
       [ 9.93110657e+00, -1.26444788e+01, -2.68941212e+00,
         9.45089645e+01, -1.70738373e+01,  1.46873749e+02,
         3.81868011e+02,  1.34565033e+02,  3.07499523e+01,
        -7.31639557e+01],
       [-2.93684268e+00,  8.77432346e+00, -2.08046627e+00,
         8.70184326e+00,  2.79930925e+00,  3.23700752e+01,
         1.24471832e+02,  5.26450882e+01,  9.25347710e+00,
         4.59621086e+01],
       [-1.53424740e+00, -5.18026352e+00,  1.19274044e+00,
         3.62019691e+01, -1.28110342e+01, -3.40084259e+02,
        -6.76359253e+02, -4.07204437e+02, -5.51349449e+01,
         1.48627539e+01],
       [ 7.88840961e+00, -1.76517906e+01,  3.95084286e+00,
         1.52368774e+02,  1.41330442e+01,  2.34990501e+01,
         3.50978363e+02, -6.66676636e+01, -4.96816254e+01,
        -3.46432312e+02],
       [-3.39185596e+00,  7.40100145e+00, -1.60991609e+00,
        -1.64099159e+01, -3.38175273e+00, -3.86504974e+01,
        -4.19829063e+01, -1.04361801e+01,  4.71196270e+00,
         3.71269531e+01],
       [-1.00677466e+00, -4.07123041e+00,  9.93995845e-01,
         4.52523880e+01, -7.02781248e+00, -2.98757568e+02,
        -6.59695068e+02, -3.76718079e+02, -4.95445786e+01,
         9.36832275e+01],
       [ 8.00732994e+00, -2.11878376e+01,  5.78464270e+00,
         1.55565475e+02,  1.58942385e+01, -1.60752735e+01,
         3.29903015e+02, -1.14171021e+02, -6.53037262e+01,
        -4.47984375e+02],
       [-3.43943167e+00,  7.20920324e+00, -1.36570036e+00,
        -9.16429043e+00, -3.62043262e+00, -4.54429893e+01,
        -3.70049133e+01, -2.13534222e+01,  3.04793453e+00,
         2.03374290e+01],
       [ 1.58511683e-01,  1.13685834e+00, -1.91898572e+00,
         2.17274265e+01, -7.09450531e+00, -6.20119171e+01,
        -2.94057648e+02, -8.17996216e+01,  1.10181017e+01,
         2.38967941e+02],
       [ 8.78420925e+00, -2.08583469e+01,  4.41029549e+00,
         7.41614151e+01,  7.84076881e+00,  2.66080189e+01,
         1.61829071e+02, -2.54660702e+01, -3.13953075e+01,
        -2.56048370e+02],
       [-4.60270691e+00,  1.20388088e+01, -2.87067246e+00,
        -4.59784355e+01, -7.77012968e+00, -1.08963718e+01,
        -4.60565948e+01,  4.40913582e+01,  2.40693188e+01,
         1.11330811e+02],
       [ 6.89572692e-01,  8.62730598e+00, -7.51769495e+00,
         7.02749710e+01, -2.65473137e+01,  6.35673637e+01,
         7.20722275e+01,  7.97319412e+01,  6.30717850e+01,
         2.97700653e+02],
       [ 9.72141933e+00, -2.08973293e+01,  3.17733288e+00,
         8.15809555e+01,  1.36098754e+00,  3.92231750e+01,
         1.83086349e+02, -6.73602533e+00, -2.04925480e+01,
        -2.26958176e+02],
       [-5.01006174e+00,  1.31595259e+01, -3.33163476e+00,
        -4.29598579e+01, -1.11819506e+01, -2.92635193e+01,
        -5.87992783e+01,  2.80604305e+01,  2.43925400e+01,
         1.05868622e+02],
       [ 8.53344560e-01,  1.18401308e+01, -1.29589100e+01,
         9.61239548e+01, -6.56140137e+01,  5.74954927e-01,
         1.23303505e+02,  5.62914848e+01,  9.41677246e+01,
         2.47154739e+02],
       [ 9.96372414e+00, -1.57201109e+01, -1.07478392e+00,
         9.11230469e+01, -1.65487957e+01,  8.19880676e+01,
         2.72614746e+02,  6.30312843e+01,  1.53068361e+01,
        -1.32259125e+02],
       [ 1.43108547e-01, -2.82823324e-01, -4.71587330e-01,
        -5.61546612e+00, -1.27713799e+00,  3.95919108e+00,
        -3.42381668e+01,  8.75895262e-01,  4.78349066e+00,
         3.19738941e+01],
       [ 1.72387445e+00, -2.27051973e+00,  1.81921259e-01,
         9.57831383e+00,  3.50351977e+00, -5.64361305e+01,
        -3.38594360e+02, -7.55760956e+01,  3.12913632e+00,
         2.38197495e+02],
       [ 8.21431351e+00, -1.81972027e+01,  3.44382977e+00,
         6.44917221e+01,  5.63774538e+00,  4.74820175e+01,
         1.83512817e+02,  6.26211834e+00, -2.20889606e+01,
        -2.17845779e+02],
       [ 1.00106575e-01, -4.46788192e-01, -4.11388665e-01,
        -1.26392803e+01, -1.29637480e+00,  2.85291147e+00,
        -4.13835526e+01,  5.62698841e+00,  5.60618973e+00,
         3.38858719e+01],
       [ 8.08086455e-01, -7.29831505e+00,  2.78460097e+00,
         4.78836899e+01, -5.34153283e-01, -2.87108154e+02,
        -7.12333862e+02, -3.86312897e+02, -4.70708504e+01,
         1.09467377e+02],
       [ 7.11472034e+00, -1.98019409e+01,  5.18349600e+00,
         1.32627274e+02,  1.12053490e+01, -2.11969223e+01,
         3.00228760e+02, -1.04941154e+02, -5.81097794e+01,
        -4.31674194e+02],
       [ 6.30130395e-02, -2.10322285e+00,  3.51814240e-01,
        -1.33480616e+01, -1.81072700e+00, -5.32049713e+01,
        -1.59849716e+02, -6.10874138e+01, -5.31351042e+00,
         2.15958672e+01],
       [-1.14076853e-01, -1.10241251e+01,  3.82337356e+00,
         2.47988472e+01, -8.70917988e+00, -3.60788513e+02,
        -8.17952942e+02, -4.59318298e+02, -5.84997749e+01,
        -4.92988318e-01],
       [ 1.38090149e+03, -1.91530591e+03, -1.25719958e+03,
         1.16212852e+02, -1.01134045e+03,  4.44938183e+00,
         3.56310669e+02, -8.91059998e+02, -2.92900482e+02,
         5.68609070e+02],
       [ 6.18425190e-01, -7.09303677e-01,  8.87985677e-02,
         3.89653168e+01,  4.04220200e+00,  1.05640335e+01,
         6.48519135e+01, -1.67850266e+01, -4.49481678e+00,
        -1.53854237e+01],
       [ 2.69434738e+00,  3.21104556e-01,  4.13444424e+00,
         2.94798145e+01,  3.86585655e+01, -4.20252037e+01,
        -1.41512726e+02, -1.66594448e+01, -2.93375282e+01,
         1.65356293e+02],
       [ 8.87878036e+00, -8.86351395e+00,  3.56538987e+00,
         8.62350845e+01,  3.40842094e+01,  1.59288330e+02,
         4.00993256e+02,  1.57400513e+02, -1.59933681e+01,
        -5.46848450e+01],
       [ 9.47691426e-02, -3.69656301e+00,  3.93902987e-01,
         4.00485458e+01, -4.81316662e+00, -4.12917061e+01,
        -5.56604385e+00, -8.84854279e+01, -1.05561438e+01,
        -9.31444778e+01],
       [ 4.66226768e+00,  8.01642036e+00,  7.70338202e+00,
         9.09794235e+01,  9.02794571e+01,  1.19636726e+01,
         1.00960121e+02,  7.98822403e+01, -6.35205803e+01,
         2.40647079e+02],
       [ 9.41019917e+00, -1.21512661e+01,  5.37081480e+00,
         9.07357025e+01,  3.80554008e+01,  8.72457275e+01,
         2.94124817e+02,  7.95870972e+01, -3.74856148e+01,
        -1.14470314e+02],
       [ 8.88958722e-02, -2.14960575e+00,  4.35643762e-01,
         1.66853371e+01, -1.17470026e+00, -3.54136734e+01,
        -4.14811172e+01, -5.91723251e+01, -8.09670067e+00,
        -4.25092659e+01],
       [ 2.66480827e+00,  1.67962670e+00,  1.57555974e+00,
         4.98018494e+01,  2.88813896e+01,  6.16659307e+00,
        -1.10537270e+02,  7.09888124e+00, -9.92064667e+00,
         2.50363419e+02],
       [ 8.63221073e+00, -1.76143684e+01,  4.27460527e+00,
         7.10832520e+01,  1.36666346e+01,  4.54945221e+01,
         1.99361267e+02,  1.14849243e+01, -2.94369183e+01,
        -2.13432159e+02],
       [ 1.11625069e+02, -1.17556421e+03,  2.41016577e+03,
         8.73368835e+02,  6.38473206e+02, -4.08449432e+02,
        -2.47965454e+02,  1.50186694e+03,  3.09159851e+02,
         2.35200024e+03],
       [ 1.33809949e+03,  1.25714111e+03, -1.54245691e+03,
         2.02164722e+03, -1.78749744e+03, -1.88496521e+03,
        -4.90231018e+02, -3.24706757e+02,  6.81599976e+02,
        -1.50046265e+03],
       [ 1.52172046e+03, -2.39651855e+03,  2.24449707e+03,
         4.59947083e+02,  1.95559155e+03,  2.46324738e+02,
        -7.93313904e+01,  1.97041031e+02, -2.66780975e+02,
         3.69712250e+02],
       [ 2.31070663e+02, -7.43047729e+02,  1.98151465e+03,
         1.95884338e+02,  3.38795685e+02, -1.30726465e+03,
         2.79106102e+01,  1.23258301e+03,  2.46916284e+03,
         3.81017334e+02],
       [ 6.10201416e+02,  5.57285522e+02, -6.85489685e+02,
         3.14222778e+03, -3.49953918e+02,  1.47409106e+03,
        -1.14819226e+03, -1.86514929e+03,  2.29295090e+02,
         5.34383301e+02],
       [ 7.57052856e+02, -2.16119800e+03,  1.68664404e+03,
         2.47663620e+02,  1.41212695e+03,  5.01740479e+02,
        -6.78754700e+02,  4.20752533e+02,  1.76731232e+02,
        -8.76019470e+02],
       [ 1.24356880e+02,  2.73482838e+01,  1.63984705e+03,
         4.54500313e+01, -8.05551514e+02, -7.07931335e+02,
         1.37391068e+02,  3.20891693e+02,  3.63570264e+03,
        -3.65043365e+02],
       [ 2.39627350e+02,  5.52421570e+01, -1.90392563e+02,
         3.32321606e+03,  1.67414871e+02,  2.89258154e+03,
        -1.65319995e+03, -2.38858789e+03, -6.99669724e+01,
         1.13751892e+03],
       [ 3.88261261e+02, -1.87211633e+03,  7.27457703e+02,
         1.44488266e+02,  4.66988831e+02,  1.43763416e+03,
        -7.73857117e+02, -1.11421837e+02, -1.38342621e+02,
        -1.30250964e+03],
       [ 2.59442787e+01,  2.37979660e+02,  1.63889795e+03,
         7.26709976e+01, -1.01155634e+03, -1.26206848e+02,
         4.63739738e+01, -2.65245209e+02,  3.67640918e+03,
        -4.86040802e+02],
       [ 2.07785156e+02, -1.70896664e+01, -8.13017273e+00,
         3.27175073e+03,  3.33897583e+02,  2.78396875e+03,
        -1.74619128e+03, -2.44408716e+03,  7.31946850e+00,
         8.82595764e+02],
       [ 3.52721039e+02, -1.98951038e+03,  3.07744934e+02,
         1.73296722e+02,  1.01542679e+02,  1.63084949e+03,
        -7.96230469e+02, -3.42431854e+02, -1.57069778e+02,
        -1.38615332e+03],
       [-7.62416000e+01,  4.30936859e+02,  1.62100391e+03,
         9.97438049e+01, -6.27549561e+02,  4.04142334e+02,
        -5.10972519e+01, -8.39623413e+02,  3.54343823e+03,
        -5.85745178e+02],
       [ 2.35116165e+02,  1.01243874e+02,  1.45225784e+02,
         3.37088452e+03,  5.10690094e+02,  2.94448022e+03,
        -1.68103125e+03, -2.38189746e+03,  1.15598030e+02,
         1.18464966e+03],
       [ 3.77447571e+02, -1.98486694e+03, -1.46919739e+02,
         8.82361450e+01, -2.91837921e+02,  1.55961511e+03,
        -7.56238892e+02, -1.82575256e+02, -1.38435989e+02,
        -1.27114795e+03],
       [-2.36450058e+02,  1.23815735e+03,  1.70404614e+03,
        -2.93423218e+02,  4.41404877e+02,  1.21317200e+03,
         3.98147964e+01, -1.53046179e+03,  2.26907983e+03,
        -8.12999268e+02],
       [ 5.73893372e+02,  7.45158997e+02,  4.27829681e+02,
         3.03202759e+03,  8.01568481e+02,  1.87196545e+03,
        -1.27050269e+03, -1.71206128e+03, -2.69544556e+02,
         8.15416809e+02],
       [ 7.72669006e+02, -2.57788965e+03, -9.58937622e+02,
         3.18186890e+02, -1.34678406e+03,  7.71586914e+02,
        -6.80415222e+02,  1.90342590e+02, -4.01460266e+02,
        -8.74833191e+02],
       [-1.67581543e+02,  1.85107458e+03,  1.98667310e+03,
        -1.00533234e+03,  5.10061829e+02,  4.55414948e+02,
         2.91180328e+02, -1.61395593e+03, -7.51449036e+02,
        -2.18367407e+03],
       [ 1.55631189e+03,  1.70442029e+03,  9.98810425e+02,
         1.52865967e+03,  1.89428516e+03, -1.39310510e+03,
        -6.80889404e+02,  3.69799652e+02, -1.04930798e+03,
        -1.13336816e+03],
       [ 1.62443628e+03, -2.99013550e+03, -1.46089771e+03,
         4.95036346e+02, -1.78223865e+03,  6.11130798e+02,
        -5.85772896e+01, -5.01874847e+01,  5.37595581e+02,
         1.24109657e+02],
       [-3.81448578e+02,  1.07915369e+03,  2.45449048e+03,
        -3.68017853e+02, -1.94480005e+03,  4.57458191e+02,
         7.46258621e+01, -1.18564026e+03, -4.54986847e+02,
        -1.07909082e+03],
       [ 3.05053809e+03,  2.04432568e+03,  2.85523438e+02,
        -3.49403717e+02,  1.13624646e+03,  8.19719971e+02,
        -6.80744934e+02,  1.92778467e+03, -7.98767700e+02,
        -4.29146027e+02],
       [ 2.12955469e+03, -2.21654688e+03, -8.67325623e+02,
        -5.85421387e+02, -9.59737976e+02,  5.73891907e+02,
         3.46555420e+02, -1.17848694e+03, -1.45648239e+02,
        -7.09632385e+02],
       [-3.18382416e+02,  6.03848877e+02,  2.66268872e+03,
         9.42292480e+01, -3.28221875e+03,  2.82165466e+02,
         1.29477730e+01, -6.45987305e+02,  9.14328861e+00,
        -5.97544067e+02],
       [ 3.60021460e+03,  2.47155103e+03, -1.17262146e+02,
        -1.01403625e+03,  4.94422577e+02,  1.80453113e+03,
        -6.34999084e+02,  2.50730811e+03, -1.62388596e+02,
         3.49145996e+02],
       [ 2.09694897e+03, -1.54658813e+03, -2.62056274e+02,
        -1.27202368e+03, -2.82052643e+02,  1.20123438e+03,
         4.87233093e+02, -1.96726050e+03, -3.55999268e+02,
        -1.12381897e+03],
       [-1.02250452e+01,  3.26233093e+02,  2.73899609e+03,
         2.45289200e+02, -3.72901587e+03,  2.52515472e+02,
         1.94348984e+01, -9.52180176e+01,  2.68927460e+02,
        -5.84157333e+01],
       [ 3.74437598e+03,  2.51960913e+03, -4.21100098e+02,
        -1.11150732e+03, -2.86636841e+02,  2.01044873e+03,
        -6.05981812e+02,  2.56864014e+03,  3.05078766e+02,
         4.52939606e+02],
       [ 2.05319849e+03, -1.36797485e+03,  2.59717834e+02,
        -1.38438477e+03,  2.85807590e+01,  1.36394568e+03,
         4.74861938e+02, -2.09422778e+03, -2.43468597e+02,
        -1.35360828e+03],
       [ 2.73833069e+02,  1.48126278e+01,  2.70984521e+03,
         3.97795105e+02, -3.26361206e+03,  9.89684143e+01,
         5.81060410e+00,  4.48562469e+02,  2.05699783e+02,
         3.88113220e+02],
       [ 3.53552930e+03,  2.31609229e+03, -6.79289978e+02,
        -8.94086060e+02, -1.00466663e+03,  1.74689099e+03,
        -6.05265808e+02,  2.31700488e+03,  6.97390991e+02,
         1.51789383e+02],
       [ 2.04745667e+03, -1.53638354e+03,  7.95200867e+02,
        -1.10628430e+03,  3.96294220e+02,  9.99953430e+02,
         4.31164795e+02, -1.97166772e+03, -1.00647079e+02,
        -1.36729590e+03],
       [ 3.19512848e+02, -4.94936188e+02,  2.68637817e+03,
         6.88147400e+02, -1.82770984e+03, -1.67060699e+02,
        -8.91502075e+01,  1.11233264e+03,  5.48635063e+01,
         1.05460266e+03],
       [ 2.89966602e+03,  1.78642932e+03, -8.88530334e+02,
        -1.37924377e+02, -1.47845105e+03,  6.97005798e+02,
        -6.05475403e+02,  1.52152759e+03,  1.00856891e+03,
        -7.20073914e+02],
       [ 2.10748145e+03, -1.98748621e+03,  1.55926074e+03,
        -4.57886047e+02,  1.19627026e+03,  3.37855804e+02,
         2.61629944e+02, -1.02774353e+03, -1.48549133e+02,
        -8.47029907e+02],
       [ 1.82987442e+02, -1.26583838e+03,  2.60219482e+03,
         8.81785522e+02,  6.47570374e+02, -2.88034393e+02,
        -2.73091583e+02,  1.70747351e+03,  2.71955292e+02,
         2.33375610e+03],
       [ 1.47538416e+03,  1.32222668e+03, -1.47548389e+03,
         1.87475513e+03, -1.81497241e+03, -1.18999438e+03,
        -6.78561707e+02, -1.55539047e+02,  5.38907104e+02,
        -1.50548352e+03],
       [ 1.65825159e+03, -2.57166504e+03,  2.36215527e+03,
         4.62751556e+02,  2.11251904e+03,  3.89508301e+02,
        -2.57402191e+02,  4.65438904e+02, -4.10946503e+02,
         2.89537537e+02],
       [ 1.80707687e+02, -2.20998215e+02,  2.12048438e+03,
         4.04977020e+02, -9.37738037e+02, -9.42293335e+02,
         9.97517700e+01,  5.76236389e+02,  3.59482324e+03,
         5.38799477e+00],
       [ 3.22476318e+02,  4.17888000e+02, -3.60746979e+02,
         3.06411060e+03, -7.58105469e+01,  2.20502441e+03,
        -1.60521057e+03, -2.55681616e+03,  5.04469849e+02,
         7.66406494e+02],
       [ 6.01714539e+02, -2.16994629e+03,  9.09103394e+02,
         4.26091156e+02,  8.15671570e+02,  8.71706238e+02,
        -8.68009888e+02, -4.56524445e+02,  1.71742203e+02,
        -2.24893311e+03],
       [ 3.80510979e+01,  2.85049103e+02,  1.92005969e+03,
         2.62522335e+01, -1.67834985e+03, -8.11846695e+01,
         9.17216873e+01, -2.30699142e+02,  3.74829175e+03,
        -3.86119232e+02],
       [ 1.77281723e+02,  2.38561783e+02, -3.75420418e+01,
         3.06554443e+03,  3.06699829e+02,  2.03306738e+03,
        -1.64140234e+03, -2.53619751e+03, -7.04078102e+00,
         6.16134705e+02],
       [ 4.17853363e+02, -2.24431519e+03,  3.70623108e+02,
         2.60421417e+02,  1.60754288e+02,  1.27338879e+03,
        -8.80008911e+02, -6.62214050e+02, -2.25339035e+02,
        -2.31507666e+03],
       [-1.27532326e+02,  7.89985657e+02,  2.00262622e+03,
        -3.43424622e+02, -7.65619934e+02,  6.45438904e+02,
         6.11903000e+01, -1.01124182e+03,  3.53268091e+03,
        -7.74609131e+02],
       [ 2.86516174e+02,  4.86997314e+02,  2.12426804e+02,
         3.09466211e+03,  6.48148376e+02,  2.28234888e+03,
        -1.65522986e+03, -2.45007739e+03, -4.00770203e+02,
         9.63956543e+02],
       [ 5.47582336e+02, -2.33136206e+03, -1.90791107e+02,
         3.85024597e+02, -5.40238525e+02,  1.09216296e+03,
        -8.69172607e+02, -5.84141418e+02, -6.28034546e+02,
        -2.19338037e+03],
       [-2.03752441e+02,  1.97270715e+03,  2.06571021e+03,
        -1.01557806e+03,  4.94756989e+02,  4.12604980e+02,
         2.97234863e+02, -1.70550610e+03, -7.78629883e+02,
        -2.04468384e+03],
       [ 1.65779211e+03,  1.69920129e+03,  9.49528137e+02,
         1.46025330e+03,  1.92589185e+03, -9.29970093e+02,
        -8.41354370e+02,  4.92698944e+02, -9.29106201e+02,
        -1.30421094e+03],
       [ 1.69982178e+03, -3.12920947e+03, -1.49994495e+03,
         5.63029907e+02, -1.85545154e+03,  6.72461792e+02,
        -2.24975067e+02,  2.26751297e+02,  6.56324707e+02,
        -9.45345612e+01],
       [-2.76170410e+02,  7.95938965e+02,  2.70962598e+03,
        -2.13857025e+02, -3.48169849e+03,  6.65482300e+02,
        -1.48769207e+01, -5.36984985e+02, -2.34287888e+02,
        -4.49787872e+02],
       [ 3.68992798e+03,  2.24383398e+03, -1.23972679e+02,
        -7.06750977e+02,  2.93332611e+02,  1.91177075e+03,
        -7.57229919e+02,  2.50147632e+03, -1.69555679e+02,
        -1.38560028e+02],
       [ 1.94720618e+03, -1.96563403e+03, -2.14263428e+02,
        -6.08597168e+02,  6.50885010e+01,  3.82304443e+02,
         1.11396988e+02, -1.41049329e+03, -4.77256866e+02,
        -2.86183228e+03],
       [-5.45855856e+00,  3.65750641e+02,  2.76438867e+03,
         1.51885834e+02, -3.97487915e+03,  3.81480408e+02,
         3.14079895e+01, -7.88156204e+01,  1.47110199e+02,
         2.05500031e+02],
       [ 3.81793945e+03,  2.24890234e+03, -3.73221497e+02,
        -8.29695923e+02, -2.74338165e+02,  2.00526233e+03,
        -6.48730591e+02,  2.38320239e+03,  2.86682190e+02,
         3.56091042e+01],
       [ 1.88006934e+03, -1.67919568e+03,  3.33634583e+02,
        -7.80917480e+02,  5.71147118e+01,  8.34564697e+02,
         1.22797394e+00, -1.36724719e+03, -4.24378723e+02,
        -3.29776050e+03],
       [ 2.42965622e+02, -9.74083862e+01,  2.82274829e+03,
         5.59261414e+02, -3.34764551e+03, -4.28300591e+01,
         3.20098114e+01,  4.65022156e+02, -9.43314667e+01,
         8.06617188e+02],
       [ 3.55214600e+03,  2.10062744e+03, -6.15352173e+02,
        -5.69793518e+02, -8.05824219e+02,  1.80614722e+03,
        -7.34117554e+02,  2.29223169e+03,  7.19567871e+02,
        -3.10226410e+02],
       [ 2.04574670e+03, -1.79434192e+03,  9.64689270e+02,
        -6.05485535e+02,  9.26129837e+01,  4.02693024e+02,
         1.03879990e+02, -1.30258850e+03, -3.32522156e+02,
        -2.67960547e+03]], dtype=np.float32)

# landmark - pipnet

PIP_to_5 = {
    68:{'eye_left':[37,38,37,41],
        'eye_right':[43,44,43,47],
        'nose':[30,-1,30,33],
        'mouth_left':[48,-1,48,-1],
        'mouth_right':[54,-1,54,-1]
       },
    
    29:{'eye_left':[16,-1,16,-1],
        'eye_right':[17,-1,17,-1],
        'nose':[20,-1,20,21],
        'mouth_left':[22,-1,22,-1],
        'mouth_right':[23,-1,23,-1]
       },
    
    98:{'eye_left':[96,-1,96,-1],
        'eye_right':[97,-1,97,-1],
        'nose':[54,-1,54,-1],
        'mouth_left':[76,-1,76,-1],
        'mouth_right':[82,-1,82,-1]
       },
    
    19:{'eye_left':[7,-1,7,-1],
        'eye_right':[10,-1,10,-1],
        'nose':[13,-1,13,-1],
        'mouth_left':[15,-1,15,-1],
        'mouth_right':[17,-1,17,-1]
       }
}

# detection - blazeface 640 cfg
cfg_blaze = {
    'name': 'Blaze',
    # origin anchor
    # 'min_sizes': [[16, 24], [32, 48, 64, 80, 96, 128]],
    # kmeans and evolving for 640x640
    'min_sizes': [[8, 11], [14, 19, 26, 38, 64, 149]], 
    'steps': [8, 16],
    'variance': [0.1, 0.2],
    'clip': False,
    'loc_weight': 1,
    'cls_weight': 6,
    'landm_weight': 0.1, 
    'gpu_train': True,
    'batch_size': 256,
    'ngpu': 1,
    'epoch': 200,
    'decay1': 130,
    'decay2': 160,
    'decay3': 175,
    'decay4': 185,
    'image_size': 320,
    'num_classes':2
}