// This file is @generated by prost-build.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct CloudFile {
    #[prost(string, tag = "1")]
    pub uri: ::prost::alloc::string::String,
    #[prost(uint64, tag = "2")]
    pub size: u64,
    #[prost(string, tag = "3")]
    pub content_type: ::prost::alloc::string::String,
    #[prost(string, tag = "4")]
    pub bucket_name: ::prost::alloc::string::String,
    #[prost(enumeration = "cloud_file::Source", tag = "5")]
    pub source: i32,
    #[prost(string, tag = "6")]
    pub filename: ::prost::alloc::string::String,
    /// Temporal upload information
    #[prost(string, tag = "7")]
    pub resumable_uri: ::prost::alloc::string::String,
    #[prost(uint64, tag = "8")]
    pub offset: u64,
    #[prost(string, tag = "9")]
    pub upload_uri: ::prost::alloc::string::String,
    #[prost(string, repeated, tag = "10")]
    pub parts: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(string, tag = "11")]
    pub old_uri: ::prost::alloc::string::String,
    #[prost(string, tag = "12")]
    pub old_bucket: ::prost::alloc::string::String,
    #[prost(string, tag = "13")]
    pub md5: ::prost::alloc::string::String,
}
/// Nested message and enum types in `CloudFile`.
pub mod cloud_file {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Source {
        Flaps = 0,
        Gcs = 1,
        S3 = 2,
        Local = 3,
        External = 4,
        Empty = 5,
        Export = 6,
        Postgres = 7,
    }
    impl Source {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Source::Flaps => "FLAPS",
                Source::Gcs => "GCS",
                Source::S3 => "S3",
                Source::Local => "LOCAL",
                Source::External => "EXTERNAL",
                Source::Empty => "EMPTY",
                Source::Export => "EXPORT",
                Source::Postgres => "POSTGRES",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "FLAPS" => Some(Self::Flaps),
                "GCS" => Some(Self::Gcs),
                "S3" => Some(Self::S3),
                "LOCAL" => Some(Self::Local),
                "EXTERNAL" => Some(Self::External),
                "EMPTY" => Some(Self::Empty),
                "EXPORT" => Some(Self::Export),
                "POSTGRES" => Some(Self::Postgres),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Basic {
    #[prost(string, tag = "1")]
    pub slug: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub icon: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub title: ::prost::alloc::string::String,
    #[prost(string, tag = "4")]
    pub summary: ::prost::alloc::string::String,
    /// reference to inner thumbnail
    #[prost(string, tag = "5")]
    pub thumbnail: ::prost::alloc::string::String,
    #[prost(string, tag = "6")]
    pub layout: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "7")]
    pub created: ::core::option::Option<::prost_types::Timestamp>,
    #[prost(message, optional, tag = "8")]
    pub modified: ::core::option::Option<::prost_types::Timestamp>,
    #[prost(message, optional, tag = "9")]
    pub metadata: ::core::option::Option<Metadata>,
    /// Not Basic
    #[prost(message, optional, tag = "10")]
    pub usermetadata: ::core::option::Option<UserMetadata>,
    #[prost(message, repeated, tag = "11")]
    pub fieldmetadata: ::prost::alloc::vec::Vec<UserFieldMetadata>,
    #[prost(message, optional, tag = "15")]
    pub computedmetadata: ::core::option::Option<ComputedMetadata>,
    /// Only for read operations
    #[prost(string, tag = "12")]
    pub uuid: ::prost::alloc::string::String,
    #[prost(string, repeated, tag = "13")]
    pub labels: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// last processing seqid of the resource
    #[prost(int64, tag = "14")]
    pub last_seqid: i64,
    /// last processing sequid (non nats) of this resource in the account queue
    #[prost(int64, tag = "35")]
    pub last_account_seq: i64,
    #[prost(enumeration = "basic::QueueType", tag = "36")]
    pub queue: i32,
}
/// Nested message and enum types in `Basic`.
pub mod basic {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum QueueType {
        Private = 0,
        Shared = 1,
    }
    impl QueueType {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                QueueType::Private => "PRIVATE",
                QueueType::Shared => "SHARED",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "PRIVATE" => Some(Self::Private),
                "SHARED" => Some(Self::Shared),
                _ => None,
            }
        }
    }
}
/// Block behaviors
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Origin {
    #[prost(enumeration = "origin::Source", tag = "1")]
    pub source: i32,
    #[prost(string, tag = "2")]
    pub source_id: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub url: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "4")]
    pub created: ::core::option::Option<::prost_types::Timestamp>,
    #[prost(message, optional, tag = "5")]
    pub modified: ::core::option::Option<::prost_types::Timestamp>,
    #[prost(map = "string, string", tag = "6")]
    pub metadata: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
    #[prost(string, repeated, tag = "7")]
    pub tags: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(string, repeated, tag = "8")]
    pub colaborators: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(string, tag = "9")]
    pub filename: ::prost::alloc::string::String,
    #[prost(string, repeated, tag = "10")]
    pub related: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(string, tag = "11")]
    pub path: ::prost::alloc::string::String,
}
/// Nested message and enum types in `Origin`.
pub mod origin {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Source {
        Web = 0,
        Desktop = 1,
        Api = 2,
    }
    impl Source {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Source::Web => "WEB",
                Source::Desktop => "DESKTOP",
                Source::Api => "API",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "WEB" => Some(Self::Web),
                "DESKTOP" => Some(Self::Desktop),
                "API" => Some(Self::Api),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Extra {
    #[prost(message, optional, tag = "1")]
    pub metadata: ::core::option::Option<::prost_types::Struct>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Relations {
    #[prost(message, repeated, tag = "1")]
    pub relations: ::prost::alloc::vec::Vec<super::utils::Relation>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct MessageContent {
    #[prost(string, tag = "1")]
    pub text: ::prost::alloc::string::String,
    #[prost(enumeration = "message_content::Format", tag = "2")]
    pub format: i32,
    #[prost(message, repeated, tag = "4")]
    pub attachments: ::prost::alloc::vec::Vec<CloudFile>,
}
/// Nested message and enum types in `MessageContent`.
pub mod message_content {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Format {
        Plain = 0,
        Html = 1,
        Markdown = 2,
        Rst = 3,
        KeepMarkdown = 4,
    }
    impl Format {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Format::Plain => "PLAIN",
                Format::Html => "HTML",
                Format::Markdown => "MARKDOWN",
                Format::Rst => "RST",
                Format::KeepMarkdown => "KEEP_MARKDOWN",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "PLAIN" => Some(Self::Plain),
                "HTML" => Some(Self::Html),
                "MARKDOWN" => Some(Self::Markdown),
                "RST" => Some(Self::Rst),
                "KEEP_MARKDOWN" => Some(Self::KeepMarkdown),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Message {
    #[prost(message, optional, tag = "1")]
    pub timestamp: ::core::option::Option<::prost_types::Timestamp>,
    #[prost(string, tag = "2")]
    pub who: ::prost::alloc::string::String,
    #[prost(string, repeated, tag = "3")]
    pub to: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(message, optional, tag = "4")]
    pub content: ::core::option::Option<MessageContent>,
    #[prost(string, tag = "5")]
    pub ident: ::prost::alloc::string::String,
    #[prost(enumeration = "message::MessageType", tag = "6")]
    pub r#type: i32,
}
/// Nested message and enum types in `Message`.
pub mod message {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum MessageType {
        Unset = 0,
        Question = 1,
        Answer = 2,
    }
    impl MessageType {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                MessageType::Unset => "UNSET",
                MessageType::Question => "QUESTION",
                MessageType::Answer => "ANSWER",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "UNSET" => Some(Self::Unset),
                "QUESTION" => Some(Self::Question),
                "ANSWER" => Some(Self::Answer),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Conversation {
    #[prost(message, repeated, tag = "1")]
    pub messages: ::prost::alloc::vec::Vec<Message>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FieldConversation {
    /// Total number of pages
    #[prost(int32, tag = "1")]
    pub pages: i32,
    /// Max page size
    #[prost(int32, tag = "2")]
    pub size: i32,
    /// Total number of messages
    #[prost(int32, tag = "3")]
    pub total: i32,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct NestedPosition {
    #[prost(int64, tag = "1")]
    pub start: i64,
    #[prost(int64, tag = "2")]
    pub end: i64,
    #[prost(int64, tag = "3")]
    pub page: i64,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct NestedListPosition {
    #[prost(message, repeated, tag = "1")]
    pub positions: ::prost::alloc::vec::Vec<NestedPosition>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FileExtractedData {
    #[prost(string, tag = "1")]
    pub language: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub md5: ::prost::alloc::string::String,
    #[prost(map = "string, string", tag = "3")]
    pub metadata: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
    #[prost(map = "string, string", tag = "4")]
    pub nested: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
    #[prost(map = "string, message", tag = "5")]
    pub file_generated: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        CloudFile,
    >,
    #[prost(map = "string, message", tag = "6")]
    pub file_rows_previews: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        RowsPreview,
    >,
    #[prost(message, optional, tag = "7")]
    pub file_preview: ::core::option::Option<CloudFile>,
    #[prost(message, optional, tag = "8")]
    pub file_pages_previews: ::core::option::Option<FilePages>,
    #[prost(message, optional, tag = "9")]
    pub file_thumbnail: ::core::option::Option<CloudFile>,
    #[prost(string, tag = "10")]
    pub field: ::prost::alloc::string::String,
    #[prost(string, tag = "11")]
    pub icon: ::prost::alloc::string::String,
    #[prost(map = "string, message", tag = "12")]
    pub nested_position: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        NestedPosition,
    >,
    #[prost(map = "string, message", tag = "13")]
    pub nested_list_position: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        NestedListPosition,
    >,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct LinkExtractedData {
    #[prost(message, optional, tag = "1")]
    pub date: ::core::option::Option<::prost_types::Timestamp>,
    #[prost(string, tag = "2")]
    pub language: ::prost::alloc::string::String,
    #[prost(string, tag = "4")]
    pub title: ::prost::alloc::string::String,
    #[prost(map = "string, string", tag = "5")]
    pub metadata: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
    #[prost(message, optional, tag = "6")]
    pub link_thumbnail: ::core::option::Option<CloudFile>,
    #[prost(message, optional, tag = "7")]
    pub link_preview: ::core::option::Option<CloudFile>,
    #[prost(string, tag = "8")]
    pub field: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "9")]
    pub link_image: ::core::option::Option<CloudFile>,
    #[prost(string, tag = "10")]
    pub description: ::prost::alloc::string::String,
    #[prost(string, tag = "11")]
    pub r#type: ::prost::alloc::string::String,
    #[prost(string, tag = "12")]
    pub embed: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "13")]
    pub pdf_structure: ::core::option::Option<PageStructure>,
    /// The key is the file ID
    #[prost(map = "string, message", tag = "14")]
    pub file_generated: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        CloudFile,
    >,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ExtractedTextWrapper {
    #[prost(message, optional, tag = "3")]
    pub field: ::core::option::Option<FieldId>,
    #[prost(oneof = "extracted_text_wrapper::FileOrData", tags = "1, 2")]
    pub file_or_data: ::core::option::Option<extracted_text_wrapper::FileOrData>,
}
/// Nested message and enum types in `ExtractedTextWrapper`.
pub mod extracted_text_wrapper {
    #[allow(clippy::derive_partial_eq_without_eq)]
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum FileOrData {
        #[prost(message, tag = "1")]
        Body(super::super::utils::ExtractedText),
        #[prost(message, tag = "2")]
        File(super::CloudFile),
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ExtractedVectorsWrapper {
    #[prost(message, optional, tag = "3")]
    pub field: ::core::option::Option<FieldId>,
    #[prost(string, tag = "4")]
    pub vectorset_id: ::prost::alloc::string::String,
    #[prost(oneof = "extracted_vectors_wrapper::FileOrData", tags = "1, 2")]
    pub file_or_data: ::core::option::Option<extracted_vectors_wrapper::FileOrData>,
}
/// Nested message and enum types in `ExtractedVectorsWrapper`.
pub mod extracted_vectors_wrapper {
    #[allow(clippy::derive_partial_eq_without_eq)]
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum FileOrData {
        #[prost(message, tag = "1")]
        Vectors(super::super::utils::VectorObject),
        #[prost(message, tag = "2")]
        File(super::CloudFile),
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct UserVectorsWrapper {
    #[prost(message, optional, tag = "1")]
    pub vectors: ::core::option::Option<super::utils::UserVectorSet>,
    /// Vectorset prefix vector id
    #[prost(map = "string, message", tag = "13")]
    pub vectors_to_delete: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        super::utils::UserVectorsList,
    >,
    #[prost(message, optional, tag = "3")]
    pub field: ::core::option::Option<FieldId>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Sentence {
    #[prost(int32, tag = "1")]
    pub start: i32,
    #[prost(int32, tag = "2")]
    pub end: i32,
    #[prost(string, tag = "3")]
    pub key: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PageInformation {
    #[prost(uint32, tag = "1")]
    pub page: u32,
    #[prost(bool, tag = "2")]
    pub page_with_visual: bool,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Representation {
    #[prost(bool, tag = "1")]
    pub is_a_table: bool,
    #[prost(string, tag = "2")]
    pub reference_file: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ParagraphRelations {
    #[prost(string, repeated, tag = "1")]
    pub parents: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(string, repeated, tag = "2")]
    pub siblings: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(string, repeated, tag = "3")]
    pub replacements: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Paragraph {
    #[prost(uint32, tag = "1")]
    pub start: u32,
    #[prost(uint32, tag = "2")]
    pub end: u32,
    #[prost(uint32, repeated, tag = "3")]
    pub start_seconds: ::prost::alloc::vec::Vec<u32>,
    #[prost(uint32, repeated, tag = "4")]
    pub end_seconds: ::prost::alloc::vec::Vec<u32>,
    #[prost(enumeration = "paragraph::TypeParagraph", tag = "5")]
    pub kind: i32,
    #[prost(message, repeated, tag = "6")]
    pub classifications: ::prost::alloc::vec::Vec<Classification>,
    #[prost(message, repeated, tag = "7")]
    pub sentences: ::prost::alloc::vec::Vec<Sentence>,
    #[prost(string, tag = "8")]
    pub key: ::prost::alloc::string::String,
    /// Optional, as a computed value
    #[prost(string, tag = "9")]
    pub text: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "10")]
    pub page: ::core::option::Option<PageInformation>,
    #[prost(message, optional, tag = "11")]
    pub representation: ::core::option::Option<Representation>,
    #[prost(message, optional, tag = "12")]
    pub relations: ::core::option::Option<ParagraphRelations>,
}
/// Nested message and enum types in `Paragraph`.
pub mod paragraph {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum TypeParagraph {
        Text = 0,
        Ocr = 1,
        Inception = 2,
        Description = 3,
        Transcript = 4,
        Title = 5,
        Table = 6,
    }
    impl TypeParagraph {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                TypeParagraph::Text => "TEXT",
                TypeParagraph::Ocr => "OCR",
                TypeParagraph::Inception => "INCEPTION",
                TypeParagraph::Description => "DESCRIPTION",
                TypeParagraph::Transcript => "TRANSCRIPT",
                TypeParagraph::Title => "TITLE",
                TypeParagraph::Table => "TABLE",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "TEXT" => Some(Self::Text),
                "OCR" => Some(Self::Ocr),
                "INCEPTION" => Some(Self::Inception),
                "DESCRIPTION" => Some(Self::Description),
                "TRANSCRIPT" => Some(Self::Transcript),
                "TITLE" => Some(Self::Title),
                "TABLE" => Some(Self::Table),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Position {
    #[prost(int64, tag = "1")]
    pub start: i64,
    #[prost(int64, tag = "2")]
    pub end: i64,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Positions {
    #[prost(message, repeated, tag = "1")]
    pub position: ::prost::alloc::vec::Vec<Position>,
    #[prost(string, tag = "2")]
    pub entity: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FieldMetadata {
    #[prost(string, repeated, tag = "1")]
    pub links: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(message, repeated, tag = "2")]
    pub paragraphs: ::prost::alloc::vec::Vec<Paragraph>,
    /// Document
    #[prost(map = "string, string", tag = "3")]
    pub ner: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
    #[prost(message, repeated, tag = "4")]
    pub classifications: ::prost::alloc::vec::Vec<Classification>,
    #[prost(message, optional, tag = "5")]
    pub last_index: ::core::option::Option<::prost_types::Timestamp>,
    #[prost(message, optional, tag = "6")]
    pub last_understanding: ::core::option::Option<::prost_types::Timestamp>,
    #[prost(message, optional, tag = "7")]
    pub last_extract: ::core::option::Option<::prost_types::Timestamp>,
    #[prost(message, optional, tag = "8")]
    pub last_summary: ::core::option::Option<::prost_types::Timestamp>,
    #[prost(message, optional, tag = "9")]
    pub thumbnail: ::core::option::Option<CloudFile>,
    #[prost(string, tag = "10")]
    pub language: ::prost::alloc::string::String,
    #[prost(string, tag = "11")]
    pub summary: ::prost::alloc::string::String,
    /// Document
    #[prost(map = "string, message", tag = "12")]
    pub positions: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        Positions,
    >,
    #[prost(message, repeated, tag = "13")]
    pub relations: ::prost::alloc::vec::Vec<Relations>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Question {
    #[prost(string, tag = "1")]
    pub text: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub language: ::prost::alloc::string::String,
    #[prost(string, repeated, tag = "3")]
    pub ids_paragraphs: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Answers {
    #[prost(string, tag = "1")]
    pub text: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub language: ::prost::alloc::string::String,
    #[prost(string, repeated, tag = "3")]
    pub ids_paragraphs: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct QuestionAnswer {
    #[prost(message, optional, tag = "1")]
    pub question: ::core::option::Option<Question>,
    #[prost(message, repeated, tag = "2")]
    pub answers: ::prost::alloc::vec::Vec<Answers>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct QuestionAnswers {
    #[prost(message, repeated, tag = "1")]
    pub question_answer: ::prost::alloc::vec::Vec<QuestionAnswer>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FieldQuestionAnswerWrapper {
    #[prost(message, optional, tag = "3")]
    pub field: ::core::option::Option<FieldId>,
    #[prost(oneof = "field_question_answer_wrapper::FileOrData", tags = "1, 2")]
    pub file_or_data: ::core::option::Option<field_question_answer_wrapper::FileOrData>,
}
/// Nested message and enum types in `FieldQuestionAnswerWrapper`.
pub mod field_question_answer_wrapper {
    #[allow(clippy::derive_partial_eq_without_eq)]
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum FileOrData {
        #[prost(message, tag = "1")]
        QuestionAnswers(super::QuestionAnswers),
        #[prost(message, tag = "2")]
        File(super::CloudFile),
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FieldComputedMetadata {
    #[prost(message, optional, tag = "1")]
    pub metadata: ::core::option::Option<FieldMetadata>,
    #[prost(map = "string, message", tag = "2")]
    pub split_metadata: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        FieldMetadata,
    >,
    #[prost(string, repeated, tag = "3")]
    pub deleted_splits: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FieldComputedMetadataWrapper {
    #[prost(message, optional, tag = "1")]
    pub metadata: ::core::option::Option<FieldComputedMetadata>,
    #[prost(message, optional, tag = "4")]
    pub field: ::core::option::Option<FieldId>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Metadata {
    #[prost(map = "string, string", tag = "1")]
    pub metadata: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
    #[prost(string, tag = "2")]
    pub language: ::prost::alloc::string::String,
    #[prost(string, repeated, tag = "3")]
    pub languages: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(bool, tag = "4")]
    pub useful: bool,
    #[prost(enumeration = "metadata::Status", tag = "5")]
    pub status: i32,
}
/// Nested message and enum types in `Metadata`.
pub mod metadata {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Status {
        Pending = 0,
        Processed = 1,
        Error = 2,
        Blocked = 3,
        Expired = 4,
    }
    impl Status {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Status::Pending => "PENDING",
                Status::Processed => "PROCESSED",
                Status::Error => "ERROR",
                Status::Blocked => "BLOCKED",
                Status::Expired => "EXPIRED",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "PENDING" => Some(Self::Pending),
                "PROCESSED" => Some(Self::Processed),
                "ERROR" => Some(Self::Error),
                "BLOCKED" => Some(Self::Blocked),
                "EXPIRED" => Some(Self::Expired),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FieldText {
    #[prost(string, tag = "1")]
    pub body: ::prost::alloc::string::String,
    #[prost(enumeration = "field_text::Format", tag = "2")]
    pub format: i32,
    #[prost(string, tag = "3")]
    pub md5: ::prost::alloc::string::String,
}
/// Nested message and enum types in `FieldText`.
pub mod field_text {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Format {
        Plain = 0,
        Html = 1,
        Rst = 2,
        Markdown = 3,
        Json = 4,
        /// Markdown to be kept
        KeepMarkdown = 5,
    }
    impl Format {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Format::Plain => "PLAIN",
                Format::Html => "HTML",
                Format::Rst => "RST",
                Format::Markdown => "MARKDOWN",
                Format::Json => "JSON",
                Format::KeepMarkdown => "KEEP_MARKDOWN",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "PLAIN" => Some(Self::Plain),
                "HTML" => Some(Self::Html),
                "RST" => Some(Self::Rst),
                "MARKDOWN" => Some(Self::Markdown),
                "JSON" => Some(Self::Json),
                "KEEP_MARKDOWN" => Some(Self::KeepMarkdown),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Block {
    #[prost(int32, tag = "1")]
    pub x: i32,
    #[prost(int32, tag = "2")]
    pub y: i32,
    #[prost(int32, tag = "3")]
    pub cols: i32,
    #[prost(int32, tag = "4")]
    pub rows: i32,
    #[prost(enumeration = "block::TypeBlock", tag = "5")]
    pub r#type: i32,
    #[prost(string, tag = "6")]
    pub ident: ::prost::alloc::string::String,
    #[prost(string, tag = "7")]
    pub payload: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "8")]
    pub file: ::core::option::Option<CloudFile>,
}
/// Nested message and enum types in `Block`.
pub mod block {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum TypeBlock {
        Title = 0,
        Description = 1,
        Richtext = 2,
        Text = 3,
        Attachments = 4,
        Comments = 5,
        Classifications = 6,
    }
    impl TypeBlock {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                TypeBlock::Title => "TITLE",
                TypeBlock::Description => "DESCRIPTION",
                TypeBlock::Richtext => "RICHTEXT",
                TypeBlock::Text => "TEXT",
                TypeBlock::Attachments => "ATTACHMENTS",
                TypeBlock::Comments => "COMMENTS",
                TypeBlock::Classifications => "CLASSIFICATIONS",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "TITLE" => Some(Self::Title),
                "DESCRIPTION" => Some(Self::Description),
                "RICHTEXT" => Some(Self::Richtext),
                "TEXT" => Some(Self::Text),
                "ATTACHMENTS" => Some(Self::Attachments),
                "COMMENTS" => Some(Self::Comments),
                "CLASSIFICATIONS" => Some(Self::Classifications),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct LayoutContent {
    #[prost(map = "string, message", tag = "1")]
    pub blocks: ::std::collections::HashMap<::prost::alloc::string::String, Block>,
    #[prost(string, repeated, tag = "2")]
    pub deleted_blocks: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FieldLayout {
    #[prost(message, optional, tag = "1")]
    pub body: ::core::option::Option<LayoutContent>,
    #[prost(enumeration = "field_layout::Format", tag = "2")]
    pub format: i32,
}
/// Nested message and enum types in `FieldLayout`.
pub mod field_layout {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Format {
        NucliAv1 = 0,
    }
    impl Format {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Format::NucliAv1 => "NUCLIAv1",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "NUCLIAv1" => Some(Self::NucliAv1),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Classification {
    #[prost(string, tag = "1")]
    pub labelset: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub label: ::prost::alloc::string::String,
    #[prost(bool, tag = "3")]
    pub cancelled_by_user: bool,
    /// On field classification we need to set on which split is the classification
    #[prost(string, tag = "4")]
    pub split: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct UserMetadata {
    #[prost(message, repeated, tag = "1")]
    pub classifications: ::prost::alloc::vec::Vec<Classification>,
    #[prost(message, repeated, tag = "3")]
    pub relations: ::prost::alloc::vec::Vec<super::utils::Relation>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FieldClassifications {
    #[prost(message, optional, tag = "1")]
    pub field: ::core::option::Option<FieldId>,
    #[prost(message, repeated, tag = "2")]
    pub classifications: ::prost::alloc::vec::Vec<Classification>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ComputedMetadata {
    #[prost(message, repeated, tag = "1")]
    pub field_classifications: ::prost::alloc::vec::Vec<FieldClassifications>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TokenSplit {
    #[prost(string, tag = "1")]
    pub token: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub klass: ::prost::alloc::string::String,
    #[prost(uint32, tag = "3")]
    pub start: u32,
    #[prost(uint32, tag = "4")]
    pub end: u32,
    #[prost(bool, tag = "5")]
    pub cancelled_by_user: bool,
    #[prost(string, tag = "6")]
    pub split: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ParagraphAnnotation {
    #[prost(string, tag = "1")]
    pub key: ::prost::alloc::string::String,
    #[prost(message, repeated, tag = "2")]
    pub classifications: ::prost::alloc::vec::Vec<Classification>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct QuestionAnswerAnnotation {
    #[prost(message, optional, tag = "1")]
    pub question_answer: ::core::option::Option<QuestionAnswer>,
    #[prost(bool, tag = "2")]
    pub cancelled_by_user: bool,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct VisualSelection {
    #[prost(string, tag = "1")]
    pub label: ::prost::alloc::string::String,
    #[prost(float, tag = "2")]
    pub top: f32,
    #[prost(float, tag = "3")]
    pub left: f32,
    #[prost(float, tag = "4")]
    pub right: f32,
    #[prost(float, tag = "5")]
    pub bottom: f32,
    /// Token IDs are the indexes in PageStructure
    #[prost(uint32, repeated, tag = "6")]
    pub token_ids: ::prost::alloc::vec::Vec<u32>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PageSelections {
    #[prost(uint32, tag = "1")]
    pub page: u32,
    #[prost(message, repeated, tag = "2")]
    pub visual: ::prost::alloc::vec::Vec<VisualSelection>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct UserFieldMetadata {
    #[prost(message, repeated, tag = "1")]
    pub token: ::prost::alloc::vec::Vec<TokenSplit>,
    #[prost(message, repeated, tag = "2")]
    pub paragraphs: ::prost::alloc::vec::Vec<ParagraphAnnotation>,
    #[prost(message, repeated, tag = "4")]
    pub page_selections: ::prost::alloc::vec::Vec<PageSelections>,
    #[prost(message, repeated, tag = "5")]
    pub question_answers: ::prost::alloc::vec::Vec<QuestionAnswerAnnotation>,
    #[prost(message, optional, tag = "3")]
    pub field: ::core::option::Option<FieldId>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FieldLink {
    #[prost(message, optional, tag = "1")]
    pub added: ::core::option::Option<::prost_types::Timestamp>,
    #[prost(map = "string, string", tag = "2")]
    pub headers: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
    #[prost(map = "string, string", tag = "3")]
    pub cookies: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
    #[prost(string, tag = "4")]
    pub uri: ::prost::alloc::string::String,
    #[prost(string, tag = "5")]
    pub language: ::prost::alloc::string::String,
    #[prost(map = "string, string", tag = "6")]
    pub localstorage: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
    #[prost(string, tag = "7")]
    pub css_selector: ::prost::alloc::string::String,
    #[prost(string, tag = "8")]
    pub xpath: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Keyword {
    #[prost(string, tag = "1")]
    pub value: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FieldKeywordset {
    #[prost(message, repeated, tag = "1")]
    pub keywords: ::prost::alloc::vec::Vec<Keyword>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FieldDatetime {
    #[prost(message, optional, tag = "1")]
    pub value: ::core::option::Option<::prost_types::Timestamp>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FieldFile {
    #[prost(message, optional, tag = "1")]
    pub added: ::core::option::Option<::prost_types::Timestamp>,
    #[prost(message, optional, tag = "2")]
    pub file: ::core::option::Option<CloudFile>,
    #[prost(string, tag = "3")]
    pub language: ::prost::alloc::string::String,
    #[prost(string, tag = "4")]
    pub password: ::prost::alloc::string::String,
    #[prost(string, tag = "5")]
    pub url: ::prost::alloc::string::String,
    #[prost(map = "string, string", tag = "6")]
    pub headers: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Entity {
    #[prost(string, tag = "1")]
    pub token: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub root: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub r#type: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FieldLargeMetadata {
    #[prost(message, repeated, tag = "1")]
    pub entities: ::prost::alloc::vec::Vec<Entity>,
    #[prost(map = "string, int32", tag = "2")]
    pub tokens: ::std::collections::HashMap<::prost::alloc::string::String, i32>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct LargeComputedMetadata {
    #[prost(message, optional, tag = "1")]
    pub metadata: ::core::option::Option<FieldLargeMetadata>,
    #[prost(map = "string, message", tag = "2")]
    pub split_metadata: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        FieldLargeMetadata,
    >,
    #[prost(string, repeated, tag = "3")]
    pub deleted_splits: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct LargeComputedMetadataWrapper {
    #[prost(message, optional, tag = "3")]
    pub field: ::core::option::Option<FieldId>,
    #[prost(oneof = "large_computed_metadata_wrapper::FileOrData", tags = "1, 2")]
    pub file_or_data: ::core::option::Option<
        large_computed_metadata_wrapper::FileOrData,
    >,
}
/// Nested message and enum types in `LargeComputedMetadataWrapper`.
pub mod large_computed_metadata_wrapper {
    #[allow(clippy::derive_partial_eq_without_eq)]
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum FileOrData {
        #[prost(message, tag = "1")]
        Real(super::LargeComputedMetadata),
        #[prost(message, tag = "2")]
        File(super::CloudFile),
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PagePositions {
    #[prost(int64, tag = "1")]
    pub start: i64,
    #[prost(int64, tag = "2")]
    pub end: i64,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PageStructurePage {
    #[prost(int64, tag = "1")]
    pub width: i64,
    #[prost(int64, tag = "2")]
    pub height: i64,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PageStructureToken {
    #[prost(float, tag = "7")]
    pub x: f32,
    #[prost(float, tag = "8")]
    pub y: f32,
    #[prost(float, tag = "9")]
    pub width: f32,
    #[prost(float, tag = "10")]
    pub height: f32,
    #[prost(string, tag = "5")]
    pub text: ::prost::alloc::string::String,
    #[prost(float, tag = "6")]
    pub line: f32,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PageStructure {
    #[prost(message, optional, tag = "1")]
    pub page: ::core::option::Option<PageStructurePage>,
    #[prost(message, repeated, tag = "2")]
    pub tokens: ::prost::alloc::vec::Vec<PageStructureToken>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FilePages {
    #[prost(message, repeated, tag = "1")]
    pub pages: ::prost::alloc::vec::Vec<CloudFile>,
    #[prost(message, repeated, tag = "2")]
    pub positions: ::prost::alloc::vec::Vec<PagePositions>,
    #[prost(message, repeated, tag = "3")]
    pub structures: ::prost::alloc::vec::Vec<PageStructure>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct RowsPreview {
    #[prost(map = "string, message", tag = "1")]
    pub sheets: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        rows_preview::Sheet,
    >,
}
/// Nested message and enum types in `RowsPreview`.
pub mod rows_preview {
    #[allow(clippy::derive_partial_eq_without_eq)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct Sheet {
        #[prost(message, repeated, tag = "1")]
        pub rows: ::prost::alloc::vec::Vec<sheet::Row>,
    }
    /// Nested message and enum types in `Sheet`.
    pub mod sheet {
        #[allow(clippy::derive_partial_eq_without_eq)]
        #[derive(Clone, PartialEq, ::prost::Message)]
        pub struct Row {
            #[prost(string, repeated, tag = "1")]
            pub cell: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct FieldId {
    #[prost(enumeration = "FieldType", tag = "1")]
    pub field_type: i32,
    #[prost(string, tag = "2")]
    pub field: ::prost::alloc::string::String,
}
/// This message is used to store a list of all field ids of a particular
/// resource. Note that title and summary fields are not included.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct AllFieldIDs {
    #[prost(message, repeated, tag = "1")]
    pub fields: ::prost::alloc::vec::Vec<FieldId>,
}
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum FieldType {
    File = 0,
    Link = 1,
    Datetime = 2,
    Keywordset = 3,
    Text = 4,
    Layout = 5,
    /// Base title/summary fields
    Generic = 6,
    Conversation = 7,
}
impl FieldType {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            FieldType::File => "FILE",
            FieldType::Link => "LINK",
            FieldType::Datetime => "DATETIME",
            FieldType::Keywordset => "KEYWORDSET",
            FieldType::Text => "TEXT",
            FieldType::Layout => "LAYOUT",
            FieldType::Generic => "GENERIC",
            FieldType::Conversation => "CONVERSATION",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "FILE" => Some(Self::File),
            "LINK" => Some(Self::Link),
            "DATETIME" => Some(Self::Datetime),
            "KEYWORDSET" => Some(Self::Keywordset),
            "TEXT" => Some(Self::Text),
            "LAYOUT" => Some(Self::Layout),
            "GENERIC" => Some(Self::Generic),
            "CONVERSATION" => Some(Self::Conversation),
            _ => None,
        }
    }
}
