// This file is @generated by prost-build.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct TextInformation {
    #[prost(string, tag = "1")]
    pub text: ::prost::alloc::string::String,
    #[prost(string, repeated, tag = "2")]
    pub labels: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct IndexMetadata {
    /// Tantivy doc & para
    #[prost(message, optional, tag = "1")]
    pub modified: ::core::option::Option<::prost_types::Timestamp>,
    /// Tantivy doc & para
    #[prost(message, optional, tag = "2")]
    pub created: ::core::option::Option<::prost_types::Timestamp>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ShardId {
    #[prost(string, tag = "1")]
    pub id: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ShardIds {
    #[prost(message, repeated, tag = "1")]
    pub ids: ::prost::alloc::vec::Vec<ShardId>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ShardCreated {
    #[prost(string, tag = "1")]
    pub id: ::prost::alloc::string::String,
    #[prost(enumeration = "shard_created::DocumentService", tag = "2")]
    pub document_service: i32,
    #[prost(enumeration = "shard_created::ParagraphService", tag = "3")]
    pub paragraph_service: i32,
    #[prost(enumeration = "shard_created::VectorService", tag = "4")]
    pub vector_service: i32,
    #[prost(enumeration = "shard_created::RelationService", tag = "5")]
    pub relation_service: i32,
}
/// Nested message and enum types in `ShardCreated`.
pub mod shard_created {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum DocumentService {
        DocumentV0 = 0,
        DocumentV1 = 1,
        DocumentV2 = 2,
    }
    impl DocumentService {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                DocumentService::DocumentV0 => "DOCUMENT_V0",
                DocumentService::DocumentV1 => "DOCUMENT_V1",
                DocumentService::DocumentV2 => "DOCUMENT_V2",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "DOCUMENT_V0" => Some(Self::DocumentV0),
                "DOCUMENT_V1" => Some(Self::DocumentV1),
                "DOCUMENT_V2" => Some(Self::DocumentV2),
                _ => None,
            }
        }
    }
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum ParagraphService {
        ParagraphV0 = 0,
        ParagraphV1 = 1,
        ParagraphV2 = 2,
        ParagraphV3 = 3,
    }
    impl ParagraphService {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                ParagraphService::ParagraphV0 => "PARAGRAPH_V0",
                ParagraphService::ParagraphV1 => "PARAGRAPH_V1",
                ParagraphService::ParagraphV2 => "PARAGRAPH_V2",
                ParagraphService::ParagraphV3 => "PARAGRAPH_V3",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "PARAGRAPH_V0" => Some(Self::ParagraphV0),
                "PARAGRAPH_V1" => Some(Self::ParagraphV1),
                "PARAGRAPH_V2" => Some(Self::ParagraphV2),
                "PARAGRAPH_V3" => Some(Self::ParagraphV3),
                _ => None,
            }
        }
    }
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum VectorService {
        VectorV0 = 0,
        VectorV1 = 1,
    }
    impl VectorService {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                VectorService::VectorV0 => "VECTOR_V0",
                VectorService::VectorV1 => "VECTOR_V1",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "VECTOR_V0" => Some(Self::VectorV0),
                "VECTOR_V1" => Some(Self::VectorV1),
                _ => None,
            }
        }
    }
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum RelationService {
        RelationV0 = 0,
        RelationV1 = 1,
        RelationV2 = 2,
    }
    impl RelationService {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                RelationService::RelationV0 => "RELATION_V0",
                RelationService::RelationV1 => "RELATION_V1",
                RelationService::RelationV2 => "RELATION_V2",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "RELATION_V0" => Some(Self::RelationV0),
                "RELATION_V1" => Some(Self::RelationV1),
                "RELATION_V2" => Some(Self::RelationV2),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ResourceId {
    #[prost(string, tag = "1")]
    pub shard_id: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub uuid: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Shard {
    #[prost(message, optional, tag = "5")]
    pub metadata: ::core::option::Option<ShardMetadata>,
    #[prost(string, tag = "1")]
    pub shard_id: ::prost::alloc::string::String,
    #[prost(uint64, tag = "2")]
    pub fields: u64,
    #[prost(uint64, tag = "3")]
    pub paragraphs: u64,
    #[prost(uint64, tag = "4")]
    pub sentences: u64,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct EmptyResponse {}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct EmptyQuery {}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Position {
    #[prost(uint64, tag = "1")]
    pub index: u64,
    #[prost(uint64, tag = "2")]
    pub start: u64,
    #[prost(uint64, tag = "3")]
    pub end: u64,
    /// For pdfs/documents only
    #[prost(uint64, tag = "4")]
    pub page_number: u64,
    #[prost(bool, tag = "7")]
    pub in_page: bool,
    /// For multimedia only
    #[prost(uint32, repeated, tag = "5")]
    pub start_seconds: ::prost::alloc::vec::Vec<u32>,
    #[prost(uint32, repeated, tag = "6")]
    pub end_seconds: ::prost::alloc::vec::Vec<u32>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Representation {
    #[prost(bool, tag = "1")]
    pub is_a_table: bool,
    #[prost(string, tag = "2")]
    pub file: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SentenceMetadata {
    #[prost(message, optional, tag = "1")]
    pub position: ::core::option::Option<Position>,
    #[prost(bool, tag = "2")]
    pub page_with_visual: bool,
    #[prost(message, optional, tag = "3")]
    pub representation: ::core::option::Option<Representation>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct VectorSentence {
    #[prost(float, repeated, tag = "1")]
    pub vector: ::prost::alloc::vec::Vec<f32>,
    #[prost(message, optional, tag = "9")]
    pub metadata: ::core::option::Option<SentenceMetadata>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct VectorsetSentences {
    /// key is full id for vectors
    #[prost(map = "string, message", tag = "1")]
    pub sentences: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        VectorSentence,
    >,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ParagraphMetadata {
    #[prost(message, optional, tag = "1")]
    pub position: ::core::option::Option<Position>,
    #[prost(bool, tag = "2")]
    pub page_with_visual: bool,
    #[prost(message, optional, tag = "3")]
    pub representation: ::core::option::Option<Representation>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct IndexParagraph {
    /// Start end position in field text
    #[prost(int32, tag = "1")]
    pub start: i32,
    /// Start end position in field text
    #[prost(int32, tag = "2")]
    pub end: i32,
    /// Paragraph specific labels
    #[prost(string, repeated, tag = "3")]
    pub labels: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// key is full id for vectors
    #[prost(map = "string, message", tag = "4")]
    pub sentences: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        VectorSentence,
    >,
    /// key is vectorset id
    #[prost(map = "string, message", tag = "10")]
    pub vectorsets_sentences: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        VectorsetSentences,
    >,
    #[prost(string, tag = "5")]
    pub field: ::prost::alloc::string::String,
    /// split were it belongs
    #[prost(string, tag = "6")]
    pub split: ::prost::alloc::string::String,
    #[prost(uint64, tag = "7")]
    pub index: u64,
    #[prost(bool, tag = "8")]
    pub repeated_in_field: bool,
    #[prost(message, optional, tag = "9")]
    pub metadata: ::core::option::Option<ParagraphMetadata>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct VectorSetId {
    #[prost(message, optional, tag = "1")]
    pub shard: ::core::option::Option<ShardId>,
    #[prost(string, tag = "2")]
    pub vectorset: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct VectorSetList {
    #[prost(message, optional, tag = "1")]
    pub shard: ::core::option::Option<ShardId>,
    #[prost(string, repeated, tag = "2")]
    pub vectorsets: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct IndexParagraphs {
    /// id of the paragraph f"{self.rid}/{field_key}/{paragraph.start}-{paragraph.end}"
    #[prost(map = "string, message", tag = "1")]
    pub paragraphs: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        IndexParagraph,
    >,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Resource {
    #[prost(message, optional, tag = "1")]
    pub resource: ::core::option::Option<ResourceId>,
    #[prost(message, optional, tag = "2")]
    pub metadata: ::core::option::Option<IndexMetadata>,
    /// Doc index
    ///
    /// Tantivy doc filled by field allways full
    #[prost(map = "string, message", tag = "3")]
    pub texts: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        TextInformation,
    >,
    /// Document labels always serialized full
    #[prost(string, repeated, tag = "4")]
    pub labels: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Tantivy doc
    #[prost(enumeration = "resource::ResourceStatus", tag = "5")]
    pub status: i32,
    /// Paragraph
    ///
    /// Paragraphs by field
    #[prost(map = "string, message", tag = "6")]
    pub paragraphs: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        IndexParagraphs,
    >,
    #[prost(string, repeated, tag = "7")]
    pub paragraphs_to_delete: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(string, repeated, tag = "8")]
    pub sentences_to_delete: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// Relations
    #[prost(message, repeated, tag = "9")]
    pub relations: ::prost::alloc::vec::Vec<super::utils::Relation>,
    #[prost(string, tag = "11")]
    pub shard_id: ::prost::alloc::string::String,
    /// vectorset is the key
    #[prost(map = "string, message", tag = "12")]
    pub vectors: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        super::utils::UserVectors,
    >,
    /// Vectorset prefix vector id
    #[prost(map = "string, message", tag = "13")]
    pub vectors_to_delete: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        super::utils::UserVectorsList,
    >,
    #[prost(message, optional, tag = "14")]
    pub security: ::core::option::Option<super::utils::Security>,
}
/// Nested message and enum types in `Resource`.
pub mod resource {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum ResourceStatus {
        Processed = 0,
        Empty = 1,
        Error = 2,
        Delete = 3,
        Pending = 4,
        Blocked = 5,
        Expired = 6,
    }
    impl ResourceStatus {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                ResourceStatus::Processed => "PROCESSED",
                ResourceStatus::Empty => "EMPTY",
                ResourceStatus::Error => "ERROR",
                ResourceStatus::Delete => "DELETE",
                ResourceStatus::Pending => "PENDING",
                ResourceStatus::Blocked => "BLOCKED",
                ResourceStatus::Expired => "EXPIRED",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "PROCESSED" => Some(Self::Processed),
                "EMPTY" => Some(Self::Empty),
                "ERROR" => Some(Self::Error),
                "DELETE" => Some(Self::Delete),
                "PENDING" => Some(Self::Pending),
                "BLOCKED" => Some(Self::Blocked),
                "EXPIRED" => Some(Self::Expired),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ShardMetadata {
    #[prost(string, tag = "1")]
    pub kbid: ::prost::alloc::string::String,
    #[prost(enumeration = "super::utils::ReleaseChannel", tag = "2")]
    pub release_channel: i32,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct NodeMetadata {
    #[deprecated]
    #[prost(float, tag = "1")]
    pub load_score: f32,
    #[prost(uint64, tag = "2")]
    pub shard_count: u64,
    #[prost(map = "string, message", tag = "3")]
    pub shards: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        node_metadata::ShardMetadata,
    >,
    #[prost(string, tag = "4")]
    pub node_id: ::prost::alloc::string::String,
    #[prost(string, optional, tag = "5")]
    pub primary_node_id: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(uint64, tag = "6")]
    pub available_disk: u64,
    #[prost(uint64, tag = "7")]
    pub total_disk: u64,
}
/// Nested message and enum types in `NodeMetadata`.
pub mod node_metadata {
    #[allow(clippy::derive_partial_eq_without_eq)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct ShardMetadata {
        #[prost(string, tag = "1")]
        pub kbid: ::prost::alloc::string::String,
        #[deprecated]
        #[prost(float, tag = "2")]
        pub load_score: f32,
    }
}
