// This file is @generated by prost-build.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PrimaryShardReplicationState {
    #[prost(string, tag = "1")]
    pub shard_id: ::prost::alloc::string::String,
    /// ID to identify the generation of the shard to know
    /// if there is a new version of the shard available to download
    #[prost(string, tag = "2")]
    pub generation_id: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub kbid: ::prost::alloc::string::String,
    #[deprecated]
    #[prost(string, optional, tag = "4")]
    pub similarity: ::core::option::Option<::prost::alloc::string::String>,
    #[deprecated]
    #[prost(bool, optional, tag = "5")]
    pub normalize_vectors: ::core::option::Option<bool>,
    #[prost(enumeration = "super::utils::ReleaseChannel", tag = "6")]
    pub release_channel: i32,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SecondaryShardReplicationState {
    #[prost(string, tag = "1")]
    pub shard_id: ::prost::alloc::string::String,
    /// ID to identify the generation of the shard to know
    /// if there is a new version of the shard available to download
    #[prost(string, tag = "2")]
    pub generation_id: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SecondaryCheckReplicationStateRequest {
    #[prost(string, tag = "1")]
    pub secondary_id: ::prost::alloc::string::String,
    #[prost(message, repeated, tag = "2")]
    pub shard_states: ::prost::alloc::vec::Vec<SecondaryShardReplicationState>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct PrimaryCheckReplicationStateResponse {
    #[prost(message, repeated, tag = "1")]
    pub shard_states: ::prost::alloc::vec::Vec<PrimaryShardReplicationState>,
    #[prost(string, repeated, tag = "2")]
    pub shards_to_remove: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(string, tag = "3")]
    pub primary_id: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SegmentIds {
    #[prost(string, repeated, tag = "1")]
    pub items: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ReplicateShardRequest {
    #[prost(string, tag = "1")]
    pub shard_id: ::prost::alloc::string::String,
    /// list of existing segment ids so we replicate same shards again
    #[prost(map = "string, message", tag = "2")]
    pub existing_segment_ids: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        SegmentIds,
    >,
    #[prost(uint64, tag = "3")]
    pub chunk_size: u64,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ReplicateShardResponse {
    #[prost(string, tag = "1")]
    pub generation_id: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub filepath: ::prost::alloc::string::String,
    #[prost(bytes = "vec", tag = "3")]
    pub data: ::prost::alloc::vec::Vec<u8>,
    #[prost(uint32, tag = "4")]
    pub chunk: u32,
    #[prost(uint64, tag = "5")]
    pub read_position: u64,
    #[prost(uint64, tag = "6")]
    pub total_size: u64,
}
/// Generated client implementations.
pub mod replication_service_client {
    #![allow(unused_variables, dead_code, missing_docs, clippy::let_unit_value)]
    use tonic::codegen::*;
    use tonic::codegen::http::Uri;
    #[derive(Debug, Clone)]
    pub struct ReplicationServiceClient<T> {
        inner: tonic::client::Grpc<T>,
    }
    impl ReplicationServiceClient<tonic::transport::Channel> {
        /// Attempt to create a new client by connecting to a given endpoint.
        pub async fn connect<D>(dst: D) -> Result<Self, tonic::transport::Error>
        where
            D: TryInto<tonic::transport::Endpoint>,
            D::Error: Into<StdError>,
        {
            let conn = tonic::transport::Endpoint::new(dst)?.connect().await?;
            Ok(Self::new(conn))
        }
    }
    impl<T> ReplicationServiceClient<T>
    where
        T: tonic::client::GrpcService<tonic::body::BoxBody>,
        T::Error: Into<StdError>,
        T::ResponseBody: Body<Data = Bytes> + Send + 'static,
        <T::ResponseBody as Body>::Error: Into<StdError> + Send,
    {
        pub fn new(inner: T) -> Self {
            let inner = tonic::client::Grpc::new(inner);
            Self { inner }
        }
        pub fn with_origin(inner: T, origin: Uri) -> Self {
            let inner = tonic::client::Grpc::with_origin(inner, origin);
            Self { inner }
        }
        pub fn with_interceptor<F>(
            inner: T,
            interceptor: F,
        ) -> ReplicationServiceClient<InterceptedService<T, F>>
        where
            F: tonic::service::Interceptor,
            T::ResponseBody: Default,
            T: tonic::codegen::Service<
                http::Request<tonic::body::BoxBody>,
                Response = http::Response<
                    <T as tonic::client::GrpcService<tonic::body::BoxBody>>::ResponseBody,
                >,
            >,
            <T as tonic::codegen::Service<
                http::Request<tonic::body::BoxBody>,
            >>::Error: Into<StdError> + Send + Sync,
        {
            ReplicationServiceClient::new(InterceptedService::new(inner, interceptor))
        }
        /// Compress requests with the given encoding.
        ///
        /// This requires the server to support it otherwise it might respond with an
        /// error.
        #[must_use]
        pub fn send_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.send_compressed(encoding);
            self
        }
        /// Enable decompressing responses.
        #[must_use]
        pub fn accept_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.inner = self.inner.accept_compressed(encoding);
            self
        }
        /// Limits the maximum size of a decoded message.
        ///
        /// Default: `4MB`
        #[must_use]
        pub fn max_decoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_decoding_message_size(limit);
            self
        }
        /// Limits the maximum size of an encoded message.
        ///
        /// Default: `usize::MAX`
        #[must_use]
        pub fn max_encoding_message_size(mut self, limit: usize) -> Self {
            self.inner = self.inner.max_encoding_message_size(limit);
            self
        }
        /// Shard replication RPCs
        pub async fn check_replication_state(
            &mut self,
            request: impl tonic::IntoRequest<
                super::SecondaryCheckReplicationStateRequest,
            >,
        ) -> std::result::Result<
            tonic::Response<super::PrimaryCheckReplicationStateResponse>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/replication.ReplicationService/CheckReplicationState",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new(
                        "replication.ReplicationService",
                        "CheckReplicationState",
                    ),
                );
            self.inner.unary(req, path, codec).await
        }
        pub async fn replicate_shard(
            &mut self,
            request: impl tonic::IntoRequest<super::ReplicateShardRequest>,
        ) -> std::result::Result<
            tonic::Response<tonic::codec::Streaming<super::ReplicateShardResponse>>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/replication.ReplicationService/ReplicateShard",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new("replication.ReplicationService", "ReplicateShard"),
                );
            self.inner.server_streaming(req, path, codec).await
        }
        pub async fn get_metadata(
            &mut self,
            request: impl tonic::IntoRequest<super::super::noderesources::EmptyQuery>,
        ) -> std::result::Result<
            tonic::Response<super::super::noderesources::NodeMetadata>,
            tonic::Status,
        > {
            self.inner
                .ready()
                .await
                .map_err(|e| {
                    tonic::Status::new(
                        tonic::Code::Unknown,
                        format!("Service was not ready: {}", e.into()),
                    )
                })?;
            let codec = tonic::codec::ProstCodec::default();
            let path = http::uri::PathAndQuery::from_static(
                "/replication.ReplicationService/GetMetadata",
            );
            let mut req = request.into_request();
            req.extensions_mut()
                .insert(
                    GrpcMethod::new("replication.ReplicationService", "GetMetadata"),
                );
            self.inner.unary(req, path, codec).await
        }
    }
}
/// Generated server implementations.
pub mod replication_service_server {
    #![allow(unused_variables, dead_code, missing_docs, clippy::let_unit_value)]
    use tonic::codegen::*;
    /// Generated trait containing gRPC methods that should be implemented for use with ReplicationServiceServer.
    #[async_trait]
    pub trait ReplicationService: Send + Sync + 'static {
        /// Shard replication RPCs
        async fn check_replication_state(
            &self,
            request: tonic::Request<super::SecondaryCheckReplicationStateRequest>,
        ) -> std::result::Result<
            tonic::Response<super::PrimaryCheckReplicationStateResponse>,
            tonic::Status,
        >;
        /// Server streaming response type for the ReplicateShard method.
        type ReplicateShardStream: tonic::codegen::tokio_stream::Stream<
                Item = std::result::Result<super::ReplicateShardResponse, tonic::Status>,
            >
            + Send
            + 'static;
        async fn replicate_shard(
            &self,
            request: tonic::Request<super::ReplicateShardRequest>,
        ) -> std::result::Result<
            tonic::Response<Self::ReplicateShardStream>,
            tonic::Status,
        >;
        async fn get_metadata(
            &self,
            request: tonic::Request<super::super::noderesources::EmptyQuery>,
        ) -> std::result::Result<
            tonic::Response<super::super::noderesources::NodeMetadata>,
            tonic::Status,
        >;
    }
    #[derive(Debug)]
    pub struct ReplicationServiceServer<T: ReplicationService> {
        inner: _Inner<T>,
        accept_compression_encodings: EnabledCompressionEncodings,
        send_compression_encodings: EnabledCompressionEncodings,
        max_decoding_message_size: Option<usize>,
        max_encoding_message_size: Option<usize>,
    }
    struct _Inner<T>(Arc<T>);
    impl<T: ReplicationService> ReplicationServiceServer<T> {
        pub fn new(inner: T) -> Self {
            Self::from_arc(Arc::new(inner))
        }
        pub fn from_arc(inner: Arc<T>) -> Self {
            let inner = _Inner(inner);
            Self {
                inner,
                accept_compression_encodings: Default::default(),
                send_compression_encodings: Default::default(),
                max_decoding_message_size: None,
                max_encoding_message_size: None,
            }
        }
        pub fn with_interceptor<F>(
            inner: T,
            interceptor: F,
        ) -> InterceptedService<Self, F>
        where
            F: tonic::service::Interceptor,
        {
            InterceptedService::new(Self::new(inner), interceptor)
        }
        /// Enable decompressing requests with the given encoding.
        #[must_use]
        pub fn accept_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.accept_compression_encodings.enable(encoding);
            self
        }
        /// Compress responses with the given encoding, if the client supports it.
        #[must_use]
        pub fn send_compressed(mut self, encoding: CompressionEncoding) -> Self {
            self.send_compression_encodings.enable(encoding);
            self
        }
        /// Limits the maximum size of a decoded message.
        ///
        /// Default: `4MB`
        #[must_use]
        pub fn max_decoding_message_size(mut self, limit: usize) -> Self {
            self.max_decoding_message_size = Some(limit);
            self
        }
        /// Limits the maximum size of an encoded message.
        ///
        /// Default: `usize::MAX`
        #[must_use]
        pub fn max_encoding_message_size(mut self, limit: usize) -> Self {
            self.max_encoding_message_size = Some(limit);
            self
        }
    }
    impl<T, B> tonic::codegen::Service<http::Request<B>> for ReplicationServiceServer<T>
    where
        T: ReplicationService,
        B: Body + Send + 'static,
        B::Error: Into<StdError> + Send + 'static,
    {
        type Response = http::Response<tonic::body::BoxBody>;
        type Error = std::convert::Infallible;
        type Future = BoxFuture<Self::Response, Self::Error>;
        fn poll_ready(
            &mut self,
            _cx: &mut Context<'_>,
        ) -> Poll<std::result::Result<(), Self::Error>> {
            Poll::Ready(Ok(()))
        }
        fn call(&mut self, req: http::Request<B>) -> Self::Future {
            let inner = self.inner.clone();
            match req.uri().path() {
                "/replication.ReplicationService/CheckReplicationState" => {
                    #[allow(non_camel_case_types)]
                    struct CheckReplicationStateSvc<T: ReplicationService>(pub Arc<T>);
                    impl<
                        T: ReplicationService,
                    > tonic::server::UnaryService<
                        super::SecondaryCheckReplicationStateRequest,
                    > for CheckReplicationStateSvc<T> {
                        type Response = super::PrimaryCheckReplicationStateResponse;
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<
                                super::SecondaryCheckReplicationStateRequest,
                            >,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as ReplicationService>::check_replication_state(
                                        &inner,
                                        request,
                                    )
                                    .await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let inner = inner.0;
                        let method = CheckReplicationStateSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/replication.ReplicationService/ReplicateShard" => {
                    #[allow(non_camel_case_types)]
                    struct ReplicateShardSvc<T: ReplicationService>(pub Arc<T>);
                    impl<
                        T: ReplicationService,
                    > tonic::server::ServerStreamingService<super::ReplicateShardRequest>
                    for ReplicateShardSvc<T> {
                        type Response = super::ReplicateShardResponse;
                        type ResponseStream = T::ReplicateShardStream;
                        type Future = BoxFuture<
                            tonic::Response<Self::ResponseStream>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<super::ReplicateShardRequest>,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as ReplicationService>::replicate_shard(&inner, request)
                                    .await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let inner = inner.0;
                        let method = ReplicateShardSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.server_streaming(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                "/replication.ReplicationService/GetMetadata" => {
                    #[allow(non_camel_case_types)]
                    struct GetMetadataSvc<T: ReplicationService>(pub Arc<T>);
                    impl<
                        T: ReplicationService,
                    > tonic::server::UnaryService<
                        super::super::noderesources::EmptyQuery,
                    > for GetMetadataSvc<T> {
                        type Response = super::super::noderesources::NodeMetadata;
                        type Future = BoxFuture<
                            tonic::Response<Self::Response>,
                            tonic::Status,
                        >;
                        fn call(
                            &mut self,
                            request: tonic::Request<
                                super::super::noderesources::EmptyQuery,
                            >,
                        ) -> Self::Future {
                            let inner = Arc::clone(&self.0);
                            let fut = async move {
                                <T as ReplicationService>::get_metadata(&inner, request)
                                    .await
                            };
                            Box::pin(fut)
                        }
                    }
                    let accept_compression_encodings = self.accept_compression_encodings;
                    let send_compression_encodings = self.send_compression_encodings;
                    let max_decoding_message_size = self.max_decoding_message_size;
                    let max_encoding_message_size = self.max_encoding_message_size;
                    let inner = self.inner.clone();
                    let fut = async move {
                        let inner = inner.0;
                        let method = GetMetadataSvc(inner);
                        let codec = tonic::codec::ProstCodec::default();
                        let mut grpc = tonic::server::Grpc::new(codec)
                            .apply_compression_config(
                                accept_compression_encodings,
                                send_compression_encodings,
                            )
                            .apply_max_message_size_config(
                                max_decoding_message_size,
                                max_encoding_message_size,
                            );
                        let res = grpc.unary(method, req).await;
                        Ok(res)
                    };
                    Box::pin(fut)
                }
                _ => {
                    Box::pin(async move {
                        Ok(
                            http::Response::builder()
                                .status(200)
                                .header("grpc-status", "12")
                                .header("content-type", "application/grpc")
                                .body(empty_body())
                                .unwrap(),
                        )
                    })
                }
            }
        }
    }
    impl<T: ReplicationService> Clone for ReplicationServiceServer<T> {
        fn clone(&self) -> Self {
            let inner = self.inner.clone();
            Self {
                inner,
                accept_compression_encodings: self.accept_compression_encodings,
                send_compression_encodings: self.send_compression_encodings,
                max_decoding_message_size: self.max_decoding_message_size,
                max_encoding_message_size: self.max_encoding_message_size,
            }
        }
    }
    impl<T: ReplicationService> Clone for _Inner<T> {
        fn clone(&self) -> Self {
            Self(Arc::clone(&self.0))
        }
    }
    impl<T: std::fmt::Debug> std::fmt::Debug for _Inner<T> {
        fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
            write!(f, "{:?}", self.0)
        }
    }
    impl<T: ReplicationService> tonic::server::NamedService
    for ReplicationServiceServer<T> {
        const NAME: &'static str = "replication.ReplicationService";
    }
}
