// This file is @generated by prost-build.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Audit {
    #[prost(string, tag = "1")]
    pub user: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "2")]
    pub when: ::core::option::Option<::prost_types::Timestamp>,
    #[prost(string, tag = "3")]
    pub origin: ::prost::alloc::string::String,
    #[prost(enumeration = "audit::Source", tag = "4")]
    pub source: i32,
    #[prost(string, tag = "5")]
    pub kbid: ::prost::alloc::string::String,
    #[prost(string, tag = "6")]
    pub uuid: ::prost::alloc::string::String,
    #[prost(enumeration = "broker_message::MessageSource", tag = "7")]
    pub message_source: i32,
    #[prost(message, repeated, tag = "8")]
    pub field_metadata: ::prost::alloc::vec::Vec<super::resources::FieldId>,
    #[prost(message, repeated, tag = "9")]
    pub audit_fields: ::prost::alloc::vec::Vec<super::audit::AuditField>,
}
/// Nested message and enum types in `Audit`.
pub mod audit {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Source {
        Http = 0,
        Dashboard = 1,
        Desktop = 2,
    }
    impl Source {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Source::Http => "HTTP",
                Source::Dashboard => "DASHBOARD",
                Source::Desktop => "DESKTOP",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "HTTP" => Some(Self::Http),
                "DASHBOARD" => Some(Self::Dashboard),
                "DESKTOP" => Some(Self::Desktop),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Error {
    #[prost(string, tag = "1")]
    pub field: ::prost::alloc::string::String,
    #[prost(enumeration = "super::resources::FieldType", tag = "2")]
    pub field_type: i32,
    #[prost(string, tag = "3")]
    pub error: ::prost::alloc::string::String,
    #[prost(enumeration = "error::ErrorCode", tag = "4")]
    pub code: i32,
}
/// Nested message and enum types in `Error`.
pub mod error {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum ErrorCode {
        Generic = 0,
        Extract = 1,
        Process = 2,
        Dataaugmentation = 3,
    }
    impl ErrorCode {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                ErrorCode::Generic => "GENERIC",
                ErrorCode::Extract => "EXTRACT",
                ErrorCode::Process => "PROCESS",
                ErrorCode::Dataaugmentation => "DATAAUGMENTATION",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "GENERIC" => Some(Self::Generic),
                "EXTRACT" => Some(Self::Extract),
                "PROCESS" => Some(Self::Process),
                "DATAAUGMENTATION" => Some(Self::Dataaugmentation),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BrokerMessage {
    #[prost(string, tag = "1")]
    pub kbid: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub uuid: ::prost::alloc::string::String,
    #[prost(string, tag = "4")]
    pub slug: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "5")]
    pub audit: ::core::option::Option<Audit>,
    #[prost(enumeration = "broker_message::MessageType", tag = "6")]
    pub r#type: i32,
    #[prost(string, tag = "7")]
    pub multiid: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "8")]
    pub basic: ::core::option::Option<super::resources::Basic>,
    #[prost(message, optional, tag = "9")]
    pub origin: ::core::option::Option<super::resources::Origin>,
    #[prost(message, repeated, tag = "10")]
    pub relations: ::prost::alloc::vec::Vec<super::utils::Relation>,
    /// Field Conversations
    #[prost(map = "string, message", tag = "11")]
    pub conversations: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        super::resources::Conversation,
    >,
    /// Field Text
    #[prost(map = "string, message", tag = "13")]
    pub texts: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        super::resources::FieldText,
    >,
    /// Field Links
    #[prost(map = "string, message", tag = "16")]
    pub links: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        super::resources::FieldLink,
    >,
    /// Field File
    #[prost(map = "string, message", tag = "17")]
    pub files: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        super::resources::FieldFile,
    >,
    /// Link extracted extra info
    #[prost(message, repeated, tag = "18")]
    pub link_extracted_data: ::prost::alloc::vec::Vec<
        super::resources::LinkExtractedData,
    >,
    /// File extracted extra info
    #[prost(message, repeated, tag = "19")]
    pub file_extracted_data: ::prost::alloc::vec::Vec<
        super::resources::FileExtractedData,
    >,
    /// Field Extracted/Computed information
    #[prost(message, repeated, tag = "20")]
    pub extracted_text: ::prost::alloc::vec::Vec<super::resources::ExtractedTextWrapper>,
    #[prost(message, repeated, tag = "21")]
    pub field_metadata: ::prost::alloc::vec::Vec<
        super::resources::FieldComputedMetadataWrapper,
    >,
    #[prost(message, repeated, tag = "22")]
    pub field_vectors: ::prost::alloc::vec::Vec<
        super::resources::ExtractedVectorsWrapper,
    >,
    /// Resource Large Computed Metadata
    #[prost(message, repeated, tag = "23")]
    pub field_large_metadata: ::prost::alloc::vec::Vec<
        super::resources::LargeComputedMetadataWrapper,
    >,
    #[prost(message, repeated, tag = "24")]
    pub delete_fields: ::prost::alloc::vec::Vec<super::resources::FieldId>,
    #[prost(int32, tag = "25")]
    pub origin_seq: i32,
    #[prost(float, tag = "26")]
    pub slow_processing_time: f32,
    #[prost(float, tag = "28")]
    pub pre_processing_time: f32,
    #[prost(message, optional, tag = "29")]
    pub done_time: ::core::option::Option<::prost_types::Timestamp>,
    /// Not needed anymore
    #[deprecated]
    #[prost(int64, tag = "30")]
    pub txseqid: i64,
    #[prost(message, repeated, tag = "31")]
    pub errors: ::prost::alloc::vec::Vec<Error>,
    #[prost(string, tag = "32")]
    pub processing_id: ::prost::alloc::string::String,
    #[prost(enumeration = "broker_message::MessageSource", tag = "33")]
    pub source: i32,
    #[prost(int64, tag = "34")]
    pub account_seq: i64,
    #[prost(message, repeated, tag = "35")]
    pub user_vectors: ::prost::alloc::vec::Vec<super::resources::UserVectorsWrapper>,
    /// If true, force reindex all paragraphs in a resource
    #[prost(bool, tag = "36")]
    pub reindex: bool,
    #[prost(message, optional, tag = "37")]
    pub extra: ::core::option::Option<super::resources::Extra>,
    #[prost(message, repeated, tag = "38")]
    pub question_answers: ::prost::alloc::vec::Vec<
        super::resources::FieldQuestionAnswerWrapper,
    >,
    #[prost(message, optional, tag = "39")]
    pub security: ::core::option::Option<super::utils::Security>,
}
/// Nested message and enum types in `BrokerMessage`.
pub mod broker_message {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum MessageType {
        Autocommit = 0,
        Multi = 1,
        Commit = 2,
        Rollback = 3,
        Delete = 4,
    }
    impl MessageType {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                MessageType::Autocommit => "AUTOCOMMIT",
                MessageType::Multi => "MULTI",
                MessageType::Commit => "COMMIT",
                MessageType::Rollback => "ROLLBACK",
                MessageType::Delete => "DELETE",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "AUTOCOMMIT" => Some(Self::Autocommit),
                "MULTI" => Some(Self::Multi),
                "COMMIT" => Some(Self::Commit),
                "ROLLBACK" => Some(Self::Rollback),
                "DELETE" => Some(Self::Delete),
                _ => None,
            }
        }
    }
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum MessageSource {
        Writer = 0,
        Processor = 1,
    }
    impl MessageSource {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                MessageSource::Writer => "WRITER",
                MessageSource::Processor => "PROCESSOR",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "WRITER" => Some(Self::Writer),
                "PROCESSOR" => Some(Self::Processor),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct BrokerMessageBlobReference {
    #[prost(string, tag = "1")]
    pub kbid: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub uuid: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub storage_key: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct WriterStatusResponse {
    #[prost(string, repeated, tag = "1")]
    pub knowledgeboxes: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    /// map of last message processed
    #[prost(map = "string, int64", tag = "2")]
    pub msgid: ::std::collections::HashMap<::prost::alloc::string::String, i64>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct WriterStatusRequest {}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct NewEntitiesGroupRequest {
    #[prost(message, optional, tag = "1")]
    pub kb: ::core::option::Option<super::knowledgebox::KnowledgeBoxId>,
    #[prost(string, tag = "2")]
    pub group: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "3")]
    pub entities: ::core::option::Option<super::knowledgebox::EntitiesGroup>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct NewEntitiesGroupResponse {
    #[prost(enumeration = "new_entities_group_response::Status", tag = "1")]
    pub status: i32,
}
/// Nested message and enum types in `NewEntitiesGroupResponse`.
pub mod new_entities_group_response {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Status {
        Ok = 0,
        Error = 1,
        KbNotFound = 2,
        AlreadyExists = 3,
    }
    impl Status {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Status::Ok => "OK",
                Status::Error => "ERROR",
                Status::KbNotFound => "KB_NOT_FOUND",
                Status::AlreadyExists => "ALREADY_EXISTS",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "OK" => Some(Self::Ok),
                "ERROR" => Some(Self::Error),
                "KB_NOT_FOUND" => Some(Self::KbNotFound),
                "ALREADY_EXISTS" => Some(Self::AlreadyExists),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SetEntitiesRequest {
    #[prost(message, optional, tag = "1")]
    pub kb: ::core::option::Option<super::knowledgebox::KnowledgeBoxId>,
    #[prost(string, tag = "2")]
    pub group: ::prost::alloc::string::String,
    #[prost(message, optional, tag = "3")]
    pub entities: ::core::option::Option<super::knowledgebox::EntitiesGroup>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct UpdateEntitiesGroupRequest {
    #[prost(message, optional, tag = "1")]
    pub kb: ::core::option::Option<super::knowledgebox::KnowledgeBoxId>,
    #[prost(string, tag = "2")]
    pub group: ::prost::alloc::string::String,
    /// entity_id: Entity
    #[prost(map = "string, message", tag = "3")]
    pub add: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        super::knowledgebox::Entity,
    >,
    /// entity_id: Entity
    #[prost(map = "string, message", tag = "4")]
    pub update: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        super::knowledgebox::Entity,
    >,
    /// entity_id
    #[prost(string, repeated, tag = "5")]
    pub delete: ::prost::alloc::vec::Vec<::prost::alloc::string::String>,
    #[prost(string, tag = "6")]
    pub title: ::prost::alloc::string::String,
    #[prost(string, tag = "7")]
    pub color: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct UpdateEntitiesGroupResponse {
    #[prost(enumeration = "update_entities_group_response::Status", tag = "1")]
    pub status: i32,
}
/// Nested message and enum types in `UpdateEntitiesGroupResponse`.
pub mod update_entities_group_response {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Status {
        Ok = 0,
        Error = 1,
        KbNotFound = 2,
        EntitiesGroupNotFound = 3,
    }
    impl Status {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Status::Ok => "OK",
                Status::Error => "ERROR",
                Status::KbNotFound => "KB_NOT_FOUND",
                Status::EntitiesGroupNotFound => "ENTITIES_GROUP_NOT_FOUND",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "OK" => Some(Self::Ok),
                "ERROR" => Some(Self::Error),
                "KB_NOT_FOUND" => Some(Self::KbNotFound),
                "ENTITIES_GROUP_NOT_FOUND" => Some(Self::EntitiesGroupNotFound),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListEntitiesGroupsRequest {
    #[prost(message, optional, tag = "1")]
    pub kb: ::core::option::Option<super::knowledgebox::KnowledgeBoxId>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListEntitiesGroupsResponse {
    #[prost(map = "string, message", tag = "1")]
    pub groups: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        super::knowledgebox::EntitiesGroupSummary,
    >,
    #[prost(enumeration = "list_entities_groups_response::Status", tag = "2")]
    pub status: i32,
}
/// Nested message and enum types in `ListEntitiesGroupsResponse`.
pub mod list_entities_groups_response {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Status {
        Ok = 0,
        Notfound = 1,
        Error = 2,
    }
    impl Status {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Status::Ok => "OK",
                Status::Notfound => "NOTFOUND",
                Status::Error => "ERROR",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "OK" => Some(Self::Ok),
                "NOTFOUND" => Some(Self::Notfound),
                "ERROR" => Some(Self::Error),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetEntitiesRequest {
    #[prost(message, optional, tag = "1")]
    pub kb: ::core::option::Option<super::knowledgebox::KnowledgeBoxId>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetEntitiesResponse {
    #[prost(message, optional, tag = "1")]
    pub kb: ::core::option::Option<super::knowledgebox::KnowledgeBoxId>,
    #[prost(map = "string, message", tag = "2")]
    pub groups: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        super::knowledgebox::EntitiesGroup,
    >,
    #[prost(enumeration = "get_entities_response::Status", tag = "3")]
    pub status: i32,
}
/// Nested message and enum types in `GetEntitiesResponse`.
pub mod get_entities_response {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Status {
        Ok = 0,
        Notfound = 1,
        Error = 2,
    }
    impl Status {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Status::Ok => "OK",
                Status::Notfound => "NOTFOUND",
                Status::Error => "ERROR",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "OK" => Some(Self::Ok),
                "NOTFOUND" => Some(Self::Notfound),
                "ERROR" => Some(Self::Error),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DelEntitiesRequest {
    #[prost(message, optional, tag = "1")]
    pub kb: ::core::option::Option<super::knowledgebox::KnowledgeBoxId>,
    #[prost(string, tag = "2")]
    pub group: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct MergeEntitiesRequest {
    #[prost(message, optional, tag = "1")]
    pub kb: ::core::option::Option<super::knowledgebox::KnowledgeBoxId>,
    #[prost(message, optional, tag = "2")]
    pub from: ::core::option::Option<merge_entities_request::EntityId>,
    #[prost(message, optional, tag = "3")]
    pub to: ::core::option::Option<merge_entities_request::EntityId>,
}
/// Nested message and enum types in `MergeEntitiesRequest`.
pub mod merge_entities_request {
    #[allow(clippy::derive_partial_eq_without_eq)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct EntityId {
        #[prost(string, tag = "1")]
        pub group: ::prost::alloc::string::String,
        #[prost(string, tag = "2")]
        pub entity: ::prost::alloc::string::String,
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetLabelsResponse {
    #[prost(message, optional, tag = "1")]
    pub kb: ::core::option::Option<super::knowledgebox::KnowledgeBoxId>,
    #[prost(message, optional, tag = "2")]
    pub labels: ::core::option::Option<super::knowledgebox::Labels>,
    #[prost(enumeration = "get_labels_response::Status", tag = "3")]
    pub status: i32,
}
/// Nested message and enum types in `GetLabelsResponse`.
pub mod get_labels_response {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Status {
        Ok = 0,
        Notfound = 1,
    }
    impl Status {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Status::Ok => "OK",
                Status::Notfound => "NOTFOUND",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "OK" => Some(Self::Ok),
                "NOTFOUND" => Some(Self::Notfound),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetLabelsRequest {
    #[prost(message, optional, tag = "1")]
    pub kb: ::core::option::Option<super::knowledgebox::KnowledgeBoxId>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetEntitiesGroupRequest {
    #[prost(message, optional, tag = "1")]
    pub kb: ::core::option::Option<super::knowledgebox::KnowledgeBoxId>,
    #[prost(string, tag = "2")]
    pub group: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetEntitiesGroupResponse {
    #[prost(message, optional, tag = "1")]
    pub kb: ::core::option::Option<super::knowledgebox::KnowledgeBoxId>,
    #[prost(message, optional, tag = "2")]
    pub group: ::core::option::Option<super::knowledgebox::EntitiesGroup>,
    #[prost(enumeration = "get_entities_group_response::Status", tag = "3")]
    pub status: i32,
}
/// Nested message and enum types in `GetEntitiesGroupResponse`.
pub mod get_entities_group_response {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Status {
        Ok = 0,
        KbNotFound = 1,
        EntitiesGroupNotFound = 2,
        Error = 3,
    }
    impl Status {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Status::Ok => "OK",
                Status::KbNotFound => "KB_NOT_FOUND",
                Status::EntitiesGroupNotFound => "ENTITIES_GROUP_NOT_FOUND",
                Status::Error => "ERROR",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "OK" => Some(Self::Ok),
                "KB_NOT_FOUND" => Some(Self::KbNotFound),
                "ENTITIES_GROUP_NOT_FOUND" => Some(Self::EntitiesGroupNotFound),
                "ERROR" => Some(Self::Error),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetVectorSetsRequest {
    #[prost(message, optional, tag = "1")]
    pub kb: ::core::option::Option<super::knowledgebox::KnowledgeBoxId>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GetVectorSetsResponse {
    #[prost(message, optional, tag = "1")]
    pub kb: ::core::option::Option<super::knowledgebox::KnowledgeBoxId>,
    #[prost(message, optional, tag = "2")]
    pub vectorsets: ::core::option::Option<super::knowledgebox::VectorSets>,
    #[prost(enumeration = "get_vector_sets_response::Status", tag = "3")]
    pub status: i32,
}
/// Nested message and enum types in `GetVectorSetsResponse`.
pub mod get_vector_sets_response {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Status {
        Ok = 0,
        Notfound = 1,
        Error = 2,
    }
    impl Status {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Status::Ok => "OK",
                Status::Notfound => "NOTFOUND",
                Status::Error => "ERROR",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "OK" => Some(Self::Ok),
                "NOTFOUND" => Some(Self::Notfound),
                "ERROR" => Some(Self::Error),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct OpStatusWriter {
    #[prost(enumeration = "op_status_writer::Status", tag = "1")]
    pub status: i32,
}
/// Nested message and enum types in `OpStatusWriter`.
pub mod op_status_writer {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Status {
        Ok = 0,
        Error = 1,
        Notfound = 2,
    }
    impl Status {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Status::Ok => "OK",
                Status::Error => "ERROR",
                Status::Notfound => "NOTFOUND",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "OK" => Some(Self::Ok),
                "ERROR" => Some(Self::Error),
                "NOTFOUND" => Some(Self::Notfound),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Notification {
    #[prost(int32, tag = "1")]
    pub partition: i32,
    #[prost(string, tag = "2")]
    pub multi: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub uuid: ::prost::alloc::string::String,
    #[prost(string, tag = "4")]
    pub kbid: ::prost::alloc::string::String,
    #[prost(int64, tag = "5")]
    pub seqid: i64,
    #[prost(enumeration = "notification::Action", tag = "6")]
    pub action: i32,
    #[prost(enumeration = "notification::WriteType", tag = "7")]
    pub write_type: i32,
    #[deprecated]
    #[prost(message, optional, tag = "8")]
    pub message: ::core::option::Option<BrokerMessage>,
    #[prost(enumeration = "NotificationSource", tag = "9")]
    pub source: i32,
    #[prost(bool, tag = "10")]
    pub processing_errors: bool,
    #[prost(message, optional, tag = "11")]
    pub message_audit: ::core::option::Option<Audit>,
}
/// Nested message and enum types in `Notification`.
pub mod notification {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Action {
        Commit = 0,
        Abort = 1,
        Indexed = 2,
    }
    impl Action {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Action::Commit => "COMMIT",
                Action::Abort => "ABORT",
                Action::Indexed => "INDEXED",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "COMMIT" => Some(Self::Commit),
                "ABORT" => Some(Self::Abort),
                "INDEXED" => Some(Self::Indexed),
                _ => None,
            }
        }
    }
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum WriteType {
        Unset = 0,
        Created = 1,
        Modified = 2,
        Deleted = 3,
    }
    impl WriteType {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                WriteType::Unset => "UNSET",
                WriteType::Created => "CREATED",
                WriteType::Modified => "MODIFIED",
                WriteType::Deleted => "DELETED",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "UNSET" => Some(Self::Unset),
                "CREATED" => Some(Self::Created),
                "MODIFIED" => Some(Self::Modified),
                "DELETED" => Some(Self::Deleted),
                _ => None,
            }
        }
    }
}
/// The member information.
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Member {
    /// / Member ID.　A string of the UUID.
    #[prost(string, tag = "1")]
    pub id: ::prost::alloc::string::String,
    /// / Cluster listen address. string of IP and port number.
    /// / E.g. 127.0.0.1:5000
    #[prost(string, tag = "2")]
    pub listen_address: ::prost::alloc::string::String,
    /// / If true, it means self.
    #[deprecated]
    #[prost(bool, tag = "3")]
    pub is_self: bool,
    /// / Io, Ingest, Search, Train.
    #[deprecated]
    #[prost(enumeration = "member::Type", tag = "4")]
    pub r#type: i32,
    /// / Dummy Member
    #[deprecated]
    #[prost(bool, tag = "5")]
    pub dummy: bool,
    /// / The load score of the member.
    #[deprecated]
    #[prost(float, tag = "6")]
    pub load_score: f32,
    /// / The number of shards in the node.
    #[prost(uint32, tag = "7")]
    pub shard_count: u32,
    /// / The id of the primary node (if it is a secondary node).
    #[prost(string, tag = "8")]
    pub primary_id: ::prost::alloc::string::String,
}
/// Nested message and enum types in `Member`.
pub mod member {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Type {
        Io = 0,
        Search = 1,
        Ingest = 2,
        Train = 3,
        Unknown = 4,
    }
    impl Type {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Type::Io => "IO",
                Type::Search => "SEARCH",
                Type::Ingest => "INGEST",
                Type::Train => "TRAIN",
                Type::Unknown => "UNKNOWN",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "IO" => Some(Self::Io),
                "SEARCH" => Some(Self::Search),
                "INGEST" => Some(Self::Ingest),
                "TRAIN" => Some(Self::Train),
                "UNKNOWN" => Some(Self::Unknown),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListMembersRequest {}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ListMembersResponse {
    #[prost(message, repeated, tag = "1")]
    pub members: ::prost::alloc::vec::Vec<Member>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ShardReplica {
    #[prost(message, optional, tag = "1")]
    pub shard: ::core::option::Option<super::noderesources::ShardCreated>,
    #[prost(string, tag = "2")]
    pub node: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct ShardObject {
    #[prost(string, tag = "1")]
    pub shard: ::prost::alloc::string::String,
    #[prost(message, repeated, tag = "3")]
    pub replicas: ::prost::alloc::vec::Vec<ShardReplica>,
    #[deprecated]
    #[prost(message, optional, tag = "4")]
    pub timestamp: ::core::option::Option<::prost_types::Timestamp>,
    #[prost(bool, tag = "5")]
    pub read_only: bool,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Shards {
    #[prost(message, repeated, tag = "1")]
    pub shards: ::prost::alloc::vec::Vec<ShardObject>,
    #[prost(string, tag = "2")]
    pub kbid: ::prost::alloc::string::String,
    /// DEPRECATED a KB know can have multiple alive shards and is tracked in
    /// each ShardObject
    #[deprecated]
    #[prost(int32, tag = "3")]
    pub actual: i32,
    /// DEPRECATED in favor of `model` to include more data
    #[deprecated]
    #[prost(enumeration = "super::utils::VectorSimilarity", tag = "4")]
    pub similarity: i32,
    /// DEPRECATED: use vectorset configurations instead
    #[deprecated]
    #[prost(message, optional, tag = "5")]
    pub model: ::core::option::Option<super::knowledgebox::SemanticModelMetadata>,
    #[prost(enumeration = "super::utils::ReleaseChannel", tag = "6")]
    pub release_channel: i32,
    #[prost(map = "string, string", tag = "7")]
    pub extra: ::std::collections::HashMap<
        ::prost::alloc::string::String,
        ::prost::alloc::string::String,
    >,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct IndexResource {
    #[prost(string, tag = "1")]
    pub kbid: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub rid: ::prost::alloc::string::String,
    #[prost(bool, tag = "3")]
    pub reindex_vectors: bool,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct IndexStatus {}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct SynonymsRequest {
    #[prost(string, tag = "1")]
    pub kbid: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct NewVectorSetRequest {
    #[prost(string, tag = "1")]
    pub kbid: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub vectorset_id: ::prost::alloc::string::String,
    #[prost(enumeration = "super::nodewriter::VectorType", tag = "3")]
    pub vector_type: i32,
    #[prost(enumeration = "super::utils::VectorSimilarity", tag = "4")]
    pub similarity: i32,
    #[prost(uint32, tag = "5")]
    pub vector_dimension: u32,
    #[prost(bool, tag = "6")]
    pub normalize_vectors: bool,
    #[prost(uint32, repeated, tag = "7")]
    pub matryoshka_dimensions: ::prost::alloc::vec::Vec<u32>,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct NewVectorSetResponse {
    #[prost(enumeration = "new_vector_set_response::Status", tag = "1")]
    pub status: i32,
    #[prost(string, tag = "2")]
    pub details: ::prost::alloc::string::String,
}
/// Nested message and enum types in `NewVectorSetResponse`.
pub mod new_vector_set_response {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Status {
        Ok = 0,
        /// generic error
        Error = 1,
    }
    impl Status {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Status::Ok => "OK",
                Status::Error => "ERROR",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "OK" => Some(Self::Ok),
                "ERROR" => Some(Self::Error),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DelVectorSetRequest {
    #[prost(string, tag = "1")]
    pub kbid: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub vectorset_id: ::prost::alloc::string::String,
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct DelVectorSetResponse {
    #[prost(enumeration = "del_vector_set_response::Status", tag = "1")]
    pub status: i32,
    #[prost(string, tag = "2")]
    pub details: ::prost::alloc::string::String,
}
/// Nested message and enum types in `DelVectorSetResponse`.
pub mod del_vector_set_response {
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Status {
        Ok = 0,
        /// generic error
        Error = 1,
    }
    impl Status {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Status::Ok => "OK",
                Status::Error => "ERROR",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "OK" => Some(Self::Ok),
                "ERROR" => Some(Self::Error),
                _ => None,
            }
        }
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct NewKnowledgeBoxV2Request {
    #[prost(string, tag = "1")]
    pub kbid: ::prost::alloc::string::String,
    #[prost(string, tag = "2")]
    pub slug: ::prost::alloc::string::String,
    #[prost(string, tag = "3")]
    pub title: ::prost::alloc::string::String,
    #[prost(string, tag = "4")]
    pub description: ::prost::alloc::string::String,
    #[prost(message, repeated, tag = "5")]
    pub vectorsets: ::prost::alloc::vec::Vec<new_knowledge_box_v2_request::VectorSet>,
    #[prost(message, optional, tag = "6")]
    pub external_index_provider: ::core::option::Option<
        super::knowledgebox::CreateExternalIndexProviderMetadata,
    >,
}
/// Nested message and enum types in `NewKnowledgeBoxV2Request`.
pub mod new_knowledge_box_v2_request {
    #[allow(clippy::derive_partial_eq_without_eq)]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct VectorSet {
        #[prost(string, tag = "1")]
        pub vectorset_id: ::prost::alloc::string::String,
        #[prost(enumeration = "super::super::utils::VectorSimilarity", tag = "2")]
        pub similarity: i32,
        #[prost(uint32, tag = "3")]
        pub vector_dimension: u32,
        #[prost(uint32, repeated, tag = "4")]
        pub matryoshka_dimensions: ::prost::alloc::vec::Vec<u32>,
    }
}
#[allow(clippy::derive_partial_eq_without_eq)]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct NewKnowledgeBoxV2Response {
    #[prost(enumeration = "super::knowledgebox::KnowledgeBoxResponseStatus", tag = "1")]
    pub status: i32,
    #[prost(string, tag = "2")]
    pub error_message: ::prost::alloc::string::String,
}
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum NotificationSource {
    Unset = 0,
    Writer = 1,
    Processor = 2,
}
impl NotificationSource {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            NotificationSource::Unset => "UNSET",
            NotificationSource::Writer => "WRITER",
            NotificationSource::Processor => "PROCESSOR",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "UNSET" => Some(Self::Unset),
            "WRITER" => Some(Self::Writer),
            "PROCESSOR" => Some(Self::Processor),
            _ => None,
        }
    }
}
