def t_5_1(var=1):
    if var == 1:
        text = """1. Ряд совместных наблюдений независимых нормально распределенных случайных величин X и Y, описывающих некоторый финансовый показатель двух фирм, задан двумерной выборкой:
        {(-199.76, -175.45); (-219.72, -194.67);
        
        ALPHA_MEAN = 0.01  # Уровень значимости для теста средних
        APLHA_VARIANCE = 0.05  # Уровень значимости для теста дисперсий
        
        import pandas as pd
        import numpy as np
        from scipy.stats import pearsonr, ttest_ind, f
        
        raw_data = [(-195.996, -166.5), (-165.653, -176.5),]
        
        data = pd.DataFrame(raw_data, columns=["A", "B"])
        data = data.replace("NA", np.nan).dropna()
        
        correlation, _ = pearsonr(data["A"], data["B"])
        print(f"Коэффициент корреляции Пирсона: {correlation:.20f}")
        
        t_stat, p_value_ttest = ttest_ind(data["A"], data["B"], equal_var=False, alternative='less')
        print(f"P-значение (t-тест Уэлча): {p_value_ttest:.20f}")
              
        result_mean_test = int(p_value_ttest < ALPHA_MEAN)
        print(f"Результат теста средних (0.01): {result_mean_test}")
        
        var_a = np.var(data["A"], ddof=1)
        var_b = np.var(data["B"], ddof=1)
        df_a = len(data["A"]) - 1
        df_b = len(data["B"]) - 1
        
        if var_a > var_b:
            f_stat = var_a / var_b
            p_value_f_test = 2 * min(f.cdf(f_stat, df_a, df_b), 1 - f.cdf(f_stat, df_a, df_b))
        else:
            f_stat = var_b / var_a
            p_value_f_test = 2 * min(f.cdf(f_stat, df_b, df_a), 1 - f.cdf(f_stat, df_b, df_a))
        print(f"P-значение (F-тест): {p_value_f_test:.20f}")
    
    
        result_var_test = int(p_value_f_test < APLHA_VARIANCE)
        print(f"Результат теста дисперсий (0.05): {result_var_test}")
        """
    if var == 2:
        text = """2.  Ряд совместных наблюдений независимых нормально распределенных случайных величин X и Y, описывающих некоторый финансовый показатель двух фирм, задан двумерной выборкой:
        {(-199.76, -175.45); (-219.72, -194.67);
        
        import pandas as pd
        from scipy import stats
        import numpy as np
        
        # Исходная выборка
        data_str = '{198.286; 246.779; 220.085; 246.747; 214.803; 185.845; 209.192; 194.611; 223.919; 179.129; 241.656; 217.265; 238.67; 250.006; 225.551; 226.978; 262.953; 241.953; 200.382; NA; 266.493; NA; 233.95; 180.868; 253.236; 235.486; NA; 223.485; 225.608; 180.776; 230.832; NA; 242.484; NA; 259.269; 200.804; 235.55; 211.408; 221.178; 229.775; 196.07; 221.893; 209.508; 251.971; 254.245; 220.548; 175.281; NA; 172.483; 232.299; NA; 228.23; 277.53; 193.646; 247.37; 242.237; NA; NA; 242.954; 278.095; 234.742; 216.922; 225.755; 57.2405; 140.296; 238.569; 255.539; 170.147; 213.087; 229.516; 297.115; 273.482; 255.184; 185.724; 216.916; 202.413; NA; 235.694; 234.179; 239.29; 272.892; 236.044; NA; 240.263; 199.191; 218.775; 229.579; 240.038; 192.553; NA; 189.733; 241.403; 202.706; 217.216; 213.539; 240.704; 222.891; 215.884; 211.748; 260.592; 243.107; 240.035; 191.842; 202.566; 210.37; 240.33; 177.987; 233.764; NA; 215.709; 194.024; NA; 223.56; 257.854; 192.569; NA; 234.059; 155.986; 205.711; NA; NA; 259.806; 97.862; 182.802; 216.353; 205.137; 248.445; 238.745; 226.804; 194.76; 188.979; 229.207; 222.214; 192.763; 196.348; NA; 203.879; 271.33; 183.157; 212.574; 205.584; 254.658; 145.924; 195.409; 256.001; 230.169; 202.936; 210.81; 216.317; 213.131; 222.949; 256.825; NA; 227.547; 206.946; 232.581; 234.514; 175.117; 185.762; 255.691; 222.334; 196.2; 195.761; 171.926; 262.256; 202.426; 200.09; 228.395; 246.669; 221.124; 226.906; 216.429; 263.651; 273.584; 244.739; 285.954; 232.574; 233.865; 257.806; 210.293; 215.845; 302.455; 198.001; 221.902; 217.286; 185.88; 262.461; 211.151; NA; 261.396; 229.128; NA; NA; 195.706; 187.56; NA; 238.316; 228.829; 228.331; 208.74; 220.437; NA; 217.72; 247.387; 237.704; 211.762; 216.217; 213.477; 229.971; 276.73; 180.528; 225.489; NA; 188.22; 187.836; NA; 234.212; 216.675; 238.106; 214.522; 250.688; 210.679; 237.116; 241.973; 257.346; 218.164; 422.834; 226.132; 167.298; NA; 229.316; 217.998; NA; NA; NA; 188.544; 203.947; 229.518; 172.359; 267.258; 186.823; 257.03; 168.345; 220.994; 198.383; 258.824; 183.02; 217.693; 179.737; 247.245; 192.304; 222.699; NA; 169.048; 185.635; 170.57; 193.607; 234.985; 348.11975; 231.014; 263.825; 238.719; 226.256; 213.965; 184.118; NA; 234.439; 210.868; 250.131; 263.714; NA; 228.815; 229.22; NA; 242.121; 212.691; 167.771; 168.012; 185.691; NA; 271.901; 257.318; 205.598; 211.823; 254.038; 197.852; NA; 183.742; 227.084; 182.92}'
        data_list = list(map(lambda x: float(x) if x != 'NA' else None, data_str.replace('{', '').replace('}', '').split('; ')))
        df = pd.DataFrame(data_list, columns=['A'])
        
        
        # Количество пропущенных значений
        na_count = df['A'].isna().sum()
        print(f'Количество пропущенных значений: {na_count}')
        
        # Очищенная выборка без пропусков
        cleaned_data = df.dropna()['A']
        
        # Объем очищенной выборки
        n = len(cleaned_data)
        print(f'Объем очищенной выборки: {n}')
        
        # Среднее значение
        mean = cleaned_data.mean()
        print(f'Среднее значение: {mean}')
        
        # Стандартное отклонение (исправленное)
        std_dev = cleaned_data.std(ddof=1)
        print(f'Стандартное отклонение: {std_dev}')
        
        # Несмещенная дисперсия
        var = std_dev ** 2
        print(f'Несмещенная дисперсия: {var}')
        
        # Первая квартиль
        q1 = np.quantile(cleaned_data, 0.25)
        print(f'Первая квартиль: {q1}')
        
        # Третья квартиль
        q3 = np.quantile(cleaned_data, 0.75)
        print(f'Третья квартиль: {q3}')
        
        # Медиана
        median = np.median(cleaned_data)
        print(f'Медиана: {median}')
        
        # Максимальное значение
        max_val = cleaned_data.max()
        print(f'Максимальное значение: {max_val}')
        
        # Минимальное значение
        min_val = cleaned_data.min()
        print(f'Минимальное значение: {min_val}')
        
        # Размах выборки
        range_ = max_val - min_val
        print(f'Размах выборки: {range_}')
        
        # Эксцесс (по формуле Excel)
        kurtosis = stats.kurtosis(cleaned_data, bias=False)
        print(f'Эксцесс: {kurtosis}')
        
        # Коэффициент асимметрии (по формуле Excel)
        skewness = stats.skew(cleaned_data, bias=False)
        print(f'Коэффициент асимметрии: {skewness}')
        
        # Ошибка выборки
        sem = std_dev / np.sqrt(n)
        print(f'Ошибка выборки: {sem}')
        
        # Левая граница 0.95-доверительного интервала для E(X)
        left_ci_mean = mean - 1.96 * sem
        print(f'Левая граница 0.95-доверительного интервала для E(X): {left_ci_mean}')
        
        # Правая граница 0.95-доверительного интервала для E(X)
        right_ci_mean = mean + 1.96 * sem
        print(f'Правая граница 0.95-доверительного интервала для E(X): {right_ci_mean}')
        
        # Левая граница 0.95-доверительного интервала для Var(X)
        chi_left = n * var / stats.chi2.ppf(0.975, n-1)
        print(f'Левая граница 0.95-доверительного интервала для Var(X): {chi_left}')
        
        # Правая граница 0.95-доверительного интервала для Var(X)
        chi_right = n * var / stats.chi2.ppf(0.025, n-1)
        print(f'Правая граница 0.95-доверительного интервала для Var(X): {chi_right}')
        
        # Выбросы ниже нормы
        outliers_low = sum(cleaned_data < q1 - 1.5 * (q3 - q1))
        print(f'Выбросы ниже нормы: {outliers_low}')
        
        # Выбросы выше нормы
        outliers_high = sum(cleaned_data > q3 + 1.5 * (q3 - q1))
        print(f'Выбросы выше нормы: {outliers_high}')
        
        # Определяем выбросы
        Q1 = np.quantile(cleaned_data, 0.25)
        Q3 = np.quantile(cleaned_data, 0.75)
        IQR = Q3 - Q1
        lower_bound = Q1 - 1.5 * IQR
        upper_bound = Q3 + 1.5 * IQR
        no_outliers_data = cleaned_data[(cleaned_data >= lower_bound) & (cleaned_data <= upper_bound)]
        
        import matplotlib.pyplot as plt
        no_outliers_data.plot.hist()
        plt.show()
        no_outliers_data.plot.box()
        plt.show()
        """

    return text
