# Copyright (c) 2024, NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
#
# SPDX-License-Identifier: Apache-2.0
#
# This code was automatically generated across versions from 11.0.3 to 12.6.2. Do not modify it directly.

from libc.stdint cimport intptr_t

from .cycublas cimport *


###############################################################################
# Types
###############################################################################

ctypedef cublasHandle_t Handle
ctypedef cublasLogCallback Callback

ctypedef cudaStream_t Stream
ctypedef cudaDataType DataType
ctypedef libraryPropertyType_t LibraryPropertyType


###############################################################################
# Enum
###############################################################################

ctypedef cublasStatus_t _Status
ctypedef cublasFillMode_t _FillMode
ctypedef cublasDiagType_t _DiagType
ctypedef cublasSideMode_t _SideMode
ctypedef cublasOperation_t _Operation
ctypedef cublasPointerMode_t _PointerMode
ctypedef cublasAtomicsMode_t _AtomicsMode
ctypedef cublasGemmAlgo_t _GemmAlgo
ctypedef cublasMath_t _Math
ctypedef cublasComputeType_t _ComputeType


###############################################################################
# Functions
###############################################################################

cpdef intptr_t create() except? 0
cpdef destroy(intptr_t handle)
cpdef int get_version(intptr_t handle) except? -1
cpdef int get_property(int type) except? -1
cpdef size_t get_cudart_version() except? 0
cpdef set_workspace(intptr_t handle, intptr_t workspace, size_t workspace_size_in_bytes)
cpdef set_stream(intptr_t handle, intptr_t stream_id)
cpdef intptr_t get_stream(intptr_t handle) except? 0
cpdef int get_pointer_mode(intptr_t handle) except? -1
cpdef set_pointer_mode(intptr_t handle, int mode)
cpdef int get_atomics_mode(intptr_t handle) except? -1
cpdef set_atomics_mode(intptr_t handle, int mode)
cpdef int get_math_mode(intptr_t handle) except? -1
cpdef set_math_mode(intptr_t handle, int mode)
cpdef logger_configure(int log_is_on, int log_to_std_out, int log_to_std_err, log_file_name)
cpdef set_vector(int n, int elem_size, intptr_t x, int incx, intptr_t device_ptr, int incy)
cpdef get_vector(int n, int elem_size, intptr_t x, int incx, intptr_t y, int incy)
cpdef set_matrix(int rows, int cols, int elem_size, intptr_t a, int lda, intptr_t b, int ldb)
cpdef get_matrix(int rows, int cols, int elem_size, intptr_t a, int lda, intptr_t b, int ldb)
cpdef set_vector_async(int n, int elem_size, intptr_t host_ptr, int incx, intptr_t device_ptr, int incy, intptr_t stream)
cpdef get_vector_async(int n, int elem_size, intptr_t device_ptr, int incx, intptr_t host_ptr, int incy, intptr_t stream)
cpdef set_matrix_async(int rows, int cols, int elem_size, intptr_t a, int lda, intptr_t b, int ldb, intptr_t stream)
cpdef get_matrix_async(int rows, int cols, int elem_size, intptr_t a, int lda, intptr_t b, int ldb, intptr_t stream)
cpdef nrm2_ex(intptr_t handle, int n, intptr_t x, int x_type, int incx, intptr_t result, int result_type, int execution_type)
cpdef snrm2(intptr_t handle, int n, intptr_t x, int incx, intptr_t result)
cpdef dnrm2(intptr_t handle, int n, intptr_t x, int incx, intptr_t result)
cpdef scnrm2(intptr_t handle, int n, intptr_t x, int incx, intptr_t result)
cpdef dznrm2(intptr_t handle, int n, intptr_t x, int incx, intptr_t result)
cpdef dot_ex(intptr_t handle, int n, intptr_t x, int x_type, int incx, intptr_t y, int y_type, int incy, intptr_t result, int result_type, int execution_type)
cpdef dotc_ex(intptr_t handle, int n, intptr_t x, int x_type, int incx, intptr_t y, int y_type, int incy, intptr_t result, int result_type, int execution_type)
cpdef sdot(intptr_t handle, int n, intptr_t x, int incx, intptr_t y, int incy, intptr_t result)
cpdef ddot(intptr_t handle, int n, intptr_t x, int incx, intptr_t y, int incy, intptr_t result)
cpdef cdotu(intptr_t handle, int n, intptr_t x, int incx, intptr_t y, int incy, intptr_t result)
cpdef cdotc(intptr_t handle, int n, intptr_t x, int incx, intptr_t y, int incy, intptr_t result)
cpdef zdotu(intptr_t handle, int n, intptr_t x, int incx, intptr_t y, int incy, intptr_t result)
cpdef zdotc(intptr_t handle, int n, intptr_t x, int incx, intptr_t y, int incy, intptr_t result)
cpdef scal_ex(intptr_t handle, int n, intptr_t alpha, int alpha_type, intptr_t x, int x_type, int incx, int execution_type)
cpdef sscal(intptr_t handle, int n, intptr_t alpha, intptr_t x, int incx)
cpdef dscal(intptr_t handle, int n, intptr_t alpha, intptr_t x, int incx)
cpdef cscal(intptr_t handle, int n, intptr_t alpha, intptr_t x, int incx)
cpdef csscal(intptr_t handle, int n, intptr_t alpha, intptr_t x, int incx)
cpdef zscal(intptr_t handle, int n, intptr_t alpha, intptr_t x, int incx)
cpdef zdscal(intptr_t handle, int n, intptr_t alpha, intptr_t x, int incx)
cpdef axpy_ex(intptr_t handle, int n, intptr_t alpha, int alpha_type, intptr_t x, int x_type, int incx, intptr_t y, int y_type, int incy, int executiontype)
cpdef saxpy(intptr_t handle, int n, intptr_t alpha, intptr_t x, int incx, intptr_t y, int incy)
cpdef daxpy(intptr_t handle, int n, intptr_t alpha, intptr_t x, int incx, intptr_t y, int incy)
cpdef caxpy(intptr_t handle, int n, intptr_t alpha, intptr_t x, int incx, intptr_t y, int incy)
cpdef zaxpy(intptr_t handle, int n, intptr_t alpha, intptr_t x, int incx, intptr_t y, int incy)
cpdef copy_ex(intptr_t handle, int n, intptr_t x, int x_type, int incx, intptr_t y, int y_type, int incy)
cpdef scopy(intptr_t handle, int n, intptr_t x, int incx, intptr_t y, int incy)
cpdef dcopy(intptr_t handle, int n, intptr_t x, int incx, intptr_t y, int incy)
cpdef ccopy(intptr_t handle, int n, intptr_t x, int incx, intptr_t y, int incy)
cpdef zcopy(intptr_t handle, int n, intptr_t x, int incx, intptr_t y, int incy)
cpdef sswap(intptr_t handle, int n, intptr_t x, int incx, intptr_t y, int incy)
cpdef dswap(intptr_t handle, int n, intptr_t x, int incx, intptr_t y, int incy)
cpdef cswap(intptr_t handle, int n, intptr_t x, int incx, intptr_t y, int incy)
cpdef zswap(intptr_t handle, int n, intptr_t x, int incx, intptr_t y, int incy)
cpdef swap_ex(intptr_t handle, int n, intptr_t x, int x_type, int incx, intptr_t y, int y_type, int incy)
cpdef isamax(intptr_t handle, int n, intptr_t x, int incx, intptr_t result)
cpdef idamax(intptr_t handle, int n, intptr_t x, int incx, intptr_t result)
cpdef icamax(intptr_t handle, int n, intptr_t x, int incx, intptr_t result)
cpdef izamax(intptr_t handle, int n, intptr_t x, int incx, intptr_t result)
cpdef iamax_ex(intptr_t handle, int n, intptr_t x, int x_type, int incx, intptr_t result)
cpdef isamin(intptr_t handle, int n, intptr_t x, int incx, intptr_t result)
cpdef idamin(intptr_t handle, int n, intptr_t x, int incx, intptr_t result)
cpdef icamin(intptr_t handle, int n, intptr_t x, int incx, intptr_t result)
cpdef izamin(intptr_t handle, int n, intptr_t x, int incx, intptr_t result)
cpdef iamin_ex(intptr_t handle, int n, intptr_t x, int x_type, int incx, intptr_t result)
cpdef asum_ex(intptr_t handle, int n, intptr_t x, int x_type, int incx, intptr_t result, int result_type, int executiontype)
cpdef sasum(intptr_t handle, int n, intptr_t x, int incx, intptr_t result)
cpdef dasum(intptr_t handle, int n, intptr_t x, int incx, intptr_t result)
cpdef scasum(intptr_t handle, int n, intptr_t x, int incx, intptr_t result)
cpdef dzasum(intptr_t handle, int n, intptr_t x, int incx, intptr_t result)
cpdef srot(intptr_t handle, int n, intptr_t x, int incx, intptr_t y, int incy, intptr_t c, intptr_t s)
cpdef drot(intptr_t handle, int n, intptr_t x, int incx, intptr_t y, int incy, intptr_t c, intptr_t s)
cpdef crot(intptr_t handle, int n, intptr_t x, int incx, intptr_t y, int incy, intptr_t c, intptr_t s)
cpdef csrot(intptr_t handle, int n, intptr_t x, int incx, intptr_t y, int incy, intptr_t c, intptr_t s)
cpdef zrot(intptr_t handle, int n, intptr_t x, int incx, intptr_t y, int incy, intptr_t c, intptr_t s)
cpdef zdrot(intptr_t handle, int n, intptr_t x, int incx, intptr_t y, int incy, intptr_t c, intptr_t s)
cpdef rot_ex(intptr_t handle, int n, intptr_t x, int x_type, int incx, intptr_t y, int y_type, int incy, intptr_t c, intptr_t s, int cs_type, int executiontype)
cpdef srotg(intptr_t handle, intptr_t a, intptr_t b, intptr_t c, intptr_t s)
cpdef drotg(intptr_t handle, intptr_t a, intptr_t b, intptr_t c, intptr_t s)
cpdef crotg(intptr_t handle, intptr_t a, intptr_t b, intptr_t c, intptr_t s)
cpdef zrotg(intptr_t handle, intptr_t a, intptr_t b, intptr_t c, intptr_t s)
cpdef rotg_ex(intptr_t handle, intptr_t a, intptr_t b, int ab_type, intptr_t c, intptr_t s, int cs_type, int executiontype)
cpdef srotm(intptr_t handle, int n, intptr_t x, int incx, intptr_t y, int incy, intptr_t param)
cpdef drotm(intptr_t handle, int n, intptr_t x, int incx, intptr_t y, int incy, intptr_t param)
cpdef rotm_ex(intptr_t handle, int n, intptr_t x, int x_type, int incx, intptr_t y, int y_type, int incy, intptr_t param, int param_type, int executiontype)
cpdef srotmg(intptr_t handle, intptr_t d1, intptr_t d2, intptr_t x1, intptr_t y1, intptr_t param)
cpdef drotmg(intptr_t handle, intptr_t d1, intptr_t d2, intptr_t x1, intptr_t y1, intptr_t param)
cpdef rotmg_ex(intptr_t handle, intptr_t d1, int d1type, intptr_t d2, int d2type, intptr_t x1, int x1type, intptr_t y1, int y1type, intptr_t param, int param_type, int executiontype)
cpdef sgemv(intptr_t handle, int trans, int m, int n, intptr_t alpha, intptr_t a, int lda, intptr_t x, int incx, intptr_t beta, intptr_t y, int incy)
cpdef dgemv(intptr_t handle, int trans, int m, int n, intptr_t alpha, intptr_t a, int lda, intptr_t x, int incx, intptr_t beta, intptr_t y, int incy)
cpdef cgemv(intptr_t handle, int trans, int m, int n, intptr_t alpha, intptr_t a, int lda, intptr_t x, int incx, intptr_t beta, intptr_t y, int incy)
cpdef zgemv(intptr_t handle, int trans, int m, int n, intptr_t alpha, intptr_t a, int lda, intptr_t x, int incx, intptr_t beta, intptr_t y, int incy)
cpdef sgbmv(intptr_t handle, int trans, int m, int n, int kl, int ku, intptr_t alpha, intptr_t a, int lda, intptr_t x, int incx, intptr_t beta, intptr_t y, int incy)
cpdef dgbmv(intptr_t handle, int trans, int m, int n, int kl, int ku, intptr_t alpha, intptr_t a, int lda, intptr_t x, int incx, intptr_t beta, intptr_t y, int incy)
cpdef cgbmv(intptr_t handle, int trans, int m, int n, int kl, int ku, intptr_t alpha, intptr_t a, int lda, intptr_t x, int incx, intptr_t beta, intptr_t y, int incy)
cpdef zgbmv(intptr_t handle, int trans, int m, int n, int kl, int ku, intptr_t alpha, intptr_t a, int lda, intptr_t x, int incx, intptr_t beta, intptr_t y, int incy)
cpdef strmv(intptr_t handle, int uplo, int trans, int diag, int n, intptr_t a, int lda, intptr_t x, int incx)
cpdef dtrmv(intptr_t handle, int uplo, int trans, int diag, int n, intptr_t a, int lda, intptr_t x, int incx)
cpdef ctrmv(intptr_t handle, int uplo, int trans, int diag, int n, intptr_t a, int lda, intptr_t x, int incx)
cpdef ztrmv(intptr_t handle, int uplo, int trans, int diag, int n, intptr_t a, int lda, intptr_t x, int incx)
cpdef stbmv(intptr_t handle, int uplo, int trans, int diag, int n, int k, intptr_t a, int lda, intptr_t x, int incx)
cpdef dtbmv(intptr_t handle, int uplo, int trans, int diag, int n, int k, intptr_t a, int lda, intptr_t x, int incx)
cpdef ctbmv(intptr_t handle, int uplo, int trans, int diag, int n, int k, intptr_t a, int lda, intptr_t x, int incx)
cpdef ztbmv(intptr_t handle, int uplo, int trans, int diag, int n, int k, intptr_t a, int lda, intptr_t x, int incx)
cpdef stpmv(intptr_t handle, int uplo, int trans, int diag, int n, intptr_t ap, intptr_t x, int incx)
cpdef dtpmv(intptr_t handle, int uplo, int trans, int diag, int n, intptr_t ap, intptr_t x, int incx)
cpdef ctpmv(intptr_t handle, int uplo, int trans, int diag, int n, intptr_t ap, intptr_t x, int incx)
cpdef ztpmv(intptr_t handle, int uplo, int trans, int diag, int n, intptr_t ap, intptr_t x, int incx)
cpdef strsv(intptr_t handle, int uplo, int trans, int diag, int n, intptr_t a, int lda, intptr_t x, int incx)
cpdef dtrsv(intptr_t handle, int uplo, int trans, int diag, int n, intptr_t a, int lda, intptr_t x, int incx)
cpdef ctrsv(intptr_t handle, int uplo, int trans, int diag, int n, intptr_t a, int lda, intptr_t x, int incx)
cpdef ztrsv(intptr_t handle, int uplo, int trans, int diag, int n, intptr_t a, int lda, intptr_t x, int incx)
cpdef stpsv(intptr_t handle, int uplo, int trans, int diag, int n, intptr_t ap, intptr_t x, int incx)
cpdef dtpsv(intptr_t handle, int uplo, int trans, int diag, int n, intptr_t ap, intptr_t x, int incx)
cpdef ctpsv(intptr_t handle, int uplo, int trans, int diag, int n, intptr_t ap, intptr_t x, int incx)
cpdef ztpsv(intptr_t handle, int uplo, int trans, int diag, int n, intptr_t ap, intptr_t x, int incx)
cpdef stbsv(intptr_t handle, int uplo, int trans, int diag, int n, int k, intptr_t a, int lda, intptr_t x, int incx)
cpdef dtbsv(intptr_t handle, int uplo, int trans, int diag, int n, int k, intptr_t a, int lda, intptr_t x, int incx)
cpdef ctbsv(intptr_t handle, int uplo, int trans, int diag, int n, int k, intptr_t a, int lda, intptr_t x, int incx)
cpdef ztbsv(intptr_t handle, int uplo, int trans, int diag, int n, int k, intptr_t a, int lda, intptr_t x, int incx)
cpdef ssymv(intptr_t handle, int uplo, int n, intptr_t alpha, intptr_t a, int lda, intptr_t x, int incx, intptr_t beta, intptr_t y, int incy)
cpdef dsymv(intptr_t handle, int uplo, int n, intptr_t alpha, intptr_t a, int lda, intptr_t x, int incx, intptr_t beta, intptr_t y, int incy)
cpdef csymv(intptr_t handle, int uplo, int n, intptr_t alpha, intptr_t a, int lda, intptr_t x, int incx, intptr_t beta, intptr_t y, int incy)
cpdef zsymv(intptr_t handle, int uplo, int n, intptr_t alpha, intptr_t a, int lda, intptr_t x, int incx, intptr_t beta, intptr_t y, int incy)
cpdef chemv(intptr_t handle, int uplo, int n, intptr_t alpha, intptr_t a, int lda, intptr_t x, int incx, intptr_t beta, intptr_t y, int incy)
cpdef zhemv(intptr_t handle, int uplo, int n, intptr_t alpha, intptr_t a, int lda, intptr_t x, int incx, intptr_t beta, intptr_t y, int incy)
cpdef ssbmv(intptr_t handle, int uplo, int n, int k, intptr_t alpha, intptr_t a, int lda, intptr_t x, int incx, intptr_t beta, intptr_t y, int incy)
cpdef dsbmv(intptr_t handle, int uplo, int n, int k, intptr_t alpha, intptr_t a, int lda, intptr_t x, int incx, intptr_t beta, intptr_t y, int incy)
cpdef chbmv(intptr_t handle, int uplo, int n, int k, intptr_t alpha, intptr_t a, int lda, intptr_t x, int incx, intptr_t beta, intptr_t y, int incy)
cpdef zhbmv(intptr_t handle, int uplo, int n, int k, intptr_t alpha, intptr_t a, int lda, intptr_t x, int incx, intptr_t beta, intptr_t y, int incy)
cpdef sspmv(intptr_t handle, int uplo, int n, intptr_t alpha, intptr_t ap, intptr_t x, int incx, intptr_t beta, intptr_t y, int incy)
cpdef dspmv(intptr_t handle, int uplo, int n, intptr_t alpha, intptr_t ap, intptr_t x, int incx, intptr_t beta, intptr_t y, int incy)
cpdef chpmv(intptr_t handle, int uplo, int n, intptr_t alpha, intptr_t ap, intptr_t x, int incx, intptr_t beta, intptr_t y, int incy)
cpdef zhpmv(intptr_t handle, int uplo, int n, intptr_t alpha, intptr_t ap, intptr_t x, int incx, intptr_t beta, intptr_t y, int incy)
cpdef sger(intptr_t handle, int m, int n, intptr_t alpha, intptr_t x, int incx, intptr_t y, int incy, intptr_t a, int lda)
cpdef dger(intptr_t handle, int m, int n, intptr_t alpha, intptr_t x, int incx, intptr_t y, int incy, intptr_t a, int lda)
cpdef cgeru(intptr_t handle, int m, int n, intptr_t alpha, intptr_t x, int incx, intptr_t y, int incy, intptr_t a, int lda)
cpdef cgerc(intptr_t handle, int m, int n, intptr_t alpha, intptr_t x, int incx, intptr_t y, int incy, intptr_t a, int lda)
cpdef zgeru(intptr_t handle, int m, int n, intptr_t alpha, intptr_t x, int incx, intptr_t y, int incy, intptr_t a, int lda)
cpdef zgerc(intptr_t handle, int m, int n, intptr_t alpha, intptr_t x, int incx, intptr_t y, int incy, intptr_t a, int lda)
cpdef ssyr(intptr_t handle, int uplo, int n, intptr_t alpha, intptr_t x, int incx, intptr_t a, int lda)
cpdef dsyr(intptr_t handle, int uplo, int n, intptr_t alpha, intptr_t x, int incx, intptr_t a, int lda)
cpdef csyr(intptr_t handle, int uplo, int n, intptr_t alpha, intptr_t x, int incx, intptr_t a, int lda)
cpdef zsyr(intptr_t handle, int uplo, int n, intptr_t alpha, intptr_t x, int incx, intptr_t a, int lda)
cpdef cher(intptr_t handle, int uplo, int n, intptr_t alpha, intptr_t x, int incx, intptr_t a, int lda)
cpdef zher(intptr_t handle, int uplo, int n, intptr_t alpha, intptr_t x, int incx, intptr_t a, int lda)
cpdef sspr(intptr_t handle, int uplo, int n, intptr_t alpha, intptr_t x, int incx, intptr_t ap)
cpdef dspr(intptr_t handle, int uplo, int n, intptr_t alpha, intptr_t x, int incx, intptr_t ap)
cpdef chpr(intptr_t handle, int uplo, int n, intptr_t alpha, intptr_t x, int incx, intptr_t ap)
cpdef zhpr(intptr_t handle, int uplo, int n, intptr_t alpha, intptr_t x, int incx, intptr_t ap)
cpdef ssyr2(intptr_t handle, int uplo, int n, intptr_t alpha, intptr_t x, int incx, intptr_t y, int incy, intptr_t a, int lda)
cpdef dsyr2(intptr_t handle, int uplo, int n, intptr_t alpha, intptr_t x, int incx, intptr_t y, int incy, intptr_t a, int lda)
cpdef csyr2(intptr_t handle, int uplo, int n, intptr_t alpha, intptr_t x, int incx, intptr_t y, int incy, intptr_t a, int lda)
cpdef zsyr2(intptr_t handle, int uplo, int n, intptr_t alpha, intptr_t x, int incx, intptr_t y, int incy, intptr_t a, int lda)
cpdef cher2(intptr_t handle, int uplo, int n, intptr_t alpha, intptr_t x, int incx, intptr_t y, int incy, intptr_t a, int lda)
cpdef zher2(intptr_t handle, int uplo, int n, intptr_t alpha, intptr_t x, int incx, intptr_t y, int incy, intptr_t a, int lda)
cpdef sspr2(intptr_t handle, int uplo, int n, intptr_t alpha, intptr_t x, int incx, intptr_t y, int incy, intptr_t ap)
cpdef dspr2(intptr_t handle, int uplo, int n, intptr_t alpha, intptr_t x, int incx, intptr_t y, int incy, intptr_t ap)
cpdef chpr2(intptr_t handle, int uplo, int n, intptr_t alpha, intptr_t x, int incx, intptr_t y, int incy, intptr_t ap)
cpdef zhpr2(intptr_t handle, int uplo, int n, intptr_t alpha, intptr_t x, int incx, intptr_t y, int incy, intptr_t ap)
cpdef sgemm(intptr_t handle, int transa, int transb, int m, int n, int k, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb, intptr_t beta, intptr_t c, int ldc)
cpdef dgemm(intptr_t handle, int transa, int transb, int m, int n, int k, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb, intptr_t beta, intptr_t c, int ldc)
cpdef cgemm(intptr_t handle, int transa, int transb, int m, int n, int k, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb, intptr_t beta, intptr_t c, int ldc)
cpdef cgemm3m(intptr_t handle, int transa, int transb, int m, int n, int k, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb, intptr_t beta, intptr_t c, int ldc)
cpdef cgemm3m_ex(intptr_t handle, int transa, int transb, int m, int n, int k, intptr_t alpha, intptr_t a, int atype, int lda, intptr_t b, int btype, int ldb, intptr_t beta, intptr_t c, int ctype, int ldc)
cpdef zgemm(intptr_t handle, int transa, int transb, int m, int n, int k, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb, intptr_t beta, intptr_t c, int ldc)
cpdef zgemm3m(intptr_t handle, int transa, int transb, int m, int n, int k, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb, intptr_t beta, intptr_t c, int ldc)
cpdef sgemm_ex(intptr_t handle, int transa, int transb, int m, int n, int k, intptr_t alpha, intptr_t a, int atype, int lda, intptr_t b, int btype, int ldb, intptr_t beta, intptr_t c, int ctype, int ldc)
cpdef gemm_ex(intptr_t handle, int transa, int transb, int m, int n, int k, intptr_t alpha, intptr_t a, int atype, int lda, intptr_t b, int btype, int ldb, intptr_t beta, intptr_t c, int ctype, int ldc, int compute_type, int algo)
cpdef cgemm_ex(intptr_t handle, int transa, int transb, int m, int n, int k, intptr_t alpha, intptr_t a, int atype, int lda, intptr_t b, int btype, int ldb, intptr_t beta, intptr_t c, int ctype, int ldc)
cpdef uint8gemm_bias(intptr_t handle, int transa, int transb, int transc, int m, int n, int k, intptr_t a, int a_bias, int lda, intptr_t b, int b_bias, int ldb, intptr_t c, int c_bias, int ldc, int c_mult, int c_shift)
cpdef ssyrk(intptr_t handle, int uplo, int trans, int n, int k, intptr_t alpha, intptr_t a, int lda, intptr_t beta, intptr_t c, int ldc)
cpdef dsyrk(intptr_t handle, int uplo, int trans, int n, int k, intptr_t alpha, intptr_t a, int lda, intptr_t beta, intptr_t c, int ldc)
cpdef csyrk(intptr_t handle, int uplo, int trans, int n, int k, intptr_t alpha, intptr_t a, int lda, intptr_t beta, intptr_t c, int ldc)
cpdef zsyrk(intptr_t handle, int uplo, int trans, int n, int k, intptr_t alpha, intptr_t a, int lda, intptr_t beta, intptr_t c, int ldc)
cpdef csyrk_ex(intptr_t handle, int uplo, int trans, int n, int k, intptr_t alpha, intptr_t a, int atype, int lda, intptr_t beta, intptr_t c, int ctype, int ldc)
cpdef csyrk3m_ex(intptr_t handle, int uplo, int trans, int n, int k, intptr_t alpha, intptr_t a, int atype, int lda, intptr_t beta, intptr_t c, int ctype, int ldc)
cpdef cherk(intptr_t handle, int uplo, int trans, int n, int k, intptr_t alpha, intptr_t a, int lda, intptr_t beta, intptr_t c, int ldc)
cpdef zherk(intptr_t handle, int uplo, int trans, int n, int k, intptr_t alpha, intptr_t a, int lda, intptr_t beta, intptr_t c, int ldc)
cpdef cherk_ex(intptr_t handle, int uplo, int trans, int n, int k, intptr_t alpha, intptr_t a, int atype, int lda, intptr_t beta, intptr_t c, int ctype, int ldc)
cpdef cherk3m_ex(intptr_t handle, int uplo, int trans, int n, int k, intptr_t alpha, intptr_t a, int atype, int lda, intptr_t beta, intptr_t c, int ctype, int ldc)
cpdef ssyr2k(intptr_t handle, int uplo, int trans, int n, int k, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb, intptr_t beta, intptr_t c, int ldc)
cpdef dsyr2k(intptr_t handle, int uplo, int trans, int n, int k, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb, intptr_t beta, intptr_t c, int ldc)
cpdef csyr2k(intptr_t handle, int uplo, int trans, int n, int k, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb, intptr_t beta, intptr_t c, int ldc)
cpdef zsyr2k(intptr_t handle, int uplo, int trans, int n, int k, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb, intptr_t beta, intptr_t c, int ldc)
cpdef cher2k(intptr_t handle, int uplo, int trans, int n, int k, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb, intptr_t beta, intptr_t c, int ldc)
cpdef zher2k(intptr_t handle, int uplo, int trans, int n, int k, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb, intptr_t beta, intptr_t c, int ldc)
cpdef ssyrkx(intptr_t handle, int uplo, int trans, int n, int k, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb, intptr_t beta, intptr_t c, int ldc)
cpdef dsyrkx(intptr_t handle, int uplo, int trans, int n, int k, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb, intptr_t beta, intptr_t c, int ldc)
cpdef csyrkx(intptr_t handle, int uplo, int trans, int n, int k, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb, intptr_t beta, intptr_t c, int ldc)
cpdef zsyrkx(intptr_t handle, int uplo, int trans, int n, int k, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb, intptr_t beta, intptr_t c, int ldc)
cpdef cherkx(intptr_t handle, int uplo, int trans, int n, int k, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb, intptr_t beta, intptr_t c, int ldc)
cpdef zherkx(intptr_t handle, int uplo, int trans, int n, int k, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb, intptr_t beta, intptr_t c, int ldc)
cpdef ssymm(intptr_t handle, int side, int uplo, int m, int n, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb, intptr_t beta, intptr_t c, int ldc)
cpdef dsymm(intptr_t handle, int side, int uplo, int m, int n, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb, intptr_t beta, intptr_t c, int ldc)
cpdef csymm(intptr_t handle, int side, int uplo, int m, int n, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb, intptr_t beta, intptr_t c, int ldc)
cpdef zsymm(intptr_t handle, int side, int uplo, int m, int n, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb, intptr_t beta, intptr_t c, int ldc)
cpdef chemm(intptr_t handle, int side, int uplo, int m, int n, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb, intptr_t beta, intptr_t c, int ldc)
cpdef zhemm(intptr_t handle, int side, int uplo, int m, int n, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb, intptr_t beta, intptr_t c, int ldc)
cpdef strsm(intptr_t handle, int side, int uplo, int trans, int diag, int m, int n, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb)
cpdef dtrsm(intptr_t handle, int side, int uplo, int trans, int diag, int m, int n, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb)
cpdef ctrsm(intptr_t handle, int side, int uplo, int trans, int diag, int m, int n, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb)
cpdef ztrsm(intptr_t handle, int side, int uplo, int trans, int diag, int m, int n, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb)
cpdef strmm(intptr_t handle, int side, int uplo, int trans, int diag, int m, int n, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb, intptr_t c, int ldc)
cpdef dtrmm(intptr_t handle, int side, int uplo, int trans, int diag, int m, int n, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb, intptr_t c, int ldc)
cpdef ctrmm(intptr_t handle, int side, int uplo, int trans, int diag, int m, int n, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb, intptr_t c, int ldc)
cpdef ztrmm(intptr_t handle, int side, int uplo, int trans, int diag, int m, int n, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb, intptr_t c, int ldc)
cpdef sgemm_batched(intptr_t handle, int transa, int transb, int m, int n, int k, intptr_t alpha, intptr_t aarray, int lda, intptr_t barray, int ldb, intptr_t beta, intptr_t carray, int ldc, int batch_count)
cpdef dgemm_batched(intptr_t handle, int transa, int transb, int m, int n, int k, intptr_t alpha, intptr_t aarray, int lda, intptr_t barray, int ldb, intptr_t beta, intptr_t carray, int ldc, int batch_count)
cpdef cgemm_batched(intptr_t handle, int transa, int transb, int m, int n, int k, intptr_t alpha, intptr_t aarray, int lda, intptr_t barray, int ldb, intptr_t beta, intptr_t carray, int ldc, int batch_count)
cpdef cgemm3m_batched(intptr_t handle, int transa, int transb, int m, int n, int k, intptr_t alpha, intptr_t aarray, int lda, intptr_t barray, int ldb, intptr_t beta, intptr_t carray, int ldc, int batch_count)
cpdef zgemm_batched(intptr_t handle, int transa, int transb, int m, int n, int k, intptr_t alpha, intptr_t aarray, int lda, intptr_t barray, int ldb, intptr_t beta, intptr_t carray, int ldc, int batch_count)
cpdef gemm_batched_ex(intptr_t handle, int transa, int transb, int m, int n, int k, intptr_t alpha, intptr_t aarray, int atype, int lda, intptr_t barray, int btype, int ldb, intptr_t beta, intptr_t carray, int ctype, int ldc, int batch_count, int compute_type, int algo)
cpdef gemm_strided_batched_ex(intptr_t handle, int transa, int transb, int m, int n, int k, intptr_t alpha, intptr_t a, int atype, int lda, long long int stride_a, intptr_t b, int btype, int ldb, long long int stride_b, intptr_t beta, intptr_t c, int ctype, int ldc, long long int stride_c, int batch_count, int compute_type, int algo)
cpdef sgemm_strided_batched(intptr_t handle, int transa, int transb, int m, int n, int k, intptr_t alpha, intptr_t a, int lda, long long int stride_a, intptr_t b, int ldb, long long int stride_b, intptr_t beta, intptr_t c, int ldc, long long int stride_c, int batch_count)
cpdef dgemm_strided_batched(intptr_t handle, int transa, int transb, int m, int n, int k, intptr_t alpha, intptr_t a, int lda, long long int stride_a, intptr_t b, int ldb, long long int stride_b, intptr_t beta, intptr_t c, int ldc, long long int stride_c, int batch_count)
cpdef cgemm_strided_batched(intptr_t handle, int transa, int transb, int m, int n, int k, intptr_t alpha, intptr_t a, int lda, long long int stride_a, intptr_t b, int ldb, long long int stride_b, intptr_t beta, intptr_t c, int ldc, long long int stride_c, int batch_count)
cpdef cgemm3m_strided_batched(intptr_t handle, int transa, int transb, int m, int n, int k, intptr_t alpha, intptr_t a, int lda, long long int stride_a, intptr_t b, int ldb, long long int stride_b, intptr_t beta, intptr_t c, int ldc, long long int stride_c, int batch_count)
cpdef zgemm_strided_batched(intptr_t handle, int transa, int transb, int m, int n, int k, intptr_t alpha, intptr_t a, int lda, long long int stride_a, intptr_t b, int ldb, long long int stride_b, intptr_t beta, intptr_t c, int ldc, long long int stride_c, int batch_count)
cpdef sgeam(intptr_t handle, int transa, int transb, int m, int n, intptr_t alpha, intptr_t a, int lda, intptr_t beta, intptr_t b, int ldb, intptr_t c, int ldc)
cpdef dgeam(intptr_t handle, int transa, int transb, int m, int n, intptr_t alpha, intptr_t a, int lda, intptr_t beta, intptr_t b, int ldb, intptr_t c, int ldc)
cpdef cgeam(intptr_t handle, int transa, int transb, int m, int n, intptr_t alpha, intptr_t a, int lda, intptr_t beta, intptr_t b, int ldb, intptr_t c, int ldc)
cpdef zgeam(intptr_t handle, int transa, int transb, int m, int n, intptr_t alpha, intptr_t a, int lda, intptr_t beta, intptr_t b, int ldb, intptr_t c, int ldc)
cpdef sgetrf_batched(intptr_t handle, int n, intptr_t a, int lda, intptr_t p, intptr_t info, int batch_size)
cpdef dgetrf_batched(intptr_t handle, int n, intptr_t a, int lda, intptr_t p, intptr_t info, int batch_size)
cpdef cgetrf_batched(intptr_t handle, int n, intptr_t a, int lda, intptr_t p, intptr_t info, int batch_size)
cpdef zgetrf_batched(intptr_t handle, int n, intptr_t a, int lda, intptr_t p, intptr_t info, int batch_size)
cpdef sgetri_batched(intptr_t handle, int n, intptr_t a, int lda, intptr_t p, intptr_t c, int ldc, intptr_t info, int batch_size)
cpdef dgetri_batched(intptr_t handle, int n, intptr_t a, int lda, intptr_t p, intptr_t c, int ldc, intptr_t info, int batch_size)
cpdef cgetri_batched(intptr_t handle, int n, intptr_t a, int lda, intptr_t p, intptr_t c, int ldc, intptr_t info, int batch_size)
cpdef zgetri_batched(intptr_t handle, int n, intptr_t a, int lda, intptr_t p, intptr_t c, int ldc, intptr_t info, int batch_size)
cpdef sgetrs_batched(intptr_t handle, int trans, int n, int nrhs, intptr_t aarray, int lda, intptr_t dev_ipiv, intptr_t barray, int ldb, intptr_t info, int batch_size)
cpdef dgetrs_batched(intptr_t handle, int trans, int n, int nrhs, intptr_t aarray, int lda, intptr_t dev_ipiv, intptr_t barray, int ldb, intptr_t info, int batch_size)
cpdef cgetrs_batched(intptr_t handle, int trans, int n, int nrhs, intptr_t aarray, int lda, intptr_t dev_ipiv, intptr_t barray, int ldb, intptr_t info, int batch_size)
cpdef zgetrs_batched(intptr_t handle, int trans, int n, int nrhs, intptr_t aarray, int lda, intptr_t dev_ipiv, intptr_t barray, int ldb, intptr_t info, int batch_size)
cpdef strsm_batched(intptr_t handle, int side, int uplo, int trans, int diag, int m, int n, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb, int batch_count)
cpdef dtrsm_batched(intptr_t handle, int side, int uplo, int trans, int diag, int m, int n, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb, int batch_count)
cpdef ctrsm_batched(intptr_t handle, int side, int uplo, int trans, int diag, int m, int n, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb, int batch_count)
cpdef ztrsm_batched(intptr_t handle, int side, int uplo, int trans, int diag, int m, int n, intptr_t alpha, intptr_t a, int lda, intptr_t b, int ldb, int batch_count)
cpdef smatinv_batched(intptr_t handle, int n, intptr_t a, int lda, intptr_t ainv, int lda_inv, intptr_t info, int batch_size)
cpdef dmatinv_batched(intptr_t handle, int n, intptr_t a, int lda, intptr_t ainv, int lda_inv, intptr_t info, int batch_size)
cpdef cmatinv_batched(intptr_t handle, int n, intptr_t a, int lda, intptr_t ainv, int lda_inv, intptr_t info, int batch_size)
cpdef zmatinv_batched(intptr_t handle, int n, intptr_t a, int lda, intptr_t ainv, int lda_inv, intptr_t info, int batch_size)
cpdef sgeqrf_batched(intptr_t handle, int m, int n, intptr_t aarray, int lda, intptr_t tau_array, intptr_t info, int batch_size)
cpdef dgeqrf_batched(intptr_t handle, int m, int n, intptr_t aarray, int lda, intptr_t tau_array, intptr_t info, int batch_size)
cpdef cgeqrf_batched(intptr_t handle, int m, int n, intptr_t aarray, int lda, intptr_t tau_array, intptr_t info, int batch_size)
cpdef zgeqrf_batched(intptr_t handle, int m, int n, intptr_t aarray, int lda, intptr_t tau_array, intptr_t info, int batch_size)
cpdef sgels_batched(intptr_t handle, int trans, int m, int n, int nrhs, intptr_t aarray, int lda, intptr_t carray, int ldc, intptr_t info, intptr_t dev_info_array, int batch_size)
cpdef dgels_batched(intptr_t handle, int trans, int m, int n, int nrhs, intptr_t aarray, int lda, intptr_t carray, int ldc, intptr_t info, intptr_t dev_info_array, int batch_size)
cpdef cgels_batched(intptr_t handle, int trans, int m, int n, int nrhs, intptr_t aarray, int lda, intptr_t carray, int ldc, intptr_t info, intptr_t dev_info_array, int batch_size)
cpdef zgels_batched(intptr_t handle, int trans, int m, int n, int nrhs, intptr_t aarray, int lda, intptr_t carray, int ldc, intptr_t info, intptr_t dev_info_array, int batch_size)
cpdef sdgmm(intptr_t handle, int mode, int m, int n, intptr_t a, int lda, intptr_t x, int incx, intptr_t c, int ldc)
cpdef ddgmm(intptr_t handle, int mode, int m, int n, intptr_t a, int lda, intptr_t x, int incx, intptr_t c, int ldc)
cpdef cdgmm(intptr_t handle, int mode, int m, int n, intptr_t a, int lda, intptr_t x, int incx, intptr_t c, int ldc)
cpdef zdgmm(intptr_t handle, int mode, int m, int n, intptr_t a, int lda, intptr_t x, int incx, intptr_t c, int ldc)
cpdef stpttr(intptr_t handle, int uplo, int n, intptr_t ap, intptr_t a, int lda)
cpdef dtpttr(intptr_t handle, int uplo, int n, intptr_t ap, intptr_t a, int lda)
cpdef ctpttr(intptr_t handle, int uplo, int n, intptr_t ap, intptr_t a, int lda)
cpdef ztpttr(intptr_t handle, int uplo, int n, intptr_t ap, intptr_t a, int lda)
cpdef strttp(intptr_t handle, int uplo, int n, intptr_t a, int lda, intptr_t ap)
cpdef dtrttp(intptr_t handle, int uplo, int n, intptr_t a, int lda, intptr_t ap)
cpdef ctrttp(intptr_t handle, int uplo, int n, intptr_t a, int lda, intptr_t ap)
cpdef ztrttp(intptr_t handle, int uplo, int n, intptr_t a, int lda, intptr_t ap)
cpdef int get_sm_count_target(intptr_t handle) except? -1
cpdef set_sm_count_target(intptr_t handle, int sm_count_target)
cpdef str get_status_name(int status)
cpdef str get_status_string(int status)
cpdef sgemv_batched(intptr_t handle, int trans, int m, int n, intptr_t alpha, intptr_t aarray, int lda, intptr_t xarray, int incx, intptr_t beta, intptr_t yarray, int incy, int batch_count)
cpdef dgemv_batched(intptr_t handle, int trans, int m, int n, intptr_t alpha, intptr_t aarray, int lda, intptr_t xarray, int incx, intptr_t beta, intptr_t yarray, int incy, int batch_count)
cpdef cgemv_batched(intptr_t handle, int trans, int m, int n, intptr_t alpha, intptr_t aarray, int lda, intptr_t xarray, int incx, intptr_t beta, intptr_t yarray, int incy, int batch_count)
cpdef zgemv_batched(intptr_t handle, int trans, int m, int n, intptr_t alpha, intptr_t aarray, int lda, intptr_t xarray, int incx, intptr_t beta, intptr_t yarray, int incy, int batch_count)
cpdef sgemv_strided_batched(intptr_t handle, int trans, int m, int n, intptr_t alpha, intptr_t a, int lda, long long int stride_a, intptr_t x, int incx, long long int strid_ex, intptr_t beta, intptr_t y, int incy, long long int stridey, int batch_count)
cpdef dgemv_strided_batched(intptr_t handle, int trans, int m, int n, intptr_t alpha, intptr_t a, int lda, long long int stride_a, intptr_t x, int incx, long long int strid_ex, intptr_t beta, intptr_t y, int incy, long long int stridey, int batch_count)
cpdef cgemv_strided_batched(intptr_t handle, int trans, int m, int n, intptr_t alpha, intptr_t a, int lda, long long int stride_a, intptr_t x, int incx, long long int strid_ex, intptr_t beta, intptr_t y, int incy, long long int stridey, int batch_count)
cpdef zgemv_strided_batched(intptr_t handle, int trans, int m, int n, intptr_t alpha, intptr_t a, int lda, long long int stride_a, intptr_t x, int incx, long long int strid_ex, intptr_t beta, intptr_t y, int incy, long long int stridey, int batch_count)
cpdef set_vector_64(int64_t n, int64_t elem_size, intptr_t x, int64_t incx, intptr_t device_ptr, int64_t incy)
cpdef get_vector_64(int64_t n, int64_t elem_size, intptr_t x, int64_t incx, intptr_t y, int64_t incy)
cpdef set_matrix_64(int64_t rows, int64_t cols, int64_t elem_size, intptr_t a, int64_t lda, intptr_t b, int64_t ldb)
cpdef get_matrix_64(int64_t rows, int64_t cols, int64_t elem_size, intptr_t a, int64_t lda, intptr_t b, int64_t ldb)
cpdef set_vector_async_64(int64_t n, int64_t elem_size, intptr_t host_ptr, int64_t incx, intptr_t device_ptr, int64_t incy, intptr_t stream)
cpdef get_vector_async_64(int64_t n, int64_t elem_size, intptr_t device_ptr, int64_t incx, intptr_t host_ptr, int64_t incy, intptr_t stream)
cpdef set_matrix_async_64(int64_t rows, int64_t cols, int64_t elem_size, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, intptr_t stream)
cpdef get_matrix_async_64(int64_t rows, int64_t cols, int64_t elem_size, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, intptr_t stream)
cpdef nrm2ex_64(intptr_t handle, int64_t n, intptr_t x, int x_type, int64_t incx, intptr_t result, int result_type, int execution_type)
cpdef snrm2_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t result)
cpdef dnrm2_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t result)
cpdef scnrm2_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t result)
cpdef dznrm2_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t result)
cpdef dot_ex_64(intptr_t handle, int64_t n, intptr_t x, int x_type, int64_t incx, intptr_t y, int y_type, int64_t incy, intptr_t result, int result_type, int execution_type)
cpdef dotc_ex_64(intptr_t handle, int64_t n, intptr_t x, int x_type, int64_t incx, intptr_t y, int y_type, int64_t incy, intptr_t result, int result_type, int execution_type)
cpdef sdot_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t y, int64_t incy, intptr_t result)
cpdef ddot_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t y, int64_t incy, intptr_t result)
cpdef cdotu_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t y, int64_t incy, intptr_t result)
cpdef cdotc_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t y, int64_t incy, intptr_t result)
cpdef zdotu_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t y, int64_t incy, intptr_t result)
cpdef zdotc_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t y, int64_t incy, intptr_t result)
cpdef scal_ex_64(intptr_t handle, int64_t n, intptr_t alpha, int alpha_type, intptr_t x, int x_type, int64_t incx, int execution_type)
cpdef sscal_64(intptr_t handle, int64_t n, intptr_t alpha, intptr_t x, int64_t incx)
cpdef dscal_64(intptr_t handle, int64_t n, intptr_t alpha, intptr_t x, int64_t incx)
cpdef cscal_64(intptr_t handle, int64_t n, intptr_t alpha, intptr_t x, int64_t incx)
cpdef csscal_64(intptr_t handle, int64_t n, intptr_t alpha, intptr_t x, int64_t incx)
cpdef zscal_64(intptr_t handle, int64_t n, intptr_t alpha, intptr_t x, int64_t incx)
cpdef zdscal_64(intptr_t handle, int64_t n, intptr_t alpha, intptr_t x, int64_t incx)
cpdef axpy_ex_64(intptr_t handle, int64_t n, intptr_t alpha, int alpha_type, intptr_t x, int x_type, int64_t incx, intptr_t y, int y_type, int64_t incy, int executiontype)
cpdef saxpy_64(intptr_t handle, int64_t n, intptr_t alpha, intptr_t x, int64_t incx, intptr_t y, int64_t incy)
cpdef daxpy_64(intptr_t handle, int64_t n, intptr_t alpha, intptr_t x, int64_t incx, intptr_t y, int64_t incy)
cpdef caxpy_64(intptr_t handle, int64_t n, intptr_t alpha, intptr_t x, int64_t incx, intptr_t y, int64_t incy)
cpdef zaxpy_64(intptr_t handle, int64_t n, intptr_t alpha, intptr_t x, int64_t incx, intptr_t y, int64_t incy)
cpdef copy_ex_64(intptr_t handle, int64_t n, intptr_t x, int x_type, int64_t incx, intptr_t y, int y_type, int64_t incy)
cpdef scopy_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t y, int64_t incy)
cpdef dcopy_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t y, int64_t incy)
cpdef ccopy_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t y, int64_t incy)
cpdef zcopy_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t y, int64_t incy)
cpdef sswap_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t y, int64_t incy)
cpdef dswap_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t y, int64_t incy)
cpdef cswap_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t y, int64_t incy)
cpdef zswap_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t y, int64_t incy)
cpdef swap_ex_64(intptr_t handle, int64_t n, intptr_t x, int x_type, int64_t incx, intptr_t y, int y_type, int64_t incy)
cpdef isamax_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t result)
cpdef idamax_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t result)
cpdef icamax_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t result)
cpdef izamax_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t result)
cpdef iamax_ex_64(intptr_t handle, int64_t n, intptr_t x, int x_type, int64_t incx, intptr_t result)
cpdef isamin_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t result)
cpdef idamin_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t result)
cpdef icamin_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t result)
cpdef izamin_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t result)
cpdef iamin_ex_64(intptr_t handle, int64_t n, intptr_t x, int x_type, int64_t incx, intptr_t result)
cpdef asum_ex_64(intptr_t handle, int64_t n, intptr_t x, int x_type, int64_t incx, intptr_t result, int result_type, int executiontype)
cpdef sasum_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t result)
cpdef dasum_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t result)
cpdef scasum_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t result)
cpdef dzasum_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t result)
cpdef srot_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t y, int64_t incy, intptr_t c, intptr_t s)
cpdef drot_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t y, int64_t incy, intptr_t c, intptr_t s)
cpdef crot_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t y, int64_t incy, intptr_t c, intptr_t s)
cpdef csrot_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t y, int64_t incy, intptr_t c, intptr_t s)
cpdef zrot_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t y, int64_t incy, intptr_t c, intptr_t s)
cpdef zdrot_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t y, int64_t incy, intptr_t c, intptr_t s)
cpdef rot_ex_64(intptr_t handle, int64_t n, intptr_t x, int x_type, int64_t incx, intptr_t y, int y_type, int64_t incy, intptr_t c, intptr_t s, int cs_type, int executiontype)
cpdef srotm_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t y, int64_t incy, intptr_t param)
cpdef drotm_64(intptr_t handle, int64_t n, intptr_t x, int64_t incx, intptr_t y, int64_t incy, intptr_t param)
cpdef rotm_ex_64(intptr_t handle, int64_t n, intptr_t x, int x_type, int64_t incx, intptr_t y, int y_type, int64_t incy, intptr_t param, int param_type, int executiontype)
cpdef sgemv_64(intptr_t handle, int trans, int64_t m, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, intptr_t x, int64_t incx, intptr_t beta, intptr_t y, int64_t incy)
cpdef dgemv_64(intptr_t handle, int trans, int64_t m, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, intptr_t x, int64_t incx, intptr_t beta, intptr_t y, int64_t incy)
cpdef cgemv_64(intptr_t handle, int trans, int64_t m, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, intptr_t x, int64_t incx, intptr_t beta, intptr_t y, int64_t incy)
cpdef zgemv_64(intptr_t handle, int trans, int64_t m, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, intptr_t x, int64_t incx, intptr_t beta, intptr_t y, int64_t incy)
cpdef sgbmv_64(intptr_t handle, int trans, int64_t m, int64_t n, int64_t kl, int64_t ku, intptr_t alpha, intptr_t a, int64_t lda, intptr_t x, int64_t incx, intptr_t beta, intptr_t y, int64_t incy)
cpdef dgbmv_64(intptr_t handle, int trans, int64_t m, int64_t n, int64_t kl, int64_t ku, intptr_t alpha, intptr_t a, int64_t lda, intptr_t x, int64_t incx, intptr_t beta, intptr_t y, int64_t incy)
cpdef cgbmv_64(intptr_t handle, int trans, int64_t m, int64_t n, int64_t kl, int64_t ku, intptr_t alpha, intptr_t a, int64_t lda, intptr_t x, int64_t incx, intptr_t beta, intptr_t y, int64_t incy)
cpdef zgbmv_64(intptr_t handle, int trans, int64_t m, int64_t n, int64_t kl, int64_t ku, intptr_t alpha, intptr_t a, int64_t lda, intptr_t x, int64_t incx, intptr_t beta, intptr_t y, int64_t incy)
cpdef strmv_64(intptr_t handle, int uplo, int trans, int diag, int64_t n, intptr_t a, int64_t lda, intptr_t x, int64_t incx)
cpdef dtrmv_64(intptr_t handle, int uplo, int trans, int diag, int64_t n, intptr_t a, int64_t lda, intptr_t x, int64_t incx)
cpdef ctrmv_64(intptr_t handle, int uplo, int trans, int diag, int64_t n, intptr_t a, int64_t lda, intptr_t x, int64_t incx)
cpdef ztrmv_64(intptr_t handle, int uplo, int trans, int diag, int64_t n, intptr_t a, int64_t lda, intptr_t x, int64_t incx)
cpdef stbmv_64(intptr_t handle, int uplo, int trans, int diag, int64_t n, int64_t k, intptr_t a, int64_t lda, intptr_t x, int64_t incx)
cpdef dtbmv_64(intptr_t handle, int uplo, int trans, int diag, int64_t n, int64_t k, intptr_t a, int64_t lda, intptr_t x, int64_t incx)
cpdef ctbmv_64(intptr_t handle, int uplo, int trans, int diag, int64_t n, int64_t k, intptr_t a, int64_t lda, intptr_t x, int64_t incx)
cpdef ztbmv_64(intptr_t handle, int uplo, int trans, int diag, int64_t n, int64_t k, intptr_t a, int64_t lda, intptr_t x, int64_t incx)
cpdef stpmv_64(intptr_t handle, int uplo, int trans, int diag, int64_t n, intptr_t ap, intptr_t x, int64_t incx)
cpdef dtpmv_64(intptr_t handle, int uplo, int trans, int diag, int64_t n, intptr_t ap, intptr_t x, int64_t incx)
cpdef ctpmv_64(intptr_t handle, int uplo, int trans, int diag, int64_t n, intptr_t ap, intptr_t x, int64_t incx)
cpdef ztpmv_64(intptr_t handle, int uplo, int trans, int diag, int64_t n, intptr_t ap, intptr_t x, int64_t incx)
cpdef strsv_64(intptr_t handle, int uplo, int trans, int diag, int64_t n, intptr_t a, int64_t lda, intptr_t x, int64_t incx)
cpdef dtrsv_64(intptr_t handle, int uplo, int trans, int diag, int64_t n, intptr_t a, int64_t lda, intptr_t x, int64_t incx)
cpdef ctrsv_64(intptr_t handle, int uplo, int trans, int diag, int64_t n, intptr_t a, int64_t lda, intptr_t x, int64_t incx)
cpdef ztrsv_64(intptr_t handle, int uplo, int trans, int diag, int64_t n, intptr_t a, int64_t lda, intptr_t x, int64_t incx)
cpdef stpsv_64(intptr_t handle, int uplo, int trans, int diag, int64_t n, intptr_t ap, intptr_t x, int64_t incx)
cpdef dtpsv_64(intptr_t handle, int uplo, int trans, int diag, int64_t n, intptr_t ap, intptr_t x, int64_t incx)
cpdef ctpsv_64(intptr_t handle, int uplo, int trans, int diag, int64_t n, intptr_t ap, intptr_t x, int64_t incx)
cpdef ztpsv_64(intptr_t handle, int uplo, int trans, int diag, int64_t n, intptr_t ap, intptr_t x, int64_t incx)
cpdef stbsv_64(intptr_t handle, int uplo, int trans, int diag, int64_t n, int64_t k, intptr_t a, int64_t lda, intptr_t x, int64_t incx)
cpdef dtbsv_64(intptr_t handle, int uplo, int trans, int diag, int64_t n, int64_t k, intptr_t a, int64_t lda, intptr_t x, int64_t incx)
cpdef ctbsv_64(intptr_t handle, int uplo, int trans, int diag, int64_t n, int64_t k, intptr_t a, int64_t lda, intptr_t x, int64_t incx)
cpdef ztbsv_64(intptr_t handle, int uplo, int trans, int diag, int64_t n, int64_t k, intptr_t a, int64_t lda, intptr_t x, int64_t incx)
cpdef ssymv_64(intptr_t handle, int uplo, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, intptr_t x, int64_t incx, intptr_t beta, intptr_t y, int64_t incy)
cpdef dsymv_64(intptr_t handle, int uplo, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, intptr_t x, int64_t incx, intptr_t beta, intptr_t y, int64_t incy)
cpdef csymv_64(intptr_t handle, int uplo, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, intptr_t x, int64_t incx, intptr_t beta, intptr_t y, int64_t incy)
cpdef zsymv_64(intptr_t handle, int uplo, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, intptr_t x, int64_t incx, intptr_t beta, intptr_t y, int64_t incy)
cpdef chemv_64(intptr_t handle, int uplo, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, intptr_t x, int64_t incx, intptr_t beta, intptr_t y, int64_t incy)
cpdef zhemv_64(intptr_t handle, int uplo, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, intptr_t x, int64_t incx, intptr_t beta, intptr_t y, int64_t incy)
cpdef ssbmv_64(intptr_t handle, int uplo, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, intptr_t x, int64_t incx, intptr_t beta, intptr_t y, int64_t incy)
cpdef dsbmv_64(intptr_t handle, int uplo, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, intptr_t x, int64_t incx, intptr_t beta, intptr_t y, int64_t incy)
cpdef chbmv_64(intptr_t handle, int uplo, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, intptr_t x, int64_t incx, intptr_t beta, intptr_t y, int64_t incy)
cpdef zhbmv_64(intptr_t handle, int uplo, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, intptr_t x, int64_t incx, intptr_t beta, intptr_t y, int64_t incy)
cpdef sspmv_64(intptr_t handle, int uplo, int64_t n, intptr_t alpha, intptr_t ap, intptr_t x, int64_t incx, intptr_t beta, intptr_t y, int64_t incy)
cpdef dspmv_64(intptr_t handle, int uplo, int64_t n, intptr_t alpha, intptr_t ap, intptr_t x, int64_t incx, intptr_t beta, intptr_t y, int64_t incy)
cpdef chpmv_64(intptr_t handle, int uplo, int64_t n, intptr_t alpha, intptr_t ap, intptr_t x, int64_t incx, intptr_t beta, intptr_t y, int64_t incy)
cpdef zhpmv_64(intptr_t handle, int uplo, int64_t n, intptr_t alpha, intptr_t ap, intptr_t x, int64_t incx, intptr_t beta, intptr_t y, int64_t incy)
cpdef sger_64(intptr_t handle, int64_t m, int64_t n, intptr_t alpha, intptr_t x, int64_t incx, intptr_t y, int64_t incy, intptr_t a, int64_t lda)
cpdef dger_64(intptr_t handle, int64_t m, int64_t n, intptr_t alpha, intptr_t x, int64_t incx, intptr_t y, int64_t incy, intptr_t a, int64_t lda)
cpdef cgeru_64(intptr_t handle, int64_t m, int64_t n, intptr_t alpha, intptr_t x, int64_t incx, intptr_t y, int64_t incy, intptr_t a, int64_t lda)
cpdef cgerc_64(intptr_t handle, int64_t m, int64_t n, intptr_t alpha, intptr_t x, int64_t incx, intptr_t y, int64_t incy, intptr_t a, int64_t lda)
cpdef zgeru_64(intptr_t handle, int64_t m, int64_t n, intptr_t alpha, intptr_t x, int64_t incx, intptr_t y, int64_t incy, intptr_t a, int64_t lda)
cpdef zgerc_64(intptr_t handle, int64_t m, int64_t n, intptr_t alpha, intptr_t x, int64_t incx, intptr_t y, int64_t incy, intptr_t a, int64_t lda)
cpdef ssyr_64(intptr_t handle, int uplo, int64_t n, intptr_t alpha, intptr_t x, int64_t incx, intptr_t a, int64_t lda)
cpdef dsyr_64(intptr_t handle, int uplo, int64_t n, intptr_t alpha, intptr_t x, int64_t incx, intptr_t a, int64_t lda)
cpdef csyr_64(intptr_t handle, int uplo, int64_t n, intptr_t alpha, intptr_t x, int64_t incx, intptr_t a, int64_t lda)
cpdef zsyr_64(intptr_t handle, int uplo, int64_t n, intptr_t alpha, intptr_t x, int64_t incx, intptr_t a, int64_t lda)
cpdef cher_64(intptr_t handle, int uplo, int64_t n, intptr_t alpha, intptr_t x, int64_t incx, intptr_t a, int64_t lda)
cpdef zher_64(intptr_t handle, int uplo, int64_t n, intptr_t alpha, intptr_t x, int64_t incx, intptr_t a, int64_t lda)
cpdef sspr_64(intptr_t handle, int uplo, int64_t n, intptr_t alpha, intptr_t x, int64_t incx, intptr_t ap)
cpdef dspr_64(intptr_t handle, int uplo, int64_t n, intptr_t alpha, intptr_t x, int64_t incx, intptr_t ap)
cpdef chpr_64(intptr_t handle, int uplo, int64_t n, intptr_t alpha, intptr_t x, int64_t incx, intptr_t ap)
cpdef zhpr_64(intptr_t handle, int uplo, int64_t n, intptr_t alpha, intptr_t x, int64_t incx, intptr_t ap)
cpdef ssyr2_64(intptr_t handle, int uplo, int64_t n, intptr_t alpha, intptr_t x, int64_t incx, intptr_t y, int64_t incy, intptr_t a, int64_t lda)
cpdef dsyr2_64(intptr_t handle, int uplo, int64_t n, intptr_t alpha, intptr_t x, int64_t incx, intptr_t y, int64_t incy, intptr_t a, int64_t lda)
cpdef csyr2_64(intptr_t handle, int uplo, int64_t n, intptr_t alpha, intptr_t x, int64_t incx, intptr_t y, int64_t incy, intptr_t a, int64_t lda)
cpdef zsyr2_64(intptr_t handle, int uplo, int64_t n, intptr_t alpha, intptr_t x, int64_t incx, intptr_t y, int64_t incy, intptr_t a, int64_t lda)
cpdef cher2_64(intptr_t handle, int uplo, int64_t n, intptr_t alpha, intptr_t x, int64_t incx, intptr_t y, int64_t incy, intptr_t a, int64_t lda)
cpdef zher2_64(intptr_t handle, int uplo, int64_t n, intptr_t alpha, intptr_t x, int64_t incx, intptr_t y, int64_t incy, intptr_t a, int64_t lda)
cpdef sspr2_64(intptr_t handle, int uplo, int64_t n, intptr_t alpha, intptr_t x, int64_t incx, intptr_t y, int64_t incy, intptr_t ap)
cpdef dspr2_64(intptr_t handle, int uplo, int64_t n, intptr_t alpha, intptr_t x, int64_t incx, intptr_t y, int64_t incy, intptr_t ap)
cpdef chpr2_64(intptr_t handle, int uplo, int64_t n, intptr_t alpha, intptr_t x, int64_t incx, intptr_t y, int64_t incy, intptr_t ap)
cpdef zhpr2_64(intptr_t handle, int uplo, int64_t n, intptr_t alpha, intptr_t x, int64_t incx, intptr_t y, int64_t incy, intptr_t ap)
cpdef sgemv_batched_64(intptr_t handle, int trans, int64_t m, int64_t n, intptr_t alpha, intptr_t aarray, int64_t lda, intptr_t xarray, int64_t incx, intptr_t beta, intptr_t yarray, int64_t incy, int64_t batch_count)
cpdef dgemv_batched_64(intptr_t handle, int trans, int64_t m, int64_t n, intptr_t alpha, intptr_t aarray, int64_t lda, intptr_t xarray, int64_t incx, intptr_t beta, intptr_t yarray, int64_t incy, int64_t batch_count)
cpdef cgemv_batched_64(intptr_t handle, int trans, int64_t m, int64_t n, intptr_t alpha, intptr_t aarray, int64_t lda, intptr_t xarray, int64_t incx, intptr_t beta, intptr_t yarray, int64_t incy, int64_t batch_count)
cpdef zgemv_batched_64(intptr_t handle, int trans, int64_t m, int64_t n, intptr_t alpha, intptr_t aarray, int64_t lda, intptr_t xarray, int64_t incx, intptr_t beta, intptr_t yarray, int64_t incy, int64_t batch_count)
cpdef sgemv_strided_batched_64(intptr_t handle, int trans, int64_t m, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, long long int stride_a, intptr_t x, int64_t incx, long long int strid_ex, intptr_t beta, intptr_t y, int64_t incy, long long int stridey, int64_t batch_count)
cpdef dgemv_strided_batched_64(intptr_t handle, int trans, int64_t m, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, long long int stride_a, intptr_t x, int64_t incx, long long int strid_ex, intptr_t beta, intptr_t y, int64_t incy, long long int stridey, int64_t batch_count)
cpdef cgemv_strided_batched_64(intptr_t handle, int trans, int64_t m, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, long long int stride_a, intptr_t x, int64_t incx, long long int strid_ex, intptr_t beta, intptr_t y, int64_t incy, long long int stridey, int64_t batch_count)
cpdef zgemv_strided_batched_64(intptr_t handle, int trans, int64_t m, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, long long int stride_a, intptr_t x, int64_t incx, long long int strid_ex, intptr_t beta, intptr_t y, int64_t incy, long long int stridey, int64_t batch_count)
cpdef sgemm_64(intptr_t handle, int transa, int transb, int64_t m, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, intptr_t beta, intptr_t c, int64_t ldc)
cpdef dgemm_64(intptr_t handle, int transa, int transb, int64_t m, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, intptr_t beta, intptr_t c, int64_t ldc)
cpdef cgemm_64(intptr_t handle, int transa, int transb, int64_t m, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, intptr_t beta, intptr_t c, int64_t ldc)
cpdef cgemm3m_64(intptr_t handle, int transa, int transb, int64_t m, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, intptr_t beta, intptr_t c, int64_t ldc)
cpdef cgemm3m_ex_64(intptr_t handle, int transa, int transb, int64_t m, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int atype, int64_t lda, intptr_t b, int btype, int64_t ldb, intptr_t beta, intptr_t c, int ctype, int64_t ldc)
cpdef zgemm_64(intptr_t handle, int transa, int transb, int64_t m, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, intptr_t beta, intptr_t c, int64_t ldc)
cpdef zgemm3m_64(intptr_t handle, int transa, int transb, int64_t m, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, intptr_t beta, intptr_t c, int64_t ldc)
cpdef sgemm_ex_64(intptr_t handle, int transa, int transb, int64_t m, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int atype, int64_t lda, intptr_t b, int btype, int64_t ldb, intptr_t beta, intptr_t c, int ctype, int64_t ldc)
cpdef gemm_ex_64(intptr_t handle, int transa, int transb, int64_t m, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int atype, int64_t lda, intptr_t b, int btype, int64_t ldb, intptr_t beta, intptr_t c, int ctype, int64_t ldc, int compute_type, int algo)
cpdef cgemm_ex_64(intptr_t handle, int transa, int transb, int64_t m, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int atype, int64_t lda, intptr_t b, int btype, int64_t ldb, intptr_t beta, intptr_t c, int ctype, int64_t ldc)
cpdef ssyrk_64(intptr_t handle, int uplo, int trans, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, intptr_t beta, intptr_t c, int64_t ldc)
cpdef dsyrk_64(intptr_t handle, int uplo, int trans, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, intptr_t beta, intptr_t c, int64_t ldc)
cpdef csyrk_64(intptr_t handle, int uplo, int trans, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, intptr_t beta, intptr_t c, int64_t ldc)
cpdef zsyrk_64(intptr_t handle, int uplo, int trans, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, intptr_t beta, intptr_t c, int64_t ldc)
cpdef csyrk_ex_64(intptr_t handle, int uplo, int trans, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int atype, int64_t lda, intptr_t beta, intptr_t c, int ctype, int64_t ldc)
cpdef csyrk3m_ex_64(intptr_t handle, int uplo, int trans, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int atype, int64_t lda, intptr_t beta, intptr_t c, int ctype, int64_t ldc)
cpdef cherk_64(intptr_t handle, int uplo, int trans, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, intptr_t beta, intptr_t c, int64_t ldc)
cpdef zherk_64(intptr_t handle, int uplo, int trans, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, intptr_t beta, intptr_t c, int64_t ldc)
cpdef cherk_ex_64(intptr_t handle, int uplo, int trans, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int atype, int64_t lda, intptr_t beta, intptr_t c, int ctype, int64_t ldc)
cpdef cherk3m_ex_64(intptr_t handle, int uplo, int trans, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int atype, int64_t lda, intptr_t beta, intptr_t c, int ctype, int64_t ldc)
cpdef ssyr2k_64(intptr_t handle, int uplo, int trans, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, intptr_t beta, intptr_t c, int64_t ldc)
cpdef dsyr2k_64(intptr_t handle, int uplo, int trans, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, intptr_t beta, intptr_t c, int64_t ldc)
cpdef csyr2k_64(intptr_t handle, int uplo, int trans, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, intptr_t beta, intptr_t c, int64_t ldc)
cpdef zsyr2k_64(intptr_t handle, int uplo, int trans, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, intptr_t beta, intptr_t c, int64_t ldc)
cpdef cher2k_64(intptr_t handle, int uplo, int trans, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, intptr_t beta, intptr_t c, int64_t ldc)
cpdef zher2k_64(intptr_t handle, int uplo, int trans, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, intptr_t beta, intptr_t c, int64_t ldc)
cpdef ssyrkx_64(intptr_t handle, int uplo, int trans, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, intptr_t beta, intptr_t c, int64_t ldc)
cpdef dsyrkx_64(intptr_t handle, int uplo, int trans, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, intptr_t beta, intptr_t c, int64_t ldc)
cpdef csyrkx_64(intptr_t handle, int uplo, int trans, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, intptr_t beta, intptr_t c, int64_t ldc)
cpdef zsyrkx_64(intptr_t handle, int uplo, int trans, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, intptr_t beta, intptr_t c, int64_t ldc)
cpdef cherkx_64(intptr_t handle, int uplo, int trans, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, intptr_t beta, intptr_t c, int64_t ldc)
cpdef zherkx_64(intptr_t handle, int uplo, int trans, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, intptr_t beta, intptr_t c, int64_t ldc)
cpdef ssymm_64(intptr_t handle, int side, int uplo, int64_t m, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, intptr_t beta, intptr_t c, int64_t ldc)
cpdef dsymm_64(intptr_t handle, int side, int uplo, int64_t m, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, intptr_t beta, intptr_t c, int64_t ldc)
cpdef csymm_64(intptr_t handle, int side, int uplo, int64_t m, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, intptr_t beta, intptr_t c, int64_t ldc)
cpdef zsymm_64(intptr_t handle, int side, int uplo, int64_t m, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, intptr_t beta, intptr_t c, int64_t ldc)
cpdef chemm_64(intptr_t handle, int side, int uplo, int64_t m, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, intptr_t beta, intptr_t c, int64_t ldc)
cpdef zhemm_64(intptr_t handle, int side, int uplo, int64_t m, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, intptr_t beta, intptr_t c, int64_t ldc)
cpdef strsm_64(intptr_t handle, int side, int uplo, int trans, int diag, int64_t m, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb)
cpdef dtrsm_64(intptr_t handle, int side, int uplo, int trans, int diag, int64_t m, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb)
cpdef ctrsm_64(intptr_t handle, int side, int uplo, int trans, int diag, int64_t m, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb)
cpdef ztrsm_64(intptr_t handle, int side, int uplo, int trans, int diag, int64_t m, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb)
cpdef strmm_64(intptr_t handle, int side, int uplo, int trans, int diag, int64_t m, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, intptr_t c, int64_t ldc)
cpdef dtrmm_64(intptr_t handle, int side, int uplo, int trans, int diag, int64_t m, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, intptr_t c, int64_t ldc)
cpdef ctrmm_64(intptr_t handle, int side, int uplo, int trans, int diag, int64_t m, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, intptr_t c, int64_t ldc)
cpdef ztrmm_64(intptr_t handle, int side, int uplo, int trans, int diag, int64_t m, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, intptr_t c, int64_t ldc)
cpdef sgemm_batched_64(intptr_t handle, int transa, int transb, int64_t m, int64_t n, int64_t k, intptr_t alpha, intptr_t aarray, int64_t lda, intptr_t barray, int64_t ldb, intptr_t beta, intptr_t carray, int64_t ldc, int64_t batch_count)
cpdef dgemm_batched_64(intptr_t handle, int transa, int transb, int64_t m, int64_t n, int64_t k, intptr_t alpha, intptr_t aarray, int64_t lda, intptr_t barray, int64_t ldb, intptr_t beta, intptr_t carray, int64_t ldc, int64_t batch_count)
cpdef cgemm_batched_64(intptr_t handle, int transa, int transb, int64_t m, int64_t n, int64_t k, intptr_t alpha, intptr_t aarray, int64_t lda, intptr_t barray, int64_t ldb, intptr_t beta, intptr_t carray, int64_t ldc, int64_t batch_count)
cpdef cgemm3m_batched_64(intptr_t handle, int transa, int transb, int64_t m, int64_t n, int64_t k, intptr_t alpha, intptr_t aarray, int64_t lda, intptr_t barray, int64_t ldb, intptr_t beta, intptr_t carray, int64_t ldc, int64_t batch_count)
cpdef zgemm_batched_64(intptr_t handle, int transa, int transb, int64_t m, int64_t n, int64_t k, intptr_t alpha, intptr_t aarray, int64_t lda, intptr_t barray, int64_t ldb, intptr_t beta, intptr_t carray, int64_t ldc, int64_t batch_count)
cpdef sgemm_strided_batched_64(intptr_t handle, int transa, int transb, int64_t m, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, long long int stride_a, intptr_t b, int64_t ldb, long long int stride_b, intptr_t beta, intptr_t c, int64_t ldc, long long int stride_c, int64_t batch_count)
cpdef dgemm_strided_batched_64(intptr_t handle, int transa, int transb, int64_t m, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, long long int stride_a, intptr_t b, int64_t ldb, long long int stride_b, intptr_t beta, intptr_t c, int64_t ldc, long long int stride_c, int64_t batch_count)
cpdef cgemm_strided_batched_64(intptr_t handle, int transa, int transb, int64_t m, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, long long int stride_a, intptr_t b, int64_t ldb, long long int stride_b, intptr_t beta, intptr_t c, int64_t ldc, long long int stride_c, int64_t batch_count)
cpdef cgemm3m_strided_batched_64(intptr_t handle, int transa, int transb, int64_t m, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, long long int stride_a, intptr_t b, int64_t ldb, long long int stride_b, intptr_t beta, intptr_t c, int64_t ldc, long long int stride_c, int64_t batch_count)
cpdef zgemm_strided_batched_64(intptr_t handle, int transa, int transb, int64_t m, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int64_t lda, long long int stride_a, intptr_t b, int64_t ldb, long long int stride_b, intptr_t beta, intptr_t c, int64_t ldc, long long int stride_c, int64_t batch_count)
cpdef gemm_batched_ex_64(intptr_t handle, int transa, int transb, int64_t m, int64_t n, int64_t k, intptr_t alpha, intptr_t aarray, int atype, int64_t lda, intptr_t barray, int btype, int64_t ldb, intptr_t beta, intptr_t carray, int ctype, int64_t ldc, int64_t batch_count, int compute_type, int algo)
cpdef gemm_strided_batched_ex_64(intptr_t handle, int transa, int transb, int64_t m, int64_t n, int64_t k, intptr_t alpha, intptr_t a, int atype, int64_t lda, long long int stride_a, intptr_t b, int btype, int64_t ldb, long long int stride_b, intptr_t beta, intptr_t c, int ctype, int64_t ldc, long long int stride_c, int64_t batch_count, int compute_type, int algo)
cpdef sgeam_64(intptr_t handle, int transa, int transb, int64_t m, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, intptr_t beta, intptr_t b, int64_t ldb, intptr_t c, int64_t ldc)
cpdef dgeam_64(intptr_t handle, int transa, int transb, int64_t m, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, intptr_t beta, intptr_t b, int64_t ldb, intptr_t c, int64_t ldc)
cpdef cgeam_64(intptr_t handle, int transa, int transb, int64_t m, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, intptr_t beta, intptr_t b, int64_t ldb, intptr_t c, int64_t ldc)
cpdef zgeam_64(intptr_t handle, int transa, int transb, int64_t m, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, intptr_t beta, intptr_t b, int64_t ldb, intptr_t c, int64_t ldc)
cpdef strsm_batched_64(intptr_t handle, int side, int uplo, int trans, int diag, int64_t m, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, int64_t batch_count)
cpdef dtrsm_batched_64(intptr_t handle, int side, int uplo, int trans, int diag, int64_t m, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, int64_t batch_count)
cpdef ctrsm_batched_64(intptr_t handle, int side, int uplo, int trans, int diag, int64_t m, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, int64_t batch_count)
cpdef ztrsm_batched_64(intptr_t handle, int side, int uplo, int trans, int diag, int64_t m, int64_t n, intptr_t alpha, intptr_t a, int64_t lda, intptr_t b, int64_t ldb, int64_t batch_count)
cpdef sdgmm_64(intptr_t handle, int mode, int64_t m, int64_t n, intptr_t a, int64_t lda, intptr_t x, int64_t incx, intptr_t c, int64_t ldc)
cpdef ddgmm_64(intptr_t handle, int mode, int64_t m, int64_t n, intptr_t a, int64_t lda, intptr_t x, int64_t incx, intptr_t c, int64_t ldc)
cpdef cdgmm_64(intptr_t handle, int mode, int64_t m, int64_t n, intptr_t a, int64_t lda, intptr_t x, int64_t incx, intptr_t c, int64_t ldc)
cpdef zdgmm_64(intptr_t handle, int mode, int64_t m, int64_t n, intptr_t a, int64_t lda, intptr_t x, int64_t incx, intptr_t c, int64_t ldc)
cpdef sgemm_grouped_batched(intptr_t handle, transa_array, transb_array, m_array, n_array, k_array, alpha_array, intptr_t aarray, lda_array, intptr_t barray, ldb_array, beta_array, intptr_t carray, ldc_array, int group_count, group_size)
cpdef sgemm_grouped_batched_64(intptr_t handle, transa_array, transb_array, m_array, n_array, k_array, alpha_array, intptr_t aarray, lda_array, intptr_t barray, ldb_array, beta_array, intptr_t carray, ldc_array, int64_t group_count, group_size)
cpdef dgemm_grouped_batched(intptr_t handle, transa_array, transb_array, m_array, n_array, k_array, alpha_array, intptr_t aarray, lda_array, intptr_t barray, ldb_array, beta_array, intptr_t carray, ldc_array, int group_count, group_size)
cpdef dgemm_grouped_batched_64(intptr_t handle, transa_array, transb_array, m_array, n_array, k_array, alpha_array, intptr_t aarray, lda_array, intptr_t barray, ldb_array, beta_array, intptr_t carray, ldc_array, int64_t group_count, group_size)
cpdef gemm_grouped_batched_ex(intptr_t handle, transa_array, transb_array, m_array, n_array, k_array, intptr_t alpha_array, intptr_t aarray, int atype, lda_array, intptr_t barray, int btype, ldb_array, intptr_t beta_array, intptr_t carray, int ctype, ldc_array, int group_count, group_size, int compute_type)
cpdef gemm_grouped_batched_ex_64(intptr_t handle, transa_array, transb_array, m_array, n_array, k_array, intptr_t alpha_array, intptr_t aarray, int atype, lda_array, intptr_t barray, int btype, ldb_array, intptr_t beta_array, intptr_t carray, int ctype, ldc_array, int64_t group_count, group_size, int compute_type)
