# Copyright (c) 2024, NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
#
# SPDX-License-Identifier: Apache-2.0
#
# This code was automatically generated across versions from 11.0.3 to 12.6.2. Do not modify it directly.
# This layer exposes the C header to Cython as-is.

from libc.stdint cimport int64_t

from .cycublas cimport (cublasFillMode_t, cublasSideMode_t, cublasOperation_t,
                        cublasDiagType_t,)


###############################################################################
# Types (structs, enums, ...)
###############################################################################

# enums
ctypedef enum cusolverStatus_t "cusolverStatus_t":
    CUSOLVER_STATUS_SUCCESS "CUSOLVER_STATUS_SUCCESS" = 0
    CUSOLVER_STATUS_NOT_INITIALIZED "CUSOLVER_STATUS_NOT_INITIALIZED" = 1
    CUSOLVER_STATUS_ALLOC_FAILED "CUSOLVER_STATUS_ALLOC_FAILED" = 2
    CUSOLVER_STATUS_INVALID_VALUE "CUSOLVER_STATUS_INVALID_VALUE" = 3
    CUSOLVER_STATUS_ARCH_MISMATCH "CUSOLVER_STATUS_ARCH_MISMATCH" = 4
    CUSOLVER_STATUS_MAPPING_ERROR "CUSOLVER_STATUS_MAPPING_ERROR" = 5
    CUSOLVER_STATUS_EXECUTION_FAILED "CUSOLVER_STATUS_EXECUTION_FAILED" = 6
    CUSOLVER_STATUS_INTERNAL_ERROR "CUSOLVER_STATUS_INTERNAL_ERROR" = 7
    CUSOLVER_STATUS_MATRIX_TYPE_NOT_SUPPORTED "CUSOLVER_STATUS_MATRIX_TYPE_NOT_SUPPORTED" = 8
    CUSOLVER_STATUS_NOT_SUPPORTED "CUSOLVER_STATUS_NOT_SUPPORTED" = 9
    CUSOLVER_STATUS_ZERO_PIVOT "CUSOLVER_STATUS_ZERO_PIVOT" = 10
    CUSOLVER_STATUS_INVALID_LICENSE "CUSOLVER_STATUS_INVALID_LICENSE" = 11
    CUSOLVER_STATUS_IRS_PARAMS_NOT_INITIALIZED "CUSOLVER_STATUS_IRS_PARAMS_NOT_INITIALIZED" = 12
    CUSOLVER_STATUS_IRS_PARAMS_INVALID "CUSOLVER_STATUS_IRS_PARAMS_INVALID" = 13
    CUSOLVER_STATUS_IRS_PARAMS_INVALID_PREC "CUSOLVER_STATUS_IRS_PARAMS_INVALID_PREC" = 14
    CUSOLVER_STATUS_IRS_PARAMS_INVALID_REFINE "CUSOLVER_STATUS_IRS_PARAMS_INVALID_REFINE" = 15
    CUSOLVER_STATUS_IRS_PARAMS_INVALID_MAXITER "CUSOLVER_STATUS_IRS_PARAMS_INVALID_MAXITER" = 16
    CUSOLVER_STATUS_IRS_INTERNAL_ERROR "CUSOLVER_STATUS_IRS_INTERNAL_ERROR" = 20
    CUSOLVER_STATUS_IRS_NOT_SUPPORTED "CUSOLVER_STATUS_IRS_NOT_SUPPORTED" = 21
    CUSOLVER_STATUS_IRS_OUT_OF_RANGE "CUSOLVER_STATUS_IRS_OUT_OF_RANGE" = 22
    CUSOLVER_STATUS_IRS_NRHS_NOT_SUPPORTED_FOR_REFINE_GMRES "CUSOLVER_STATUS_IRS_NRHS_NOT_SUPPORTED_FOR_REFINE_GMRES" = 23
    CUSOLVER_STATUS_IRS_INFOS_NOT_INITIALIZED "CUSOLVER_STATUS_IRS_INFOS_NOT_INITIALIZED" = 25
    CUSOLVER_STATUS_IRS_INFOS_NOT_DESTROYED "CUSOLVER_STATUS_IRS_INFOS_NOT_DESTROYED" = 26
    CUSOLVER_STATUS_IRS_MATRIX_SINGULAR "CUSOLVER_STATUS_IRS_MATRIX_SINGULAR" = 30
    CUSOLVER_STATUS_INVALID_WORKSPACE "CUSOLVER_STATUS_INVALID_WORKSPACE" = 31

ctypedef enum cusolverEigType_t "cusolverEigType_t":
    CUSOLVER_EIG_TYPE_1 "CUSOLVER_EIG_TYPE_1" = 1
    CUSOLVER_EIG_TYPE_2 "CUSOLVER_EIG_TYPE_2" = 2
    CUSOLVER_EIG_TYPE_3 "CUSOLVER_EIG_TYPE_3" = 3

ctypedef enum cusolverEigMode_t "cusolverEigMode_t":
    CUSOLVER_EIG_MODE_NOVECTOR "CUSOLVER_EIG_MODE_NOVECTOR" = 0
    CUSOLVER_EIG_MODE_VECTOR "CUSOLVER_EIG_MODE_VECTOR" = 1

ctypedef enum cusolverEigRange_t "cusolverEigRange_t":
    CUSOLVER_EIG_RANGE_ALL "CUSOLVER_EIG_RANGE_ALL" = 1001
    CUSOLVER_EIG_RANGE_I "CUSOLVER_EIG_RANGE_I" = 1002
    CUSOLVER_EIG_RANGE_V "CUSOLVER_EIG_RANGE_V" = 1003

ctypedef enum cusolverNorm_t "cusolverNorm_t":
    CUSOLVER_INF_NORM "CUSOLVER_INF_NORM" = 104
    CUSOLVER_MAX_NORM "CUSOLVER_MAX_NORM" = 105
    CUSOLVER_ONE_NORM "CUSOLVER_ONE_NORM" = 106
    CUSOLVER_FRO_NORM "CUSOLVER_FRO_NORM" = 107

ctypedef enum cusolverIRSRefinement_t "cusolverIRSRefinement_t":
    CUSOLVER_IRS_REFINE_NOT_SET "CUSOLVER_IRS_REFINE_NOT_SET" = 1100
    CUSOLVER_IRS_REFINE_NONE "CUSOLVER_IRS_REFINE_NONE" = 1101
    CUSOLVER_IRS_REFINE_CLASSICAL "CUSOLVER_IRS_REFINE_CLASSICAL" = 1102
    CUSOLVER_IRS_REFINE_CLASSICAL_GMRES "CUSOLVER_IRS_REFINE_CLASSICAL_GMRES" = 1103
    CUSOLVER_IRS_REFINE_GMRES "CUSOLVER_IRS_REFINE_GMRES" = 1104
    CUSOLVER_IRS_REFINE_GMRES_GMRES "CUSOLVER_IRS_REFINE_GMRES_GMRES" = 1105
    CUSOLVER_IRS_REFINE_GMRES_NOPCOND "CUSOLVER_IRS_REFINE_GMRES_NOPCOND" = 1106
    CUSOLVER_PREC_DD "CUSOLVER_PREC_DD" = 1150
    CUSOLVER_PREC_SS "CUSOLVER_PREC_SS" = 1151
    CUSOLVER_PREC_SHT "CUSOLVER_PREC_SHT" = 1152

ctypedef enum cusolverPrecType_t "cusolverPrecType_t":
    CUSOLVER_R_8I "CUSOLVER_R_8I" = 1201
    CUSOLVER_R_8U "CUSOLVER_R_8U" = 1202
    CUSOLVER_R_64F "CUSOLVER_R_64F" = 1203
    CUSOLVER_R_32F "CUSOLVER_R_32F" = 1204
    CUSOLVER_R_16F "CUSOLVER_R_16F" = 1205
    CUSOLVER_R_16BF "CUSOLVER_R_16BF" = 1206
    CUSOLVER_R_TF32 "CUSOLVER_R_TF32" = 1207
    CUSOLVER_R_AP "CUSOLVER_R_AP" = 1208
    CUSOLVER_C_8I "CUSOLVER_C_8I" = 1211
    CUSOLVER_C_8U "CUSOLVER_C_8U" = 1212
    CUSOLVER_C_64F "CUSOLVER_C_64F" = 1213
    CUSOLVER_C_32F "CUSOLVER_C_32F" = 1214
    CUSOLVER_C_16F "CUSOLVER_C_16F" = 1215
    CUSOLVER_C_16BF "CUSOLVER_C_16BF" = 1216
    CUSOLVER_C_TF32 "CUSOLVER_C_TF32" = 1217
    CUSOLVER_C_AP "CUSOLVER_C_AP" = 1218

ctypedef enum cusolverAlgMode_t "cusolverAlgMode_t":
    CUSOLVER_ALG_0 "CUSOLVER_ALG_0" = 0
    CUSOLVER_ALG_1 "CUSOLVER_ALG_1" = 1
    CUSOLVER_ALG_2 "CUSOLVER_ALG_2" = 2

ctypedef enum cusolverStorevMode_t "cusolverStorevMode_t":
    CUBLAS_STOREV_COLUMNWISE "CUBLAS_STOREV_COLUMNWISE" = 0
    CUBLAS_STOREV_ROWWISE "CUBLAS_STOREV_ROWWISE" = 1

ctypedef enum cusolverDirectMode_t "cusolverDirectMode_t":
    CUBLAS_DIRECT_FORWARD "CUBLAS_DIRECT_FORWARD" = 0
    CUBLAS_DIRECT_BACKWARD "CUBLAS_DIRECT_BACKWARD" = 1

ctypedef enum cusolverDeterministicMode_t "cusolverDeterministicMode_t":
    CUSOLVER_DETERMINISTIC_RESULTS "CUSOLVER_DETERMINISTIC_RESULTS" = 1
    CUSOLVER_ALLOW_NON_DETERMINISTIC_RESULTS "CUSOLVER_ALLOW_NON_DETERMINISTIC_RESULTS" = 2


# types
cdef extern from *:
    """
    #include <driver_types.h>
    #include <library_types.h>
    #include <cuComplex.h>
    """
    ctypedef void* cudaStream_t 'cudaStream_t'
    ctypedef int cudaDataType_t 'cudaDataType_t'
    ctypedef int cudaDataType 'cudaDataType'
    ctypedef int libraryPropertyType_t 'libraryPropertyType_t'
    ctypedef int libraryPropertyType 'libraryPropertyType'

    ctypedef struct cuComplex:
        pass
    ctypedef struct cuDoubleComplex:
        pass



ctypedef int cusolver_int_t 'cusolver_int_t'


###############################################################################
# Functions
###############################################################################

cdef cusolverStatus_t cusolverGetProperty(libraryPropertyType type, int* value) except* nogil
cdef cusolverStatus_t cusolverGetVersion(int* version) except* nogil
