# Copyright (c) 2024-2025, NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
#
# SPDX-License-Identifier: Apache-2.0

import _cython_3_1_2
import enum
from typing import Any, Callable, ClassVar

__pyx_capi__: dict
__test__: dict
cleanup_threads: _cython_3_1_2.cython_function_or_method
cleanup_threads_double: _cython_3_1_2.cython_function_or_method
cleanup_threads_float: _cython_3_1_2.cython_function_or_method
destroy: _cython_3_1_2.cython_function_or_method
destroy_plan_double: _cython_3_1_2.cython_function_or_method
destroy_plan_float: _cython_3_1_2.cython_function_or_method
execute: _cython_3_1_2.cython_function_or_method
execute_c2c_double: _cython_3_1_2.cython_function_or_method
execute_c2c_float: _cython_3_1_2.cython_function_or_method
execute_c2r_double: _cython_3_1_2.cython_function_or_method
execute_c2r_float: _cython_3_1_2.cython_function_or_method
execute_r2c_double: _cython_3_1_2.cython_function_or_method
execute_r2c_float: _cython_3_1_2.cython_function_or_method
get_version: _cython_3_1_2.cython_function_or_method
init_threads: _cython_3_1_2.cython_function_or_method
init_threads_double: _cython_3_1_2.cython_function_or_method
init_threads_float: _cython_3_1_2.cython_function_or_method
plan_many: _cython_3_1_2.cython_function_or_method
plan_many_c2c_double: _cython_3_1_2.cython_function_or_method
plan_many_c2c_float: _cython_3_1_2.cython_function_or_method
plan_many_c2r_double: _cython_3_1_2.cython_function_or_method
plan_many_c2r_float: _cython_3_1_2.cython_function_or_method
plan_many_r2c_double: _cython_3_1_2.cython_function_or_method
plan_many_r2c_float: _cython_3_1_2.cython_function_or_method
plan_with_nthreads: _cython_3_1_2.cython_function_or_method
plan_with_nthreads_double: _cython_3_1_2.cython_function_or_method
plan_with_nthreads_float: _cython_3_1_2.cython_function_or_method
planner_nthreads: _cython_3_1_2.cython_function_or_method
planner_nthreads_double: _cython_3_1_2.cython_function_or_method
planner_nthreads_float: _cython_3_1_2.cython_function_or_method

class FFTWError(Exception): ...

class FFTWUnaligned(FFTWError): ...

class Kind(enum.IntFlag):
    __new__: ClassVar[Callable] = ...
    C2C: ClassVar[Kind] = ...
    C2R: ClassVar[Kind] = ...
    R2C: ClassVar[Kind] = ...
    _all_bits_: ClassVar[int] = ...
    _boundary_: ClassVar[enum.FlagBoundary] = ...
    _flag_mask_: ClassVar[int] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _inverted_: ClassVar[None] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _singles_mask_: ClassVar[int] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    __and__: ClassVar[Callable] = ...
    __invert__: ClassVar[Callable] = ...
    __or__: ClassVar[Callable] = ...
    __rand__: ClassVar[Callable] = ...
    __ror__: ClassVar[Callable] = ...
    __rxor__: ClassVar[Callable] = ...
    __xor__: ClassVar[Callable] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class Plan:
    @classmethod
    def __init__(cls, *args, **kwargs) -> None: ...
    def __reduce__(self) -> Any: ...

class PlannerFlags(enum.IntFlag):
    __new__: ClassVar[Callable] = ...
    ESTIMATE: ClassVar[PlannerFlags] = ...
    EXHAUSTIVE: ClassVar[PlannerFlags] = ...
    MEASURE: ClassVar[PlannerFlags] = ...
    PATIENT: ClassVar[PlannerFlags] = ...
    WISDOM_ONLY: ClassVar[PlannerFlags] = ...
    _all_bits_: ClassVar[int] = ...
    _boundary_: ClassVar[enum.FlagBoundary] = ...
    _flag_mask_: ClassVar[int] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _inverted_: ClassVar[None] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _singles_mask_: ClassVar[int] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    __and__: ClassVar[Callable] = ...
    __invert__: ClassVar[Callable] = ...
    __or__: ClassVar[Callable] = ...
    __rand__: ClassVar[Callable] = ...
    __ror__: ClassVar[Callable] = ...
    __rxor__: ClassVar[Callable] = ...
    __xor__: ClassVar[Callable] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class Precision(enum.IntFlag):
    __new__: ClassVar[Callable] = ...
    DOUBLE: ClassVar[Precision] = ...
    FLOAT: ClassVar[Precision] = ...
    _all_bits_: ClassVar[int] = ...
    _boundary_: ClassVar[enum.FlagBoundary] = ...
    _flag_mask_: ClassVar[int] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _inverted_: ClassVar[None] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _singles_mask_: ClassVar[int] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    __and__: ClassVar[Callable] = ...
    __invert__: ClassVar[Callable] = ...
    __or__: ClassVar[Callable] = ...
    __rand__: ClassVar[Callable] = ...
    __ror__: ClassVar[Callable] = ...
    __rxor__: ClassVar[Callable] = ...
    __xor__: ClassVar[Callable] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class Sign(enum.IntFlag):
    __new__: ClassVar[Callable] = ...
    FORWARD: ClassVar[Sign] = ...
    INVERSE: ClassVar[Sign] = ...
    UNSPECIFIED: ClassVar[Sign] = ...
    _all_bits_: ClassVar[int] = ...
    _boundary_: ClassVar[enum.FlagBoundary] = ...
    _flag_mask_: ClassVar[int] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _inverted_: ClassVar[None] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _singles_mask_: ClassVar[int] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    __and__: ClassVar[Callable] = ...
    __invert__: ClassVar[Callable] = ...
    __or__: ClassVar[Callable] = ...
    __rand__: ClassVar[Callable] = ...
    __ror__: ClassVar[Callable] = ...
    __rxor__: ClassVar[Callable] = ...
    __xor__: ClassVar[Callable] = ...
    def __format__(self, *args, **kwargs) -> str: ...
