# Copyright (c) 2024-2025, NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
#
# SPDX-License-Identifier: Apache-2.0
#
# This code was automatically generated across versions from 11.0.3 to 13.0.0. Do not modify it directly.

from ..cycublas cimport *

cdef void* load_library(const int driver_ver) except* with gil

###############################################################################
# Wrapper functions
###############################################################################

cdef cublasStatus_t _cublasCreate(cublasHandle_t* handle) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDestroy(cublasHandle_t handle) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasGetVersion(cublasHandle_t handle, int* version) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasGetProperty(libraryPropertyType type, int* value) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef size_t _cublasGetCudartVersion() except?0 nogil
cdef cublasStatus_t _cublasSetWorkspace(cublasHandle_t handle, void* workspace, size_t workspaceSizeInBytes) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSetStream(cublasHandle_t handle, cudaStream_t streamId) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasGetStream(cublasHandle_t handle, cudaStream_t* streamId) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasGetPointerMode(cublasHandle_t handle, cublasPointerMode_t* mode) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSetPointerMode(cublasHandle_t handle, cublasPointerMode_t mode) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasGetAtomicsMode(cublasHandle_t handle, cublasAtomicsMode_t* mode) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSetAtomicsMode(cublasHandle_t handle, cublasAtomicsMode_t mode) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasGetMathMode(cublasHandle_t handle, cublasMath_t* mode) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSetMathMode(cublasHandle_t handle, cublasMath_t mode) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasLoggerConfigure(int logIsOn, int logToStdOut, int logToStdErr, const char* logFileName) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSetLoggerCallback(cublasLogCallback userCallback) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasGetLoggerCallback(cublasLogCallback* userCallback) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSetVector(int n, int elemSize, const void* x, int incx, void* devicePtr, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasGetVector(int n, int elemSize, const void* x, int incx, void* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSetMatrix(int rows, int cols, int elemSize, const void* A, int lda, void* B, int ldb) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasGetMatrix(int rows, int cols, int elemSize, const void* A, int lda, void* B, int ldb) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSetVectorAsync(int n, int elemSize, const void* hostPtr, int incx, void* devicePtr, int incy, cudaStream_t stream) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasGetVectorAsync(int n, int elemSize, const void* devicePtr, int incx, void* hostPtr, int incy, cudaStream_t stream) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSetMatrixAsync(int rows, int cols, int elemSize, const void* A, int lda, void* B, int ldb, cudaStream_t stream) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasGetMatrixAsync(int rows, int cols, int elemSize, const void* A, int lda, void* B, int ldb, cudaStream_t stream) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasNrm2Ex(cublasHandle_t handle, int n, const void* x, cudaDataType xType, int incx, void* result, cudaDataType resultType, cudaDataType executionType) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSnrm2(cublasHandle_t handle, int n, const float* x, int incx, float* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDnrm2(cublasHandle_t handle, int n, const double* x, int incx, double* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasScnrm2(cublasHandle_t handle, int n, const cuComplex* x, int incx, float* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDznrm2(cublasHandle_t handle, int n, const cuDoubleComplex* x, int incx, double* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDotEx(cublasHandle_t handle, int n, const void* x, cudaDataType xType, int incx, const void* y, cudaDataType yType, int incy, void* result, cudaDataType resultType, cudaDataType executionType) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDotcEx(cublasHandle_t handle, int n, const void* x, cudaDataType xType, int incx, const void* y, cudaDataType yType, int incy, void* result, cudaDataType resultType, cudaDataType executionType) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSdot(cublasHandle_t handle, int n, const float* x, int incx, const float* y, int incy, float* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDdot(cublasHandle_t handle, int n, const double* x, int incx, const double* y, int incy, double* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCdotu(cublasHandle_t handle, int n, const cuComplex* x, int incx, const cuComplex* y, int incy, cuComplex* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCdotc(cublasHandle_t handle, int n, const cuComplex* x, int incx, const cuComplex* y, int incy, cuComplex* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZdotu(cublasHandle_t handle, int n, const cuDoubleComplex* x, int incx, const cuDoubleComplex* y, int incy, cuDoubleComplex* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZdotc(cublasHandle_t handle, int n, const cuDoubleComplex* x, int incx, const cuDoubleComplex* y, int incy, cuDoubleComplex* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasScalEx(cublasHandle_t handle, int n, const void* alpha, cudaDataType alphaType, void* x, cudaDataType xType, int incx, cudaDataType executionType) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSscal(cublasHandle_t handle, int n, const float* alpha, float* x, int incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDscal(cublasHandle_t handle, int n, const double* alpha, double* x, int incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCscal(cublasHandle_t handle, int n, const cuComplex* alpha, cuComplex* x, int incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCsscal(cublasHandle_t handle, int n, const float* alpha, cuComplex* x, int incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZscal(cublasHandle_t handle, int n, const cuDoubleComplex* alpha, cuDoubleComplex* x, int incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZdscal(cublasHandle_t handle, int n, const double* alpha, cuDoubleComplex* x, int incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasAxpyEx(cublasHandle_t handle, int n, const void* alpha, cudaDataType alphaType, const void* x, cudaDataType xType, int incx, void* y, cudaDataType yType, int incy, cudaDataType executiontype) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSaxpy(cublasHandle_t handle, int n, const float* alpha, const float* x, int incx, float* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDaxpy(cublasHandle_t handle, int n, const double* alpha, const double* x, int incx, double* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCaxpy(cublasHandle_t handle, int n, const cuComplex* alpha, const cuComplex* x, int incx, cuComplex* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZaxpy(cublasHandle_t handle, int n, const cuDoubleComplex* alpha, const cuDoubleComplex* x, int incx, cuDoubleComplex* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCopyEx(cublasHandle_t handle, int n, const void* x, cudaDataType xType, int incx, void* y, cudaDataType yType, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasScopy(cublasHandle_t handle, int n, const float* x, int incx, float* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDcopy(cublasHandle_t handle, int n, const double* x, int incx, double* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCcopy(cublasHandle_t handle, int n, const cuComplex* x, int incx, cuComplex* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZcopy(cublasHandle_t handle, int n, const cuDoubleComplex* x, int incx, cuDoubleComplex* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSswap(cublasHandle_t handle, int n, float* x, int incx, float* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDswap(cublasHandle_t handle, int n, double* x, int incx, double* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCswap(cublasHandle_t handle, int n, cuComplex* x, int incx, cuComplex* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZswap(cublasHandle_t handle, int n, cuDoubleComplex* x, int incx, cuDoubleComplex* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSwapEx(cublasHandle_t handle, int n, void* x, cudaDataType xType, int incx, void* y, cudaDataType yType, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasIsamax(cublasHandle_t handle, int n, const float* x, int incx, int* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasIdamax(cublasHandle_t handle, int n, const double* x, int incx, int* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasIcamax(cublasHandle_t handle, int n, const cuComplex* x, int incx, int* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasIzamax(cublasHandle_t handle, int n, const cuDoubleComplex* x, int incx, int* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasIamaxEx(cublasHandle_t handle, int n, const void* x, cudaDataType xType, int incx, int* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasIsamin(cublasHandle_t handle, int n, const float* x, int incx, int* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasIdamin(cublasHandle_t handle, int n, const double* x, int incx, int* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasIcamin(cublasHandle_t handle, int n, const cuComplex* x, int incx, int* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasIzamin(cublasHandle_t handle, int n, const cuDoubleComplex* x, int incx, int* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasIaminEx(cublasHandle_t handle, int n, const void* x, cudaDataType xType, int incx, int* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasAsumEx(cublasHandle_t handle, int n, const void* x, cudaDataType xType, int incx, void* result, cudaDataType resultType, cudaDataType executiontype) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSasum(cublasHandle_t handle, int n, const float* x, int incx, float* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDasum(cublasHandle_t handle, int n, const double* x, int incx, double* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasScasum(cublasHandle_t handle, int n, const cuComplex* x, int incx, float* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDzasum(cublasHandle_t handle, int n, const cuDoubleComplex* x, int incx, double* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSrot(cublasHandle_t handle, int n, float* x, int incx, float* y, int incy, const float* c, const float* s) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDrot(cublasHandle_t handle, int n, double* x, int incx, double* y, int incy, const double* c, const double* s) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCrot(cublasHandle_t handle, int n, cuComplex* x, int incx, cuComplex* y, int incy, const float* c, const cuComplex* s) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCsrot(cublasHandle_t handle, int n, cuComplex* x, int incx, cuComplex* y, int incy, const float* c, const float* s) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZrot(cublasHandle_t handle, int n, cuDoubleComplex* x, int incx, cuDoubleComplex* y, int incy, const double* c, const cuDoubleComplex* s) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZdrot(cublasHandle_t handle, int n, cuDoubleComplex* x, int incx, cuDoubleComplex* y, int incy, const double* c, const double* s) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasRotEx(cublasHandle_t handle, int n, void* x, cudaDataType xType, int incx, void* y, cudaDataType yType, int incy, const void* c, const void* s, cudaDataType csType, cudaDataType executiontype) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSrotg(cublasHandle_t handle, float* a, float* b, float* c, float* s) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDrotg(cublasHandle_t handle, double* a, double* b, double* c, double* s) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCrotg(cublasHandle_t handle, cuComplex* a, cuComplex* b, float* c, cuComplex* s) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZrotg(cublasHandle_t handle, cuDoubleComplex* a, cuDoubleComplex* b, double* c, cuDoubleComplex* s) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasRotgEx(cublasHandle_t handle, void* a, void* b, cudaDataType abType, void* c, void* s, cudaDataType csType, cudaDataType executiontype) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSrotm(cublasHandle_t handle, int n, float* x, int incx, float* y, int incy, const float* param) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDrotm(cublasHandle_t handle, int n, double* x, int incx, double* y, int incy, const double* param) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasRotmEx(cublasHandle_t handle, int n, void* x, cudaDataType xType, int incx, void* y, cudaDataType yType, int incy, const void* param, cudaDataType paramType, cudaDataType executiontype) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSrotmg(cublasHandle_t handle, float* d1, float* d2, float* x1, const float* y1, float* param) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDrotmg(cublasHandle_t handle, double* d1, double* d2, double* x1, const double* y1, double* param) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasRotmgEx(cublasHandle_t handle, void* d1, cudaDataType d1Type, void* d2, cudaDataType d2Type, void* x1, cudaDataType x1Type, const void* y1, cudaDataType y1Type, void* param, cudaDataType paramType, cudaDataType executiontype) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSgemv(cublasHandle_t handle, cublasOperation_t trans, int m, int n, const float* alpha, const float* A, int lda, const float* x, int incx, const float* beta, float* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDgemv(cublasHandle_t handle, cublasOperation_t trans, int m, int n, const double* alpha, const double* A, int lda, const double* x, int incx, const double* beta, double* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgemv(cublasHandle_t handle, cublasOperation_t trans, int m, int n, const cuComplex* alpha, const cuComplex* A, int lda, const cuComplex* x, int incx, const cuComplex* beta, cuComplex* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZgemv(cublasHandle_t handle, cublasOperation_t trans, int m, int n, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int lda, const cuDoubleComplex* x, int incx, const cuDoubleComplex* beta, cuDoubleComplex* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSgbmv(cublasHandle_t handle, cublasOperation_t trans, int m, int n, int kl, int ku, const float* alpha, const float* A, int lda, const float* x, int incx, const float* beta, float* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDgbmv(cublasHandle_t handle, cublasOperation_t trans, int m, int n, int kl, int ku, const double* alpha, const double* A, int lda, const double* x, int incx, const double* beta, double* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgbmv(cublasHandle_t handle, cublasOperation_t trans, int m, int n, int kl, int ku, const cuComplex* alpha, const cuComplex* A, int lda, const cuComplex* x, int incx, const cuComplex* beta, cuComplex* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZgbmv(cublasHandle_t handle, cublasOperation_t trans, int m, int n, int kl, int ku, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int lda, const cuDoubleComplex* x, int incx, const cuDoubleComplex* beta, cuDoubleComplex* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasStrmv(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int n, const float* A, int lda, float* x, int incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDtrmv(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int n, const double* A, int lda, double* x, int incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCtrmv(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int n, const cuComplex* A, int lda, cuComplex* x, int incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZtrmv(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int n, const cuDoubleComplex* A, int lda, cuDoubleComplex* x, int incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasStbmv(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int n, int k, const float* A, int lda, float* x, int incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDtbmv(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int n, int k, const double* A, int lda, double* x, int incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCtbmv(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int n, int k, const cuComplex* A, int lda, cuComplex* x, int incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZtbmv(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int n, int k, const cuDoubleComplex* A, int lda, cuDoubleComplex* x, int incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasStpmv(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int n, const float* AP, float* x, int incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDtpmv(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int n, const double* AP, double* x, int incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCtpmv(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int n, const cuComplex* AP, cuComplex* x, int incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZtpmv(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int n, const cuDoubleComplex* AP, cuDoubleComplex* x, int incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasStrsv(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int n, const float* A, int lda, float* x, int incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDtrsv(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int n, const double* A, int lda, double* x, int incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCtrsv(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int n, const cuComplex* A, int lda, cuComplex* x, int incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZtrsv(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int n, const cuDoubleComplex* A, int lda, cuDoubleComplex* x, int incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasStpsv(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int n, const float* AP, float* x, int incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDtpsv(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int n, const double* AP, double* x, int incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCtpsv(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int n, const cuComplex* AP, cuComplex* x, int incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZtpsv(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int n, const cuDoubleComplex* AP, cuDoubleComplex* x, int incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasStbsv(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int n, int k, const float* A, int lda, float* x, int incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDtbsv(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int n, int k, const double* A, int lda, double* x, int incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCtbsv(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int n, int k, const cuComplex* A, int lda, cuComplex* x, int incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZtbsv(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int n, int k, const cuDoubleComplex* A, int lda, cuDoubleComplex* x, int incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSsymv(cublasHandle_t handle, cublasFillMode_t uplo, int n, const float* alpha, const float* A, int lda, const float* x, int incx, const float* beta, float* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDsymv(cublasHandle_t handle, cublasFillMode_t uplo, int n, const double* alpha, const double* A, int lda, const double* x, int incx, const double* beta, double* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCsymv(cublasHandle_t handle, cublasFillMode_t uplo, int n, const cuComplex* alpha, const cuComplex* A, int lda, const cuComplex* x, int incx, const cuComplex* beta, cuComplex* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZsymv(cublasHandle_t handle, cublasFillMode_t uplo, int n, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int lda, const cuDoubleComplex* x, int incx, const cuDoubleComplex* beta, cuDoubleComplex* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasChemv(cublasHandle_t handle, cublasFillMode_t uplo, int n, const cuComplex* alpha, const cuComplex* A, int lda, const cuComplex* x, int incx, const cuComplex* beta, cuComplex* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZhemv(cublasHandle_t handle, cublasFillMode_t uplo, int n, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int lda, const cuDoubleComplex* x, int incx, const cuDoubleComplex* beta, cuDoubleComplex* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSsbmv(cublasHandle_t handle, cublasFillMode_t uplo, int n, int k, const float* alpha, const float* A, int lda, const float* x, int incx, const float* beta, float* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDsbmv(cublasHandle_t handle, cublasFillMode_t uplo, int n, int k, const double* alpha, const double* A, int lda, const double* x, int incx, const double* beta, double* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasChbmv(cublasHandle_t handle, cublasFillMode_t uplo, int n, int k, const cuComplex* alpha, const cuComplex* A, int lda, const cuComplex* x, int incx, const cuComplex* beta, cuComplex* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZhbmv(cublasHandle_t handle, cublasFillMode_t uplo, int n, int k, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int lda, const cuDoubleComplex* x, int incx, const cuDoubleComplex* beta, cuDoubleComplex* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSspmv(cublasHandle_t handle, cublasFillMode_t uplo, int n, const float* alpha, const float* AP, const float* x, int incx, const float* beta, float* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDspmv(cublasHandle_t handle, cublasFillMode_t uplo, int n, const double* alpha, const double* AP, const double* x, int incx, const double* beta, double* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasChpmv(cublasHandle_t handle, cublasFillMode_t uplo, int n, const cuComplex* alpha, const cuComplex* AP, const cuComplex* x, int incx, const cuComplex* beta, cuComplex* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZhpmv(cublasHandle_t handle, cublasFillMode_t uplo, int n, const cuDoubleComplex* alpha, const cuDoubleComplex* AP, const cuDoubleComplex* x, int incx, const cuDoubleComplex* beta, cuDoubleComplex* y, int incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSger(cublasHandle_t handle, int m, int n, const float* alpha, const float* x, int incx, const float* y, int incy, float* A, int lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDger(cublasHandle_t handle, int m, int n, const double* alpha, const double* x, int incx, const double* y, int incy, double* A, int lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgeru(cublasHandle_t handle, int m, int n, const cuComplex* alpha, const cuComplex* x, int incx, const cuComplex* y, int incy, cuComplex* A, int lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgerc(cublasHandle_t handle, int m, int n, const cuComplex* alpha, const cuComplex* x, int incx, const cuComplex* y, int incy, cuComplex* A, int lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZgeru(cublasHandle_t handle, int m, int n, const cuDoubleComplex* alpha, const cuDoubleComplex* x, int incx, const cuDoubleComplex* y, int incy, cuDoubleComplex* A, int lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZgerc(cublasHandle_t handle, int m, int n, const cuDoubleComplex* alpha, const cuDoubleComplex* x, int incx, const cuDoubleComplex* y, int incy, cuDoubleComplex* A, int lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSsyr(cublasHandle_t handle, cublasFillMode_t uplo, int n, const float* alpha, const float* x, int incx, float* A, int lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDsyr(cublasHandle_t handle, cublasFillMode_t uplo, int n, const double* alpha, const double* x, int incx, double* A, int lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCsyr(cublasHandle_t handle, cublasFillMode_t uplo, int n, const cuComplex* alpha, const cuComplex* x, int incx, cuComplex* A, int lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZsyr(cublasHandle_t handle, cublasFillMode_t uplo, int n, const cuDoubleComplex* alpha, const cuDoubleComplex* x, int incx, cuDoubleComplex* A, int lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCher(cublasHandle_t handle, cublasFillMode_t uplo, int n, const float* alpha, const cuComplex* x, int incx, cuComplex* A, int lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZher(cublasHandle_t handle, cublasFillMode_t uplo, int n, const double* alpha, const cuDoubleComplex* x, int incx, cuDoubleComplex* A, int lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSspr(cublasHandle_t handle, cublasFillMode_t uplo, int n, const float* alpha, const float* x, int incx, float* AP) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDspr(cublasHandle_t handle, cublasFillMode_t uplo, int n, const double* alpha, const double* x, int incx, double* AP) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasChpr(cublasHandle_t handle, cublasFillMode_t uplo, int n, const float* alpha, const cuComplex* x, int incx, cuComplex* AP) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZhpr(cublasHandle_t handle, cublasFillMode_t uplo, int n, const double* alpha, const cuDoubleComplex* x, int incx, cuDoubleComplex* AP) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSsyr2(cublasHandle_t handle, cublasFillMode_t uplo, int n, const float* alpha, const float* x, int incx, const float* y, int incy, float* A, int lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDsyr2(cublasHandle_t handle, cublasFillMode_t uplo, int n, const double* alpha, const double* x, int incx, const double* y, int incy, double* A, int lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCsyr2(cublasHandle_t handle, cublasFillMode_t uplo, int n, const cuComplex* alpha, const cuComplex* x, int incx, const cuComplex* y, int incy, cuComplex* A, int lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZsyr2(cublasHandle_t handle, cublasFillMode_t uplo, int n, const cuDoubleComplex* alpha, const cuDoubleComplex* x, int incx, const cuDoubleComplex* y, int incy, cuDoubleComplex* A, int lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCher2(cublasHandle_t handle, cublasFillMode_t uplo, int n, const cuComplex* alpha, const cuComplex* x, int incx, const cuComplex* y, int incy, cuComplex* A, int lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZher2(cublasHandle_t handle, cublasFillMode_t uplo, int n, const cuDoubleComplex* alpha, const cuDoubleComplex* x, int incx, const cuDoubleComplex* y, int incy, cuDoubleComplex* A, int lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSspr2(cublasHandle_t handle, cublasFillMode_t uplo, int n, const float* alpha, const float* x, int incx, const float* y, int incy, float* AP) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDspr2(cublasHandle_t handle, cublasFillMode_t uplo, int n, const double* alpha, const double* x, int incx, const double* y, int incy, double* AP) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasChpr2(cublasHandle_t handle, cublasFillMode_t uplo, int n, const cuComplex* alpha, const cuComplex* x, int incx, const cuComplex* y, int incy, cuComplex* AP) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZhpr2(cublasHandle_t handle, cublasFillMode_t uplo, int n, const cuDoubleComplex* alpha, const cuDoubleComplex* x, int incx, const cuDoubleComplex* y, int incy, cuDoubleComplex* AP) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSgemm(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int m, int n, int k, const float* alpha, const float* A, int lda, const float* B, int ldb, const float* beta, float* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDgemm(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int m, int n, int k, const double* alpha, const double* A, int lda, const double* B, int ldb, const double* beta, double* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgemm(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int m, int n, int k, const cuComplex* alpha, const cuComplex* A, int lda, const cuComplex* B, int ldb, const cuComplex* beta, cuComplex* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgemm3m(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int m, int n, int k, const cuComplex* alpha, const cuComplex* A, int lda, const cuComplex* B, int ldb, const cuComplex* beta, cuComplex* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgemm3mEx(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int m, int n, int k, const cuComplex* alpha, const void* A, cudaDataType Atype, int lda, const void* B, cudaDataType Btype, int ldb, const cuComplex* beta, void* C, cudaDataType Ctype, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZgemm(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int m, int n, int k, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int lda, const cuDoubleComplex* B, int ldb, const cuDoubleComplex* beta, cuDoubleComplex* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZgemm3m(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int m, int n, int k, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int lda, const cuDoubleComplex* B, int ldb, const cuDoubleComplex* beta, cuDoubleComplex* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSgemmEx(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int m, int n, int k, const float* alpha, const void* A, cudaDataType Atype, int lda, const void* B, cudaDataType Btype, int ldb, const float* beta, void* C, cudaDataType Ctype, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasGemmEx(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int m, int n, int k, const void* alpha, const void* A, cudaDataType Atype, int lda, const void* B, cudaDataType Btype, int ldb, const void* beta, void* C, cudaDataType Ctype, int ldc, cublasComputeType_t computeType, cublasGemmAlgo_t algo) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgemmEx(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int m, int n, int k, const cuComplex* alpha, const void* A, cudaDataType Atype, int lda, const void* B, cudaDataType Btype, int ldb, const cuComplex* beta, void* C, cudaDataType Ctype, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasUint8gemmBias(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, cublasOperation_t transc, int m, int n, int k, const unsigned char* A, int A_bias, int lda, const unsigned char* B, int B_bias, int ldb, unsigned char* C, int C_bias, int ldc, int C_mult, int C_shift) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSsyrk(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int n, int k, const float* alpha, const float* A, int lda, const float* beta, float* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDsyrk(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int n, int k, const double* alpha, const double* A, int lda, const double* beta, double* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCsyrk(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int n, int k, const cuComplex* alpha, const cuComplex* A, int lda, const cuComplex* beta, cuComplex* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZsyrk(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int n, int k, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int lda, const cuDoubleComplex* beta, cuDoubleComplex* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCsyrkEx(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int n, int k, const cuComplex* alpha, const void* A, cudaDataType Atype, int lda, const cuComplex* beta, void* C, cudaDataType Ctype, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCsyrk3mEx(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int n, int k, const cuComplex* alpha, const void* A, cudaDataType Atype, int lda, const cuComplex* beta, void* C, cudaDataType Ctype, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCherk(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int n, int k, const float* alpha, const cuComplex* A, int lda, const float* beta, cuComplex* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZherk(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int n, int k, const double* alpha, const cuDoubleComplex* A, int lda, const double* beta, cuDoubleComplex* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCherkEx(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int n, int k, const float* alpha, const void* A, cudaDataType Atype, int lda, const float* beta, void* C, cudaDataType Ctype, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCherk3mEx(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int n, int k, const float* alpha, const void* A, cudaDataType Atype, int lda, const float* beta, void* C, cudaDataType Ctype, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSsyr2k(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int n, int k, const float* alpha, const float* A, int lda, const float* B, int ldb, const float* beta, float* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDsyr2k(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int n, int k, const double* alpha, const double* A, int lda, const double* B, int ldb, const double* beta, double* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCsyr2k(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int n, int k, const cuComplex* alpha, const cuComplex* A, int lda, const cuComplex* B, int ldb, const cuComplex* beta, cuComplex* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZsyr2k(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int n, int k, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int lda, const cuDoubleComplex* B, int ldb, const cuDoubleComplex* beta, cuDoubleComplex* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCher2k(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int n, int k, const cuComplex* alpha, const cuComplex* A, int lda, const cuComplex* B, int ldb, const float* beta, cuComplex* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZher2k(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int n, int k, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int lda, const cuDoubleComplex* B, int ldb, const double* beta, cuDoubleComplex* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSsyrkx(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int n, int k, const float* alpha, const float* A, int lda, const float* B, int ldb, const float* beta, float* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDsyrkx(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int n, int k, const double* alpha, const double* A, int lda, const double* B, int ldb, const double* beta, double* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCsyrkx(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int n, int k, const cuComplex* alpha, const cuComplex* A, int lda, const cuComplex* B, int ldb, const cuComplex* beta, cuComplex* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZsyrkx(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int n, int k, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int lda, const cuDoubleComplex* B, int ldb, const cuDoubleComplex* beta, cuDoubleComplex* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCherkx(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int n, int k, const cuComplex* alpha, const cuComplex* A, int lda, const cuComplex* B, int ldb, const float* beta, cuComplex* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZherkx(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int n, int k, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int lda, const cuDoubleComplex* B, int ldb, const double* beta, cuDoubleComplex* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSsymm(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, int m, int n, const float* alpha, const float* A, int lda, const float* B, int ldb, const float* beta, float* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDsymm(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, int m, int n, const double* alpha, const double* A, int lda, const double* B, int ldb, const double* beta, double* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCsymm(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, int m, int n, const cuComplex* alpha, const cuComplex* A, int lda, const cuComplex* B, int ldb, const cuComplex* beta, cuComplex* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZsymm(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, int m, int n, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int lda, const cuDoubleComplex* B, int ldb, const cuDoubleComplex* beta, cuDoubleComplex* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasChemm(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, int m, int n, const cuComplex* alpha, const cuComplex* A, int lda, const cuComplex* B, int ldb, const cuComplex* beta, cuComplex* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZhemm(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, int m, int n, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int lda, const cuDoubleComplex* B, int ldb, const cuDoubleComplex* beta, cuDoubleComplex* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasStrsm(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int m, int n, const float* alpha, const float* A, int lda, float* B, int ldb) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDtrsm(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int m, int n, const double* alpha, const double* A, int lda, double* B, int ldb) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCtrsm(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int m, int n, const cuComplex* alpha, const cuComplex* A, int lda, cuComplex* B, int ldb) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZtrsm(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int m, int n, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int lda, cuDoubleComplex* B, int ldb) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasStrmm(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int m, int n, const float* alpha, const float* A, int lda, const float* B, int ldb, float* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDtrmm(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int m, int n, const double* alpha, const double* A, int lda, const double* B, int ldb, double* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCtrmm(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int m, int n, const cuComplex* alpha, const cuComplex* A, int lda, const cuComplex* B, int ldb, cuComplex* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZtrmm(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int m, int n, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int lda, const cuDoubleComplex* B, int ldb, cuDoubleComplex* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSgemmBatched(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int m, int n, int k, const float* alpha, const float* const Aarray[], int lda, const float* const Barray[], int ldb, const float* beta, float* const Carray[], int ldc, int batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDgemmBatched(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int m, int n, int k, const double* alpha, const double* const Aarray[], int lda, const double* const Barray[], int ldb, const double* beta, double* const Carray[], int ldc, int batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgemmBatched(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int m, int n, int k, const cuComplex* alpha, const cuComplex* const Aarray[], int lda, const cuComplex* const Barray[], int ldb, const cuComplex* beta, cuComplex* const Carray[], int ldc, int batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgemm3mBatched(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int m, int n, int k, const cuComplex* alpha, const cuComplex* const Aarray[], int lda, const cuComplex* const Barray[], int ldb, const cuComplex* beta, cuComplex* const Carray[], int ldc, int batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZgemmBatched(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int m, int n, int k, const cuDoubleComplex* alpha, const cuDoubleComplex* const Aarray[], int lda, const cuDoubleComplex* const Barray[], int ldb, const cuDoubleComplex* beta, cuDoubleComplex* const Carray[], int ldc, int batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasGemmBatchedEx(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int m, int n, int k, const void* alpha, const void* const Aarray[], cudaDataType Atype, int lda, const void* const Barray[], cudaDataType Btype, int ldb, const void* beta, void* const Carray[], cudaDataType Ctype, int ldc, int batchCount, cublasComputeType_t computeType, cublasGemmAlgo_t algo) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasGemmStridedBatchedEx(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int m, int n, int k, const void* alpha, const void* A, cudaDataType Atype, int lda, long long int strideA, const void* B, cudaDataType Btype, int ldb, long long int strideB, const void* beta, void* C, cudaDataType Ctype, int ldc, long long int strideC, int batchCount, cublasComputeType_t computeType, cublasGemmAlgo_t algo) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSgemmStridedBatched(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int m, int n, int k, const float* alpha, const float* A, int lda, long long int strideA, const float* B, int ldb, long long int strideB, const float* beta, float* C, int ldc, long long int strideC, int batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDgemmStridedBatched(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int m, int n, int k, const double* alpha, const double* A, int lda, long long int strideA, const double* B, int ldb, long long int strideB, const double* beta, double* C, int ldc, long long int strideC, int batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgemmStridedBatched(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int m, int n, int k, const cuComplex* alpha, const cuComplex* A, int lda, long long int strideA, const cuComplex* B, int ldb, long long int strideB, const cuComplex* beta, cuComplex* C, int ldc, long long int strideC, int batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgemm3mStridedBatched(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int m, int n, int k, const cuComplex* alpha, const cuComplex* A, int lda, long long int strideA, const cuComplex* B, int ldb, long long int strideB, const cuComplex* beta, cuComplex* C, int ldc, long long int strideC, int batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZgemmStridedBatched(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int m, int n, int k, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int lda, long long int strideA, const cuDoubleComplex* B, int ldb, long long int strideB, const cuDoubleComplex* beta, cuDoubleComplex* C, int ldc, long long int strideC, int batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSgeam(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int m, int n, const float* alpha, const float* A, int lda, const float* beta, const float* B, int ldb, float* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDgeam(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int m, int n, const double* alpha, const double* A, int lda, const double* beta, const double* B, int ldb, double* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgeam(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int m, int n, const cuComplex* alpha, const cuComplex* A, int lda, const cuComplex* beta, const cuComplex* B, int ldb, cuComplex* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZgeam(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int m, int n, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int lda, const cuDoubleComplex* beta, const cuDoubleComplex* B, int ldb, cuDoubleComplex* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSgetrfBatched(cublasHandle_t handle, int n, float* const A[], int lda, int* P, int* info, int batchSize) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDgetrfBatched(cublasHandle_t handle, int n, double* const A[], int lda, int* P, int* info, int batchSize) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgetrfBatched(cublasHandle_t handle, int n, cuComplex* const A[], int lda, int* P, int* info, int batchSize) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZgetrfBatched(cublasHandle_t handle, int n, cuDoubleComplex* const A[], int lda, int* P, int* info, int batchSize) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSgetriBatched(cublasHandle_t handle, int n, const float* const A[], int lda, const int* P, float* const C[], int ldc, int* info, int batchSize) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDgetriBatched(cublasHandle_t handle, int n, const double* const A[], int lda, const int* P, double* const C[], int ldc, int* info, int batchSize) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgetriBatched(cublasHandle_t handle, int n, const cuComplex* const A[], int lda, const int* P, cuComplex* const C[], int ldc, int* info, int batchSize) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZgetriBatched(cublasHandle_t handle, int n, const cuDoubleComplex* const A[], int lda, const int* P, cuDoubleComplex* const C[], int ldc, int* info, int batchSize) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSgetrsBatched(cublasHandle_t handle, cublasOperation_t trans, int n, int nrhs, const float* const Aarray[], int lda, const int* devIpiv, float* const Barray[], int ldb, int* info, int batchSize) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDgetrsBatched(cublasHandle_t handle, cublasOperation_t trans, int n, int nrhs, const double* const Aarray[], int lda, const int* devIpiv, double* const Barray[], int ldb, int* info, int batchSize) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgetrsBatched(cublasHandle_t handle, cublasOperation_t trans, int n, int nrhs, const cuComplex* const Aarray[], int lda, const int* devIpiv, cuComplex* const Barray[], int ldb, int* info, int batchSize) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZgetrsBatched(cublasHandle_t handle, cublasOperation_t trans, int n, int nrhs, const cuDoubleComplex* const Aarray[], int lda, const int* devIpiv, cuDoubleComplex* const Barray[], int ldb, int* info, int batchSize) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasStrsmBatched(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int m, int n, const float* alpha, const float* const A[], int lda, float* const B[], int ldb, int batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDtrsmBatched(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int m, int n, const double* alpha, const double* const A[], int lda, double* const B[], int ldb, int batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCtrsmBatched(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int m, int n, const cuComplex* alpha, const cuComplex* const A[], int lda, cuComplex* const B[], int ldb, int batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZtrsmBatched(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int m, int n, const cuDoubleComplex* alpha, const cuDoubleComplex* const A[], int lda, cuDoubleComplex* const B[], int ldb, int batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSmatinvBatched(cublasHandle_t handle, int n, const float* const A[], int lda, float* const Ainv[], int lda_inv, int* info, int batchSize) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDmatinvBatched(cublasHandle_t handle, int n, const double* const A[], int lda, double* const Ainv[], int lda_inv, int* info, int batchSize) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCmatinvBatched(cublasHandle_t handle, int n, const cuComplex* const A[], int lda, cuComplex* const Ainv[], int lda_inv, int* info, int batchSize) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZmatinvBatched(cublasHandle_t handle, int n, const cuDoubleComplex* const A[], int lda, cuDoubleComplex* const Ainv[], int lda_inv, int* info, int batchSize) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSgeqrfBatched(cublasHandle_t handle, int m, int n, float* const Aarray[], int lda, float* const TauArray[], int* info, int batchSize) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDgeqrfBatched(cublasHandle_t handle, int m, int n, double* const Aarray[], int lda, double* const TauArray[], int* info, int batchSize) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgeqrfBatched(cublasHandle_t handle, int m, int n, cuComplex* const Aarray[], int lda, cuComplex* const TauArray[], int* info, int batchSize) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZgeqrfBatched(cublasHandle_t handle, int m, int n, cuDoubleComplex* const Aarray[], int lda, cuDoubleComplex* const TauArray[], int* info, int batchSize) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSgelsBatched(cublasHandle_t handle, cublasOperation_t trans, int m, int n, int nrhs, float* const Aarray[], int lda, float* const Carray[], int ldc, int* info, int* devInfoArray, int batchSize) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDgelsBatched(cublasHandle_t handle, cublasOperation_t trans, int m, int n, int nrhs, double* const Aarray[], int lda, double* const Carray[], int ldc, int* info, int* devInfoArray, int batchSize) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgelsBatched(cublasHandle_t handle, cublasOperation_t trans, int m, int n, int nrhs, cuComplex* const Aarray[], int lda, cuComplex* const Carray[], int ldc, int* info, int* devInfoArray, int batchSize) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZgelsBatched(cublasHandle_t handle, cublasOperation_t trans, int m, int n, int nrhs, cuDoubleComplex* const Aarray[], int lda, cuDoubleComplex* const Carray[], int ldc, int* info, int* devInfoArray, int batchSize) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSdgmm(cublasHandle_t handle, cublasSideMode_t mode, int m, int n, const float* A, int lda, const float* x, int incx, float* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDdgmm(cublasHandle_t handle, cublasSideMode_t mode, int m, int n, const double* A, int lda, const double* x, int incx, double* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCdgmm(cublasHandle_t handle, cublasSideMode_t mode, int m, int n, const cuComplex* A, int lda, const cuComplex* x, int incx, cuComplex* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZdgmm(cublasHandle_t handle, cublasSideMode_t mode, int m, int n, const cuDoubleComplex* A, int lda, const cuDoubleComplex* x, int incx, cuDoubleComplex* C, int ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasStpttr(cublasHandle_t handle, cublasFillMode_t uplo, int n, const float* AP, float* A, int lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDtpttr(cublasHandle_t handle, cublasFillMode_t uplo, int n, const double* AP, double* A, int lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCtpttr(cublasHandle_t handle, cublasFillMode_t uplo, int n, const cuComplex* AP, cuComplex* A, int lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZtpttr(cublasHandle_t handle, cublasFillMode_t uplo, int n, const cuDoubleComplex* AP, cuDoubleComplex* A, int lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasStrttp(cublasHandle_t handle, cublasFillMode_t uplo, int n, const float* A, int lda, float* AP) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDtrttp(cublasHandle_t handle, cublasFillMode_t uplo, int n, const double* A, int lda, double* AP) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCtrttp(cublasHandle_t handle, cublasFillMode_t uplo, int n, const cuComplex* A, int lda, cuComplex* AP) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZtrttp(cublasHandle_t handle, cublasFillMode_t uplo, int n, const cuDoubleComplex* A, int lda, cuDoubleComplex* AP) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasGetSmCountTarget(cublasHandle_t handle, int* smCountTarget) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSetSmCountTarget(cublasHandle_t handle, int smCountTarget) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef const char* _cublasGetStatusName(cublasStatus_t status) except?NULL nogil
cdef const char* _cublasGetStatusString(cublasStatus_t status) except?NULL nogil
cdef cublasStatus_t _cublasSgemvBatched(cublasHandle_t handle, cublasOperation_t trans, int m, int n, const float* alpha, const float* const Aarray[], int lda, const float* const xarray[], int incx, const float* beta, float* const yarray[], int incy, int batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDgemvBatched(cublasHandle_t handle, cublasOperation_t trans, int m, int n, const double* alpha, const double* const Aarray[], int lda, const double* const xarray[], int incx, const double* beta, double* const yarray[], int incy, int batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgemvBatched(cublasHandle_t handle, cublasOperation_t trans, int m, int n, const cuComplex* alpha, const cuComplex* const Aarray[], int lda, const cuComplex* const xarray[], int incx, const cuComplex* beta, cuComplex* const yarray[], int incy, int batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZgemvBatched(cublasHandle_t handle, cublasOperation_t trans, int m, int n, const cuDoubleComplex* alpha, const cuDoubleComplex* const Aarray[], int lda, const cuDoubleComplex* const xarray[], int incx, const cuDoubleComplex* beta, cuDoubleComplex* const yarray[], int incy, int batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSgemvStridedBatched(cublasHandle_t handle, cublasOperation_t trans, int m, int n, const float* alpha, const float* A, int lda, long long int strideA, const float* x, int incx, long long int stridex, const float* beta, float* y, int incy, long long int stridey, int batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDgemvStridedBatched(cublasHandle_t handle, cublasOperation_t trans, int m, int n, const double* alpha, const double* A, int lda, long long int strideA, const double* x, int incx, long long int stridex, const double* beta, double* y, int incy, long long int stridey, int batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgemvStridedBatched(cublasHandle_t handle, cublasOperation_t trans, int m, int n, const cuComplex* alpha, const cuComplex* A, int lda, long long int strideA, const cuComplex* x, int incx, long long int stridex, const cuComplex* beta, cuComplex* y, int incy, long long int stridey, int batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZgemvStridedBatched(cublasHandle_t handle, cublasOperation_t trans, int m, int n, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int lda, long long int strideA, const cuDoubleComplex* x, int incx, long long int stridex, const cuDoubleComplex* beta, cuDoubleComplex* y, int incy, long long int stridey, int batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSetVector_64(int64_t n, int64_t elemSize, const void* x, int64_t incx, void* devicePtr, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasGetVector_64(int64_t n, int64_t elemSize, const void* x, int64_t incx, void* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSetMatrix_64(int64_t rows, int64_t cols, int64_t elemSize, const void* A, int64_t lda, void* B, int64_t ldb) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasGetMatrix_64(int64_t rows, int64_t cols, int64_t elemSize, const void* A, int64_t lda, void* B, int64_t ldb) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSetVectorAsync_64(int64_t n, int64_t elemSize, const void* hostPtr, int64_t incx, void* devicePtr, int64_t incy, cudaStream_t stream) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasGetVectorAsync_64(int64_t n, int64_t elemSize, const void* devicePtr, int64_t incx, void* hostPtr, int64_t incy, cudaStream_t stream) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSetMatrixAsync_64(int64_t rows, int64_t cols, int64_t elemSize, const void* A, int64_t lda, void* B, int64_t ldb, cudaStream_t stream) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasGetMatrixAsync_64(int64_t rows, int64_t cols, int64_t elemSize, const void* A, int64_t lda, void* B, int64_t ldb, cudaStream_t stream) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasNrm2Ex_64(cublasHandle_t handle, int64_t n, const void* x, cudaDataType xType, int64_t incx, void* result, cudaDataType resultType, cudaDataType executionType) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSnrm2_64(cublasHandle_t handle, int64_t n, const float* x, int64_t incx, float* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDnrm2_64(cublasHandle_t handle, int64_t n, const double* x, int64_t incx, double* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasScnrm2_64(cublasHandle_t handle, int64_t n, const cuComplex* x, int64_t incx, float* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDznrm2_64(cublasHandle_t handle, int64_t n, const cuDoubleComplex* x, int64_t incx, double* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDotEx_64(cublasHandle_t handle, int64_t n, const void* x, cudaDataType xType, int64_t incx, const void* y, cudaDataType yType, int64_t incy, void* result, cudaDataType resultType, cudaDataType executionType) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDotcEx_64(cublasHandle_t handle, int64_t n, const void* x, cudaDataType xType, int64_t incx, const void* y, cudaDataType yType, int64_t incy, void* result, cudaDataType resultType, cudaDataType executionType) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSdot_64(cublasHandle_t handle, int64_t n, const float* x, int64_t incx, const float* y, int64_t incy, float* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDdot_64(cublasHandle_t handle, int64_t n, const double* x, int64_t incx, const double* y, int64_t incy, double* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCdotu_64(cublasHandle_t handle, int64_t n, const cuComplex* x, int64_t incx, const cuComplex* y, int64_t incy, cuComplex* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCdotc_64(cublasHandle_t handle, int64_t n, const cuComplex* x, int64_t incx, const cuComplex* y, int64_t incy, cuComplex* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZdotu_64(cublasHandle_t handle, int64_t n, const cuDoubleComplex* x, int64_t incx, const cuDoubleComplex* y, int64_t incy, cuDoubleComplex* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZdotc_64(cublasHandle_t handle, int64_t n, const cuDoubleComplex* x, int64_t incx, const cuDoubleComplex* y, int64_t incy, cuDoubleComplex* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasScalEx_64(cublasHandle_t handle, int64_t n, const void* alpha, cudaDataType alphaType, void* x, cudaDataType xType, int64_t incx, cudaDataType executionType) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSscal_64(cublasHandle_t handle, int64_t n, const float* alpha, float* x, int64_t incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDscal_64(cublasHandle_t handle, int64_t n, const double* alpha, double* x, int64_t incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCscal_64(cublasHandle_t handle, int64_t n, const cuComplex* alpha, cuComplex* x, int64_t incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCsscal_64(cublasHandle_t handle, int64_t n, const float* alpha, cuComplex* x, int64_t incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZscal_64(cublasHandle_t handle, int64_t n, const cuDoubleComplex* alpha, cuDoubleComplex* x, int64_t incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZdscal_64(cublasHandle_t handle, int64_t n, const double* alpha, cuDoubleComplex* x, int64_t incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasAxpyEx_64(cublasHandle_t handle, int64_t n, const void* alpha, cudaDataType alphaType, const void* x, cudaDataType xType, int64_t incx, void* y, cudaDataType yType, int64_t incy, cudaDataType executiontype) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSaxpy_64(cublasHandle_t handle, int64_t n, const float* alpha, const float* x, int64_t incx, float* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDaxpy_64(cublasHandle_t handle, int64_t n, const double* alpha, const double* x, int64_t incx, double* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCaxpy_64(cublasHandle_t handle, int64_t n, const cuComplex* alpha, const cuComplex* x, int64_t incx, cuComplex* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZaxpy_64(cublasHandle_t handle, int64_t n, const cuDoubleComplex* alpha, const cuDoubleComplex* x, int64_t incx, cuDoubleComplex* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCopyEx_64(cublasHandle_t handle, int64_t n, const void* x, cudaDataType xType, int64_t incx, void* y, cudaDataType yType, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasScopy_64(cublasHandle_t handle, int64_t n, const float* x, int64_t incx, float* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDcopy_64(cublasHandle_t handle, int64_t n, const double* x, int64_t incx, double* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCcopy_64(cublasHandle_t handle, int64_t n, const cuComplex* x, int64_t incx, cuComplex* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZcopy_64(cublasHandle_t handle, int64_t n, const cuDoubleComplex* x, int64_t incx, cuDoubleComplex* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSswap_64(cublasHandle_t handle, int64_t n, float* x, int64_t incx, float* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDswap_64(cublasHandle_t handle, int64_t n, double* x, int64_t incx, double* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCswap_64(cublasHandle_t handle, int64_t n, cuComplex* x, int64_t incx, cuComplex* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZswap_64(cublasHandle_t handle, int64_t n, cuDoubleComplex* x, int64_t incx, cuDoubleComplex* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSwapEx_64(cublasHandle_t handle, int64_t n, void* x, cudaDataType xType, int64_t incx, void* y, cudaDataType yType, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasIsamax_64(cublasHandle_t handle, int64_t n, const float* x, int64_t incx, int64_t* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasIdamax_64(cublasHandle_t handle, int64_t n, const double* x, int64_t incx, int64_t* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasIcamax_64(cublasHandle_t handle, int64_t n, const cuComplex* x, int64_t incx, int64_t* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasIzamax_64(cublasHandle_t handle, int64_t n, const cuDoubleComplex* x, int64_t incx, int64_t* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasIamaxEx_64(cublasHandle_t handle, int64_t n, const void* x, cudaDataType xType, int64_t incx, int64_t* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasIsamin_64(cublasHandle_t handle, int64_t n, const float* x, int64_t incx, int64_t* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasIdamin_64(cublasHandle_t handle, int64_t n, const double* x, int64_t incx, int64_t* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasIcamin_64(cublasHandle_t handle, int64_t n, const cuComplex* x, int64_t incx, int64_t* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasIzamin_64(cublasHandle_t handle, int64_t n, const cuDoubleComplex* x, int64_t incx, int64_t* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasIaminEx_64(cublasHandle_t handle, int64_t n, const void* x, cudaDataType xType, int64_t incx, int64_t* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasAsumEx_64(cublasHandle_t handle, int64_t n, const void* x, cudaDataType xType, int64_t incx, void* result, cudaDataType resultType, cudaDataType executiontype) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSasum_64(cublasHandle_t handle, int64_t n, const float* x, int64_t incx, float* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDasum_64(cublasHandle_t handle, int64_t n, const double* x, int64_t incx, double* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasScasum_64(cublasHandle_t handle, int64_t n, const cuComplex* x, int64_t incx, float* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDzasum_64(cublasHandle_t handle, int64_t n, const cuDoubleComplex* x, int64_t incx, double* result) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSrot_64(cublasHandle_t handle, int64_t n, float* x, int64_t incx, float* y, int64_t incy, const float* c, const float* s) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDrot_64(cublasHandle_t handle, int64_t n, double* x, int64_t incx, double* y, int64_t incy, const double* c, const double* s) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCrot_64(cublasHandle_t handle, int64_t n, cuComplex* x, int64_t incx, cuComplex* y, int64_t incy, const float* c, const cuComplex* s) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCsrot_64(cublasHandle_t handle, int64_t n, cuComplex* x, int64_t incx, cuComplex* y, int64_t incy, const float* c, const float* s) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZrot_64(cublasHandle_t handle, int64_t n, cuDoubleComplex* x, int64_t incx, cuDoubleComplex* y, int64_t incy, const double* c, const cuDoubleComplex* s) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZdrot_64(cublasHandle_t handle, int64_t n, cuDoubleComplex* x, int64_t incx, cuDoubleComplex* y, int64_t incy, const double* c, const double* s) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasRotEx_64(cublasHandle_t handle, int64_t n, void* x, cudaDataType xType, int64_t incx, void* y, cudaDataType yType, int64_t incy, const void* c, const void* s, cudaDataType csType, cudaDataType executiontype) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSrotm_64(cublasHandle_t handle, int64_t n, float* x, int64_t incx, float* y, int64_t incy, const float* param) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDrotm_64(cublasHandle_t handle, int64_t n, double* x, int64_t incx, double* y, int64_t incy, const double* param) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasRotmEx_64(cublasHandle_t handle, int64_t n, void* x, cudaDataType xType, int64_t incx, void* y, cudaDataType yType, int64_t incy, const void* param, cudaDataType paramType, cudaDataType executiontype) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSgemv_64(cublasHandle_t handle, cublasOperation_t trans, int64_t m, int64_t n, const float* alpha, const float* A, int64_t lda, const float* x, int64_t incx, const float* beta, float* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDgemv_64(cublasHandle_t handle, cublasOperation_t trans, int64_t m, int64_t n, const double* alpha, const double* A, int64_t lda, const double* x, int64_t incx, const double* beta, double* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgemv_64(cublasHandle_t handle, cublasOperation_t trans, int64_t m, int64_t n, const cuComplex* alpha, const cuComplex* A, int64_t lda, const cuComplex* x, int64_t incx, const cuComplex* beta, cuComplex* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZgemv_64(cublasHandle_t handle, cublasOperation_t trans, int64_t m, int64_t n, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int64_t lda, const cuDoubleComplex* x, int64_t incx, const cuDoubleComplex* beta, cuDoubleComplex* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSgbmv_64(cublasHandle_t handle, cublasOperation_t trans, int64_t m, int64_t n, int64_t kl, int64_t ku, const float* alpha, const float* A, int64_t lda, const float* x, int64_t incx, const float* beta, float* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDgbmv_64(cublasHandle_t handle, cublasOperation_t trans, int64_t m, int64_t n, int64_t kl, int64_t ku, const double* alpha, const double* A, int64_t lda, const double* x, int64_t incx, const double* beta, double* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgbmv_64(cublasHandle_t handle, cublasOperation_t trans, int64_t m, int64_t n, int64_t kl, int64_t ku, const cuComplex* alpha, const cuComplex* A, int64_t lda, const cuComplex* x, int64_t incx, const cuComplex* beta, cuComplex* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZgbmv_64(cublasHandle_t handle, cublasOperation_t trans, int64_t m, int64_t n, int64_t kl, int64_t ku, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int64_t lda, const cuDoubleComplex* x, int64_t incx, const cuDoubleComplex* beta, cuDoubleComplex* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasStrmv_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t n, const float* A, int64_t lda, float* x, int64_t incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDtrmv_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t n, const double* A, int64_t lda, double* x, int64_t incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCtrmv_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t n, const cuComplex* A, int64_t lda, cuComplex* x, int64_t incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZtrmv_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t n, const cuDoubleComplex* A, int64_t lda, cuDoubleComplex* x, int64_t incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasStbmv_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t n, int64_t k, const float* A, int64_t lda, float* x, int64_t incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDtbmv_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t n, int64_t k, const double* A, int64_t lda, double* x, int64_t incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCtbmv_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t n, int64_t k, const cuComplex* A, int64_t lda, cuComplex* x, int64_t incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZtbmv_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t n, int64_t k, const cuDoubleComplex* A, int64_t lda, cuDoubleComplex* x, int64_t incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasStpmv_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t n, const float* AP, float* x, int64_t incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDtpmv_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t n, const double* AP, double* x, int64_t incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCtpmv_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t n, const cuComplex* AP, cuComplex* x, int64_t incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZtpmv_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t n, const cuDoubleComplex* AP, cuDoubleComplex* x, int64_t incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasStrsv_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t n, const float* A, int64_t lda, float* x, int64_t incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDtrsv_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t n, const double* A, int64_t lda, double* x, int64_t incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCtrsv_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t n, const cuComplex* A, int64_t lda, cuComplex* x, int64_t incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZtrsv_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t n, const cuDoubleComplex* A, int64_t lda, cuDoubleComplex* x, int64_t incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasStpsv_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t n, const float* AP, float* x, int64_t incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDtpsv_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t n, const double* AP, double* x, int64_t incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCtpsv_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t n, const cuComplex* AP, cuComplex* x, int64_t incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZtpsv_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t n, const cuDoubleComplex* AP, cuDoubleComplex* x, int64_t incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasStbsv_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t n, int64_t k, const float* A, int64_t lda, float* x, int64_t incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDtbsv_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t n, int64_t k, const double* A, int64_t lda, double* x, int64_t incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCtbsv_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t n, int64_t k, const cuComplex* A, int64_t lda, cuComplex* x, int64_t incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZtbsv_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t n, int64_t k, const cuDoubleComplex* A, int64_t lda, cuDoubleComplex* x, int64_t incx) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSsymv_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, const float* alpha, const float* A, int64_t lda, const float* x, int64_t incx, const float* beta, float* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDsymv_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, const double* alpha, const double* A, int64_t lda, const double* x, int64_t incx, const double* beta, double* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCsymv_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, const cuComplex* alpha, const cuComplex* A, int64_t lda, const cuComplex* x, int64_t incx, const cuComplex* beta, cuComplex* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZsymv_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int64_t lda, const cuDoubleComplex* x, int64_t incx, const cuDoubleComplex* beta, cuDoubleComplex* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasChemv_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, const cuComplex* alpha, const cuComplex* A, int64_t lda, const cuComplex* x, int64_t incx, const cuComplex* beta, cuComplex* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZhemv_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int64_t lda, const cuDoubleComplex* x, int64_t incx, const cuDoubleComplex* beta, cuDoubleComplex* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSsbmv_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, int64_t k, const float* alpha, const float* A, int64_t lda, const float* x, int64_t incx, const float* beta, float* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDsbmv_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, int64_t k, const double* alpha, const double* A, int64_t lda, const double* x, int64_t incx, const double* beta, double* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasChbmv_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, int64_t k, const cuComplex* alpha, const cuComplex* A, int64_t lda, const cuComplex* x, int64_t incx, const cuComplex* beta, cuComplex* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZhbmv_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, int64_t k, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int64_t lda, const cuDoubleComplex* x, int64_t incx, const cuDoubleComplex* beta, cuDoubleComplex* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSspmv_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, const float* alpha, const float* AP, const float* x, int64_t incx, const float* beta, float* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDspmv_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, const double* alpha, const double* AP, const double* x, int64_t incx, const double* beta, double* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasChpmv_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, const cuComplex* alpha, const cuComplex* AP, const cuComplex* x, int64_t incx, const cuComplex* beta, cuComplex* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZhpmv_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, const cuDoubleComplex* alpha, const cuDoubleComplex* AP, const cuDoubleComplex* x, int64_t incx, const cuDoubleComplex* beta, cuDoubleComplex* y, int64_t incy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSger_64(cublasHandle_t handle, int64_t m, int64_t n, const float* alpha, const float* x, int64_t incx, const float* y, int64_t incy, float* A, int64_t lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDger_64(cublasHandle_t handle, int64_t m, int64_t n, const double* alpha, const double* x, int64_t incx, const double* y, int64_t incy, double* A, int64_t lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgeru_64(cublasHandle_t handle, int64_t m, int64_t n, const cuComplex* alpha, const cuComplex* x, int64_t incx, const cuComplex* y, int64_t incy, cuComplex* A, int64_t lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgerc_64(cublasHandle_t handle, int64_t m, int64_t n, const cuComplex* alpha, const cuComplex* x, int64_t incx, const cuComplex* y, int64_t incy, cuComplex* A, int64_t lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZgeru_64(cublasHandle_t handle, int64_t m, int64_t n, const cuDoubleComplex* alpha, const cuDoubleComplex* x, int64_t incx, const cuDoubleComplex* y, int64_t incy, cuDoubleComplex* A, int64_t lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZgerc_64(cublasHandle_t handle, int64_t m, int64_t n, const cuDoubleComplex* alpha, const cuDoubleComplex* x, int64_t incx, const cuDoubleComplex* y, int64_t incy, cuDoubleComplex* A, int64_t lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSsyr_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, const float* alpha, const float* x, int64_t incx, float* A, int64_t lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDsyr_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, const double* alpha, const double* x, int64_t incx, double* A, int64_t lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCsyr_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, const cuComplex* alpha, const cuComplex* x, int64_t incx, cuComplex* A, int64_t lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZsyr_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, const cuDoubleComplex* alpha, const cuDoubleComplex* x, int64_t incx, cuDoubleComplex* A, int64_t lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCher_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, const float* alpha, const cuComplex* x, int64_t incx, cuComplex* A, int64_t lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZher_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, const double* alpha, const cuDoubleComplex* x, int64_t incx, cuDoubleComplex* A, int64_t lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSspr_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, const float* alpha, const float* x, int64_t incx, float* AP) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDspr_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, const double* alpha, const double* x, int64_t incx, double* AP) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasChpr_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, const float* alpha, const cuComplex* x, int64_t incx, cuComplex* AP) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZhpr_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, const double* alpha, const cuDoubleComplex* x, int64_t incx, cuDoubleComplex* AP) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSsyr2_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, const float* alpha, const float* x, int64_t incx, const float* y, int64_t incy, float* A, int64_t lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDsyr2_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, const double* alpha, const double* x, int64_t incx, const double* y, int64_t incy, double* A, int64_t lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCsyr2_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, const cuComplex* alpha, const cuComplex* x, int64_t incx, const cuComplex* y, int64_t incy, cuComplex* A, int64_t lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZsyr2_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, const cuDoubleComplex* alpha, const cuDoubleComplex* x, int64_t incx, const cuDoubleComplex* y, int64_t incy, cuDoubleComplex* A, int64_t lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCher2_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, const cuComplex* alpha, const cuComplex* x, int64_t incx, const cuComplex* y, int64_t incy, cuComplex* A, int64_t lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZher2_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, const cuDoubleComplex* alpha, const cuDoubleComplex* x, int64_t incx, const cuDoubleComplex* y, int64_t incy, cuDoubleComplex* A, int64_t lda) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSspr2_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, const float* alpha, const float* x, int64_t incx, const float* y, int64_t incy, float* AP) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDspr2_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, const double* alpha, const double* x, int64_t incx, const double* y, int64_t incy, double* AP) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasChpr2_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, const cuComplex* alpha, const cuComplex* x, int64_t incx, const cuComplex* y, int64_t incy, cuComplex* AP) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZhpr2_64(cublasHandle_t handle, cublasFillMode_t uplo, int64_t n, const cuDoubleComplex* alpha, const cuDoubleComplex* x, int64_t incx, const cuDoubleComplex* y, int64_t incy, cuDoubleComplex* AP) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSgemvBatched_64(cublasHandle_t handle, cublasOperation_t trans, int64_t m, int64_t n, const float* alpha, const float* const Aarray[], int64_t lda, const float* const xarray[], int64_t incx, const float* beta, float* const yarray[], int64_t incy, int64_t batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDgemvBatched_64(cublasHandle_t handle, cublasOperation_t trans, int64_t m, int64_t n, const double* alpha, const double* const Aarray[], int64_t lda, const double* const xarray[], int64_t incx, const double* beta, double* const yarray[], int64_t incy, int64_t batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgemvBatched_64(cublasHandle_t handle, cublasOperation_t trans, int64_t m, int64_t n, const cuComplex* alpha, const cuComplex* const Aarray[], int64_t lda, const cuComplex* const xarray[], int64_t incx, const cuComplex* beta, cuComplex* const yarray[], int64_t incy, int64_t batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZgemvBatched_64(cublasHandle_t handle, cublasOperation_t trans, int64_t m, int64_t n, const cuDoubleComplex* alpha, const cuDoubleComplex* const Aarray[], int64_t lda, const cuDoubleComplex* const xarray[], int64_t incx, const cuDoubleComplex* beta, cuDoubleComplex* const yarray[], int64_t incy, int64_t batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSgemvStridedBatched_64(cublasHandle_t handle, cublasOperation_t trans, int64_t m, int64_t n, const float* alpha, const float* A, int64_t lda, long long int strideA, const float* x, int64_t incx, long long int stridex, const float* beta, float* y, int64_t incy, long long int stridey, int64_t batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDgemvStridedBatched_64(cublasHandle_t handle, cublasOperation_t trans, int64_t m, int64_t n, const double* alpha, const double* A, int64_t lda, long long int strideA, const double* x, int64_t incx, long long int stridex, const double* beta, double* y, int64_t incy, long long int stridey, int64_t batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgemvStridedBatched_64(cublasHandle_t handle, cublasOperation_t trans, int64_t m, int64_t n, const cuComplex* alpha, const cuComplex* A, int64_t lda, long long int strideA, const cuComplex* x, int64_t incx, long long int stridex, const cuComplex* beta, cuComplex* y, int64_t incy, long long int stridey, int64_t batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZgemvStridedBatched_64(cublasHandle_t handle, cublasOperation_t trans, int64_t m, int64_t n, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int64_t lda, long long int strideA, const cuDoubleComplex* x, int64_t incx, long long int stridex, const cuDoubleComplex* beta, cuDoubleComplex* y, int64_t incy, long long int stridey, int64_t batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSgemm_64(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int64_t m, int64_t n, int64_t k, const float* alpha, const float* A, int64_t lda, const float* B, int64_t ldb, const float* beta, float* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDgemm_64(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int64_t m, int64_t n, int64_t k, const double* alpha, const double* A, int64_t lda, const double* B, int64_t ldb, const double* beta, double* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgemm_64(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int64_t m, int64_t n, int64_t k, const cuComplex* alpha, const cuComplex* A, int64_t lda, const cuComplex* B, int64_t ldb, const cuComplex* beta, cuComplex* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgemm3m_64(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int64_t m, int64_t n, int64_t k, const cuComplex* alpha, const cuComplex* A, int64_t lda, const cuComplex* B, int64_t ldb, const cuComplex* beta, cuComplex* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgemm3mEx_64(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int64_t m, int64_t n, int64_t k, const cuComplex* alpha, const void* A, cudaDataType Atype, int64_t lda, const void* B, cudaDataType Btype, int64_t ldb, const cuComplex* beta, void* C, cudaDataType Ctype, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZgemm_64(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int64_t m, int64_t n, int64_t k, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int64_t lda, const cuDoubleComplex* B, int64_t ldb, const cuDoubleComplex* beta, cuDoubleComplex* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZgemm3m_64(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int64_t m, int64_t n, int64_t k, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int64_t lda, const cuDoubleComplex* B, int64_t ldb, const cuDoubleComplex* beta, cuDoubleComplex* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSgemmEx_64(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int64_t m, int64_t n, int64_t k, const float* alpha, const void* A, cudaDataType Atype, int64_t lda, const void* B, cudaDataType Btype, int64_t ldb, const float* beta, void* C, cudaDataType Ctype, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasGemmEx_64(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int64_t m, int64_t n, int64_t k, const void* alpha, const void* A, cudaDataType Atype, int64_t lda, const void* B, cudaDataType Btype, int64_t ldb, const void* beta, void* C, cudaDataType Ctype, int64_t ldc, cublasComputeType_t computeType, cublasGemmAlgo_t algo) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgemmEx_64(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int64_t m, int64_t n, int64_t k, const cuComplex* alpha, const void* A, cudaDataType Atype, int64_t lda, const void* B, cudaDataType Btype, int64_t ldb, const cuComplex* beta, void* C, cudaDataType Ctype, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSsyrk_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int64_t n, int64_t k, const float* alpha, const float* A, int64_t lda, const float* beta, float* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDsyrk_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int64_t n, int64_t k, const double* alpha, const double* A, int64_t lda, const double* beta, double* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCsyrk_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int64_t n, int64_t k, const cuComplex* alpha, const cuComplex* A, int64_t lda, const cuComplex* beta, cuComplex* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZsyrk_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int64_t n, int64_t k, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int64_t lda, const cuDoubleComplex* beta, cuDoubleComplex* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCsyrkEx_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int64_t n, int64_t k, const cuComplex* alpha, const void* A, cudaDataType Atype, int64_t lda, const cuComplex* beta, void* C, cudaDataType Ctype, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCsyrk3mEx_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int64_t n, int64_t k, const cuComplex* alpha, const void* A, cudaDataType Atype, int64_t lda, const cuComplex* beta, void* C, cudaDataType Ctype, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCherk_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int64_t n, int64_t k, const float* alpha, const cuComplex* A, int64_t lda, const float* beta, cuComplex* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZherk_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int64_t n, int64_t k, const double* alpha, const cuDoubleComplex* A, int64_t lda, const double* beta, cuDoubleComplex* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCherkEx_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int64_t n, int64_t k, const float* alpha, const void* A, cudaDataType Atype, int64_t lda, const float* beta, void* C, cudaDataType Ctype, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCherk3mEx_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int64_t n, int64_t k, const float* alpha, const void* A, cudaDataType Atype, int64_t lda, const float* beta, void* C, cudaDataType Ctype, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSsyr2k_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int64_t n, int64_t k, const float* alpha, const float* A, int64_t lda, const float* B, int64_t ldb, const float* beta, float* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDsyr2k_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int64_t n, int64_t k, const double* alpha, const double* A, int64_t lda, const double* B, int64_t ldb, const double* beta, double* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCsyr2k_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int64_t n, int64_t k, const cuComplex* alpha, const cuComplex* A, int64_t lda, const cuComplex* B, int64_t ldb, const cuComplex* beta, cuComplex* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZsyr2k_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int64_t n, int64_t k, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int64_t lda, const cuDoubleComplex* B, int64_t ldb, const cuDoubleComplex* beta, cuDoubleComplex* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCher2k_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int64_t n, int64_t k, const cuComplex* alpha, const cuComplex* A, int64_t lda, const cuComplex* B, int64_t ldb, const float* beta, cuComplex* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZher2k_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int64_t n, int64_t k, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int64_t lda, const cuDoubleComplex* B, int64_t ldb, const double* beta, cuDoubleComplex* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSsyrkx_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int64_t n, int64_t k, const float* alpha, const float* A, int64_t lda, const float* B, int64_t ldb, const float* beta, float* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDsyrkx_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int64_t n, int64_t k, const double* alpha, const double* A, int64_t lda, const double* B, int64_t ldb, const double* beta, double* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCsyrkx_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int64_t n, int64_t k, const cuComplex* alpha, const cuComplex* A, int64_t lda, const cuComplex* B, int64_t ldb, const cuComplex* beta, cuComplex* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZsyrkx_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int64_t n, int64_t k, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int64_t lda, const cuDoubleComplex* B, int64_t ldb, const cuDoubleComplex* beta, cuDoubleComplex* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCherkx_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int64_t n, int64_t k, const cuComplex* alpha, const cuComplex* A, int64_t lda, const cuComplex* B, int64_t ldb, const float* beta, cuComplex* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZherkx_64(cublasHandle_t handle, cublasFillMode_t uplo, cublasOperation_t trans, int64_t n, int64_t k, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int64_t lda, const cuDoubleComplex* B, int64_t ldb, const double* beta, cuDoubleComplex* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSsymm_64(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, int64_t m, int64_t n, const float* alpha, const float* A, int64_t lda, const float* B, int64_t ldb, const float* beta, float* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDsymm_64(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, int64_t m, int64_t n, const double* alpha, const double* A, int64_t lda, const double* B, int64_t ldb, const double* beta, double* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCsymm_64(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, int64_t m, int64_t n, const cuComplex* alpha, const cuComplex* A, int64_t lda, const cuComplex* B, int64_t ldb, const cuComplex* beta, cuComplex* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZsymm_64(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, int64_t m, int64_t n, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int64_t lda, const cuDoubleComplex* B, int64_t ldb, const cuDoubleComplex* beta, cuDoubleComplex* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasChemm_64(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, int64_t m, int64_t n, const cuComplex* alpha, const cuComplex* A, int64_t lda, const cuComplex* B, int64_t ldb, const cuComplex* beta, cuComplex* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZhemm_64(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, int64_t m, int64_t n, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int64_t lda, const cuDoubleComplex* B, int64_t ldb, const cuDoubleComplex* beta, cuDoubleComplex* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasStrsm_64(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t m, int64_t n, const float* alpha, const float* A, int64_t lda, float* B, int64_t ldb) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDtrsm_64(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t m, int64_t n, const double* alpha, const double* A, int64_t lda, double* B, int64_t ldb) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCtrsm_64(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t m, int64_t n, const cuComplex* alpha, const cuComplex* A, int64_t lda, cuComplex* B, int64_t ldb) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZtrsm_64(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t m, int64_t n, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int64_t lda, cuDoubleComplex* B, int64_t ldb) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasStrmm_64(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t m, int64_t n, const float* alpha, const float* A, int64_t lda, const float* B, int64_t ldb, float* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDtrmm_64(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t m, int64_t n, const double* alpha, const double* A, int64_t lda, const double* B, int64_t ldb, double* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCtrmm_64(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t m, int64_t n, const cuComplex* alpha, const cuComplex* A, int64_t lda, const cuComplex* B, int64_t ldb, cuComplex* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZtrmm_64(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t m, int64_t n, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int64_t lda, const cuDoubleComplex* B, int64_t ldb, cuDoubleComplex* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSgemmBatched_64(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int64_t m, int64_t n, int64_t k, const float* alpha, const float* const Aarray[], int64_t lda, const float* const Barray[], int64_t ldb, const float* beta, float* const Carray[], int64_t ldc, int64_t batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDgemmBatched_64(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int64_t m, int64_t n, int64_t k, const double* alpha, const double* const Aarray[], int64_t lda, const double* const Barray[], int64_t ldb, const double* beta, double* const Carray[], int64_t ldc, int64_t batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgemmBatched_64(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int64_t m, int64_t n, int64_t k, const cuComplex* alpha, const cuComplex* const Aarray[], int64_t lda, const cuComplex* const Barray[], int64_t ldb, const cuComplex* beta, cuComplex* const Carray[], int64_t ldc, int64_t batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgemm3mBatched_64(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int64_t m, int64_t n, int64_t k, const cuComplex* alpha, const cuComplex* const Aarray[], int64_t lda, const cuComplex* const Barray[], int64_t ldb, const cuComplex* beta, cuComplex* const Carray[], int64_t ldc, int64_t batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZgemmBatched_64(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int64_t m, int64_t n, int64_t k, const cuDoubleComplex* alpha, const cuDoubleComplex* const Aarray[], int64_t lda, const cuDoubleComplex* const Barray[], int64_t ldb, const cuDoubleComplex* beta, cuDoubleComplex* const Carray[], int64_t ldc, int64_t batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSgemmStridedBatched_64(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int64_t m, int64_t n, int64_t k, const float* alpha, const float* A, int64_t lda, long long int strideA, const float* B, int64_t ldb, long long int strideB, const float* beta, float* C, int64_t ldc, long long int strideC, int64_t batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDgemmStridedBatched_64(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int64_t m, int64_t n, int64_t k, const double* alpha, const double* A, int64_t lda, long long int strideA, const double* B, int64_t ldb, long long int strideB, const double* beta, double* C, int64_t ldc, long long int strideC, int64_t batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgemmStridedBatched_64(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int64_t m, int64_t n, int64_t k, const cuComplex* alpha, const cuComplex* A, int64_t lda, long long int strideA, const cuComplex* B, int64_t ldb, long long int strideB, const cuComplex* beta, cuComplex* C, int64_t ldc, long long int strideC, int64_t batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgemm3mStridedBatched_64(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int64_t m, int64_t n, int64_t k, const cuComplex* alpha, const cuComplex* A, int64_t lda, long long int strideA, const cuComplex* B, int64_t ldb, long long int strideB, const cuComplex* beta, cuComplex* C, int64_t ldc, long long int strideC, int64_t batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZgemmStridedBatched_64(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int64_t m, int64_t n, int64_t k, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int64_t lda, long long int strideA, const cuDoubleComplex* B, int64_t ldb, long long int strideB, const cuDoubleComplex* beta, cuDoubleComplex* C, int64_t ldc, long long int strideC, int64_t batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasGemmBatchedEx_64(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int64_t m, int64_t n, int64_t k, const void* alpha, const void* const Aarray[], cudaDataType Atype, int64_t lda, const void* const Barray[], cudaDataType Btype, int64_t ldb, const void* beta, void* const Carray[], cudaDataType Ctype, int64_t ldc, int64_t batchCount, cublasComputeType_t computeType, cublasGemmAlgo_t algo) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasGemmStridedBatchedEx_64(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int64_t m, int64_t n, int64_t k, const void* alpha, const void* A, cudaDataType Atype, int64_t lda, long long int strideA, const void* B, cudaDataType Btype, int64_t ldb, long long int strideB, const void* beta, void* C, cudaDataType Ctype, int64_t ldc, long long int strideC, int64_t batchCount, cublasComputeType_t computeType, cublasGemmAlgo_t algo) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSgeam_64(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int64_t m, int64_t n, const float* alpha, const float* A, int64_t lda, const float* beta, const float* B, int64_t ldb, float* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDgeam_64(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int64_t m, int64_t n, const double* alpha, const double* A, int64_t lda, const double* beta, const double* B, int64_t ldb, double* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCgeam_64(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int64_t m, int64_t n, const cuComplex* alpha, const cuComplex* A, int64_t lda, const cuComplex* beta, const cuComplex* B, int64_t ldb, cuComplex* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZgeam_64(cublasHandle_t handle, cublasOperation_t transa, cublasOperation_t transb, int64_t m, int64_t n, const cuDoubleComplex* alpha, const cuDoubleComplex* A, int64_t lda, const cuDoubleComplex* beta, const cuDoubleComplex* B, int64_t ldb, cuDoubleComplex* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasStrsmBatched_64(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t m, int64_t n, const float* alpha, const float* const A[], int64_t lda, float* const B[], int64_t ldb, int64_t batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDtrsmBatched_64(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t m, int64_t n, const double* alpha, const double* const A[], int64_t lda, double* const B[], int64_t ldb, int64_t batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCtrsmBatched_64(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t m, int64_t n, const cuComplex* alpha, const cuComplex* const A[], int64_t lda, cuComplex* const B[], int64_t ldb, int64_t batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZtrsmBatched_64(cublasHandle_t handle, cublasSideMode_t side, cublasFillMode_t uplo, cublasOperation_t trans, cublasDiagType_t diag, int64_t m, int64_t n, const cuDoubleComplex* alpha, const cuDoubleComplex* const A[], int64_t lda, cuDoubleComplex* const B[], int64_t ldb, int64_t batchCount) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSdgmm_64(cublasHandle_t handle, cublasSideMode_t mode, int64_t m, int64_t n, const float* A, int64_t lda, const float* x, int64_t incx, float* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDdgmm_64(cublasHandle_t handle, cublasSideMode_t mode, int64_t m, int64_t n, const double* A, int64_t lda, const double* x, int64_t incx, double* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasCdgmm_64(cublasHandle_t handle, cublasSideMode_t mode, int64_t m, int64_t n, const cuComplex* A, int64_t lda, const cuComplex* x, int64_t incx, cuComplex* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasZdgmm_64(cublasHandle_t handle, cublasSideMode_t mode, int64_t m, int64_t n, const cuDoubleComplex* A, int64_t lda, const cuDoubleComplex* x, int64_t incx, cuDoubleComplex* C, int64_t ldc) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSgemmGroupedBatched(cublasHandle_t handle, const cublasOperation_t transa_array[], const cublasOperation_t transb_array[], const int m_array[], const int n_array[], const int k_array[], const float alpha_array[], const float* const Aarray[], const int lda_array[], const float* const Barray[], const int ldb_array[], const float beta_array[], float* const Carray[], const int ldc_array[], int group_count, const int group_size[]) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSgemmGroupedBatched_64(cublasHandle_t handle, const cublasOperation_t transa_array[], const cublasOperation_t transb_array[], const int64_t m_array[], const int64_t n_array[], const int64_t k_array[], const float alpha_array[], const float* const Aarray[], const int64_t lda_array[], const float* const Barray[], const int64_t ldb_array[], const float beta_array[], float* const Carray[], const int64_t ldc_array[], int64_t group_count, const int64_t group_size[]) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDgemmGroupedBatched(cublasHandle_t handle, const cublasOperation_t transa_array[], const cublasOperation_t transb_array[], const int m_array[], const int n_array[], const int k_array[], const double alpha_array[], const double* const Aarray[], const int lda_array[], const double* const Barray[], const int ldb_array[], const double beta_array[], double* const Carray[], const int ldc_array[], int group_count, const int group_size[]) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasDgemmGroupedBatched_64(cublasHandle_t handle, const cublasOperation_t transa_array[], const cublasOperation_t transb_array[], const int64_t m_array[], const int64_t n_array[], const int64_t k_array[], const double alpha_array[], const double* const Aarray[], const int64_t lda_array[], const double* const Barray[], const int64_t ldb_array[], const double beta_array[], double* const Carray[], const int64_t ldc_array[], int64_t group_count, const int64_t group_size[]) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasGemmGroupedBatchedEx(cublasHandle_t handle, const cublasOperation_t transa_array[], const cublasOperation_t transb_array[], const int m_array[], const int n_array[], const int k_array[], const void* alpha_array, const void* const Aarray[], cudaDataType_t Atype, const int lda_array[], const void* const Barray[], cudaDataType_t Btype, const int ldb_array[], const void* beta_array, void* const Carray[], cudaDataType_t Ctype, const int ldc_array[], int group_count, const int group_size[], cublasComputeType_t computeType) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasGemmGroupedBatchedEx_64(cublasHandle_t handle, const cublasOperation_t transa_array[], const cublasOperation_t transb_array[], const int64_t m_array[], const int64_t n_array[], const int64_t k_array[], const void* alpha_array, const void* const Aarray[], cudaDataType_t Atype, const int64_t lda_array[], const void* const Barray[], cudaDataType_t Btype, const int64_t ldb_array[], const void* beta_array, void* const Carray[], cudaDataType_t Ctype, const int64_t ldc_array[], int64_t group_count, const int64_t group_size[], cublasComputeType_t computeType) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasGetEmulationStrategy(cublasHandle_t handle, cublasEmulationStrategy_t* emulationStrategy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
cdef cublasStatus_t _cublasSetEmulationStrategy(cublasHandle_t handle, cublasEmulationStrategy_t emulationStrategy) except?_CUBLASSTATUS_T_INTERNAL_LOADING_ERROR nogil
