# Copyright (c) 2024-2025, NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
#
# SPDX-License-Identifier: Apache-2.0

import _cython_3_0_12
import enum
from typing import Any, Callable, ClassVar

__pyx_capi__: dict
__test__: dict
check_status: _cython_3_0_12.cython_function_or_method
config_create: _cython_3_0_12.cython_function_or_method
config_destroy: _cython_3_0_12.cython_function_or_method
config_get: _cython_3_0_12.cython_function_or_method
config_set: _cython_3_0_12.cython_function_or_method
create: _cython_3_0_12.cython_function_or_method
data_create: _cython_3_0_12.cython_function_or_method
data_destroy: _cython_3_0_12.cython_function_or_method
data_get: _cython_3_0_12.cython_function_or_method
data_set: _cython_3_0_12.cython_function_or_method
destroy: _cython_3_0_12.cython_function_or_method
execute: _cython_3_0_12.cython_function_or_method
get_config_param_dtype: _cython_3_0_12.cython_function_or_method
get_data_param_dtype: _cython_3_0_12.cython_function_or_method
get_device_mem_handler: _cython_3_0_12.cython_function_or_method
get_property: _cython_3_0_12.cython_function_or_method
matrix_create_batch_csr: _cython_3_0_12.cython_function_or_method
matrix_create_batch_dn: _cython_3_0_12.cython_function_or_method
matrix_create_csr: _cython_3_0_12.cython_function_or_method
matrix_create_dn: _cython_3_0_12.cython_function_or_method
matrix_destroy: _cython_3_0_12.cython_function_or_method
matrix_get_batch_csr: _cython_3_0_12.cython_function_or_method
matrix_get_batch_dn: _cython_3_0_12.cython_function_or_method
matrix_get_csr: _cython_3_0_12.cython_function_or_method
matrix_get_dn: _cython_3_0_12.cython_function_or_method
matrix_get_format: _cython_3_0_12.cython_function_or_method
matrix_set_batch_csr_pointers: _cython_3_0_12.cython_function_or_method
matrix_set_batch_values: _cython_3_0_12.cython_function_or_method
matrix_set_csr_pointers: _cython_3_0_12.cython_function_or_method
matrix_set_values: _cython_3_0_12.cython_function_or_method
set_comm_layer: _cython_3_0_12.cython_function_or_method
set_device_mem_handler: _cython_3_0_12.cython_function_or_method
set_stream: _cython_3_0_12.cython_function_or_method
set_threading_layer: _cython_3_0_12.cython_function_or_method

class AlgType(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    ALG_1: ClassVar[AlgType] = ...
    ALG_2: ClassVar[AlgType] = ...
    ALG_3: ClassVar[AlgType] = ...
    ALG_DEFAULT: ClassVar[AlgType] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class ConfigParam(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    FACTORIZATION_ALG: ClassVar[ConfigParam] = ...
    HOST_NTHREADS: ClassVar[ConfigParam] = ...
    HYBRID_DEVICE_MEMORY_LIMIT: ClassVar[ConfigParam] = ...
    HYBRID_EXECUTE_MODE: ClassVar[ConfigParam] = ...
    HYBRID_MODE: ClassVar[ConfigParam] = ...
    IR_N_STEPS: ClassVar[ConfigParam] = ...
    IR_TOL: ClassVar[ConfigParam] = ...
    MATCHING_TYPE: ClassVar[ConfigParam] = ...
    MAX_LU_NNZ: ClassVar[ConfigParam] = ...
    PIVOT_EPSILON: ClassVar[ConfigParam] = ...
    PIVOT_EPSILON_ALG: ClassVar[ConfigParam] = ...
    PIVOT_THRESHOLD: ClassVar[ConfigParam] = ...
    PIVOT_TYPE: ClassVar[ConfigParam] = ...
    REORDERING_ALG: ClassVar[ConfigParam] = ...
    SOLVE_ALG: ClassVar[ConfigParam] = ...
    SOLVE_MODE: ClassVar[ConfigParam] = ...
    USE_CUDA_REGISTER_MEMORY: ClassVar[ConfigParam] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class DataParam(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    COMM: ClassVar[DataParam] = ...
    DIAG: ClassVar[DataParam] = ...
    HYBRID_DEVICE_MEMORY_MIN: ClassVar[DataParam] = ...
    INERTIA: ClassVar[DataParam] = ...
    INFO: ClassVar[DataParam] = ...
    LU_NNZ: ClassVar[DataParam] = ...
    MEMORY_ESTIMATES: ClassVar[DataParam] = ...
    NPIVOTS: ClassVar[DataParam] = ...
    PERM_COL: ClassVar[DataParam] = ...
    PERM_REORDER_COL: ClassVar[DataParam] = ...
    PERM_REORDER_ROW: ClassVar[DataParam] = ...
    PERM_ROW: ClassVar[DataParam] = ...
    USER_PERM: ClassVar[DataParam] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class IndexBase(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    ONE: ClassVar[IndexBase] = ...
    ZERO: ClassVar[IndexBase] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class Layout(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    COL_MAJOR: ClassVar[Layout] = ...
    ROW_MAJOR: ClassVar[Layout] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class MatrixFormat(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    BATCH: ClassVar[MatrixFormat] = ...
    CSR: ClassVar[MatrixFormat] = ...
    DENSE: ClassVar[MatrixFormat] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class MatrixType(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    GENERAL: ClassVar[MatrixType] = ...
    HERMITIAN: ClassVar[MatrixType] = ...
    HPD: ClassVar[MatrixType] = ...
    SPD: ClassVar[MatrixType] = ...
    SYMMETRIC: ClassVar[MatrixType] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class MatrixViewType(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    FULL: ClassVar[MatrixViewType] = ...
    LOWER: ClassVar[MatrixViewType] = ...
    UPPER: ClassVar[MatrixViewType] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class OpType(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    MAX: ClassVar[OpType] = ...
    MIN: ClassVar[OpType] = ...
    SUM: ClassVar[OpType] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class Phase(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    ANALYSIS: ClassVar[Phase] = ...
    FACTORIZATION: ClassVar[Phase] = ...
    REFACTORIZATION: ClassVar[Phase] = ...
    SOLVE: ClassVar[Phase] = ...
    SOLVE_BWD: ClassVar[Phase] = ...
    SOLVE_DIAG: ClassVar[Phase] = ...
    SOLVE_FWD: ClassVar[Phase] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class PivotType(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    PIVOT_COL: ClassVar[PivotType] = ...
    PIVOT_NONE: ClassVar[PivotType] = ...
    PIVOT_ROW: ClassVar[PivotType] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class Status(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    ALLOC_FAILED: ClassVar[Status] = ...
    EXECUTION_FAILED: ClassVar[Status] = ...
    INTERNAL_ERROR: ClassVar[Status] = ...
    INVALID_VALUE: ClassVar[Status] = ...
    NOT_INITIALIZED: ClassVar[Status] = ...
    NOT_SUPPORTED: ClassVar[Status] = ...
    SUCCESS: ClassVar[Status] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class cuDSSError(Exception):
    def __init__(self, status) -> Any: ...
    def __reduce__(self) -> Any: ...
