# Copyright (c) 2024-2025, NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
#
# SPDX-License-Identifier: Apache-2.0

import _cython_3_1_2
import enum
from typing import Any, Callable, ClassVar

__pyx_capi__: dict
__test__: dict
check_status: _cython_3_1_2.cython_function_or_method
get_property: _cython_3_1_2.cython_function_or_method
get_version: _cython_3_1_2.cython_function_or_method

class AlgMode(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    ALG_0: ClassVar[AlgMode] = ...
    ALG_1: ClassVar[AlgMode] = ...
    ALG_2: ClassVar[AlgMode] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class DeterministicMode(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    ALLOW_NON_DETERMINISTIC_RESULTS: ClassVar[DeterministicMode] = ...
    DETERMINISTIC_RESULTS: ClassVar[DeterministicMode] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class DirectMode(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    BACKWARD: ClassVar[DirectMode] = ...
    FORWARD: ClassVar[DirectMode] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class EigMode(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    NOVECTOR: ClassVar[EigMode] = ...
    VECTOR: ClassVar[EigMode] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class EigRange(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    ALL: ClassVar[EigRange] = ...
    I: ClassVar[EigRange] = ...
    V: ClassVar[EigRange] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class EigType(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    TYPE_1: ClassVar[EigType] = ...
    TYPE_2: ClassVar[EigType] = ...
    TYPE_3: ClassVar[EigType] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class IRSRefinement(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    IRS_REFINE_CLASSICAL: ClassVar[IRSRefinement] = ...
    IRS_REFINE_CLASSICAL_GMRES: ClassVar[IRSRefinement] = ...
    IRS_REFINE_GMRES: ClassVar[IRSRefinement] = ...
    IRS_REFINE_GMRES_GMRES: ClassVar[IRSRefinement] = ...
    IRS_REFINE_GMRES_NOPCOND: ClassVar[IRSRefinement] = ...
    IRS_REFINE_NONE: ClassVar[IRSRefinement] = ...
    IRS_REFINE_NOT_SET: ClassVar[IRSRefinement] = ...
    PREC_DD: ClassVar[IRSRefinement] = ...
    PREC_SHT: ClassVar[IRSRefinement] = ...
    PREC_SS: ClassVar[IRSRefinement] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class Norm(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    FRO_NORM: ClassVar[Norm] = ...
    INF_NORM: ClassVar[Norm] = ...
    MAX_NORM: ClassVar[Norm] = ...
    ONE_NORM: ClassVar[Norm] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class PrecType(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    C_16BF: ClassVar[PrecType] = ...
    C_16F: ClassVar[PrecType] = ...
    C_32F: ClassVar[PrecType] = ...
    C_64F: ClassVar[PrecType] = ...
    C_8I: ClassVar[PrecType] = ...
    C_8U: ClassVar[PrecType] = ...
    C_AP: ClassVar[PrecType] = ...
    C_TF32: ClassVar[PrecType] = ...
    R_16BF: ClassVar[PrecType] = ...
    R_16F: ClassVar[PrecType] = ...
    R_32F: ClassVar[PrecType] = ...
    R_64F: ClassVar[PrecType] = ...
    R_8I: ClassVar[PrecType] = ...
    R_8U: ClassVar[PrecType] = ...
    R_AP: ClassVar[PrecType] = ...
    R_TF32: ClassVar[PrecType] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class Status(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    ALLOC_FAILED: ClassVar[Status] = ...
    ARCH_MISMATCH: ClassVar[Status] = ...
    EXECUTION_FAILED: ClassVar[Status] = ...
    INTERNAL_ERROR: ClassVar[Status] = ...
    INVALID_LICENSE: ClassVar[Status] = ...
    INVALID_VALUE: ClassVar[Status] = ...
    INVALID_WORKSPACE: ClassVar[Status] = ...
    IRS_INFOS_NOT_DESTROYED: ClassVar[Status] = ...
    IRS_INFOS_NOT_INITIALIZED: ClassVar[Status] = ...
    IRS_INTERNAL_ERROR: ClassVar[Status] = ...
    IRS_MATRIX_SINGULAR: ClassVar[Status] = ...
    IRS_NOT_SUPPORTED: ClassVar[Status] = ...
    IRS_NRHS_NOT_SUPPORTED_FOR_REFINE_GMRES: ClassVar[Status] = ...
    IRS_OUT_OF_RANGE: ClassVar[Status] = ...
    IRS_PARAMS_INVALID: ClassVar[Status] = ...
    IRS_PARAMS_INVALID_MAXITER: ClassVar[Status] = ...
    IRS_PARAMS_INVALID_PREC: ClassVar[Status] = ...
    IRS_PARAMS_INVALID_REFINE: ClassVar[Status] = ...
    IRS_PARAMS_NOT_INITIALIZED: ClassVar[Status] = ...
    MAPPING_ERROR: ClassVar[Status] = ...
    MATRIX_TYPE_NOT_SUPPORTED: ClassVar[Status] = ...
    NOT_INITIALIZED: ClassVar[Status] = ...
    NOT_SUPPORTED: ClassVar[Status] = ...
    SUCCESS: ClassVar[Status] = ...
    ZERO_PIVOT: ClassVar[Status] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class StorevMode(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    COLUMNWISE: ClassVar[StorevMode] = ...
    ROWWISE: ClassVar[StorevMode] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class cuSOLVERError(Exception):
    def __init__(self, status) -> Any: ...
    def __reduce__(self) -> Any: ...
