# Copyright (c) 2024-2025, NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
#
# SPDX-License-Identifier: Apache-2.0

# type: ignore

# Automatically generated by Numbast Static Binding Generator
import os

from cuda import pathfinder

# Imports:
from numba.types import uint32
from numba import types
from numba.types import Function
from numba.core.extending import make_attribute_wrapper
from numba.types import UniTuple
from enum import IntEnum
from numba.types import float32
from numba.cuda.vector_types import vector_types
from numba.cuda import declare_device
from numba.cuda.cudadecl import register_global
from numba.types import Type
from numba.types import int32
from numba.types import CPointer
from numba.core.typing import signature
from numba.cuda.cudadecl import register
from numba.types import uint64
from numba.core.typing.templates import ConcreteTemplate
from numba.cuda.cudaimpl import lower
from numba.cuda.cudadecl import register_attr
from numba.core.extending import register_model
from numba.core.datamodel.models import StructModel
from numba.types import uint8
from numba.types import float64
from numba.core.typing.templates import AttributeTemplate
from numba.types import none
from numba.cuda import CUSource

uint32x4 = vector_types['uint32x4']
uint32x2 = vector_types['uint32x2']
float32x4 = vector_types['float32x4']
float64x2 = vector_types['float64x2']
float64x4 = vector_types['float64x4']
float32x2 = vector_types['float32x2']

# Enums:


class curandStatus(IntEnum):
    CURAND_STATUS_SUCCESS = 0
    CURAND_STATUS_VERSION_MISMATCH = 100
    CURAND_STATUS_NOT_INITIALIZED = 101
    CURAND_STATUS_ALLOCATION_FAILED = 102
    CURAND_STATUS_TYPE_ERROR = 103
    CURAND_STATUS_OUT_OF_RANGE = 104
    CURAND_STATUS_LENGTH_NOT_MULTIPLE = 105
    CURAND_STATUS_DOUBLE_PRECISION_REQUIRED = 106
    CURAND_STATUS_LAUNCH_FAILURE = 201
    CURAND_STATUS_PREEXISTING_FAILURE = 202
    CURAND_STATUS_INITIALIZATION_FAILED = 203
    CURAND_STATUS_ARCH_MISMATCH = 204
    CURAND_STATUS_INTERNAL_ERROR = 999


class curandRngType(IntEnum):
    CURAND_RNG_TEST = 0
    CURAND_RNG_PSEUDO_DEFAULT = 100
    CURAND_RNG_PSEUDO_XORWOW = 101
    CURAND_RNG_PSEUDO_MRG32K3A = 121
    CURAND_RNG_PSEUDO_MTGP32 = 141
    CURAND_RNG_PSEUDO_MT19937 = 142
    CURAND_RNG_PSEUDO_PHILOX4_32_10 = 161
    CURAND_RNG_QUASI_DEFAULT = 200
    CURAND_RNG_QUASI_SOBOL32 = 201
    CURAND_RNG_QUASI_SCRAMBLED_SOBOL32 = 202
    CURAND_RNG_QUASI_SOBOL64 = 203
    CURAND_RNG_QUASI_SCRAMBLED_SOBOL64 = 204


class curandOrdering(IntEnum):
    CURAND_ORDERING_PSEUDO_BEST = 100
    CURAND_ORDERING_PSEUDO_DEFAULT = 101
    CURAND_ORDERING_PSEUDO_SEEDED = 102
    CURAND_ORDERING_PSEUDO_LEGACY = 103
    CURAND_ORDERING_PSEUDO_DYNAMIC = 104
    CURAND_ORDERING_QUASI_DEFAULT = 201


class curandDirectionVectorSet(IntEnum):
    CURAND_DIRECTION_VECTORS_32_JOEKUO6 = 101
    CURAND_SCRAMBLED_DIRECTION_VECTORS_32_JOEKUO6 = 102
    CURAND_DIRECTION_VECTORS_64_JOEKUO6 = 103
    CURAND_SCRAMBLED_DIRECTION_VECTORS_64_JOEKUO6 = 104


class curandMethod(IntEnum):
    CURAND_CHOOSE_BEST = 0
    CURAND_ITR = 1
    CURAND_KNUTH = 2
    CURAND_HITR = 3
    CURAND_M1 = 4
    CURAND_M2 = 5
    CURAND_BINARY_SEARCH = 6
    CURAND_DISCRETE_GAUSS = 7
    CURAND_REJECTION = 8
    CURAND_DEVICE_API = 9
    CURAND_FAST_REJECTION = 10
    CURAND_3RD = 11
    CURAND_DEFINITION = 12
    CURAND_POISSON = 13

# Structs:



# Typing for mtgp32_params_fast
class _type_class_mtgp32_params_fast(Type):
    def __init__(self):
        super().__init__(name="mtgp32_params_fast")
        self.alignof_ = 4
        self.bitwidth = 236 * 8

_type_mtgp32_params_fast = _type_class_mtgp32_params_fast()


# Make Python API for struct
mtgp32_params_fast = type("mtgp32_params_fast", (), {"_nbtype": _type_mtgp32_params_fast})


@register_model(_type_class_mtgp32_params_fast)
class _model_mtgp32_params_fast(StructModel):
    def __init__(self, dmm, fe_type):
        members = [('mexp', int32), ('pos', int32), ('sh1', int32), ('sh2', int32), ('tbl', UniTuple(uint32, 16)), ('tmp_tbl', UniTuple(uint32, 16)), ('flt_tmp_tbl', UniTuple(uint32, 16)), ('mask', uint32), ('poly_sha1', UniTuple(uint8, 21))]
        super().__init__(dmm, fe_type, members)


@register_attr
class _attr_typing_mtgp32_params_fast(AttributeTemplate):
    key = globals()['mtgp32_params_fast']


    def resolve_mexp(self, obj):
        return int32


    def resolve_pos(self, obj):
        return int32


    def resolve_sh1(self, obj):
        return int32


    def resolve_sh2(self, obj):
        return int32


    def resolve_tbl(self, obj):
        return UniTuple(uint32, 16)


    def resolve_tmp_tbl(self, obj):
        return UniTuple(uint32, 16)


    def resolve_flt_tmp_tbl(self, obj):
        return UniTuple(uint32, 16)


    def resolve_mask(self, obj):
        return uint32


    def resolve_poly_sha1(self, obj):
        return UniTuple(uint8, 21)



make_attribute_wrapper(_type_class_mtgp32_params_fast, "mexp", "mexp")


make_attribute_wrapper(_type_class_mtgp32_params_fast, "pos", "pos")


make_attribute_wrapper(_type_class_mtgp32_params_fast, "sh1", "sh1")


make_attribute_wrapper(_type_class_mtgp32_params_fast, "sh2", "sh2")


make_attribute_wrapper(_type_class_mtgp32_params_fast, "tbl", "tbl")


make_attribute_wrapper(_type_class_mtgp32_params_fast, "tmp_tbl", "tmp_tbl")


make_attribute_wrapper(_type_class_mtgp32_params_fast, "flt_tmp_tbl", "flt_tmp_tbl")


make_attribute_wrapper(_type_class_mtgp32_params_fast, "mask", "mask")


make_attribute_wrapper(_type_class_mtgp32_params_fast, "poly_sha1", "poly_sha1")



@register
class _ctor_template_mtgp32_params_fast(ConcreteTemplate):
    key = globals()['mtgp32_params_fast']
    cases = []

register_global(mtgp32_params_fast, Function(_ctor_template_mtgp32_params_fast))





# Typing for mtgp32_kernel_params
class _type_class_mtgp32_kernel_params(Type):
    def __init__(self):
        super().__init__(name="mtgp32_kernel_params")
        self.alignof_ = 4
        self.bitwidth = 40804 * 8

_type_mtgp32_kernel_params = _type_class_mtgp32_kernel_params()


# Make Python API for struct
mtgp32_kernel_params = type("mtgp32_kernel_params", (), {"_nbtype": _type_mtgp32_kernel_params})


@register_model(_type_class_mtgp32_kernel_params)
class _model_mtgp32_kernel_params(StructModel):
    def __init__(self, dmm, fe_type):
        members = [('pos_tbl', UniTuple(uint32, 200)), ('param_tbl', UniTuple(UniTuple(uint32, 200), 16)), ('temper_tbl', UniTuple(UniTuple(uint32, 200), 16)), ('single_temper_tbl', UniTuple(UniTuple(uint32, 200), 16)), ('sh1_tbl', UniTuple(uint32, 200)), ('sh2_tbl', UniTuple(uint32, 200)), ('mask', UniTuple(uint32, 1))]
        super().__init__(dmm, fe_type, members)


@register_attr
class _attr_typing_mtgp32_kernel_params(AttributeTemplate):
    key = globals()['mtgp32_kernel_params']


    def resolve_pos_tbl(self, obj):
        return UniTuple(uint32, 200)


    def resolve_param_tbl(self, obj):
        return UniTuple(UniTuple(uint32, 200), 16)


    def resolve_temper_tbl(self, obj):
        return UniTuple(UniTuple(uint32, 200), 16)


    def resolve_single_temper_tbl(self, obj):
        return UniTuple(UniTuple(uint32, 200), 16)


    def resolve_sh1_tbl(self, obj):
        return UniTuple(uint32, 200)


    def resolve_sh2_tbl(self, obj):
        return UniTuple(uint32, 200)


    def resolve_mask(self, obj):
        return UniTuple(uint32, 1)



make_attribute_wrapper(_type_class_mtgp32_kernel_params, "pos_tbl", "pos_tbl")


make_attribute_wrapper(_type_class_mtgp32_kernel_params, "param_tbl", "param_tbl")


make_attribute_wrapper(_type_class_mtgp32_kernel_params, "temper_tbl", "temper_tbl")


make_attribute_wrapper(_type_class_mtgp32_kernel_params, "single_temper_tbl", "single_temper_tbl")


make_attribute_wrapper(_type_class_mtgp32_kernel_params, "sh1_tbl", "sh1_tbl")


make_attribute_wrapper(_type_class_mtgp32_kernel_params, "sh2_tbl", "sh2_tbl")


make_attribute_wrapper(_type_class_mtgp32_kernel_params, "mask", "mask")



@register
class _ctor_template_mtgp32_kernel_params(ConcreteTemplate):
    key = globals()['mtgp32_kernel_params']
    cases = []

register_global(mtgp32_kernel_params, Function(_ctor_template_mtgp32_kernel_params))





# Typing for curandStateMtgp32
class _type_class_curandStateMtgp32(Type):
    def __init__(self):
        super().__init__(name="curandStateMtgp32")
        self.alignof_ = 8
        self.bitwidth = 4112 * 8

_type_curandStateMtgp32 = _type_class_curandStateMtgp32()


# Make Python API for struct
curandStateMtgp32 = type("curandStateMtgp32", (), {"_nbtype": _type_curandStateMtgp32})


@register_model(_type_class_curandStateMtgp32)
class _model_curandStateMtgp32(StructModel):
    def __init__(self, dmm, fe_type):
        members = [('s', UniTuple(uint32, 1024)), ('offset', int32), ('pIdx', int32), ('k', CPointer(_type_mtgp32_kernel_params))]
        super().__init__(dmm, fe_type, members)


@register_attr
class _attr_typing_curandStateMtgp32(AttributeTemplate):
    key = globals()['curandStateMtgp32']


    def resolve_s(self, obj):
        return UniTuple(uint32, 1024)


    def resolve_offset(self, obj):
        return int32


    def resolve_pIdx(self, obj):
        return int32


    def resolve_k(self, obj):
        return CPointer(_type_mtgp32_kernel_params)



make_attribute_wrapper(_type_class_curandStateMtgp32, "s", "s")


make_attribute_wrapper(_type_class_curandStateMtgp32, "offset", "offset")


make_attribute_wrapper(_type_class_curandStateMtgp32, "pIdx", "pIdx")


make_attribute_wrapper(_type_class_curandStateMtgp32, "k", "k")



@register
class _ctor_template_curandStateMtgp32(ConcreteTemplate):
    key = globals()['curandStateMtgp32']
    cases = []

register_global(curandStateMtgp32, Function(_ctor_template_curandStateMtgp32))





# Typing for curandDistributionShift_st
class _type_class_curandDistributionShift_st(Type):
    def __init__(self):
        super().__init__(name="curandDistributionShift_st")
        self.alignof_ = 8
        self.bitwidth = 32 * 8

_type_curandDistributionShift_st = _type_class_curandDistributionShift_st()


# Make Python API for struct
curandDistributionShift_st = type("curandDistributionShift_st", (), {"_nbtype": _type_curandDistributionShift_st})


@register_model(_type_class_curandDistributionShift_st)
class _model_curandDistributionShift_st(StructModel):
    def __init__(self, dmm, fe_type):
        members = [('probability', CPointer(float64)), ('host_probability', CPointer(float64)), ('shift', uint32), ('length', uint32), ('host_gen', uint32)]
        super().__init__(dmm, fe_type, members)


@register_attr
class _attr_typing_curandDistributionShift_st(AttributeTemplate):
    key = globals()['curandDistributionShift_st']


    def resolve_probability(self, obj):
        return CPointer(float64)


    def resolve_host_probability(self, obj):
        return CPointer(float64)


    def resolve_shift(self, obj):
        return uint32


    def resolve_length(self, obj):
        return uint32


    def resolve_host_gen(self, obj):
        return uint32



make_attribute_wrapper(_type_class_curandDistributionShift_st, "probability", "probability")


make_attribute_wrapper(_type_class_curandDistributionShift_st, "host_probability", "host_probability")


make_attribute_wrapper(_type_class_curandDistributionShift_st, "shift", "shift")


make_attribute_wrapper(_type_class_curandDistributionShift_st, "length", "length")


make_attribute_wrapper(_type_class_curandDistributionShift_st, "host_gen", "host_gen")



@register
class _ctor_template_curandDistributionShift_st(ConcreteTemplate):
    key = globals()['curandDistributionShift_st']
    cases = []

register_global(curandDistributionShift_st, Function(_ctor_template_curandDistributionShift_st))





# Typing for curandHistogramM2_st
class _type_class_curandHistogramM2_st(Type):
    def __init__(self):
        super().__init__(name="curandHistogramM2_st")
        self.alignof_ = 8
        self.bitwidth = 40 * 8

_type_curandHistogramM2_st = _type_class_curandHistogramM2_st()


# Make Python API for struct
curandHistogramM2_st = type("curandHistogramM2_st", (), {"_nbtype": _type_curandHistogramM2_st})


@register_model(_type_class_curandHistogramM2_st)
class _model_curandHistogramM2_st(StructModel):
    def __init__(self, dmm, fe_type):
        members = [('V', CPointer(float64)), ('host_V', CPointer(float64)), ('K', CPointer(uint32)), ('host_K', CPointer(uint32)), ('host_gen', uint32)]
        super().__init__(dmm, fe_type, members)


@register_attr
class _attr_typing_curandHistogramM2_st(AttributeTemplate):
    key = globals()['curandHistogramM2_st']


    def resolve_V(self, obj):
        return CPointer(float64)


    def resolve_host_V(self, obj):
        return CPointer(float64)


    def resolve_K(self, obj):
        return CPointer(uint32)


    def resolve_host_K(self, obj):
        return CPointer(uint32)


    def resolve_host_gen(self, obj):
        return uint32



make_attribute_wrapper(_type_class_curandHistogramM2_st, "V", "V")


make_attribute_wrapper(_type_class_curandHistogramM2_st, "host_V", "host_V")


make_attribute_wrapper(_type_class_curandHistogramM2_st, "K", "K")


make_attribute_wrapper(_type_class_curandHistogramM2_st, "host_K", "host_K")


make_attribute_wrapper(_type_class_curandHistogramM2_st, "host_gen", "host_gen")



@register
class _ctor_template_curandHistogramM2_st(ConcreteTemplate):
    key = globals()['curandHistogramM2_st']
    cases = []

register_global(curandHistogramM2_st, Function(_ctor_template_curandHistogramM2_st))





# Typing for curandDistributionM2Shift_st
class _type_class_curandDistributionM2Shift_st(Type):
    def __init__(self):
        super().__init__(name="curandDistributionM2Shift_st")
        self.alignof_ = 8
        self.bitwidth = 32 * 8

_type_curandDistributionM2Shift_st = _type_class_curandDistributionM2Shift_st()


# Make Python API for struct
curandDistributionM2Shift_st = type("curandDistributionM2Shift_st", (), {"_nbtype": _type_curandDistributionM2Shift_st})


@register_model(_type_class_curandDistributionM2Shift_st)
class _model_curandDistributionM2Shift_st(StructModel):
    def __init__(self, dmm, fe_type):
        members = [('histogram', CPointer(_type_curandHistogramM2_st)), ('host_histogram', CPointer(_type_curandHistogramM2_st)), ('shift', uint32), ('length', uint32), ('host_gen', uint32)]
        super().__init__(dmm, fe_type, members)


@register_attr
class _attr_typing_curandDistributionM2Shift_st(AttributeTemplate):
    key = globals()['curandDistributionM2Shift_st']


    def resolve_histogram(self, obj):
        return CPointer(_type_curandHistogramM2_st)


    def resolve_host_histogram(self, obj):
        return CPointer(_type_curandHistogramM2_st)


    def resolve_shift(self, obj):
        return uint32


    def resolve_length(self, obj):
        return uint32


    def resolve_host_gen(self, obj):
        return uint32



make_attribute_wrapper(_type_class_curandDistributionM2Shift_st, "histogram", "histogram")


make_attribute_wrapper(_type_class_curandDistributionM2Shift_st, "host_histogram", "host_histogram")


make_attribute_wrapper(_type_class_curandDistributionM2Shift_st, "shift", "shift")


make_attribute_wrapper(_type_class_curandDistributionM2Shift_st, "length", "length")


make_attribute_wrapper(_type_class_curandDistributionM2Shift_st, "host_gen", "host_gen")



@register
class _ctor_template_curandDistributionM2Shift_st(ConcreteTemplate):
    key = globals()['curandDistributionM2Shift_st']
    cases = []

register_global(curandDistributionM2Shift_st, Function(_ctor_template_curandDistributionM2Shift_st))





# Typing for curandDiscreteDistribution_st
class _type_class_curandDiscreteDistribution_st(Type):
    def __init__(self):
        super().__init__(name="curandDiscreteDistribution_st")
        self.alignof_ = 8
        self.bitwidth = 48 * 8

_type_curandDiscreteDistribution_st = _type_class_curandDiscreteDistribution_st()


# Make Python API for struct
curandDiscreteDistribution_st = type("curandDiscreteDistribution_st", (), {"_nbtype": _type_curandDiscreteDistribution_st})


@register_model(_type_class_curandDiscreteDistribution_st)
class _model_curandDiscreteDistribution_st(StructModel):
    def __init__(self, dmm, fe_type):
        members = [('self_host_ptr', CPointer(_type_curandDiscreteDistribution_st)), ('M2', CPointer(_type_curandDistributionM2Shift_st)), ('host_M2', CPointer(_type_curandDistributionM2Shift_st)), ('stddev', float64), ('mean', float64), ('method', curandMethod), ('host_gen', uint32)]
        super().__init__(dmm, fe_type, members)


@register_attr
class _attr_typing_curandDiscreteDistribution_st(AttributeTemplate):
    key = globals()['curandDiscreteDistribution_st']


    def resolve_self_host_ptr(self, obj):
        return CPointer(_type_curandDiscreteDistribution_st)


    def resolve_M2(self, obj):
        return CPointer(_type_curandDistributionM2Shift_st)


    def resolve_host_M2(self, obj):
        return CPointer(_type_curandDistributionM2Shift_st)


    def resolve_stddev(self, obj):
        return float64


    def resolve_mean(self, obj):
        return float64


    def resolve_method(self, obj):
        return curandMethod


    def resolve_host_gen(self, obj):
        return uint32



make_attribute_wrapper(_type_class_curandDiscreteDistribution_st, "self_host_ptr", "self_host_ptr")


make_attribute_wrapper(_type_class_curandDiscreteDistribution_st, "M2", "M2")


make_attribute_wrapper(_type_class_curandDiscreteDistribution_st, "host_M2", "host_M2")


make_attribute_wrapper(_type_class_curandDiscreteDistribution_st, "stddev", "stddev")


make_attribute_wrapper(_type_class_curandDiscreteDistribution_st, "mean", "mean")


make_attribute_wrapper(_type_class_curandDiscreteDistribution_st, "method", "method")


make_attribute_wrapper(_type_class_curandDiscreteDistribution_st, "host_gen", "host_gen")



@register
class _ctor_template_curandDiscreteDistribution_st(ConcreteTemplate):
    key = globals()['curandDiscreteDistribution_st']
    cases = []

register_global(curandDiscreteDistribution_st, Function(_ctor_template_curandDiscreteDistribution_st))





# Typing for curandStatePhilox4_32_10
class _type_class_curandStatePhilox4_32_10(Type):
    def __init__(self):
        super().__init__(name="curandStatePhilox4_32_10")
        self.alignof_ = 16
        self.bitwidth = 64 * 8

_type_curandStatePhilox4_32_10 = _type_class_curandStatePhilox4_32_10()


# Make Python API for struct
curandStatePhilox4_32_10 = type("curandStatePhilox4_32_10", (), {"_nbtype": _type_curandStatePhilox4_32_10})


@register_model(_type_class_curandStatePhilox4_32_10)
class _model_curandStatePhilox4_32_10(StructModel):
    def __init__(self, dmm, fe_type):
        members = [('ctr', uint32x4), ('output', uint32x4), ('key', uint32x2), ('STATE', uint32), ('boxmuller_flag', int32), ('boxmuller_flag_double', int32), ('boxmuller_extra', float32), ('boxmuller_extra_double', float64)]
        super().__init__(dmm, fe_type, members)


@register_attr
class _attr_typing_curandStatePhilox4_32_10(AttributeTemplate):
    key = globals()['curandStatePhilox4_32_10']


    def resolve_ctr(self, obj):
        return uint32x4


    def resolve_output(self, obj):
        return uint32x4


    def resolve_key(self, obj):
        return uint32x2


    def resolve_STATE(self, obj):
        return uint32


    def resolve_boxmuller_flag(self, obj):
        return int32


    def resolve_boxmuller_flag_double(self, obj):
        return int32


    def resolve_boxmuller_extra(self, obj):
        return float32


    def resolve_boxmuller_extra_double(self, obj):
        return float64



make_attribute_wrapper(_type_class_curandStatePhilox4_32_10, "ctr", "ctr")


make_attribute_wrapper(_type_class_curandStatePhilox4_32_10, "output", "output")


make_attribute_wrapper(_type_class_curandStatePhilox4_32_10, "key", "key")


make_attribute_wrapper(_type_class_curandStatePhilox4_32_10, "STATE", "STATE")


make_attribute_wrapper(_type_class_curandStatePhilox4_32_10, "boxmuller_flag", "boxmuller_flag")


make_attribute_wrapper(_type_class_curandStatePhilox4_32_10, "boxmuller_flag_double", "boxmuller_flag_double")


make_attribute_wrapper(_type_class_curandStatePhilox4_32_10, "boxmuller_extra", "boxmuller_extra")


make_attribute_wrapper(_type_class_curandStatePhilox4_32_10, "boxmuller_extra_double", "boxmuller_extra_double")



@register
class _ctor_template_curandStatePhilox4_32_10(ConcreteTemplate):
    key = globals()['curandStatePhilox4_32_10']
    cases = []

register_global(curandStatePhilox4_32_10, Function(_ctor_template_curandStatePhilox4_32_10))





# Typing for normal_args_st
class _type_class_normal_args_st(Type):
    def __init__(self):
        super().__init__(name="normal_args_st")
        self.alignof_ = 4
        self.bitwidth = 8 * 8

_type_normal_args_st = _type_class_normal_args_st()


# Make Python API for struct
normal_args_st = type("normal_args_st", (), {"_nbtype": _type_normal_args_st})


@register_model(_type_class_normal_args_st)
class _model_normal_args_st(StructModel):
    def __init__(self, dmm, fe_type):
        members = [('mean', float32), ('stddev', float32)]
        super().__init__(dmm, fe_type, members)


@register_attr
class _attr_typing_normal_args_st(AttributeTemplate):
    key = globals()['normal_args_st']


    def resolve_mean(self, obj):
        return float32


    def resolve_stddev(self, obj):
        return float32



make_attribute_wrapper(_type_class_normal_args_st, "mean", "mean")


make_attribute_wrapper(_type_class_normal_args_st, "stddev", "stddev")



@register
class _ctor_template_normal_args_st(ConcreteTemplate):
    key = globals()['normal_args_st']
    cases = []

register_global(normal_args_st, Function(_ctor_template_normal_args_st))





# Typing for normal_args_double_st
class _type_class_normal_args_double_st(Type):
    def __init__(self):
        super().__init__(name="normal_args_double_st")
        self.alignof_ = 8
        self.bitwidth = 16 * 8

_type_normal_args_double_st = _type_class_normal_args_double_st()


# Make Python API for struct
normal_args_double_st = type("normal_args_double_st", (), {"_nbtype": _type_normal_args_double_st})


@register_model(_type_class_normal_args_double_st)
class _model_normal_args_double_st(StructModel):
    def __init__(self, dmm, fe_type):
        members = [('mean', float64), ('stddev', float64)]
        super().__init__(dmm, fe_type, members)


@register_attr
class _attr_typing_normal_args_double_st(AttributeTemplate):
    key = globals()['normal_args_double_st']


    def resolve_mean(self, obj):
        return float64


    def resolve_stddev(self, obj):
        return float64



make_attribute_wrapper(_type_class_normal_args_double_st, "mean", "mean")


make_attribute_wrapper(_type_class_normal_args_double_st, "stddev", "stddev")



@register
class _ctor_template_normal_args_double_st(ConcreteTemplate):
    key = globals()['normal_args_double_st']
    cases = []

register_global(normal_args_double_st, Function(_ctor_template_normal_args_double_st))





# Typing for curandStateTest
class _type_class_curandStateTest(Type):
    def __init__(self):
        super().__init__(name="curandStateTest")
        self.alignof_ = 4
        self.bitwidth = 4 * 8

_type_curandStateTest = _type_class_curandStateTest()


# Make Python API for struct
curandStateTest = type("curandStateTest", (), {"_nbtype": _type_curandStateTest})


@register_model(_type_class_curandStateTest)
class _model_curandStateTest(StructModel):
    def __init__(self, dmm, fe_type):
        members = [('v', uint32)]
        super().__init__(dmm, fe_type, members)


@register_attr
class _attr_typing_curandStateTest(AttributeTemplate):
    key = globals()['curandStateTest']


    def resolve_v(self, obj):
        return uint32



make_attribute_wrapper(_type_class_curandStateTest, "v", "v")



@register
class _ctor_template_curandStateTest(ConcreteTemplate):
    key = globals()['curandStateTest']
    cases = []

register_global(curandStateTest, Function(_ctor_template_curandStateTest))





# Typing for curandStateXORWOW
class _type_class_curandStateXORWOW(Type):
    def __init__(self):
        super().__init__(name="curandStateXORWOW")
        self.alignof_ = 8
        self.bitwidth = 48 * 8

_type_curandStateXORWOW = _type_class_curandStateXORWOW()


# Make Python API for struct
curandStateXORWOW = type("curandStateXORWOW", (), {"_nbtype": _type_curandStateXORWOW})


@register_model(_type_class_curandStateXORWOW)
class _model_curandStateXORWOW(StructModel):
    def __init__(self, dmm, fe_type):
        members = [('d', uint32), ('v', UniTuple(uint32, 5)), ('boxmuller_flag', int32), ('boxmuller_flag_double', int32), ('boxmuller_extra', float32), ('boxmuller_extra_double', float64)]
        super().__init__(dmm, fe_type, members)


@register_attr
class _attr_typing_curandStateXORWOW(AttributeTemplate):
    key = globals()['curandStateXORWOW']


    def resolve_d(self, obj):
        return uint32


    def resolve_v(self, obj):
        return UniTuple(uint32, 5)


    def resolve_boxmuller_flag(self, obj):
        return int32


    def resolve_boxmuller_flag_double(self, obj):
        return int32


    def resolve_boxmuller_extra(self, obj):
        return float32


    def resolve_boxmuller_extra_double(self, obj):
        return float64



make_attribute_wrapper(_type_class_curandStateXORWOW, "d", "d")


make_attribute_wrapper(_type_class_curandStateXORWOW, "v", "v")


make_attribute_wrapper(_type_class_curandStateXORWOW, "boxmuller_flag", "boxmuller_flag")


make_attribute_wrapper(_type_class_curandStateXORWOW, "boxmuller_flag_double", "boxmuller_flag_double")


make_attribute_wrapper(_type_class_curandStateXORWOW, "boxmuller_extra", "boxmuller_extra")


make_attribute_wrapper(_type_class_curandStateXORWOW, "boxmuller_extra_double", "boxmuller_extra_double")



@register
class _ctor_template_curandStateXORWOW(ConcreteTemplate):
    key = globals()['curandStateXORWOW']
    cases = []

register_global(curandStateXORWOW, Function(_ctor_template_curandStateXORWOW))





# Typing for curandStateMRG32k3a
class _type_class_curandStateMRG32k3a(Type):
    def __init__(self):
        super().__init__(name="curandStateMRG32k3a")
        self.alignof_ = 8
        self.bitwidth = 48 * 8

_type_curandStateMRG32k3a = _type_class_curandStateMRG32k3a()


# Make Python API for struct
curandStateMRG32k3a = type("curandStateMRG32k3a", (), {"_nbtype": _type_curandStateMRG32k3a})


@register_model(_type_class_curandStateMRG32k3a)
class _model_curandStateMRG32k3a(StructModel):
    def __init__(self, dmm, fe_type):
        members = [('s1', UniTuple(uint32, 3)), ('s2', UniTuple(uint32, 3)), ('boxmuller_flag', int32), ('boxmuller_flag_double', int32), ('boxmuller_extra', float32), ('boxmuller_extra_double', float64)]
        super().__init__(dmm, fe_type, members)


@register_attr
class _attr_typing_curandStateMRG32k3a(AttributeTemplate):
    key = globals()['curandStateMRG32k3a']


    def resolve_s1(self, obj):
        return UniTuple(uint32, 3)


    def resolve_s2(self, obj):
        return UniTuple(uint32, 3)


    def resolve_boxmuller_flag(self, obj):
        return int32


    def resolve_boxmuller_flag_double(self, obj):
        return int32


    def resolve_boxmuller_extra(self, obj):
        return float32


    def resolve_boxmuller_extra_double(self, obj):
        return float64



make_attribute_wrapper(_type_class_curandStateMRG32k3a, "s1", "s1")


make_attribute_wrapper(_type_class_curandStateMRG32k3a, "s2", "s2")


make_attribute_wrapper(_type_class_curandStateMRG32k3a, "boxmuller_flag", "boxmuller_flag")


make_attribute_wrapper(_type_class_curandStateMRG32k3a, "boxmuller_flag_double", "boxmuller_flag_double")


make_attribute_wrapper(_type_class_curandStateMRG32k3a, "boxmuller_extra", "boxmuller_extra")


make_attribute_wrapper(_type_class_curandStateMRG32k3a, "boxmuller_extra_double", "boxmuller_extra_double")



@register
class _ctor_template_curandStateMRG32k3a(ConcreteTemplate):
    key = globals()['curandStateMRG32k3a']
    cases = []

register_global(curandStateMRG32k3a, Function(_ctor_template_curandStateMRG32k3a))





# Typing for curandStateSobol32
class _type_class_curandStateSobol32(Type):
    def __init__(self):
        super().__init__(name="curandStateSobol32")
        self.alignof_ = 4
        self.bitwidth = 140 * 8

_type_curandStateSobol32 = _type_class_curandStateSobol32()


# Make Python API for struct
curandStateSobol32 = type("curandStateSobol32", (), {"_nbtype": _type_curandStateSobol32})


@register_model(_type_class_curandStateSobol32)
class _model_curandStateSobol32(StructModel):
    def __init__(self, dmm, fe_type):
        members = [('i', uint32), ('x', uint32), ('c', uint32), ('direction_vectors', UniTuple(uint32, 32))]
        super().__init__(dmm, fe_type, members)


@register_attr
class _attr_typing_curandStateSobol32(AttributeTemplate):
    key = globals()['curandStateSobol32']


    def resolve_i(self, obj):
        return uint32


    def resolve_x(self, obj):
        return uint32


    def resolve_c(self, obj):
        return uint32


    def resolve_direction_vectors(self, obj):
        return UniTuple(uint32, 32)



make_attribute_wrapper(_type_class_curandStateSobol32, "i", "i")


make_attribute_wrapper(_type_class_curandStateSobol32, "x", "x")


make_attribute_wrapper(_type_class_curandStateSobol32, "c", "c")


make_attribute_wrapper(_type_class_curandStateSobol32, "direction_vectors", "direction_vectors")



@register
class _ctor_template_curandStateSobol32(ConcreteTemplate):
    key = globals()['curandStateSobol32']
    cases = []

register_global(curandStateSobol32, Function(_ctor_template_curandStateSobol32))





# Typing for curandStateScrambledSobol32
class _type_class_curandStateScrambledSobol32(Type):
    def __init__(self):
        super().__init__(name="curandStateScrambledSobol32")
        self.alignof_ = 4
        self.bitwidth = 140 * 8

_type_curandStateScrambledSobol32 = _type_class_curandStateScrambledSobol32()


# Make Python API for struct
curandStateScrambledSobol32 = type("curandStateScrambledSobol32", (), {"_nbtype": _type_curandStateScrambledSobol32})


@register_model(_type_class_curandStateScrambledSobol32)
class _model_curandStateScrambledSobol32(StructModel):
    def __init__(self, dmm, fe_type):
        members = [('i', uint32), ('x', uint32), ('c', uint32), ('direction_vectors', UniTuple(uint32, 32))]
        super().__init__(dmm, fe_type, members)


@register_attr
class _attr_typing_curandStateScrambledSobol32(AttributeTemplate):
    key = globals()['curandStateScrambledSobol32']


    def resolve_i(self, obj):
        return uint32


    def resolve_x(self, obj):
        return uint32


    def resolve_c(self, obj):
        return uint32


    def resolve_direction_vectors(self, obj):
        return UniTuple(uint32, 32)



make_attribute_wrapper(_type_class_curandStateScrambledSobol32, "i", "i")


make_attribute_wrapper(_type_class_curandStateScrambledSobol32, "x", "x")


make_attribute_wrapper(_type_class_curandStateScrambledSobol32, "c", "c")


make_attribute_wrapper(_type_class_curandStateScrambledSobol32, "direction_vectors", "direction_vectors")



@register
class _ctor_template_curandStateScrambledSobol32(ConcreteTemplate):
    key = globals()['curandStateScrambledSobol32']
    cases = []

register_global(curandStateScrambledSobol32, Function(_ctor_template_curandStateScrambledSobol32))





# Typing for curandStateSobol64
class _type_class_curandStateSobol64(Type):
    def __init__(self):
        super().__init__(name="curandStateSobol64")
        self.alignof_ = 8
        self.bitwidth = 536 * 8

_type_curandStateSobol64 = _type_class_curandStateSobol64()


# Make Python API for struct
curandStateSobol64 = type("curandStateSobol64", (), {"_nbtype": _type_curandStateSobol64})


@register_model(_type_class_curandStateSobol64)
class _model_curandStateSobol64(StructModel):
    def __init__(self, dmm, fe_type):
        members = [('i', uint64), ('x', uint64), ('c', uint64), ('direction_vectors', UniTuple(uint64, 64))]
        super().__init__(dmm, fe_type, members)


@register_attr
class _attr_typing_curandStateSobol64(AttributeTemplate):
    key = globals()['curandStateSobol64']


    def resolve_i(self, obj):
        return uint64


    def resolve_x(self, obj):
        return uint64


    def resolve_c(self, obj):
        return uint64


    def resolve_direction_vectors(self, obj):
        return UniTuple(uint64, 64)



make_attribute_wrapper(_type_class_curandStateSobol64, "i", "i")


make_attribute_wrapper(_type_class_curandStateSobol64, "x", "x")


make_attribute_wrapper(_type_class_curandStateSobol64, "c", "c")


make_attribute_wrapper(_type_class_curandStateSobol64, "direction_vectors", "direction_vectors")



@register
class _ctor_template_curandStateSobol64(ConcreteTemplate):
    key = globals()['curandStateSobol64']
    cases = []

register_global(curandStateSobol64, Function(_ctor_template_curandStateSobol64))





# Typing for curandStateScrambledSobol64
class _type_class_curandStateScrambledSobol64(Type):
    def __init__(self):
        super().__init__(name="curandStateScrambledSobol64")
        self.alignof_ = 8
        self.bitwidth = 536 * 8

_type_curandStateScrambledSobol64 = _type_class_curandStateScrambledSobol64()


# Make Python API for struct
curandStateScrambledSobol64 = type("curandStateScrambledSobol64", (), {"_nbtype": _type_curandStateScrambledSobol64})


@register_model(_type_class_curandStateScrambledSobol64)
class _model_curandStateScrambledSobol64(StructModel):
    def __init__(self, dmm, fe_type):
        members = [('i', uint64), ('x', uint64), ('c', uint64), ('direction_vectors', UniTuple(uint64, 64))]
        super().__init__(dmm, fe_type, members)


@register_attr
class _attr_typing_curandStateScrambledSobol64(AttributeTemplate):
    key = globals()['curandStateScrambledSobol64']


    def resolve_i(self, obj):
        return uint64


    def resolve_x(self, obj):
        return uint64


    def resolve_c(self, obj):
        return uint64


    def resolve_direction_vectors(self, obj):
        return UniTuple(uint64, 64)



make_attribute_wrapper(_type_class_curandStateScrambledSobol64, "i", "i")


make_attribute_wrapper(_type_class_curandStateScrambledSobol64, "x", "x")


make_attribute_wrapper(_type_class_curandStateScrambledSobol64, "c", "c")


make_attribute_wrapper(_type_class_curandStateScrambledSobol64, "direction_vectors", "direction_vectors")



@register
class _ctor_template_curandStateScrambledSobol64(ConcreteTemplate):
    key = globals()['curandStateScrambledSobol64']
    cases = []

register_global(curandStateScrambledSobol64, Function(_ctor_template_curandStateScrambledSobol64))



# Functions:


def para_rec():
    pass



def _para_rec_1_lower():

    para_rec_1 = declare_device(
        'para_rec_1',
        uint32(
            CPointer(CPointer(_type_mtgp32_kernel_params)), CPointer(uint32), CPointer(uint32), CPointer(uint32), CPointer(int32)
        )
    )


    def para_rec_1_caller(arg_0, arg_1, arg_2, arg_3, arg_4):
        return para_rec_1(arg_0, arg_1, arg_2, arg_3, arg_4)


    @lower(para_rec, CPointer(_type_mtgp32_kernel_params), uint32, uint32, uint32, int32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            para_rec_1_caller,
            signature(uint32, CPointer(CPointer(_type_mtgp32_kernel_params)), CPointer(uint32), CPointer(uint32), CPointer(uint32), CPointer(int32)),
            ptrs,
        )


_para_rec_1_lower()


def temper():
    pass



def _temper_1_lower():

    temper_1 = declare_device(
        'temper_1',
        uint32(
            CPointer(CPointer(_type_mtgp32_kernel_params)), CPointer(uint32), CPointer(uint32), CPointer(int32)
        )
    )


    def temper_1_caller(arg_0, arg_1, arg_2, arg_3):
        return temper_1(arg_0, arg_1, arg_2, arg_3)


    @lower(temper, CPointer(_type_mtgp32_kernel_params), uint32, uint32, int32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            temper_1_caller,
            signature(uint32, CPointer(CPointer(_type_mtgp32_kernel_params)), CPointer(uint32), CPointer(uint32), CPointer(int32)),
            ptrs,
        )


_temper_1_lower()


def temper_single():
    pass



def _temper_single_1_lower():

    temper_single_1 = declare_device(
        'temper_single_1',
        uint32(
            CPointer(CPointer(_type_mtgp32_kernel_params)), CPointer(uint32), CPointer(uint32), CPointer(int32)
        )
    )


    def temper_single_1_caller(arg_0, arg_1, arg_2, arg_3):
        return temper_single_1(arg_0, arg_1, arg_2, arg_3)


    @lower(temper_single, CPointer(_type_mtgp32_kernel_params), uint32, uint32, int32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            temper_single_1_caller,
            signature(uint32, CPointer(CPointer(_type_mtgp32_kernel_params)), CPointer(uint32), CPointer(uint32), CPointer(int32)),
            ptrs,
        )


_temper_single_1_lower()


def curand():
    pass



def _curand_1_lower():

    curand_1 = declare_device(
        'curand_1',
        uint32(
            CPointer(CPointer(_type_curandStateMtgp32))
        )
    )


    def curand_1_caller(arg_0):
        return curand_1(arg_0)


    @lower(curand, CPointer(_type_curandStateMtgp32))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_1_caller,
            signature(uint32, CPointer(CPointer(_type_curandStateMtgp32))),
            ptrs,
        )


_curand_1_lower()


def curand_mtgp32_specific():
    pass



def _curand_mtgp32_specific_1_lower():

    curand_mtgp32_specific_1 = declare_device(
        'curand_mtgp32_specific_1',
        uint32(
            CPointer(CPointer(_type_curandStateMtgp32)), CPointer(uint8), CPointer(uint8)
        )
    )


    def curand_mtgp32_specific_1_caller(arg_0, arg_1, arg_2):
        return curand_mtgp32_specific_1(arg_0, arg_1, arg_2)


    @lower(curand_mtgp32_specific, CPointer(_type_curandStateMtgp32), uint8, uint8)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_mtgp32_specific_1_caller,
            signature(uint32, CPointer(CPointer(_type_curandStateMtgp32)), CPointer(uint8), CPointer(uint8)),
            ptrs,
        )


_curand_mtgp32_specific_1_lower()


def curand_mtgp32_single():
    pass



def _curand_mtgp32_single_1_lower():

    curand_mtgp32_single_1 = declare_device(
        'curand_mtgp32_single_1',
        float32(
            CPointer(CPointer(_type_curandStateMtgp32))
        )
    )


    def curand_mtgp32_single_1_caller(arg_0):
        return curand_mtgp32_single_1(arg_0)


    @lower(curand_mtgp32_single, CPointer(_type_curandStateMtgp32))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_mtgp32_single_1_caller,
            signature(float32, CPointer(CPointer(_type_curandStateMtgp32))),
            ptrs,
        )


_curand_mtgp32_single_1_lower()


def curand_mtgp32_single_specific():
    pass



def _curand_mtgp32_single_specific_1_lower():

    curand_mtgp32_single_specific_1 = declare_device(
        'curand_mtgp32_single_specific_1',
        float32(
            CPointer(CPointer(_type_curandStateMtgp32)), CPointer(uint8), CPointer(uint8)
        )
    )


    def curand_mtgp32_single_specific_1_caller(arg_0, arg_1, arg_2):
        return curand_mtgp32_single_specific_1(arg_0, arg_1, arg_2)


    @lower(curand_mtgp32_single_specific, CPointer(_type_curandStateMtgp32), uint8, uint8)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_mtgp32_single_specific_1_caller,
            signature(float32, CPointer(CPointer(_type_curandStateMtgp32)), CPointer(uint8), CPointer(uint8)),
            ptrs,
        )


_curand_mtgp32_single_specific_1_lower()


def Philox_State_Incr():
    pass



def _Philox_State_Incr_1_lower():

    Philox_State_Incr_1 = declare_device(
        'Philox_State_Incr_1',
        none(
            CPointer(CPointer(_type_curandStatePhilox4_32_10)), CPointer(uint64)
        )
    )


    def Philox_State_Incr_1_caller(arg_0, arg_1):
        return Philox_State_Incr_1(arg_0, arg_1)


    @lower(Philox_State_Incr, CPointer(_type_curandStatePhilox4_32_10), uint64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            Philox_State_Incr_1_caller,
            signature(none, CPointer(CPointer(_type_curandStatePhilox4_32_10)), CPointer(uint64)),
            ptrs,
        )


_Philox_State_Incr_1_lower()


def Philox_State_Incr_hi():
    pass



def _Philox_State_Incr_hi_1_lower():

    Philox_State_Incr_hi_1 = declare_device(
        'Philox_State_Incr_hi_1',
        none(
            CPointer(CPointer(_type_curandStatePhilox4_32_10)), CPointer(uint64)
        )
    )


    def Philox_State_Incr_hi_1_caller(arg_0, arg_1):
        return Philox_State_Incr_hi_1(arg_0, arg_1)


    @lower(Philox_State_Incr_hi, CPointer(_type_curandStatePhilox4_32_10), uint64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            Philox_State_Incr_hi_1_caller,
            signature(none, CPointer(CPointer(_type_curandStatePhilox4_32_10)), CPointer(uint64)),
            ptrs,
        )


_Philox_State_Incr_hi_1_lower()




def _Philox_State_Incr_2_lower():

    Philox_State_Incr_2 = declare_device(
        'Philox_State_Incr_2',
        none(
            CPointer(CPointer(_type_curandStatePhilox4_32_10))
        )
    )


    def Philox_State_Incr_2_caller(arg_0):
        return Philox_State_Incr_2(arg_0)


    @lower(Philox_State_Incr, CPointer(_type_curandStatePhilox4_32_10))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            Philox_State_Incr_2_caller,
            signature(none, CPointer(CPointer(_type_curandStatePhilox4_32_10))),
            ptrs,
        )


_Philox_State_Incr_2_lower()


def mulhilo32():
    pass



def _mulhilo32_1_lower():

    mulhilo32_1 = declare_device(
        'mulhilo32_1',
        uint32(
            CPointer(uint32), CPointer(uint32), CPointer(CPointer(uint32))
        )
    )


    def mulhilo32_1_caller(arg_0, arg_1, arg_2):
        return mulhilo32_1(arg_0, arg_1, arg_2)


    @lower(mulhilo32, uint32, uint32, CPointer(uint32))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            mulhilo32_1_caller,
            signature(uint32, CPointer(uint32), CPointer(uint32), CPointer(CPointer(uint32))),
            ptrs,
        )


_mulhilo32_1_lower()


def _philox4x32round():
    pass



def __philox4x32round_1_lower():

    _philox4x32round_1 = declare_device(
        '_philox4x32round_1',
        uint32x4(
            CPointer(uint32x4), CPointer(uint32x2)
        )
    )


    def _philox4x32round_1_caller(arg_0, arg_1):
        return _philox4x32round_1(arg_0, arg_1)


    @lower(_philox4x32round, uint32x4, uint32x2)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _philox4x32round_1_caller,
            signature(uint32x4, CPointer(uint32x4), CPointer(uint32x2)),
            ptrs,
        )


__philox4x32round_1_lower()


def curand_Philox4x32_10():
    pass



def _curand_Philox4x32_10_1_lower():

    curand_Philox4x32_10_1 = declare_device(
        'curand_Philox4x32_10_1',
        uint32x4(
            CPointer(uint32x4), CPointer(uint32x2)
        )
    )


    def curand_Philox4x32_10_1_caller(arg_0, arg_1):
        return curand_Philox4x32_10_1(arg_0, arg_1)


    @lower(curand_Philox4x32_10, uint32x4, uint32x2)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_Philox4x32_10_1_caller,
            signature(uint32x4, CPointer(uint32x4), CPointer(uint32x2)),
            ptrs,
        )


_curand_Philox4x32_10_1_lower()


def __curand_matvec():
    pass



def ___curand_matvec_1_lower():

    __curand_matvec_1 = declare_device(
        '__curand_matvec_1',
        none(
            CPointer(CPointer(uint32)), CPointer(CPointer(uint32)), CPointer(CPointer(uint32)), CPointer(int32)
        )
    )


    def __curand_matvec_1_caller(arg_0, arg_1, arg_2, arg_3):
        return __curand_matvec_1(arg_0, arg_1, arg_2, arg_3)


    @lower(__curand_matvec, CPointer(uint32), CPointer(uint32), CPointer(uint32), int32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            __curand_matvec_1_caller,
            signature(none, CPointer(CPointer(uint32)), CPointer(CPointer(uint32)), CPointer(CPointer(uint32)), CPointer(int32)),
            ptrs,
        )


___curand_matvec_1_lower()


def __curand_matidentity():
    pass



def ___curand_matidentity_1_lower():

    __curand_matidentity_1 = declare_device(
        '__curand_matidentity_1',
        none(
            CPointer(CPointer(uint32)), CPointer(int32)
        )
    )


    def __curand_matidentity_1_caller(arg_0, arg_1):
        return __curand_matidentity_1(arg_0, arg_1)


    @lower(__curand_matidentity, CPointer(uint32), int32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            __curand_matidentity_1_caller,
            signature(none, CPointer(CPointer(uint32)), CPointer(int32)),
            ptrs,
        )


___curand_matidentity_1_lower()


def __curand_matmat():
    pass



def ___curand_matmat_1_lower():

    __curand_matmat_1 = declare_device(
        '__curand_matmat_1',
        none(
            CPointer(CPointer(uint32)), CPointer(CPointer(uint32)), CPointer(int32)
        )
    )


    def __curand_matmat_1_caller(arg_0, arg_1, arg_2):
        return __curand_matmat_1(arg_0, arg_1, arg_2)


    @lower(__curand_matmat, CPointer(uint32), CPointer(uint32), int32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            __curand_matmat_1_caller,
            signature(none, CPointer(CPointer(uint32)), CPointer(CPointer(uint32)), CPointer(int32)),
            ptrs,
        )


___curand_matmat_1_lower()


def __curand_veccopy():
    pass



def ___curand_veccopy_1_lower():

    __curand_veccopy_1 = declare_device(
        '__curand_veccopy_1',
        none(
            CPointer(CPointer(uint32)), CPointer(CPointer(uint32)), CPointer(int32)
        )
    )


    def __curand_veccopy_1_caller(arg_0, arg_1, arg_2):
        return __curand_veccopy_1(arg_0, arg_1, arg_2)


    @lower(__curand_veccopy, CPointer(uint32), CPointer(uint32), int32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            __curand_veccopy_1_caller,
            signature(none, CPointer(CPointer(uint32)), CPointer(CPointer(uint32)), CPointer(int32)),
            ptrs,
        )


___curand_veccopy_1_lower()


def __curand_matcopy():
    pass



def ___curand_matcopy_1_lower():

    __curand_matcopy_1 = declare_device(
        '__curand_matcopy_1',
        none(
            CPointer(CPointer(uint32)), CPointer(CPointer(uint32)), CPointer(int32)
        )
    )


    def __curand_matcopy_1_caller(arg_0, arg_1, arg_2):
        return __curand_matcopy_1(arg_0, arg_1, arg_2)


    @lower(__curand_matcopy, CPointer(uint32), CPointer(uint32), int32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            __curand_matcopy_1_caller,
            signature(none, CPointer(CPointer(uint32)), CPointer(CPointer(uint32)), CPointer(int32)),
            ptrs,
        )


___curand_matcopy_1_lower()


def __curand_matpow():
    pass



def ___curand_matpow_1_lower():

    __curand_matpow_1 = declare_device(
        '__curand_matpow_1',
        none(
            CPointer(CPointer(uint32)), CPointer(CPointer(uint32)), CPointer(uint64), CPointer(int32)
        )
    )


    def __curand_matpow_1_caller(arg_0, arg_1, arg_2, arg_3):
        return __curand_matpow_1(arg_0, arg_1, arg_2, arg_3)


    @lower(__curand_matpow, CPointer(uint32), CPointer(uint32), uint64, int32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            __curand_matpow_1_caller,
            signature(none, CPointer(CPointer(uint32)), CPointer(CPointer(uint32)), CPointer(uint64), CPointer(int32)),
            ptrs,
        )


___curand_matpow_1_lower()


def curand_MRGmod():
    pass



def _curand_MRGmod_1_lower():

    curand_MRGmod_1 = declare_device(
        'curand_MRGmod_1',
        float64(
            CPointer(float64), CPointer(float64)
        )
    )


    def curand_MRGmod_1_caller(arg_0, arg_1):
        return curand_MRGmod_1(arg_0, arg_1)


    @lower(curand_MRGmod, float64, float64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_MRGmod_1_caller,
            signature(float64, CPointer(float64), CPointer(float64)),
            ptrs,
        )


_curand_MRGmod_1_lower()


def curand_MRGmodMul():
    pass



def _curand_MRGmodMul_1_lower():

    curand_MRGmodMul_1 = declare_device(
        'curand_MRGmodMul_1',
        float64(
            CPointer(float64), CPointer(float64), CPointer(float64)
        )
    )


    def curand_MRGmodMul_1_caller(arg_0, arg_1, arg_2):
        return curand_MRGmodMul_1(arg_0, arg_1, arg_2)


    @lower(curand_MRGmodMul, float64, float64, float64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_MRGmodMul_1_caller,
            signature(float64, CPointer(float64), CPointer(float64), CPointer(float64)),
            ptrs,
        )


_curand_MRGmodMul_1_lower()


def curand_MRGmatMul3x3():
    pass



def _curand_MRGmatMul3x3_1_lower():

    curand_MRGmatMul3x3_1 = declare_device(
        'curand_MRGmatMul3x3_1',
        none(
            CPointer(CPointer(uint32)), CPointer(CPointer(uint32)), CPointer(CPointer(uint32)), CPointer(float64)
        )
    )


    def curand_MRGmatMul3x3_1_caller(arg_0, arg_1, arg_2, arg_3):
        return curand_MRGmatMul3x3_1(arg_0, arg_1, arg_2, arg_3)


    @lower(curand_MRGmatMul3x3, CPointer(uint32), CPointer(uint32), CPointer(uint32), float64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_MRGmatMul3x3_1_caller,
            signature(none, CPointer(CPointer(uint32)), CPointer(CPointer(uint32)), CPointer(CPointer(uint32)), CPointer(float64)),
            ptrs,
        )


_curand_MRGmatMul3x3_1_lower()


def curand_MRGmatVecMul3x3():
    pass



def _curand_MRGmatVecMul3x3_1_lower():

    curand_MRGmatVecMul3x3_1 = declare_device(
        'curand_MRGmatVecMul3x3_1',
        none(
            CPointer(CPointer(uint32)), CPointer(CPointer(uint32)), CPointer(float64)
        )
    )


    def curand_MRGmatVecMul3x3_1_caller(arg_0, arg_1, arg_2):
        return curand_MRGmatVecMul3x3_1(arg_0, arg_1, arg_2)


    @lower(curand_MRGmatVecMul3x3, CPointer(uint32), CPointer(uint32), float64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_MRGmatVecMul3x3_1_caller,
            signature(none, CPointer(CPointer(uint32)), CPointer(CPointer(uint32)), CPointer(float64)),
            ptrs,
        )


_curand_MRGmatVecMul3x3_1_lower()


def curand_MRGmatPow3x3():
    pass



def _curand_MRGmatPow3x3_1_lower():

    curand_MRGmatPow3x3_1 = declare_device(
        'curand_MRGmatPow3x3_1',
        none(
            CPointer(CPointer(uint32)), CPointer(CPointer(uint32)), CPointer(float64), CPointer(uint64)
        )
    )


    def curand_MRGmatPow3x3_1_caller(arg_0, arg_1, arg_2, arg_3):
        return curand_MRGmatPow3x3_1(arg_0, arg_1, arg_2, arg_3)


    @lower(curand_MRGmatPow3x3, CPointer(uint32), CPointer(uint32), float64, uint64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_MRGmatPow3x3_1_caller,
            signature(none, CPointer(CPointer(uint32)), CPointer(CPointer(uint32)), CPointer(float64), CPointer(uint64)),
            ptrs,
        )


_curand_MRGmatPow3x3_1_lower()


def curnand_MRGmatPow2Pow3x3():
    pass



def _curnand_MRGmatPow2Pow3x3_1_lower():

    curnand_MRGmatPow2Pow3x3_1 = declare_device(
        'curnand_MRGmatPow2Pow3x3_1',
        none(
            CPointer(CPointer(float64)), CPointer(CPointer(float64)), CPointer(float64), CPointer(uint64)
        )
    )


    def curnand_MRGmatPow2Pow3x3_1_caller(arg_0, arg_1, arg_2, arg_3):
        return curnand_MRGmatPow2Pow3x3_1(arg_0, arg_1, arg_2, arg_3)


    @lower(curnand_MRGmatPow2Pow3x3, CPointer(float64), CPointer(float64), float64, uint64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curnand_MRGmatPow2Pow3x3_1_caller,
            signature(none, CPointer(CPointer(float64)), CPointer(CPointer(float64)), CPointer(float64), CPointer(uint64)),
            ptrs,
        )


_curnand_MRGmatPow2Pow3x3_1_lower()


def curand_init():
    pass



def _curand_init_1_lower():

    curand_init_1 = declare_device(
        'curand_init_1',
        none(
            CPointer(uint64), CPointer(uint64), CPointer(uint64), CPointer(CPointer(_type_curandStateTest))
        )
    )


    def curand_init_1_caller(arg_0, arg_1, arg_2, arg_3):
        return curand_init_1(arg_0, arg_1, arg_2, arg_3)


    @lower(curand_init, uint64, uint64, uint64, CPointer(_type_curandStateTest))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_init_1_caller,
            signature(none, CPointer(uint64), CPointer(uint64), CPointer(uint64), CPointer(CPointer(_type_curandStateTest))),
            ptrs,
        )


_curand_init_1_lower()




def _curand_2_lower():

    curand_2 = declare_device(
        'curand_2',
        uint32(
            CPointer(CPointer(_type_curandStateTest))
        )
    )


    def curand_2_caller(arg_0):
        return curand_2(arg_0)


    @lower(curand, CPointer(_type_curandStateTest))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_2_caller,
            signature(uint32, CPointer(CPointer(_type_curandStateTest))),
            ptrs,
        )


_curand_2_lower()


def skipahead():
    pass



def _skipahead_1_lower():

    skipahead_1 = declare_device(
        'skipahead_1',
        none(
            CPointer(uint64), CPointer(CPointer(_type_curandStateTest))
        )
    )


    def skipahead_1_caller(arg_0, arg_1):
        return skipahead_1(arg_0, arg_1)


    @lower(skipahead, uint64, CPointer(_type_curandStateTest))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            skipahead_1_caller,
            signature(none, CPointer(uint64), CPointer(CPointer(_type_curandStateTest))),
            ptrs,
        )


_skipahead_1_lower()




def _skipahead_2_lower():

    skipahead_2 = declare_device(
        'skipahead_2',
        none(
            CPointer(uint64), CPointer(CPointer(_type_curandStateXORWOW))
        )
    )


    def skipahead_2_caller(arg_0, arg_1):
        return skipahead_2(arg_0, arg_1)


    @lower(skipahead, uint64, CPointer(_type_curandStateXORWOW))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            skipahead_2_caller,
            signature(none, CPointer(uint64), CPointer(CPointer(_type_curandStateXORWOW))),
            ptrs,
        )


_skipahead_2_lower()


def skipahead_sequence():
    pass



def _skipahead_sequence_1_lower():

    skipahead_sequence_1 = declare_device(
        'skipahead_sequence_1',
        none(
            CPointer(uint64), CPointer(CPointer(_type_curandStateXORWOW))
        )
    )


    def skipahead_sequence_1_caller(arg_0, arg_1):
        return skipahead_sequence_1(arg_0, arg_1)


    @lower(skipahead_sequence, uint64, CPointer(_type_curandStateXORWOW))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            skipahead_sequence_1_caller,
            signature(none, CPointer(uint64), CPointer(CPointer(_type_curandStateXORWOW))),
            ptrs,
        )


_skipahead_sequence_1_lower()


def _curand_init_scratch():
    pass



def __curand_init_scratch_1_lower():

    _curand_init_scratch_1 = declare_device(
        '_curand_init_scratch_1',
        none(
            CPointer(uint64), CPointer(uint64), CPointer(uint64), CPointer(CPointer(_type_curandStateXORWOW)), CPointer(CPointer(uint32))
        )
    )


    def _curand_init_scratch_1_caller(arg_0, arg_1, arg_2, arg_3, arg_4):
        return _curand_init_scratch_1(arg_0, arg_1, arg_2, arg_3, arg_4)


    @lower(_curand_init_scratch, uint64, uint64, uint64, CPointer(_type_curandStateXORWOW), CPointer(uint32))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _curand_init_scratch_1_caller,
            signature(none, CPointer(uint64), CPointer(uint64), CPointer(uint64), CPointer(CPointer(_type_curandStateXORWOW)), CPointer(CPointer(uint32))),
            ptrs,
        )


__curand_init_scratch_1_lower()


def _curand_init_inplace():
    pass



def __curand_init_inplace_1_lower():

    _curand_init_inplace_1 = declare_device(
        '_curand_init_inplace_1',
        none(
            CPointer(uint64), CPointer(uint64), CPointer(uint64), CPointer(CPointer(_type_curandStateXORWOW))
        )
    )


    def _curand_init_inplace_1_caller(arg_0, arg_1, arg_2, arg_3):
        return _curand_init_inplace_1(arg_0, arg_1, arg_2, arg_3)


    @lower(_curand_init_inplace, uint64, uint64, uint64, CPointer(_type_curandStateXORWOW))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _curand_init_inplace_1_caller,
            signature(none, CPointer(uint64), CPointer(uint64), CPointer(uint64), CPointer(CPointer(_type_curandStateXORWOW))),
            ptrs,
        )


__curand_init_inplace_1_lower()




def _curand_init_2_lower():

    curand_init_2 = declare_device(
        'curand_init_2',
        none(
            CPointer(uint64), CPointer(uint64), CPointer(uint64), CPointer(CPointer(_type_curandStateXORWOW))
        )
    )


    def curand_init_2_caller(arg_0, arg_1, arg_2, arg_3):
        return curand_init_2(arg_0, arg_1, arg_2, arg_3)


    @lower(curand_init, uint64, uint64, uint64, CPointer(_type_curandStateXORWOW))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_init_2_caller,
            signature(none, CPointer(uint64), CPointer(uint64), CPointer(uint64), CPointer(CPointer(_type_curandStateXORWOW))),
            ptrs,
        )


_curand_init_2_lower()




def _curand_3_lower():

    curand_3 = declare_device(
        'curand_3',
        uint32(
            CPointer(CPointer(_type_curandStateXORWOW))
        )
    )


    def curand_3_caller(arg_0):
        return curand_3(arg_0)


    @lower(curand, CPointer(_type_curandStateXORWOW))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_3_caller,
            signature(uint32, CPointer(CPointer(_type_curandStateXORWOW))),
            ptrs,
        )


_curand_3_lower()




def _curand_4_lower():

    curand_4 = declare_device(
        'curand_4',
        uint32(
            CPointer(CPointer(_type_curandStatePhilox4_32_10))
        )
    )


    def curand_4_caller(arg_0):
        return curand_4(arg_0)


    @lower(curand, CPointer(_type_curandStatePhilox4_32_10))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_4_caller,
            signature(uint32, CPointer(CPointer(_type_curandStatePhilox4_32_10))),
            ptrs,
        )


_curand_4_lower()


def curand4():
    pass



def _curand4_1_lower():

    curand4_1 = declare_device(
        'curand4_1',
        uint32x4(
            CPointer(CPointer(_type_curandStatePhilox4_32_10))
        )
    )


    def curand4_1_caller(arg_0):
        return curand4_1(arg_0)


    @lower(curand4, CPointer(_type_curandStatePhilox4_32_10))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand4_1_caller,
            signature(uint32x4, CPointer(CPointer(_type_curandStatePhilox4_32_10))),
            ptrs,
        )


_curand4_1_lower()




def _skipahead_3_lower():

    skipahead_3 = declare_device(
        'skipahead_3',
        none(
            CPointer(uint64), CPointer(CPointer(_type_curandStatePhilox4_32_10))
        )
    )


    def skipahead_3_caller(arg_0, arg_1):
        return skipahead_3(arg_0, arg_1)


    @lower(skipahead, uint64, CPointer(_type_curandStatePhilox4_32_10))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            skipahead_3_caller,
            signature(none, CPointer(uint64), CPointer(CPointer(_type_curandStatePhilox4_32_10))),
            ptrs,
        )


_skipahead_3_lower()




def _skipahead_sequence_2_lower():

    skipahead_sequence_2 = declare_device(
        'skipahead_sequence_2',
        none(
            CPointer(uint64), CPointer(CPointer(_type_curandStatePhilox4_32_10))
        )
    )


    def skipahead_sequence_2_caller(arg_0, arg_1):
        return skipahead_sequence_2(arg_0, arg_1)


    @lower(skipahead_sequence, uint64, CPointer(_type_curandStatePhilox4_32_10))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            skipahead_sequence_2_caller,
            signature(none, CPointer(uint64), CPointer(CPointer(_type_curandStatePhilox4_32_10))),
            ptrs,
        )


_skipahead_sequence_2_lower()




def _curand_init_3_lower():

    curand_init_3 = declare_device(
        'curand_init_3',
        none(
            CPointer(uint64), CPointer(uint64), CPointer(uint64), CPointer(CPointer(_type_curandStatePhilox4_32_10))
        )
    )


    def curand_init_3_caller(arg_0, arg_1, arg_2, arg_3):
        return curand_init_3(arg_0, arg_1, arg_2, arg_3)


    @lower(curand_init, uint64, uint64, uint64, CPointer(_type_curandStatePhilox4_32_10))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_init_3_caller,
            signature(none, CPointer(uint64), CPointer(uint64), CPointer(uint64), CPointer(CPointer(_type_curandStatePhilox4_32_10))),
            ptrs,
        )


_curand_init_3_lower()


def __curand_umad():
    pass



def ___curand_umad_1_lower():

    __curand_umad_1 = declare_device(
        '__curand_umad_1',
        uint64(
            CPointer(uint32), CPointer(uint32), CPointer(uint64)
        )
    )


    def __curand_umad_1_caller(arg_0, arg_1, arg_2):
        return __curand_umad_1(arg_0, arg_1, arg_2)


    @lower(__curand_umad, uint32, uint32, uint64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            __curand_umad_1_caller,
            signature(uint64, CPointer(uint32), CPointer(uint32), CPointer(uint64)),
            ptrs,
        )


___curand_umad_1_lower()


def __curand_umul():
    pass



def ___curand_umul_1_lower():

    __curand_umul_1 = declare_device(
        '__curand_umul_1',
        uint64(
            CPointer(uint32), CPointer(uint32)
        )
    )


    def __curand_umul_1_caller(arg_0, arg_1):
        return __curand_umul_1(arg_0, arg_1)


    @lower(__curand_umul, uint32, uint32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            __curand_umul_1_caller,
            signature(uint64, CPointer(uint32), CPointer(uint32)),
            ptrs,
        )


___curand_umul_1_lower()


def curand_MRG32k3a():
    pass



def _curand_MRG32k3a_1_lower():

    curand_MRG32k3a_1 = declare_device(
        'curand_MRG32k3a_1',
        float64(
            CPointer(CPointer(_type_curandStateMRG32k3a))
        )
    )


    def curand_MRG32k3a_1_caller(arg_0):
        return curand_MRG32k3a_1(arg_0)


    @lower(curand_MRG32k3a, CPointer(_type_curandStateMRG32k3a))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_MRG32k3a_1_caller,
            signature(float64, CPointer(CPointer(_type_curandStateMRG32k3a))),
            ptrs,
        )


_curand_MRG32k3a_1_lower()




def _curand_5_lower():

    curand_5 = declare_device(
        'curand_5',
        uint32(
            CPointer(CPointer(_type_curandStateMRG32k3a))
        )
    )


    def curand_5_caller(arg_0):
        return curand_5(arg_0)


    @lower(curand, CPointer(_type_curandStateMRG32k3a))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_5_caller,
            signature(uint32, CPointer(CPointer(_type_curandStateMRG32k3a))),
            ptrs,
        )


_curand_5_lower()




def _skipahead_4_lower():

    skipahead_4 = declare_device(
        'skipahead_4',
        none(
            CPointer(uint64), CPointer(CPointer(_type_curandStateMRG32k3a))
        )
    )


    def skipahead_4_caller(arg_0, arg_1):
        return skipahead_4(arg_0, arg_1)


    @lower(skipahead, uint64, CPointer(_type_curandStateMRG32k3a))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            skipahead_4_caller,
            signature(none, CPointer(uint64), CPointer(CPointer(_type_curandStateMRG32k3a))),
            ptrs,
        )


_skipahead_4_lower()


def skipahead_subsequence():
    pass



def _skipahead_subsequence_1_lower():

    skipahead_subsequence_1 = declare_device(
        'skipahead_subsequence_1',
        none(
            CPointer(uint64), CPointer(CPointer(_type_curandStateMRG32k3a))
        )
    )


    def skipahead_subsequence_1_caller(arg_0, arg_1):
        return skipahead_subsequence_1(arg_0, arg_1)


    @lower(skipahead_subsequence, uint64, CPointer(_type_curandStateMRG32k3a))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            skipahead_subsequence_1_caller,
            signature(none, CPointer(uint64), CPointer(CPointer(_type_curandStateMRG32k3a))),
            ptrs,
        )


_skipahead_subsequence_1_lower()




def _skipahead_sequence_3_lower():

    skipahead_sequence_3 = declare_device(
        'skipahead_sequence_3',
        none(
            CPointer(uint64), CPointer(CPointer(_type_curandStateMRG32k3a))
        )
    )


    def skipahead_sequence_3_caller(arg_0, arg_1):
        return skipahead_sequence_3(arg_0, arg_1)


    @lower(skipahead_sequence, uint64, CPointer(_type_curandStateMRG32k3a))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            skipahead_sequence_3_caller,
            signature(none, CPointer(uint64), CPointer(CPointer(_type_curandStateMRG32k3a))),
            ptrs,
        )


_skipahead_sequence_3_lower()




def _curand_init_4_lower():

    curand_init_4 = declare_device(
        'curand_init_4',
        none(
            CPointer(uint64), CPointer(uint64), CPointer(uint64), CPointer(CPointer(_type_curandStateMRG32k3a))
        )
    )


    def curand_init_4_caller(arg_0, arg_1, arg_2, arg_3):
        return curand_init_4(arg_0, arg_1, arg_2, arg_3)


    @lower(curand_init, uint64, uint64, uint64, CPointer(_type_curandStateMRG32k3a))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_init_4_caller,
            signature(none, CPointer(uint64), CPointer(uint64), CPointer(uint64), CPointer(CPointer(_type_curandStateMRG32k3a))),
            ptrs,
        )


_curand_init_4_lower()




def _curand_init_5_lower():

    curand_init_5 = declare_device(
        'curand_init_5',
        none(
            CPointer(CPointer(uint32)), CPointer(uint32), CPointer(CPointer(_type_curandStateSobol32))
        )
    )


    def curand_init_5_caller(arg_0, arg_1, arg_2):
        return curand_init_5(arg_0, arg_1, arg_2)


    @lower(curand_init, CPointer(uint32), uint32, CPointer(_type_curandStateSobol32))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_init_5_caller,
            signature(none, CPointer(CPointer(uint32)), CPointer(uint32), CPointer(CPointer(_type_curandStateSobol32))),
            ptrs,
        )


_curand_init_5_lower()




def _curand_init_6_lower():

    curand_init_6 = declare_device(
        'curand_init_6',
        none(
            CPointer(CPointer(uint32)), CPointer(uint32), CPointer(uint32), CPointer(CPointer(_type_curandStateScrambledSobol32))
        )
    )


    def curand_init_6_caller(arg_0, arg_1, arg_2, arg_3):
        return curand_init_6(arg_0, arg_1, arg_2, arg_3)


    @lower(curand_init, CPointer(uint32), uint32, uint32, CPointer(_type_curandStateScrambledSobol32))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_init_6_caller,
            signature(none, CPointer(CPointer(uint32)), CPointer(uint32), CPointer(uint32), CPointer(CPointer(_type_curandStateScrambledSobol32))),
            ptrs,
        )


_curand_init_6_lower()


def __curand_find_trailing_zero():
    pass



def ___curand_find_trailing_zero_1_lower():

    __curand_find_trailing_zero_1 = declare_device(
        '__curand_find_trailing_zero_1',
        int32(
            CPointer(uint32)
        )
    )


    def __curand_find_trailing_zero_1_caller(arg_0):
        return __curand_find_trailing_zero_1(arg_0)


    @lower(__curand_find_trailing_zero, uint32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            __curand_find_trailing_zero_1_caller,
            signature(int32, CPointer(uint32)),
            ptrs,
        )


___curand_find_trailing_zero_1_lower()




def ___curand_find_trailing_zero_2_lower():

    __curand_find_trailing_zero_2 = declare_device(
        '__curand_find_trailing_zero_2',
        int32(
            CPointer(uint64)
        )
    )


    def __curand_find_trailing_zero_2_caller(arg_0):
        return __curand_find_trailing_zero_2(arg_0)


    @lower(__curand_find_trailing_zero, uint64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            __curand_find_trailing_zero_2_caller,
            signature(int32, CPointer(uint64)),
            ptrs,
        )


___curand_find_trailing_zero_2_lower()




def _curand_init_7_lower():

    curand_init_7 = declare_device(
        'curand_init_7',
        none(
            CPointer(CPointer(uint64)), CPointer(uint64), CPointer(CPointer(_type_curandStateSobol64))
        )
    )


    def curand_init_7_caller(arg_0, arg_1, arg_2):
        return curand_init_7(arg_0, arg_1, arg_2)


    @lower(curand_init, CPointer(uint64), uint64, CPointer(_type_curandStateSobol64))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_init_7_caller,
            signature(none, CPointer(CPointer(uint64)), CPointer(uint64), CPointer(CPointer(_type_curandStateSobol64))),
            ptrs,
        )


_curand_init_7_lower()




def _curand_init_8_lower():

    curand_init_8 = declare_device(
        'curand_init_8',
        none(
            CPointer(CPointer(uint64)), CPointer(uint64), CPointer(uint64), CPointer(CPointer(_type_curandStateScrambledSobol64))
        )
    )


    def curand_init_8_caller(arg_0, arg_1, arg_2, arg_3):
        return curand_init_8(arg_0, arg_1, arg_2, arg_3)


    @lower(curand_init, CPointer(uint64), uint64, uint64, CPointer(_type_curandStateScrambledSobol64))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_init_8_caller,
            signature(none, CPointer(CPointer(uint64)), CPointer(uint64), CPointer(uint64), CPointer(CPointer(_type_curandStateScrambledSobol64))),
            ptrs,
        )


_curand_init_8_lower()




def _curand_6_lower():

    curand_6 = declare_device(
        'curand_6',
        uint32(
            CPointer(CPointer(_type_curandStateSobol32))
        )
    )


    def curand_6_caller(arg_0):
        return curand_6(arg_0)


    @lower(curand, CPointer(_type_curandStateSobol32))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_6_caller,
            signature(uint32, CPointer(CPointer(_type_curandStateSobol32))),
            ptrs,
        )


_curand_6_lower()




def _curand_7_lower():

    curand_7 = declare_device(
        'curand_7',
        uint32(
            CPointer(CPointer(_type_curandStateScrambledSobol32))
        )
    )


    def curand_7_caller(arg_0):
        return curand_7(arg_0)


    @lower(curand, CPointer(_type_curandStateScrambledSobol32))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_7_caller,
            signature(uint32, CPointer(CPointer(_type_curandStateScrambledSobol32))),
            ptrs,
        )


_curand_7_lower()




def _curand_8_lower():

    curand_8 = declare_device(
        'curand_8',
        uint64(
            CPointer(CPointer(_type_curandStateSobol64))
        )
    )


    def curand_8_caller(arg_0):
        return curand_8(arg_0)


    @lower(curand, CPointer(_type_curandStateSobol64))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_8_caller,
            signature(uint64, CPointer(CPointer(_type_curandStateSobol64))),
            ptrs,
        )


_curand_8_lower()




def _curand_9_lower():

    curand_9 = declare_device(
        'curand_9',
        uint64(
            CPointer(CPointer(_type_curandStateScrambledSobol64))
        )
    )


    def curand_9_caller(arg_0):
        return curand_9(arg_0)


    @lower(curand, CPointer(_type_curandStateScrambledSobol64))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_9_caller,
            signature(uint64, CPointer(CPointer(_type_curandStateScrambledSobol64))),
            ptrs,
        )


_curand_9_lower()


def _curand_uniform():
    pass



def __curand_uniform_1_lower():

    _curand_uniform_1 = declare_device(
        '_curand_uniform_1',
        float32(
            CPointer(uint32)
        )
    )


    def _curand_uniform_1_caller(arg_0):
        return _curand_uniform_1(arg_0)


    @lower(_curand_uniform, uint32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _curand_uniform_1_caller,
            signature(float32, CPointer(uint32)),
            ptrs,
        )


__curand_uniform_1_lower()


def _curand_uniform4():
    pass



def __curand_uniform4_1_lower():

    _curand_uniform4_1 = declare_device(
        '_curand_uniform4_1',
        float32x4(
            CPointer(uint32x4)
        )
    )


    def _curand_uniform4_1_caller(arg_0):
        return _curand_uniform4_1(arg_0)


    @lower(_curand_uniform4, uint32x4)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _curand_uniform4_1_caller,
            signature(float32x4, CPointer(uint32x4)),
            ptrs,
        )


__curand_uniform4_1_lower()




def __curand_uniform_2_lower():

    _curand_uniform_2 = declare_device(
        '_curand_uniform_2',
        float32(
            CPointer(uint64)
        )
    )


    def _curand_uniform_2_caller(arg_0):
        return _curand_uniform_2(arg_0)


    @lower(_curand_uniform, uint64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _curand_uniform_2_caller,
            signature(float32, CPointer(uint64)),
            ptrs,
        )


__curand_uniform_2_lower()


def _curand_uniform_double():
    pass



def __curand_uniform_double_1_lower():

    _curand_uniform_double_1 = declare_device(
        '_curand_uniform_double_1',
        float64(
            CPointer(uint32)
        )
    )


    def _curand_uniform_double_1_caller(arg_0):
        return _curand_uniform_double_1(arg_0)


    @lower(_curand_uniform_double, uint32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _curand_uniform_double_1_caller,
            signature(float64, CPointer(uint32)),
            ptrs,
        )


__curand_uniform_double_1_lower()




def __curand_uniform_double_2_lower():

    _curand_uniform_double_2 = declare_device(
        '_curand_uniform_double_2',
        float64(
            CPointer(uint64)
        )
    )


    def _curand_uniform_double_2_caller(arg_0):
        return _curand_uniform_double_2(arg_0)


    @lower(_curand_uniform_double, uint64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _curand_uniform_double_2_caller,
            signature(float64, CPointer(uint64)),
            ptrs,
        )


__curand_uniform_double_2_lower()


def _curand_uniform_double_hq():
    pass



def __curand_uniform_double_hq_1_lower():

    _curand_uniform_double_hq_1 = declare_device(
        '_curand_uniform_double_hq_1',
        float64(
            CPointer(uint32), CPointer(uint32)
        )
    )


    def _curand_uniform_double_hq_1_caller(arg_0, arg_1):
        return _curand_uniform_double_hq_1(arg_0, arg_1)


    @lower(_curand_uniform_double_hq, uint32, uint32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _curand_uniform_double_hq_1_caller,
            signature(float64, CPointer(uint32), CPointer(uint32)),
            ptrs,
        )


__curand_uniform_double_hq_1_lower()


def curand_uniform():
    pass



def _curand_uniform_1_lower():

    curand_uniform_1 = declare_device(
        'curand_uniform_1',
        float32(
            CPointer(CPointer(_type_curandStateTest))
        )
    )


    def curand_uniform_1_caller(arg_0):
        return curand_uniform_1(arg_0)


    @lower(curand_uniform, CPointer(_type_curandStateTest))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_uniform_1_caller,
            signature(float32, CPointer(CPointer(_type_curandStateTest))),
            ptrs,
        )


_curand_uniform_1_lower()


def curand_uniform_double():
    pass



def _curand_uniform_double_1_lower():

    curand_uniform_double_1 = declare_device(
        'curand_uniform_double_1',
        float64(
            CPointer(CPointer(_type_curandStateTest))
        )
    )


    def curand_uniform_double_1_caller(arg_0):
        return curand_uniform_double_1(arg_0)


    @lower(curand_uniform_double, CPointer(_type_curandStateTest))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_uniform_double_1_caller,
            signature(float64, CPointer(CPointer(_type_curandStateTest))),
            ptrs,
        )


_curand_uniform_double_1_lower()




def _curand_uniform_2_lower():

    curand_uniform_2 = declare_device(
        'curand_uniform_2',
        float32(
            CPointer(CPointer(_type_curandStateXORWOW))
        )
    )


    def curand_uniform_2_caller(arg_0):
        return curand_uniform_2(arg_0)


    @lower(curand_uniform, CPointer(_type_curandStateXORWOW))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_uniform_2_caller,
            signature(float32, CPointer(CPointer(_type_curandStateXORWOW))),
            ptrs,
        )


_curand_uniform_2_lower()




def _curand_uniform_double_2_lower():

    curand_uniform_double_2 = declare_device(
        'curand_uniform_double_2',
        float64(
            CPointer(CPointer(_type_curandStateXORWOW))
        )
    )


    def curand_uniform_double_2_caller(arg_0):
        return curand_uniform_double_2(arg_0)


    @lower(curand_uniform_double, CPointer(_type_curandStateXORWOW))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_uniform_double_2_caller,
            signature(float64, CPointer(CPointer(_type_curandStateXORWOW))),
            ptrs,
        )


_curand_uniform_double_2_lower()




def _curand_uniform_3_lower():

    curand_uniform_3 = declare_device(
        'curand_uniform_3',
        float32(
            CPointer(CPointer(_type_curandStateMRG32k3a))
        )
    )


    def curand_uniform_3_caller(arg_0):
        return curand_uniform_3(arg_0)


    @lower(curand_uniform, CPointer(_type_curandStateMRG32k3a))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_uniform_3_caller,
            signature(float32, CPointer(CPointer(_type_curandStateMRG32k3a))),
            ptrs,
        )


_curand_uniform_3_lower()




def _curand_uniform_double_3_lower():

    curand_uniform_double_3 = declare_device(
        'curand_uniform_double_3',
        float64(
            CPointer(CPointer(_type_curandStateMRG32k3a))
        )
    )


    def curand_uniform_double_3_caller(arg_0):
        return curand_uniform_double_3(arg_0)


    @lower(curand_uniform_double, CPointer(_type_curandStateMRG32k3a))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_uniform_double_3_caller,
            signature(float64, CPointer(CPointer(_type_curandStateMRG32k3a))),
            ptrs,
        )


_curand_uniform_double_3_lower()


def curand_uniform2_double():
    pass



def _curand_uniform2_double_1_lower():

    curand_uniform2_double_1 = declare_device(
        'curand_uniform2_double_1',
        float64x2(
            CPointer(CPointer(_type_curandStatePhilox4_32_10))
        )
    )


    def curand_uniform2_double_1_caller(arg_0):
        return curand_uniform2_double_1(arg_0)


    @lower(curand_uniform2_double, CPointer(_type_curandStatePhilox4_32_10))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_uniform2_double_1_caller,
            signature(float64x2, CPointer(CPointer(_type_curandStatePhilox4_32_10))),
            ptrs,
        )


_curand_uniform2_double_1_lower()


def curand_uniform4_double():
    pass



def _curand_uniform4_double_1_lower():

    curand_uniform4_double_1 = declare_device(
        'curand_uniform4_double_1',
        float64x4(
            CPointer(CPointer(_type_curandStatePhilox4_32_10))
        )
    )


    def curand_uniform4_double_1_caller(arg_0):
        return curand_uniform4_double_1(arg_0)


    @lower(curand_uniform4_double, CPointer(_type_curandStatePhilox4_32_10))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_uniform4_double_1_caller,
            signature(float64x4, CPointer(CPointer(_type_curandStatePhilox4_32_10))),
            ptrs,
        )


_curand_uniform4_double_1_lower()




def _curand_uniform_4_lower():

    curand_uniform_4 = declare_device(
        'curand_uniform_4',
        float32(
            CPointer(CPointer(_type_curandStatePhilox4_32_10))
        )
    )


    def curand_uniform_4_caller(arg_0):
        return curand_uniform_4(arg_0)


    @lower(curand_uniform, CPointer(_type_curandStatePhilox4_32_10))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_uniform_4_caller,
            signature(float32, CPointer(CPointer(_type_curandStatePhilox4_32_10))),
            ptrs,
        )


_curand_uniform_4_lower()


def curand_uniform4():
    pass



def _curand_uniform4_1_lower():

    curand_uniform4_1 = declare_device(
        'curand_uniform4_1',
        float32x4(
            CPointer(CPointer(_type_curandStatePhilox4_32_10))
        )
    )


    def curand_uniform4_1_caller(arg_0):
        return curand_uniform4_1(arg_0)


    @lower(curand_uniform4, CPointer(_type_curandStatePhilox4_32_10))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_uniform4_1_caller,
            signature(float32x4, CPointer(CPointer(_type_curandStatePhilox4_32_10))),
            ptrs,
        )


_curand_uniform4_1_lower()




def _curand_uniform_5_lower():

    curand_uniform_5 = declare_device(
        'curand_uniform_5',
        float32(
            CPointer(CPointer(_type_curandStateMtgp32))
        )
    )


    def curand_uniform_5_caller(arg_0):
        return curand_uniform_5(arg_0)


    @lower(curand_uniform, CPointer(_type_curandStateMtgp32))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_uniform_5_caller,
            signature(float32, CPointer(CPointer(_type_curandStateMtgp32))),
            ptrs,
        )


_curand_uniform_5_lower()




def _curand_uniform_double_4_lower():

    curand_uniform_double_4 = declare_device(
        'curand_uniform_double_4',
        float64(
            CPointer(CPointer(_type_curandStateMtgp32))
        )
    )


    def curand_uniform_double_4_caller(arg_0):
        return curand_uniform_double_4(arg_0)


    @lower(curand_uniform_double, CPointer(_type_curandStateMtgp32))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_uniform_double_4_caller,
            signature(float64, CPointer(CPointer(_type_curandStateMtgp32))),
            ptrs,
        )


_curand_uniform_double_4_lower()




def _curand_uniform_double_5_lower():

    curand_uniform_double_5 = declare_device(
        'curand_uniform_double_5',
        float64(
            CPointer(CPointer(_type_curandStatePhilox4_32_10))
        )
    )


    def curand_uniform_double_5_caller(arg_0):
        return curand_uniform_double_5(arg_0)


    @lower(curand_uniform_double, CPointer(_type_curandStatePhilox4_32_10))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_uniform_double_5_caller,
            signature(float64, CPointer(CPointer(_type_curandStatePhilox4_32_10))),
            ptrs,
        )


_curand_uniform_double_5_lower()




def _curand_uniform_6_lower():

    curand_uniform_6 = declare_device(
        'curand_uniform_6',
        float32(
            CPointer(CPointer(_type_curandStateSobol32))
        )
    )


    def curand_uniform_6_caller(arg_0):
        return curand_uniform_6(arg_0)


    @lower(curand_uniform, CPointer(_type_curandStateSobol32))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_uniform_6_caller,
            signature(float32, CPointer(CPointer(_type_curandStateSobol32))),
            ptrs,
        )


_curand_uniform_6_lower()




def _curand_uniform_double_6_lower():

    curand_uniform_double_6 = declare_device(
        'curand_uniform_double_6',
        float64(
            CPointer(CPointer(_type_curandStateSobol32))
        )
    )


    def curand_uniform_double_6_caller(arg_0):
        return curand_uniform_double_6(arg_0)


    @lower(curand_uniform_double, CPointer(_type_curandStateSobol32))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_uniform_double_6_caller,
            signature(float64, CPointer(CPointer(_type_curandStateSobol32))),
            ptrs,
        )


_curand_uniform_double_6_lower()




def _curand_uniform_7_lower():

    curand_uniform_7 = declare_device(
        'curand_uniform_7',
        float32(
            CPointer(CPointer(_type_curandStateScrambledSobol32))
        )
    )


    def curand_uniform_7_caller(arg_0):
        return curand_uniform_7(arg_0)


    @lower(curand_uniform, CPointer(_type_curandStateScrambledSobol32))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_uniform_7_caller,
            signature(float32, CPointer(CPointer(_type_curandStateScrambledSobol32))),
            ptrs,
        )


_curand_uniform_7_lower()




def _curand_uniform_double_7_lower():

    curand_uniform_double_7 = declare_device(
        'curand_uniform_double_7',
        float64(
            CPointer(CPointer(_type_curandStateScrambledSobol32))
        )
    )


    def curand_uniform_double_7_caller(arg_0):
        return curand_uniform_double_7(arg_0)


    @lower(curand_uniform_double, CPointer(_type_curandStateScrambledSobol32))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_uniform_double_7_caller,
            signature(float64, CPointer(CPointer(_type_curandStateScrambledSobol32))),
            ptrs,
        )


_curand_uniform_double_7_lower()




def _curand_uniform_8_lower():

    curand_uniform_8 = declare_device(
        'curand_uniform_8',
        float32(
            CPointer(CPointer(_type_curandStateSobol64))
        )
    )


    def curand_uniform_8_caller(arg_0):
        return curand_uniform_8(arg_0)


    @lower(curand_uniform, CPointer(_type_curandStateSobol64))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_uniform_8_caller,
            signature(float32, CPointer(CPointer(_type_curandStateSobol64))),
            ptrs,
        )


_curand_uniform_8_lower()




def _curand_uniform_double_8_lower():

    curand_uniform_double_8 = declare_device(
        'curand_uniform_double_8',
        float64(
            CPointer(CPointer(_type_curandStateSobol64))
        )
    )


    def curand_uniform_double_8_caller(arg_0):
        return curand_uniform_double_8(arg_0)


    @lower(curand_uniform_double, CPointer(_type_curandStateSobol64))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_uniform_double_8_caller,
            signature(float64, CPointer(CPointer(_type_curandStateSobol64))),
            ptrs,
        )


_curand_uniform_double_8_lower()




def _curand_uniform_9_lower():

    curand_uniform_9 = declare_device(
        'curand_uniform_9',
        float32(
            CPointer(CPointer(_type_curandStateScrambledSobol64))
        )
    )


    def curand_uniform_9_caller(arg_0):
        return curand_uniform_9(arg_0)


    @lower(curand_uniform, CPointer(_type_curandStateScrambledSobol64))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_uniform_9_caller,
            signature(float32, CPointer(CPointer(_type_curandStateScrambledSobol64))),
            ptrs,
        )


_curand_uniform_9_lower()




def _curand_uniform_double_9_lower():

    curand_uniform_double_9 = declare_device(
        'curand_uniform_double_9',
        float64(
            CPointer(CPointer(_type_curandStateScrambledSobol64))
        )
    )


    def curand_uniform_double_9_caller(arg_0):
        return curand_uniform_double_9(arg_0)


    @lower(curand_uniform_double, CPointer(_type_curandStateScrambledSobol64))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_uniform_double_9_caller,
            signature(float64, CPointer(CPointer(_type_curandStateScrambledSobol64))),
            ptrs,
        )


_curand_uniform_double_9_lower()


def _curand_normal_icdf():
    pass



def __curand_normal_icdf_1_lower():

    _curand_normal_icdf_1 = declare_device(
        '_curand_normal_icdf_1',
        float32(
            CPointer(uint32)
        )
    )


    def _curand_normal_icdf_1_caller(arg_0):
        return _curand_normal_icdf_1(arg_0)


    @lower(_curand_normal_icdf, uint32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _curand_normal_icdf_1_caller,
            signature(float32, CPointer(uint32)),
            ptrs,
        )


__curand_normal_icdf_1_lower()




def __curand_normal_icdf_2_lower():

    _curand_normal_icdf_2 = declare_device(
        '_curand_normal_icdf_2',
        float32(
            CPointer(uint64)
        )
    )


    def _curand_normal_icdf_2_caller(arg_0):
        return _curand_normal_icdf_2(arg_0)


    @lower(_curand_normal_icdf, uint64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _curand_normal_icdf_2_caller,
            signature(float32, CPointer(uint64)),
            ptrs,
        )


__curand_normal_icdf_2_lower()


def _curand_normal_icdf_double():
    pass



def __curand_normal_icdf_double_1_lower():

    _curand_normal_icdf_double_1 = declare_device(
        '_curand_normal_icdf_double_1',
        float64(
            CPointer(uint32)
        )
    )


    def _curand_normal_icdf_double_1_caller(arg_0):
        return _curand_normal_icdf_double_1(arg_0)


    @lower(_curand_normal_icdf_double, uint32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _curand_normal_icdf_double_1_caller,
            signature(float64, CPointer(uint32)),
            ptrs,
        )


__curand_normal_icdf_double_1_lower()




def __curand_normal_icdf_double_2_lower():

    _curand_normal_icdf_double_2 = declare_device(
        '_curand_normal_icdf_double_2',
        float64(
            CPointer(uint64)
        )
    )


    def _curand_normal_icdf_double_2_caller(arg_0):
        return _curand_normal_icdf_double_2(arg_0)


    @lower(_curand_normal_icdf_double, uint64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _curand_normal_icdf_double_2_caller,
            signature(float64, CPointer(uint64)),
            ptrs,
        )


__curand_normal_icdf_double_2_lower()


def _curand_box_muller():
    pass



def __curand_box_muller_1_lower():

    _curand_box_muller_1 = declare_device(
        '_curand_box_muller_1',
        float32x2(
            CPointer(uint32), CPointer(uint32)
        )
    )


    def _curand_box_muller_1_caller(arg_0, arg_1):
        return _curand_box_muller_1(arg_0, arg_1)


    @lower(_curand_box_muller, uint32, uint32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _curand_box_muller_1_caller,
            signature(float32x2, CPointer(uint32), CPointer(uint32)),
            ptrs,
        )


__curand_box_muller_1_lower()


def curand_box_muller_mrg():
    pass



def _curand_box_muller_mrg_1_lower():

    curand_box_muller_mrg_1 = declare_device(
        'curand_box_muller_mrg_1',
        float32x2(
            CPointer(CPointer(_type_curandStateMRG32k3a))
        )
    )


    def curand_box_muller_mrg_1_caller(arg_0):
        return curand_box_muller_mrg_1(arg_0)


    @lower(curand_box_muller_mrg, CPointer(_type_curandStateMRG32k3a))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_box_muller_mrg_1_caller,
            signature(float32x2, CPointer(CPointer(_type_curandStateMRG32k3a))),
            ptrs,
        )


_curand_box_muller_mrg_1_lower()


def _curand_box_muller_double():
    pass



def __curand_box_muller_double_1_lower():

    _curand_box_muller_double_1 = declare_device(
        '_curand_box_muller_double_1',
        float64x2(
            CPointer(uint32), CPointer(uint32), CPointer(uint32), CPointer(uint32)
        )
    )


    def _curand_box_muller_double_1_caller(arg_0, arg_1, arg_2, arg_3):
        return _curand_box_muller_double_1(arg_0, arg_1, arg_2, arg_3)


    @lower(_curand_box_muller_double, uint32, uint32, uint32, uint32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _curand_box_muller_double_1_caller,
            signature(float64x2, CPointer(uint32), CPointer(uint32), CPointer(uint32), CPointer(uint32)),
            ptrs,
        )


__curand_box_muller_double_1_lower()


def curand_box_muller_mrg_double():
    pass



def _curand_box_muller_mrg_double_1_lower():

    curand_box_muller_mrg_double_1 = declare_device(
        'curand_box_muller_mrg_double_1',
        float64x2(
            CPointer(CPointer(_type_curandStateMRG32k3a))
        )
    )


    def curand_box_muller_mrg_double_1_caller(arg_0):
        return curand_box_muller_mrg_double_1(arg_0)


    @lower(curand_box_muller_mrg_double, CPointer(_type_curandStateMRG32k3a))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_box_muller_mrg_double_1_caller,
            signature(float64x2, CPointer(CPointer(_type_curandStateMRG32k3a))),
            ptrs,
        )


_curand_box_muller_mrg_double_1_lower()


def curand_normal():
    pass



def _curand_normal_1_lower():

    curand_normal_1 = declare_device(
        'curand_normal_1',
        float32(
            CPointer(CPointer(_type_curandStateXORWOW))
        )
    )


    def curand_normal_1_caller(arg_0):
        return curand_normal_1(arg_0)


    @lower(curand_normal, CPointer(_type_curandStateXORWOW))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_normal_1_caller,
            signature(float32, CPointer(CPointer(_type_curandStateXORWOW))),
            ptrs,
        )


_curand_normal_1_lower()




def _curand_normal_2_lower():

    curand_normal_2 = declare_device(
        'curand_normal_2',
        float32(
            CPointer(CPointer(_type_curandStatePhilox4_32_10))
        )
    )


    def curand_normal_2_caller(arg_0):
        return curand_normal_2(arg_0)


    @lower(curand_normal, CPointer(_type_curandStatePhilox4_32_10))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_normal_2_caller,
            signature(float32, CPointer(CPointer(_type_curandStatePhilox4_32_10))),
            ptrs,
        )


_curand_normal_2_lower()




def _curand_normal_3_lower():

    curand_normal_3 = declare_device(
        'curand_normal_3',
        float32(
            CPointer(CPointer(_type_curandStateMRG32k3a))
        )
    )


    def curand_normal_3_caller(arg_0):
        return curand_normal_3(arg_0)


    @lower(curand_normal, CPointer(_type_curandStateMRG32k3a))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_normal_3_caller,
            signature(float32, CPointer(CPointer(_type_curandStateMRG32k3a))),
            ptrs,
        )


_curand_normal_3_lower()


def curand_normal2():
    pass



def _curand_normal2_1_lower():

    curand_normal2_1 = declare_device(
        'curand_normal2_1',
        float32x2(
            CPointer(CPointer(_type_curandStateXORWOW))
        )
    )


    def curand_normal2_1_caller(arg_0):
        return curand_normal2_1(arg_0)


    @lower(curand_normal2, CPointer(_type_curandStateXORWOW))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_normal2_1_caller,
            signature(float32x2, CPointer(CPointer(_type_curandStateXORWOW))),
            ptrs,
        )


_curand_normal2_1_lower()




def _curand_normal2_2_lower():

    curand_normal2_2 = declare_device(
        'curand_normal2_2',
        float32x2(
            CPointer(CPointer(_type_curandStatePhilox4_32_10))
        )
    )


    def curand_normal2_2_caller(arg_0):
        return curand_normal2_2(arg_0)


    @lower(curand_normal2, CPointer(_type_curandStatePhilox4_32_10))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_normal2_2_caller,
            signature(float32x2, CPointer(CPointer(_type_curandStatePhilox4_32_10))),
            ptrs,
        )


_curand_normal2_2_lower()


def curand_normal4():
    pass



def _curand_normal4_1_lower():

    curand_normal4_1 = declare_device(
        'curand_normal4_1',
        float32x4(
            CPointer(CPointer(_type_curandStatePhilox4_32_10))
        )
    )


    def curand_normal4_1_caller(arg_0):
        return curand_normal4_1(arg_0)


    @lower(curand_normal4, CPointer(_type_curandStatePhilox4_32_10))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_normal4_1_caller,
            signature(float32x4, CPointer(CPointer(_type_curandStatePhilox4_32_10))),
            ptrs,
        )


_curand_normal4_1_lower()




def _curand_normal2_3_lower():

    curand_normal2_3 = declare_device(
        'curand_normal2_3',
        float32x2(
            CPointer(CPointer(_type_curandStateMRG32k3a))
        )
    )


    def curand_normal2_3_caller(arg_0):
        return curand_normal2_3(arg_0)


    @lower(curand_normal2, CPointer(_type_curandStateMRG32k3a))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_normal2_3_caller,
            signature(float32x2, CPointer(CPointer(_type_curandStateMRG32k3a))),
            ptrs,
        )


_curand_normal2_3_lower()




def _curand_normal_4_lower():

    curand_normal_4 = declare_device(
        'curand_normal_4',
        float32(
            CPointer(CPointer(_type_curandStateMtgp32))
        )
    )


    def curand_normal_4_caller(arg_0):
        return curand_normal_4(arg_0)


    @lower(curand_normal, CPointer(_type_curandStateMtgp32))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_normal_4_caller,
            signature(float32, CPointer(CPointer(_type_curandStateMtgp32))),
            ptrs,
        )


_curand_normal_4_lower()




def _curand_normal_5_lower():

    curand_normal_5 = declare_device(
        'curand_normal_5',
        float32(
            CPointer(CPointer(_type_curandStateSobol32))
        )
    )


    def curand_normal_5_caller(arg_0):
        return curand_normal_5(arg_0)


    @lower(curand_normal, CPointer(_type_curandStateSobol32))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_normal_5_caller,
            signature(float32, CPointer(CPointer(_type_curandStateSobol32))),
            ptrs,
        )


_curand_normal_5_lower()




def _curand_normal_6_lower():

    curand_normal_6 = declare_device(
        'curand_normal_6',
        float32(
            CPointer(CPointer(_type_curandStateScrambledSobol32))
        )
    )


    def curand_normal_6_caller(arg_0):
        return curand_normal_6(arg_0)


    @lower(curand_normal, CPointer(_type_curandStateScrambledSobol32))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_normal_6_caller,
            signature(float32, CPointer(CPointer(_type_curandStateScrambledSobol32))),
            ptrs,
        )


_curand_normal_6_lower()




def _curand_normal_7_lower():

    curand_normal_7 = declare_device(
        'curand_normal_7',
        float32(
            CPointer(CPointer(_type_curandStateSobol64))
        )
    )


    def curand_normal_7_caller(arg_0):
        return curand_normal_7(arg_0)


    @lower(curand_normal, CPointer(_type_curandStateSobol64))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_normal_7_caller,
            signature(float32, CPointer(CPointer(_type_curandStateSobol64))),
            ptrs,
        )


_curand_normal_7_lower()




def _curand_normal_8_lower():

    curand_normal_8 = declare_device(
        'curand_normal_8',
        float32(
            CPointer(CPointer(_type_curandStateScrambledSobol64))
        )
    )


    def curand_normal_8_caller(arg_0):
        return curand_normal_8(arg_0)


    @lower(curand_normal, CPointer(_type_curandStateScrambledSobol64))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_normal_8_caller,
            signature(float32, CPointer(CPointer(_type_curandStateScrambledSobol64))),
            ptrs,
        )


_curand_normal_8_lower()


def curand_normal_double():
    pass



def _curand_normal_double_1_lower():

    curand_normal_double_1 = declare_device(
        'curand_normal_double_1',
        float64(
            CPointer(CPointer(_type_curandStateXORWOW))
        )
    )


    def curand_normal_double_1_caller(arg_0):
        return curand_normal_double_1(arg_0)


    @lower(curand_normal_double, CPointer(_type_curandStateXORWOW))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_normal_double_1_caller,
            signature(float64, CPointer(CPointer(_type_curandStateXORWOW))),
            ptrs,
        )


_curand_normal_double_1_lower()




def _curand_normal_double_2_lower():

    curand_normal_double_2 = declare_device(
        'curand_normal_double_2',
        float64(
            CPointer(CPointer(_type_curandStatePhilox4_32_10))
        )
    )


    def curand_normal_double_2_caller(arg_0):
        return curand_normal_double_2(arg_0)


    @lower(curand_normal_double, CPointer(_type_curandStatePhilox4_32_10))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_normal_double_2_caller,
            signature(float64, CPointer(CPointer(_type_curandStatePhilox4_32_10))),
            ptrs,
        )


_curand_normal_double_2_lower()




def _curand_normal_double_3_lower():

    curand_normal_double_3 = declare_device(
        'curand_normal_double_3',
        float64(
            CPointer(CPointer(_type_curandStateMRG32k3a))
        )
    )


    def curand_normal_double_3_caller(arg_0):
        return curand_normal_double_3(arg_0)


    @lower(curand_normal_double, CPointer(_type_curandStateMRG32k3a))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_normal_double_3_caller,
            signature(float64, CPointer(CPointer(_type_curandStateMRG32k3a))),
            ptrs,
        )


_curand_normal_double_3_lower()


def curand_normal2_double():
    pass



def _curand_normal2_double_1_lower():

    curand_normal2_double_1 = declare_device(
        'curand_normal2_double_1',
        float64x2(
            CPointer(CPointer(_type_curandStateXORWOW))
        )
    )


    def curand_normal2_double_1_caller(arg_0):
        return curand_normal2_double_1(arg_0)


    @lower(curand_normal2_double, CPointer(_type_curandStateXORWOW))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_normal2_double_1_caller,
            signature(float64x2, CPointer(CPointer(_type_curandStateXORWOW))),
            ptrs,
        )


_curand_normal2_double_1_lower()




def _curand_normal2_double_2_lower():

    curand_normal2_double_2 = declare_device(
        'curand_normal2_double_2',
        float64x2(
            CPointer(CPointer(_type_curandStatePhilox4_32_10))
        )
    )


    def curand_normal2_double_2_caller(arg_0):
        return curand_normal2_double_2(arg_0)


    @lower(curand_normal2_double, CPointer(_type_curandStatePhilox4_32_10))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_normal2_double_2_caller,
            signature(float64x2, CPointer(CPointer(_type_curandStatePhilox4_32_10))),
            ptrs,
        )


_curand_normal2_double_2_lower()


def curand_normal4_double():
    pass



def _curand_normal4_double_1_lower():

    curand_normal4_double_1 = declare_device(
        'curand_normal4_double_1',
        float64x4(
            CPointer(CPointer(_type_curandStatePhilox4_32_10))
        )
    )


    def curand_normal4_double_1_caller(arg_0):
        return curand_normal4_double_1(arg_0)


    @lower(curand_normal4_double, CPointer(_type_curandStatePhilox4_32_10))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_normal4_double_1_caller,
            signature(float64x4, CPointer(CPointer(_type_curandStatePhilox4_32_10))),
            ptrs,
        )


_curand_normal4_double_1_lower()




def _curand_normal2_double_3_lower():

    curand_normal2_double_3 = declare_device(
        'curand_normal2_double_3',
        float64x2(
            CPointer(CPointer(_type_curandStateMRG32k3a))
        )
    )


    def curand_normal2_double_3_caller(arg_0):
        return curand_normal2_double_3(arg_0)


    @lower(curand_normal2_double, CPointer(_type_curandStateMRG32k3a))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_normal2_double_3_caller,
            signature(float64x2, CPointer(CPointer(_type_curandStateMRG32k3a))),
            ptrs,
        )


_curand_normal2_double_3_lower()




def _curand_normal_double_4_lower():

    curand_normal_double_4 = declare_device(
        'curand_normal_double_4',
        float64(
            CPointer(CPointer(_type_curandStateMtgp32))
        )
    )


    def curand_normal_double_4_caller(arg_0):
        return curand_normal_double_4(arg_0)


    @lower(curand_normal_double, CPointer(_type_curandStateMtgp32))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_normal_double_4_caller,
            signature(float64, CPointer(CPointer(_type_curandStateMtgp32))),
            ptrs,
        )


_curand_normal_double_4_lower()




def _curand_normal_double_5_lower():

    curand_normal_double_5 = declare_device(
        'curand_normal_double_5',
        float64(
            CPointer(CPointer(_type_curandStateSobol32))
        )
    )


    def curand_normal_double_5_caller(arg_0):
        return curand_normal_double_5(arg_0)


    @lower(curand_normal_double, CPointer(_type_curandStateSobol32))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_normal_double_5_caller,
            signature(float64, CPointer(CPointer(_type_curandStateSobol32))),
            ptrs,
        )


_curand_normal_double_5_lower()




def _curand_normal_double_6_lower():

    curand_normal_double_6 = declare_device(
        'curand_normal_double_6',
        float64(
            CPointer(CPointer(_type_curandStateScrambledSobol32))
        )
    )


    def curand_normal_double_6_caller(arg_0):
        return curand_normal_double_6(arg_0)


    @lower(curand_normal_double, CPointer(_type_curandStateScrambledSobol32))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_normal_double_6_caller,
            signature(float64, CPointer(CPointer(_type_curandStateScrambledSobol32))),
            ptrs,
        )


_curand_normal_double_6_lower()




def _curand_normal_double_7_lower():

    curand_normal_double_7 = declare_device(
        'curand_normal_double_7',
        float64(
            CPointer(CPointer(_type_curandStateSobol64))
        )
    )


    def curand_normal_double_7_caller(arg_0):
        return curand_normal_double_7(arg_0)


    @lower(curand_normal_double, CPointer(_type_curandStateSobol64))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_normal_double_7_caller,
            signature(float64, CPointer(CPointer(_type_curandStateSobol64))),
            ptrs,
        )


_curand_normal_double_7_lower()




def _curand_normal_double_8_lower():

    curand_normal_double_8 = declare_device(
        'curand_normal_double_8',
        float64(
            CPointer(CPointer(_type_curandStateScrambledSobol64))
        )
    )


    def curand_normal_double_8_caller(arg_0):
        return curand_normal_double_8(arg_0)


    @lower(curand_normal_double, CPointer(_type_curandStateScrambledSobol64))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_normal_double_8_caller,
            signature(float64, CPointer(CPointer(_type_curandStateScrambledSobol64))),
            ptrs,
        )


_curand_normal_double_8_lower()


def curand_log_normal():
    pass



def _curand_log_normal_1_lower():

    curand_log_normal_1 = declare_device(
        'curand_log_normal_1',
        float32(
            CPointer(CPointer(_type_curandStateXORWOW)), CPointer(float32), CPointer(float32)
        )
    )


    def curand_log_normal_1_caller(arg_0, arg_1, arg_2):
        return curand_log_normal_1(arg_0, arg_1, arg_2)


    @lower(curand_log_normal, CPointer(_type_curandStateXORWOW), float32, float32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_log_normal_1_caller,
            signature(float32, CPointer(CPointer(_type_curandStateXORWOW)), CPointer(float32), CPointer(float32)),
            ptrs,
        )


_curand_log_normal_1_lower()




def _curand_log_normal_2_lower():

    curand_log_normal_2 = declare_device(
        'curand_log_normal_2',
        float32(
            CPointer(CPointer(_type_curandStatePhilox4_32_10)), CPointer(float32), CPointer(float32)
        )
    )


    def curand_log_normal_2_caller(arg_0, arg_1, arg_2):
        return curand_log_normal_2(arg_0, arg_1, arg_2)


    @lower(curand_log_normal, CPointer(_type_curandStatePhilox4_32_10), float32, float32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_log_normal_2_caller,
            signature(float32, CPointer(CPointer(_type_curandStatePhilox4_32_10)), CPointer(float32), CPointer(float32)),
            ptrs,
        )


_curand_log_normal_2_lower()


def curand_log_normal2():
    pass



def _curand_log_normal2_1_lower():

    curand_log_normal2_1 = declare_device(
        'curand_log_normal2_1',
        float32x2(
            CPointer(CPointer(_type_curandStateXORWOW)), CPointer(float32), CPointer(float32)
        )
    )


    def curand_log_normal2_1_caller(arg_0, arg_1, arg_2):
        return curand_log_normal2_1(arg_0, arg_1, arg_2)


    @lower(curand_log_normal2, CPointer(_type_curandStateXORWOW), float32, float32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_log_normal2_1_caller,
            signature(float32x2, CPointer(CPointer(_type_curandStateXORWOW)), CPointer(float32), CPointer(float32)),
            ptrs,
        )


_curand_log_normal2_1_lower()




def _curand_log_normal2_2_lower():

    curand_log_normal2_2 = declare_device(
        'curand_log_normal2_2',
        float32x2(
            CPointer(CPointer(_type_curandStatePhilox4_32_10)), CPointer(float32), CPointer(float32)
        )
    )


    def curand_log_normal2_2_caller(arg_0, arg_1, arg_2):
        return curand_log_normal2_2(arg_0, arg_1, arg_2)


    @lower(curand_log_normal2, CPointer(_type_curandStatePhilox4_32_10), float32, float32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_log_normal2_2_caller,
            signature(float32x2, CPointer(CPointer(_type_curandStatePhilox4_32_10)), CPointer(float32), CPointer(float32)),
            ptrs,
        )


_curand_log_normal2_2_lower()


def curand_log_normal4():
    pass



def _curand_log_normal4_1_lower():

    curand_log_normal4_1 = declare_device(
        'curand_log_normal4_1',
        float32x4(
            CPointer(CPointer(_type_curandStatePhilox4_32_10)), CPointer(float32), CPointer(float32)
        )
    )


    def curand_log_normal4_1_caller(arg_0, arg_1, arg_2):
        return curand_log_normal4_1(arg_0, arg_1, arg_2)


    @lower(curand_log_normal4, CPointer(_type_curandStatePhilox4_32_10), float32, float32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_log_normal4_1_caller,
            signature(float32x4, CPointer(CPointer(_type_curandStatePhilox4_32_10)), CPointer(float32), CPointer(float32)),
            ptrs,
        )


_curand_log_normal4_1_lower()




def _curand_log_normal_3_lower():

    curand_log_normal_3 = declare_device(
        'curand_log_normal_3',
        float32(
            CPointer(CPointer(_type_curandStateMRG32k3a)), CPointer(float32), CPointer(float32)
        )
    )


    def curand_log_normal_3_caller(arg_0, arg_1, arg_2):
        return curand_log_normal_3(arg_0, arg_1, arg_2)


    @lower(curand_log_normal, CPointer(_type_curandStateMRG32k3a), float32, float32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_log_normal_3_caller,
            signature(float32, CPointer(CPointer(_type_curandStateMRG32k3a)), CPointer(float32), CPointer(float32)),
            ptrs,
        )


_curand_log_normal_3_lower()




def _curand_log_normal2_3_lower():

    curand_log_normal2_3 = declare_device(
        'curand_log_normal2_3',
        float32x2(
            CPointer(CPointer(_type_curandStateMRG32k3a)), CPointer(float32), CPointer(float32)
        )
    )


    def curand_log_normal2_3_caller(arg_0, arg_1, arg_2):
        return curand_log_normal2_3(arg_0, arg_1, arg_2)


    @lower(curand_log_normal2, CPointer(_type_curandStateMRG32k3a), float32, float32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_log_normal2_3_caller,
            signature(float32x2, CPointer(CPointer(_type_curandStateMRG32k3a)), CPointer(float32), CPointer(float32)),
            ptrs,
        )


_curand_log_normal2_3_lower()




def _curand_log_normal_4_lower():

    curand_log_normal_4 = declare_device(
        'curand_log_normal_4',
        float32(
            CPointer(CPointer(_type_curandStateMtgp32)), CPointer(float32), CPointer(float32)
        )
    )


    def curand_log_normal_4_caller(arg_0, arg_1, arg_2):
        return curand_log_normal_4(arg_0, arg_1, arg_2)


    @lower(curand_log_normal, CPointer(_type_curandStateMtgp32), float32, float32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_log_normal_4_caller,
            signature(float32, CPointer(CPointer(_type_curandStateMtgp32)), CPointer(float32), CPointer(float32)),
            ptrs,
        )


_curand_log_normal_4_lower()




def _curand_log_normal_5_lower():

    curand_log_normal_5 = declare_device(
        'curand_log_normal_5',
        float32(
            CPointer(CPointer(_type_curandStateSobol32)), CPointer(float32), CPointer(float32)
        )
    )


    def curand_log_normal_5_caller(arg_0, arg_1, arg_2):
        return curand_log_normal_5(arg_0, arg_1, arg_2)


    @lower(curand_log_normal, CPointer(_type_curandStateSobol32), float32, float32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_log_normal_5_caller,
            signature(float32, CPointer(CPointer(_type_curandStateSobol32)), CPointer(float32), CPointer(float32)),
            ptrs,
        )


_curand_log_normal_5_lower()




def _curand_log_normal_6_lower():

    curand_log_normal_6 = declare_device(
        'curand_log_normal_6',
        float32(
            CPointer(CPointer(_type_curandStateScrambledSobol32)), CPointer(float32), CPointer(float32)
        )
    )


    def curand_log_normal_6_caller(arg_0, arg_1, arg_2):
        return curand_log_normal_6(arg_0, arg_1, arg_2)


    @lower(curand_log_normal, CPointer(_type_curandStateScrambledSobol32), float32, float32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_log_normal_6_caller,
            signature(float32, CPointer(CPointer(_type_curandStateScrambledSobol32)), CPointer(float32), CPointer(float32)),
            ptrs,
        )


_curand_log_normal_6_lower()




def _curand_log_normal_7_lower():

    curand_log_normal_7 = declare_device(
        'curand_log_normal_7',
        float32(
            CPointer(CPointer(_type_curandStateSobol64)), CPointer(float32), CPointer(float32)
        )
    )


    def curand_log_normal_7_caller(arg_0, arg_1, arg_2):
        return curand_log_normal_7(arg_0, arg_1, arg_2)


    @lower(curand_log_normal, CPointer(_type_curandStateSobol64), float32, float32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_log_normal_7_caller,
            signature(float32, CPointer(CPointer(_type_curandStateSobol64)), CPointer(float32), CPointer(float32)),
            ptrs,
        )


_curand_log_normal_7_lower()




def _curand_log_normal_8_lower():

    curand_log_normal_8 = declare_device(
        'curand_log_normal_8',
        float32(
            CPointer(CPointer(_type_curandStateScrambledSobol64)), CPointer(float32), CPointer(float32)
        )
    )


    def curand_log_normal_8_caller(arg_0, arg_1, arg_2):
        return curand_log_normal_8(arg_0, arg_1, arg_2)


    @lower(curand_log_normal, CPointer(_type_curandStateScrambledSobol64), float32, float32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_log_normal_8_caller,
            signature(float32, CPointer(CPointer(_type_curandStateScrambledSobol64)), CPointer(float32), CPointer(float32)),
            ptrs,
        )


_curand_log_normal_8_lower()


def curand_log_normal_double():
    pass



def _curand_log_normal_double_1_lower():

    curand_log_normal_double_1 = declare_device(
        'curand_log_normal_double_1',
        float64(
            CPointer(CPointer(_type_curandStateXORWOW)), CPointer(float64), CPointer(float64)
        )
    )


    def curand_log_normal_double_1_caller(arg_0, arg_1, arg_2):
        return curand_log_normal_double_1(arg_0, arg_1, arg_2)


    @lower(curand_log_normal_double, CPointer(_type_curandStateXORWOW), float64, float64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_log_normal_double_1_caller,
            signature(float64, CPointer(CPointer(_type_curandStateXORWOW)), CPointer(float64), CPointer(float64)),
            ptrs,
        )


_curand_log_normal_double_1_lower()




def _curand_log_normal_double_2_lower():

    curand_log_normal_double_2 = declare_device(
        'curand_log_normal_double_2',
        float64(
            CPointer(CPointer(_type_curandStatePhilox4_32_10)), CPointer(float64), CPointer(float64)
        )
    )


    def curand_log_normal_double_2_caller(arg_0, arg_1, arg_2):
        return curand_log_normal_double_2(arg_0, arg_1, arg_2)


    @lower(curand_log_normal_double, CPointer(_type_curandStatePhilox4_32_10), float64, float64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_log_normal_double_2_caller,
            signature(float64, CPointer(CPointer(_type_curandStatePhilox4_32_10)), CPointer(float64), CPointer(float64)),
            ptrs,
        )


_curand_log_normal_double_2_lower()


def curand_log_normal2_double():
    pass



def _curand_log_normal2_double_1_lower():

    curand_log_normal2_double_1 = declare_device(
        'curand_log_normal2_double_1',
        float64x2(
            CPointer(CPointer(_type_curandStateXORWOW)), CPointer(float64), CPointer(float64)
        )
    )


    def curand_log_normal2_double_1_caller(arg_0, arg_1, arg_2):
        return curand_log_normal2_double_1(arg_0, arg_1, arg_2)


    @lower(curand_log_normal2_double, CPointer(_type_curandStateXORWOW), float64, float64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_log_normal2_double_1_caller,
            signature(float64x2, CPointer(CPointer(_type_curandStateXORWOW)), CPointer(float64), CPointer(float64)),
            ptrs,
        )


_curand_log_normal2_double_1_lower()




def _curand_log_normal2_double_2_lower():

    curand_log_normal2_double_2 = declare_device(
        'curand_log_normal2_double_2',
        float64x2(
            CPointer(CPointer(_type_curandStatePhilox4_32_10)), CPointer(float64), CPointer(float64)
        )
    )


    def curand_log_normal2_double_2_caller(arg_0, arg_1, arg_2):
        return curand_log_normal2_double_2(arg_0, arg_1, arg_2)


    @lower(curand_log_normal2_double, CPointer(_type_curandStatePhilox4_32_10), float64, float64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_log_normal2_double_2_caller,
            signature(float64x2, CPointer(CPointer(_type_curandStatePhilox4_32_10)), CPointer(float64), CPointer(float64)),
            ptrs,
        )


_curand_log_normal2_double_2_lower()


def curand_log_normal4_double():
    pass



def _curand_log_normal4_double_1_lower():

    curand_log_normal4_double_1 = declare_device(
        'curand_log_normal4_double_1',
        float64x4(
            CPointer(CPointer(_type_curandStatePhilox4_32_10)), CPointer(float64), CPointer(float64)
        )
    )


    def curand_log_normal4_double_1_caller(arg_0, arg_1, arg_2):
        return curand_log_normal4_double_1(arg_0, arg_1, arg_2)


    @lower(curand_log_normal4_double, CPointer(_type_curandStatePhilox4_32_10), float64, float64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_log_normal4_double_1_caller,
            signature(float64x4, CPointer(CPointer(_type_curandStatePhilox4_32_10)), CPointer(float64), CPointer(float64)),
            ptrs,
        )


_curand_log_normal4_double_1_lower()




def _curand_log_normal_double_3_lower():

    curand_log_normal_double_3 = declare_device(
        'curand_log_normal_double_3',
        float64(
            CPointer(CPointer(_type_curandStateMRG32k3a)), CPointer(float64), CPointer(float64)
        )
    )


    def curand_log_normal_double_3_caller(arg_0, arg_1, arg_2):
        return curand_log_normal_double_3(arg_0, arg_1, arg_2)


    @lower(curand_log_normal_double, CPointer(_type_curandStateMRG32k3a), float64, float64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_log_normal_double_3_caller,
            signature(float64, CPointer(CPointer(_type_curandStateMRG32k3a)), CPointer(float64), CPointer(float64)),
            ptrs,
        )


_curand_log_normal_double_3_lower()




def _curand_log_normal2_double_3_lower():

    curand_log_normal2_double_3 = declare_device(
        'curand_log_normal2_double_3',
        float64x2(
            CPointer(CPointer(_type_curandStateMRG32k3a)), CPointer(float64), CPointer(float64)
        )
    )


    def curand_log_normal2_double_3_caller(arg_0, arg_1, arg_2):
        return curand_log_normal2_double_3(arg_0, arg_1, arg_2)


    @lower(curand_log_normal2_double, CPointer(_type_curandStateMRG32k3a), float64, float64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_log_normal2_double_3_caller,
            signature(float64x2, CPointer(CPointer(_type_curandStateMRG32k3a)), CPointer(float64), CPointer(float64)),
            ptrs,
        )


_curand_log_normal2_double_3_lower()




def _curand_log_normal_double_4_lower():

    curand_log_normal_double_4 = declare_device(
        'curand_log_normal_double_4',
        float64(
            CPointer(CPointer(_type_curandStateMtgp32)), CPointer(float64), CPointer(float64)
        )
    )


    def curand_log_normal_double_4_caller(arg_0, arg_1, arg_2):
        return curand_log_normal_double_4(arg_0, arg_1, arg_2)


    @lower(curand_log_normal_double, CPointer(_type_curandStateMtgp32), float64, float64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_log_normal_double_4_caller,
            signature(float64, CPointer(CPointer(_type_curandStateMtgp32)), CPointer(float64), CPointer(float64)),
            ptrs,
        )


_curand_log_normal_double_4_lower()




def _curand_log_normal_double_5_lower():

    curand_log_normal_double_5 = declare_device(
        'curand_log_normal_double_5',
        float64(
            CPointer(CPointer(_type_curandStateSobol32)), CPointer(float64), CPointer(float64)
        )
    )


    def curand_log_normal_double_5_caller(arg_0, arg_1, arg_2):
        return curand_log_normal_double_5(arg_0, arg_1, arg_2)


    @lower(curand_log_normal_double, CPointer(_type_curandStateSobol32), float64, float64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_log_normal_double_5_caller,
            signature(float64, CPointer(CPointer(_type_curandStateSobol32)), CPointer(float64), CPointer(float64)),
            ptrs,
        )


_curand_log_normal_double_5_lower()




def _curand_log_normal_double_6_lower():

    curand_log_normal_double_6 = declare_device(
        'curand_log_normal_double_6',
        float64(
            CPointer(CPointer(_type_curandStateScrambledSobol32)), CPointer(float64), CPointer(float64)
        )
    )


    def curand_log_normal_double_6_caller(arg_0, arg_1, arg_2):
        return curand_log_normal_double_6(arg_0, arg_1, arg_2)


    @lower(curand_log_normal_double, CPointer(_type_curandStateScrambledSobol32), float64, float64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_log_normal_double_6_caller,
            signature(float64, CPointer(CPointer(_type_curandStateScrambledSobol32)), CPointer(float64), CPointer(float64)),
            ptrs,
        )


_curand_log_normal_double_6_lower()




def _curand_log_normal_double_7_lower():

    curand_log_normal_double_7 = declare_device(
        'curand_log_normal_double_7',
        float64(
            CPointer(CPointer(_type_curandStateSobol64)), CPointer(float64), CPointer(float64)
        )
    )


    def curand_log_normal_double_7_caller(arg_0, arg_1, arg_2):
        return curand_log_normal_double_7(arg_0, arg_1, arg_2)


    @lower(curand_log_normal_double, CPointer(_type_curandStateSobol64), float64, float64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_log_normal_double_7_caller,
            signature(float64, CPointer(CPointer(_type_curandStateSobol64)), CPointer(float64), CPointer(float64)),
            ptrs,
        )


_curand_log_normal_double_7_lower()




def _curand_log_normal_double_8_lower():

    curand_log_normal_double_8 = declare_device(
        'curand_log_normal_double_8',
        float64(
            CPointer(CPointer(_type_curandStateScrambledSobol64)), CPointer(float64), CPointer(float64)
        )
    )


    def curand_log_normal_double_8_caller(arg_0, arg_1, arg_2):
        return curand_log_normal_double_8(arg_0, arg_1, arg_2)


    @lower(curand_log_normal_double, CPointer(_type_curandStateScrambledSobol64), float64, float64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_log_normal_double_8_caller,
            signature(float64, CPointer(CPointer(_type_curandStateScrambledSobol64)), CPointer(float64), CPointer(float64)),
            ptrs,
        )


_curand_log_normal_double_8_lower()


def __cr_rsqrt():
    pass



def ___cr_rsqrt_1_lower():

    __cr_rsqrt_1 = declare_device(
        '__cr_rsqrt_1',
        float32(
            CPointer(float32)
        )
    )


    def __cr_rsqrt_1_caller(arg_0):
        return __cr_rsqrt_1(arg_0)


    @lower(__cr_rsqrt, float32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            __cr_rsqrt_1_caller,
            signature(float32, CPointer(float32)),
            ptrs,
        )


___cr_rsqrt_1_lower()


def __cr_exp():
    pass



def ___cr_exp_1_lower():

    __cr_exp_1 = declare_device(
        '__cr_exp_1',
        float32(
            CPointer(float32)
        )
    )


    def __cr_exp_1_caller(arg_0):
        return __cr_exp_1(arg_0)


    @lower(__cr_exp, float32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            __cr_exp_1_caller,
            signature(float32, CPointer(float32)),
            ptrs,
        )


___cr_exp_1_lower()


def __cr_log():
    pass



def ___cr_log_1_lower():

    __cr_log_1 = declare_device(
        '__cr_log_1',
        float32(
            CPointer(float32)
        )
    )


    def __cr_log_1_caller(arg_0):
        return __cr_log_1(arg_0)


    @lower(__cr_log, float32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            __cr_log_1_caller,
            signature(float32, CPointer(float32)),
            ptrs,
        )


___cr_log_1_lower()


def __cr_rcp():
    pass



def ___cr_rcp_1_lower():

    __cr_rcp_1 = declare_device(
        '__cr_rcp_1',
        float32(
            CPointer(float32)
        )
    )


    def __cr_rcp_1_caller(arg_0):
        return __cr_rcp_1(arg_0)


    @lower(__cr_rcp, float32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            __cr_rcp_1_caller,
            signature(float32, CPointer(float32)),
            ptrs,
        )


___cr_rcp_1_lower()


def __cr_pgammainc():
    pass



def ___cr_pgammainc_1_lower():

    __cr_pgammainc_1 = declare_device(
        '__cr_pgammainc_1',
        float32(
            CPointer(float32), CPointer(float32)
        )
    )


    def __cr_pgammainc_1_caller(arg_0, arg_1):
        return __cr_pgammainc_1(arg_0, arg_1)


    @lower(__cr_pgammainc, float32, float32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            __cr_pgammainc_1_caller,
            signature(float32, CPointer(float32), CPointer(float32)),
            ptrs,
        )


___cr_pgammainc_1_lower()


def __cr_pgammaincinv():
    pass



def ___cr_pgammaincinv_1_lower():

    __cr_pgammaincinv_1 = declare_device(
        '__cr_pgammaincinv_1',
        float32(
            CPointer(float32), CPointer(float32)
        )
    )


    def __cr_pgammaincinv_1_caller(arg_0, arg_1):
        return __cr_pgammaincinv_1(arg_0, arg_1)


    @lower(__cr_pgammaincinv, float32, float32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            __cr_pgammaincinv_1_caller,
            signature(float32, CPointer(float32), CPointer(float32)),
            ptrs,
        )


___cr_pgammaincinv_1_lower()


def __cr_lgamma_integer():
    pass



def ___cr_lgamma_integer_1_lower():

    __cr_lgamma_integer_1 = declare_device(
        '__cr_lgamma_integer_1',
        float64(
            CPointer(int32)
        )
    )


    def __cr_lgamma_integer_1_caller(arg_0):
        return __cr_lgamma_integer_1(arg_0)


    @lower(__cr_lgamma_integer, int32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            __cr_lgamma_integer_1_caller,
            signature(float64, CPointer(int32)),
            ptrs,
        )


___cr_lgamma_integer_1_lower()


def _curand_uniform_double_excluding_one():
    pass



def __curand_uniform_double_excluding_one_1_lower():

    _curand_uniform_double_excluding_one_1 = declare_device(
        '_curand_uniform_double_excluding_one_1',
        float64(
            CPointer(uint32)
        )
    )


    def _curand_uniform_double_excluding_one_1_caller(arg_0):
        return _curand_uniform_double_excluding_one_1(arg_0)


    @lower(_curand_uniform_double_excluding_one, uint32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _curand_uniform_double_excluding_one_1_caller,
            signature(float64, CPointer(uint32)),
            ptrs,
        )


__curand_uniform_double_excluding_one_1_lower()




def __curand_uniform_double_excluding_one_2_lower():

    _curand_uniform_double_excluding_one_2 = declare_device(
        '_curand_uniform_double_excluding_one_2',
        float64(
            CPointer(uint64)
        )
    )


    def _curand_uniform_double_excluding_one_2_caller(arg_0):
        return _curand_uniform_double_excluding_one_2(arg_0)


    @lower(_curand_uniform_double_excluding_one, uint64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            _curand_uniform_double_excluding_one_2_caller,
            signature(float64, CPointer(uint64)),
            ptrs,
        )


__curand_uniform_double_excluding_one_2_lower()


def curand_poisson():
    pass



def _curand_poisson_1_lower():

    curand_poisson_1 = declare_device(
        'curand_poisson_1',
        uint32(
            CPointer(CPointer(_type_curandStateXORWOW)), CPointer(float64)
        )
    )


    def curand_poisson_1_caller(arg_0, arg_1):
        return curand_poisson_1(arg_0, arg_1)


    @lower(curand_poisson, CPointer(_type_curandStateXORWOW), float64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_poisson_1_caller,
            signature(uint32, CPointer(CPointer(_type_curandStateXORWOW)), CPointer(float64)),
            ptrs,
        )


_curand_poisson_1_lower()




def _curand_poisson_2_lower():

    curand_poisson_2 = declare_device(
        'curand_poisson_2',
        uint32(
            CPointer(CPointer(_type_curandStatePhilox4_32_10)), CPointer(float64)
        )
    )


    def curand_poisson_2_caller(arg_0, arg_1):
        return curand_poisson_2(arg_0, arg_1)


    @lower(curand_poisson, CPointer(_type_curandStatePhilox4_32_10), float64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_poisson_2_caller,
            signature(uint32, CPointer(CPointer(_type_curandStatePhilox4_32_10)), CPointer(float64)),
            ptrs,
        )


_curand_poisson_2_lower()


def curand_poisson4():
    pass



def _curand_poisson4_1_lower():

    curand_poisson4_1 = declare_device(
        'curand_poisson4_1',
        uint32x4(
            CPointer(CPointer(_type_curandStatePhilox4_32_10)), CPointer(float64)
        )
    )


    def curand_poisson4_1_caller(arg_0, arg_1):
        return curand_poisson4_1(arg_0, arg_1)


    @lower(curand_poisson4, CPointer(_type_curandStatePhilox4_32_10), float64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_poisson4_1_caller,
            signature(uint32x4, CPointer(CPointer(_type_curandStatePhilox4_32_10)), CPointer(float64)),
            ptrs,
        )


_curand_poisson4_1_lower()




def _curand_poisson_3_lower():

    curand_poisson_3 = declare_device(
        'curand_poisson_3',
        uint32(
            CPointer(CPointer(_type_curandStateMRG32k3a)), CPointer(float64)
        )
    )


    def curand_poisson_3_caller(arg_0, arg_1):
        return curand_poisson_3(arg_0, arg_1)


    @lower(curand_poisson, CPointer(_type_curandStateMRG32k3a), float64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_poisson_3_caller,
            signature(uint32, CPointer(CPointer(_type_curandStateMRG32k3a)), CPointer(float64)),
            ptrs,
        )


_curand_poisson_3_lower()




def _curand_poisson_4_lower():

    curand_poisson_4 = declare_device(
        'curand_poisson_4',
        uint32(
            CPointer(CPointer(_type_curandStateMtgp32)), CPointer(float64)
        )
    )


    def curand_poisson_4_caller(arg_0, arg_1):
        return curand_poisson_4(arg_0, arg_1)


    @lower(curand_poisson, CPointer(_type_curandStateMtgp32), float64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_poisson_4_caller,
            signature(uint32, CPointer(CPointer(_type_curandStateMtgp32)), CPointer(float64)),
            ptrs,
        )


_curand_poisson_4_lower()




def _curand_poisson_5_lower():

    curand_poisson_5 = declare_device(
        'curand_poisson_5',
        uint32(
            CPointer(CPointer(_type_curandStateSobol32)), CPointer(float64)
        )
    )


    def curand_poisson_5_caller(arg_0, arg_1):
        return curand_poisson_5(arg_0, arg_1)


    @lower(curand_poisson, CPointer(_type_curandStateSobol32), float64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_poisson_5_caller,
            signature(uint32, CPointer(CPointer(_type_curandStateSobol32)), CPointer(float64)),
            ptrs,
        )


_curand_poisson_5_lower()




def _curand_poisson_6_lower():

    curand_poisson_6 = declare_device(
        'curand_poisson_6',
        uint32(
            CPointer(CPointer(_type_curandStateScrambledSobol32)), CPointer(float64)
        )
    )


    def curand_poisson_6_caller(arg_0, arg_1):
        return curand_poisson_6(arg_0, arg_1)


    @lower(curand_poisson, CPointer(_type_curandStateScrambledSobol32), float64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_poisson_6_caller,
            signature(uint32, CPointer(CPointer(_type_curandStateScrambledSobol32)), CPointer(float64)),
            ptrs,
        )


_curand_poisson_6_lower()




def _curand_poisson_7_lower():

    curand_poisson_7 = declare_device(
        'curand_poisson_7',
        uint32(
            CPointer(CPointer(_type_curandStateSobol64)), CPointer(float64)
        )
    )


    def curand_poisson_7_caller(arg_0, arg_1):
        return curand_poisson_7(arg_0, arg_1)


    @lower(curand_poisson, CPointer(_type_curandStateSobol64), float64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_poisson_7_caller,
            signature(uint32, CPointer(CPointer(_type_curandStateSobol64)), CPointer(float64)),
            ptrs,
        )


_curand_poisson_7_lower()




def _curand_poisson_8_lower():

    curand_poisson_8 = declare_device(
        'curand_poisson_8',
        uint32(
            CPointer(CPointer(_type_curandStateScrambledSobol64)), CPointer(float64)
        )
    )


    def curand_poisson_8_caller(arg_0, arg_1):
        return curand_poisson_8(arg_0, arg_1)


    @lower(curand_poisson, CPointer(_type_curandStateScrambledSobol64), float64)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_poisson_8_caller,
            signature(uint32, CPointer(CPointer(_type_curandStateScrambledSobol64)), CPointer(float64)),
            ptrs,
        )


_curand_poisson_8_lower()


def curand_discrete():
    pass



def _curand_discrete_1_lower():

    curand_discrete_1 = declare_device(
        'curand_discrete_1',
        uint32(
            CPointer(CPointer(_type_curandStateXORWOW)), CPointer(CPointer(_type_curandDiscreteDistribution_st))
        )
    )


    def curand_discrete_1_caller(arg_0, arg_1):
        return curand_discrete_1(arg_0, arg_1)


    @lower(curand_discrete, CPointer(_type_curandStateXORWOW), CPointer(_type_curandDiscreteDistribution_st))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_discrete_1_caller,
            signature(uint32, CPointer(CPointer(_type_curandStateXORWOW)), CPointer(CPointer(_type_curandDiscreteDistribution_st))),
            ptrs,
        )


_curand_discrete_1_lower()




def _curand_discrete_2_lower():

    curand_discrete_2 = declare_device(
        'curand_discrete_2',
        uint32(
            CPointer(CPointer(_type_curandStatePhilox4_32_10)), CPointer(CPointer(_type_curandDiscreteDistribution_st))
        )
    )


    def curand_discrete_2_caller(arg_0, arg_1):
        return curand_discrete_2(arg_0, arg_1)


    @lower(curand_discrete, CPointer(_type_curandStatePhilox4_32_10), CPointer(_type_curandDiscreteDistribution_st))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_discrete_2_caller,
            signature(uint32, CPointer(CPointer(_type_curandStatePhilox4_32_10)), CPointer(CPointer(_type_curandDiscreteDistribution_st))),
            ptrs,
        )


_curand_discrete_2_lower()


def curand_discrete4():
    pass



def _curand_discrete4_1_lower():

    curand_discrete4_1 = declare_device(
        'curand_discrete4_1',
        uint32x4(
            CPointer(CPointer(_type_curandStatePhilox4_32_10)), CPointer(CPointer(_type_curandDiscreteDistribution_st))
        )
    )


    def curand_discrete4_1_caller(arg_0, arg_1):
        return curand_discrete4_1(arg_0, arg_1)


    @lower(curand_discrete4, CPointer(_type_curandStatePhilox4_32_10), CPointer(_type_curandDiscreteDistribution_st))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_discrete4_1_caller,
            signature(uint32x4, CPointer(CPointer(_type_curandStatePhilox4_32_10)), CPointer(CPointer(_type_curandDiscreteDistribution_st))),
            ptrs,
        )


_curand_discrete4_1_lower()




def _curand_discrete_3_lower():

    curand_discrete_3 = declare_device(
        'curand_discrete_3',
        uint32(
            CPointer(CPointer(_type_curandStateMRG32k3a)), CPointer(CPointer(_type_curandDiscreteDistribution_st))
        )
    )


    def curand_discrete_3_caller(arg_0, arg_1):
        return curand_discrete_3(arg_0, arg_1)


    @lower(curand_discrete, CPointer(_type_curandStateMRG32k3a), CPointer(_type_curandDiscreteDistribution_st))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_discrete_3_caller,
            signature(uint32, CPointer(CPointer(_type_curandStateMRG32k3a)), CPointer(CPointer(_type_curandDiscreteDistribution_st))),
            ptrs,
        )


_curand_discrete_3_lower()




def _curand_discrete_4_lower():

    curand_discrete_4 = declare_device(
        'curand_discrete_4',
        uint32(
            CPointer(CPointer(_type_curandStateMtgp32)), CPointer(CPointer(_type_curandDiscreteDistribution_st))
        )
    )


    def curand_discrete_4_caller(arg_0, arg_1):
        return curand_discrete_4(arg_0, arg_1)


    @lower(curand_discrete, CPointer(_type_curandStateMtgp32), CPointer(_type_curandDiscreteDistribution_st))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_discrete_4_caller,
            signature(uint32, CPointer(CPointer(_type_curandStateMtgp32)), CPointer(CPointer(_type_curandDiscreteDistribution_st))),
            ptrs,
        )


_curand_discrete_4_lower()




def _curand_discrete_5_lower():

    curand_discrete_5 = declare_device(
        'curand_discrete_5',
        uint32(
            CPointer(CPointer(_type_curandStateSobol32)), CPointer(CPointer(_type_curandDiscreteDistribution_st))
        )
    )


    def curand_discrete_5_caller(arg_0, arg_1):
        return curand_discrete_5(arg_0, arg_1)


    @lower(curand_discrete, CPointer(_type_curandStateSobol32), CPointer(_type_curandDiscreteDistribution_st))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_discrete_5_caller,
            signature(uint32, CPointer(CPointer(_type_curandStateSobol32)), CPointer(CPointer(_type_curandDiscreteDistribution_st))),
            ptrs,
        )


_curand_discrete_5_lower()




def _curand_discrete_6_lower():

    curand_discrete_6 = declare_device(
        'curand_discrete_6',
        uint32(
            CPointer(CPointer(_type_curandStateScrambledSobol32)), CPointer(CPointer(_type_curandDiscreteDistribution_st))
        )
    )


    def curand_discrete_6_caller(arg_0, arg_1):
        return curand_discrete_6(arg_0, arg_1)


    @lower(curand_discrete, CPointer(_type_curandStateScrambledSobol32), CPointer(_type_curandDiscreteDistribution_st))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_discrete_6_caller,
            signature(uint32, CPointer(CPointer(_type_curandStateScrambledSobol32)), CPointer(CPointer(_type_curandDiscreteDistribution_st))),
            ptrs,
        )


_curand_discrete_6_lower()




def _curand_discrete_7_lower():

    curand_discrete_7 = declare_device(
        'curand_discrete_7',
        uint32(
            CPointer(CPointer(_type_curandStateSobol64)), CPointer(CPointer(_type_curandDiscreteDistribution_st))
        )
    )


    def curand_discrete_7_caller(arg_0, arg_1):
        return curand_discrete_7(arg_0, arg_1)


    @lower(curand_discrete, CPointer(_type_curandStateSobol64), CPointer(_type_curandDiscreteDistribution_st))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_discrete_7_caller,
            signature(uint32, CPointer(CPointer(_type_curandStateSobol64)), CPointer(CPointer(_type_curandDiscreteDistribution_st))),
            ptrs,
        )


_curand_discrete_7_lower()




def _curand_discrete_8_lower():

    curand_discrete_8 = declare_device(
        'curand_discrete_8',
        uint32(
            CPointer(CPointer(_type_curandStateScrambledSobol64)), CPointer(CPointer(_type_curandDiscreteDistribution_st))
        )
    )


    def curand_discrete_8_caller(arg_0, arg_1):
        return curand_discrete_8(arg_0, arg_1)


    @lower(curand_discrete, CPointer(_type_curandStateScrambledSobol64), CPointer(_type_curandDiscreteDistribution_st))
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            curand_discrete_8_caller,
            signature(uint32, CPointer(CPointer(_type_curandStateScrambledSobol64)), CPointer(CPointer(_type_curandDiscreteDistribution_st))),
            ptrs,
        )


_curand_discrete_8_lower()


def __get_precalculated_matrix():
    pass



def ___get_precalculated_matrix_1_lower():

    __get_precalculated_matrix_1 = declare_device(
        '__get_precalculated_matrix_1',
        CPointer(uint32)(
            CPointer(int32)
        )
    )


    def __get_precalculated_matrix_1_caller(arg_0):
        return __get_precalculated_matrix_1(arg_0)


    @lower(__get_precalculated_matrix, int32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            __get_precalculated_matrix_1_caller,
            signature(CPointer(uint32), CPointer(int32)),
            ptrs,
        )


___get_precalculated_matrix_1_lower()


def __get_mrg32k3a_matrix():
    pass



def ___get_mrg32k3a_matrix_1_lower():

    __get_mrg32k3a_matrix_1 = declare_device(
        '__get_mrg32k3a_matrix_1',
        CPointer(uint32)(
            CPointer(int32)
        )
    )


    def __get_mrg32k3a_matrix_1_caller(arg_0):
        return __get_mrg32k3a_matrix_1(arg_0)


    @lower(__get_mrg32k3a_matrix, int32)
    def impl(context, builder, sig, args):
        ptrs = [builder.alloca(context.get_value_type(arg)) for arg in sig.args]
        for ptr, ty, arg in zip(ptrs, sig.args, args):
            builder.store(arg, ptr, align=getattr(ty, "alignof_", None))

        return context.compile_internal(
            builder,
            __get_mrg32k3a_matrix_1_caller,
            signature(CPointer(uint32), CPointer(int32)),
            ptrs,
        )


___get_mrg32k3a_matrix_1_lower()


@register
class _typing_para_rec(ConcreteTemplate):
    key = globals()["para_rec"]
    cases = [signature(uint32, CPointer(_type_mtgp32_kernel_params), uint32, uint32, uint32, int32)]

register_global(para_rec, types.Function(_typing_para_rec))


@register
class _typing_temper(ConcreteTemplate):
    key = globals()["temper"]
    cases = [signature(uint32, CPointer(_type_mtgp32_kernel_params), uint32, uint32, int32)]

register_global(temper, types.Function(_typing_temper))


@register
class _typing_temper_single(ConcreteTemplate):
    key = globals()["temper_single"]
    cases = [signature(uint32, CPointer(_type_mtgp32_kernel_params), uint32, uint32, int32)]

register_global(temper_single, types.Function(_typing_temper_single))


@register
class _typing_curand(ConcreteTemplate):
    key = globals()["curand"]
    cases = [signature(uint32, CPointer(_type_curandStateMtgp32)), signature(uint32, CPointer(_type_curandStateTest)), signature(uint32, CPointer(_type_curandStateXORWOW)), signature(uint32, CPointer(_type_curandStatePhilox4_32_10)), signature(uint32, CPointer(_type_curandStateMRG32k3a)), signature(uint32, CPointer(_type_curandStateSobol32)), signature(uint32, CPointer(_type_curandStateScrambledSobol32)), signature(uint64, CPointer(_type_curandStateSobol64)), signature(uint64, CPointer(_type_curandStateScrambledSobol64))]

register_global(curand, types.Function(_typing_curand))


@register
class _typing_curand_mtgp32_specific(ConcreteTemplate):
    key = globals()["curand_mtgp32_specific"]
    cases = [signature(uint32, CPointer(_type_curandStateMtgp32), uint8, uint8)]

register_global(curand_mtgp32_specific, types.Function(_typing_curand_mtgp32_specific))


@register
class _typing_curand_mtgp32_single(ConcreteTemplate):
    key = globals()["curand_mtgp32_single"]
    cases = [signature(float32, CPointer(_type_curandStateMtgp32))]

register_global(curand_mtgp32_single, types.Function(_typing_curand_mtgp32_single))


@register
class _typing_curand_mtgp32_single_specific(ConcreteTemplate):
    key = globals()["curand_mtgp32_single_specific"]
    cases = [signature(float32, CPointer(_type_curandStateMtgp32), uint8, uint8)]

register_global(curand_mtgp32_single_specific, types.Function(_typing_curand_mtgp32_single_specific))


@register
class _typing_Philox_State_Incr(ConcreteTemplate):
    key = globals()["Philox_State_Incr"]
    cases = [signature(none, CPointer(_type_curandStatePhilox4_32_10), uint64), signature(none, CPointer(_type_curandStatePhilox4_32_10))]

register_global(Philox_State_Incr, types.Function(_typing_Philox_State_Incr))


@register
class _typing_Philox_State_Incr_hi(ConcreteTemplate):
    key = globals()["Philox_State_Incr_hi"]
    cases = [signature(none, CPointer(_type_curandStatePhilox4_32_10), uint64)]

register_global(Philox_State_Incr_hi, types.Function(_typing_Philox_State_Incr_hi))


@register
class _typing_mulhilo32(ConcreteTemplate):
    key = globals()["mulhilo32"]
    cases = [signature(uint32, uint32, uint32, CPointer(uint32))]

register_global(mulhilo32, types.Function(_typing_mulhilo32))


@register
class _typing__philox4x32round(ConcreteTemplate):
    key = globals()["_philox4x32round"]
    cases = [signature(uint32x4, uint32x4, uint32x2)]

register_global(_philox4x32round, types.Function(_typing__philox4x32round))


@register
class _typing_curand_Philox4x32_10(ConcreteTemplate):
    key = globals()["curand_Philox4x32_10"]
    cases = [signature(uint32x4, uint32x4, uint32x2)]

register_global(curand_Philox4x32_10, types.Function(_typing_curand_Philox4x32_10))


@register
class _typing___curand_matvec(ConcreteTemplate):
    key = globals()["__curand_matvec"]
    cases = [signature(none, CPointer(uint32), CPointer(uint32), CPointer(uint32), int32)]

register_global(__curand_matvec, types.Function(_typing___curand_matvec))


@register
class _typing___curand_matidentity(ConcreteTemplate):
    key = globals()["__curand_matidentity"]
    cases = [signature(none, CPointer(uint32), int32)]

register_global(__curand_matidentity, types.Function(_typing___curand_matidentity))


@register
class _typing___curand_matmat(ConcreteTemplate):
    key = globals()["__curand_matmat"]
    cases = [signature(none, CPointer(uint32), CPointer(uint32), int32)]

register_global(__curand_matmat, types.Function(_typing___curand_matmat))


@register
class _typing___curand_veccopy(ConcreteTemplate):
    key = globals()["__curand_veccopy"]
    cases = [signature(none, CPointer(uint32), CPointer(uint32), int32)]

register_global(__curand_veccopy, types.Function(_typing___curand_veccopy))


@register
class _typing___curand_matcopy(ConcreteTemplate):
    key = globals()["__curand_matcopy"]
    cases = [signature(none, CPointer(uint32), CPointer(uint32), int32)]

register_global(__curand_matcopy, types.Function(_typing___curand_matcopy))


@register
class _typing___curand_matpow(ConcreteTemplate):
    key = globals()["__curand_matpow"]
    cases = [signature(none, CPointer(uint32), CPointer(uint32), uint64, int32)]

register_global(__curand_matpow, types.Function(_typing___curand_matpow))


@register
class _typing_curand_MRGmod(ConcreteTemplate):
    key = globals()["curand_MRGmod"]
    cases = [signature(float64, float64, float64)]

register_global(curand_MRGmod, types.Function(_typing_curand_MRGmod))


@register
class _typing_curand_MRGmodMul(ConcreteTemplate):
    key = globals()["curand_MRGmodMul"]
    cases = [signature(float64, float64, float64, float64)]

register_global(curand_MRGmodMul, types.Function(_typing_curand_MRGmodMul))


@register
class _typing_curand_MRGmatMul3x3(ConcreteTemplate):
    key = globals()["curand_MRGmatMul3x3"]
    cases = [signature(none, CPointer(uint32), CPointer(uint32), CPointer(uint32), float64)]

register_global(curand_MRGmatMul3x3, types.Function(_typing_curand_MRGmatMul3x3))


@register
class _typing_curand_MRGmatVecMul3x3(ConcreteTemplate):
    key = globals()["curand_MRGmatVecMul3x3"]
    cases = [signature(none, CPointer(uint32), CPointer(uint32), float64)]

register_global(curand_MRGmatVecMul3x3, types.Function(_typing_curand_MRGmatVecMul3x3))


@register
class _typing_curand_MRGmatPow3x3(ConcreteTemplate):
    key = globals()["curand_MRGmatPow3x3"]
    cases = [signature(none, CPointer(uint32), CPointer(uint32), float64, uint64)]

register_global(curand_MRGmatPow3x3, types.Function(_typing_curand_MRGmatPow3x3))


@register
class _typing_curnand_MRGmatPow2Pow3x3(ConcreteTemplate):
    key = globals()["curnand_MRGmatPow2Pow3x3"]
    cases = [signature(none, CPointer(float64), CPointer(float64), float64, uint64)]

register_global(curnand_MRGmatPow2Pow3x3, types.Function(_typing_curnand_MRGmatPow2Pow3x3))


@register
class _typing_curand_init(ConcreteTemplate):
    key = globals()["curand_init"]
    cases = [signature(none, uint64, uint64, uint64, CPointer(_type_curandStateTest)), signature(none, uint64, uint64, uint64, CPointer(_type_curandStateXORWOW)), signature(none, uint64, uint64, uint64, CPointer(_type_curandStatePhilox4_32_10)), signature(none, uint64, uint64, uint64, CPointer(_type_curandStateMRG32k3a)), signature(none, CPointer(uint32), uint32, CPointer(_type_curandStateSobol32)), signature(none, CPointer(uint32), uint32, uint32, CPointer(_type_curandStateScrambledSobol32)), signature(none, CPointer(uint64), uint64, CPointer(_type_curandStateSobol64)), signature(none, CPointer(uint64), uint64, uint64, CPointer(_type_curandStateScrambledSobol64))]

register_global(curand_init, types.Function(_typing_curand_init))


@register
class _typing_skipahead(ConcreteTemplate):
    key = globals()["skipahead"]
    cases = [signature(none, uint64, CPointer(_type_curandStateTest)), signature(none, uint64, CPointer(_type_curandStateXORWOW)), signature(none, uint64, CPointer(_type_curandStatePhilox4_32_10)), signature(none, uint64, CPointer(_type_curandStateMRG32k3a))]

register_global(skipahead, types.Function(_typing_skipahead))


@register
class _typing_skipahead_sequence(ConcreteTemplate):
    key = globals()["skipahead_sequence"]
    cases = [signature(none, uint64, CPointer(_type_curandStateXORWOW)), signature(none, uint64, CPointer(_type_curandStatePhilox4_32_10)), signature(none, uint64, CPointer(_type_curandStateMRG32k3a))]

register_global(skipahead_sequence, types.Function(_typing_skipahead_sequence))


@register
class _typing__curand_init_scratch(ConcreteTemplate):
    key = globals()["_curand_init_scratch"]
    cases = [signature(none, uint64, uint64, uint64, CPointer(_type_curandStateXORWOW), CPointer(uint32))]

register_global(_curand_init_scratch, types.Function(_typing__curand_init_scratch))


@register
class _typing__curand_init_inplace(ConcreteTemplate):
    key = globals()["_curand_init_inplace"]
    cases = [signature(none, uint64, uint64, uint64, CPointer(_type_curandStateXORWOW))]

register_global(_curand_init_inplace, types.Function(_typing__curand_init_inplace))


@register
class _typing_curand4(ConcreteTemplate):
    key = globals()["curand4"]
    cases = [signature(uint32x4, CPointer(_type_curandStatePhilox4_32_10))]

register_global(curand4, types.Function(_typing_curand4))


@register
class _typing___curand_umad(ConcreteTemplate):
    key = globals()["__curand_umad"]
    cases = [signature(uint64, uint32, uint32, uint64)]

register_global(__curand_umad, types.Function(_typing___curand_umad))


@register
class _typing___curand_umul(ConcreteTemplate):
    key = globals()["__curand_umul"]
    cases = [signature(uint64, uint32, uint32)]

register_global(__curand_umul, types.Function(_typing___curand_umul))


@register
class _typing_curand_MRG32k3a(ConcreteTemplate):
    key = globals()["curand_MRG32k3a"]
    cases = [signature(float64, CPointer(_type_curandStateMRG32k3a))]

register_global(curand_MRG32k3a, types.Function(_typing_curand_MRG32k3a))


@register
class _typing_skipahead_subsequence(ConcreteTemplate):
    key = globals()["skipahead_subsequence"]
    cases = [signature(none, uint64, CPointer(_type_curandStateMRG32k3a))]

register_global(skipahead_subsequence, types.Function(_typing_skipahead_subsequence))


@register
class _typing___curand_find_trailing_zero(ConcreteTemplate):
    key = globals()["__curand_find_trailing_zero"]
    cases = [signature(int32, uint32), signature(int32, uint64)]

register_global(__curand_find_trailing_zero, types.Function(_typing___curand_find_trailing_zero))


@register
class _typing__curand_uniform(ConcreteTemplate):
    key = globals()["_curand_uniform"]
    cases = [signature(float32, uint32), signature(float32, uint64)]

register_global(_curand_uniform, types.Function(_typing__curand_uniform))


@register
class _typing__curand_uniform4(ConcreteTemplate):
    key = globals()["_curand_uniform4"]
    cases = [signature(float32x4, uint32x4)]

register_global(_curand_uniform4, types.Function(_typing__curand_uniform4))


@register
class _typing__curand_uniform_double(ConcreteTemplate):
    key = globals()["_curand_uniform_double"]
    cases = [signature(float64, uint32), signature(float64, uint64)]

register_global(_curand_uniform_double, types.Function(_typing__curand_uniform_double))


@register
class _typing__curand_uniform_double_hq(ConcreteTemplate):
    key = globals()["_curand_uniform_double_hq"]
    cases = [signature(float64, uint32, uint32)]

register_global(_curand_uniform_double_hq, types.Function(_typing__curand_uniform_double_hq))


@register
class _typing_curand_uniform(ConcreteTemplate):
    key = globals()["curand_uniform"]
    cases = [signature(float32, CPointer(_type_curandStateTest)), signature(float32, CPointer(_type_curandStateXORWOW)), signature(float32, CPointer(_type_curandStateMRG32k3a)), signature(float32, CPointer(_type_curandStatePhilox4_32_10)), signature(float32, CPointer(_type_curandStateMtgp32)), signature(float32, CPointer(_type_curandStateSobol32)), signature(float32, CPointer(_type_curandStateScrambledSobol32)), signature(float32, CPointer(_type_curandStateSobol64)), signature(float32, CPointer(_type_curandStateScrambledSobol64))]

register_global(curand_uniform, types.Function(_typing_curand_uniform))


@register
class _typing_curand_uniform_double(ConcreteTemplate):
    key = globals()["curand_uniform_double"]
    cases = [signature(float64, CPointer(_type_curandStateTest)), signature(float64, CPointer(_type_curandStateXORWOW)), signature(float64, CPointer(_type_curandStateMRG32k3a)), signature(float64, CPointer(_type_curandStateMtgp32)), signature(float64, CPointer(_type_curandStatePhilox4_32_10)), signature(float64, CPointer(_type_curandStateSobol32)), signature(float64, CPointer(_type_curandStateScrambledSobol32)), signature(float64, CPointer(_type_curandStateSobol64)), signature(float64, CPointer(_type_curandStateScrambledSobol64))]

register_global(curand_uniform_double, types.Function(_typing_curand_uniform_double))


@register
class _typing_curand_uniform2_double(ConcreteTemplate):
    key = globals()["curand_uniform2_double"]
    cases = [signature(float64x2, CPointer(_type_curandStatePhilox4_32_10))]

register_global(curand_uniform2_double, types.Function(_typing_curand_uniform2_double))


@register
class _typing_curand_uniform4_double(ConcreteTemplate):
    key = globals()["curand_uniform4_double"]
    cases = [signature(float64x4, CPointer(_type_curandStatePhilox4_32_10))]

register_global(curand_uniform4_double, types.Function(_typing_curand_uniform4_double))


@register
class _typing_curand_uniform4(ConcreteTemplate):
    key = globals()["curand_uniform4"]
    cases = [signature(float32x4, CPointer(_type_curandStatePhilox4_32_10))]

register_global(curand_uniform4, types.Function(_typing_curand_uniform4))


@register
class _typing__curand_normal_icdf(ConcreteTemplate):
    key = globals()["_curand_normal_icdf"]
    cases = [signature(float32, uint32), signature(float32, uint64)]

register_global(_curand_normal_icdf, types.Function(_typing__curand_normal_icdf))


@register
class _typing__curand_normal_icdf_double(ConcreteTemplate):
    key = globals()["_curand_normal_icdf_double"]
    cases = [signature(float64, uint32), signature(float64, uint64)]

register_global(_curand_normal_icdf_double, types.Function(_typing__curand_normal_icdf_double))


@register
class _typing__curand_box_muller(ConcreteTemplate):
    key = globals()["_curand_box_muller"]
    cases = [signature(float32x2, uint32, uint32)]

register_global(_curand_box_muller, types.Function(_typing__curand_box_muller))


@register
class _typing_curand_box_muller_mrg(ConcreteTemplate):
    key = globals()["curand_box_muller_mrg"]
    cases = [signature(float32x2, CPointer(_type_curandStateMRG32k3a))]

register_global(curand_box_muller_mrg, types.Function(_typing_curand_box_muller_mrg))


@register
class _typing__curand_box_muller_double(ConcreteTemplate):
    key = globals()["_curand_box_muller_double"]
    cases = [signature(float64x2, uint32, uint32, uint32, uint32)]

register_global(_curand_box_muller_double, types.Function(_typing__curand_box_muller_double))


@register
class _typing_curand_box_muller_mrg_double(ConcreteTemplate):
    key = globals()["curand_box_muller_mrg_double"]
    cases = [signature(float64x2, CPointer(_type_curandStateMRG32k3a))]

register_global(curand_box_muller_mrg_double, types.Function(_typing_curand_box_muller_mrg_double))


@register
class _typing_curand_normal(ConcreteTemplate):
    key = globals()["curand_normal"]
    cases = [signature(float32, CPointer(_type_curandStateXORWOW)), signature(float32, CPointer(_type_curandStatePhilox4_32_10)), signature(float32, CPointer(_type_curandStateMRG32k3a)), signature(float32, CPointer(_type_curandStateMtgp32)), signature(float32, CPointer(_type_curandStateSobol32)), signature(float32, CPointer(_type_curandStateScrambledSobol32)), signature(float32, CPointer(_type_curandStateSobol64)), signature(float32, CPointer(_type_curandStateScrambledSobol64))]

register_global(curand_normal, types.Function(_typing_curand_normal))


@register
class _typing_curand_normal2(ConcreteTemplate):
    key = globals()["curand_normal2"]
    cases = [signature(float32x2, CPointer(_type_curandStateXORWOW)), signature(float32x2, CPointer(_type_curandStatePhilox4_32_10)), signature(float32x2, CPointer(_type_curandStateMRG32k3a))]

register_global(curand_normal2, types.Function(_typing_curand_normal2))


@register
class _typing_curand_normal4(ConcreteTemplate):
    key = globals()["curand_normal4"]
    cases = [signature(float32x4, CPointer(_type_curandStatePhilox4_32_10))]

register_global(curand_normal4, types.Function(_typing_curand_normal4))


@register
class _typing_curand_normal_double(ConcreteTemplate):
    key = globals()["curand_normal_double"]
    cases = [signature(float64, CPointer(_type_curandStateXORWOW)), signature(float64, CPointer(_type_curandStatePhilox4_32_10)), signature(float64, CPointer(_type_curandStateMRG32k3a)), signature(float64, CPointer(_type_curandStateMtgp32)), signature(float64, CPointer(_type_curandStateSobol32)), signature(float64, CPointer(_type_curandStateScrambledSobol32)), signature(float64, CPointer(_type_curandStateSobol64)), signature(float64, CPointer(_type_curandStateScrambledSobol64))]

register_global(curand_normal_double, types.Function(_typing_curand_normal_double))


@register
class _typing_curand_normal2_double(ConcreteTemplate):
    key = globals()["curand_normal2_double"]
    cases = [signature(float64x2, CPointer(_type_curandStateXORWOW)), signature(float64x2, CPointer(_type_curandStatePhilox4_32_10)), signature(float64x2, CPointer(_type_curandStateMRG32k3a))]

register_global(curand_normal2_double, types.Function(_typing_curand_normal2_double))


@register
class _typing_curand_normal4_double(ConcreteTemplate):
    key = globals()["curand_normal4_double"]
    cases = [signature(float64x4, CPointer(_type_curandStatePhilox4_32_10))]

register_global(curand_normal4_double, types.Function(_typing_curand_normal4_double))


@register
class _typing_curand_log_normal(ConcreteTemplate):
    key = globals()["curand_log_normal"]
    cases = [signature(float32, CPointer(_type_curandStateXORWOW), float32, float32), signature(float32, CPointer(_type_curandStatePhilox4_32_10), float32, float32), signature(float32, CPointer(_type_curandStateMRG32k3a), float32, float32), signature(float32, CPointer(_type_curandStateMtgp32), float32, float32), signature(float32, CPointer(_type_curandStateSobol32), float32, float32), signature(float32, CPointer(_type_curandStateScrambledSobol32), float32, float32), signature(float32, CPointer(_type_curandStateSobol64), float32, float32), signature(float32, CPointer(_type_curandStateScrambledSobol64), float32, float32)]

register_global(curand_log_normal, types.Function(_typing_curand_log_normal))


@register
class _typing_curand_log_normal2(ConcreteTemplate):
    key = globals()["curand_log_normal2"]
    cases = [signature(float32x2, CPointer(_type_curandStateXORWOW), float32, float32), signature(float32x2, CPointer(_type_curandStatePhilox4_32_10), float32, float32), signature(float32x2, CPointer(_type_curandStateMRG32k3a), float32, float32)]

register_global(curand_log_normal2, types.Function(_typing_curand_log_normal2))


@register
class _typing_curand_log_normal4(ConcreteTemplate):
    key = globals()["curand_log_normal4"]
    cases = [signature(float32x4, CPointer(_type_curandStatePhilox4_32_10), float32, float32)]

register_global(curand_log_normal4, types.Function(_typing_curand_log_normal4))


@register
class _typing_curand_log_normal_double(ConcreteTemplate):
    key = globals()["curand_log_normal_double"]
    cases = [signature(float64, CPointer(_type_curandStateXORWOW), float64, float64), signature(float64, CPointer(_type_curandStatePhilox4_32_10), float64, float64), signature(float64, CPointer(_type_curandStateMRG32k3a), float64, float64), signature(float64, CPointer(_type_curandStateMtgp32), float64, float64), signature(float64, CPointer(_type_curandStateSobol32), float64, float64), signature(float64, CPointer(_type_curandStateScrambledSobol32), float64, float64), signature(float64, CPointer(_type_curandStateSobol64), float64, float64), signature(float64, CPointer(_type_curandStateScrambledSobol64), float64, float64)]

register_global(curand_log_normal_double, types.Function(_typing_curand_log_normal_double))


@register
class _typing_curand_log_normal2_double(ConcreteTemplate):
    key = globals()["curand_log_normal2_double"]
    cases = [signature(float64x2, CPointer(_type_curandStateXORWOW), float64, float64), signature(float64x2, CPointer(_type_curandStatePhilox4_32_10), float64, float64), signature(float64x2, CPointer(_type_curandStateMRG32k3a), float64, float64)]

register_global(curand_log_normal2_double, types.Function(_typing_curand_log_normal2_double))


@register
class _typing_curand_log_normal4_double(ConcreteTemplate):
    key = globals()["curand_log_normal4_double"]
    cases = [signature(float64x4, CPointer(_type_curandStatePhilox4_32_10), float64, float64)]

register_global(curand_log_normal4_double, types.Function(_typing_curand_log_normal4_double))


@register
class _typing___cr_rsqrt(ConcreteTemplate):
    key = globals()["__cr_rsqrt"]
    cases = [signature(float32, float32)]

register_global(__cr_rsqrt, types.Function(_typing___cr_rsqrt))


@register
class _typing___cr_exp(ConcreteTemplate):
    key = globals()["__cr_exp"]
    cases = [signature(float32, float32)]

register_global(__cr_exp, types.Function(_typing___cr_exp))


@register
class _typing___cr_log(ConcreteTemplate):
    key = globals()["__cr_log"]
    cases = [signature(float32, float32)]

register_global(__cr_log, types.Function(_typing___cr_log))


@register
class _typing___cr_rcp(ConcreteTemplate):
    key = globals()["__cr_rcp"]
    cases = [signature(float32, float32)]

register_global(__cr_rcp, types.Function(_typing___cr_rcp))


@register
class _typing___cr_pgammainc(ConcreteTemplate):
    key = globals()["__cr_pgammainc"]
    cases = [signature(float32, float32, float32)]

register_global(__cr_pgammainc, types.Function(_typing___cr_pgammainc))


@register
class _typing___cr_pgammaincinv(ConcreteTemplate):
    key = globals()["__cr_pgammaincinv"]
    cases = [signature(float32, float32, float32)]

register_global(__cr_pgammaincinv, types.Function(_typing___cr_pgammaincinv))


@register
class _typing___cr_lgamma_integer(ConcreteTemplate):
    key = globals()["__cr_lgamma_integer"]
    cases = [signature(float64, int32)]

register_global(__cr_lgamma_integer, types.Function(_typing___cr_lgamma_integer))


@register
class _typing__curand_uniform_double_excluding_one(ConcreteTemplate):
    key = globals()["_curand_uniform_double_excluding_one"]
    cases = [signature(float64, uint32), signature(float64, uint64)]

register_global(_curand_uniform_double_excluding_one, types.Function(_typing__curand_uniform_double_excluding_one))


@register
class _typing_curand_poisson(ConcreteTemplate):
    key = globals()["curand_poisson"]
    cases = [signature(uint32, CPointer(_type_curandStateXORWOW), float64), signature(uint32, CPointer(_type_curandStatePhilox4_32_10), float64), signature(uint32, CPointer(_type_curandStateMRG32k3a), float64), signature(uint32, CPointer(_type_curandStateMtgp32), float64), signature(uint32, CPointer(_type_curandStateSobol32), float64), signature(uint32, CPointer(_type_curandStateScrambledSobol32), float64), signature(uint32, CPointer(_type_curandStateSobol64), float64), signature(uint32, CPointer(_type_curandStateScrambledSobol64), float64)]

register_global(curand_poisson, types.Function(_typing_curand_poisson))


@register
class _typing_curand_poisson4(ConcreteTemplate):
    key = globals()["curand_poisson4"]
    cases = [signature(uint32x4, CPointer(_type_curandStatePhilox4_32_10), float64)]

register_global(curand_poisson4, types.Function(_typing_curand_poisson4))


@register
class _typing_curand_discrete(ConcreteTemplate):
    key = globals()["curand_discrete"]
    cases = [signature(uint32, CPointer(_type_curandStateXORWOW), CPointer(_type_curandDiscreteDistribution_st)), signature(uint32, CPointer(_type_curandStatePhilox4_32_10), CPointer(_type_curandDiscreteDistribution_st)), signature(uint32, CPointer(_type_curandStateMRG32k3a), CPointer(_type_curandDiscreteDistribution_st)), signature(uint32, CPointer(_type_curandStateMtgp32), CPointer(_type_curandDiscreteDistribution_st)), signature(uint32, CPointer(_type_curandStateSobol32), CPointer(_type_curandDiscreteDistribution_st)), signature(uint32, CPointer(_type_curandStateScrambledSobol32), CPointer(_type_curandDiscreteDistribution_st)), signature(uint32, CPointer(_type_curandStateSobol64), CPointer(_type_curandDiscreteDistribution_st)), signature(uint32, CPointer(_type_curandStateScrambledSobol64), CPointer(_type_curandDiscreteDistribution_st))]

register_global(curand_discrete, types.Function(_typing_curand_discrete))


@register
class _typing_curand_discrete4(ConcreteTemplate):
    key = globals()["curand_discrete4"]
    cases = [signature(uint32x4, CPointer(_type_curandStatePhilox4_32_10), CPointer(_type_curandDiscreteDistribution_st))]

register_global(curand_discrete4, types.Function(_typing_curand_discrete4))


@register
class _typing___get_precalculated_matrix(ConcreteTemplate):
    key = globals()["__get_precalculated_matrix"]
    cases = [signature(CPointer(uint32), int32)]

register_global(__get_precalculated_matrix, types.Function(_typing___get_precalculated_matrix))


@register
class _typing___get_mrg32k3a_matrix(ConcreteTemplate):
    key = globals()["__get_mrg32k3a_matrix"]
    cases = [signature(CPointer(uint32), int32)]

register_global(__get_mrg32k3a_matrix, types.Function(_typing___get_mrg32k3a_matrix))


# Aliases:
mtgp32_params_fast_t = mtgp32_params_fast
mtgp32_kernel_params_t = mtgp32_kernel_params
curandStateMtgp32_t = curandStateMtgp32
curandStatePhilox4_32_10_t = curandStatePhilox4_32_10
normal_args_t = normal_args_st
normal_args_double_t = normal_args_double_st
curandStateTest_t = curandStateTest
curandStateXORWOW_t = curandStateXORWOW
curandState_t = curandStateXORWOW
curandState = curandStateXORWOW
curandStateMRG32k3a_t = curandStateMRG32k3a
curandStateSobol32_t = curandStateSobol32
curandStateScrambledSobol32_t = curandStateScrambledSobol32
curandStateSobol64_t = curandStateSobol64
curandStateScrambledSobol64_t = curandStateScrambledSobol64

# Shim functions:

curand_kernel_header = os.path.join(pathfinder.find_nvidia_header_directory("curand"), 'curand_kernel.h')
c_ext_shim_source = CUSource("""#include <%s>

extern "C" __device__ int
para_rec_1(unsigned int *retval , mtgp32_kernel_params ** k, unsigned int* X1, unsigned int* X2, unsigned int* Y, int* bid) {
    unsigned int local_retval = para_rec(*k, *X1, *X2, *Y, *bid);
    memcpy(retval, &local_retval, sizeof(unsigned int));
    return 0;
}


extern "C" __device__ int
temper_1(unsigned int *retval , mtgp32_kernel_params ** k, unsigned int* V, unsigned int* T, int* bid) {
    unsigned int local_retval = temper(*k, *V, *T, *bid);
    memcpy(retval, &local_retval, sizeof(unsigned int));
    return 0;
}


extern "C" __device__ int
temper_single_1(unsigned int *retval , mtgp32_kernel_params ** k, unsigned int* V, unsigned int* T, int* bid) {
    unsigned int local_retval = temper_single(*k, *V, *T, *bid);
    memcpy(retval, &local_retval, sizeof(unsigned int));
    return 0;
}


extern "C" __device__ int
curand_1(unsigned int *retval , curandStateMtgp32 ** state) {
    unsigned int local_retval = curand(*state);
    memcpy(retval, &local_retval, sizeof(unsigned int));
    return 0;
}


extern "C" __device__ int
curand_mtgp32_specific_1(unsigned int *retval , curandStateMtgp32 ** state, unsigned char* index, unsigned char* n) {
    unsigned int local_retval = curand_mtgp32_specific(*state, *index, *n);
    memcpy(retval, &local_retval, sizeof(unsigned int));
    return 0;
}


extern "C" __device__ int
curand_mtgp32_single_1(float *retval , curandStateMtgp32 ** state) {
    float local_retval = curand_mtgp32_single(*state);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
curand_mtgp32_single_specific_1(float *retval , curandStateMtgp32 ** state, unsigned char* index, unsigned char* n) {
    float local_retval = curand_mtgp32_single_specific(*state, *index, *n);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
Philox_State_Incr_1(int *retval , curandStatePhilox4_32_10 ** s, unsigned long long* n) {
    Philox_State_Incr(*s, *n);

    return 0;
}


extern "C" __device__ int
Philox_State_Incr_hi_1(int *retval , curandStatePhilox4_32_10 ** s, unsigned long long* n) {
    Philox_State_Incr_hi(*s, *n);

    return 0;
}


extern "C" __device__ int
Philox_State_Incr_2(int *retval , curandStatePhilox4_32_10 ** s) {
    Philox_State_Incr(*s);

    return 0;
}


extern "C" __device__ int
mulhilo32_1(unsigned int *retval , unsigned int* a, unsigned int* b, unsigned int ** hip) {
    unsigned int local_retval = mulhilo32(*a, *b, *hip);
    memcpy(retval, &local_retval, sizeof(unsigned int));
    return 0;
}


extern "C" __device__ int
_philox4x32round_1(uint4 *retval , uint4* ctr, uint2* key) {
    uint4 local_retval = _philox4x32round(*ctr, *key);
    memcpy(retval, &local_retval, sizeof(uint4));
    return 0;
}


extern "C" __device__ int
curand_Philox4x32_10_1(uint4 *retval , uint4* c, uint2* k) {
    uint4 local_retval = curand_Philox4x32_10(*c, *k);
    memcpy(retval, &local_retval, sizeof(uint4));
    return 0;
}


extern "C" __device__ int
__curand_matvec_1(int *retval , unsigned int ** vector, unsigned int ** matrix, unsigned int ** result, int* n) {
    __curand_matvec(*vector, *matrix, *result, *n);

    return 0;
}


extern "C" __device__ int
__curand_matidentity_1(int *retval , unsigned int ** matrix, int* n) {
    __curand_matidentity(*matrix, *n);

    return 0;
}


extern "C" __device__ int
__curand_matmat_1(int *retval , unsigned int ** matrixA, unsigned int ** matrixB, int* n) {
    __curand_matmat(*matrixA, *matrixB, *n);

    return 0;
}


extern "C" __device__ int
__curand_veccopy_1(int *retval , unsigned int ** vector, unsigned int ** vectorA, int* n) {
    __curand_veccopy(*vector, *vectorA, *n);

    return 0;
}


extern "C" __device__ int
__curand_matcopy_1(int *retval , unsigned int ** matrix, unsigned int ** matrixA, int* n) {
    __curand_matcopy(*matrix, *matrixA, *n);

    return 0;
}


extern "C" __device__ int
__curand_matpow_1(int *retval , unsigned int ** matrix, unsigned int ** matrixA, unsigned long long* p, int* n) {
    __curand_matpow(*matrix, *matrixA, *p, *n);

    return 0;
}


extern "C" __device__ int
curand_MRGmod_1(double *retval , double* i, double* m) {
    double local_retval = curand_MRGmod(*i, *m);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
curand_MRGmodMul_1(double *retval , double* i, double* j, double* m) {
    double local_retval = curand_MRGmodMul(*i, *j, *m);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
curand_MRGmatMul3x3_1(int *retval , unsigned int (**i1)[3], unsigned int (**i2)[3], unsigned int (**o)[3], double* m) {
    curand_MRGmatMul3x3(*i1, *i2, *o, *m);

    return 0;
}


extern "C" __device__ int
curand_MRGmatVecMul3x3_1(int *retval , unsigned int (**i)[3], unsigned int ** v, double* m) {
    curand_MRGmatVecMul3x3(*i, *v, *m);

    return 0;
}


extern "C" __device__ int
curand_MRGmatPow3x3_1(int *retval , unsigned int (**in)[3][3], unsigned int (**o)[3], double* m, unsigned long long* pow) {
    curand_MRGmatPow3x3(*in, *o, *m, *pow);

    return 0;
}


extern "C" __device__ int
curnand_MRGmatPow2Pow3x3_1(int *retval , double (**in)[3], double (**o)[3], double* m, unsigned long* pow) {
    curnand_MRGmatPow2Pow3x3(*in, *o, *m, *pow);

    return 0;
}


extern "C" __device__ int
curand_init_1(int *retval , unsigned long long* seed, unsigned long long* subsequence, unsigned long long* offset, curandStateTest ** state) {
    curand_init(*seed, *subsequence, *offset, *state);

    return 0;
}


extern "C" __device__ int
curand_2(unsigned int *retval , curandStateTest ** state) {
    unsigned int local_retval = curand(*state);
    memcpy(retval, &local_retval, sizeof(unsigned int));
    return 0;
}


extern "C" __device__ int
skipahead_1(int *retval , unsigned long long* n, curandStateTest ** state) {
    skipahead(*n, *state);

    return 0;
}


extern "C" __device__ int
skipahead_2(int *retval , unsigned long long* n, curandStateXORWOW ** state) {
    skipahead(*n, *state);

    return 0;
}


extern "C" __device__ int
skipahead_sequence_1(int *retval , unsigned long long* n, curandStateXORWOW ** state) {
    skipahead_sequence(*n, *state);

    return 0;
}


extern "C" __device__ int
_curand_init_scratch_1(int *retval , unsigned long long* seed, unsigned long long* subsequence, unsigned long long* offset, curandStateXORWOW ** state, unsigned int ** scratch) {
    _curand_init_scratch(*seed, *subsequence, *offset, *state, *scratch);

    return 0;
}


extern "C" __device__ int
_curand_init_inplace_1(int *retval , unsigned long long* seed, unsigned long long* subsequence, unsigned long long* offset, curandStateXORWOW ** state) {
    _curand_init_inplace(*seed, *subsequence, *offset, *state);

    return 0;
}


extern "C" __device__ int
curand_init_2(int *retval , unsigned long long* seed, unsigned long long* subsequence, unsigned long long* offset, curandStateXORWOW ** state) {
    curand_init(*seed, *subsequence, *offset, *state);

    return 0;
}


extern "C" __device__ int
curand_3(unsigned int *retval , curandStateXORWOW ** state) {
    unsigned int local_retval = curand(*state);
    memcpy(retval, &local_retval, sizeof(unsigned int));
    return 0;
}


extern "C" __device__ int
curand_4(unsigned int *retval , curandStatePhilox4_32_10 ** state) {
    unsigned int local_retval = curand(*state);
    memcpy(retval, &local_retval, sizeof(unsigned int));
    return 0;
}


extern "C" __device__ int
curand4_1(uint4 *retval , curandStatePhilox4_32_10 ** state) {
    uint4 local_retval = curand4(*state);
    memcpy(retval, &local_retval, sizeof(uint4));
    return 0;
}


extern "C" __device__ int
skipahead_3(int *retval , unsigned long long* n, curandStatePhilox4_32_10 ** state) {
    skipahead(*n, *state);

    return 0;
}


extern "C" __device__ int
skipahead_sequence_2(int *retval , unsigned long long* n, curandStatePhilox4_32_10 ** state) {
    skipahead_sequence(*n, *state);

    return 0;
}


extern "C" __device__ int
curand_init_3(int *retval , unsigned long long* seed, unsigned long long* subsequence, unsigned long long* offset, curandStatePhilox4_32_10 ** state) {
    curand_init(*seed, *subsequence, *offset, *state);

    return 0;
}


extern "C" __device__ int
__curand_umad_1(unsigned long long *retval , unsigned int* a, unsigned int* b, unsigned long long* c) {
    unsigned long long local_retval = __curand_umad(*a, *b, *c);
    memcpy(retval, &local_retval, sizeof(unsigned long long));
    return 0;
}


extern "C" __device__ int
__curand_umul_1(unsigned long long *retval , unsigned int* a, unsigned int* b) {
    unsigned long long local_retval = __curand_umul(*a, *b);
    memcpy(retval, &local_retval, sizeof(unsigned long long));
    return 0;
}


extern "C" __device__ int
curand_MRG32k3a_1(double *retval , curandStateMRG32k3a ** state) {
    double local_retval = curand_MRG32k3a(*state);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
curand_5(unsigned int *retval , curandStateMRG32k3a ** state) {
    unsigned int local_retval = curand(*state);
    memcpy(retval, &local_retval, sizeof(unsigned int));
    return 0;
}


extern "C" __device__ int
skipahead_4(int *retval , unsigned long long* n, curandStateMRG32k3a ** state) {
    skipahead(*n, *state);

    return 0;
}


extern "C" __device__ int
skipahead_subsequence_1(int *retval , unsigned long long* n, curandStateMRG32k3a ** state) {
    skipahead_subsequence(*n, *state);

    return 0;
}


extern "C" __device__ int
skipahead_sequence_3(int *retval , unsigned long long* n, curandStateMRG32k3a ** state) {
    skipahead_sequence(*n, *state);

    return 0;
}


extern "C" __device__ int
curand_init_4(int *retval , unsigned long long* seed, unsigned long long* subsequence, unsigned long long* offset, curandStateMRG32k3a ** state) {
    curand_init(*seed, *subsequence, *offset, *state);

    return 0;
}


extern "C" __device__ int
curand_init_5(int *retval , unsigned int ** direction_vectors, unsigned int* offset, curandStateSobol32 ** state) {
    curand_init(*direction_vectors, *offset, *state);

    return 0;
}


extern "C" __device__ int
curand_init_6(int *retval , unsigned int ** direction_vectors, unsigned int* scramble_c, unsigned int* offset, curandStateScrambledSobol32 ** state) {
    curand_init(*direction_vectors, *scramble_c, *offset, *state);

    return 0;
}


extern "C" __device__ int
__curand_find_trailing_zero_1(int *retval , unsigned int* x) {
    int local_retval = __curand_find_trailing_zero(*x);
    memcpy(retval, &local_retval, sizeof(int));
    return 0;
}


extern "C" __device__ int
__curand_find_trailing_zero_2(int *retval , unsigned long long* x) {
    int local_retval = __curand_find_trailing_zero(*x);
    memcpy(retval, &local_retval, sizeof(int));
    return 0;
}


extern "C" __device__ int
curand_init_7(int *retval , unsigned long long ** direction_vectors, unsigned long long* offset, curandStateSobol64 ** state) {
    curand_init(*direction_vectors, *offset, *state);

    return 0;
}


extern "C" __device__ int
curand_init_8(int *retval , unsigned long long ** direction_vectors, unsigned long long* scramble_c, unsigned long long* offset, curandStateScrambledSobol64 ** state) {
    curand_init(*direction_vectors, *scramble_c, *offset, *state);

    return 0;
}


extern "C" __device__ int
curand_6(unsigned int *retval , curandStateSobol32 ** state) {
    unsigned int local_retval = curand(*state);
    memcpy(retval, &local_retval, sizeof(unsigned int));
    return 0;
}


extern "C" __device__ int
curand_7(unsigned int *retval , curandStateScrambledSobol32 ** state) {
    unsigned int local_retval = curand(*state);
    memcpy(retval, &local_retval, sizeof(unsigned int));
    return 0;
}


extern "C" __device__ int
curand_8(unsigned long long *retval , curandStateSobol64 ** state) {
    unsigned long long local_retval = curand(*state);
    memcpy(retval, &local_retval, sizeof(unsigned long long));
    return 0;
}


extern "C" __device__ int
curand_9(unsigned long long *retval , curandStateScrambledSobol64 ** state) {
    unsigned long long local_retval = curand(*state);
    memcpy(retval, &local_retval, sizeof(unsigned long long));
    return 0;
}


extern "C" __device__ int
_curand_uniform_1(float *retval , unsigned int* x) {
    float local_retval = _curand_uniform(*x);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
_curand_uniform4_1(float4 *retval , uint4* x) {
    float4 local_retval = _curand_uniform4(*x);
    memcpy(retval, &local_retval, sizeof(float4));
    return 0;
}


extern "C" __device__ int
_curand_uniform_2(float *retval , unsigned long long* x) {
    float local_retval = _curand_uniform(*x);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
_curand_uniform_double_1(double *retval , unsigned int* x) {
    double local_retval = _curand_uniform_double(*x);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
_curand_uniform_double_2(double *retval , unsigned long long* x) {
    double local_retval = _curand_uniform_double(*x);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
_curand_uniform_double_hq_1(double *retval , unsigned int* x, unsigned int* y) {
    double local_retval = _curand_uniform_double_hq(*x, *y);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
curand_uniform_1(float *retval , curandStateTest ** state) {
    float local_retval = curand_uniform(*state);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
curand_uniform_double_1(double *retval , curandStateTest ** state) {
    double local_retval = curand_uniform_double(*state);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
curand_uniform_2(float *retval , curandStateXORWOW ** state) {
    float local_retval = curand_uniform(*state);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
curand_uniform_double_2(double *retval , curandStateXORWOW ** state) {
    double local_retval = curand_uniform_double(*state);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
curand_uniform_3(float *retval , curandStateMRG32k3a ** state) {
    float local_retval = curand_uniform(*state);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
curand_uniform_double_3(double *retval , curandStateMRG32k3a ** state) {
    double local_retval = curand_uniform_double(*state);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
curand_uniform2_double_1(double2 *retval , curandStatePhilox4_32_10 ** state) {
    double2 local_retval = curand_uniform2_double(*state);
    memcpy(retval, &local_retval, sizeof(double2));
    return 0;
}


extern "C" __device__ int
curand_uniform4_double_1(double4 *retval , curandStatePhilox4_32_10 ** state) {
    double4 local_retval = curand_uniform4_double(*state);
    memcpy(retval, &local_retval, sizeof(double4));
    return 0;
}


extern "C" __device__ int
curand_uniform_4(float *retval , curandStatePhilox4_32_10 ** state) {
    float local_retval = curand_uniform(*state);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
curand_uniform4_1(float4 *retval , curandStatePhilox4_32_10 ** state) {
    float4 local_retval = curand_uniform4(*state);
    memcpy(retval, &local_retval, sizeof(float4));
    return 0;
}


extern "C" __device__ int
curand_uniform_5(float *retval , curandStateMtgp32 ** state) {
    float local_retval = curand_uniform(*state);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
curand_uniform_double_4(double *retval , curandStateMtgp32 ** state) {
    double local_retval = curand_uniform_double(*state);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
curand_uniform_double_5(double *retval , curandStatePhilox4_32_10 ** state) {
    double local_retval = curand_uniform_double(*state);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
curand_uniform_6(float *retval , curandStateSobol32 ** state) {
    float local_retval = curand_uniform(*state);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
curand_uniform_double_6(double *retval , curandStateSobol32 ** state) {
    double local_retval = curand_uniform_double(*state);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
curand_uniform_7(float *retval , curandStateScrambledSobol32 ** state) {
    float local_retval = curand_uniform(*state);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
curand_uniform_double_7(double *retval , curandStateScrambledSobol32 ** state) {
    double local_retval = curand_uniform_double(*state);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
curand_uniform_8(float *retval , curandStateSobol64 ** state) {
    float local_retval = curand_uniform(*state);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
curand_uniform_double_8(double *retval , curandStateSobol64 ** state) {
    double local_retval = curand_uniform_double(*state);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
curand_uniform_9(float *retval , curandStateScrambledSobol64 ** state) {
    float local_retval = curand_uniform(*state);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
curand_uniform_double_9(double *retval , curandStateScrambledSobol64 ** state) {
    double local_retval = curand_uniform_double(*state);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
_curand_normal_icdf_1(float *retval , unsigned int* x) {
    float local_retval = _curand_normal_icdf(*x);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
_curand_normal_icdf_2(float *retval , unsigned long long* x) {
    float local_retval = _curand_normal_icdf(*x);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
_curand_normal_icdf_double_1(double *retval , unsigned int* x) {
    double local_retval = _curand_normal_icdf_double(*x);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
_curand_normal_icdf_double_2(double *retval , unsigned long long* x) {
    double local_retval = _curand_normal_icdf_double(*x);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
_curand_box_muller_1(float2 *retval , unsigned int* x, unsigned int* y) {
    float2 local_retval = _curand_box_muller(*x, *y);
    memcpy(retval, &local_retval, sizeof(float2));
    return 0;
}


extern "C" __device__ int
curand_box_muller_mrg_1(float2 *retval , curandStateMRG32k3a ** state) {
    float2 local_retval = curand_box_muller_mrg(*state);
    memcpy(retval, &local_retval, sizeof(float2));
    return 0;
}


extern "C" __device__ int
_curand_box_muller_double_1(double2 *retval , unsigned int* x0, unsigned int* x1, unsigned int* y0, unsigned int* y1) {
    double2 local_retval = _curand_box_muller_double(*x0, *x1, *y0, *y1);
    memcpy(retval, &local_retval, sizeof(double2));
    return 0;
}


extern "C" __device__ int
curand_box_muller_mrg_double_1(double2 *retval , curandStateMRG32k3a ** state) {
    double2 local_retval = curand_box_muller_mrg_double(*state);
    memcpy(retval, &local_retval, sizeof(double2));
    return 0;
}


extern "C" __device__ int
curand_normal_1(float *retval , curandStateXORWOW ** state) {
    float local_retval = curand_normal(*state);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
curand_normal_2(float *retval , curandStatePhilox4_32_10 ** state) {
    float local_retval = curand_normal(*state);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
curand_normal_3(float *retval , curandStateMRG32k3a ** state) {
    float local_retval = curand_normal(*state);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
curand_normal2_1(float2 *retval , curandStateXORWOW ** state) {
    float2 local_retval = curand_normal2(*state);
    memcpy(retval, &local_retval, sizeof(float2));
    return 0;
}


extern "C" __device__ int
curand_normal2_2(float2 *retval , curandStatePhilox4_32_10 ** state) {
    float2 local_retval = curand_normal2(*state);
    memcpy(retval, &local_retval, sizeof(float2));
    return 0;
}


extern "C" __device__ int
curand_normal4_1(float4 *retval , curandStatePhilox4_32_10 ** state) {
    float4 local_retval = curand_normal4(*state);
    memcpy(retval, &local_retval, sizeof(float4));
    return 0;
}


extern "C" __device__ int
curand_normal2_3(float2 *retval , curandStateMRG32k3a ** state) {
    float2 local_retval = curand_normal2(*state);
    memcpy(retval, &local_retval, sizeof(float2));
    return 0;
}


extern "C" __device__ int
curand_normal_4(float *retval , curandStateMtgp32 ** state) {
    float local_retval = curand_normal(*state);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
curand_normal_5(float *retval , curandStateSobol32 ** state) {
    float local_retval = curand_normal(*state);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
curand_normal_6(float *retval , curandStateScrambledSobol32 ** state) {
    float local_retval = curand_normal(*state);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
curand_normal_7(float *retval , curandStateSobol64 ** state) {
    float local_retval = curand_normal(*state);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
curand_normal_8(float *retval , curandStateScrambledSobol64 ** state) {
    float local_retval = curand_normal(*state);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
curand_normal_double_1(double *retval , curandStateXORWOW ** state) {
    double local_retval = curand_normal_double(*state);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
curand_normal_double_2(double *retval , curandStatePhilox4_32_10 ** state) {
    double local_retval = curand_normal_double(*state);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
curand_normal_double_3(double *retval , curandStateMRG32k3a ** state) {
    double local_retval = curand_normal_double(*state);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
curand_normal2_double_1(double2 *retval , curandStateXORWOW ** state) {
    double2 local_retval = curand_normal2_double(*state);
    memcpy(retval, &local_retval, sizeof(double2));
    return 0;
}


extern "C" __device__ int
curand_normal2_double_2(double2 *retval , curandStatePhilox4_32_10 ** state) {
    double2 local_retval = curand_normal2_double(*state);
    memcpy(retval, &local_retval, sizeof(double2));
    return 0;
}


extern "C" __device__ int
curand_normal4_double_1(double4 *retval , curandStatePhilox4_32_10 ** state) {
    double4 local_retval = curand_normal4_double(*state);
    memcpy(retval, &local_retval, sizeof(double4));
    return 0;
}


extern "C" __device__ int
curand_normal2_double_3(double2 *retval , curandStateMRG32k3a ** state) {
    double2 local_retval = curand_normal2_double(*state);
    memcpy(retval, &local_retval, sizeof(double2));
    return 0;
}


extern "C" __device__ int
curand_normal_double_4(double *retval , curandStateMtgp32 ** state) {
    double local_retval = curand_normal_double(*state);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
curand_normal_double_5(double *retval , curandStateSobol32 ** state) {
    double local_retval = curand_normal_double(*state);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
curand_normal_double_6(double *retval , curandStateScrambledSobol32 ** state) {
    double local_retval = curand_normal_double(*state);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
curand_normal_double_7(double *retval , curandStateSobol64 ** state) {
    double local_retval = curand_normal_double(*state);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
curand_normal_double_8(double *retval , curandStateScrambledSobol64 ** state) {
    double local_retval = curand_normal_double(*state);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
curand_log_normal_1(float *retval , curandStateXORWOW ** state, float* mean, float* stddev) {
    float local_retval = curand_log_normal(*state, *mean, *stddev);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
curand_log_normal_2(float *retval , curandStatePhilox4_32_10 ** state, float* mean, float* stddev) {
    float local_retval = curand_log_normal(*state, *mean, *stddev);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
curand_log_normal2_1(float2 *retval , curandStateXORWOW ** state, float* mean, float* stddev) {
    float2 local_retval = curand_log_normal2(*state, *mean, *stddev);
    memcpy(retval, &local_retval, sizeof(float2));
    return 0;
}


extern "C" __device__ int
curand_log_normal2_2(float2 *retval , curandStatePhilox4_32_10 ** state, float* mean, float* stddev) {
    float2 local_retval = curand_log_normal2(*state, *mean, *stddev);
    memcpy(retval, &local_retval, sizeof(float2));
    return 0;
}


extern "C" __device__ int
curand_log_normal4_1(float4 *retval , curandStatePhilox4_32_10 ** state, float* mean, float* stddev) {
    float4 local_retval = curand_log_normal4(*state, *mean, *stddev);
    memcpy(retval, &local_retval, sizeof(float4));
    return 0;
}


extern "C" __device__ int
curand_log_normal_3(float *retval , curandStateMRG32k3a ** state, float* mean, float* stddev) {
    float local_retval = curand_log_normal(*state, *mean, *stddev);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
curand_log_normal2_3(float2 *retval , curandStateMRG32k3a ** state, float* mean, float* stddev) {
    float2 local_retval = curand_log_normal2(*state, *mean, *stddev);
    memcpy(retval, &local_retval, sizeof(float2));
    return 0;
}


extern "C" __device__ int
curand_log_normal_4(float *retval , curandStateMtgp32 ** state, float* mean, float* stddev) {
    float local_retval = curand_log_normal(*state, *mean, *stddev);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
curand_log_normal_5(float *retval , curandStateSobol32 ** state, float* mean, float* stddev) {
    float local_retval = curand_log_normal(*state, *mean, *stddev);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
curand_log_normal_6(float *retval , curandStateScrambledSobol32 ** state, float* mean, float* stddev) {
    float local_retval = curand_log_normal(*state, *mean, *stddev);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
curand_log_normal_7(float *retval , curandStateSobol64 ** state, float* mean, float* stddev) {
    float local_retval = curand_log_normal(*state, *mean, *stddev);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
curand_log_normal_8(float *retval , curandStateScrambledSobol64 ** state, float* mean, float* stddev) {
    float local_retval = curand_log_normal(*state, *mean, *stddev);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
curand_log_normal_double_1(double *retval , curandStateXORWOW ** state, double* mean, double* stddev) {
    double local_retval = curand_log_normal_double(*state, *mean, *stddev);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
curand_log_normal_double_2(double *retval , curandStatePhilox4_32_10 ** state, double* mean, double* stddev) {
    double local_retval = curand_log_normal_double(*state, *mean, *stddev);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
curand_log_normal2_double_1(double2 *retval , curandStateXORWOW ** state, double* mean, double* stddev) {
    double2 local_retval = curand_log_normal2_double(*state, *mean, *stddev);
    memcpy(retval, &local_retval, sizeof(double2));
    return 0;
}


extern "C" __device__ int
curand_log_normal2_double_2(double2 *retval , curandStatePhilox4_32_10 ** state, double* mean, double* stddev) {
    double2 local_retval = curand_log_normal2_double(*state, *mean, *stddev);
    memcpy(retval, &local_retval, sizeof(double2));
    return 0;
}


extern "C" __device__ int
curand_log_normal4_double_1(double4 *retval , curandStatePhilox4_32_10 ** state, double* mean, double* stddev) {
    double4 local_retval = curand_log_normal4_double(*state, *mean, *stddev);
    memcpy(retval, &local_retval, sizeof(double4));
    return 0;
}


extern "C" __device__ int
curand_log_normal_double_3(double *retval , curandStateMRG32k3a ** state, double* mean, double* stddev) {
    double local_retval = curand_log_normal_double(*state, *mean, *stddev);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
curand_log_normal2_double_3(double2 *retval , curandStateMRG32k3a ** state, double* mean, double* stddev) {
    double2 local_retval = curand_log_normal2_double(*state, *mean, *stddev);
    memcpy(retval, &local_retval, sizeof(double2));
    return 0;
}


extern "C" __device__ int
curand_log_normal_double_4(double *retval , curandStateMtgp32 ** state, double* mean, double* stddev) {
    double local_retval = curand_log_normal_double(*state, *mean, *stddev);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
curand_log_normal_double_5(double *retval , curandStateSobol32 ** state, double* mean, double* stddev) {
    double local_retval = curand_log_normal_double(*state, *mean, *stddev);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
curand_log_normal_double_6(double *retval , curandStateScrambledSobol32 ** state, double* mean, double* stddev) {
    double local_retval = curand_log_normal_double(*state, *mean, *stddev);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
curand_log_normal_double_7(double *retval , curandStateSobol64 ** state, double* mean, double* stddev) {
    double local_retval = curand_log_normal_double(*state, *mean, *stddev);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
curand_log_normal_double_8(double *retval , curandStateScrambledSobol64 ** state, double* mean, double* stddev) {
    double local_retval = curand_log_normal_double(*state, *mean, *stddev);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
__cr_rsqrt_1(float *retval , float* a) {
    float local_retval = __cr_rsqrt(*a);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
__cr_exp_1(float *retval , float* a) {
    float local_retval = __cr_exp(*a);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
__cr_log_1(float *retval , float* a) {
    float local_retval = __cr_log(*a);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
__cr_rcp_1(float *retval , float* a) {
    float local_retval = __cr_rcp(*a);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
__cr_pgammainc_1(float *retval , float* a, float* x) {
    float local_retval = __cr_pgammainc(*a, *x);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
__cr_pgammaincinv_1(float *retval , float* a, float* y) {
    float local_retval = __cr_pgammaincinv(*a, *y);
    memcpy(retval, &local_retval, sizeof(float));
    return 0;
}


extern "C" __device__ int
__cr_lgamma_integer_1(double *retval , int* a) {
    double local_retval = __cr_lgamma_integer(*a);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
_curand_uniform_double_excluding_one_1(double *retval , unsigned int* x) {
    double local_retval = _curand_uniform_double_excluding_one(*x);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
_curand_uniform_double_excluding_one_2(double *retval , unsigned long long* x) {
    double local_retval = _curand_uniform_double_excluding_one(*x);
    memcpy(retval, &local_retval, sizeof(double));
    return 0;
}


extern "C" __device__ int
curand_poisson_1(unsigned int *retval , curandStateXORWOW ** state, double* lambda) {
    unsigned int local_retval = curand_poisson(*state, *lambda);
    memcpy(retval, &local_retval, sizeof(unsigned int));
    return 0;
}


extern "C" __device__ int
curand_poisson_2(unsigned int *retval , curandStatePhilox4_32_10 ** state, double* lambda) {
    unsigned int local_retval = curand_poisson(*state, *lambda);
    memcpy(retval, &local_retval, sizeof(unsigned int));
    return 0;
}


extern "C" __device__ int
curand_poisson4_1(uint4 *retval , curandStatePhilox4_32_10 ** state, double* lambda) {
    uint4 local_retval = curand_poisson4(*state, *lambda);
    memcpy(retval, &local_retval, sizeof(uint4));
    return 0;
}


extern "C" __device__ int
curand_poisson_3(unsigned int *retval , curandStateMRG32k3a ** state, double* lambda) {
    unsigned int local_retval = curand_poisson(*state, *lambda);
    memcpy(retval, &local_retval, sizeof(unsigned int));
    return 0;
}


extern "C" __device__ int
curand_poisson_4(unsigned int *retval , curandStateMtgp32 ** state, double* lambda) {
    unsigned int local_retval = curand_poisson(*state, *lambda);
    memcpy(retval, &local_retval, sizeof(unsigned int));
    return 0;
}


extern "C" __device__ int
curand_poisson_5(unsigned int *retval , curandStateSobol32 ** state, double* lambda) {
    unsigned int local_retval = curand_poisson(*state, *lambda);
    memcpy(retval, &local_retval, sizeof(unsigned int));
    return 0;
}


extern "C" __device__ int
curand_poisson_6(unsigned int *retval , curandStateScrambledSobol32 ** state, double* lambda) {
    unsigned int local_retval = curand_poisson(*state, *lambda);
    memcpy(retval, &local_retval, sizeof(unsigned int));
    return 0;
}


extern "C" __device__ int
curand_poisson_7(unsigned int *retval , curandStateSobol64 ** state, double* lambda) {
    unsigned int local_retval = curand_poisson(*state, *lambda);
    memcpy(retval, &local_retval, sizeof(unsigned int));
    return 0;
}


extern "C" __device__ int
curand_poisson_8(unsigned int *retval , curandStateScrambledSobol64 ** state, double* lambda) {
    unsigned int local_retval = curand_poisson(*state, *lambda);
    memcpy(retval, &local_retval, sizeof(unsigned int));
    return 0;
}


extern "C" __device__ int
curand_discrete_1(unsigned int *retval , curandStateXORWOW ** state, curandDiscreteDistribution_st ** discrete_distribution) {
    unsigned int local_retval = curand_discrete(*state, *discrete_distribution);
    memcpy(retval, &local_retval, sizeof(unsigned int));
    return 0;
}


extern "C" __device__ int
curand_discrete_2(unsigned int *retval , curandStatePhilox4_32_10 ** state, curandDiscreteDistribution_st ** discrete_distribution) {
    unsigned int local_retval = curand_discrete(*state, *discrete_distribution);
    memcpy(retval, &local_retval, sizeof(unsigned int));
    return 0;
}


extern "C" __device__ int
curand_discrete4_1(uint4 *retval , curandStatePhilox4_32_10 ** state, curandDiscreteDistribution_st ** discrete_distribution) {
    uint4 local_retval = curand_discrete4(*state, *discrete_distribution);
    memcpy(retval, &local_retval, sizeof(uint4));
    return 0;
}


extern "C" __device__ int
curand_discrete_3(unsigned int *retval , curandStateMRG32k3a ** state, curandDiscreteDistribution_st ** discrete_distribution) {
    unsigned int local_retval = curand_discrete(*state, *discrete_distribution);
    memcpy(retval, &local_retval, sizeof(unsigned int));
    return 0;
}


extern "C" __device__ int
curand_discrete_4(unsigned int *retval , curandStateMtgp32 ** state, curandDiscreteDistribution_st ** discrete_distribution) {
    unsigned int local_retval = curand_discrete(*state, *discrete_distribution);
    memcpy(retval, &local_retval, sizeof(unsigned int));
    return 0;
}


extern "C" __device__ int
curand_discrete_5(unsigned int *retval , curandStateSobol32 ** state, curandDiscreteDistribution_st ** discrete_distribution) {
    unsigned int local_retval = curand_discrete(*state, *discrete_distribution);
    memcpy(retval, &local_retval, sizeof(unsigned int));
    return 0;
}


extern "C" __device__ int
curand_discrete_6(unsigned int *retval , curandStateScrambledSobol32 ** state, curandDiscreteDistribution_st ** discrete_distribution) {
    unsigned int local_retval = curand_discrete(*state, *discrete_distribution);
    memcpy(retval, &local_retval, sizeof(unsigned int));
    return 0;
}


extern "C" __device__ int
curand_discrete_7(unsigned int *retval , curandStateSobol64 ** state, curandDiscreteDistribution_st ** discrete_distribution) {
    unsigned int local_retval = curand_discrete(*state, *discrete_distribution);
    memcpy(retval, &local_retval, sizeof(unsigned int));
    return 0;
}


extern "C" __device__ int
curand_discrete_8(unsigned int *retval , curandStateScrambledSobol64 ** state, curandDiscreteDistribution_st ** discrete_distribution) {
    unsigned int local_retval = curand_discrete(*state, *discrete_distribution);
    memcpy(retval, &local_retval, sizeof(unsigned int));
    return 0;
}


extern "C" __device__ int
__get_precalculated_matrix_1(unsigned int * *retval , int* n) {
    unsigned int * local_retval = __get_precalculated_matrix(*n);
    memcpy(retval, &local_retval, sizeof(unsigned int *));
    return 0;
}


extern "C" __device__ int
__get_mrg32k3a_matrix_1(unsigned int * *retval , int* n) {
    unsigned int * local_retval = __get_mrg32k3a_matrix(*n);
    memcpy(retval, &local_retval, sizeof(unsigned int *));
    return 0;
}
    """ % curand_kernel_header)
