# Copyright (c) 2024-2025, NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
#
# SPDX-License-Identifier: Apache-2.0

import _cython_3_1_2
import enum
from typing import Any, Callable, ClassVar

__pyx_capi__: dict
__test__: dict
axpby: _cython_3_1_2.cython_function_or_method
blocked_ell_get: _cython_3_1_2.cython_function_or_method
bsr_set_strided_batch: _cython_3_1_2.cython_function_or_method
cbsr2csr: _cython_3_1_2.cython_function_or_method
cbsrmm: _cython_3_1_2.cython_function_or_method
cbsrmv: _cython_3_1_2.cython_function_or_method
ccsr2gebsr: _cython_3_1_2.cython_function_or_method
ccsr2gebsr_buffer_size: _cython_3_1_2.cython_function_or_method
ccsr2gebsr_buffer_size_ext: _cython_3_1_2.cython_function_or_method
ccsrgeam2: _cython_3_1_2.cython_function_or_method
ccsrgeam2_buffer_size_ext: _cython_3_1_2.cython_function_or_method
cgebsr2gebsc: _cython_3_1_2.cython_function_or_method
cgebsr2gebsc_buffer_size: _cython_3_1_2.cython_function_or_method
cgebsr2gebsc_buffer_size_ext: _cython_3_1_2.cython_function_or_method
cgebsr2gebsr: _cython_3_1_2.cython_function_or_method
cgebsr2gebsr_buffer_size: _cython_3_1_2.cython_function_or_method
cgebsr2gebsr_buffer_size_ext: _cython_3_1_2.cython_function_or_method
cgemvi: _cython_3_1_2.cython_function_or_method
cgemvi_buffer_size: _cython_3_1_2.cython_function_or_method
cgpsv_interleaved_batch: _cython_3_1_2.cython_function_or_method
cgpsv_interleaved_batch_buffer_size_ext: _cython_3_1_2.cython_function_or_method
cgtsv2: _cython_3_1_2.cython_function_or_method
cgtsv2_buffer_size_ext: _cython_3_1_2.cython_function_or_method
cgtsv2_nopivot: _cython_3_1_2.cython_function_or_method
cgtsv2_nopivot_buffer_size_ext: _cython_3_1_2.cython_function_or_method
cgtsv2strided_batch: _cython_3_1_2.cython_function_or_method
cgtsv2strided_batch_buffer_size_ext: _cython_3_1_2.cython_function_or_method
cgtsv_interleaved_batch: _cython_3_1_2.cython_function_or_method
cgtsv_interleaved_batch_buffer_size_ext: _cython_3_1_2.cython_function_or_method
check_status: _cython_3_1_2.cython_function_or_method
cnnz: _cython_3_1_2.cython_function_or_method
const_blocked_ell_get: _cython_3_1_2.cython_function_or_method
const_coo_get: _cython_3_1_2.cython_function_or_method
const_csc_get: _cython_3_1_2.cython_function_or_method
const_csr_get: _cython_3_1_2.cython_function_or_method
const_dn_mat_get: _cython_3_1_2.cython_function_or_method
const_dn_mat_get_values: _cython_3_1_2.cython_function_or_method
const_dn_vec_get: _cython_3_1_2.cython_function_or_method
const_dn_vec_get_values: _cython_3_1_2.cython_function_or_method
const_sp_mat_get_values: _cython_3_1_2.cython_function_or_method
const_sp_vec_get: _cython_3_1_2.cython_function_or_method
const_sp_vec_get_values: _cython_3_1_2.cython_function_or_method
coo_get: _cython_3_1_2.cython_function_or_method
coo_set_pointers: _cython_3_1_2.cython_function_or_method
coo_set_strided_batch: _cython_3_1_2.cython_function_or_method
create: _cython_3_1_2.cython_function_or_method
create_blocked_ell: _cython_3_1_2.cython_function_or_method
create_bsr: _cython_3_1_2.cython_function_or_method
create_const_blocked_ell: _cython_3_1_2.cython_function_or_method
create_const_bsr: _cython_3_1_2.cython_function_or_method
create_const_coo: _cython_3_1_2.cython_function_or_method
create_const_csc: _cython_3_1_2.cython_function_or_method
create_const_csr: _cython_3_1_2.cython_function_or_method
create_const_dn_mat: _cython_3_1_2.cython_function_or_method
create_const_dn_vec: _cython_3_1_2.cython_function_or_method
create_const_sliced_ell: _cython_3_1_2.cython_function_or_method
create_const_sp_vec: _cython_3_1_2.cython_function_or_method
create_coo: _cython_3_1_2.cython_function_or_method
create_csc: _cython_3_1_2.cython_function_or_method
create_csr: _cython_3_1_2.cython_function_or_method
create_dn_mat: _cython_3_1_2.cython_function_or_method
create_dn_vec: _cython_3_1_2.cython_function_or_method
create_mat_descr: _cython_3_1_2.cython_function_or_method
create_sliced_ell: _cython_3_1_2.cython_function_or_method
create_sp_vec: _cython_3_1_2.cython_function_or_method
csc_get: _cython_3_1_2.cython_function_or_method
csc_set_pointers: _cython_3_1_2.cython_function_or_method
csr2csc_ex2: _cython_3_1_2.cython_function_or_method
csr2csc_ex2_buffer_size: _cython_3_1_2.cython_function_or_method
csr_get: _cython_3_1_2.cython_function_or_method
csr_set_pointers: _cython_3_1_2.cython_function_or_method
csr_set_strided_batch: _cython_3_1_2.cython_function_or_method
dbsr2csr: _cython_3_1_2.cython_function_or_method
dbsrmm: _cython_3_1_2.cython_function_or_method
dbsrmv: _cython_3_1_2.cython_function_or_method
dcsr2gebsr: _cython_3_1_2.cython_function_or_method
dcsr2gebsr_buffer_size: _cython_3_1_2.cython_function_or_method
dcsr2gebsr_buffer_size_ext: _cython_3_1_2.cython_function_or_method
dcsrgeam2: _cython_3_1_2.cython_function_or_method
dcsrgeam2_buffer_size_ext: _cython_3_1_2.cython_function_or_method
dense_to_sparse_analysis: _cython_3_1_2.cython_function_or_method
dense_to_sparse_buffer_size: _cython_3_1_2.cython_function_or_method
dense_to_sparse_convert: _cython_3_1_2.cython_function_or_method
destroy: _cython_3_1_2.cython_function_or_method
destroy_dn_mat: _cython_3_1_2.cython_function_or_method
destroy_dn_vec: _cython_3_1_2.cython_function_or_method
destroy_mat_descr: _cython_3_1_2.cython_function_or_method
destroy_sp_mat: _cython_3_1_2.cython_function_or_method
destroy_sp_vec: _cython_3_1_2.cython_function_or_method
dgebsr2gebsc: _cython_3_1_2.cython_function_or_method
dgebsr2gebsc_buffer_size: _cython_3_1_2.cython_function_or_method
dgebsr2gebsc_buffer_size_ext: _cython_3_1_2.cython_function_or_method
dgebsr2gebsr: _cython_3_1_2.cython_function_or_method
dgebsr2gebsr_buffer_size: _cython_3_1_2.cython_function_or_method
dgebsr2gebsr_buffer_size_ext: _cython_3_1_2.cython_function_or_method
dgemvi: _cython_3_1_2.cython_function_or_method
dgemvi_buffer_size: _cython_3_1_2.cython_function_or_method
dgpsv_interleaved_batch: _cython_3_1_2.cython_function_or_method
dgpsv_interleaved_batch_buffer_size_ext: _cython_3_1_2.cython_function_or_method
dgtsv2: _cython_3_1_2.cython_function_or_method
dgtsv2_buffer_size_ext: _cython_3_1_2.cython_function_or_method
dgtsv2_nopivot: _cython_3_1_2.cython_function_or_method
dgtsv2_nopivot_buffer_size_ext: _cython_3_1_2.cython_function_or_method
dgtsv2strided_batch: _cython_3_1_2.cython_function_or_method
dgtsv2strided_batch_buffer_size_ext: _cython_3_1_2.cython_function_or_method
dgtsv_interleaved_batch: _cython_3_1_2.cython_function_or_method
dgtsv_interleaved_batch_buffer_size_ext: _cython_3_1_2.cython_function_or_method
dn_mat_get: _cython_3_1_2.cython_function_or_method
dn_mat_get_strided_batch: _cython_3_1_2.cython_function_or_method
dn_mat_get_values: _cython_3_1_2.cython_function_or_method
dn_mat_set_strided_batch: _cython_3_1_2.cython_function_or_method
dn_mat_set_values: _cython_3_1_2.cython_function_or_method
dn_vec_get: _cython_3_1_2.cython_function_or_method
dn_vec_get_values: _cython_3_1_2.cython_function_or_method
dn_vec_set_values: _cython_3_1_2.cython_function_or_method
dnnz: _cython_3_1_2.cython_function_or_method
gather: _cython_3_1_2.cython_function_or_method
get_error_name: _cython_3_1_2.cython_function_or_method
get_error_string: _cython_3_1_2.cython_function_or_method
get_mat_diag_type: _cython_3_1_2.cython_function_or_method
get_mat_fill_mode: _cython_3_1_2.cython_function_or_method
get_mat_index_base: _cython_3_1_2.cython_function_or_method
get_mat_type: _cython_3_1_2.cython_function_or_method
get_pointer_mode: _cython_3_1_2.cython_function_or_method
get_property: _cython_3_1_2.cython_function_or_method
get_sp_mat_attribute_dtype: _cython_3_1_2.cython_function_or_method
get_stream: _cython_3_1_2.cython_function_or_method
get_version: _cython_3_1_2.cython_function_or_method
logger_force_disable: _cython_3_1_2.cython_function_or_method
logger_open_file: _cython_3_1_2.cython_function_or_method
logger_set_level: _cython_3_1_2.cython_function_or_method
logger_set_mask: _cython_3_1_2.cython_function_or_method
sbsr2csr: _cython_3_1_2.cython_function_or_method
sbsrmm: _cython_3_1_2.cython_function_or_method
sbsrmv: _cython_3_1_2.cython_function_or_method
scatter: _cython_3_1_2.cython_function_or_method
scsr2gebsr: _cython_3_1_2.cython_function_or_method
scsr2gebsr_buffer_size: _cython_3_1_2.cython_function_or_method
scsr2gebsr_buffer_size_ext: _cython_3_1_2.cython_function_or_method
scsrgeam2: _cython_3_1_2.cython_function_or_method
scsrgeam2_buffer_size_ext: _cython_3_1_2.cython_function_or_method
sddmm: _cython_3_1_2.cython_function_or_method
sddmm_buffer_size: _cython_3_1_2.cython_function_or_method
sddmm_preprocess: _cython_3_1_2.cython_function_or_method
set_mat_diag_type: _cython_3_1_2.cython_function_or_method
set_mat_fill_mode: _cython_3_1_2.cython_function_or_method
set_mat_index_base: _cython_3_1_2.cython_function_or_method
set_mat_type: _cython_3_1_2.cython_function_or_method
set_pointer_mode: _cython_3_1_2.cython_function_or_method
set_stream: _cython_3_1_2.cython_function_or_method
sgebsr2gebsc: _cython_3_1_2.cython_function_or_method
sgebsr2gebsc_buffer_size: _cython_3_1_2.cython_function_or_method
sgebsr2gebsc_buffer_size_ext: _cython_3_1_2.cython_function_or_method
sgebsr2gebsr: _cython_3_1_2.cython_function_or_method
sgebsr2gebsr_buffer_size: _cython_3_1_2.cython_function_or_method
sgebsr2gebsr_buffer_size_ext: _cython_3_1_2.cython_function_or_method
sgemvi: _cython_3_1_2.cython_function_or_method
sgemvi_buffer_size: _cython_3_1_2.cython_function_or_method
sgpsv_interleaved_batch: _cython_3_1_2.cython_function_or_method
sgpsv_interleaved_batch_buffer_size_ext: _cython_3_1_2.cython_function_or_method
sgtsv2: _cython_3_1_2.cython_function_or_method
sgtsv2_buffer_size_ext: _cython_3_1_2.cython_function_or_method
sgtsv2_nopivot: _cython_3_1_2.cython_function_or_method
sgtsv2_nopivot_buffer_size_ext: _cython_3_1_2.cython_function_or_method
sgtsv2strided_batch: _cython_3_1_2.cython_function_or_method
sgtsv2strided_batch_buffer_size_ext: _cython_3_1_2.cython_function_or_method
sgtsv_interleaved_batch: _cython_3_1_2.cython_function_or_method
sgtsv_interleaved_batch_buffer_size_ext: _cython_3_1_2.cython_function_or_method
snnz: _cython_3_1_2.cython_function_or_method
sp_gemm_compute: _cython_3_1_2.cython_function_or_method
sp_gemm_copy: _cython_3_1_2.cython_function_or_method
sp_gemm_create_descr: _cython_3_1_2.cython_function_or_method
sp_gemm_destroy_descr: _cython_3_1_2.cython_function_or_method
sp_gemm_get_num_products: _cython_3_1_2.cython_function_or_method
sp_gemm_reuse_compute: _cython_3_1_2.cython_function_or_method
sp_gemm_reuse_copy: _cython_3_1_2.cython_function_or_method
sp_gemm_reuse_nnz: _cython_3_1_2.cython_function_or_method
sp_gemm_reuse_work_estimation: _cython_3_1_2.cython_function_or_method
sp_gemm_work_estimation: _cython_3_1_2.cython_function_or_method
sp_mat_get_attribute: _cython_3_1_2.cython_function_or_method
sp_mat_get_format: _cython_3_1_2.cython_function_or_method
sp_mat_get_index_base: _cython_3_1_2.cython_function_or_method
sp_mat_get_size: _cython_3_1_2.cython_function_or_method
sp_mat_get_strided_batch: _cython_3_1_2.cython_function_or_method
sp_mat_get_values: _cython_3_1_2.cython_function_or_method
sp_mat_set_attribute: _cython_3_1_2.cython_function_or_method
sp_mat_set_values: _cython_3_1_2.cython_function_or_method
sp_mm: _cython_3_1_2.cython_function_or_method
sp_mm_buffer_size: _cython_3_1_2.cython_function_or_method
sp_mm_op: _cython_3_1_2.cython_function_or_method
sp_mm_op_create_plan: _cython_3_1_2.cython_function_or_method
sp_mm_op_destroy_plan: _cython_3_1_2.cython_function_or_method
sp_mm_preprocess: _cython_3_1_2.cython_function_or_method
sp_mv: _cython_3_1_2.cython_function_or_method
sp_mv_buffer_size: _cython_3_1_2.cython_function_or_method
sp_mv_preprocess: _cython_3_1_2.cython_function_or_method
sp_sm_analysis: _cython_3_1_2.cython_function_or_method
sp_sm_buffer_size: _cython_3_1_2.cython_function_or_method
sp_sm_create_descr: _cython_3_1_2.cython_function_or_method
sp_sm_destroy_descr: _cython_3_1_2.cython_function_or_method
sp_sm_solve: _cython_3_1_2.cython_function_or_method
sp_sm_update_matrix: _cython_3_1_2.cython_function_or_method
sp_sv_analysis: _cython_3_1_2.cython_function_or_method
sp_sv_buffer_size: _cython_3_1_2.cython_function_or_method
sp_sv_create_descr: _cython_3_1_2.cython_function_or_method
sp_sv_destroy_descr: _cython_3_1_2.cython_function_or_method
sp_sv_solve: _cython_3_1_2.cython_function_or_method
sp_sv_update_matrix: _cython_3_1_2.cython_function_or_method
sp_vec_get: _cython_3_1_2.cython_function_or_method
sp_vec_get_index_base: _cython_3_1_2.cython_function_or_method
sp_vec_get_values: _cython_3_1_2.cython_function_or_method
sp_vec_set_values: _cython_3_1_2.cython_function_or_method
sp_vv: _cython_3_1_2.cython_function_or_method
sp_vv_buffer_size: _cython_3_1_2.cython_function_or_method
sparse_to_dense: _cython_3_1_2.cython_function_or_method
sparse_to_dense_buffer_size: _cython_3_1_2.cython_function_or_method
xcoo2csr: _cython_3_1_2.cython_function_or_method
xcoosort_buffer_size_ext: _cython_3_1_2.cython_function_or_method
xcoosort_by_column: _cython_3_1_2.cython_function_or_method
xcoosort_by_row: _cython_3_1_2.cython_function_or_method
xcscsort: _cython_3_1_2.cython_function_or_method
xcscsort_buffer_size_ext: _cython_3_1_2.cython_function_or_method
xcsr2coo: _cython_3_1_2.cython_function_or_method
xcsr2gebsr_nnz: _cython_3_1_2.cython_function_or_method
xcsrgeam2nnz: _cython_3_1_2.cython_function_or_method
xcsrsort: _cython_3_1_2.cython_function_or_method
xcsrsort_buffer_size_ext: _cython_3_1_2.cython_function_or_method
xgebsr2gebsr_nnz: _cython_3_1_2.cython_function_or_method
zbsr2csr: _cython_3_1_2.cython_function_or_method
zbsrmm: _cython_3_1_2.cython_function_or_method
zbsrmv: _cython_3_1_2.cython_function_or_method
zcsr2gebsr: _cython_3_1_2.cython_function_or_method
zcsr2gebsr_buffer_size: _cython_3_1_2.cython_function_or_method
zcsr2gebsr_buffer_size_ext: _cython_3_1_2.cython_function_or_method
zcsrgeam2: _cython_3_1_2.cython_function_or_method
zcsrgeam2_buffer_size_ext: _cython_3_1_2.cython_function_or_method
zgebsr2gebsc: _cython_3_1_2.cython_function_or_method
zgebsr2gebsc_buffer_size: _cython_3_1_2.cython_function_or_method
zgebsr2gebsc_buffer_size_ext: _cython_3_1_2.cython_function_or_method
zgebsr2gebsr: _cython_3_1_2.cython_function_or_method
zgebsr2gebsr_buffer_size: _cython_3_1_2.cython_function_or_method
zgebsr2gebsr_buffer_size_ext: _cython_3_1_2.cython_function_or_method
zgemvi: _cython_3_1_2.cython_function_or_method
zgemvi_buffer_size: _cython_3_1_2.cython_function_or_method
zgpsv_interleaved_batch: _cython_3_1_2.cython_function_or_method
zgpsv_interleaved_batch_buffer_size_ext: _cython_3_1_2.cython_function_or_method
zgtsv2: _cython_3_1_2.cython_function_or_method
zgtsv2_buffer_size_ext: _cython_3_1_2.cython_function_or_method
zgtsv2_nopivot: _cython_3_1_2.cython_function_or_method
zgtsv2_nopivot_buffer_size_ext: _cython_3_1_2.cython_function_or_method
zgtsv2strided_batch: _cython_3_1_2.cython_function_or_method
zgtsv2strided_batch_buffer_size_ext: _cython_3_1_2.cython_function_or_method
zgtsv_interleaved_batch: _cython_3_1_2.cython_function_or_method
zgtsv_interleaved_batch_buffer_size_ext: _cython_3_1_2.cython_function_or_method
znnz: _cython_3_1_2.cython_function_or_method

class Action(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    NUMERIC: ClassVar[Action] = ...
    SYMBOLIC: ClassVar[Action] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class ColorAlg(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    COLOR_ALG0: ClassVar[ColorAlg] = ...
    COLOR_ALG1: ClassVar[ColorAlg] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class Csr2CscAlg(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    ALG1: ClassVar[Csr2CscAlg] = ...
    ALG2: ClassVar[Csr2CscAlg] = ...
    DEFAULT: ClassVar[Csr2CscAlg] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class DenseToSparseAlg(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    DEFAULT: ClassVar[DenseToSparseAlg] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class DiagType(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    NON_UNIT: ClassVar[DiagType] = ...
    UNIT: ClassVar[DiagType] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class Direction(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    COLUMN: ClassVar[Direction] = ...
    ROW: ClassVar[Direction] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class FillMode(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    LOWER: ClassVar[FillMode] = ...
    UPPER: ClassVar[FillMode] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class Format(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    BLOCKED_ELL: ClassVar[Format] = ...
    BSR: ClassVar[Format] = ...
    COO: ClassVar[Format] = ...
    COO_AOS: ClassVar[Format] = ...
    CSC: ClassVar[Format] = ...
    CSR: ClassVar[Format] = ...
    SLICED_ELLPACK: ClassVar[Format] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class IndexBase(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    ONE: ClassVar[IndexBase] = ...
    ZERO: ClassVar[IndexBase] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class IndexType(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    INDEX_16U: ClassVar[IndexType] = ...
    INDEX_32I: ClassVar[IndexType] = ...
    INDEX_64I: ClassVar[IndexType] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class MatrixType(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    GENERAL: ClassVar[MatrixType] = ...
    HERMITIAN: ClassVar[MatrixType] = ...
    SYMMETRIC: ClassVar[MatrixType] = ...
    TRIANGULAR: ClassVar[MatrixType] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class Operation(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    CONJUGATE_TRANSPOSE: ClassVar[Operation] = ...
    NON_TRANSPOSE: ClassVar[Operation] = ...
    TRANSPOSE: ClassVar[Operation] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class Order(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    COL: ClassVar[Order] = ...
    ROW: ClassVar[Order] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class PointerMode(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    DEVICE: ClassVar[PointerMode] = ...
    HOST: ClassVar[PointerMode] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class SDDMMAlg(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    DEFAULT: ClassVar[SDDMMAlg] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class SolvePolicy(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    NO_LEVEL: ClassVar[SolvePolicy] = ...
    USE_LEVEL: ClassVar[SolvePolicy] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class SpGEMMAlg(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    ALG1: ClassVar[SpGEMMAlg] = ...
    ALG2: ClassVar[SpGEMMAlg] = ...
    ALG3: ClassVar[SpGEMMAlg] = ...
    CSR_ALG_DETERMINITIC: ClassVar[SpGEMMAlg] = ...
    CSR_ALG_NONDETERMINITIC: ClassVar[SpGEMMAlg] = ...
    DEFAULT: ClassVar[SpGEMMAlg] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class SpMMAlg(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    BLOCKED_ELL_ALG1: ClassVar[SpMMAlg] = ...
    BSR_ALG1: ClassVar[SpMMAlg] = ...
    COOMM_ALG1: ClassVar[SpMMAlg] = ...
    COOMM_ALG2: ClassVar[SpMMAlg] = ...
    COOMM_ALG3: ClassVar[SpMMAlg] = ...
    COO_ALG1: ClassVar[SpMMAlg] = ...
    COO_ALG2: ClassVar[SpMMAlg] = ...
    COO_ALG3: ClassVar[SpMMAlg] = ...
    COO_ALG4: ClassVar[SpMMAlg] = ...
    CSRMM_ALG1: ClassVar[SpMMAlg] = ...
    CSR_ALG1: ClassVar[SpMMAlg] = ...
    CSR_ALG2: ClassVar[SpMMAlg] = ...
    CSR_ALG3: ClassVar[SpMMAlg] = ...
    DEFAULT: ClassVar[SpMMAlg] = ...
    MM_ALG_DEFAULT: ClassVar[SpMMAlg] = ...
    SPMMA_ALG1: ClassVar[SpMMAlg] = ...
    SPMMA_ALG2: ClassVar[SpMMAlg] = ...
    SPMMA_ALG3: ClassVar[SpMMAlg] = ...
    SPMMA_ALG4: ClassVar[SpMMAlg] = ...
    SPMMA_PREPROCESS: ClassVar[SpMMAlg] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class SpMMOpAlg(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    DEFAULT: ClassVar[SpMMOpAlg] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class SpMVAlg(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    COOMV_ALG: ClassVar[SpMVAlg] = ...
    COO_ALG1: ClassVar[SpMVAlg] = ...
    COO_ALG2: ClassVar[SpMVAlg] = ...
    CSRMV_ALG1: ClassVar[SpMVAlg] = ...
    CSRMV_ALG2: ClassVar[SpMVAlg] = ...
    CSR_ALG1: ClassVar[SpMVAlg] = ...
    CSR_ALG2: ClassVar[SpMVAlg] = ...
    DEFAULT: ClassVar[SpMVAlg] = ...
    MV_ALG_DEFAULT: ClassVar[SpMVAlg] = ...
    SELL_ALG1: ClassVar[SpMVAlg] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class SpMatAttribute(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    DIAG_TYPE: ClassVar[SpMatAttribute] = ...
    FILL_MODE: ClassVar[SpMatAttribute] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class SpSMAlg(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    DEFAULT: ClassVar[SpSMAlg] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class SpSMUpdate(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    UPDATE_DIAGONAL: ClassVar[SpSMUpdate] = ...
    UPDATE_GENERAL: ClassVar[SpSMUpdate] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class SpSVAlg(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    DEFAULT: ClassVar[SpSVAlg] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class SpSVUpdate(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    DIAGONAL: ClassVar[SpSVUpdate] = ...
    GENERAL: ClassVar[SpSVUpdate] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class SparseToDenseAlg(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    DEFAULT: ClassVar[SparseToDenseAlg] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class Status(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    ALLOC_FAILED: ClassVar[Status] = ...
    ARCH_MISMATCH: ClassVar[Status] = ...
    EXECUTION_FAILED: ClassVar[Status] = ...
    INSUFFICIENT_RESOURCES: ClassVar[Status] = ...
    INTERNAL_ERROR: ClassVar[Status] = ...
    INVALID_VALUE: ClassVar[Status] = ...
    MAPPING_ERROR: ClassVar[Status] = ...
    MATRIX_TYPE_NOT_SUPPORTED: ClassVar[Status] = ...
    NOT_INITIALIZED: ClassVar[Status] = ...
    NOT_SUPPORTED: ClassVar[Status] = ...
    SUCCESS: ClassVar[Status] = ...
    ZERO_PIVOT: ClassVar[Status] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class cuSPARSEError(Exception):
    def __init__(self, status) -> Any: ...
    def __reduce__(self) -> Any: ...
