# Copyright (c) 2024-2025, NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
#
# SPDX-License-Identifier: Apache-2.0

import _cython_3_1_4
import enum
from typing import Callable, ClassVar

__pyx_capi__: dict
__test__: dict
cgemm: _cython_3_1_4.cython_function_or_method
cgemm_batch: _cython_3_1_4.cython_function_or_method
cgemm_batch_strided: _cython_3_1_4.cython_function_or_method
chemm: _cython_3_1_4.cython_function_or_method
chemm_batch_strided: _cython_3_1_4.cython_function_or_method
cher2k: _cython_3_1_4.cython_function_or_method
cherk: _cython_3_1_4.cython_function_or_method
csymm: _cython_3_1_4.cython_function_or_method
csymm_batch_strided: _cython_3_1_4.cython_function_or_method
csyr2k: _cython_3_1_4.cython_function_or_method
csyrk: _cython_3_1_4.cython_function_or_method
ctrmm: _cython_3_1_4.cython_function_or_method
ctrmm_batch_strided: _cython_3_1_4.cython_function_or_method
ctrsm: _cython_3_1_4.cython_function_or_method
dgemm: _cython_3_1_4.cython_function_or_method
dgemm_batch: _cython_3_1_4.cython_function_or_method
dgemm_batch_strided: _cython_3_1_4.cython_function_or_method
dsymm: _cython_3_1_4.cython_function_or_method
dsymm_batch_strided: _cython_3_1_4.cython_function_or_method
dsyr2k: _cython_3_1_4.cython_function_or_method
dsyrk: _cython_3_1_4.cython_function_or_method
dtrmm: _cython_3_1_4.cython_function_or_method
dtrmm_batch_strided: _cython_3_1_4.cython_function_or_method
dtrsm: _cython_3_1_4.cython_function_or_method
get_max_threads: _cython_3_1_4.cython_function_or_method
get_version: _cython_3_1_4.cython_function_or_method
mkl_set_num_threads: _cython_3_1_4.cython_function_or_method
mkl_set_num_threads_local: _cython_3_1_4.cython_function_or_method
openblas_set_num_threads: _cython_3_1_4.cython_function_or_method
openblas_set_num_threads_local: _cython_3_1_4.cython_function_or_method
set_num_threads: _cython_3_1_4.cython_function_or_method
set_num_threads_local: _cython_3_1_4.cython_function_or_method
sgemm: _cython_3_1_4.cython_function_or_method
sgemm_batch: _cython_3_1_4.cython_function_or_method
sgemm_batch_strided: _cython_3_1_4.cython_function_or_method
ssymm: _cython_3_1_4.cython_function_or_method
ssymm_batch_strided: _cython_3_1_4.cython_function_or_method
ssyr2k: _cython_3_1_4.cython_function_or_method
ssyrk: _cython_3_1_4.cython_function_or_method
strmm: _cython_3_1_4.cython_function_or_method
strmm_batch_strided: _cython_3_1_4.cython_function_or_method
strsm: _cython_3_1_4.cython_function_or_method
zgemm: _cython_3_1_4.cython_function_or_method
zgemm_batch: _cython_3_1_4.cython_function_or_method
zgemm_batch_strided: _cython_3_1_4.cython_function_or_method
zhemm: _cython_3_1_4.cython_function_or_method
zhemm_batch_strided: _cython_3_1_4.cython_function_or_method
zher2k: _cython_3_1_4.cython_function_or_method
zherk: _cython_3_1_4.cython_function_or_method
zsymm: _cython_3_1_4.cython_function_or_method
zsymm_batch_strided: _cython_3_1_4.cython_function_or_method
zsyr2k: _cython_3_1_4.cython_function_or_method
zsyrk: _cython_3_1_4.cython_function_or_method
ztrmm: _cython_3_1_4.cython_function_or_method
ztrmm_batch_strided: _cython_3_1_4.cython_function_or_method
ztrsm: _cython_3_1_4.cython_function_or_method

class DIAG(enum.IntEnum):
    """See `CBLAS_DIAG`."""
    __new__: ClassVar[Callable] = ...
    NonUnit: ClassVar[DIAG] = ...
    Unit: ClassVar[DIAG] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class ORDER(enum.IntEnum):
    """See `CBLAS_ORDER`."""
    __new__: ClassVar[Callable] = ...
    ColMajor: ClassVar[ORDER] = ...
    RowMajor: ClassVar[ORDER] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class SIDE(enum.IntEnum):
    """See `CBLAS_SIDE`."""
    __new__: ClassVar[Callable] = ...
    Left: ClassVar[SIDE] = ...
    Right: ClassVar[SIDE] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class TRANSPOSE(enum.IntEnum):
    """See `CBLAS_TRANSPOSE`."""
    __new__: ClassVar[Callable] = ...
    ConjTrans: ClassVar[TRANSPOSE] = ...
    NoTrans: ClassVar[TRANSPOSE] = ...
    Trans: ClassVar[TRANSPOSE] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class UPLO(enum.IntEnum):
    """See `CBLAS_UPLO`."""
    __new__: ClassVar[Callable] = ...
    Lower: ClassVar[UPLO] = ...
    Upper: ClassVar[UPLO] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...
