# Copyright (c) 2024-2025, NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
#
# SPDX-License-Identifier: Apache-2.0

import _cython_3_1_4
import enum
from typing import Any, Callable, ClassVar

__pyx_capi__: dict
__test__: dict
check_status: _cython_3_1_4.cython_function_or_method
config_create: _cython_3_1_4.cython_function_or_method
config_destroy: _cython_3_1_4.cython_function_or_method
config_get: _cython_3_1_4.cython_function_or_method
config_set: _cython_3_1_4.cython_function_or_method
create: _cython_3_1_4.cython_function_or_method
create_mg: _cython_3_1_4.cython_function_or_method
data_create: _cython_3_1_4.cython_function_or_method
data_destroy: _cython_3_1_4.cython_function_or_method
data_get: _cython_3_1_4.cython_function_or_method
data_set: _cython_3_1_4.cython_function_or_method
destroy: _cython_3_1_4.cython_function_or_method
execute: _cython_3_1_4.cython_function_or_method
get_config_param_dtype: _cython_3_1_4.cython_function_or_method
get_data_param_dtype: _cython_3_1_4.cython_function_or_method
get_device_mem_handler: _cython_3_1_4.cython_function_or_method
get_property: _cython_3_1_4.cython_function_or_method
matrix_create_batch_csr: _cython_3_1_4.cython_function_or_method
matrix_create_batch_dn: _cython_3_1_4.cython_function_or_method
matrix_create_csr: _cython_3_1_4.cython_function_or_method
matrix_create_dn: _cython_3_1_4.cython_function_or_method
matrix_destroy: _cython_3_1_4.cython_function_or_method
matrix_get_batch_csr: _cython_3_1_4.cython_function_or_method
matrix_get_batch_dn: _cython_3_1_4.cython_function_or_method
matrix_get_csr: _cython_3_1_4.cython_function_or_method
matrix_get_distribution_row1d: _cython_3_1_4.cython_function_or_method
matrix_get_dn: _cython_3_1_4.cython_function_or_method
matrix_get_format: _cython_3_1_4.cython_function_or_method
matrix_set_batch_csr_pointers: _cython_3_1_4.cython_function_or_method
matrix_set_batch_values: _cython_3_1_4.cython_function_or_method
matrix_set_csr_pointers: _cython_3_1_4.cython_function_or_method
matrix_set_distribution_row1d: _cython_3_1_4.cython_function_or_method
matrix_set_values: _cython_3_1_4.cython_function_or_method
set_comm_layer: _cython_3_1_4.cython_function_or_method
set_device_mem_handler: _cython_3_1_4.cython_function_or_method
set_stream: _cython_3_1_4.cython_function_or_method
set_threading_layer: _cython_3_1_4.cython_function_or_method

class AlgType(enum.IntEnum):
    """See `cudssAlgType_t`."""
    __new__: ClassVar[Callable] = ...
    ALG_1: ClassVar[AlgType] = ...
    ALG_2: ClassVar[AlgType] = ...
    ALG_3: ClassVar[AlgType] = ...
    ALG_4: ClassVar[AlgType] = ...
    ALG_5: ClassVar[AlgType] = ...
    ALG_DEFAULT: ClassVar[AlgType] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class ConfigParam(enum.IntEnum):
    """See `cudssConfigParam_t`."""
    __new__: ClassVar[Callable] = ...
    DETERMINISTIC_MODE: ClassVar[ConfigParam] = ...
    DEVICE_COUNT: ClassVar[ConfigParam] = ...
    DEVICE_INDICES: ClassVar[ConfigParam] = ...
    FACTORIZATION_ALG: ClassVar[ConfigParam] = ...
    HOST_NTHREADS: ClassVar[ConfigParam] = ...
    HYBRID_DEVICE_MEMORY_LIMIT: ClassVar[ConfigParam] = ...
    HYBRID_EXECUTE_MODE: ClassVar[ConfigParam] = ...
    HYBRID_MODE: ClassVar[ConfigParam] = ...
    IR_N_STEPS: ClassVar[ConfigParam] = ...
    IR_TOL: ClassVar[ConfigParam] = ...
    MATCHING_ALG: ClassVar[ConfigParam] = ...
    MAX_LU_NNZ: ClassVar[ConfigParam] = ...
    ND_NLEVELS: ClassVar[ConfigParam] = ...
    PIVOT_EPSILON: ClassVar[ConfigParam] = ...
    PIVOT_EPSILON_ALG: ClassVar[ConfigParam] = ...
    PIVOT_THRESHOLD: ClassVar[ConfigParam] = ...
    PIVOT_TYPE: ClassVar[ConfigParam] = ...
    REORDERING_ALG: ClassVar[ConfigParam] = ...
    SCHUR_MODE: ClassVar[ConfigParam] = ...
    SOLVE_ALG: ClassVar[ConfigParam] = ...
    SOLVE_MODE: ClassVar[ConfigParam] = ...
    UBATCH_INDEX: ClassVar[ConfigParam] = ...
    UBATCH_SIZE: ClassVar[ConfigParam] = ...
    USE_CUDA_REGISTER_MEMORY: ClassVar[ConfigParam] = ...
    USE_MATCHING: ClassVar[ConfigParam] = ...
    USE_SUPERPANELS: ClassVar[ConfigParam] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class DataParam(enum.IntEnum):
    """See `cudssDataParam_t`."""
    __new__: ClassVar[Callable] = ...
    COMM: ClassVar[DataParam] = ...
    DIAG: ClassVar[DataParam] = ...
    ELIMINATION_TREE: ClassVar[DataParam] = ...
    HYBRID_DEVICE_MEMORY_MIN: ClassVar[DataParam] = ...
    INERTIA: ClassVar[DataParam] = ...
    INFO: ClassVar[DataParam] = ...
    LU_NNZ: ClassVar[DataParam] = ...
    MEMORY_ESTIMATES: ClassVar[DataParam] = ...
    NPIVOTS: ClassVar[DataParam] = ...
    NSUPERPANELS: ClassVar[DataParam] = ...
    PERM_COL: ClassVar[DataParam] = ...
    PERM_MATCHING: ClassVar[DataParam] = ...
    PERM_REORDER_COL: ClassVar[DataParam] = ...
    PERM_REORDER_ROW: ClassVar[DataParam] = ...
    PERM_ROW: ClassVar[DataParam] = ...
    SCALE_COL: ClassVar[DataParam] = ...
    SCALE_ROW: ClassVar[DataParam] = ...
    SCHUR_MATRIX: ClassVar[DataParam] = ...
    SCHUR_SHAPE: ClassVar[DataParam] = ...
    USER_ELIMINATION_TREE: ClassVar[DataParam] = ...
    USER_HOST_INTERRUPT: ClassVar[DataParam] = ...
    USER_PERM: ClassVar[DataParam] = ...
    USER_SCHUR_INDICES: ClassVar[DataParam] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class IndexBase(enum.IntEnum):
    """See `cudssIndexBase_t`."""
    __new__: ClassVar[Callable] = ...
    ONE: ClassVar[IndexBase] = ...
    ZERO: ClassVar[IndexBase] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class Layout(enum.IntEnum):
    """See `cudssLayout_t`."""
    __new__: ClassVar[Callable] = ...
    COL_MAJOR: ClassVar[Layout] = ...
    ROW_MAJOR: ClassVar[Layout] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class MatrixFormat(enum.IntEnum):
    """See `cudssMatrixFormat_t`."""
    __new__: ClassVar[Callable] = ...
    BATCH: ClassVar[MatrixFormat] = ...
    CSR: ClassVar[MatrixFormat] = ...
    DENSE: ClassVar[MatrixFormat] = ...
    DISTRIBUTED: ClassVar[MatrixFormat] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class MatrixType(enum.IntEnum):
    """See `cudssMatrixType_t`."""
    __new__: ClassVar[Callable] = ...
    GENERAL: ClassVar[MatrixType] = ...
    HERMITIAN: ClassVar[MatrixType] = ...
    HPD: ClassVar[MatrixType] = ...
    SPD: ClassVar[MatrixType] = ...
    SYMMETRIC: ClassVar[MatrixType] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class MatrixViewType(enum.IntEnum):
    """See `cudssMatrixViewType_t`."""
    __new__: ClassVar[Callable] = ...
    FULL: ClassVar[MatrixViewType] = ...
    LOWER: ClassVar[MatrixViewType] = ...
    UPPER: ClassVar[MatrixViewType] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class OpType(enum.IntEnum):
    """See `cudssOpType_t`."""
    __new__: ClassVar[Callable] = ...
    MAX: ClassVar[OpType] = ...
    MIN: ClassVar[OpType] = ...
    SUM: ClassVar[OpType] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class Phase(enum.IntEnum):
    """See `cudssPhase_t`."""
    __new__: ClassVar[Callable] = ...
    ANALYSIS: ClassVar[Phase] = ...
    FACTORIZATION: ClassVar[Phase] = ...
    REFACTORIZATION: ClassVar[Phase] = ...
    REORDERING: ClassVar[Phase] = ...
    SOLVE: ClassVar[Phase] = ...
    SOLVE_BWD: ClassVar[Phase] = ...
    SOLVE_BWD_PERM: ClassVar[Phase] = ...
    SOLVE_DIAG: ClassVar[Phase] = ...
    SOLVE_FWD: ClassVar[Phase] = ...
    SOLVE_FWD_PERM: ClassVar[Phase] = ...
    SOLVE_REFINEMENT: ClassVar[Phase] = ...
    SYMBOLIC_FACTORIZATION: ClassVar[Phase] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class PivotType(enum.IntEnum):
    """See `cudssPivotType_t`."""
    __new__: ClassVar[Callable] = ...
    PIVOT_COL: ClassVar[PivotType] = ...
    PIVOT_NONE: ClassVar[PivotType] = ...
    PIVOT_ROW: ClassVar[PivotType] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class Status(enum.IntEnum):
    """See `cudssStatus_t`."""
    __new__: ClassVar[Callable] = ...
    ALLOC_FAILED: ClassVar[Status] = ...
    EXECUTION_FAILED: ClassVar[Status] = ...
    INTERNAL_ERROR: ClassVar[Status] = ...
    INVALID_VALUE: ClassVar[Status] = ...
    NOT_INITIALIZED: ClassVar[Status] = ...
    NOT_SUPPORTED: ClassVar[Status] = ...
    SUCCESS: ClassVar[Status] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class cuDSSError(Exception):
    """cuDSSError(status)"""
    def __init__(self, status) -> Any:
        """Initialize self.  See help(type(self)) for accurate signature."""
    def __reduce__(self) -> Any:
        """cuDSSError.__reduce__(self)"""
