# Open Applied Topology

[Open applied topology (OAT)](https://openappliedtopology.github.io) is a library for fast, user-friendly algebra and topology. OAT has 

- a user-friendly frontend for Python users, called [oat_python](https://github.com/OpenAppliedTopology/oat_python)
- a fast backend written in Rust, called [oat_rust](https://github.com/OpenAppliedTopology/oat_rust) 

This package contains the source code for [oat_python](https://github.com/OpenAppliedTopology/oat_python).

# Caution: breaking changes

OAT is in early stages of develpoment, and it's evolving quickly. Code that you write today may not work tomorrow, due to these changes. We will do our very best to make sure that if/when this happens, you will only need to make small changes to your code to fix the problem (e.g., updating the name of a function). However, please do bear this in mind as you write your code!

# Documentation & contributing

- [oat_python: documentation is available through Read the Docs](https://oat-python.readthedocs.io)
- [oat_rust: documentation is available on docs.rs](https://docs.rs/oat_rust/latest)
- [contributing: see CONTRIBUTING.md](https://github.com/OpenAppliedTopology/oat_python/blob/main/CONTRIBUTING.md)

For further options on documentation and installation, see `CONTRIBUTING.md`

# Legal

For information on copyright and licensing, see `LICENSE.md` and `DISCLAIMER.md`.

# Attributions

OAT-PNNL is an extension of OAT library available [here](https://github.com/ExHACT/OAT).  See `ATTRIBUTIONS.md` for details.
