"""
Objects In Space serial command interface.
"""

VERSION = "1.0.4"


class Command:
    _TOGGLE = "_TOGGLE"
    BURN_MAIN_ENGINE = "BURN_MAIN_ENGINE"
    STOP_MAIN_ENGINE = "STOP_MAIN_ENGINE"
    TOGGLE_MAIN_ENGINE = "TOGGLE_MAIN_ENGINE"
    PLOT_COURSE = "PLOT_COURSE"
    CLEAR_COURSE = "CLEAR_COURSE"
    REMOVE_LAST_WAYPOINT = "REMOVE_LAST_WAYPOINT"
    MAP_MOVE_LEFT = "MAP_MOVE_LEFT"
    MAP_MOVE_RIGHT = "MAP_MOVE_RIGHT"
    MAP_MOVE_UP = "MAP_MOVE_UP"
    MAP_MOVE_DOWN = "MAP_MOVE_DOWN"
    MAP_ZOOM_IN = "MAP_ZOOM_IN"
    MAP_ZOOM_OUT = "MAP_ZOOM_OUT"
    MAP_CENTER = "MAP_CENTER"
    ENGAGE_COURSE = "ENGAGE_COURSE"
    FULL_STOP = "FULL_STOP"
    FIRE_RCS_CW = "FIRE_RCS_CW"
    FIRE_RCS_CCW = "FIRE_RCS_CCW"
    STOP_RCS = "STOP_RCS"
    EMCON_ON = "EMCON_ON"
    EMCON_OFF = "EMCON_OFF"
    CANCEL_AUTOPILOT = "CANCEL_AUTOPILOT"
    DOCK = "DOCK"
    UNDOCK = "UNDOCK"
    SELECT_TUBE = "SELECT_TUBE"
    DESELECT_TUBE = "DESELECT_TUBE"
    SPIN_UP_WEAPON = "SPIN_UP_WEAPON"
    POWER_DOWN_WEAPON = "POWER_DOWN_WEAPON"
    FIRE_WEAPON = "FIRE_WEAPON"
    SET_WEAPON_TARGET = "SET_WEAPON_TARGET"
    UNLINK_WEAPON = "UNLINK_WEAPON"
    ARM_WEAPON = "ARM_WEAPON"
    DISABLE_WEAPON = "DISABLE_WEAPON"
    ROTATE = "ROTATE"
    TOGGLE_EMCON = "TOGGLE_EMCON"
    TOGGLE_MAP_MODE = "TOGGLE_MAP_MODE"
    BREAK_ORBIT = "BREAK_ORBIT"
    CHANGE_TO_STANDARD_ORBIT = "CHANGE_TO_STANDARD_ORBIT"
    CHANGE_TO_HIGH_ORBIT = "CHANGE_TO_HIGH_ORBIT"
    CHANGE_TO_POLAR_ORBIT = "CHANGE_TO_POLAR_ORBIT"
    REQUEST_DOCKING_PERMISSION = "REQUEST_DOCKING_PERMISSION"
    REQUEST_UNDOCKING_PERMISSION = "REQUEST_UNDOCKING_PERMISSION"
    TURN_ON_IFF = "TURN_ON_IFF"
    TURN_OFF_IFF = "TURN_OFF_IFF"
    TOGGLE_IFF = "TOGGLE_IFF"
    LEAVE_SHIP = "LEAVE_SHIP"
    COMMUNICATE_WITH_SELECTED = "COMMUNICATE_WITH_SELECTED"
    RESCIND_DOCKING_PERMISSION = "RESCIND_DOCKING_PERMISSION"
    RESCIND_UNDOCKING_PERMISSION = "RESCIND_UNDOCKING_PERMISSION"
    PAY_DOCKED_STATION = "PAY_DOCKED_STATION"
    ACTIVATE_JUMPGATE = "ACTIVATE_JUMPGATE"
    PAY_FOR_JUMPGATE = "PAY_FOR_JUMPGATE"
    SELECT_TUBE1 = "SELECT_TUBE1"
    SELECT_TUBE2 = "SELECT_TUBE2"
    SELECT_TUBE3 = "SELECT_TUBE3"
    SELECT_TUBE4 = "SELECT_TUBE4"
    SELECT_TUBE5 = "SELECT_TUBE5"
    MAP_CLICK = "MAP_CLICK"
    ENG_DISCONNECT_CURRENT_MODULE = "ENG_DISCONNECT_CURRENT_MODULE"
    ENG_CONNECT_CURRENT_MODULE = "ENG_CONNECT_CURRENT_MODULE"
    ENG_OPEN_CURRENT_MODULE = "ENG_OPEN_CURRENT_MODULE"
    ENG_CLOSE_CURRENT_MODULE = "ENG_CLOSE_CURRENT_MODULE"
    ENG_REPAIR_CURRENT_COMPONENT = "ENG_REPAIR_CURRENT_COMPONENT"
    JMP_SET_JUMP_DESTINATION = "JMP_SET_JUMP_DESTINATION"
    JMP_SPIN_UP_JUMP_DRIVE = "JMP_SPIN_UP_JUMP_DRIVE"
    JMP_CALCULATE_JUMP_SOLUTION = "JMP_CALCULATE_JUMP_SOLUTION"
    JMP_BEGIN_JUMP = "JMP_BEGIN_JUMP"
    JMP_DISCHARGE_JUMP_DRIVE = "JMP_DISCHARGE_JUMP_DRIVE"
    PWR_TOGGLE_CURRENT_MODULE_EMCON = "PWR_TOGGLE_CURRENT_MODULE_EMCON"
    PWR_TOGGLE_CURRENT_MODULE_POWER = "PWR_TOGGLE_CURRENT_MODULE_POWER"
    PWR_RAISE_PRIORITY = "PWR_RAISE_PRIORITY"
    PWR_LOWER_PRIORITY = "PWR_LOWER_PRIORITY"
    SCRAM_REACTOR = "SCRAM_REACTOR"
    POWER_UP_REACTOR = "POWER_UP_REACTOR"
    TOGGLE_REACTOR = "TOGGLE_REACTOR"
    PWR_DISCONNECT_HELM = "PWR_DISCONNECT_HELM"
    PWR_CONNECT_HELM = "PWR_CONNECT_HELM"
    PWR_TOGGLE_HELM = "PWR_TOGGLE_HELM"
    PWR_DISCONNECT_RCS = "PWR_DISCONNECT_RCS"
    PWR_CONNECT_RCS = "PWR_CONNECT_RCS"
    PWR_TOGGLE_RCS = "PWR_TOGGLE_RCS"
    PWR_DISCONNECT_MAINDRIVE = "PWR_DISCONNECT_MAINDRIVE"
    PWR_CONNECT_MAINDRIVE = "PWR_CONNECT_MAINDRIVE"
    PWR_TOGGLE_MAINDRIVE = "PWR_TOGGLE_MAINDRIVE"
    PWR_DISCONNECT_COMMS = "PWR_DISCONNECT_COMMS"
    PWR_CONNECT_COMMS = "PWR_CONNECT_COMMS"
    PWR_TOGGLE_COMMS = "PWR_TOGGLE_COMMS"
    PWR_DISCONNECT_WEAP = "PWR_DISCONNECT_WEAP"
    PWR_CONNECT_WEAP = "PWR_CONNECT_WEAP"
    PWR_TOGGLE_WEAP = "PWR_TOGGLE_WEAP"
    PWR_DISCONNECT_JUMPDRIVE = "PWR_DISCONNECT_JUMPDRIVE"
    PWR_CONNECT_JUMPDRIVE = "PWR_CONNECT_JUMPDRIVE"
    PWR_TOGGLE_JUMPDRIVE = "PWR_TOGGLE_JUMPDRIVE"
    PWR_DISCONNECT_BATT1 = "PWR_DISCONNECT_BATT1"
    PWR_CONNECT_BATT1 = "PWR_CONNECT_BATT1"
    PWR_TOGGLE_BATT1 = "PWR_TOGGLE_BATT1"
    PWR_DISCONNECT_BATT2 = "PWR_DISCONNECT_BATT2"
    PWR_CONNECT_BATT2 = "PWR_CONNECT_BATT2"
    PWR_TOGGLE_BATT2 = "PWR_TOGGLE_BATT2"
    PWR_DISCONNECT_BATT3 = "PWR_DISCONNECT_BATT3"
    PWR_CONNECT_BATT3 = "PWR_CONNECT_BATT3"
    PWR_TOGGLE_BATT3 = "PWR_TOGGLE_BATT3"
    PWR_DISCONNECT_NAVCOM = "PWR_DISCONNECT_NAVCOM"
    PWR_CONNECT_NAVCOM = "PWR_CONNECT_NAVCOM"
    PWR_TOGGLE_NAVCOM = "PWR_TOGGLE_NAVCOM"
    PWR_DISCONNECT_SENS = "PWR_DISCONNECT_SENS"
    PWR_CONNECT_SENS = "PWR_CONNECT_SENS"
    PWR_TOGGLE_SENS = "PWR_TOGGLE_SENS"
    TURN_ON_SHIP = "TURN_ON_SHIP"
    TURN_OFF_SHIP = "TURN_OFF_SHIP"
    TELEPORT = "TELEPORT"
    SENSOR_SELECT_DOWN = "SENSOR_SELECT_DOWN"
    SENSOR_SELECT_UP = "SENSOR_SELECT_UP"
    SENSOR_SELECT_RIGHT = "SENSOR_SELECT_RIGHT"
    SENSOR_SELECT_LEFT = "SENSOR_SELECT_LEFT"
    SENSOR_SELECT_TAB = "SENSOR_SELECT_TAB"
    SENSOR_SET_NAV_AND_SENSOR_LINKED = "SENSOR_SET_NAV_AND_SENSOR_LINKED"
    SENSOR_UNSET_NAV_AND_SENSOR_LINKED = "SENSOR_UNSET_NAV_AND_SENSOR_LINKED"
    SENSOR_SET_HISTORY_LOCKED = "SENSOR_SET_HISTORY_LOCKED"
    SENSOR_UNSET_HISTORY_LOCKED = "SENSOR_UNSET_HISTORY_LOCKED"
    SENSOR_SET_AUTO = "SENSOR_SET_AUTO"
    SENSOR_UNSET_AUTO = "SENSOR_UNSET_AUTO"
    PWR_SELECT_MODULE = "PWR_SELECT_MODULE"
    ENG_SELECT_MODULE = "ENG_SELECT_MODULE"
    ENG_SELECT_COMPONENT = "ENG_SELECT_COMPONENT"
    ENG_MOUNT_COMPONENT = "ENG_MOUNT_COMPONENT"
    ENG_MOVE_COMPONENT = "ENG_MOVE_COMPONENT"
    ENG_UNMOUNT_COMPONENT = "ENG_UNMOUNT_COMPONENT"
    ENG_TOGGLE_SCREW = "ENG_TOGGLE_SCREW"
    ENG_TOGGLE_SHIELD = "ENG_TOGGLE_SHIELD"
    SELECT_COMPONENT_INV = "SELECT_COMPONENT_INV"
    HELM_SET_ATAC_MODE = "HELM_SET_ATAC_MODE"
    HELM_UNSET_ATAC_MODE = "HELM_UNSET_ATAC_MODE"
    ENABLE_LADAR = "ENABLE_LADAR"
    DISABLE_LADAR = "DISABLE_LADAR"
    TOGGLE_LADAR = "TOGGLE_LADAR"
    MAIN_DRIVE_POWER_INCREASE = "MAIN_DRIVE_POWER_INCREASE"
    MAIN_DRIVE_POWER_DECREASE = "MAIN_DRIVE_POWER_DECREASE"
    PWR_POWER_INCREASE = "PWR_POWER_INCREASE"
    PWR_POWER_DECREASE = "PWR_POWER_DECREASE"
    ACTIVATE_PDS = "ACTIVATE_PDS"
    DEACTIVATE_PDS = "DEACTIVATE_PDS"
    TOGGLE_PDS = "TOGGLE_PDS"
    FIRE_CM = "FIRE_CM"
    COMMS_SYNC = "COMMS_SYNC"
    COMMS_TURN_ON_AUTO = "COMMS_TURN_ON_AUTO"
    COMMS_TURN_OFF_AUTO = "COMMS_TURN_OFF_AUTO"
    SHIP_CARGO_DOWN = "SHIP_CARGO_DOWN"
    SHIP_CARGO_UP = "SHIP_CARGO_UP"
    JETTISON_CARGO = "JETTISON_CARGO"
    JETTISON_ALL = "JETTISON_ALL"
    MOORED_CARGO_DOWN = "MOORED_CARGO_DOWN"
    MOORED_CARGO_UP = "MOORED_CARGO_UP"
    TRANSFER_CARGO_FROM_MOORED = "TRANSFER_CARGO_FROM_MOORED"
    TRANSFER_CARGO_FROM_SHIP = "TRANSFER_CARGO_FROM_SHIP"
    HACK = "HACK"
    REPAIR_HULL_AT_DEPOT = "REPAIR_HULL_AT_DEPOT"
    REPAIR_MODULES_AT_DEPOT = "REPAIR_MODULES_AT_DEPOT"
    REARM_AT_DEPOT = "REARM_AT_DEPOT"
    BUY_CM_AT_DEPOT = "BUY_CM_AT_DEPOT"
    TUTORIAL_JUMP = "TUTORIAL_JUMP"
    TRADE_TOMAX = "TRADE_TOMAX"
    TRADE_PERFORM = "TRADE_PERFORM"
    TRADE_CANCEL = "TRADE_CANCEL"
    COMMERCE_MENU = "COMMERCE_MENU"
    COMMERCE_GETLICENSE = "COMMERCE_GETLICENSE"
    COMMERCE_TAKELOAN = "COMMERCE_TAKELOAN"
    COMMERCE_REPAYLOAN = "COMMERCE_REPAYLOAN"
    COMMERCE_TAKECONTRACT = "COMMERCE_TAKECONTRACT"
    COMMERCE_DELIVERCONTRACT = "COMMERCE_DELIVERCONTRACT"
    VIEW_WIRE = "VIEW_WIRE"
    MECHANIC_TOMENU = "MECHANIC_TOMENU"
    MECHANIC_REPAIR = "MECHANIC_REPAIR"
    MECHANIC_BUY_POD = "MECHANIC_BUY_POD"
    MECHANIC_SELL_POD = "MECHANIC_SELL_POD"
    MECHANIC_UPGRADE_POD = "MECHANIC_UPGRADE_POD"
    MECHANIC_CANCELMODULE = "MECHANIC_CANCELMODULE"
    MECHANIC_MODULETRANSACTION = "MECHANIC_MODULETRANSACTION"
    MECHANIC_BUYARMAMENT = "MECHANIC_BUYARMAMENT"
    MECHANIC_SELLARMAMENT = "MECHANIC_SELLARMAMENT"
    BUY_SHIP = "BUY_SHIP"
    MOORED_WRECK_UNLOCK_CARGO = "MOORED_WRECK_UNLOCK_CARGO"
    MOORED_WRECK_DOWNLOAD_DATA = "MOORED_WRECK_DOWNLOAD_DATA"
    SET_VIEW_SHIP = "SET_VIEW_SHIP"
    BOARD_BROKER_SHIP = "BOARD_BROKER_SHIP"
    TAKE_PASSENGER = "TAKE_PASSENGER"
    TURN_ON_SOS = "TURN_ON_SOS"
    TURN_OFF_SOS = "TURN_OFF_SOS"
    NEXT_TRACK = "NEXT_TRACK"
    PREV_TRACK = "PREV_TRACK"
    PAUSE_TRACK = "PAUSE_TRACK"
    RESUME_TRACK = "RESUME_TRACK"
    TAKE_BOUNTY = "TAKE_BOUNTY"
    QUIT_TO_MENU = "QUIT_TO_MENU"
    QUIT_TO_OS = "QUIT_TO_OS"
    ROOM_LEFT = "ROOM_LEFT"
    ROOM_RIGHT = "ROOM_RIGHT"
    TOGGLE_TABLET = "TOGGLE_TABLET"
    SWITCH_TABS = "SWITCH_TABS"
    TIME_SLOWER = "TIME_SLOWER"
    TIME_FASTER = "TIME_FASTER"
    CHANGE_DETAILS = "CHANGE_DETAILS"
    BEGIN_GAME = "BEGIN_GAME"
    DELETE_SAVE = "DELETE_SAVE"
    JETTISON_COMPONENT = "JETTISON_COMPONENT"
    MOVE_MODULE = "MOVE_MODULE"
    SWITCH_TO_MENU = "SWITCH_TO_MENU"
    CONNECT_TO_SERVER = "CONNECT_TO_SERVER"
    DISCONNECT_FROM_SERVER = "DISCONNECT_FROM_SERVER"
    SEND_CHAT_MESSAGE = "SEND_CHAT_MESSAGE"
    ALTER_SERVER_SETTING = "ALTER_SERVER_SETTING"
    SEND_SERVER_COMMAND = "SEND_SERVER_COMMAND"
    MOVE_CARGO = "MOVE_CARGO"
    SEND_READY_STATE = "SEND_READY_STATE"


class Boolean:
    FLAGSET = "FLAGSET"
    FLAGNOTSET = "FLAGNOTSET"
    _STATE = "_STATE"
    NAV_TARGET_SELECTED = "NAV_TARGET_SELECTED"
    IS_MOVING = "IS_MOVING"
    MAIN_ENGINE_BURNING = "MAIN_ENGINE_BURNING"
    HAS_SELECTED_DIRECTION = "HAS_SELECTED_DIRECTION"
    HAS_COURSE_PLOTTED = "HAS_COURSE_PLOTTED"
    AUTO_PILOT_ENGAGED = "AUTO_PILOT_ENGAGED"
    AUTO_PILOT_NOT_ENGAGED = "AUTO_PILOT_NOT_ENGAGED"
    COURSE_PLOTTED_NOT_ENGAGED = "COURSE_PLOTTED_NOT_ENGAGED"
    DOCKED_WITH_JUMPGATE = "DOCKED_WITH_JUMPGATE"
    HAS_SELECTED_OBJECT = "HAS_SELECTED_OBJECT"
    MAP_LOCKED_TO_SHIP = "MAP_LOCKED_TO_SHIP"
    MAP_IN_SECTOR_MODE = "MAP_IN_SECTOR_MODE"
    PWR_HAS_MODULE_SELECTED = "PWR_HAS_MODULE_SELECTED"
    PWR_CURRENT_MODULE_ON = "PWR_CURRENT_MODULE_ON"
    PWR_CURRENT_MODULE_OFF = "PWR_CURRENT_MODULE_OFF"
    PWR_CURRENT_MODULE_EMCON_ON = "PWR_CURRENT_MODULE_EMCON_ON"
    PWR_CURRENT_MODULE_EMCON_OFF = "PWR_CURRENT_MODULE_EMCON_OFF"
    PWR_REACTOR_ON = "PWR_REACTOR_ON"
    PWR_REACTOR_OFF = "PWR_REACTOR_OFF"
    PWR_CAN_RAISE_PRIORITY = "PWR_CAN_RAISE_PRIORITY"
    PWR_CAN_LOWER_PRIORITY = "PWR_CAN_LOWER_PRIORITY"
    IS_STATIONARY = "IS_STATIONARY"
    CAN_COME_TO_FULL_STOP = "CAN_COME_TO_FULL_STOP"
    RCS_BURNING = "RCS_BURNING"
    RCS_BURNING_CW = "RCS_BURNING_CW"
    RCS_BURNING_CCW = "RCS_BURNING_CCW"
    EMCON_MODE = "EMCON_MODE"
    HAS_SELECTED_DESTINATION = "HAS_SELECTED_DESTINATION"
    STATUS_WARNING = "STATUS_WARNING"
    STATUS_DANGER = "STATUS_DANGER"
    STATUS_NOMINAL = "STATUS_NOMINAL"
    IN_ASTEROID_FIELD = "IN_ASTEROID_FIELD"
    IN_NEBULA = "IN_NEBULA"
    TUBE_HAS_TORPEDO = "TUBE_HAS_TORPEDO"
    TUBE_HAS_MINE = "TUBE_HAS_MINE"
    TUBE_HAS_PROBE = "TUBE_HAS_PROBE"
    TUBE_CAN_SPIN_UP = "TUBE_CAN_SPIN_UP"
    TUBE_CAN_FIRE = "TUBE_CAN_FIRE"
    TUBE_CAN_LAUNCH = "TUBE_CAN_LAUNCH"
    TUBE_LAUNCHED = "TUBE_LAUNCHED"
    TUBE_EMPTY = "TUBE_EMPTY"
    TUBE_SPINNING_UP = "TUBE_SPINNING_UP"
    TUBE_LINKED = "TUBE_LINKED"
    TUBE_HAS_EXP = "TUBE_HAS_EXP"
    TUBE_HAS_EMP = "TUBE_HAS_EMP"
    TUBE_CAN_BE_ARMED = "TUBE_CAN_BE_ARMED"
    TUBE_CAN_POWER_DOWN = "TUBE_CAN_POWER_DOWN"
    TUBE_CAN_BE_DISABLED = "TUBE_CAN_BE_DISABLED"
    CAN_SET_TARGET = "CAN_SET_TARGET"
    CAN_CHANGE_TARGET = "CAN_CHANGE_TARGET"
    CANNOT_SET_OR_CHANGE_TARGET = "CANNOT_SET_OR_CHANGE_TARGET"
    CAN_ROTATE = "CAN_ROTATE"
    PCE_ALARM = "PCE_ALARM"
    CLUSTER_MODE = "CLUSTER_MODE"
    IS_IN_ORBIT = "IS_IN_ORBIT"
    IS_IN_STANDARD_ORBIT = "IS_IN_STANDARD_ORBIT"
    IS_IN_HIGH_ORBIT = "IS_IN_HIGH_ORBIT"
    IS_IN_POLAR_ORBIT = "IS_IN_POLAR_ORBIT"
    NOT_IN_STANDARD_ORBIT = "NOT_IN_STANDARD_ORBIT"
    NOT_IN_HIGH_ORBIT = "NOT_IN_HIGH_ORBIT"
    NOT_IN_POLAR_ORBIT = "NOT_IN_POLAR_ORBIT"
    IS_IN_FREE_SPACE = "IS_IN_FREE_SPACE"
    IS_CHANGING_ORBIT = "IS_CHANGING_ORBIT"
    IS_LEAVING_ORBIT = "IS_LEAVING_ORBIT"
    IS_ENTERING_ORBIT = "IS_ENTERING_ORBIT"
    IS_CORRECTING_ORBIT = "IS_CORRECTING_ORBIT"
    IS_IN_STABLE_ORBIT = "IS_IN_STABLE_ORBIT"
    NOT_DOCKED = "NOT_DOCKED"
    NOT_DOCKED_OR_MULTIPLAYER = "NOT_DOCKED_OR_MULTIPLAYER"
    NOT_DOCKED_OR_MULTIPLAYER_OR_TUTORIAL = "NOT_DOCKED_OR_MULTIPLAYER_OR_TUTORIAL"
    IS_DOCKED_OR_DOCKING = "IS_DOCKED_OR_DOCKING"
    IS_DOCKED = "IS_DOCKED"
    IS_DOCKING = "IS_DOCKING"
    IS_FULLY_DOCKED = "IS_FULLY_DOCKED"
    IS_UNDOCKING = "IS_UNDOCKING"
    NOT_DOCKING = "NOT_DOCKING"
    NOT_UNDOCKING = "NOT_UNDOCKING"
    CAN_OPEN_AIRLOCK = "CAN_OPEN_AIRLOCK"
    HAS_DOCKING_PERMISSION = "HAS_DOCKING_PERMISSION"
    NEEDS_DOCKING_PERMISSION = "NEEDS_DOCKING_PERMISSION"
    HAS_UNDOCKING_PERMISSION = "HAS_UNDOCKING_PERMISSION"
    NEEDS_UNDOCKING_PERMISSION = "NEEDS_UNDOCKING_PERMISSION"
    CAN_GET_UNDOCKING_PERMISSION = "CAN_GET_UNDOCKING_PERMISSION"
    CANNOT_GET_UNDOCKING_PERMISSION = "CANNOT_GET_UNDOCKING_PERMISSION"
    ANY_AIRLOCK_OPEN = "ANY_AIRLOCK_OPEN"
    ALL_AIRLOCKS_SEALED = "ALL_AIRLOCKS_SEALED"
    AIRLOCKS_CLOSED_BUT_NEEDS_UNDOCK_PERMISSION = (
        "AIRLOCKS_CLOSED_BUT_NEEDS_UNDOCK_PERMISSION"
    )
    CAN_UNDOCK = "CAN_UNDOCK"
    DOCKED_BUT_CANNOT_UNDOCK = "DOCKED_BUT_CANNOT_UNDOCK"
    IFF_ACTIVE = "IFF_ACTIVE"
    SELECTED_OBJECT_CAN_COMMUNICATE = "SELECTED_OBJECT_CAN_COMMUNICATE"
    OWES_MONEY_TO_DOCKED_STATION = "OWES_MONEY_TO_DOCKED_STATION"
    OWES_MONEY_TO_DOCKED_STATION_AND_CANNOT_PAY = (
        "OWES_MONEY_TO_DOCKED_STATION_AND_CANNOT_PAY"
    )
    OWES_MONEY_TO_DOCKED_STATION_AND_CAN_PAY = (
        "OWES_MONEY_TO_DOCKED_STATION_AND_CAN_PAY"
    )
    IS_DOCKED_WITH_STATION = "IS_DOCKED_WITH_STATION"
    IS_DOCKED_WITH_DEPOT = "IS_DOCKED_WITH_DEPOT"
    IS_DOCKED_WITH_JUMPGATE = "IS_DOCKED_WITH_JUMPGATE"
    NEED_TO_PAY_FOR_JUMPGATE = "NEED_TO_PAY_FOR_JUMPGATE"
    CAN_ACTIVATE_JUMPGATE = "CAN_ACTIVATE_JUMPGATE"
    NOT_DOCKED_WITH_STATION = "NOT_DOCKED_WITH_STATION"
    MODULE_REACTOR_UNDAMAGED = "MODULE_REACTOR_UNDAMAGED"
    MODULE_REACTOR_DAMAGED = "MODULE_REACTOR_DAMAGED"
    MODULE_REACTOR_DESTROYED = "MODULE_REACTOR_DESTROYED"
    MODULE_REACTOR_CONNECTED = "MODULE_REACTOR_CONNECTED"
    MODULE_REACTOR_FUNCTIONING = "MODULE_REACTOR_FUNCTIONING"
    MODULE_MAINDRIVE_UNDAMAGED = "MODULE_MAINDRIVE_UNDAMAGED"
    MODULE_MAINDRIVE_DAMAGED = "MODULE_MAINDRIVE_DAMAGED"
    MODULE_MAINDRIVE_DESTROYED = "MODULE_MAINDRIVE_DESTROYED"
    MODULE_MAINDRIVE_CONNECTED = "MODULE_MAINDRIVE_CONNECTED"
    MODULE_RCS_UNDAMAGED = "MODULE_RCS_UNDAMAGED"
    MODULE_RCS_DAMAGED = "MODULE_RCS_DAMAGED"
    MODULE_RCS_DESTROYED = "MODULE_RCS_DESTROYED"
    MODULE_RCS_CONNECTED = "MODULE_RCS_CONNECTED"
    MODULE_COMMS_UNDAMAGED = "MODULE_COMMS_UNDAMAGED"
    MODULE_COMMS_DAMAGED = "MODULE_COMMS_DAMAGED"
    MODULE_COMMS_DESTROYED = "MODULE_COMMS_DESTROYED"
    MODULE_COMMS_CONNECTED = "MODULE_COMMS_CONNECTED"
    MODULE_BATT1_UNDAMAGED = "MODULE_BATT1_UNDAMAGED"
    MODULE_BATT1_DAMAGED = "MODULE_BATT1_DAMAGED"
    MODULE_BATT1_DESTROYED = "MODULE_BATT1_DESTROYED"
    MODULE_BATT1_CONNECTED = "MODULE_BATT1_CONNECTED"
    MODULE_BATT2_UNDAMAGED = "MODULE_BATT2_UNDAMAGED"
    MODULE_BATT2_DAMAGED = "MODULE_BATT2_DAMAGED"
    MODULE_BATT2_DESTROYED = "MODULE_BATT2_DESTROYED"
    MODULE_BATT2_CONNECTED = "MODULE_BATT2_CONNECTED"
    MODULE_BATT3_UNDAMAGED = "MODULE_BATT3_UNDAMAGED"
    MODULE_BATT3_DAMAGED = "MODULE_BATT3_DAMAGED"
    MODULE_BATT3_DESTROYED = "MODULE_BATT3_DESTROYED"
    MODULE_BATT3_CONNECTED = "MODULE_BATT3_CONNECTED"
    MODULE_HELM_UNDAMAGED = "MODULE_HELM_UNDAMAGED"
    MODULE_HELM_DAMAGED = "MODULE_HELM_DAMAGED"
    MODULE_HELM_DESTROYED = "MODULE_HELM_DESTROYED"
    MODULE_HELM_CONNECTED = "MODULE_HELM_CONNECTED"
    MODULE_SENSORS_UNDAMAGED = "MODULE_SENSORS_UNDAMAGED"
    MODULE_SENSORS_DAMAGED = "MODULE_SENSORS_DAMAGED"
    MODULE_SENSORS_DESTROYED = "MODULE_SENSORS_DESTROYED"
    MODULE_SENSORS_CONNECTED = "MODULE_SENSORS_CONNECTED"
    MODULE_NAVCOM_UNDAMAGED = "MODULE_NAVCOM_UNDAMAGED"
    MODULE_NAVCOM_DAMAGED = "MODULE_NAVCOM_DAMAGED"
    MODULE_NAVCOM_DESTROYED = "MODULE_NAVCOM_DESTROYED"
    MODULE_NAVCOM_CONNECTED = "MODULE_NAVCOM_CONNECTED"
    MODULE_WEAP_UNDAMAGED = "MODULE_WEAP_UNDAMAGED"
    MODULE_WEAP_DAMAGED = "MODULE_WEAP_DAMAGED"
    MODULE_WEAP_DESTROYED = "MODULE_WEAP_DESTROYED"
    MODULE_WEAP_CONNECTED = "MODULE_WEAP_CONNECTED"
    MODULE_JUMPDRIVE_UNDAMAGED = "MODULE_JUMPDRIVE_UNDAMAGED"
    MODULE_JUMPDRIVE_DAMAGED = "MODULE_JUMPDRIVE_DAMAGED"
    MODULE_JUMPDRIVE_DESTROYED = "MODULE_JUMPDRIVE_DESTROYED"
    MODULE_JUMPDRIVE_CONNECTED = "MODULE_JUMPDRIVE_CONNECTED"
    MODULE_BOOTING = "MODULE_BOOTING"
    MODULE_DISCONNECTED = "MODULE_DISCONNECTED"
    SHOW_SPACE_DISC = "SHOW_SPACE_DISC"
    DONT_SHOW_SPACE_DISC = "DONT_SHOW_SPACE_DISC"
    TUBE_1_SELECTED = "TUBE_1_SELECTED"
    TUBE_2_SELECTED = "TUBE_2_SELECTED"
    TUBE_3_SELECTED = "TUBE_3_SELECTED"
    TUBE_4_SELECTED = "TUBE_4_SELECTED"
    TUBE_5_SELECTED = "TUBE_5_SELECTED"
    TUBE_6_SELECTED = "TUBE_6_SELECTED"
    TUBE_7_SELECTED = "TUBE_7_SELECTED"
    TUBE_8_SELECTED = "TUBE_8_SELECTED"
    ENG_MODULE_ON = "ENG_MODULE_ON"
    ENG_MODULE_OFF = "ENG_MODULE_OFF"
    ENG_MODULE_CAN_OPEN = "ENG_MODULE_CAN_OPEN"
    ENG_MODULE_OPEN = "ENG_MODULE_OPEN"
    ENG_NO_MODULE_OPEN = "ENG_NO_MODULE_OPEN"
    ENG_CAN_CLOSE_CURRENT_MODULE = "ENG_CAN_CLOSE_CURRENT_MODULE"
    ENG_MODULE_CAN_BE_CONNECTED = "ENG_MODULE_CAN_BE_CONNECTED"
    ENG_NO_TRAY_OBJECT_SELECTED = "ENG_NO_TRAY_OBJECT_SELECTED"
    ENG_CAN_REPAIR_COMPONENT = "ENG_CAN_REPAIR_COMPONENT"
    ENG_IS_REPAIRING = "ENG_IS_REPAIRING"
    JMP_CAN_SET_JUMP_DESTINATION = "JMP_CAN_SET_JUMP_DESTINATION"
    JMP_CANNOT_SET_JUMP_DESTINATION = "JMP_CANNOT_SET_JUMP_DESTINATION"
    JMP_CAN_SPIN_UP_JUMP_DRIVE = "JMP_CAN_SPIN_UP_JUMP_DRIVE"
    JMP_CANNOT_SPIN_UP_JUMP_DRIVE = "JMP_CANNOT_SPIN_UP_JUMP_DRIVE"
    JMP_CAN_CALC_JUMP = "JMP_CAN_CALC_JUMP"
    JMP_CANNOT_CALC_JUMP = "JMP_CANNOT_CALC_JUMP"
    JMP_CAN_JUMP = "JMP_CAN_JUMP"
    JMP_CANNOT_JUMP = "JMP_CANNOT_JUMP"
    JMP_CAN_DISCHARGE_JUMP_DRIVE = "JMP_CAN_DISCHARGE_JUMP_DRIVE"
    JMP_CANNOT_DISCHARGE_JUMP_DRIVE = "JMP_CANNOT_DISCHARGE_JUMP_DRIVE"
    JMP_HAS_JUMP_DRIVE = "JMP_HAS_JUMP_DRIVE"
    JMP_HAS_NO_JUMP_DRIVE = "JMP_HAS_NO_JUMP_DRIVE"
    JMP_IS_SPINNING_UP = "JMP_IS_SPINNING_UP"
    JMP_IS_CALCULATING_JUMP = "JMP_IS_CALCULATING_JUMP"
    JMP_IS_SPUN_UP = "JMP_IS_SPUN_UP"
    JMP_IS_CALCULATED = "JMP_IS_CALCULATED"
    PWR_LOW_POWER_WARNING = "PWR_LOW_POWER_WARNING"
    PWR_IS_DRAINING = "PWR_IS_DRAINING"
    PWR_IS_GENERATING = "PWR_IS_GENERATING"
    IS_TURNED_ON = "IS_TURNED_ON"
    IS_TURNED_OFF = "IS_TURNED_OFF"
    CAN_TELEPORT = "CAN_TELEPORT"
    SENSORS_NAV_LINKED = "SENSORS_NAV_LINKED"
    SENSORS_HISTORY_LOCKED = "SENSORS_HISTORY_LOCKED"
    SENSORS_AUTO = "SENSORS_AUTO"
    LADAR_ACTIVE = "LADAR_ACTIVE"
    LADAR_FUNCTIONAL = "LADAR_FUNCTIONAL"
    LADAR_INACTIVE = "LADAR_INACTIVE"
    MAIN_DRIVE_FUNCTIONAL = "MAIN_DRIVE_FUNCTIONAL"
    CM_EXISTS = "CM_EXISTS"
    CM_CANLAUNCH = "CM_CANLAUNCH"
    CM_CANNOTLAUNCH = "CM_CANNOTLAUNCH"
    PDS_EXISTS = "PDS_EXISTS"
    PDS_ACTIVE = "PDS_ACTIVE"
    PDS_INACTIVE = "PDS_INACTIVE"
    COMMS_AUTOSYNC_ON = "COMMS_AUTOSYNC_ON"
    VALID_TRAVEL_TARGET_SELECTED = "VALID_TRAVEL_TARGET_SELECTED"
    CAN_ADD_WAYPOINT = "CAN_ADD_WAYPOINT"
    IS_MOORED = "IS_MOORED"
    IS_MOORED_TO_DEBRIS = "IS_MOORED_TO_DEBRIS"
    IS_MOORED_TO_CARGO = "IS_MOORED_TO_CARGO"
    HAS_GRAPPLING_ARM = "HAS_GRAPPLING_ARM"
    GRAPPLING_ARM_IN_USE = "GRAPPLING_ARM_IN_USE"
    CAN_GRAPPLE_MOORED = "CAN_GRAPPLE_MOORED"
    CAN_GRAPPLE_SHIP = "CAN_GRAPPLE_SHIP"
    CAN_JETTISON = "CAN_JETTISON"
    CAN_JETTISON_ALL = "CAN_JETTISON_ALL"
    CAN_HACK = "CAN_HACK"
    CANNOT_HACK = "CANNOT_HACK"
    HAS_HACKING_UNIT = "HAS_HACKING_UNIT"
    IS_HACKING = "IS_HACKING"
    BEING_HAILED = "BEING_HAILED"
    SHOULD_SHOW_CARGO_SCREEN = "SHOULD_SHOW_CARGO_SCREEN"
    CAN_REPAIR_HULL_AT_DEPOT = "CAN_REPAIR_HULL_AT_DEPOT"
    CANNOT_REPAIR_HULL_AT_DEPOT = "CANNOT_REPAIR_HULL_AT_DEPOT"
    CAN_REPAIR_MODULES_AT_DEPOT = "CAN_REPAIR_MODULES_AT_DEPOT"
    CANNOT_REPAIR_MODULES_AT_DEPOT = "CANNOT_REPAIR_MODULES_AT_DEPOT"
    CAN_REARM_AT_DEPOT = "CAN_REARM_AT_DEPOT"
    CANNOT_REARM_AT_DEPOT = "CANNOT_REARM_AT_DEPOT"
    CAN_BUY_CM_AT_DEPOT = "CAN_BUY_CM_AT_DEPOT"
    CANNOT_BUY_CM_AT_DEPOT = "CANNOT_BUY_CM_AT_DEPOT"
    CAN_JUMP_IN_TUTORIAL = "CAN_JUMP_IN_TUTORIAL"
    CAN_DETECT_CASSANDRA = "CAN_DETECT_CASSANDRA"
    JUMPDRIVE_ACTIVE = "JUMPDRIVE_ACTIVE"
    PDL_ACTIVE = "PDL_ACTIVE"
    LADAR_DETECTED = "LADAR_DETECTED"
    MENU_MAIN = "MENU_MAIN"
    SUBMENU_OPTIONS = "SUBMENU_OPTIONS"
    SUBMENU_INPUT = "SUBMENU_INPUT"
    SUBMENU_NEWS = "SUBMENU_NEWS"
    SUBMENU_CREDITS = "SUBMENU_CREDITS"
    SUBMENU_GAMEOVER = "SUBMENU_GAMEOVER"
    TRADE_HASPURCHASE = "TRADE_HASPURCHASE"
    TRADE_VALIDPURCHASE = "TRADE_VALIDPURCHASE"
    TRADE_INVALIDPURCHASE = "TRADE_INVALIDPURCHASE"
    TRADE_HASSALE = "TRADE_HASSALE"
    TRADE_VALIDSALE = "TRADE_VALIDSALE"
    TRADE_INVALIDSALE = "TRADE_INVALIDSALE"
    TRADE_HASPURCHASEORSALE = "TRADE_HASPURCHASEORSALE"
    COMMERCE_ATMENU = "COMMERCE_ATMENU"
    COMMERCE_NOTATMENU = "COMMERCE_NOTATMENU"
    COMMERCE_MENUIS = "COMMERCE_MENUIS"
    COMMERCE_CANPURCHASELICENSE = "COMMERCE_CANPURCHASELICENSE"
    COMMERCE_CANNOTPURCHASELICENSE = "COMMERCE_CANNOTPURCHASELICENSE"
    COMMERCE_LOANGIVERSELECTED = "COMMERCE_LOANGIVERSELECTED"
    COMMERCE_LOANGIVERNOTSELECTED = "COMMERCE_LOANGIVERNOTSELECTED"
    COMMERCE_REPAYINGLOAN = "COMMERCE_REPAYINGLOAN"
    COMMERCE_LOANVALID = "COMMERCE_LOANVALID"
    COMMERCE_LOANINVALID = "COMMERCE_LOANINVALID"
    COMMERCE_REPAYMENTVALID = "COMMERCE_REPAYMENTVALID"
    COMMERCE_REPAYMENTINVALID = "COMMERCE_REPAYMENTINVALID"
    COMMERCE_CANTAKECONTRACT = "COMMERCE_CANTAKECONTRACT"
    COMMERCE_CANNOTTAKECONTRACT = "COMMERCE_CANNOTTAKECONTRACT"
    COMMERCE_CANDELIVERCONTRACT = "COMMERCE_CANDELIVERCONTRACT"
    COMMERCE_CANNOTDELIVERCONTRACT = "COMMERCE_CANNOTDELIVERCONTRACT"
    COMMERCE_CANTAKEPASSENGER = "COMMERCE_CANTAKEPASSENGER"
    COMMERCE_CANNOTTAKEPASSENGER = "COMMERCE_CANNOTTAKEPASSENGER"
    WIRE_VISIBLE = "WIRE_VISIBLE"
    MECHANIC_ATMENU = "MECHANIC_ATMENU"
    MECHANIC_AT = "MECHANIC_AT"
    MECHANIC_CAN_REPAIR = "MECHANIC_CAN_REPAIR"
    MECHANIC_CANNOT_REPAIR = "MECHANIC_CANNOT_REPAIR"
    MECHANIC_CAN_BUY_POD = "MECHANIC_CAN_BUY_POD"
    MECHANIC_CANNOT_BUY_POD = "MECHANIC_CANNOT_BUY_POD"
    MECHANIC_CAN_SELL_POD = "MECHANIC_CAN_SELL_POD"
    MECHANIC_CANNOT_SELL_POD = "MECHANIC_CANNOT_SELL_POD"
    MECHANIC_CAN_UPGRADE_POD = "MECHANIC_CAN_UPGRADE_POD"
    MECHANIC_CANNOT_UPGRADE_POD = "MECHANIC_CANNOT_UPGRADE_POD"
    MECHANIC_CAN_BUY_MODULE = "MECHANIC_CAN_BUY_MODULE"
    MECHANIC_CANNOT_BUY_MODULE = "MECHANIC_CANNOT_BUY_MODULE"
    MECHANIC_CAN_SELL_MODULE = "MECHANIC_CAN_SELL_MODULE"
    MECHANIC_CANNOT_SELL_MODULE = "MECHANIC_CANNOT_SELL_MODULE"
    MECHANIC_CAN_BUY_ARMAMENT = "MECHANIC_CAN_BUY_ARMAMENT"
    MECHANIC_CANNOT_BUY_ARMAMENT = "MECHANIC_CANNOT_BUY_ARMAMENT"
    MECHANIC_CAN_SELL_ARMAMENT = "MECHANIC_CAN_SELL_ARMAMENT"
    MECHANIC_CANNOT_SELL_ARMAMENT = "MECHANIC_CANNOT_SELL_ARMAMENT"
    BUYING_MODULES = "BUYING_MODULES"
    SHIP_CANBUY = "SHIP_CANBUY"
    SHIP_CANNOTBUY = "SHIP_CANNOTBUY"
    MOORED_WRECK_HAS_NOT_DOWNLOADED_DATA = "MOORED_WRECK_HAS_NOT_DOWNLOADED_DATA"
    MOORED_WRECK_HAS_DOWNLOADED_DATA = "MOORED_WRECK_HAS_DOWNLOADED_DATA"
    MOORED_WRECK_HAS_UNCLAMPED_CARGO = "MOORED_WRECK_HAS_UNCLAMPED_CARGO"
    MOORED_WRECK_HAS_NOT_UNCLAMPED_CARGO = "MOORED_WRECK_HAS_NOT_UNCLAMPED_CARGO"
    CAN_BOARD_BROKER_SHIP = "CAN_BOARD_BROKER_SHIP"
    CAN_NOT_BOARD_BROKER_SHIP = "CAN_NOT_BOARD_BROKER_SHIP"
    IS_VIEWING_SELECTED_SHIP = "IS_VIEWING_SELECTED_SHIP"
    IS_NOT_VIEWING_SELECTED_SHIP = "IS_NOT_VIEWING_SELECTED_SHIP"
    HAS_EMAILS_TO_DOWNLOAD = "HAS_EMAILS_TO_DOWNLOAD"
    STARTING_NEW_GAME = "STARTING_NEW_GAME"
    NEW_GAME_OPTIONS = "NEW_GAME_OPTIONS"
    CONVERSATION_ACTIVE = "CONVERSATION_ACTIVE"
    MUSIC_PLAYING = "MUSIC_PLAYING"
    MUSIC_NOT_PLAYING = "MUSIC_NOT_PLAYING"
    CAN_USE_MUSIC = "CAN_USE_MUSIC"
    SOS_ACTIVE = "SOS_ACTIVE"
    SOS_CAN_BE_ACTIVATED = "SOS_CAN_BE_ACTIVATED"
    SHIP_DISABLED = "SHIP_DISABLED"
    COMMERCE_CANTAKEBOUNTY = "COMMERCE_CANTAKEBOUNTY"
    COMMERCE_CANNOTTAKEBOUNTY = "COMMERCE_CANNOTTAKEBOUNTY"
    RESOLUTION_CHANGED = "RESOLUTION_CHANGED"
    CAN_BEGIN_DOCK = "CAN_BEGIN_DOCK"
    CANNOT_BEGIN_DOCK = "CANNOT_BEGIN_DOCK"
    DOCKED_WITH_EARTHGATE = "DOCKED_WITH_EARTHGATE"
    CAN_CHANGE_DETAILS = "CAN_CHANGE_DETAILS"
    CAN_BEGIN_GAME = "CAN_BEGIN_GAME"
    CAN_CONTINUE_GAME = "CAN_CONTINUE_GAME"
    CAN_DELETE_SAVE = "CAN_DELETE_SAVE"
    CAN_CONFIRM_DELETE = "CAN_CONFIRM_DELETE"
    CAN_BEGIN_STORY = "CAN_BEGIN_STORY"
    CAN_JETTISON_COMPONENT = "CAN_JETTISON_COMPONENT"
    CONNECTED_TO_SERVER = "CONNECTED_TO_SERVER"
    CAN_CONNECT_TO_SERVER = "CAN_CONNECT_TO_SERVER"
    CANNOT_CONNECT_TO_SERVER = "CANNOT_CONNECT_TO_SERVER"
    CAN_DISCONNECT_FROM_SERVER = "CAN_DISCONNECT_FROM_SERVER"
    CANNOT_DISCONNECT_FROM_SERVER = "CANNOT_DISCONNECT_FROM_SERVER"
    CAN_SEND_CHAT_MESSAGE = "CAN_SEND_CHAT_MESSAGE"
    CANNOT_SEND_CHAT_MESSAGE = "CANNOT_SEND_CHAT_MESSAGE"
    CAN_SEND_READY_STATE = "CAN_SEND_READY_STATE"
    CAN_REMOVE_READY_STATE = "CAN_REMOVE_READY_STATE"
    CANNOT_SEND_READY_STATE_CHANGE = "CANNOT_SEND_READY_STATE_CHANGE"
    PIRATE_REPORTED = "PIRATE_REPORTED"
    SMUGGLER_DETECTED = "SMUGGLER_DETECTED"
    CAN_TAKE_SHIP = "CAN_TAKE_SHIP"
    CANNOT_TAKE_SHIP = "CANNOT_TAKE_SHIP"


class Numeric:
    POWER_LEVEL = "POWER_LEVEL"
    POWER_LEVEL_PERCENT = "POWER_LEVEL_PERCENT"
    POWER_FLOW = "POWER_FLOW"
    POWER_FLOW_PERCENT = "POWER_FLOW_PERCENT"
    POWER_GENERATION = "POWER_GENERATION"
    POWER_GENERATION_PERCENT = "POWER_GENERATION_PERCENT"
    POWER_DRAIN = "POWER_DRAIN"
    POWER_DRAIN_PERCENT = "POWER_DRAIN_PERCENT"
    DESIRED_DIRECTION = "DESIRED_DIRECTION"
    MOTION_ANGLE = "MOTION_ANGLE"
    DIRECTION = "DIRECTION"
    CURRENT_SPEED = "CURRENT_SPEED"
    CURRENT_SPEED_PERCENT = "CURRENT_SPEED_PERCENT"
    PRESSURE_EXTERIOR = "PRESSURE_EXTERIOR"
    PRESSURE_INTERIOR = "PRESSURE_INTERIOR"
    PRESSURE_AIRLOCK = "PRESSURE_AIRLOCK"
    CURRENT_TEMPERATURE = "CURRENT_TEMPERATURE"
    CURRENT_DISTANCE = "CURRENT_DISTANCE"
    CURRENT_BEARING = "CURRENT_BEARING"
    ASTEROID_DENSITY = "ASTEROID_DENSITY"
    NEBULA_DENSITY = "NEBULA_DENSITY"
    TUBE_SELECTED = "TUBE_SELECTED"
    AMOUNT_OWED_TO_DOCKED = "AMOUNT_OWED_TO_DOCKED"
    AMOUNT_OWED_VIA_COMMS = "AMOUNT_OWED_VIA_COMMS"
    AUTO_REPAIR_PERCENT = "AUTO_REPAIR_PERCENT"
    CURRENT_TUBE_SPIN_UP_PERCENT = "CURRENT_TUBE_SPIN_UP_PERCENT"
    TUBE_SPIN_UP_PERCENT = "TUBE_SPIN_UP_PERCENT"
    ENG_CURRENT_REPAIR_PERCENT = "ENG_CURRENT_REPAIR_PERCENT"
    JMP_SOLUTION = "JMP_SOLUTION"
    MAIN_DRIVE_POWER_LEVEL = "MAIN_DRIVE_POWER_LEVEL"
    HULL_TEMPERATURE = "HULL_TEMPERATURE"
    SOLAR_RADIATION_PERCENT = "SOLAR_RADIATION_PERCENT"
    GRAPPLE_ARM_PERCENTAGE = "GRAPPLE_ARM_PERCENTAGE"
    HACK_PERCENTAGE = "HACK_PERCENTAGE"
    PENDING_EMAILS = "PENDING_EMAILS"
    UNREAD_EMAILS = "UNREAD_EMAILS"
    READ_EMAILS = "READ_EMAILS"
    PLAYER_CREDITS = "PLAYER_CREDITS"


ALL_COMMANDS = [
    "_TOGGLE",
    "BURN_MAIN_ENGINE",
    "STOP_MAIN_ENGINE",
    "TOGGLE_MAIN_ENGINE",
    "PLOT_COURSE",
    "CLEAR_COURSE",
    "REMOVE_LAST_WAYPOINT",
    "MAP_MOVE_LEFT",
    "MAP_MOVE_RIGHT",
    "MAP_MOVE_UP",
    "MAP_MOVE_DOWN",
    "MAP_ZOOM_IN",
    "MAP_ZOOM_OUT",
    "MAP_CENTER",
    "ENGAGE_COURSE",
    "FULL_STOP",
    "FIRE_RCS_CW",
    "FIRE_RCS_CCW",
    "STOP_RCS",
    "EMCON_ON",
    "EMCON_OFF",
    "CANCEL_AUTOPILOT",
    "DOCK",
    "UNDOCK",
    "SELECT_TUBE",
    "DESELECT_TUBE",
    "SPIN_UP_WEAPON",
    "POWER_DOWN_WEAPON",
    "FIRE_WEAPON",
    "SET_WEAPON_TARGET",
    "UNLINK_WEAPON",
    "ARM_WEAPON",
    "DISABLE_WEAPON",
    "ROTATE",
    "TOGGLE_EMCON",
    "TOGGLE_MAP_MODE",
    "BREAK_ORBIT",
    "CHANGE_TO_STANDARD_ORBIT",
    "CHANGE_TO_HIGH_ORBIT",
    "CHANGE_TO_POLAR_ORBIT",
    "REQUEST_DOCKING_PERMISSION",
    "REQUEST_UNDOCKING_PERMISSION",
    "TURN_ON_IFF",
    "TURN_OFF_IFF",
    "TOGGLE_IFF",
    "LEAVE_SHIP",
    "COMMUNICATE_WITH_SELECTED",
    "RESCIND_DOCKING_PERMISSION",
    "RESCIND_UNDOCKING_PERMISSION",
    "PAY_DOCKED_STATION",
    "ACTIVATE_JUMPGATE",
    "PAY_FOR_JUMPGATE",
    "SELECT_TUBE1",
    "SELECT_TUBE2",
    "SELECT_TUBE3",
    "SELECT_TUBE4",
    "SELECT_TUBE5",
    "MAP_CLICK",
    "ENG_DISCONNECT_CURRENT_MODULE",
    "ENG_CONNECT_CURRENT_MODULE",
    "ENG_OPEN_CURRENT_MODULE",
    "ENG_CLOSE_CURRENT_MODULE",
    "ENG_REPAIR_CURRENT_COMPONENT",
    "JMP_SET_JUMP_DESTINATION",
    "JMP_SPIN_UP_JUMP_DRIVE",
    "JMP_CALCULATE_JUMP_SOLUTION",
    "JMP_BEGIN_JUMP",
    "JMP_DISCHARGE_JUMP_DRIVE",
    "PWR_TOGGLE_CURRENT_MODULE_EMCON",
    "PWR_TOGGLE_CURRENT_MODULE_POWER",
    "PWR_RAISE_PRIORITY",
    "PWR_LOWER_PRIORITY",
    "SCRAM_REACTOR",
    "POWER_UP_REACTOR",
    "TOGGLE_REACTOR",
    "PWR_DISCONNECT_HELM",
    "PWR_CONNECT_HELM",
    "PWR_TOGGLE_HELM",
    "PWR_DISCONNECT_RCS",
    "PWR_CONNECT_RCS",
    "PWR_TOGGLE_RCS",
    "PWR_DISCONNECT_MAINDRIVE",
    "PWR_CONNECT_MAINDRIVE",
    "PWR_TOGGLE_MAINDRIVE",
    "PWR_DISCONNECT_COMMS",
    "PWR_CONNECT_COMMS",
    "PWR_TOGGLE_COMMS",
    "PWR_DISCONNECT_WEAP",
    "PWR_CONNECT_WEAP",
    "PWR_TOGGLE_WEAP",
    "PWR_DISCONNECT_JUMPDRIVE",
    "PWR_CONNECT_JUMPDRIVE",
    "PWR_TOGGLE_JUMPDRIVE",
    "PWR_DISCONNECT_BATT1",
    "PWR_CONNECT_BATT1",
    "PWR_TOGGLE_BATT1",
    "PWR_DISCONNECT_BATT2",
    "PWR_CONNECT_BATT2",
    "PWR_TOGGLE_BATT2",
    "PWR_DISCONNECT_BATT3",
    "PWR_CONNECT_BATT3",
    "PWR_TOGGLE_BATT3",
    "PWR_DISCONNECT_NAVCOM",
    "PWR_CONNECT_NAVCOM",
    "PWR_TOGGLE_NAVCOM",
    "PWR_DISCONNECT_SENS",
    "PWR_CONNECT_SENS",
    "PWR_TOGGLE_SENS",
    "TURN_ON_SHIP",
    "TURN_OFF_SHIP",
    "TELEPORT",
    "SENSOR_SELECT_DOWN",
    "SENSOR_SELECT_UP",
    "SENSOR_SELECT_RIGHT",
    "SENSOR_SELECT_LEFT",
    "SENSOR_SELECT_TAB",
    "SENSOR_SET_NAV_AND_SENSOR_LINKED",
    "SENSOR_UNSET_NAV_AND_SENSOR_LINKED",
    "SENSOR_SET_HISTORY_LOCKED",
    "SENSOR_UNSET_HISTORY_LOCKED",
    "SENSOR_SET_AUTO",
    "SENSOR_UNSET_AUTO",
    "PWR_SELECT_MODULE",
    "ENG_SELECT_MODULE",
    "ENG_SELECT_COMPONENT",
    "ENG_MOUNT_COMPONENT",
    "ENG_MOVE_COMPONENT",
    "ENG_UNMOUNT_COMPONENT",
    "ENG_TOGGLE_SCREW",
    "ENG_TOGGLE_SHIELD",
    "SELECT_COMPONENT_INV",
    "HELM_SET_ATAC_MODE",
    "HELM_UNSET_ATAC_MODE",
    "ENABLE_LADAR",
    "DISABLE_LADAR",
    "TOGGLE_LADAR",
    "MAIN_DRIVE_POWER_INCREASE",
    "MAIN_DRIVE_POWER_DECREASE",
    "PWR_POWER_INCREASE",
    "PWR_POWER_DECREASE",
    "ACTIVATE_PDS",
    "DEACTIVATE_PDS",
    "TOGGLE_PDS",
    "FIRE_CM",
    "COMMS_SYNC",
    "COMMS_TURN_ON_AUTO",
    "COMMS_TURN_OFF_AUTO",
    "SHIP_CARGO_DOWN",
    "SHIP_CARGO_UP",
    "JETTISON_CARGO",
    "JETTISON_ALL",
    "MOORED_CARGO_DOWN",
    "MOORED_CARGO_UP",
    "TRANSFER_CARGO_FROM_MOORED",
    "TRANSFER_CARGO_FROM_SHIP",
    "HACK",
    "REPAIR_HULL_AT_DEPOT",
    "REPAIR_MODULES_AT_DEPOT",
    "REARM_AT_DEPOT",
    "BUY_CM_AT_DEPOT",
    "TUTORIAL_JUMP",
    "TRADE_TOMAX",
    "TRADE_PERFORM",
    "TRADE_CANCEL",
    "COMMERCE_MENU",
    "COMMERCE_GETLICENSE",
    "COMMERCE_TAKELOAN",
    "COMMERCE_REPAYLOAN",
    "COMMERCE_TAKECONTRACT",
    "COMMERCE_DELIVERCONTRACT",
    "VIEW_WIRE",
    "MECHANIC_TOMENU",
    "MECHANIC_REPAIR",
    "MECHANIC_BUY_POD",
    "MECHANIC_SELL_POD",
    "MECHANIC_UPGRADE_POD",
    "MECHANIC_CANCELMODULE",
    "MECHANIC_MODULETRANSACTION",
    "MECHANIC_BUYARMAMENT",
    "MECHANIC_SELLARMAMENT",
    "BUY_SHIP",
    "MOORED_WRECK_UNLOCK_CARGO",
    "MOORED_WRECK_DOWNLOAD_DATA",
    "SET_VIEW_SHIP",
    "BOARD_BROKER_SHIP",
    "TAKE_PASSENGER",
    "TURN_ON_SOS",
    "TURN_OFF_SOS",
    "NEXT_TRACK",
    "PREV_TRACK",
    "PAUSE_TRACK",
    "RESUME_TRACK",
    "TAKE_BOUNTY",
    "QUIT_TO_MENU",
    "QUIT_TO_OS",
    "ROOM_LEFT",
    "ROOM_RIGHT",
    "TOGGLE_TABLET",
    "SWITCH_TABS",
    "TIME_SLOWER",
    "TIME_FASTER",
    "CHANGE_DETAILS",
    "BEGIN_GAME",
    "DELETE_SAVE",
    "JETTISON_COMPONENT",
    "MOVE_MODULE",
    "SWITCH_TO_MENU",
    "CONNECT_TO_SERVER",
    "DISCONNECT_FROM_SERVER",
    "SEND_CHAT_MESSAGE",
    "ALTER_SERVER_SETTING",
    "SEND_SERVER_COMMAND",
    "MOVE_CARGO",
    "SEND_READY_STATE",
]
