"""
OdeCloud Python SDK

Official Python client for the OdeCloud API.
"""

from odecloud.client import OdeCloud, AsyncOdeCloud
from odecloud.exceptions import (
    OdeCloudError,
    AuthenticationError,
    RateLimitError,
    NotFoundError,
    ValidationError,
)
from odecloud.models.time_entries import (
    TimeEntry,
    TimeEntryCreate,
    TimeEntryUpdate,
    TimeEntrySummary,
)
from odecloud.models.projects import Project, ProjectDetail, Task
from odecloud.models.profile import Profile, ProfileUpdate, SocialLinks, WorkExperience

__version__ = "0.1.0"

__all__ = [
    # Client
    "OdeCloud",
    "AsyncOdeCloud",
    # Exceptions
    "OdeCloudError",
    "AuthenticationError",
    "RateLimitError",
    "NotFoundError",
    "ValidationError",
    # Time Entry Models
    "TimeEntry",
    "TimeEntryCreate",
    "TimeEntryUpdate",
    "TimeEntrySummary",
    # Project Models
    "Project",
    "ProjectDetail",
    "Task",
    # Profile Models
    "Profile",
    "ProfileUpdate",
    "SocialLinks",
    "WorkExperience",
]
