"""
Organization/client models for OdeCloud API.
"""

from datetime import datetime
from typing import Optional

from pydantic import BaseModel, Field


class Org(BaseModel):
    """An organization (client)."""

    id: str = Field(..., alias="_id")
    name: str
    tagline: Optional[str] = None
    website: Optional[str] = None
    description: Optional[str] = None
    is_active: bool = Field(default=True, alias="isActive")
    created_at: Optional[datetime] = Field(default=None, alias="createdAt")
    updated_at: Optional[datetime] = Field(default=None, alias="updatedAt")

    class Config:
        populate_by_name = True
