from __future__ import annotations
from typing import Any, Dict
from omnibioai_tool_exec.execution.adapters.base import Adapter
from omnibioai_tool_exec.models.capabilities import ServerCapabilities

class AwsBatchAdapter(Adapter):
    def __init__(self, config: Dict[str, Any]) -> None:
        self.config = config

    def adapter_type(self) -> str:
        return "aws_batch"

    def handshake(self) -> ServerCapabilities:
        raise NotImplementedError

    def validate(self, tool_id: str, inputs: Dict[str, Any], resources: Dict[str, Any]) -> Dict[str, Any]:
        raise NotImplementedError

    def submit(self, tool_id: str, inputs: Dict[str, Any], resources: Dict[str, Any]) -> str:
        raise NotImplementedError

    def status(self, remote_run_id: str) -> Dict[str, Any]:
        raise NotImplementedError

    def logs(self, remote_run_id: str, tail: int = 200) -> str:
        raise NotImplementedError

    def results(self, remote_run_id: str) -> Dict[str, Any]:
        raise NotImplementedError

