from __future__ import annotations
from abc import ABC, abstractmethod
from typing import Any, Dict
from omnibioai_tool_exec.models.capabilities import ServerCapabilities


class Adapter(ABC):
    @abstractmethod
    def adapter_type(self) -> str: ...

    @abstractmethod
    def handshake(self) -> ServerCapabilities: ...

    @abstractmethod
    def validate(self, tool_id: str, inputs: Dict[str, Any], resources: Dict[str, Any]) -> Dict[str, Any]: ...

    @abstractmethod
    def submit(self, tool_id: str, inputs: Dict[str, Any], resources: Dict[str, Any]) -> str: ...

    @abstractmethod
    def status(self, remote_run_id: str) -> Dict[str, Any]: ...

    @abstractmethod
    def logs(self, remote_run_id: str, tail: int = 200) -> str: ...

    @abstractmethod
    def results(self, remote_run_id: str) -> Dict[str, Any]: ...

    def cancel(self, remote_run_id: str) -> None:
        raise NotImplementedError

