from __future__ import annotations
from typing import Any, Dict, Optional
from pydantic import BaseModel, Field
from omnibioai_tool_exec.models.capabilities import ServerCapabilities


class ServerSpec(BaseModel):
    server_id: str = Field(..., pattern=r"^[a-z0-9_]+$")
    display_name: str
    adapter_type: str
    config: Dict[str, Any] = Field(default_factory=dict)

    # Optional cached capabilities
    capabilities: Optional[ServerCapabilities] = None
    capabilities_last_refreshed_epoch: Optional[int] = None

