from __future__ import annotations
from fastapi import APIRouter
from omnibioai_tool_exec.registry.tool_registry import ToolRegistry

router = APIRouter()

def attach(tool_registry: ToolRegistry) -> APIRouter:
    @router.get("/tools")
    def list_tools():
        return [t.model_dump() for t in tool_registry.list()]
    return router

