from __future__ import annotations
import argparse
import uvicorn
from omnibioai_tool_exec.service.app import create_app


def main() -> None:
    parser = argparse.ArgumentParser(prog="omnibioai-tes")
    sub = parser.add_subparsers(dest="cmd", required=True)

    serve = sub.add_parser("serve", help="Run the Tool Execution Service")
    serve.add_argument("--host", default="127.0.0.1")
    serve.add_argument("--port", default=8080, type=int)
    serve.add_argument("--tools", required=True, help="Path to tools.yaml")
    serve.add_argument("--servers", required=True, help="Path to servers.yaml")
    serve.add_argument("--reload", action="store_true", help="Enable auto-reload (dev)")

    args = parser.parse_args()

    if args.cmd == "serve":
        app = create_app(tools_path=args.tools, servers_path=args.servers)
        uvicorn.run(app, host=args.host, port=args.port, reload=args.reload)

