from __future__ import annotations
from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field


class ToolSpec(BaseModel):
    tool_id: str = Field(..., pattern=r"^[a-z0-9_]+$")
    display_name: str
    description: Optional[str] = None

    # Keep JSON schema-ish for now (you can evolve to full JSONSchema later)
    inputs_schema: Dict[str, Any] = Field(default_factory=dict)
    outputs_schema: Dict[str, Any] = Field(default_factory=dict)

    # Router constraints
    requires: Dict[str, Any] = Field(default_factory=dict)
    tags: List[str] = Field(default_factory=list)

