from __future__ import annotations
from pathlib import Path
from typing import Any, Dict, List
import yaml

from omnibioai_tool_exec.models.tool_spec import ToolSpec
from omnibioai_tool_exec.models.server_spec import ServerSpec


def _load_yaml(path: str | Path) -> Dict[str, Any]:
    p = Path(path)
    data = yaml.safe_load(p.read_text())
    return data or {}


def load_tools(path: str | Path) -> List[ToolSpec]:
    data = _load_yaml(path)
    return [ToolSpec(**t) for t in data.get("tools", [])]


def load_servers(path: str | Path) -> List[ServerSpec]:
    data = _load_yaml(path)
    return [ServerSpec(**s) for s in data.get("servers", [])]

