from __future__ import annotations
import time
from typing import Dict

from omnibioai_tool_exec.models.run_models import RunRecord
from omnibioai_tool_exec.execution.adapters.base import Adapter


class Runner:
    def __init__(self, adapters: Dict[str, Adapter]) -> None:
        self.adapters = adapters

    def get_adapter(self, adapter_type: str) -> Adapter:
        if adapter_type not in self.adapters:
            raise KeyError(f"adapter not registered: {adapter_type}")
        return self.adapters[adapter_type]

    def refresh_status(self, adapter: Adapter, rec: RunRecord) -> RunRecord:
        st = adapter.status(rec.remote_run_id or "")
        now = int(time.time())
        state = st.get("state", rec.state)

        if state in ("QUEUED", "RUNNING", "COMPLETED", "FAILED", "CANCELLED"):
            rec.state = state  # type: ignore
        rec.updated_epoch = now  # type: ignore
        return rec

