from __future__ import annotations
from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field


class ToolCapability(BaseModel):
    tool_id: str
    version: Optional[str] = None
    features: Dict[str, Any] = Field(default_factory=dict)


class ServerCapabilities(BaseModel):
    engines: List[str] = Field(default_factory=list)
    tools: List[ToolCapability] = Field(default_factory=list)

    resources: Dict[str, Any] = Field(default_factory=dict)
    storage: Dict[str, Any] = Field(default_factory=dict)
    policies: Dict[str, Any] = Field(default_factory=dict)

    def tool_map(self) -> Dict[str, ToolCapability]:
        return {t.tool_id: t for t in self.tools}

