from __future__ import annotations
from typing import Dict, List
from omnibioai_tool_exec.models.run_models import RunRecord


class RunStore:
    """
    MVP in-memory store. Swap with Postgres/Redis later without changing APIs.
    """
    def __init__(self) -> None:
        self._runs: Dict[str, RunRecord] = {}

    def create(self, rec: RunRecord) -> None:
        self._runs[rec.run_id] = rec

    def get(self, run_id: str) -> RunRecord:
        if run_id not in self._runs:
            raise KeyError(f"run not found: {run_id}")
        return self._runs[run_id]

    def update(self, rec: RunRecord) -> None:
        self._runs[rec.run_id] = rec

    def list(self) -> List[RunRecord]:
        return list(self._runs.values())

