from __future__ import annotations
import time
from fastapi import APIRouter

from omnibioai_tool_exec.registry.server_registry import ServerRegistry
from omnibioai_tool_exec.execution.runner import Runner

router = APIRouter()

def attach(server_registry: ServerRegistry, runner: Runner) -> APIRouter:
    @router.get("/servers")
    def list_servers():
        return [s.model_dump() for s in server_registry.list()]

    @router.post("/servers/{server_id}/refresh_capabilities")
    def refresh_capabilities(server_id: str):
        srv = server_registry.get(server_id)
        adapter = runner.get_adapter(srv.adapter_type)
        caps = adapter.handshake()
        srv.capabilities = caps
        srv.capabilities_last_refreshed_epoch = int(time.time())
        server_registry.register(srv)
        return {"ok": True, "server_id": server_id, "capabilities": caps.model_dump()}

    return router

