from __future__ import annotations
from typing import Dict, List
from omnibioai_tool_exec.models.server_spec import ServerSpec


class ServerRegistry:
    def __init__(self) -> None:
        self._servers: Dict[str, ServerSpec] = {}

    def register(self, spec: ServerSpec) -> None:
        self._servers[spec.server_id] = spec

    def get(self, server_id: str) -> ServerSpec:
        if server_id not in self._servers:
            raise KeyError(f"server not found: {server_id}")
        return self._servers[server_id]

    def list(self) -> List[ServerSpec]:
        return list(self._servers.values())

