from __future__ import annotations

import time
import pytest

from omnibioai_tool_exec.models.run_models import RunRecord
from omnibioai_tool_exec.store import RunStore


def test_run_store_crud():
    store = RunStore()
    now = int(time.time())

    rec = RunRecord(
        run_id="run_1",
        tool_id="echo_test",
        server_id="local_demo",
        state="QUEUED",
        created_epoch=now,
        updated_epoch=now,
        inputs={"message": "hi"},
        resources={"cpu": 1},
    )

    store.create(rec)
    got = store.get("run_1")
    assert got.run_id == "run_1"

    rec.state = "COMPLETED"
    store.update(rec)
    got2 = store.get("run_1")
    assert got2.state == "COMPLETED"

    assert len(store.list()) == 1


def test_run_store_missing_raises():
    store = RunStore()
    with pytest.raises(KeyError):
        store.get("missing")
