from __future__ import annotations


def test_health(client):
    r = client.get("/health")
    assert r.status_code == 200
    assert r.json()["ok"] is True


def test_list_tools(client):
    r = client.get("/api/tools")
    assert r.status_code == 200
    tools = r.json()
    assert isinstance(tools, list)
    tool_ids = {t["tool_id"] for t in tools}
    # from configs/tools.example.yaml
    assert "blastn" in tool_ids
    assert "echo_test" in tool_ids
