from __future__ import annotations
from typing import Dict, List
from omnibioai_tool_exec.models.tool_spec import ToolSpec


class ToolRegistry:
    def __init__(self) -> None:
        self._tools: Dict[str, ToolSpec] = {}

    def register(self, spec: ToolSpec) -> None:
        self._tools[spec.tool_id] = spec

    def get(self, tool_id: str) -> ToolSpec:
        if tool_id not in self._tools:
            raise KeyError(f"tool not found: {tool_id}")
        return self._tools[tool_id]

    def list(self) -> List[ToolSpec]:
        return list(self._tools.values())

