from __future__ import annotations
from typing import Any, Dict, List, Literal, Optional
from pydantic import BaseModel, Field

RunState = Literal["CREATED", "VALIDATED", "QUEUED", "RUNNING", "COMPLETED", "FAILED", "CANCELLED"]


class RunRequest(BaseModel):
    tool_id: str
    inputs: Dict[str, Any] = Field(default_factory=dict)
    resources: Dict[str, Any] = Field(default_factory=dict)
    constraints: Dict[str, Any] = Field(default_factory=dict)  # preferred_server_id, etc.


class ValidationReport(BaseModel):
    ok: bool
    errors: List[Dict[str, Any]] = Field(default_factory=list)
    warnings: List[Dict[str, Any]] = Field(default_factory=list)
    selected_server_id: Optional[str] = None
    per_server: Dict[str, Any] = Field(default_factory=dict)


class RunRecord(BaseModel):
    run_id: str
    tool_id: str
    server_id: str
    state: RunState
    created_epoch: int
    updated_epoch: int

    inputs: Dict[str, Any] = Field(default_factory=dict)
    resources: Dict[str, Any] = Field(default_factory=dict)

    remote_run_id: Optional[str] = None
    exit_code: Optional[int] = None
    error: Optional[Dict[str, Any]] = None

    results: Dict[str, Any] = Field(default_factory=dict)

