# coding: utf-8

"""
    Oneloop API

    API Key Management

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, StrictStr, conlist
from oneloop_client.models.api_key_scope import ApiKeyScope

class VerifyApiKeyRequest(BaseModel):
    """
    VerifyApiKeyRequest
    """
    workspace_id: StrictStr = Field(default=..., alias="workspaceId")
    key: StrictStr = Field(...)
    requested_scopes: conlist(ApiKeyScope) = Field(default=..., alias="requestedScopes")
    __properties = ["workspaceId", "key", "requestedScopes"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> VerifyApiKeyRequest:
        """Create an instance of VerifyApiKeyRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in requested_scopes (list)
        _items = []
        if self.requested_scopes:
            for _item in self.requested_scopes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['requestedScopes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> VerifyApiKeyRequest:
        """Create an instance of VerifyApiKeyRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return VerifyApiKeyRequest.parse_obj(obj)

        _obj = VerifyApiKeyRequest.parse_obj({
            "workspace_id": obj.get("workspaceId"),
            "key": obj.get("key"),
            "requested_scopes": [ApiKeyScope.from_dict(_item) for _item in obj.get("requestedScopes")] if obj.get("requestedScopes") is not None else None
        })
        return _obj


