# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic.v1 as pydantic

from ..core.datetime_utils import serialize_datetime
from .api_key_scope import ApiKeyScope


class ApiKey(pydantic.BaseModel):
    id: str
    name: str
    masked_key: str = pydantic.Field(alias="maskedKey")
    prefix: typing.Optional[str] = None
    expires_at: typing.Optional[int] = pydantic.Field(alias="expiresAt", default=None)
    total_usage_left: typing.Optional[int] = pydantic.Field(alias="totalUsageLeft", default=None)
    limit_usage: bool = pydantic.Field(alias="limitUsage")
    scopes: typing.List[ApiKeyScope]
    enabled: bool
    customer_id: typing.Optional[str] = pydantic.Field(alias="customerId", default=None)
    deleted: bool
    created_at: str = pydantic.Field(alias="createdAt")
    updated_at: str = pydantic.Field(alias="updatedAt")
    last_used_at: typing.Optional[str] = pydantic.Field(alias="lastUsedAt", default=None)

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
