# This file was auto-generated by Fern from our API Definition.

import typing
import urllib.parse
from json.decoder import JSONDecodeError

import httpx

from .core.api_error import ApiError
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .core.jsonable_encoder import jsonable_encoder
from .environment import OneloopApiEnvironment
from .errors.bad_request_error import BadRequestError
from .errors.forbidden_error import ForbiddenError
from .errors.unauthorized_error import UnauthorizedError
from .types.api_key_scope import ApiKeyScope
from .types.create_api_key_request_scopes_item import CreateApiKeyRequestScopesItem
from .types.create_api_key_response import CreateApiKeyResponse
from .types.create_workspace_response import CreateWorkspaceResponse
from .types.create_workspace_scope_response import CreateWorkspaceScopeResponse
from .types.delete_api_key_response import DeleteApiKeyResponse
from .types.edit_api_key_response import EditApiKeyResponse
from .types.error_response import ErrorResponse
from .types.generate_link_token_response import GenerateLinkTokenResponse
from .types.get_billing_usage_response import GetBillingUsageResponse
from .types.refill_api_key_response import RefillApiKeyResponse
from .types.retrieve_all_workspace_scopes_response import RetrieveAllWorkspaceScopesResponse
from .types.retrieve_api_key_by_id_response import RetrieveApiKeyByIdResponse
from .types.retrieve_api_keys_response import RetrieveApiKeysResponse
from .types.retrieve_workspace_by_id_response import RetrieveWorkspaceByIdResponse
from .types.retrieve_workspace_response import RetrieveWorkspaceResponse
from .types.rotate_api_key_response import RotateApiKeyResponse
from .types.update_workspace_response import UpdateWorkspaceResponse
from .types.validate_link_token_response import ValidateLinkTokenResponse
from .types.verify_api_key_request_billing import VerifyApiKeyRequestBilling
from .types.verify_api_key_request_rate_limit_config import VerifyApiKeyRequestRateLimitConfig
from .types.verify_api_key_response import VerifyApiKeyResponse

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class OneloopApi:
    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: OneloopApiEnvironment = OneloopApiEnvironment.DEFAULT,
        token: typing.Union[str, typing.Callable[[], str]],
        timeout: typing.Optional[float] = 60,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            token=token,
            httpx_client=httpx.Client(timeout=timeout) if httpx_client is None else httpx_client,
        )

    def get_workspace(self) -> RetrieveWorkspaceResponse:
        """
        from oneloop.client import OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.get_workspace()
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/v1/workspace"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(RetrieveWorkspaceResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_workspace(self, *, name: str) -> CreateWorkspaceResponse:
        """
        Parameters:
            - name: str.
        ---
        from oneloop.client import OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.create_workspace(
            name="name",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/v1/workspace"),
            json=jsonable_encoder({"name": name}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(CreateWorkspaceResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_workspace_by_id(self, id: str) -> RetrieveWorkspaceByIdResponse:
        """
        Parameters:
            - id: str.
        ---
        from oneloop.client import OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.get_workspace_by_id(
            id="id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/v1/workspace/{id}"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(RetrieveWorkspaceByIdResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update_workspace(
        self,
        id: str,
        *,
        default_key_prefix: typing.Optional[str] = OMIT,
        default_allowed_i_ps: typing.List[str],
        default_rate_limit_per_second: typing.Optional[int] = OMIT,
        default_expiration: typing.Optional[int] = OMIT,
    ) -> UpdateWorkspaceResponse:
        """
        Parameters:
            - id: str.

            - default_key_prefix: typing.Optional[str].

            - default_allowed_i_ps: typing.List[str].

            - default_rate_limit_per_second: typing.Optional[int].

            - default_expiration: typing.Optional[int].
        ---
        from oneloop.client import OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.update_workspace(
            id="id",
            default_allowed_i_ps=["defaultAllowedIPs"],
        )
        """
        _request: typing.Dict[str, typing.Any] = {"defaultAllowedIPs": default_allowed_i_ps}
        if default_key_prefix is not OMIT:
            _request["defaultKeyPrefix"] = default_key_prefix
        if default_rate_limit_per_second is not OMIT:
            _request["defaultRateLimitPerSecond"] = default_rate_limit_per_second
        if default_expiration is not OMIT:
            _request["defaultExpiration"] = default_expiration
        _response = self._client_wrapper.httpx_client.request(
            "PATCH",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/v1/workspace/{id}"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(UpdateWorkspaceResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_workspace_scopes(self, id: str) -> RetrieveAllWorkspaceScopesResponse:
        """
        Parameters:
            - id: str.
        ---
        from oneloop.client import OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.get_workspace_scopes(
            id="id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/v1/workspace/{id}/scopes"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(RetrieveAllWorkspaceScopesResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_workspace_scopes(
        self, id: str, *, name: str, representation: str, description: typing.Optional[str] = OMIT
    ) -> CreateWorkspaceScopeResponse:
        """
        Parameters:
            - id: str.

            - name: str.

            - representation: str.

            - description: typing.Optional[str].
        ---
        from oneloop.client import OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.create_workspace_scopes(
            id="id",
            name="name",
            representation="representation",
        )
        """
        _request: typing.Dict[str, typing.Any] = {"name": name, "representation": representation}
        if description is not OMIT:
            _request["description"] = description
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/v1/workspace/{id}/scope"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(CreateWorkspaceScopeResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_api_key(
        self,
        *,
        name: str,
        workspace_id: str,
        prefix: typing.Optional[str] = OMIT,
        expires_at: typing.Optional[int] = OMIT,
        total_usage_allowed: typing.Optional[int] = OMIT,
        scopes: typing.List[CreateApiKeyRequestScopesItem],
        enabled: bool,
        customer_id: str,
    ) -> CreateApiKeyResponse:
        """
        Parameters:
            - name: str.

            - workspace_id: str.

            - prefix: typing.Optional[str].

            - expires_at: typing.Optional[int].

            - total_usage_allowed: typing.Optional[int].

            - scopes: typing.List[CreateApiKeyRequestScopesItem].

            - enabled: bool.

            - customer_id: str.
        ---
        from oneloop import CreateApiKeyRequestScopesItem
        from oneloop.client import OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.create_api_key(
            name="name",
            workspace_id="workspaceId",
            scopes=[
                CreateApiKeyRequestScopesItem(
                    representation="representation",
                    create=True,
                    read=True,
                    update=True,
                    del_=True,
                )
            ],
            enabled=True,
            customer_id="customerId",
        )
        """
        _request: typing.Dict[str, typing.Any] = {
            "name": name,
            "workspaceId": workspace_id,
            "scopes": scopes,
            "enabled": enabled,
            "customerId": customer_id,
        }
        if prefix is not OMIT:
            _request["prefix"] = prefix
        if expires_at is not OMIT:
            _request["expiresAt"] = expires_at
        if total_usage_allowed is not OMIT:
            _request["totalUsageAllowed"] = total_usage_allowed
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/v1/api-key"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(CreateApiKeyResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_api_keys(self, id: str) -> RetrieveApiKeysResponse:
        """
        Parameters:
            - id: str.
        ---
        from oneloop.client import OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.get_api_keys(
            id="id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/v1/workspace/{id}/api-key"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(RetrieveApiKeysResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_api_key_by_id(self, id: str, akid: str) -> RetrieveApiKeyByIdResponse:
        """
        Parameters:
            - id: str.

            - akid: str.
        ---
        from oneloop.client import OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.get_api_key_by_id(
            id="id",
            akid="akid",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/v1/workspace/{id}/api-key/{akid}"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(RetrieveApiKeyByIdResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def delete_api_key(self, id: str, akid: str) -> DeleteApiKeyResponse:
        """
        Parameters:
            - id: str.

            - akid: str.
        ---
        from oneloop.client import OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.delete_api_key(
            id="id",
            akid="akid",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/v1/workspace/{id}/api-key/{akid}"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DeleteApiKeyResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def edit_api_key(
        self,
        id: str,
        akid: str,
        *,
        name: typing.Optional[str] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        scopes: typing.Optional[typing.List[ApiKeyScope]] = OMIT,
    ) -> EditApiKeyResponse:
        """
        Parameters:
            - id: str.

            - akid: str.

            - name: typing.Optional[str].

            - enabled: typing.Optional[bool].

            - scopes: typing.Optional[typing.List[ApiKeyScope]].
        ---
        from oneloop.client import OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.edit_api_key(
            id="id",
            akid="akid",
        )
        """
        _request: typing.Dict[str, typing.Any] = {}
        if name is not OMIT:
            _request["name"] = name
        if enabled is not OMIT:
            _request["enabled"] = enabled
        if scopes is not OMIT:
            _request["scopes"] = scopes
        _response = self._client_wrapper.httpx_client.request(
            "PATCH",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/v1/workspace/{id}/api-key/{akid}"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(EditApiKeyResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def verify_api_key(
        self,
        *,
        key: str,
        requested_scopes: typing.List[ApiKeyScope],
        route: typing.Optional[str] = OMIT,
        billing: typing.Optional[VerifyApiKeyRequestBilling] = OMIT,
        rate_limit_config: typing.Optional[VerifyApiKeyRequestRateLimitConfig] = OMIT,
    ) -> VerifyApiKeyResponse:
        """
        Parameters:
            - key: str.

            - requested_scopes: typing.List[ApiKeyScope].

            - route: typing.Optional[str].

            - billing: typing.Optional[VerifyApiKeyRequestBilling].

            - rate_limit_config: typing.Optional[VerifyApiKeyRequestRateLimitConfig].
        ---
        from oneloop import ApiKeyScope
        from oneloop.client import OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.verify_api_key(
            key="key",
            requested_scopes=[
                ApiKeyScope(
                    representation="representation",
                    create=True,
                    read=True,
                    update=True,
                    del_=True,
                )
            ],
        )
        """
        _request: typing.Dict[str, typing.Any] = {"key": key, "requestedScopes": requested_scopes}
        if route is not OMIT:
            _request["route"] = route
        if billing is not OMIT:
            _request["billing"] = billing
        if rate_limit_config is not OMIT:
            _request["rateLimitConfig"] = rate_limit_config
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/v1/api-key/verify"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(VerifyApiKeyResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def rotate_api_key(self, id: str, akid: str) -> RotateApiKeyResponse:
        """
        Parameters:
            - id: str.

            - akid: str.
        ---
        from oneloop.client import OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.rotate_api_key(
            id="id",
            akid="akid",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"api/v1/workspace/{id}/api-key/{akid}/rotate"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(RotateApiKeyResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def refill_api_key(self, id: str, akid: str, *, amount: int) -> RefillApiKeyResponse:
        """
        Parameters:
            - id: str.

            - akid: str.

            - amount: int.
        ---
        from oneloop.client import OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.refill_api_key(
            id="id",
            akid="akid",
            amount=1,
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"api/v1/workspace/{id}/api-key/{akid}/refill"
            ),
            json=jsonable_encoder({"amount": amount}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(RefillApiKeyResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def generate_link_token(self, *, customer_id: str, workspace_id: str) -> GenerateLinkTokenResponse:
        """
        Parameters:
            - customer_id: str.

            - workspace_id: str.
        ---
        from oneloop.client import OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.generate_link_token(
            customer_id="customerId",
            workspace_id="workspaceId",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/v1/link-token"),
            json=jsonable_encoder({"customerId": customer_id, "workspaceId": workspace_id}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(GenerateLinkTokenResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def validate_link_token(self, token: str) -> ValidateLinkTokenResponse:
        """
        Parameters:
            - token: str.
        ---
        from oneloop.client import OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.validate_link_token(
            token="token",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/v1/link-token/{token}"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(ValidateLinkTokenResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_billing_usage(self, bid: str) -> GetBillingUsageResponse:
        """
        Parameters:
            - bid: str.
        ---
        from oneloop.client import OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.get_billing_usage(
            bid="bid",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/v1/usage/{bid}"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(GetBillingUsageResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncOneloopApi:
    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: OneloopApiEnvironment = OneloopApiEnvironment.DEFAULT,
        token: typing.Union[str, typing.Callable[[], str]],
        timeout: typing.Optional[float] = 60,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            token=token,
            httpx_client=httpx.AsyncClient(timeout=timeout) if httpx_client is None else httpx_client,
        )

    async def get_workspace(self) -> RetrieveWorkspaceResponse:
        """
        from oneloop.client import AsyncOneloopApi

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )
        await client.get_workspace()
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/v1/workspace"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(RetrieveWorkspaceResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_workspace(self, *, name: str) -> CreateWorkspaceResponse:
        """
        Parameters:
            - name: str.
        ---
        from oneloop.client import AsyncOneloopApi

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )
        await client.create_workspace(
            name="name",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/v1/workspace"),
            json=jsonable_encoder({"name": name}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(CreateWorkspaceResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_workspace_by_id(self, id: str) -> RetrieveWorkspaceByIdResponse:
        """
        Parameters:
            - id: str.
        ---
        from oneloop.client import AsyncOneloopApi

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )
        await client.get_workspace_by_id(
            id="id",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/v1/workspace/{id}"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(RetrieveWorkspaceByIdResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update_workspace(
        self,
        id: str,
        *,
        default_key_prefix: typing.Optional[str] = OMIT,
        default_allowed_i_ps: typing.List[str],
        default_rate_limit_per_second: typing.Optional[int] = OMIT,
        default_expiration: typing.Optional[int] = OMIT,
    ) -> UpdateWorkspaceResponse:
        """
        Parameters:
            - id: str.

            - default_key_prefix: typing.Optional[str].

            - default_allowed_i_ps: typing.List[str].

            - default_rate_limit_per_second: typing.Optional[int].

            - default_expiration: typing.Optional[int].
        ---
        from oneloop.client import AsyncOneloopApi

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )
        await client.update_workspace(
            id="id",
            default_allowed_i_ps=["defaultAllowedIPs"],
        )
        """
        _request: typing.Dict[str, typing.Any] = {"defaultAllowedIPs": default_allowed_i_ps}
        if default_key_prefix is not OMIT:
            _request["defaultKeyPrefix"] = default_key_prefix
        if default_rate_limit_per_second is not OMIT:
            _request["defaultRateLimitPerSecond"] = default_rate_limit_per_second
        if default_expiration is not OMIT:
            _request["defaultExpiration"] = default_expiration
        _response = await self._client_wrapper.httpx_client.request(
            "PATCH",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/v1/workspace/{id}"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(UpdateWorkspaceResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_workspace_scopes(self, id: str) -> RetrieveAllWorkspaceScopesResponse:
        """
        Parameters:
            - id: str.
        ---
        from oneloop.client import AsyncOneloopApi

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )
        await client.get_workspace_scopes(
            id="id",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/v1/workspace/{id}/scopes"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(RetrieveAllWorkspaceScopesResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_workspace_scopes(
        self, id: str, *, name: str, representation: str, description: typing.Optional[str] = OMIT
    ) -> CreateWorkspaceScopeResponse:
        """
        Parameters:
            - id: str.

            - name: str.

            - representation: str.

            - description: typing.Optional[str].
        ---
        from oneloop.client import AsyncOneloopApi

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )
        await client.create_workspace_scopes(
            id="id",
            name="name",
            representation="representation",
        )
        """
        _request: typing.Dict[str, typing.Any] = {"name": name, "representation": representation}
        if description is not OMIT:
            _request["description"] = description
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/v1/workspace/{id}/scope"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(CreateWorkspaceScopeResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_api_key(
        self,
        *,
        name: str,
        workspace_id: str,
        prefix: typing.Optional[str] = OMIT,
        expires_at: typing.Optional[int] = OMIT,
        total_usage_allowed: typing.Optional[int] = OMIT,
        scopes: typing.List[CreateApiKeyRequestScopesItem],
        enabled: bool,
        customer_id: str,
    ) -> CreateApiKeyResponse:
        """
        Parameters:
            - name: str.

            - workspace_id: str.

            - prefix: typing.Optional[str].

            - expires_at: typing.Optional[int].

            - total_usage_allowed: typing.Optional[int].

            - scopes: typing.List[CreateApiKeyRequestScopesItem].

            - enabled: bool.

            - customer_id: str.
        ---
        from oneloop import CreateApiKeyRequestScopesItem
        from oneloop.client import AsyncOneloopApi

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )
        await client.create_api_key(
            name="name",
            workspace_id="workspaceId",
            scopes=[
                CreateApiKeyRequestScopesItem(
                    representation="representation",
                    create=True,
                    read=True,
                    update=True,
                    del_=True,
                )
            ],
            enabled=True,
            customer_id="customerId",
        )
        """
        _request: typing.Dict[str, typing.Any] = {
            "name": name,
            "workspaceId": workspace_id,
            "scopes": scopes,
            "enabled": enabled,
            "customerId": customer_id,
        }
        if prefix is not OMIT:
            _request["prefix"] = prefix
        if expires_at is not OMIT:
            _request["expiresAt"] = expires_at
        if total_usage_allowed is not OMIT:
            _request["totalUsageAllowed"] = total_usage_allowed
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/v1/api-key"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(CreateApiKeyResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_api_keys(self, id: str) -> RetrieveApiKeysResponse:
        """
        Parameters:
            - id: str.
        ---
        from oneloop.client import AsyncOneloopApi

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )
        await client.get_api_keys(
            id="id",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/v1/workspace/{id}/api-key"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(RetrieveApiKeysResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_api_key_by_id(self, id: str, akid: str) -> RetrieveApiKeyByIdResponse:
        """
        Parameters:
            - id: str.

            - akid: str.
        ---
        from oneloop.client import AsyncOneloopApi

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )
        await client.get_api_key_by_id(
            id="id",
            akid="akid",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/v1/workspace/{id}/api-key/{akid}"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(RetrieveApiKeyByIdResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def delete_api_key(self, id: str, akid: str) -> DeleteApiKeyResponse:
        """
        Parameters:
            - id: str.

            - akid: str.
        ---
        from oneloop.client import AsyncOneloopApi

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )
        await client.delete_api_key(
            id="id",
            akid="akid",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "DELETE",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/v1/workspace/{id}/api-key/{akid}"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(DeleteApiKeyResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def edit_api_key(
        self,
        id: str,
        akid: str,
        *,
        name: typing.Optional[str] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        scopes: typing.Optional[typing.List[ApiKeyScope]] = OMIT,
    ) -> EditApiKeyResponse:
        """
        Parameters:
            - id: str.

            - akid: str.

            - name: typing.Optional[str].

            - enabled: typing.Optional[bool].

            - scopes: typing.Optional[typing.List[ApiKeyScope]].
        ---
        from oneloop.client import AsyncOneloopApi

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )
        await client.edit_api_key(
            id="id",
            akid="akid",
        )
        """
        _request: typing.Dict[str, typing.Any] = {}
        if name is not OMIT:
            _request["name"] = name
        if enabled is not OMIT:
            _request["enabled"] = enabled
        if scopes is not OMIT:
            _request["scopes"] = scopes
        _response = await self._client_wrapper.httpx_client.request(
            "PATCH",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/v1/workspace/{id}/api-key/{akid}"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(EditApiKeyResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def verify_api_key(
        self,
        *,
        key: str,
        requested_scopes: typing.List[ApiKeyScope],
        route: typing.Optional[str] = OMIT,
        billing: typing.Optional[VerifyApiKeyRequestBilling] = OMIT,
        rate_limit_config: typing.Optional[VerifyApiKeyRequestRateLimitConfig] = OMIT,
    ) -> VerifyApiKeyResponse:
        """
        Parameters:
            - key: str.

            - requested_scopes: typing.List[ApiKeyScope].

            - route: typing.Optional[str].

            - billing: typing.Optional[VerifyApiKeyRequestBilling].

            - rate_limit_config: typing.Optional[VerifyApiKeyRequestRateLimitConfig].
        ---
        from oneloop import ApiKeyScope
        from oneloop.client import AsyncOneloopApi

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )
        await client.verify_api_key(
            key="key",
            requested_scopes=[
                ApiKeyScope(
                    representation="representation",
                    create=True,
                    read=True,
                    update=True,
                    del_=True,
                )
            ],
        )
        """
        _request: typing.Dict[str, typing.Any] = {"key": key, "requestedScopes": requested_scopes}
        if route is not OMIT:
            _request["route"] = route
        if billing is not OMIT:
            _request["billing"] = billing
        if rate_limit_config is not OMIT:
            _request["rateLimitConfig"] = rate_limit_config
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/v1/api-key/verify"),
            json=jsonable_encoder(_request),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(VerifyApiKeyResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def rotate_api_key(self, id: str, akid: str) -> RotateApiKeyResponse:
        """
        Parameters:
            - id: str.

            - akid: str.
        ---
        from oneloop.client import AsyncOneloopApi

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )
        await client.rotate_api_key(
            id="id",
            akid="akid",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"api/v1/workspace/{id}/api-key/{akid}/rotate"
            ),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(RotateApiKeyResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def refill_api_key(self, id: str, akid: str, *, amount: int) -> RefillApiKeyResponse:
        """
        Parameters:
            - id: str.

            - akid: str.

            - amount: int.
        ---
        from oneloop.client import AsyncOneloopApi

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )
        await client.refill_api_key(
            id="id",
            akid="akid",
            amount=1,
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(
                f"{self._client_wrapper.get_base_url()}/", f"api/v1/workspace/{id}/api-key/{akid}/refill"
            ),
            json=jsonable_encoder({"amount": amount}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(RefillApiKeyResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def generate_link_token(self, *, customer_id: str, workspace_id: str) -> GenerateLinkTokenResponse:
        """
        Parameters:
            - customer_id: str.

            - workspace_id: str.
        ---
        from oneloop.client import AsyncOneloopApi

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )
        await client.generate_link_token(
            customer_id="customerId",
            workspace_id="workspaceId",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "POST",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", "api/v1/link-token"),
            json=jsonable_encoder({"customerId": customer_id, "workspaceId": workspace_id}),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(GenerateLinkTokenResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def validate_link_token(self, token: str) -> ValidateLinkTokenResponse:
        """
        Parameters:
            - token: str.
        ---
        from oneloop.client import AsyncOneloopApi

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )
        await client.validate_link_token(
            token="token",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/v1/link-token/{token}"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(ValidateLinkTokenResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_billing_usage(self, bid: str) -> GetBillingUsageResponse:
        """
        Parameters:
            - bid: str.
        ---
        from oneloop.client import AsyncOneloopApi

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )
        await client.get_billing_usage(
            bid="bid",
        )
        """
        _response = await self._client_wrapper.httpx_client.request(
            "GET",
            urllib.parse.urljoin(f"{self._client_wrapper.get_base_url()}/", f"api/v1/usage/{bid}"),
            headers=self._client_wrapper.get_headers(),
            timeout=60,
        )
        if 200 <= _response.status_code < 300:
            return pydantic.parse_obj_as(GetBillingUsageResponse, _response.json())  # type: ignore
        if _response.status_code == 400:
            raise BadRequestError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 401:
            raise UnauthorizedError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        if _response.status_code == 403:
            raise ForbiddenError(pydantic.parse_obj_as(ErrorResponse, _response.json()))  # type: ignore
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


def _get_base_url(*, base_url: typing.Optional[str] = None, environment: OneloopApiEnvironment) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception("Please pass in either base_url or environment to construct the client")
