# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.datetime_utils import serialize_datetime

try:
    import pydantic.v1 as pydantic  # type: ignore
except ImportError:
    import pydantic  # type: ignore


class Workspace(pydantic.BaseModel):
    id: str
    name: str
    team_id: str = pydantic.Field(alias="teamId")
    default_key_prefix: typing.Optional[str] = pydantic.Field(alias="defaultKeyPrefix")
    default_allowed_i_ps: typing.List[str] = pydantic.Field(alias="defaultAllowedIPs")
    default_rate_limit_per_second: typing.Optional[int] = pydantic.Field(alias="defaultRateLimitPerSecond")
    default_expiration: typing.Optional[int] = pydantic.Field(alias="defaultExpiration")
    created_at: str = pydantic.Field(alias="createdAt")
    updated_at: str = pydantic.Field(alias="updatedAt")

    def json(self, **kwargs: typing.Any) -> str:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().json(**kwargs_with_defaults)

    def dict(self, **kwargs: typing.Any) -> typing.Dict[str, typing.Any]:
        kwargs_with_defaults: typing.Any = {"by_alias": True, "exclude_unset": True, **kwargs}
        return super().dict(**kwargs_with_defaults)

    class Config:
        frozen = True
        smart_union = True
        allow_population_by_field_name = True
        json_encoders = {dt.datetime: serialize_datetime}
