# oneloop-python
API Key Management

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0.0
- Package version: 0.0.4
- Generator version: 7.7.0
- Build package: org.openapitools.codegen.languages.PythonPydanticV1ClientCodegen

## Requirements.

Python 3.7+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import oneloop_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import oneloop_client
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import oneloop_client
from oneloop_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://prod.oneloop.ai
# See configuration.py for a list of all supported configuration parameters.
configuration = oneloop_client.Configuration(
    host = "https://prod.oneloop.ai"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure Bearer authorization: bearerAuth
configuration = oneloop_client.Configuration(
    access_token = os.environ["BEARER_TOKEN"]
)


# Enter a context with an instance of the API client
with oneloop_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = oneloop_client.DefaultApi(api_client)
    create_api_key_request = oneloop_client.CreateApiKeyRequest() # CreateApiKeyRequest |  (optional)

    try:
        # Create an API key
        api_response = api_instance.create_api_key(create_api_key_request=create_api_key_request)
        print("The response of DefaultApi->create_api_key:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DefaultApi->create_api_key: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://prod.oneloop.ai*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DefaultApi* | [**create_api_key**](docs/DefaultApi.md#create_api_key) | **POST** /api/v1/api-key | Create an API key
*DefaultApi* | [**create_workspace**](docs/DefaultApi.md#create_workspace) | **POST** /api/v1/workspace | Create a workspace
*DefaultApi* | [**create_workspace_scopes**](docs/DefaultApi.md#create_workspace_scopes) | **POST** /api/v1/workspace/{id}/scope | Create a workspace scope
*DefaultApi* | [**delete_api_key**](docs/DefaultApi.md#delete_api_key) | **DELETE** /api/v1/workspace/{id}/api-key/{akid} | Delets a key for a given workspace
*DefaultApi* | [**edit_api_key**](docs/DefaultApi.md#edit_api_key) | **PATCH** /api/v1/workspace/{id}/api-key/{akid} | Edit an API key
*DefaultApi* | [**generate_link_token**](docs/DefaultApi.md#generate_link_token) | **POST** /api/v1/link-token | Generate a link token
*DefaultApi* | [**get_api_key_by_id**](docs/DefaultApi.md#get_api_key_by_id) | **GET** /api/v1/workspace/{id}/api-key/{akid} | Retrieve an API key by id
*DefaultApi* | [**get_api_keys**](docs/DefaultApi.md#get_api_keys) | **GET** /api/v1/workspace/{id}/api-key | Retrieve API keys for a workspace
*DefaultApi* | [**get_workspace**](docs/DefaultApi.md#get_workspace) | **GET** /api/v1/workspace | Retrieve a workspace
*DefaultApi* | [**get_workspace_by_id**](docs/DefaultApi.md#get_workspace_by_id) | **GET** /api/v1/workspace/{id} | Retrieve a workspace
*DefaultApi* | [**get_workspace_scopes**](docs/DefaultApi.md#get_workspace_scopes) | **GET** /api/v1/workspace/{id}/scopes | Retrieve workspace scopes
*DefaultApi* | [**refill_api_key**](docs/DefaultApi.md#refill_api_key) | **POST** /api/v1/workspace/{id}/api-key/{akid}/refill | Refill a key for a given workspace
*DefaultApi* | [**rotate_api_key**](docs/DefaultApi.md#rotate_api_key) | **POST** /api/v1/workspace/{id}/api-key/{akid}/rotate | Rotate a key for a given workspace
*DefaultApi* | [**update_workspace**](docs/DefaultApi.md#update_workspace) | **PATCH** /api/v1/workspace/{id} | Updates a workspace
*DefaultApi* | [**validate_link_token**](docs/DefaultApi.md#validate_link_token) | **GET** /api/v1/link-token | Validate a link token
*DefaultApi* | [**verify_api_key**](docs/DefaultApi.md#verify_api_key) | **POST** /api/v1/api-key/verify | Verify a key for a given workspace


## Documentation For Models

 - [ApiKey](docs/ApiKey.md)
 - [ApiKeyScope](docs/ApiKeyScope.md)
 - [CreateApiKeyRequest](docs/CreateApiKeyRequest.md)
 - [CreateApiKeyRequestScopesInner](docs/CreateApiKeyRequestScopesInner.md)
 - [CreateApiKeyResponse](docs/CreateApiKeyResponse.md)
 - [CreateApiKeyResponseApiKey](docs/CreateApiKeyResponseApiKey.md)
 - [CreateWorkspaceRequest](docs/CreateWorkspaceRequest.md)
 - [CreateWorkspaceResponse](docs/CreateWorkspaceResponse.md)
 - [CreateWorkspaceScopeRequest](docs/CreateWorkspaceScopeRequest.md)
 - [CreateWorkspaceScopeResponse](docs/CreateWorkspaceScopeResponse.md)
 - [DeleteApiKeyResponse](docs/DeleteApiKeyResponse.md)
 - [EditApiKeyRequest](docs/EditApiKeyRequest.md)
 - [EditApiKeyResponse](docs/EditApiKeyResponse.md)
 - [ErrorResponse](docs/ErrorResponse.md)
 - [ErrorResponseError](docs/ErrorResponseError.md)
 - [GenerateLinkToken200Response](docs/GenerateLinkToken200Response.md)
 - [GenerateLinkTokenRequest](docs/GenerateLinkTokenRequest.md)
 - [RefillApiKeyRequest](docs/RefillApiKeyRequest.md)
 - [RefillApiKeyResponse](docs/RefillApiKeyResponse.md)
 - [RetrieveAllWorkspaceScopesResponse](docs/RetrieveAllWorkspaceScopesResponse.md)
 - [RetrieveApiKeyByIdResponse](docs/RetrieveApiKeyByIdResponse.md)
 - [RetrieveApiKeysResponse](docs/RetrieveApiKeysResponse.md)
 - [RetrieveWorkspaceByIdResponse](docs/RetrieveWorkspaceByIdResponse.md)
 - [RetrieveWorkspaceResponse](docs/RetrieveWorkspaceResponse.md)
 - [RotateApiKeyResponse](docs/RotateApiKeyResponse.md)
 - [UpdateWorkspaceResponse](docs/UpdateWorkspaceResponse.md)
 - [ValidateLinkToken200Response](docs/ValidateLinkToken200Response.md)
 - [VerifyApiKeyRequest](docs/VerifyApiKeyRequest.md)
 - [VerifyApiKeyRequestRateLimitConfig](docs/VerifyApiKeyRequestRateLimitConfig.md)
 - [VerifyApiKeyResponse](docs/VerifyApiKeyResponse.md)
 - [VerifyApiKeyResponseRateLimit](docs/VerifyApiKeyResponseRateLimit.md)
 - [Workspace](docs/Workspace.md)
 - [WorkspaceScope](docs/WorkspaceScope.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="bearerAuth"></a>
### bearerAuth

- **Type**: Bearer authentication


## Author




