# coding: utf-8

"""
    Oneloop API

    API Key Management

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conint, conlist
from oneloop_client.models.api_key_scope import ApiKeyScope

class ApiKey(BaseModel):
    """
    ApiKey
    """
    id: StrictStr = Field(...)
    name: StrictStr = Field(...)
    masked_key: StrictStr = Field(default=..., alias="maskedKey")
    prefix: Optional[StrictStr] = Field(...)
    expires_at: Optional[conint(strict=True, gt=0)] = Field(default=..., alias="expiresAt")
    total_usage_left: Optional[conint(strict=True, gt=0)] = Field(default=..., alias="totalUsageLeft")
    limit_usage: StrictBool = Field(default=..., alias="limitUsage")
    scopes: conlist(ApiKeyScope) = Field(...)
    enabled: StrictBool = Field(...)
    customer_id: Optional[StrictStr] = Field(default=..., alias="customerId")
    deleted: StrictBool = Field(...)
    created_at: StrictStr = Field(default=..., alias="createdAt")
    updated_at: StrictStr = Field(default=..., alias="updatedAt")
    __properties = ["id", "name", "maskedKey", "prefix", "expiresAt", "totalUsageLeft", "limitUsage", "scopes", "enabled", "customerId", "deleted", "createdAt", "updatedAt"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApiKey:
        """Create an instance of ApiKey from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in scopes (list)
        _items = []
        if self.scopes:
            for _item in self.scopes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['scopes'] = _items
        # set to None if prefix (nullable) is None
        # and __fields_set__ contains the field
        if self.prefix is None and "prefix" in self.__fields_set__:
            _dict['prefix'] = None

        # set to None if expires_at (nullable) is None
        # and __fields_set__ contains the field
        if self.expires_at is None and "expires_at" in self.__fields_set__:
            _dict['expiresAt'] = None

        # set to None if total_usage_left (nullable) is None
        # and __fields_set__ contains the field
        if self.total_usage_left is None and "total_usage_left" in self.__fields_set__:
            _dict['totalUsageLeft'] = None

        # set to None if customer_id (nullable) is None
        # and __fields_set__ contains the field
        if self.customer_id is None and "customer_id" in self.__fields_set__:
            _dict['customerId'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApiKey:
        """Create an instance of ApiKey from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return ApiKey.parse_obj(obj)

        _obj = ApiKey.parse_obj({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "masked_key": obj.get("maskedKey"),
            "prefix": obj.get("prefix"),
            "expires_at": obj.get("expiresAt"),
            "total_usage_left": obj.get("totalUsageLeft"),
            "limit_usage": obj.get("limitUsage"),
            "scopes": [ApiKeyScope.from_dict(_item) for _item in obj.get("scopes")] if obj.get("scopes") is not None else None,
            "enabled": obj.get("enabled"),
            "customer_id": obj.get("customerId"),
            "deleted": obj.get("deleted"),
            "created_at": obj.get("createdAt"),
            "updated_at": obj.get("updatedAt")
        })
        return _obj


