# coding: utf-8

"""
    Oneloop API

    API Key Management

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conint, conlist, validator
from oneloop_client.models.api_key_scope import ApiKeyScope
from oneloop_client.models.verify_api_key_response_rate_limit import VerifyApiKeyResponseRateLimit

class VerifyApiKeyResponse(BaseModel):
    """
    VerifyApiKeyResponse
    """
    expires_at: Optional[conint(strict=True, gt=0)] = Field(default=..., alias="expiresAt")
    requested_scopes: conlist(ApiKeyScope) = Field(default=..., alias="requestedScopes")
    status: StrictStr = Field(...)
    rate_limit: Optional[VerifyApiKeyResponseRateLimit] = Field(default=None, alias="rateLimit")
    __properties = ["expiresAt", "requestedScopes", "status", "rateLimit"]

    @validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in ('VALID', 'EXPIRED', 'DISABLED', 'DELETED', 'RATE_LIMITED', 'USAGE_LIMITED', 'INVALID_SCOPES', 'INVALID'):
            raise ValueError("must be one of enum values ('VALID', 'EXPIRED', 'DISABLED', 'DELETED', 'RATE_LIMITED', 'USAGE_LIMITED', 'INVALID_SCOPES', 'INVALID')")
        return value

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> VerifyApiKeyResponse:
        """Create an instance of VerifyApiKeyResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in requested_scopes (list)
        _items = []
        if self.requested_scopes:
            for _item in self.requested_scopes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['requestedScopes'] = _items
        # override the default output from pydantic by calling `to_dict()` of rate_limit
        if self.rate_limit:
            _dict['rateLimit'] = self.rate_limit.to_dict()
        # set to None if expires_at (nullable) is None
        # and __fields_set__ contains the field
        if self.expires_at is None and "expires_at" in self.__fields_set__:
            _dict['expiresAt'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> VerifyApiKeyResponse:
        """Create an instance of VerifyApiKeyResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return VerifyApiKeyResponse.parse_obj(obj)

        _obj = VerifyApiKeyResponse.parse_obj({
            "expires_at": obj.get("expiresAt"),
            "requested_scopes": [ApiKeyScope.from_dict(_item) for _item in obj.get("requestedScopes")] if obj.get("requestedScopes") is not None else None,
            "status": obj.get("status"),
            "rate_limit": VerifyApiKeyResponseRateLimit.from_dict(obj.get("rateLimit")) if obj.get("rateLimit") is not None else None
        })
        return _obj


