# coding: utf-8

"""
    Oneloop API

    API Key Management

    The version of the OpenAPI document: 1.0.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, conint, conlist

class Workspace(BaseModel):
    """
    Workspace
    """
    id: StrictStr = Field(...)
    name: StrictStr = Field(...)
    team_id: StrictStr = Field(default=..., alias="teamId")
    default_key_prefix: Optional[StrictStr] = Field(default=..., alias="defaultKeyPrefix")
    default_allowed_ips: conlist(StrictStr) = Field(default=..., alias="defaultAllowedIPs")
    default_rate_limit_per_second: Optional[conint(strict=True, gt=0)] = Field(default=..., alias="defaultRateLimitPerSecond")
    default_expiration: Optional[conint(strict=True, gt=0)] = Field(default=..., alias="defaultExpiration")
    created_at: StrictStr = Field(default=..., alias="createdAt")
    updated_at: StrictStr = Field(default=..., alias="updatedAt")
    __properties = ["id", "name", "teamId", "defaultKeyPrefix", "defaultAllowedIPs", "defaultRateLimitPerSecond", "defaultExpiration", "createdAt", "updatedAt"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Workspace:
        """Create an instance of Workspace from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if default_key_prefix (nullable) is None
        # and __fields_set__ contains the field
        if self.default_key_prefix is None and "default_key_prefix" in self.__fields_set__:
            _dict['defaultKeyPrefix'] = None

        # set to None if default_rate_limit_per_second (nullable) is None
        # and __fields_set__ contains the field
        if self.default_rate_limit_per_second is None and "default_rate_limit_per_second" in self.__fields_set__:
            _dict['defaultRateLimitPerSecond'] = None

        # set to None if default_expiration (nullable) is None
        # and __fields_set__ contains the field
        if self.default_expiration is None and "default_expiration" in self.__fields_set__:
            _dict['defaultExpiration'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Workspace:
        """Create an instance of Workspace from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return Workspace.parse_obj(obj)

        _obj = Workspace.parse_obj({
            "id": obj.get("id"),
            "name": obj.get("name"),
            "team_id": obj.get("teamId"),
            "default_key_prefix": obj.get("defaultKeyPrefix"),
            "default_allowed_ips": obj.get("defaultAllowedIPs"),
            "default_rate_limit_per_second": obj.get("defaultRateLimitPerSecond"),
            "default_expiration": obj.get("defaultExpiration"),
            "created_at": obj.get("createdAt"),
            "updated_at": obj.get("updatedAt")
        })
        return _obj


