# This file was auto-generated by Fern from our API Definition.

import typing
from .environment import OneloopApiEnvironment
import httpx
from .core.client_wrapper import SyncClientWrapper
from .core.request_options import RequestOptions
from .types.retrieve_workspace_response import RetrieveWorkspaceResponse
from .core.pydantic_utilities import parse_obj_as
from .errors.bad_request_error import BadRequestError
from .types.error_response import ErrorResponse
from .errors.unauthorized_error import UnauthorizedError
from .errors.forbidden_error import ForbiddenError
from json.decoder import JSONDecodeError
from .core.api_error import ApiError
from .types.create_workspace_response import CreateWorkspaceResponse
from .types.retrieve_workspace_by_id_response import RetrieveWorkspaceByIdResponse
from .core.jsonable_encoder import jsonable_encoder
from .types.update_workspace_response import UpdateWorkspaceResponse
from .types.retrieve_all_workspace_scopes_response import (
    RetrieveAllWorkspaceScopesResponse,
)
from .types.create_workspace_scope_response import CreateWorkspaceScopeResponse
from .types.create_api_key_request_scopes_item import CreateApiKeyRequestScopesItem
from .types.create_api_key_response import CreateApiKeyResponse
from .types.retrieve_api_keys_response import RetrieveApiKeysResponse
from .types.retrieve_api_key_by_id_response import RetrieveApiKeyByIdResponse
from .types.delete_api_key_response import DeleteApiKeyResponse
from .types.api_key_scope import ApiKeyScope
from .types.edit_api_key_response import EditApiKeyResponse
from .types.verify_api_key_request_rate_limit_config import (
    VerifyApiKeyRequestRateLimitConfig,
)
from .types.verify_api_key_response import VerifyApiKeyResponse
from .types.rotate_api_key_response import RotateApiKeyResponse
from .types.refill_api_key_response import RefillApiKeyResponse
from .types.generate_link_token_response import GenerateLinkTokenResponse
from .types.validate_link_token_response import ValidateLinkTokenResponse
from .core.client_wrapper import AsyncClientWrapper

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class OneloopApi:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : OneloopApiEnvironment
        The environment to use for requests from the client. from .environment import OneloopApiEnvironment



        Defaults to OneloopApiEnvironment.DEFAULT



    token : typing.Union[str, typing.Callable[[], str]]
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from oneloop import OneloopApi

    client = OneloopApi(
        token="YOUR_TOKEN",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: OneloopApiEnvironment = OneloopApiEnvironment.DEFAULT,
        token: typing.Union[str, typing.Callable[[], str]],
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else None
        )
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            token=token,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(
                timeout=_defaulted_timeout, follow_redirects=follow_redirects
            )
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )

    def get_workspace(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> RetrieveWorkspaceResponse:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RetrieveWorkspaceResponse
            Workspace

        Examples
        --------
        from oneloop import OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.get_workspace()
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v1/workspace",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    RetrieveWorkspaceResponse,
                    parse_obj_as(
                        type_=RetrieveWorkspaceResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_workspace(
        self, *, name: str, request_options: typing.Optional[RequestOptions] = None
    ) -> CreateWorkspaceResponse:
        """
        Parameters
        ----------
        name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateWorkspaceResponse
            The created workspace

        Examples
        --------
        from oneloop import OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.create_workspace(
            name="name",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v1/workspace",
            method="POST",
            json={
                "name": name,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    CreateWorkspaceResponse,
                    parse_obj_as(
                        type_=CreateWorkspaceResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_workspace_by_id(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> RetrieveWorkspaceByIdResponse:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RetrieveWorkspaceByIdResponse
            Workspace

        Examples
        --------
        from oneloop import OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.get_workspace_by_id(
            id="id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/v1/workspace/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    RetrieveWorkspaceByIdResponse,
                    parse_obj_as(
                        type_=RetrieveWorkspaceByIdResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def update_workspace(
        self,
        id: str,
        *,
        default_allowed_i_ps: typing.Sequence[str],
        default_key_prefix: typing.Optional[str] = OMIT,
        default_rate_limit_per_second: typing.Optional[int] = OMIT,
        default_expiration: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateWorkspaceResponse:
        """
        Parameters
        ----------
        id : str

        default_allowed_i_ps : typing.Sequence[str]

        default_key_prefix : typing.Optional[str]

        default_rate_limit_per_second : typing.Optional[int]

        default_expiration : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateWorkspaceResponse
            Workspace

        Examples
        --------
        from oneloop import OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.update_workspace(
            id="id",
            default_allowed_i_ps=["defaultAllowedIPs"],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/v1/workspace/{jsonable_encoder(id)}",
            method="PATCH",
            json={
                "defaultKeyPrefix": default_key_prefix,
                "defaultAllowedIPs": default_allowed_i_ps,
                "defaultRateLimitPerSecond": default_rate_limit_per_second,
                "defaultExpiration": default_expiration,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    UpdateWorkspaceResponse,
                    parse_obj_as(
                        type_=UpdateWorkspaceResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_workspace_scopes(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> RetrieveAllWorkspaceScopesResponse:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RetrieveAllWorkspaceScopesResponse
            Workspace scopes

        Examples
        --------
        from oneloop import OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.get_workspace_scopes(
            id="id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/v1/workspace/{jsonable_encoder(id)}/scopes",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    RetrieveAllWorkspaceScopesResponse,
                    parse_obj_as(
                        type_=RetrieveAllWorkspaceScopesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_workspace_scopes(
        self,
        id: str,
        *,
        name: str,
        representation: str,
        description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateWorkspaceScopeResponse:
        """
        Parameters
        ----------
        id : str

        name : str

        representation : str

        description : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateWorkspaceScopeResponse
            The created scope

        Examples
        --------
        from oneloop import OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.create_workspace_scopes(
            id="id",
            name="name",
            representation="representation",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/v1/workspace/{jsonable_encoder(id)}/scope",
            method="POST",
            json={
                "name": name,
                "representation": representation,
                "description": description,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    CreateWorkspaceScopeResponse,
                    parse_obj_as(
                        type_=CreateWorkspaceScopeResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def create_api_key(
        self,
        *,
        name: str,
        workspace_id: str,
        scopes: typing.Sequence[CreateApiKeyRequestScopesItem],
        enabled: bool,
        customer_id: str,
        prefix: typing.Optional[str] = OMIT,
        expires_at: typing.Optional[int] = OMIT,
        total_usage_allowed: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateApiKeyResponse:
        """
        Parameters
        ----------
        name : str

        workspace_id : str

        scopes : typing.Sequence[CreateApiKeyRequestScopesItem]

        enabled : bool

        customer_id : str

        prefix : typing.Optional[str]

        expires_at : typing.Optional[int]

        total_usage_allowed : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateApiKeyResponse
            The created key

        Examples
        --------
        from oneloop import CreateApiKeyRequestScopesItem, OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.create_api_key(
            name="name",
            workspace_id="workspaceId",
            scopes=[
                CreateApiKeyRequestScopesItem(
                    representation="representation",
                    create=True,
                    read=True,
                    update=True,
                    del_=True,
                )
            ],
            enabled=True,
            customer_id="customerId",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v1/api-key",
            method="POST",
            json={
                "name": name,
                "workspaceId": workspace_id,
                "prefix": prefix,
                "expiresAt": expires_at,
                "totalUsageAllowed": total_usage_allowed,
                "scopes": scopes,
                "enabled": enabled,
                "customerId": customer_id,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    CreateApiKeyResponse,
                    parse_obj_as(
                        type_=CreateApiKeyResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_api_keys(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> RetrieveApiKeysResponse:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RetrieveApiKeysResponse
            The API keys

        Examples
        --------
        from oneloop import OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.get_api_keys(
            id="id",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/v1/workspace/{jsonable_encoder(id)}/api-key",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    RetrieveApiKeysResponse,
                    parse_obj_as(
                        type_=RetrieveApiKeysResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def get_api_key_by_id(
        self,
        id: str,
        akid: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RetrieveApiKeyByIdResponse:
        """
        Parameters
        ----------
        id : str

        akid : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RetrieveApiKeyByIdResponse
            The API key

        Examples
        --------
        from oneloop import OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.get_api_key_by_id(
            id="id",
            akid="akid",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/v1/workspace/{jsonable_encoder(id)}/api-key/{jsonable_encoder(akid)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    RetrieveApiKeyByIdResponse,
                    parse_obj_as(
                        type_=RetrieveApiKeyByIdResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def delete_api_key(
        self,
        id: str,
        akid: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DeleteApiKeyResponse:
        """
        Parameters
        ----------
        id : str

        akid : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeleteApiKeyResponse
            The updated deleted key

        Examples
        --------
        from oneloop import OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.delete_api_key(
            id="id",
            akid="akid",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/v1/workspace/{jsonable_encoder(id)}/api-key/{jsonable_encoder(akid)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    DeleteApiKeyResponse,
                    parse_obj_as(
                        type_=DeleteApiKeyResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def edit_api_key(
        self,
        id: str,
        akid: str,
        *,
        name: typing.Optional[str] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        scopes: typing.Optional[typing.Sequence[ApiKeyScope]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EditApiKeyResponse:
        """
        Parameters
        ----------
        id : str

        akid : str

        name : typing.Optional[str]

        enabled : typing.Optional[bool]

        scopes : typing.Optional[typing.Sequence[ApiKeyScope]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EditApiKeyResponse
            The edited key

        Examples
        --------
        from oneloop import OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.edit_api_key(
            id="id",
            akid="akid",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/v1/workspace/{jsonable_encoder(id)}/api-key/{jsonable_encoder(akid)}",
            method="PATCH",
            json={
                "name": name,
                "enabled": enabled,
                "scopes": scopes,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    EditApiKeyResponse,
                    parse_obj_as(
                        type_=EditApiKeyResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def verify_api_key(
        self,
        *,
        key: str,
        requested_scopes: typing.Sequence[ApiKeyScope],
        rate_limit_config: typing.Optional[VerifyApiKeyRequestRateLimitConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> VerifyApiKeyResponse:
        """
        Parameters
        ----------
        key : str

        requested_scopes : typing.Sequence[ApiKeyScope]

        rate_limit_config : typing.Optional[VerifyApiKeyRequestRateLimitConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        VerifyApiKeyResponse
            The verification result

        Examples
        --------
        from oneloop import ApiKeyScope, OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.verify_api_key(
            key="key",
            requested_scopes=[
                ApiKeyScope(
                    representation="representation",
                    create=True,
                    read=True,
                    update=True,
                    del_=True,
                )
            ],
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v1/api-key/verify",
            method="POST",
            json={
                "key": key,
                "requestedScopes": requested_scopes,
                "rateLimitConfig": rate_limit_config,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    VerifyApiKeyResponse,
                    parse_obj_as(
                        type_=VerifyApiKeyResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def rotate_api_key(
        self,
        id: str,
        akid: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RotateApiKeyResponse:
        """
        Parameters
        ----------
        id : str

        akid : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RotateApiKeyResponse
            The newly rotated key

        Examples
        --------
        from oneloop import OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.rotate_api_key(
            id="id",
            akid="akid",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/v1/workspace/{jsonable_encoder(id)}/api-key/{jsonable_encoder(akid)}/rotate",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    RotateApiKeyResponse,
                    parse_obj_as(
                        type_=RotateApiKeyResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def refill_api_key(
        self,
        id: str,
        akid: str,
        *,
        amount: int,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RefillApiKeyResponse:
        """
        Parameters
        ----------
        id : str

        akid : str

        amount : int

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RefillApiKeyResponse
            The updated key

        Examples
        --------
        from oneloop import OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.refill_api_key(
            id="id",
            akid="akid",
            amount=1,
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/v1/workspace/{jsonable_encoder(id)}/api-key/{jsonable_encoder(akid)}/refill",
            method="POST",
            json={
                "amount": amount,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    RefillApiKeyResponse,
                    parse_obj_as(
                        type_=RefillApiKeyResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def generate_link_token(
        self,
        *,
        customer_id: str,
        workspace_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GenerateLinkTokenResponse:
        """
        Parameters
        ----------
        customer_id : str

        workspace_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GenerateLinkTokenResponse
            The generated link token

        Examples
        --------
        from oneloop import OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.generate_link_token(
            customer_id="customerId",
            workspace_id="workspaceId",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/v1/link-token",
            method="POST",
            json={
                "customerId": customer_id,
                "workspaceId": workspace_id,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    GenerateLinkTokenResponse,
                    parse_obj_as(
                        type_=GenerateLinkTokenResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    def validate_link_token(
        self, token: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ValidateLinkTokenResponse:
        """
        Parameters
        ----------
        token : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ValidateLinkTokenResponse
            The validation result

        Examples
        --------
        from oneloop import OneloopApi

        client = OneloopApi(
            token="YOUR_TOKEN",
        )
        client.validate_link_token(
            token="token",
        )
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/v1/link-token/{jsonable_encoder(token)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ValidateLinkTokenResponse,
                    parse_obj_as(
                        type_=ValidateLinkTokenResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


class AsyncOneloopApi:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : OneloopApiEnvironment
        The environment to use for requests from the client. from .environment import OneloopApiEnvironment



        Defaults to OneloopApiEnvironment.DEFAULT



    token : typing.Union[str, typing.Callable[[], str]]
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from oneloop import AsyncOneloopApi

    client = AsyncOneloopApi(
        token="YOUR_TOKEN",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: OneloopApiEnvironment = OneloopApiEnvironment.DEFAULT,
        token: typing.Union[str, typing.Callable[[], str]],
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else None
        )
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            token=token,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(
                timeout=_defaulted_timeout, follow_redirects=follow_redirects
            )
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )

    async def get_workspace(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> RetrieveWorkspaceResponse:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RetrieveWorkspaceResponse
            Workspace

        Examples
        --------
        import asyncio

        from oneloop import AsyncOneloopApi

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_workspace()


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v1/workspace",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    RetrieveWorkspaceResponse,
                    parse_obj_as(
                        type_=RetrieveWorkspaceResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_workspace(
        self, *, name: str, request_options: typing.Optional[RequestOptions] = None
    ) -> CreateWorkspaceResponse:
        """
        Parameters
        ----------
        name : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateWorkspaceResponse
            The created workspace

        Examples
        --------
        import asyncio

        from oneloop import AsyncOneloopApi

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.create_workspace(
                name="name",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v1/workspace",
            method="POST",
            json={
                "name": name,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    CreateWorkspaceResponse,
                    parse_obj_as(
                        type_=CreateWorkspaceResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_workspace_by_id(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> RetrieveWorkspaceByIdResponse:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RetrieveWorkspaceByIdResponse
            Workspace

        Examples
        --------
        import asyncio

        from oneloop import AsyncOneloopApi

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_workspace_by_id(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/v1/workspace/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    RetrieveWorkspaceByIdResponse,
                    parse_obj_as(
                        type_=RetrieveWorkspaceByIdResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def update_workspace(
        self,
        id: str,
        *,
        default_allowed_i_ps: typing.Sequence[str],
        default_key_prefix: typing.Optional[str] = OMIT,
        default_rate_limit_per_second: typing.Optional[int] = OMIT,
        default_expiration: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> UpdateWorkspaceResponse:
        """
        Parameters
        ----------
        id : str

        default_allowed_i_ps : typing.Sequence[str]

        default_key_prefix : typing.Optional[str]

        default_rate_limit_per_second : typing.Optional[int]

        default_expiration : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        UpdateWorkspaceResponse
            Workspace

        Examples
        --------
        import asyncio

        from oneloop import AsyncOneloopApi

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.update_workspace(
                id="id",
                default_allowed_i_ps=["defaultAllowedIPs"],
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/v1/workspace/{jsonable_encoder(id)}",
            method="PATCH",
            json={
                "defaultKeyPrefix": default_key_prefix,
                "defaultAllowedIPs": default_allowed_i_ps,
                "defaultRateLimitPerSecond": default_rate_limit_per_second,
                "defaultExpiration": default_expiration,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    UpdateWorkspaceResponse,
                    parse_obj_as(
                        type_=UpdateWorkspaceResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_workspace_scopes(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> RetrieveAllWorkspaceScopesResponse:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RetrieveAllWorkspaceScopesResponse
            Workspace scopes

        Examples
        --------
        import asyncio

        from oneloop import AsyncOneloopApi

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_workspace_scopes(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/v1/workspace/{jsonable_encoder(id)}/scopes",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    RetrieveAllWorkspaceScopesResponse,
                    parse_obj_as(
                        type_=RetrieveAllWorkspaceScopesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_workspace_scopes(
        self,
        id: str,
        *,
        name: str,
        representation: str,
        description: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateWorkspaceScopeResponse:
        """
        Parameters
        ----------
        id : str

        name : str

        representation : str

        description : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateWorkspaceScopeResponse
            The created scope

        Examples
        --------
        import asyncio

        from oneloop import AsyncOneloopApi

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.create_workspace_scopes(
                id="id",
                name="name",
                representation="representation",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/v1/workspace/{jsonable_encoder(id)}/scope",
            method="POST",
            json={
                "name": name,
                "representation": representation,
                "description": description,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    CreateWorkspaceScopeResponse,
                    parse_obj_as(
                        type_=CreateWorkspaceScopeResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def create_api_key(
        self,
        *,
        name: str,
        workspace_id: str,
        scopes: typing.Sequence[CreateApiKeyRequestScopesItem],
        enabled: bool,
        customer_id: str,
        prefix: typing.Optional[str] = OMIT,
        expires_at: typing.Optional[int] = OMIT,
        total_usage_allowed: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateApiKeyResponse:
        """
        Parameters
        ----------
        name : str

        workspace_id : str

        scopes : typing.Sequence[CreateApiKeyRequestScopesItem]

        enabled : bool

        customer_id : str

        prefix : typing.Optional[str]

        expires_at : typing.Optional[int]

        total_usage_allowed : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateApiKeyResponse
            The created key

        Examples
        --------
        import asyncio

        from oneloop import AsyncOneloopApi, CreateApiKeyRequestScopesItem

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.create_api_key(
                name="name",
                workspace_id="workspaceId",
                scopes=[
                    CreateApiKeyRequestScopesItem(
                        representation="representation",
                        create=True,
                        read=True,
                        update=True,
                        del_=True,
                    )
                ],
                enabled=True,
                customer_id="customerId",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v1/api-key",
            method="POST",
            json={
                "name": name,
                "workspaceId": workspace_id,
                "prefix": prefix,
                "expiresAt": expires_at,
                "totalUsageAllowed": total_usage_allowed,
                "scopes": scopes,
                "enabled": enabled,
                "customerId": customer_id,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    CreateApiKeyResponse,
                    parse_obj_as(
                        type_=CreateApiKeyResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_api_keys(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> RetrieveApiKeysResponse:
        """
        Parameters
        ----------
        id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RetrieveApiKeysResponse
            The API keys

        Examples
        --------
        import asyncio

        from oneloop import AsyncOneloopApi

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_api_keys(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/v1/workspace/{jsonable_encoder(id)}/api-key",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    RetrieveApiKeysResponse,
                    parse_obj_as(
                        type_=RetrieveApiKeysResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def get_api_key_by_id(
        self,
        id: str,
        akid: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RetrieveApiKeyByIdResponse:
        """
        Parameters
        ----------
        id : str

        akid : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RetrieveApiKeyByIdResponse
            The API key

        Examples
        --------
        import asyncio

        from oneloop import AsyncOneloopApi

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.get_api_key_by_id(
                id="id",
                akid="akid",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/v1/workspace/{jsonable_encoder(id)}/api-key/{jsonable_encoder(akid)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    RetrieveApiKeyByIdResponse,
                    parse_obj_as(
                        type_=RetrieveApiKeyByIdResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def delete_api_key(
        self,
        id: str,
        akid: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DeleteApiKeyResponse:
        """
        Parameters
        ----------
        id : str

        akid : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeleteApiKeyResponse
            The updated deleted key

        Examples
        --------
        import asyncio

        from oneloop import AsyncOneloopApi

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.delete_api_key(
                id="id",
                akid="akid",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/v1/workspace/{jsonable_encoder(id)}/api-key/{jsonable_encoder(akid)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    DeleteApiKeyResponse,
                    parse_obj_as(
                        type_=DeleteApiKeyResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def edit_api_key(
        self,
        id: str,
        akid: str,
        *,
        name: typing.Optional[str] = OMIT,
        enabled: typing.Optional[bool] = OMIT,
        scopes: typing.Optional[typing.Sequence[ApiKeyScope]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> EditApiKeyResponse:
        """
        Parameters
        ----------
        id : str

        akid : str

        name : typing.Optional[str]

        enabled : typing.Optional[bool]

        scopes : typing.Optional[typing.Sequence[ApiKeyScope]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        EditApiKeyResponse
            The edited key

        Examples
        --------
        import asyncio

        from oneloop import AsyncOneloopApi

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.edit_api_key(
                id="id",
                akid="akid",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/v1/workspace/{jsonable_encoder(id)}/api-key/{jsonable_encoder(akid)}",
            method="PATCH",
            json={
                "name": name,
                "enabled": enabled,
                "scopes": scopes,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    EditApiKeyResponse,
                    parse_obj_as(
                        type_=EditApiKeyResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def verify_api_key(
        self,
        *,
        key: str,
        requested_scopes: typing.Sequence[ApiKeyScope],
        rate_limit_config: typing.Optional[VerifyApiKeyRequestRateLimitConfig] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> VerifyApiKeyResponse:
        """
        Parameters
        ----------
        key : str

        requested_scopes : typing.Sequence[ApiKeyScope]

        rate_limit_config : typing.Optional[VerifyApiKeyRequestRateLimitConfig]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        VerifyApiKeyResponse
            The verification result

        Examples
        --------
        import asyncio

        from oneloop import ApiKeyScope, AsyncOneloopApi

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.verify_api_key(
                key="key",
                requested_scopes=[
                    ApiKeyScope(
                        representation="representation",
                        create=True,
                        read=True,
                        update=True,
                        del_=True,
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v1/api-key/verify",
            method="POST",
            json={
                "key": key,
                "requestedScopes": requested_scopes,
                "rateLimitConfig": rate_limit_config,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    VerifyApiKeyResponse,
                    parse_obj_as(
                        type_=VerifyApiKeyResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def rotate_api_key(
        self,
        id: str,
        akid: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RotateApiKeyResponse:
        """
        Parameters
        ----------
        id : str

        akid : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RotateApiKeyResponse
            The newly rotated key

        Examples
        --------
        import asyncio

        from oneloop import AsyncOneloopApi

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.rotate_api_key(
                id="id",
                akid="akid",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/v1/workspace/{jsonable_encoder(id)}/api-key/{jsonable_encoder(akid)}/rotate",
            method="POST",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    RotateApiKeyResponse,
                    parse_obj_as(
                        type_=RotateApiKeyResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def refill_api_key(
        self,
        id: str,
        akid: str,
        *,
        amount: int,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RefillApiKeyResponse:
        """
        Parameters
        ----------
        id : str

        akid : str

        amount : int

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RefillApiKeyResponse
            The updated key

        Examples
        --------
        import asyncio

        from oneloop import AsyncOneloopApi

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.refill_api_key(
                id="id",
                akid="akid",
                amount=1,
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/v1/workspace/{jsonable_encoder(id)}/api-key/{jsonable_encoder(akid)}/refill",
            method="POST",
            json={
                "amount": amount,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    RefillApiKeyResponse,
                    parse_obj_as(
                        type_=RefillApiKeyResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def generate_link_token(
        self,
        *,
        customer_id: str,
        workspace_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> GenerateLinkTokenResponse:
        """
        Parameters
        ----------
        customer_id : str

        workspace_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GenerateLinkTokenResponse
            The generated link token

        Examples
        --------
        import asyncio

        from oneloop import AsyncOneloopApi

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.generate_link_token(
                customer_id="customerId",
                workspace_id="workspaceId",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/v1/link-token",
            method="POST",
            json={
                "customerId": customer_id,
                "workspaceId": workspace_id,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    GenerateLinkTokenResponse,
                    parse_obj_as(
                        type_=GenerateLinkTokenResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)

    async def validate_link_token(
        self, token: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ValidateLinkTokenResponse:
        """
        Parameters
        ----------
        token : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ValidateLinkTokenResponse
            The validation result

        Examples
        --------
        import asyncio

        from oneloop import AsyncOneloopApi

        client = AsyncOneloopApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.validate_link_token(
                token="token",
            )


        asyncio.run(main())
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/v1/link-token/{jsonable_encoder(token)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return typing.cast(
                    ValidateLinkTokenResponse,
                    parse_obj_as(
                        type_=ValidateLinkTokenResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
            if _response.status_code == 400:
                raise BadRequestError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            if _response.status_code == 403:
                raise ForbiddenError(
                    typing.cast(
                        ErrorResponse,
                        parse_obj_as(
                            type_=ErrorResponse,  # type: ignore
                            object_=_response.json(),
                        ),
                    )
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, body=_response.text)
        raise ApiError(status_code=_response.status_code, body=_response_json)


def _get_base_url(
    *, base_url: typing.Optional[str] = None, environment: OneloopApiEnvironment
) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception(
            "Please pass in either base_url or environment to construct the client"
        )
