# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['onfido', 'onfido.resources']

package_data = \
{'': ['*']}

install_requires = \
['requests>=2.24.0,<3.0.0']

setup_kwargs = {
    'name': 'onfido-python',
    'version': '0.3.7',
    'description': 'The official wrapper for the Onfido API',
    'long_description': '# Onfido Python Client Library\n\n:warning: **IN BETA**\n\n[onfido-python on PyPI](https://pypi.org/project/onfido-python/)\n\nVersion 0.3.7\n\nThe official wrapper for Onfido\'s API. Refer to the full [API documentation](https://documentation.onfido.com) for details of expected requests and responses.\n\nThis project supersedes the automatically generated [api-python-client](https://github.com/onfido/api-python-client) library (`onfido` in PyPI).\n\n## Installation\n\n`pip install onfido-python`\n\n:warning: Having the old `onfido` package installed at the same time will cause errors.\n\n## Usage\n\nMake API calls by using an instance of the `Api` class and providing your API\ntoken:\n\n```python\nimport onfido\n\napi = onfido.Api("<YOUR_API_TOKEN>")\n```\n\n### Regions\n\nSet the region in the API instance using the `base_url` parameter.\n\nThe library will use the default base URL (api.onfido.com) for the EU region, if\nno region is specified.\n\nTo specify the US region do:\n\n```python\nfrom onfido.regions import Region\n\napi = onfido.Api("<YOUR_API_TOKEN>", base_url=Region.US)\n```\n\nTo specify the CA region do:\n\n```python\nfrom onfido.regions import Region\n\napi = onfido.Api("<YOUR_API_TOKEN>", base_url=Region.CA)\n```\n\nSee https://documentation.onfido.com/#regions for supported regions.\n\n### Response format\n\nThe Python library will return data directly from the API.\n\nSee https://documentation.onfido.com/#request,-response-format for more\ninformation.\n\n### Resources\n\nAll resources share the same interface when making API calls. For example, use\n`.create` to create a resource, `.find` to find one, and `.all` to fetch all\nresources.\n\n#### Applicants\n\nApplicants are the object upon which Onfido checks are performed.\n\n```python\napi.applicant.create(params)  # => Creates an applicant\napi.applicant.update("<APPLICANT_ID>", params)  # => Updates an applicant\napi.applicant.delete("<APPLICANT_ID>")  # => Schedule an applicant for deletion\napi.applicant.restore("<APPLICANT_ID>") # => Restore an applicant scheduled for deletion\napi.applicant.find("<APPLICANT_ID>")  # => Finds a single applicant\napi.applicant.all()  # => Returns all applicants\n```\n\n`applicant.all()` takes the following optional arguments:\n\n`include_deleted=true`: include applicants scheduled for deletion.\n`per_page`: set the number of results per page. Defaults to 20.\n`page`: return specific pages. Defaults to 1.\n\n**Note:** Calling `api.applicant.delete` adds the applicant and all associated\ndocuments, photos, videos, checks, reports and analytics data to our deletion\nqueue. Please read https://documentation.onfido.com/#delete-applicant for more\ninformation.\n\n#### Documents\n\nSome report types require identity documents (passport, driving licence etc.) in order to be processed.\n\n```python\nrequest_body = {"applicant_id": "<APPLICANT_ID>", "document_type": "passport"}\nsample_file = open("<FILE_NAME>", "rb")\n\napi.document.upload(sample_file, request_body)   # => Uploads a document\napi.document.find("<DOCUMENT_ID>")      # => Finds a document\napi.document.download("<DOCUMENT_ID>")  # => Downloads a document as a binary data\napi.document.all("<APPLICANT_ID>")      # => Returns all documents belonging to an applicant\n```\n\nSee https://documentation.onfido.com/#document-types for example document types.\n\n#### Live Photos\n\nLive photos are images of the applicant’s face, typically taken at the same time as documents are provided. These photos are used to perform Facial Similarity Photo reports on the applicant.\n\n```python\nrequest_body = {"applicant_id": "<APPLICANT_ID>", "advanced_validation": "True"}\nsample_file = open("<FILE_NAME>", "rb")\n\napi.live_photo.upload(sample_file, request_body)   # => Uploads a live photo\napi.live_photo.find("<LIVE_PHOTO_ID>")      # => Finds a live photo\napi.live_photo.download("<LIVE_PHOTO_ID>")  # => Downloads a live photo as binary data\napi.live_photo.all("<APPLICANT_ID>")        # => Returns all live photos belonging to an applicant\n```\n\n#### Checks\n\nChecks are performed on an applicant. Depending on the type of check you wish to perform, different information will be required when you create an applicant. A check consists of one or more reports.\n\n```python\nrequest_body = {"applicant_id": "12345", "report_names": ["document", "facial_similarity_photo"]}\n\napi.check.create(request_body) # => Creates a check\napi.check.find("<CHECK_ID>")    # => Finds a check\napi.check.resume("<CHECK_ID>")  # => Resumes a paused check\napi.check.all("<APPLICANT_ID>") # => Returns all an applicant\'s checks\n```\n\n#### Reports\n\nReports provide details of the results of some part of a check. They are\ncreated when a check is created, so the Onfido API only provides support for\nfinding and listing them. For paused reports specifically, additional support for resuming and\n cancelling reports is also available.\n\n```python\napi.report.find("<REPORT_ID>")    # => Finds a report\napi.report.resume("<REPORT_ID>")  # => Resumes a paused report\napi.report.all("<CHECK_ID>")      # => Returns all the reports in a check\napi.report.cancel("<REPORT_ID>")  # => Cancels a paused report\n```\n\n#### Address Lookups\n\nOnfido provides an address lookup service, to help ensure well-formatted\naddresses are provided when creating applicants. To search for addresses\nby postcode, use:\n\n```python\napi.address.pick("SW46EH") # => Returns all addresses in a given postcode\n```\n\n#### Webhook Endpoints\n\nOnfido allows you to set up and view your webhook endpoints via the API, as well\nas through the Dashboard.\n\n```python\nrequest_body = {\n  "url": "https://<URL>",\n  "events": [\n    "report.completed",\n    "check.completed"\n  ]\n}\n\napi.webhook.create(request_body) # => Registers a webhook\napi.webhook.find("<WEBHOOK_ID>")  # => Finds a single webhook\napi.webhook.edit("<WEBHOOK_ID>", new_webhook_details) # => Edits a webhook\napi.webhook.delete("<WEBHOOK_ID>") # => Deletes a webhook\napi.webhook.all() # => Returns all webhooks\n```\n\n##### Webhook Verification\n\nA webhook event is valid if the signature from the header is equal to the\nexpected signature you compute for it.\n\n```python\nevent = verifier.read_payload(raw_event, signature)\n```\n\nSee https://documentation.onfido.com/#verifying-webhook-signatures for more information.\n\n#### SDK Tokens\n\nOnfido allows you to generate JSON Web Tokens via the API in order to authenticate\nwith Onfido\'s SDKs.\n\n```python\nrequest_body = {"applicant_id": "<APPLICANT_ID>", "application_id": "<APPLICATION_ID>"}\n\napi.sdk_token.create(request_body) # => Creates an SDK token\n```\n\n### Error Handling\n\n- `OnfidoServerError` is raised whenever Onfido returns a `5xx` response\n- `OnfidoRequestError` is raised whenever Onfido returns a `4xx` response\n- `OnfidoInvalidSignatureError` is raised whenever a signature from the header is not equal to the expected signature you compute for it\n- `OnfidoTimeoutError` is raised if a timeout occurs\n- `OnfidoConnectionError` is raised whenever any other network error occurs\n- `OnfidoUnknownError` is raised whenever something unexpected happens\n\n## Contributing\n\n1. Fork it ( https://github.com/onfido/onfido-python/fork )\n2. Create your feature branch (`git checkout -b my-new-feature`)\n3. Commit your changes (`git commit -am \'Add some feature\'`)\n4. Push to the branch (`git push origin my-new-feature`)\n5. Create a new Pull Request\n',
    'author': 'Ben Ahmady',
    'author_email': 'ben.ahmady@onfido.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/onfido/onfido-python',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6,<4',
}


setup(**setup_kwargs)
