# coding: utf-8

"""
    Onfido API v3.6

    The Onfido API (v3.6)

    The version of the OpenAPI document: v3.6
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from onfido.models.workflow_run_response_error import WorkflowRunResponseError
from typing import Optional, Set
from typing_extensions import Self

class WorkflowRunResponse(BaseModel):
    """
    WorkflowRunResponse
    """ # noqa: E501
    id: StrictStr = Field(description="The unique identifier for the Workflow Run.")
    workflow_version_id: Optional[StrictInt] = Field(default=None, description="The identifier for the Workflow version.")
    dashboard_url: Optional[StrictStr] = Field(default=None, description="The URL for viewing the Workflow Run results on your Onfido Dashboard.")
    status: Optional[StrictStr] = Field(default=None, description="The status of the Workflow Run.")
    output: Optional[Dict[str, Any]] = Field(default=None, description="Output object contains all of the properties configured on the Workflow version.")
    reasons: Optional[List[StrictStr]] = Field(default=None, description="The reasons the Workflow Run outcome was reached. Configurable when creating the Workflow version.")
    error: Optional[WorkflowRunResponseError] = None
    sdk_token: Optional[StrictStr] = Field(default=None, description="Client token to use when loading this workflow run in the Onfido SDK.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "workflow_version_id", "dashboard_url", "status", "output", "reasons", "error", "sdk_token"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['awaiting_input', 'processing', 'abandoned', 'error', 'approved', 'review', 'declined']):
            raise ValueError("must be one of enum values ('awaiting_input', 'processing', 'abandoned', 'error', 'approved', 'review', 'declined')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WorkflowRunResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of error
        if self.error:
            _dict['error'] = self.error.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if sdk_token (nullable) is None
        # and model_fields_set contains the field
        if self.sdk_token is None and "sdk_token" in self.model_fields_set:
            _dict['sdk_token'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WorkflowRunResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "workflow_version_id": obj.get("workflow_version_id"),
            "dashboard_url": obj.get("dashboard_url"),
            "status": obj.get("status"),
            "output": obj.get("output"),
            "reasons": obj.get("reasons"),
            "error": WorkflowRunResponseError.from_dict(obj["error"]) if obj.get("error") is not None else None,
            "sdk_token": obj.get("sdk_token")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


