# coding: utf-8

"""
    Onfido API v3.6

    The Onfido API (v3.6)

    The version of the OpenAPI document: v3.6
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class DeviceIntelligenceBreakdownPropertiesDevice(BaseModel):
    """
    DeviceIntelligenceBreakdownPropertiesDevice
    """ # noqa: E501
    sdk_version: Optional[StrictStr] = Field(default=None, description="The SDK version that was used.")
    sdk_source: Optional[StrictStr] = Field(default=None, description="The SDK used to upload the media.")
    authentication_type: Optional[StrictStr] = Field(default=None, description="The token used to authenticate the request.")
    raw_model: Optional[StrictStr] = Field(default=None, description="The model as set by the phone manufacturer (for Android and iOS) or the browser manufacturer (for Web). The model can be presented in name or number form depending on each manufacturer implementation.")
    os: Optional[StrictStr] = Field(default=None, description="The operating system of the device. The value came from manufacturer implementation (for Android and iOS) or browser's user agent (for Web).")
    browser: Optional[StrictStr] = Field(default=None, description="The browser name reported by the browser's user agent.")
    emulator: Optional[StrictBool] = Field(default=None, description="Whether the device is an emulator.")
    randomized_device: Optional[StrictBool] = Field(default=None, description="Whether the device is providing false randomized device and network information.")
    fake_network_request: Optional[StrictBool] = Field(default=None, description="Whether device is using stolen security tokens to send the network information.")
    ip_reputation: Optional[StrictStr] = Field(default=None, description="Whether there is highly suspicious traffic related to the IP address. The risk depends on the overall ratio of clear checks on a given IP.")
    device_fingerprint_reuse: Optional[StrictInt] = Field(default=None, description="The number of times the device was used to create a report for a new applicant. A value greater than 1 indicates potential device reuse.")
    single_device_used: Optional[StrictBool] = Field(default=None, description="Whether the document or biometric media were uploaded from a single device.")
    document_capture: Optional[StrictStr] = Field(default=None, description="Whether the document media were live captured from the device camera.")
    biometric_capture: Optional[StrictStr] = Field(default=None, description="Whether the biometric media were live captured from the device camera.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["sdk_version", "sdk_source", "authentication_type", "raw_model", "os", "browser", "emulator", "randomized_device", "fake_network_request", "ip_reputation", "device_fingerprint_reuse", "single_device_used", "document_capture", "biometric_capture"]

    @field_validator('sdk_source')
    def sdk_source_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['onfido-android-sdk', 'onfido-ios-sdk', 'onfido-web-sdk']):
            raise ValueError("must be one of enum values ('onfido-android-sdk', 'onfido-ios-sdk', 'onfido-web-sdk')")
        return value

    @field_validator('authentication_type')
    def authentication_type_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['sdk_token', 'mobile_token', 'api_token']):
            raise ValueError("must be one of enum values ('sdk_token', 'mobile_token', 'api_token')")
        return value

    @field_validator('ip_reputation')
    def ip_reputation_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['NOT_ENOUGH_DATA', 'HIGH_RISK', 'LOW_RISK']):
            raise ValueError("must be one of enum values ('NOT_ENOUGH_DATA', 'HIGH_RISK', 'LOW_RISK')")
        return value

    @field_validator('document_capture')
    def document_capture_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['live', 'unknown_method']):
            raise ValueError("must be one of enum values ('live', 'unknown_method')")
        return value

    @field_validator('biometric_capture')
    def biometric_capture_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['live', 'unknown_method']):
            raise ValueError("must be one of enum values ('live', 'unknown_method')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of DeviceIntelligenceBreakdownPropertiesDevice from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if single_device_used (nullable) is None
        # and model_fields_set contains the field
        if self.single_device_used is None and "single_device_used" in self.model_fields_set:
            _dict['single_device_used'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of DeviceIntelligenceBreakdownPropertiesDevice from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "sdk_version": obj.get("sdk_version"),
            "sdk_source": obj.get("sdk_source"),
            "authentication_type": obj.get("authentication_type"),
            "raw_model": obj.get("raw_model"),
            "os": obj.get("os"),
            "browser": obj.get("browser"),
            "emulator": obj.get("emulator"),
            "randomized_device": obj.get("randomized_device"),
            "fake_network_request": obj.get("fake_network_request"),
            "ip_reputation": obj.get("ip_reputation"),
            "device_fingerprint_reuse": obj.get("device_fingerprint_reuse"),
            "single_device_used": obj.get("single_device_used"),
            "document_capture": obj.get("document_capture"),
            "biometric_capture": obj.get("biometric_capture")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


