# coding: utf-8

"""
    Onfido API v3.6

    The Onfido API (v3.6)

    The version of the OpenAPI document: v3.6
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from onfido.models.facial_similarity_report_media import FacialSimilarityReportMedia
from typing import Optional, Set
from typing_extensions import Self

class FacialSimilarityReportShared(BaseModel):
    """
    FacialSimilarityReportShared
    """ # noqa: E501
    live_photos: Optional[List[FacialSimilarityReportMedia]] = Field(default=None, description="Array of objects with live photo ids that were used in the Onfido engine.")
    live_videos: Optional[List[FacialSimilarityReportMedia]] = Field(default=None, description="Array of objects with live video ids that were used in the Onfido engine.")
    motion_captures: Optional[List[FacialSimilarityReportMedia]] = Field(default=None, description="Array of objects with motion capture ids that were used in the Onfido engine.")
    id_photos: Optional[List[FacialSimilarityReportMedia]] = Field(default=None, description="Array of objects with id photo ids that were used in the Onfido engine.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["live_photos", "live_videos", "motion_captures", "id_photos"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of FacialSimilarityReportShared from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in live_photos (list)
        _items = []
        if self.live_photos:
            for _item_live_photos in self.live_photos:
                if _item_live_photos:
                    _items.append(_item_live_photos.to_dict())
            _dict['live_photos'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in live_videos (list)
        _items = []
        if self.live_videos:
            for _item_live_videos in self.live_videos:
                if _item_live_videos:
                    _items.append(_item_live_videos.to_dict())
            _dict['live_videos'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in motion_captures (list)
        _items = []
        if self.motion_captures:
            for _item_motion_captures in self.motion_captures:
                if _item_motion_captures:
                    _items.append(_item_motion_captures.to_dict())
            _dict['motion_captures'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in id_photos (list)
        _items = []
        if self.id_photos:
            for _item_id_photos in self.id_photos:
                if _item_id_photos:
                    _items.append(_item_id_photos.to_dict())
            _dict['id_photos'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of FacialSimilarityReportShared from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "live_photos": [FacialSimilarityReportMedia.from_dict(_item) for _item in obj["live_photos"]] if obj.get("live_photos") is not None else None,
            "live_videos": [FacialSimilarityReportMedia.from_dict(_item) for _item in obj["live_videos"]] if obj.get("live_videos") is not None else None,
            "motion_captures": [FacialSimilarityReportMedia.from_dict(_item) for _item in obj["motion_captures"]] if obj.get("motion_captures") is not None else None,
            "id_photos": [FacialSimilarityReportMedia.from_dict(_item) for _item in obj["id_photos"]] if obj.get("id_photos") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


