# coding: utf-8

"""
    Onfido API v3.6

    The Onfido API (v3.6)

    The version of the OpenAPI document: v3.6
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from onfido.models.report_configuration import ReportConfiguration
from onfido.models.report_name import ReportName
from onfido.models.us_driving_licence_builder import UsDrivingLicenceBuilder
from typing import Optional, Set
from typing_extensions import Self

class CheckBuilder(BaseModel):
    """
    CheckBuilder
    """ # noqa: E501
    webhook_ids: Optional[List[StrictStr]] = Field(default=None, description="An array of webhook ids describing which webhooks to trigger for this check.")
    applicant_id: StrictStr = Field(description="The ID of the applicant to do the check on.")
    applicant_provides_data: Optional[StrictBool] = Field(default=False, description="Send an applicant form to applicant to complete to proceed with check. Defaults to false.")
    tags: Optional[List[StrictStr]] = Field(default=None, description="Array of tags being assigned to this check.")
    redirect_uri: Optional[StrictStr] = Field(default=None, description="For checks where `applicant_provides_data` is `true`, redirect to this URI when the applicant has submitted their data.")
    privacy_notices_read_consent_given: Optional[StrictBool] = None
    report_names: List[ReportName] = Field(description="An array of report names (strings).")
    document_ids: Optional[List[StrictStr]] = Field(default=None, description="Optional. An array of document ids, for use with Document reports only. If omitted, the Document report will use the most recently uploaded document by default.")
    asynchronous: Optional[StrictBool] = Field(default=True, description="Defaults to `true`. If set to `false`, you will only receive a response when all reports in your check have completed. ")
    suppress_form_emails: Optional[StrictBool] = Field(default=None, description="For checks where `applicant_provides_data` is `true`, applicant form will not be automatically sent if `suppress_form_emails` is set to `true`. You can manually send the form at any time after the check has been created, using the link found in the form_uri attribute of the check object. Write-only. Defaults to false. ")
    sub_result: Optional[StrictStr] = Field(default=None, description="Triggers responses for particular sub-results for sandbox Document reports.")
    consider: Optional[List[ReportName]] = Field(default=None, description="Array of names of particular reports to return consider as their results. This is a feature available in sandbox testing")
    us_driving_licence: Optional[UsDrivingLicenceBuilder] = None
    report_configuration: Optional[ReportConfiguration] = None
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["webhook_ids", "applicant_id", "applicant_provides_data", "tags", "redirect_uri", "privacy_notices_read_consent_given", "report_names", "document_ids", "asynchronous", "suppress_form_emails", "sub_result", "consider", "us_driving_licence", "report_configuration"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CheckBuilder from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of us_driving_licence
        if self.us_driving_licence:
            _dict['us_driving_licence'] = self.us_driving_licence.to_dict()
        # override the default output from pydantic by calling `to_dict()` of report_configuration
        if self.report_configuration:
            _dict['report_configuration'] = self.report_configuration.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CheckBuilder from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "webhook_ids": obj.get("webhook_ids"),
            "applicant_id": obj.get("applicant_id"),
            "applicant_provides_data": obj.get("applicant_provides_data") if obj.get("applicant_provides_data") is not None else False,
            "tags": obj.get("tags"),
            "redirect_uri": obj.get("redirect_uri"),
            "privacy_notices_read_consent_given": obj.get("privacy_notices_read_consent_given"),
            "report_names": obj.get("report_names"),
            "document_ids": obj.get("document_ids"),
            "asynchronous": obj.get("asynchronous") if obj.get("asynchronous") is not None else True,
            "suppress_form_emails": obj.get("suppress_form_emails"),
            "sub_result": obj.get("sub_result"),
            "consider": obj.get("consider"),
            "us_driving_licence": UsDrivingLicenceBuilder.from_dict(obj["us_driving_licence"]) if obj.get("us_driving_licence") is not None else None,
            "report_configuration": ReportConfiguration.from_dict(obj["report_configuration"]) if obj.get("report_configuration") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


